import pytest

from h2o import H2O


@pytest.mark.parametrize(
    'region,param1,val1,param2,val2,expected',
    [(1, 'p', 3, 'T', 300,
      {'v': (0.100215168E-2, 1E-11),
       'u': (0.112324818E+3, 1E-6),
       'h': (0.115331273E+3, 1E-6),
       's': (0.392294792E+0, 1E-9),
       'cp': (0.417301218E+1, 1E-8),
       'w': (0.150773921E+4, 1E-5),
       }),
     (1, 'p', 80, 'T', 300,
      {'v': (0.971180894E-3, 1E-12),
       'u': (0.106448356E+3, 1E-6),
       'h': (0.184142828E+3, 1E-6),
       's': (0.368563852E+0, 1E-9),
       'cp': (0.401008987E+1, 1E-8),
       'w': (0.163469054E+4, 1E-5),
       }),
     (1, 'p', 3., 'T', 500,
      {'v': (0.120241800E-2, 1E-11),
       'u': (0.971934985E+3, 1E-6),
       'h': (0.975542239E+3, 1E-6),
       's': (0.258041912E+1, 1E-8),
       'cp': (0.465580682E+1, 1E-8),
       'w': (0.124071337E+4, 1E-5),
       }),
     (2, 'p', 35E-4, 'T', 300,
      {'v': (0.394913866E+2, 1E-7),
       'u': (0.241169160E+4, 1E-5),
       'h': (0.254991145E+4, 1E-5),
       's': (0.852238967E+1, 1E-8),
       'cp': (0.191300162E+1, 1E-8),
       'w': (0.427920172E+3, 1E-6),
       }),
     (2, 'p', 35E-4, 'T', 700,
      {'v': (0.923015898E+2, 1E-7),
       'u': (0.301262819E+4, 1E-5),
       'h': (0.333568375E+4, 1E-5),
       's': (0.101749996E+2, 1E-7),
       'cp': (0.208141274E+1, 1E-8),
       'w': (0.644289068E+3, 1E-6),
       }),
     (2, 'p', 30E+0, 'T', 700,
      {'v': (0.542946619E-2, 1E-11),
       'u': (0.246861076E+4, 1E-5),
       'h': (0.263149474E+4, 1E-5),
       's': (0.517540298E+1, 1E-8),
       'cp': (0.103505092E+2, 1E-7),
       'w': (0.480386523E+3, 1E-6),
       }),
     (3, 'rho', 500, 'T', 650,
      {'p': (0.255837018E2, 1E-7),
       'u': (0.181226279E4, 1E-5),
       'h': (0.186343019E4, 1E-5),
       's': (0.405427273E1, 1E-8),
       'cp': (0.138935717E2, 1E-7),
       'w': (0.502005554E3, 1E-6),
       }),
     (3, 'rho', 200, 'T', 650,
      {'p': (0.222930643E2, 1E-7),
       'u': (0.226365868E4, 1E-5),
       'h': (0.237512401E4, 1E-5),
       's': (0.485438792E1, 1E-8),
       'cp': (0.446579342E2, 1E-7),
       'w': (0.383444594E3, 1E-6),
       }),
     (3, 'rho', 500, 'T', 750,
      {'p': (0.783095639E2, 1E-7),
       'u': (0.210206932E4, 1E-5),
       'h': (0.225868845E4, 1E-5),
       's': (0.446971906E1, 1E-8),
       'cp': (0.634165359E1, 1E-8),
       'w': (0.760696041E3, 1E-6),
       }),
     (5, 'p', .5, 'T', 1500,
      {'v': (0.138455090E+1, 1E-8),
       'u': (0.452749310E+4, 1E-5),
       'h': (0.521976855E+4, 1E-5),
       's': (0.965408875E+1, 1E-8),
       'cp': (0.261609445E+1, 1E-8),
       'w': (0.917068690E+3, 1E-6),
       }),
     (5, 'p', 30, 'T', 1500,
      {'v': (0.230761299E-1, 1E-10),
       'u': (0.447495124E+4, 1E-5),
       'h': (0.516723514E+4, 1E-5),
       's': (0.772970133E+1, 1E-8),
       'cp': (0.272724317E+1, 1E-8),
       'w': (0.928548002E+3, 1E-6),
       }),
     (5, 'p', 30, 'T', 2000,
      {'v': (0.311385219E-1, 1E-10),
       'u': (0.563707038E+4, 1E-5),
       'h': (0.657122604E+4, 1E-5),
       's': (0.853640523E+1, 1E-8),
       'cp': (0.288569882E+1, 1E-8),
       'w': (0.106736948E+4, 1E-5),
       }),
     (4, 'T', 300, 'x', 1, {'p': (0.353658941E-2, 1E-11)}),
     (4, 'T', 500, 'x', 1, {'p': (0.263889776E+1, 1E-8)}),
     (4, 'T', 600, 'x', 1, {'p': (0.123443146E+2, 1E-7)}),
     (1, 'p', 3., 'h', 500., {'T': (0.391798509E+3, 1E-6)}),
     (1, 'p', 80, 'h', 500., {'T': (0.378108626E+3, 1E-6)}),
     (1, 'p', 80, 'h', 1500, {'T': (0.611041229E+3, 1E-6)}),
     (2, 'p', 1E-3, 'h', 3000, {'T': (0.534433241E3, 1E-6)}),
     (2, 'p', 3.00, 'h', 3000, {'T': (0.575373370E3, 1E-6)}),
     (2, 'p', 3.00, 'h', 4000, {'T': (0.101077577E4, 1E-5)}),
     (2, 'p', 5.00, 'h', 3500, {'T': (0.801299102E3, 1E-6)}),
     (2, 'p', 5.00, 'h', 4000, {'T': (0.101531583E4, 1E-5)}),
     (2, 'p', 25.0, 'h', 3500, {'T': (0.875279054E3, 1E-6)}),
     (2, 'p', 40.0, 'h', 2700, {'T': (0.743056411E3, 1E-6)}),
     (2, 'p', 60.0, 'h', 2700, {'T': (0.791137067E3, 1E-6)}),
     (2, 'p', 60.0, 'h', 3200, {'T': (0.882756860E3, 1E-6)}),
     (1, 'p', 3., 's', 0.5, {'T': (0.307842258E+3, 1E-6)}),
     (1, 'p', 80, 's', 0.5, {'T': (0.309979785E+3, 1E-6)}),
     (1, 'p', 80, 's', 3.0, {'T': (0.565899909E+3, 1E-6)}),
     (2, 'p', 0.1, 's', 7.50, {'T': (0.399517097E3, 1E-6)}),
     (2, 'p', 0.1, 's', 8.00, {'T': (0.514127081E3, 1E-6)}),
     (2, 'p', 2.5, 's', 8.00, {'T': (0.103984917E4, 1E-5)}),
     (2, 'p', 8.0, 's', 6.00, {'T': (0.600484040E3, 1E-6)}),
     (2, 'p', 8.0, 's', 7.50, {'T': (0.106495556E4, 1E-5)}),
     (2, 'p', 90., 's', 6.00, {'T': (0.103801126E4, 1E-5)}),
     (2, 'p', 20., 's', 5.75, {'T': (0.697992849E3, 1E-6)}),
     (2, 'p', 80., 's', 5.25, {'T': (0.854011484E3, 1E-6)}),
     (2, 'p', 80., 's', 5.75, {'T': (0.949017998E3, 1E-6)}),
     (1, 'h', 1E-3, 's', 0.0, {'p': (0.9800980612E-3, 1E-12)}),
     (1, 'h', 90E0, 's', 0.0, {'p': (0.9192954727E+2, 1E-7)}),
     (1, 'h', 15E2, 's', 3.4, {'p': (0.5868294423E+2, 1E-7)}),
     (2, 'h', 2800, 's', 6.5, {'p': (0.1371012767E+1, 1E-9)}),
     (2, 'h', 2800, 's', 9.5, {'p': (0.1879743844E-2, 1E-12)}),
     (2, 'h', 4100, 's', 9.5, {'p': (0.1024788997E+0, 1E-10)}),
     (2, 'h', 2800, 's', 6.0, {'p': (0.4793911442E+1, 1E-9)}),
     (2, 'h', 3600, 's', 6.0, {'p': (0.8395519209E+2, 1E-8)}),
     (2, 'h', 3600, 's', 7.0, {'p': (0.7527161441E+1, 1E-9)}),
     (2, 'h', 2800, 's', 5.1, {'p': (0.9439202060E+2, 1E-8)}),
     (2, 'h', 2800, 's', 5.8, {'p': (0.8414574124E+1, 1E-9)}),
     (2, 'h', 3400, 's', 5.8, {'p': (0.8376903879E+2, 1E-8)}),
     (3, 'p', 20., 'h', 1700,
      {'T': (0.6293083892E+3, 1E-7),
       'v': (0.1749903962E-2, 1E-12),
       }),
     (3, 'p', 50., 'h', 2000,
      {'T': (0.6905718338E+3, 1E-7),
       'v': (0.1908139035E-2, 1E-12),
       }),
     (3, 'p', 100, 'h', 2100,
      {'T': (0.7336163014E+3, 1E-7),
       'v': (0.1676229776E-2, 1E-12),
       }),
     (3, 'p', 20., 'h', 2500,
      {'T': (0.6418418053E+3, 1E-7),
       'v': (0.6670547043E-2, 1E-12),
       }),
     (3, 'p', 50., 'h', 2400,
      {'T': (0.7351848618E+3, 1E-7),
       'v': (0.2801244590E-2, 1E-12),
       }),
     (3, 'p', 100, 'h', 2700,
      {'T': (0.8420460876E+3, 1E-7),
       'v': (0.2404234998E-2, 1E-12),
       }),
     (3, 'p', 20., 's', 3.8,
      {'T': (0.6282959869E+3, 1E-7),
       'v': (0.1733791463E-2, 1E-12),
       }),
     (3, 'p', 50., 's', 3.6,
      {'T': (0.6297158726E+3, 1E-7),
       'v': (0.1469680170E-2, 1E-12),
       }),
     (3, 'p', 100, 's', 4.0,
      {'T': (0.7056880237E+3, 1E-7),
       'v': (0.1555893131E-2, 1E-12),
       }),
     (3, 'p', 20., 's', 5.0,
      {'T': (0.6401176443E+3, 1E-7),
       'v': (0.6262101987E-2, 1E-12),
       }),
     (3, 'p', 50., 's', 4.5,
      {'T': (0.7163687517E+3, 1E-7),
       'v': (0.2332634294E-2, 1E-12),
       }),
     (3, 'p', 100, 's', 5.0,
      {'T': (0.8474332825E+3, 1E-7),
       'v': (0.2449610757E-2, 1E-12),
       }),
     (3, 'h', 1700, 's', 3.8, {'p': (0.2555703246E+2, 1E-2)}),
     (3, 'h', 2000, 's', 4.2, {'p': (0.4540873468E+2, 5E-3)}),
     (3, 'h', 2100, 's', 4.3, {'p': (0.6078123340E+2, 5E-2)}),
     (3, 'h', 2600, 's', 5.1, {'p': (0.3434999263E+2, 1E-3)}),
     (3, 'h', 2400, 's', 4.7, {'p': (0.6363924887E+2, 5E-3)}),
     (3, 'h', 2700, 's', 5.0, {'p': (0.8839043281E+2, 1E-3)}),
     (3, 'p', 50.000, 'T', 630.00, {'v': (0.1470853100E-2, 1E-12)}),
     (3, 'p', 80.000, 'T', 670.00, {'v': (0.1503831359E-2, 1E-12)}),
     (3, 'p', 50.000, 'T', 710.00, {'v': (0.2204728587E-2, 1E-12)}),
     (3, 'p', 80.000, 'T', 750.00, {'v': (0.1973692940E-2, 1E-12)}),
     (3, 'p', 20.000, 'T', 630.00, {'v': (0.1761696406E-2, 1E-12)}),
     (3, 'p', 30.000, 'T', 650.00, {'v': (0.1819560617E-2, 1E-12)}),
     (3, 'p', 26.000, 'T', 656.00, {'v': (0.2245587720E-2, 1E-12)}),
     (3, 'p', 30.000, 'T', 670.00, {'v': (0.2506897702E-2, 1E-12)}),
     (3, 'p', 26.000, 'T', 661.00, {'v': (0.2970225962E-2, 1E-12)}),
     (3, 'p', 30.000, 'T', 675.00, {'v': (0.3004627086E-2, 1E-12)}),
     (3, 'p', 26.000, 'T', 671.00, {'v': (0.5019029401E-2, 1E-12)}),
     (3, 'p', 30.000, 'T', 690.00, {'v': (0.4656470142E-2, 1E-12)}),
     (3, 'p', 23.600, 'T', 649.00, {'v': (0.2163198378E-2, 1E-12)}),
     (3, 'p', 24.000, 'T', 650.00, {'v': (0.2166044161E-2, 1E-12)}),
     (3, 'p', 23.600, 'T', 652.00, {'v': (0.2651081407E-2, 1E-12)}),
     (3, 'p', 24.000, 'T', 654.00, {'v': (0.2967802335E-2, 1E-12)}),
     (3, 'p', 23.600, 'T', 653.00, {'v': (0.3273916816E-2, 1E-12)}),
     (3, 'p', 24.000, 'T', 655.00, {'v': (0.3550329864E-2, 1E-12)}),
     (3, 'p', 23.500, 'T', 655.00, {'v': (0.4545001142E-2, 1E-12)}),
     (3, 'p', 24.000, 'T', 660.00, {'v': (0.5100267704E-2, 1E-12)}),
     (3, 'p', 23.000, 'T', 660.00, {'v': (0.6109525997E-2, 1E-12)}),
     (3, 'p', 24.000, 'T', 670.00, {'v': (0.6427325645E-2, 1E-12)}),
     (3, 'p', 22.600, 'T', 646.00, {'v': (0.2117860851E-2, 1E-12)}),
     (3, 'p', 23.000, 'T', 646.00, {'v': (0.2062374674E-2, 1E-12)}),
     (3, 'p', 22.600, 'T', 648.60, {'v': (0.2533063780E-2, 1E-12)}),
     (3, 'p', 22.800, 'T', 649.30, {'v': (0.2572971781E-2, 1E-12)}),
     (3, 'p', 22.600, 'T', 649.00, {'v': (0.2923432711E-2, 1E-12)}),
     (3, 'p', 22.800, 'T', 649.70, {'v': (0.2913311494E-2, 1E-12)}),
     (3, 'p', 22.600, 'T', 649.10, {'v': (0.3131208996E-2, 1E-12)}),
     (3, 'p', 22.800, 'T', 649.90, {'v': (0.3221160278E-2, 1E-12)}),
     (3, 'p', 22.600, 'T', 649.40, {'v': (0.3715596186E-2, 1E-12)}),
     (3, 'p', 22.800, 'T', 650.20, {'v': (0.3664754790E-2, 1E-12)}),
     (3, 'p', 21.100, 'T', 640.00, {'v': (0.1970999272E-2, 1E-12)}),
     (3, 'p', 21.800, 'T', 643.00, {'v': (0.2043919161E-2, 1E-12)}),
     (3, 'p', 21.100, 'T', 644.00, {'v': (0.5251009921E-2, 1E-12)}),
     (3, 'p', 21.800, 'T', 648.00, {'v': (0.5256844741E-2, 1E-12)}),
     (3, 'p', 19.100, 'T', 635.00, {'v': (0.1932829079E-2, 1E-12)}),
     (3, 'p', 20.000, 'T', 638.00, {'v': (0.1985387227E-2, 1E-12)}),
     (3, 'p', 17.000, 'T', 626.00, {'v': (0.8483262001E-2, 1E-12)}),
     (3, 'p', 20.000, 'T', 640.00, {'v': (0.6227528101E-2, 1E-12)}),
     (3, 'p', 21.500, 'T', 644.60, {'v': (0.2268366647E-2, 1E-12)}),
     (3, 'p', 22.000, 'T', 646.10, {'v': (0.2296350553E-2, 1E-12)}),
     (3, 'p', 22.500, 'T', 648.60, {'v': (0.2832373260E-2, 1E-12)}),
     (3, 'p', 22.300, 'T', 647.90, {'v': (0.2811424405E-2, 1E-12)}),
     (3, 'p', 22.150, 'T', 647.50, {'v': (0.3694032281E-2, 1E-12)}),
     (3, 'p', 22.300, 'T', 648.10, {'v': (0.3622226305E-2, 1E-12)}),
     (3, 'p', 22.110, 'T', 648.00, {'v': (0.4528072649E-2, 1E-12)}),
     (3, 'p', 22.300, 'T', 649.00, {'v': (0.4556905799E-2, 1E-12)}),
     (3, 'p', 22.000, 'T', 646.84, {'v': (0.2698354719E-2, 1E-12)}),
     (3, 'p', 22.064, 'T', 647.05, {'v': (0.2717655648E-2, 1E-12)}),
     (3, 'p', 22.000, 'T', 646.89, {'v': (0.3798732962E-2, 1E-12)}),
     (3, 'p', 22.064, 'T', 647.15, {'v': (0.3701940010E-2, 1E-12)}),
     ])
def test_property(region, param1, val1, param2, val2, expected):
    kwargs = {param1: val1, param2: val2}
    obj = H2O(**kwargs)
    assert obj.region == region
    for k, v in expected.items():
        assert getattr(obj, k) == pytest.approx(v[0], abs=v[1])


@pytest.mark.parametrize(
    'pin,pout,s,T',
    [(2.5, 0.1, (8.00, 1E-5), (0.514127081E3, 1E-2)),
     (8.0, 0.1, (7.50, 1E-4), (0.399517097E3, 1E-3)),
     (80., 20., (5.75, 1E-2), (0.697992849E3, 1E-3)),
     ])
def test_expand(pin, pout, s, T):
    obj = H2O(p=pin, s=s[0])
    exp = obj.expand(pout)
    assert exp.s == pytest.approx(s[0], abs=s[1])
    assert exp.T == pytest.approx(T[0], abs=T[1])
