/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc.cross.sparc_sun_solaris2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CaptureStreamHandler;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public class GccProcessor {
    private static String machine;
    private static String[] specs;
    private static String version;

    private static int addLibraryPatterns(String[] libnames, StringBuffer buf, String prefix, String extension, String[] patterns, int offset) {
        int i = 0;
        while (i < libnames.length) {
            buf.setLength(0);
            buf.append(prefix);
            buf.append(libnames[i]);
            buf.append(extension);
            patterns[offset + i] = buf.toString();
            ++i;
        }
        return offset + libnames.length;
    }

    public static void convertCygwinFilenames(String[] names) {
        if (names == null) {
            throw new NullPointerException("names");
        }
        File gccDir = CUtil.getExecutableLocation("sparc-sun-solaris2-gcc.exe");
        if (gccDir != null) {
            String prefix = String.valueOf(gccDir.getAbsolutePath()) + "/..";
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < names.length) {
                String name = names[i];
                if (name != null && name.length() > 1 && name.charAt(0) == '/') {
                    buf.setLength(0);
                    buf.append(prefix);
                    buf.append(name);
                    names[i] = buf.toString();
                }
                ++i;
            }
        }
    }

    public static String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length * 2];
        int offset = GccProcessor.addLibraryPatterns(libnames, buf, "lib", ".a", patterns, 0);
        offset = GccProcessor.isHPUX() ? GccProcessor.addLibraryPatterns(libnames, buf, "lib", ".sl", patterns, offset) : GccProcessor.addLibraryPatterns(libnames, buf, "lib", ".so", patterns, offset);
        return patterns;
    }

    public static String getMachine() {
        if (machine == null) {
            String[] args = new String[]{"sparc-sun-solaris2-gcc", "-dumpmachine"};
            String[] cmdout = CaptureStreamHandler.run(args);
            machine = cmdout.length == 0 ? "nomachine" : cmdout[0];
        }
        return machine;
    }

    public static String[] getOutputFileSwitch(String letter, String outputFile) {
        StringBuffer buf = new StringBuffer();
        if (outputFile.indexOf(32) >= 0) {
            buf.append('\"');
            buf.append(outputFile.replace('\\', '/'));
            buf.append('\"');
        } else {
            buf.append(outputFile.replace('\\', '/'));
        }
        String[] retval = new String[]{letter, buf.toString()};
        return retval;
    }

    public static String[] getSpecs() {
        File gccParent;
        if (specs == null && (gccParent = CUtil.getExecutableLocation("sparc-sun-solaris2-gcc.exe")) != null) {
            StringBuffer buf = new StringBuffer("../lib/gcc-lib/");
            buf.append(GccProcessor.getMachine());
            buf.append('/');
            buf.append(GccProcessor.getVersion());
            buf.append("/specs");
            String relativePath = buf.toString();
            File specsFile = new File(gccParent, relativePath);
            try {
                BufferedReader reader = new BufferedReader(new FileReader(specsFile));
                Vector<String> lines = new Vector<String>(100);
                String line = reader.readLine();
                while (line != null) {
                    lines.addElement(line);
                    line = reader.readLine();
                }
                specs = new String[lines.size()];
                lines.copyInto(specs);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (specs == null) {
            specs = new String[0];
        }
        return specs;
    }

    public static String getVersion() {
        if (version == null) {
            String[] args = new String[]{"sparc-sun-solaris2-gcc", "-dumpversion"};
            String[] cmdout = CaptureStreamHandler.run(args);
            version = cmdout.length == 0 ? "noversion" : cmdout[0];
        }
        return version;
    }

    public static boolean isCaseSensitive() {
        return true;
    }

    public static boolean isCygwin() {
        return GccProcessor.getMachine().indexOf("cygwin") > 0;
    }

    private static boolean isHPUX() {
        String osname = System.getProperty("os.name").toLowerCase();
        return osname.indexOf("hp") >= 0 && osname.indexOf("ux") >= 0;
    }

    public static String[][] parseSpecs(String[] specsContent, String specSectionStart, String[] options) {
        if (specsContent == null) {
            throw new NullPointerException("specsContent");
        }
        if (specSectionStart == null) {
            throw new NullPointerException("specSectionStart");
        }
        if (options == null) {
            throw new NullPointerException("option");
        }
        String[][] optionValues = new String[options.length][];
        StringBuffer optionValue = new StringBuffer(40);
        int i = 0;
        while (i < specsContent.length) {
            String specLine = specsContent[i];
            if (specLine.startsWith(specSectionStart)) {
                Vector[] optionVectors = new Vector[options.length];
                int j = 0;
                while (j < options.length) {
                    optionVectors[j] = new Vector(10);
                    ++j;
                }
                ++i;
                while (i < specsContent.length) {
                    specLine = specsContent[i];
                    j = 0;
                    while (j < options.length) {
                        int optionStart = specLine.indexOf(options[j]);
                        while (optionStart >= 0) {
                            optionValue.setLength(0);
                            boolean hasNonBlank = false;
                            int k = optionStart + options[j].length();
                            while (k < specLine.length()) {
                                if (specLine.charAt(k) == ' ' || specLine.charAt(k) == '}') {
                                    if (hasNonBlank) {
                                        break;
                                    }
                                } else {
                                    hasNonBlank = true;
                                    optionValue.append(specLine.charAt(k));
                                }
                                ++k;
                            }
                            if (hasNonBlank) {
                                optionVectors[j].addElement(optionValue.toString());
                            }
                            optionStart = specLine.indexOf(options[j], k);
                        }
                        ++j;
                    }
                    ++i;
                }
                j = 0;
                while (j < options.length) {
                    optionValues[j] = new String[optionVectors[j].size()];
                    optionVectors[j].copyInto(optionValues[j]);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < optionValues.length) {
            String[] zeroLenArray = new String[]{};
            if (optionValues[i] == null) {
                optionValues[i] = zeroLenArray;
            }
            ++i;
        }
        return optionValues;
    }

    private GccProcessor() {
    }
}

