/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;

public sealed interface MessageChunk {
    @NotNull
    public String toRawString();

    @Nullable
    default public DBRRunnableWithReturn<?> getCallback() {
        return null;
    }

    public record Code(@NotNull String text, @NotNull String language) implements MessageChunk
    {
        @Override
        @NotNull
        public String toRawString() {
            return "```" + this.language + "\n" + this.text + "\n```";
        }
    }

    public record Link(@NotNull String text, @NotNull DBRRunnableWithReturn<?> callback) implements MessageChunk
    {
        @Override
        @Nullable
        public DBRRunnableWithReturn<?> getCallback() {
            return this.callback;
        }

        @Override
        @NotNull
        public String toRawString() {
            return this.text;
        }
    }

    public record Text(@NotNull String text) implements MessageChunk
    {
        @Override
        @NotNull
        public String toRawString() {
            return this.text;
        }
    }
}

