#!/bin/sh
#
# chkconfig: 2345 98 99
# description: portmon network service monitor
# processname: portmon

# Source function library.
. /etc/rc.d/init.d/functions

PREFIX=/
RETVAL=0

# See how we were called.
case "$1" in
  start)
        echo -n "Starting up portmon..."
	# You might have to edit this next line to your liking...
        daemon $(PREFIX)/bin/portmon -d -c $(PREFIX)/etc/portmon.hosts
        touch /var/lock/subsys/portmon
        echo
        ;;
  stop)
        echo -n "Shutting down portmon"
        killproc portmon
        RETVAL=$?
        [ $RETVAL -eq 0 ] && rm -f /var/lock/subsys/portmon
        echo
        ;;
  status)
        status portmon
        RETVAL=$?
        ;;
  restart|reload)
        $0 stop
        $0 start
        RETVAL=$?
        ;;
        
  *)
        echo "Usage: portmon {start|stop|status|restart|reload}"
        exit 1
esac

exit $RETVAL

