/*------------------------------------------------------------------------
 * scsierr.h
 * 
 * Defines structures for displaying scsi error messages.
 *
 *------------------------------------------------------------------------*/
/*------------------------------------------------------------------------
Copyright (c) 2002, Intel Corporation
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

  a.. Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer. 
  b.. Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution. 
  c.. Neither the name of Intel Corporation nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *------------------------------------------------------------------------*/
#define SG_ERR_DRIVER_MASK      0x0f
#define SG_ERR_SUGGEST_MASK     0xf0   

static const char unknown[] = "UNKNOWN";

/* scsi command masked statuses */
static const char * statuses[] = {
/* 0-4 */ "Good", "Check Condition", "Condition Met", unknown, "Busy",
/* 5-9 */ unknown, unknown, unknown, "Intermediate", unknown,
/* a-c */ "Intermediate-Condition Met", unknown, "Reservation Conflict",
/* d-10 */ unknown, unknown, unknown, unknown,
/* 11-14 */ "Command Terminated", unknown, unknown, "Queue Full",
/* 15-1a */ unknown, unknown, unknown,  unknown, unknown, unknown,
/* 1b-1f */ unknown, unknown, unknown,  unknown, unknown,
};

/* Linux scsi host and scsi driver statuses */
static const char * driverbyte_table[]={
"DRIVER_OK", "DRIVER_BUSY", "DRIVER_SOFT",  "DRIVER_MEDIA", "DRIVER_ERROR",
"DRIVER_INVALID", "DRIVER_TIMEOUT", "DRIVER_HARD", "DRIVER_SENSE", NULL};

static const char * driversuggest_table[]={"SUGGEST_OK",
"SUGGEST_RETRY", "SUGGEST_ABORT", "SUGGEST_REMAP", "SUGGEST_DIE",
unknown,unknown,unknown, "SUGGEST_SENSE", NULL};

static const char * hostbyte_table[]={
"DID_OK", "DID_NO_CONNECT", "DID_BUS_BUSY", "DID_TIME_OUT", "DID_BAD_TARGET",
"DID_ABORT", "DID_PARITY", "DID_ERROR", "DID_RESET", "DID_BAD_INTR",
"DID_PASSTHROUGH", "DID_SOFT_ERROR", NULL};

/* 
 * Define the sense key and additional sense code meaning strings.
 */
/* meaning of devices characters */
 unsigned short D = 0x0001;  /* DIRECT ACCESS DEVICE (disk) */
 unsigned short T = 0x0002;  /* SEQUENTIAL ACCESS DEVICE (tape) */
 unsigned short L = 0x0004;  /* PRINTER DEVICE */
 unsigned short P = 0x0008;  /* PROCESSOR DEVICE */
 unsigned short W = 0x0010;  /* WRITE ONCE READ MULTIPLE DEVICE */
 unsigned short R = 0x0020;  /* READ ONLY (CD-ROM) DEVICE */
 unsigned short O = 0x0040;  /* OPTICAL MEMORY DEVICE */
 unsigned short M = 0x0080;  /* MEDIA CHANGER DEVICE */
 unsigned short A = 0x0100;  /* STORAGE ARRAY DEVICE */
 unsigned short E = 0x0200;  /* ENCLOSURE SERVICES DEVICE */
 unsigned short B = 0x0400;  /* SIMPLIFIED DIRECT-ACCESS DEVICE */
 unsigned short K = 0x0800;  /* OPTICAL CARD READER/WRITER DEVICE */
 unsigned short V = 0x1000;  /* AUTOMATION/DRIVE INTERFACE */
 unsigned short F = 0x2000;  /* OBJECT-BASED STORAGE */
 /* These two are obsolete now */
 unsigned short S = 0x4000;  /* SCANNER DEVICE */
 unsigned short C = 0x8000;  /* COMMUNICATION DEVICE */

struct asc_info{
    unsigned char code1, code2;
    const char * devices;
    const char * text;
};
struct asc_info2{
    unsigned char code1, code2_min, code2_max;
    const char * devices;
    const char * text;
};

/* Sense Key text for values 0 - 15 (00 - 0F) */
static const char *snstext[] = {
    "None",                     /* There is no sense information */
    "Recovered Error",          /* The last command completed successfully */
                                /* but used error correction */
    "Not Ready",                /* The addressed target is not ready */
    "Medium Error",             /* Data error detected on the medium */
    "Hardware Error",           /* Controller or device failure */
    "Illegal Request",          /* A SCSI command request was malformed or 
				   is not supported by the target */
    "Unit Attention",           /* Removable medium was changed, or
                                   the target has been reset */
    "Data Protect",             /* Access to the data is blocked */
    "Blank Check",              /* Reached unexpected written or unwritten
                                   region of the medium */
    "Key=9",                    /* Vendor specific */
    "Copy Aborted",             /* COPY or COMPARE was aborted */
    "Aborted Command",          /* The target aborted the command */
    "Equal",                    /* A SEARCH DATA command found data equal */
    "Volume Overflow",          /* Medium full with still data to be written */
    "Miscompare",               /* Source data and data on the medium
                                   do not agree */
    "Key=15"                    /* Reserved */
};

/* Group some addtl sense codes together */
static struct asc_info2 additional2[] =
{
  {0x40,0x00,0x7f,"D","Ram failure (%x)"},
  {0x40,0x80,0xff,"D|T|L|P|W|R|S|O|M|C","Diagnostic failure on component (%x)"},
  {0x41,0x00,0xff,"D","Data path failure (%x)"},
  {0x42,0x00,0xff,"D","Power-on or self-test failure (%x)"},
  {0, 0, 0, 0, NULL}
};

/* The addtl sense code text is defined in the SCSI-3 spec, Table 66. */
/* Later SCSI-3 drafts show this in Table B.1 */
/* For current ASC,ASCQ table data, see http://www.t10.org/lists/asc-num.txt */
static struct asc_info additional[] = {
  {0x00,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","No additional sense information"},
  {0x00,0x01,"  T             ","FILEMARK DETECTED"},
  {0x00,0x02,"  T             ","END-OF-PARTITION/MEDIUM DETECTED"},
  {0x00,0x03,"  T             ","SETMARK DETECTED"},
  {0x00,0x04,"  T             ","BEGINNING-OF-PARTITION/MEDIUM DETECTED"},
  {0x00,0x05,"  T|L            ","END-OF-DATA DETECTED"},
  {0x00,0x06," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","I/O PROCESS TERMINATED"},
  {0x00,0x07,"  T             ","PROGRAMMABLE EARLY WARNING DETECTED"},
  {0x00,0x11,"      R         ","AUDIO PLAY OPERATION IN PROGRESS"},
  {0x00,0x12,"      R         ","AUDIO PLAY OPERATION PAUSED"},
  {0x00,0x13,"      R         ","AUDIO PLAY OPERATION SUCCESSFULLY COMPLETED"},
  {0x00,0x14,"      R         ","AUDIO PLAY OPERATION STOPPED DUE TO ERROR"},
  {0x00,0x15,"      R         ","NO CURRENT AUDIO STATUS TO RETURN"},
  {0x00,0x16," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","OPERATION IN PROGRESS"},
  {0x00,0x17," D|T|L|W|R|O|M|A|E|B|K|V|F ","CLEANING REQUESTED"},
  {0x00,0x18,"  T             ","ERASE OPERATION IN PROGRESS"},
  {0x00,0x19,"  T             ","LOCATE OPERATION IN PROGRESS"},
  {0x00,0x1A,"  T             ","REWIND OPERATION IN PROGRESS"},
  {0x00,0x1B,"  T             ","SET CAPACITY OPERATION IN PROGRESS"},
  {0x00,0x1C,"  T             ","VERIFY OPERATION IN PROGRESS"},
  {0x00,0x1D," D|T|        B    ","ATA PASS THROUGH INFORMATION AVAILABLE"},
  {0x00,0x1E," D|T|   R| M|A|E|B|K|V  ","CONFLICTING SA CREATION REQUEST"},
  {0x00,0x1F," D|T       | B    ","LOGICAL UNIT TRANSITIONING TO ANOTHER POWER CONDITION"},
  {0x01,0x00," D|   W| O|   B|K   ","NO INDEX/SECTOR SIGNAL"},
  {0x02,0x00," D|   W|R|O|   B|K   ","NO SEEK COMPLETE"},
  {0x03,0x00," D|T|L| W| O|   B|K   ","PERIPHERAL DEVICE WRITE FAULT"},
  {0x03,0x01,"  T             ","NO WRITE CURRENT"},
  {0x03,0x02,"  T             ","EXCESSIVE WRITE ERRORS"},
  {0x04,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT READY, CAUSE NOT REPORTABLE"},
  {0x04,0x01," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT IS IN PROCESS OF BECOMING READY"},
  {0x04,0x02," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT READY, INITIALIZING COMMAND REQUIRED"},
  {0x04,0x03," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT READY, MANUAL INTERVENTION REQUIRED"},
  {0x04,0x04," D|T|L | R|O  |B    ","LOGICAL UNIT NOT READY, FORMAT IN PROGRESS"},
  {0x04,0x05," D|T|W| O| A|B|K| F ","LOGICAL UNIT NOT READY, REBUILD IN PROGRESS"},
  {0x04,0x06," D|T|W| O| A|B|K   ","LOGICAL UNIT NOT READY, RECALCULATION IN PROGRESS"},
  {0x04,0x07," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT READY, OPERATION IN PROGRESS"},
  {0x04,0x08,"      R         ","LOGICAL UNIT NOT READY, LONG WRITE IN PROGRESS"},
  {0x04,0x09," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT READY, SELF-TEST IN PROGRESS"},
  {0x04,0x0A," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT ACCESSIBLE, ASYMMETRIC ACCESS STATE TRANSITION"},
  {0x04,0x0B," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT ACCESSIBLE, TARGET PORT IN STANDBY STATE"},
  {0x04,0x0C," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT ACCESSIBLE, TARGET PORT IN UNAVAILABLE STATE"},
  {0x04,0x0D,"              F ","LOGICAL UNIT NOT READY, STRUCTURE CHECK REQUIRED"},
  {0x04,0x10,"D|T|W|R|O|M| B    ","LOGICAL UNIT NOT READY, AUXILIARY MEMORY NOT ACCESSIBLE"},
  {0x04,0x11,"D|T|W|R|O| A|E|B |V|F ","LOGICAL UNIT NOT READY, NOTIFY (ENABLE SPINUP) REQUIRED"},
  {0x04,0x12,"        M  |  V  ","LOGICAL UNIT NOT READY, OFFLINE"},
  {0x04,0x13,"D|T | R| M|A|E|B|K|V  ","LOGICAL UNIT NOT READY, SA CREATION IN PROGRESS"},
  {0x04,0x14," D|B    ","LOGICAL UNIT NOT READY, SPACE ALLOCATION IN PROGRESS"},
  {0x04,0x15,"        M       ","LOGICAL UNIT NOT READY, ROBOTICS DISABLED"},
  {0x04,0x16,"        M       ","LOGICAL UNIT NOT READY, CONFIGURATION REQUIRED"},
  {0x04,0x17,"        M       ","LOGICAL UNIT NOT READY, CALIBRATION REQUIRED"},
  {0x04,0x18,"        M       ","LOGICAL UNIT NOT READY, A DOOR IS OPEN"},
  {0x04,0x19,"        M       ","LOGICAL UNIT NOT READY, OPERATING IN SEQUENTIAL MODE"},
  {0x04,0x1A,"D|T    |   B    ","LOGICAL UNIT NOT READY, START STOP UNIT COMMAND IN PROGRESS"},
  {0x04,0x1B," D|B    ","LOGICAL UNIT NOT READY, SANITIZE IN PROGRESS"},
  {0x04,0x1C,"D|T    |M|A|E|B    ","LOGICAL UNIT NOT READY, ADDITIONAL POWER USE NOT YET GRANTED"},
  {0x05,0x00," D|T|L|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT DOES NOT RESPOND TO SELECTION"},
  {0x06,0x00," D  |W|R|O|M |B|K   ","NO REFERENCE POSITION FOUND"},
  {0x07,0x00," D|T|L|W|R|O|M |B|K   ","MULTIPLE PERIPHERAL DEVICES SELECTED"},
  {0x08,0x00," D|T|L|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT COMMUNICATION FAILURE"},
  {0x08,0x01," D|T|L|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT COMMUNICATION TIME-OUT"},
  {0x08,0x02," D|T|L|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT COMMUNICATION PARITY ERROR"},
  {0x08,0x03,"D|T |R|O|M |B|K   ","LOGICAL UNIT COMMUNICATION CRC ERROR (ULTRA-DMA/32)"},
  {0x08,0x04," D|T|L|P|W|R|O |   K   ","UNREACHABLE COPY TARGET"},
  {0x09,0x00,"D|T|W|R|O|   B    ","TRACK FOLLOWING ERROR"},
  {0x09,0x01,"    W|R|O|   K   ","TRACKING SERVO FAILURE"},
  {0x09,0x02,"    W|R|O|   K   ","FOCUS SERVO FAILURE"},
  {0x09,0x03,"    W|R|O        ","SPINDLE SERVO FAILURE"},
  {0x09,0x04,"D|T|W|R|O|   B    ","HEAD SELECT FAULT"},
  {0x0A,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ERROR LOG OVERFLOW"},
  {0x0B,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","WARNING"},
  {0x0B,0x01," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","WARNING - SPECIFIED TEMPERATURE EXCEEDED"},
  {0x0B,0x02," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","WARNING - ENCLOSURE DEGRADED"},
  {0x0B,0x03," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","WARNING - BACKGROUND SELF-TEST FAILED"},
  {0x0B,0x04," D|T|L|P|W|R|O|A|E|B|K|V|F ","WARNING - BACKGROUND PRE-SCAN DETECTED MEDIUM ERROR"},
  {0x0B,0x05," D|T|L|P|W|R|O|A|E|B|K|V|F ","WARNING - BACKGROUND MEDIUM SCAN DETECTED MEDIUM ERROR"},
  {0x0B,0x06," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","WARNING - NON-VOLATILE CACHE NOW VOLATILE"},
  {0x0B,0x07," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","WARNING - DEGRADED POWER TO NON-VOLATILE CACHE"},
  {0x0B,0x08," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","WARNING - POWER LOSS EXPECTED"},
  {0x0C,0x00,"  T | R         ","WRITE ERROR"},
  {0x0C,0x01,"            K   ","WRITE ERROR - RECOVERED WITH AUTO REALLOCATION"},
  {0x0C,0x02," D|W|O  |B|K   ","WRITE ERROR - AUTO REALLOCATION FAILED"},
  {0x0C,0x03," D|W|O  |B|K   ","WRITE ERROR - RECOMMEND REASSIGNMENT"},
  {0x0C,0x04,"D|T|W|O | B    ","COMPRESSION CHECK MISCOMPARE ERROR"},
  {0x0C,0x05,"D|T|W|O | B    ","DATA EXPANSION OCCURRED DURING COMPRESSION"},
  {0x0C,0x06,"D|T|W|O | B    ","BLOCK NOT COMPRESSIBLE"},
  {0x0C,0x07,"      R         ","WRITE ERROR - RECOVERY NEEDED"},
  {0x0C,0x08,"      R         ","WRITE ERROR - RECOVERY FAILED"},
  {0x0C,0x09,"      R         ","WRITE ERROR - LOSS OF STREAMING"},
  {0x0C,0x0A,"      R         ","WRITE ERROR - PADDING BLOCKS ADDED"},
  {0x0C,0x0B,"D|T|W|R|O|M  B    ","AUXILIARY MEMORY WRITE ERROR"},
  {0x0C,0x0C," D|T|L|P|W|R|O|A|E|B|K|V|F ","WRITE ERROR - UNEXPECTED UNSOLICITED DATA"},
  {0x0C,0x0D," D|T|L|P|W|R|O|A|E|B|K|V|F ","WRITE ERROR - NOT ENOUGH UNSOLICITED DATA"},
  {0x0C,0x0F,"      R         ","DEFECTS IN ERROR WINDOW"},
  {0x0D,0x00," D|T|L|P|W|R|O|A|K   ","ERROR DETECTED BY THIRD PARTY TEMPORARY INITIATOR"},
  {0x0D,0x01," D|T|L|P|W|R|O|A|K   ","THIRD PARTY DEVICE FAILURE"},
  {0x0D,0x02," D|T|L|P|W|R|O|A|K   ","COPY TARGET DEVICE NOT REACHABLE"},
  {0x0D,0x03," D|T|L|P|W|R|O|A|K   ","INCORRECT COPY TARGET DEVICE TYPE"},
  {0x0D,0x04," D|T|L|P|W|R|O|A|K   ","COPY TARGET DEVICE DATA UNDERRUN"},
  {0x0D,0x05," D|T|L|P|W|R|O|A|K   ","COPY TARGET DEVICE DATA OVERRUN"},
  {0x0E,0x00," D|T|P|W|R|O|M|A|E|B|K F ","INVALID INFORMATION UNIT"},
  {0x0E,0x01," D|T|P|W|R|O|M|A|E|B|K F ","INFORMATION UNIT TOO SHORT"},
  {0x0E,0x02," D|T|P|W|R|O|M|A|E|B|K F ","INFORMATION UNIT TOO LONG"},
  {0x0E,0x03,"D|T|P |R| M|A|E|B|K| F ","INVALID FIELD IN COMMAND INFORMATION UNIT"},
  {0x0F,0x00,"                ","Reserved"},
  {0x10,0x00," D  | W| O  |B|K   ","ID CRC OR ECC ERROR"},
  {0x10,0x01,"D|T|W|O        ","LOGICAL BLOCK GUARD CHECK FAILED"},
  {0x10,0x02,"D|T|W|O        ","LOGICAL BLOCK APPLICATION TAG CHECK FAILED"},
  {0x10,0x03,"D|T|W|O        ","LOGICAL BLOCK REFERENCE TAG CHECK FAILED"},
  {0x10,0x04,"  T             ","LOGICAL BLOCK PROTECTION ERROR ON RECOVER BUFFERED DATA"},
  {0x10,0x05,"  T             ","LOGICAL BLOCK PROTECTION METHOD ERROR"},
  {0x11,0x00,"D|T|W|R|O|B|K   ","UNRECOVERED READ ERROR"},
  {0x11,0x01,"D|T|W|R|O|B|K   ","READ RETRIES EXHAUSTED"},
  {0x11,0x02,"D|T|W|R|O|B|K   ","ERROR TOO LONG TO CORRECT"},
  {0x11,0x03,"D|T|W|O  |B|K   ","MULTIPLE READ ERRORS"},
  {0x11,0x04," D  |W|O  |B|K   ","UNRECOVERED READ ERROR - AUTO REALLOCATE FAILED"},
  {0x11,0x05,"    W|R|O|   B    ","L-EC UNCORRECTABLE ERROR"},
  {0x11,0x06,"    W|R|O|   B    ","CIRC UNRECOVERED ERROR"},
  {0x11,0x07,"     W|O|  B    ","DATA RE-SYNCHRONIZATION ERROR"},
  {0x11,0x08,"  T             ","INCOMPLETE BLOCK READ"},
  {0x11,0x09,"  T             ","NO GAP FOUND"},
  {0x11,0x0A,"D|T  |O  |B|K   ","MISCORRECTED ERROR"},
  {0x11,0x0B," D | W|O  |B|K   ","UNRECOVERED READ ERROR - RECOMMEND REASSIGNMENT"},
  {0x11,0x0C," D | W|O  |B|K   ","UNRECOVERED READ ERROR - RECOMMEND REWRITE THE DATA"},
  {0x11,0x0D,"D|T|W|R|O|   B    ","DE-COMPRESSION CRC ERROR"},
  {0x11,0x0E,"D|T|W|R|O|   B    ","CANNOT DECOMPRESS USING DECLARED ALGORITHM"},
  {0x11,0x0F,"      R         ","ERROR READING UPC/EAN NUMBER"},
  {0x11,0x10,"      R         ","ERROR READING ISRC NUMBER"},
  {0x11,0x11,"      R         ","READ ERROR - LOSS OF STREAMING"},
  {0x11,0x12,"D|T|W|R|O|M |B    ","AUXILIARY MEMORY READ ERROR"},
  {0x11,0x13," D|T|L|P|W|R|O|A|E|B|K|V|F ","READ ERROR - FAILED RETRANSMISSION REQUEST"},
  {0x11,0x14," D              ","READ ERROR - LBA MARKED BAD BY APPLICATION CLIENT"},
  {0x12,0x00," D|W|O  |B|K   ","ADDRESS MARK NOT FOUND FOR ID FIELD"},
  {0x13,0x00," D|W|O  |B|K   ","ADDRESS MARK NOT FOUND FOR DATA FIELD"},
  {0x14,0x00," D|T|L|W|R|O|B|K   ","RECORDED ENTITY NOT FOUND"},
  {0x14,0x01,"D|T|W|R|O|B|K   ","RECORD NOT FOUND"},
  {0x14,0x02,"  T             ","FILEMARK OR SETMARK NOT FOUND"},
  {0x14,0x03,"  T             ","END-OF-DATA NOT FOUND"},
  {0x14,0x04,"  T             ","BLOCK SEQUENCE ERROR"},
  {0x14,0x05,"D|TW|O  |B|K   ","RECORD NOT FOUND - RECOMMEND REASSIGNMENT"},
  {0x14,0x06,"D|TW|O  |B|K   ","RECORD NOT FOUND - DATA AUTO-REALLOCATED"},
  {0x14,0x07,"  T             ","LOCATE OPERATION FAILURE"},
  {0x15,0x00," D|T|L|W|R|O|M |B|K   ","RANDOM POSITIONING ERROR"},
  {0x15,0x01," D|T|L|W|R|O|M |B|K   ","MECHANICAL POSITIONING ERROR"},
  {0x15,0x02,"D|T|W|R|O|B|K   ","POSITIONING ERROR DETECTED BY READ OF MEDIUM"},
  {0x16,0x00," D|W|O  |B|K   ","DATA SYNCHRONIZATION MARK ERROR"},
  {0x16,0x01," D|W|O  |B|K   ","DATA SYNC ERROR - DATA REWRITTEN"},
  {0x16,0x02," D|W|O  |B|K   ","DATA SYNC ERROR - RECOMMEND REWRITE"},
  {0x16,0x03," D|W|O  |B|K   ","DATA SYNC ERROR - DATA AUTO-REALLOCATED"},
  {0x16,0x04," D|W|O  |B|K   ","DATA SYNC ERROR - RECOMMEND REASSIGNMENT"},
  {0x17,0x00,"D|T|W|R|O|B|K   ","RECOVERED DATA WITH NO ERROR CORRECTION APPLIED"},
  {0x17,0x01,"D|T|W|R|O|B|K   ","RECOVERED DATA WITH RETRIES"},
  {0x17,0x02,"D|T|W|R|O|B|K   ","RECOVERED DATA WITH POSITIVE HEAD OFFSET"},
  {0x17,0x03,"D|T|W|R|O|B|K   ","RECOVERED DATA WITH NEGATIVE HEAD OFFSET"},
  {0x17,0x04,"    |W|R|O|   B    ","RECOVERED DATA WITH RETRIES AND/OR CIRC APPLIED"},
  {0x17,0x05," D  |W|R|O|B|K   ","RECOVERED DATA USING PREVIOUS SECTOR ID"},
  {0x17,0x06," D|W|O  |B|K   ","RECOVERED DATA WITHOUT ECC - DATA AUTO-REALLOCATED"},
  {0x17,0x07," D  |W|R|O|B|K   ","RECOVERED DATA WITHOUT ECC - RECOMMEND REASSIGNMENT"},
  {0x17,0x08," D  |W|R|O|B|K   ","RECOVERED DATA WITHOUT ECC - RECOMMEND REWRITE"},
  {0x17,0x09," D  |W|R|O|B|K   ","RECOVERED DATA WITHOUT ECC - DATA REWRITTEN"},
  {0x18,0x00,"D|T|W|R|O|B|K   ","RECOVERED DATA WITH ERROR CORRECTION APPLIED"},
  {0x18,0x01," D  |W|R|O|B|K   ","RECOVERED DATA WITH ERROR CORR. & RETRIES APPLIED"},
  {0x18,0x02," D  |W|R|O|B|K   ","RECOVERED DATA - DATA AUTO-REALLOCATED"},
  {0x18,0x03,"      R         ","RECOVERED DATA WITH CIRC"},
  {0x18,0x04,"      R         ","RECOVERED DATA WITH L-EC"},
  {0x18,0x05," D  |W|R|O|B|K   ","RECOVERED DATA - RECOMMEND REASSIGNMENT"},
  {0x18,0x06," D  |W|R|O|B|K   ","RECOVERED DATA - RECOMMEND REWRITE"},
  {0x18,0x07," D  |W|O  |B|K   ","RECOVERED DATA WITH ECC - DATA REWRITTEN"},
  {0x18,0x08,"      R         ","RECOVERED DATA WITH LINKING"},
  {0x19,0x00," D  |  O  | K   ","DEFECT LIST ERROR"},
  {0x19,0x01," D  |  O  | K   ","DEFECT LIST NOT AVAILABLE"},
  {0x19,0x02," D  |  O  | K   ","DEFECT LIST ERROR IN PRIMARY LIST"},
  {0x19,0x03," D  |  O  | K   ","DEFECT LIST ERROR IN GROWN LIST"},
  {0x1A,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","PARAMETER LIST LENGTH ERROR"},
  {0x1B,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","SYNCHRONOUS DATA TRANSFER ERROR"},
  {0x1C,0x00," D |   O  |B|K   ","DEFECT LIST NOT FOUND"},
  {0x1C,0x01," D |   O  |B|K   ","PRIMARY DEFECT LIST NOT FOUND"},
  {0x1C,0x02," D |   O  |B|K   ","GROWN DEFECT LIST NOT FOUND"},
  {0x1D,0x00,"D|T|W|R|O|B|K   ","MISCOMPARE DURING VERIFY OPERATION"},
  {0x1D,0x01," D|B    ","MISCOMPARE VERIFY OF UNMAPPED LBA"},
  {0x1E,0x00," D | W|O  |B|K   ","RECOVERED ID WITH ECC CORRECTION"},
  {0x1F,0x00," D    |O|   K   ","PARTIAL DEFECT LIST TRANSFER"},
  {0x20,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INVALID COMMAND OPERATION CODE"},
  {0x20,0x01," D|T|P|W|R|O|M|A|E|B|K   ","ACCESS DENIED - INITIATOR PENDING-ENROLLED"},
  {0x20,0x02," D|T|P|W|R|O|M|A|E|B|K   ","ACCESS DENIED - NO ACCESS RIGHTS"},
  {0x20,0x03," D|T|P|W|R|O|M|A|E|B|K   ","ACCESS DENIED - INVALID MGMT ID KEY"},
  {0x20,0x04,"  T             ","ILLEGAL COMMAND WHILE IN WRITE CAPABLE STATE"},
  {0x20,0x05,"  T             ","Obsolete"},
  {0x20,0x06,"  T             ","ILLEGAL COMMAND WHILE IN EXPLICIT ADDRESS MODE"},
  {0x20,0x07,"  T             ","ILLEGAL COMMAND WHILE IN IMPLICIT ADDRESS MODE"},
  {0x20,0x08," D|T|P|W|R|O|M|A|E|B|K   ","ACCESS DENIED - ENROLLMENT CONFLICT"},
  {0x20,0x09," D|T|P|W|R|O|M|A|E|B|K   ","ACCESS DENIED - INVALID LU IDENTIFIER"},
  {0x20,0x0A," D|T|P|W|R|O|M|A|E|B|K   ","ACCESS DENIED - INVALID PROXY TOKEN"},
  {0x20,0x0B," D|T|P|W|R|O|M|A|E|B|K   ","ACCESS DENIED - ACL LUN CONFLICT"},
  {0x20,0x0C,"  T             ","ILLEGAL COMMAND WHEN NOT IN APPEND-ONLY MODE"},
  {0x21,0x00,"D|T|W|R|O  |B|K ","LOGICAL BLOCK ADDRESS OUT OF RANGE"},
  {0x21,0x01,"D|T|W|R|O|M|B|K ","INVALID ELEMENT ADDRESS"},
  {0x21,0x02,"      R         ","INVALID ADDRESS FOR WRITE"},
  {0x21,0x03,"      R         ","INVALID WRITE CROSSING LAYER JUMP"},
  {0x22,0x00," D              ","ILLEGAL FUNCTION (USE 20 00, 24 00, OR 26 00)"},
  {0x23,0x00,"D|T|P| R  |  B    ","INVALID TOKEN OPERATION, CAUSE NOT REPORTABLE"},
  {0x24,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INVALID FIELD IN CDB"},
  {0x24,0x01," D|T|L|P|W|R|O|A|E|B|K|V|F ","CDB DECRYPTION ERROR"},
  {0x24,0x02,"  T             ","Obsolete"},
  {0x24,0x03,"  T             ","Obsolete"},
  {0x24,0x04,"              F ","SECURITY AUDIT VALUE FROZEN"},
  {0x24,0x05,"              F ","SECURITY WORKING KEY FROZEN"},
  {0x24,0x06,"              F ","NONCE NOT UNIQUE"},
  {0x24,0x07,"              F ","NONCE TIMESTAMP OUT OF RANGE"},
  {0x24,0x08,"D|T | R| M|A|E|B|K|V  ","INVALID XCDB"},
  {0x25,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT NOT SUPPORTED"},
  {0x26,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INVALID FIELD IN PARAMETER LIST"},
  {0x26,0x01," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","PARAMETER NOT SUPPORTED"},
  {0x26,0x02," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","PARAMETER VALUE INVALID"},
  {0x26,0x03," D|T|L|P|W|R|O|M|A|E K   ","THRESHOLD PARAMETERS NOT SUPPORTED"},
  {0x26,0x04," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INVALID RELEASE OF PERSISTENT RESERVATION"},
  {0x26,0x05," D|T|L|P|W|R|O|A|B|K   ","DATA DECRYPTION ERROR"},
  {0x26,0x06," D|T|L|P|W|R|O |  K   ","TOO MANY TARGET DESCRIPTORS"},
  {0x26,0x07," D|T|L|P|W|R|O |  K   ","UNSUPPORTED TARGET DESCRIPTOR TYPE CODE"},
  {0x26,0x08," D|T|L|P|W|R|O |  K   ","TOO MANY SEGMENT DESCRIPTORS"},
  {0x26,0x09," D|T|L|P|W|R|O |  K   ","UNSUPPORTED SEGMENT DESCRIPTOR TYPE CODE"},
  {0x26,0x0A," D|T|L|P|W|R|O |  K   ","UNEXPECTED INEXACT SEGMENT"},
  {0x26,0x0B," D|T|L|P|W|R|O |  K   ","INLINE DATA LENGTH EXCEEDED"},
  {0x26,0x0C," D|T|L|P|W|R|O |  K   ","INVALID OPERATION FOR COPY SOURCE OR DESTINATION"},
  {0x26,0x0D," D|T|L|P|W|R|O |  K   ","COPY SEGMENT GRANULARITY VIOLATION"},
  {0x26,0x0E," D|T|P|W|R|O|M|A|E|B|K   ","INVALID PARAMETER WHILE PORT IS ENABLED"},
  {0x26,0x0F,"              F ","INVALID DATA-OUT BUFFER INTEGRITY CHECK VALUE"},
  {0x26,0x10,"  T             ","DATA DECRYPTION KEY FAIL LIMIT REACHED"},
  {0x26,0x11,"  T             ","INCOMPLETE KEY-ASSOCIATED DATA SET"},
  {0x26,0x12,"  T             ","VENDOR SPECIFIC KEY REFERENCE NOT FOUND"},
  {0x27,0x00,"D|T|W|R|O|B|K   ","WRITE PROTECTED"},
  {0x27,0x01,"D|T|W|R|O|B|K   ","HARDWARE WRITE PROTECTED"},
  {0x27,0x02,"D|T|W|R|O|B|K   ","LOGICAL UNIT SOFTWARE WRITE PROTECTED"},
  {0x27,0x03,"  T  | R         ","ASSOCIATED WRITE PROTECT"},
  {0x27,0x04,"  T  | R         ","PERSISTENT WRITE PROTECT"},
  {0x27,0x05,"  T  | R         ","PERMANENT WRITE PROTECT"},
  {0x27,0x06,"      R      | F ","CONDITIONAL WRITE PROTECT"},
  {0x27,0x07," D|B    ","SPACE ALLOCATION FAILED WRITE PROTECT"},
  {0x28,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","NOT READY TO READY CHANGE, MEDIUM MAY HAVE CHANGED"},
  {0x28,0x01,"D|T|W|R|O|M  |B    ","IMPORT OR EXPORT ELEMENT ACCESSED"},
  {0x28,0x02,"      R         ","FORMAT-LAYER MAY HAVE CHANGED"},
  {0x28,0x03,"        M       ","IMPORT/EXPORT ELEMENT ACCESSED, MEDIUM CHANGED"},
  {0x29,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","POWER ON, RESET, OR BUS DEVICE RESET OCCURRED"},
  {0x29,0x01," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","POWER ON OCCURRED"},
  {0x29,0x02," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","SCSI BUS RESET OCCURRED"},
  {0x29,0x03," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","BUS DEVICE RESET FUNCTION OCCURRED"},
  {0x29,0x04," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","DEVICE INTERNAL RESET"},
  {0x29,0x05," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","TRANSCEIVER MODE CHANGED TO SINGLE-ENDED"},
  {0x29,0x06," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","TRANSCEIVER MODE CHANGED TO LVD"},
  {0x29,0x07," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","I_T NEXUS LOSS OCCURRED"},
  {0x2A,0x00," D|T|L|W|R|O|M|A|E|B|K|V|F ","PARAMETERS CHANGED"},
  {0x2A,0x01," D|T|L|W|R|O|M|A|E|B|K|V|F ","MODE PARAMETERS CHANGED"},
  {0x2A,0x02," D|T|L|W|R|O|M|A|E| K   ","LOG PARAMETERS CHANGED"},
  {0x2A,0x03," D|T|L|P|W|R|O|M|A|E| K   ","RESERVATIONS PREEMPTED"},
  {0x2A,0x04," D|T|L|P|W|R|O|M|A|E     ","RESERVATIONS RELEASED"},
  {0x2A,0x05," D|T|L|P|W|R|O|M|A|E     ","REGISTRATIONS PREEMPTED"},
  {0x2A,0x06," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ASYMMETRIC ACCESS STATE CHANGED"},
  {0x2A,0x07," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","IMPLICIT ASYMMETRIC ACCESS STATE TRANSITION FAILED"},
  {0x2A,0x08,"D|T|W|R|O|M|A|E|B|K|V|F ","PRIORITY CHANGED"},
  {0x2A,0x09," D              ","CAPACITY DATA HAS CHANGED"},
  {0x2A,0x0A,"D|T            ","ERROR HISTORY I_T NEXUS CLEARED"},
  {0x2A,0x0B,"D|T            ","ERROR HISTORY SNAPSHOT RELEASED"},
  {0x2A,0x0C,"              F ","ERROR RECOVERY ATTRIBUTES HAVE CHANGED"},
  {0x2A,0x0D,"  T             ","DATA ENCRYPTION CAPABILITIES CHANGED"},
  {0x2A,0x10,"D|T  | M|E |V  ","TIMESTAMP CHANGED"},
  {0x2A,0x11,"  T             ","DATA ENCRYPTION PARAMETERS CHANGED BY ANOTHER I_T NEXUS"},
  {0x2A,0x12,"  T             ","DATA ENCRYPTION PARAMETERS CHANGED BY VENDOR SPECIFIC EVENT"},
  {0x2A,0x13,"  T             ","DATA ENCRYPTION KEY INSTANCE COUNTER HAS CHANGED"},
  {0x2A,0x14,"D|T|R|M|A|E|B|K|V  ","SA CREATION CAPABILITIES DATA HAS CHANGED"},
  {0x2B,0x00," D|T|L|P|W|R|O  |K   ","COPY CANNOT EXECUTE SINCE HOST CANNOT DISCONNECT"},
  {0x2C,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","COMMAND SEQUENCE ERROR"},
  {0x2C,0x01,"                ","TOO MANY WINDOWS SPECIFIED"},
  {0x2C,0x02,"                ","INVALID COMBINATION OF WINDOWS SPECIFIED"},
  {0x2C,0x03,"      R         ","CURRENT PROGRAM AREA IS NOT EMPTY"},
  {0x2C,0x04,"      R         ","CURRENT PROGRAM AREA IS EMPTY"},
  {0x2C,0x05,"           B    ","ILLEGAL POWER CONDITION REQUEST"},
  {0x2C,0x06,"      R         ","PERSISTENT PREVENT CONFLICT"},
  {0x2C,0x07," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","PREVIOUS BUSY STATUS"},
  {0x2C,0x08," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","PREVIOUS TASK SET FULL STATUS"},
  {0x2C,0x09," D|T|L|P|WROM E|B|K|V|F ","PREVIOUS RESERVATION CONFLICT STATUS"},
  {0x2C,0x0A,"              F ","PARTITION OR COLLECTION CONTAINS USER OBJECTS"},
  {0x2C,0x0B,"  T             ","NOT RESERVED"},
  {0x2C,0x0C," D              ","ORWRITE GENERATION DOES NOT MATCH"},
  {0x2D,0x00,"  T             ","OVERWRITE ERROR ON UPDATE IN PLACE"},
  {0x2E,0x00,"      R         ","INSUFFICIENT TIME FOR OPERATION"},
  {0x2F,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","COMMANDS CLEARED BY ANOTHER INITIATOR"},
  {0x2F,0x01," D              ","COMMANDS CLEARED BY POWER LOSS NOTIFICATION"},
  {0x2F,0x02," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","COMMANDS CLEARED BY DEVICE SERVER"},
  {0x30,0x00,"D|T|W|R|O|M |B|K   ","INCOMPATIBLE MEDIUM INSTALLED"},
  {0x30,0x01,"D|T|W|R|O|B|K   ","CANNOT READ MEDIUM - UNKNOWN FORMAT"},
  {0x30,0x02,"D|T|W|R|O|B|K   ","CANNOT READ MEDIUM - INCOMPATIBLE FORMAT"},
  {0x30,0x03,"D|T|  R| M  | K   ","CLEANING CARTRIDGE INSTALLED"},
  {0x30,0x04,"D|T|W|R|O|B|K   ","CANNOT WRITE MEDIUM - UNKNOWN FORMAT"},
  {0x30,0x05,"D|T|W|R|O|B|K   ","CANNOT WRITE MEDIUM - INCOMPATIBLE FORMAT"},
  {0x30,0x06,"D|T|W|R|O|   B    ","CANNOT FORMAT MEDIUM - INCOMPATIBLE MEDIUM"},
  {0x30,0x07," D|T|L|W|R|O|M|A|E|B|K|V|F ","CLEANING FAILURE"},
  {0x30,0x08,"      R         ","CANNOT WRITE - APPLICATION CODE MISMATCH"},
  {0x30,0x09,"      R         ","CURRENT SESSION NOT FIXATED FOR APPEND"},
  {0x30,0x0A,"D|T|W|R|O| A|E|B|K   ","CLEANING REQUEST REJECTED"},
  {0x30,0x0C,"  T             ","WORM MEDIUM - OVERWRITE ATTEMPTED"},
  {0x30,0x0D,"  T             ","WORM MEDIUM - INTEGRITY CHECK"},
  {0x30,0x10,"      R         ","MEDIUM NOT FORMATTED"},
  {0x30,0x11,"        M       ","INCOMPATIBLE VOLUME TYPE"},
  {0x30,0x12,"        M       ","INCOMPATIBLE VOLUME QUALIFIER"},
  {0x30,0x13,"        M       ","CLEANING VOLUME EXPIRED"},
  {0x31,0x00,"D|T|W|R|O|B|K   ","MEDIUM FORMAT CORRUPTED"},
  {0x31,0x01," D| L | R|O |  B    ","FORMAT COMMAND FAILED"},
  {0x31,0x02,"      R         ","ZONED FORMATTING FAILED DUE TO SPARE LINKING"},
  {0x31,0x03," D|B    ","SANITIZE COMMAND FAILED"},
  {0x32,0x00," D|W|O  |B|K   ","NO DEFECT SPARE LOCATION AVAILABLE"},
  {0x32,0x01," D|W|O  |B|K   ","DEFECT LIST UPDATE FAILURE"},
  {0x33,0x00,"  T             ","TAPE LENGTH ERROR"},
  {0x34,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ENCLOSURE FAILURE"},
  {0x35,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ENCLOSURE SERVICES FAILURE"},
  {0x35,0x01," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","UNSUPPORTED ENCLOSURE FUNCTION"},
  {0x35,0x02," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ENCLOSURE SERVICES UNAVAILABLE"},
  {0x35,0x03," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ENCLOSURE SERVICES TRANSFER FAILURE"},
  {0x35,0x04," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ENCLOSURE SERVICES TRANSFER REFUSED"},
  {0x35,0x05," D|T|L|W|R|O|M|A|E|B|K|V|F ","ENCLOSURE SERVICES CHECKSUM ERROR"},
  {0x36,0x00,"   L            ","RIBBON, INK, OR TONER FAILURE"},
  {0x37,0x00," D|T|L|W|R|O|M|A|E|B|K|V|F ","ROUNDED PARAMETER"},
  {0x38,0x00,"           B    ","EVENT STATUS NOTIFICATION"},
  {0x38,0x02,"           B    ","ESN - POWER MANAGEMENT CLASS EVENT"},
  {0x38,0x04,"           B    ","ESN - MEDIA CLASS EVENT"},
  {0x38,0x06,"           B    ","ESN - DEVICE BUSY CLASS EVENT"},
  {0x38,0x07," D              ","THIN PROVISIONING SOFT THRESHOLD REACHED"},
  {0x39,0x00," D|T|L|W|R|O|MAE K   ","SAVING PARAMETERS NOT SUPPORTED"},
  {0x3A,0x00," D|T|L|W|R|O|M |B|K   ","MEDIUM NOT PRESENT"},
  {0x3A,0x01,"D|T|W|R|O|M |B|K   ","MEDIUM NOT PRESENT - TRAY CLOSED"},
  {0x3A,0x02,"D|T|W|R|O|M |B|K   ","MEDIUM NOT PRESENT - TRAY OPEN"},
  {0x3A,0x03,"D|T|W|R|O|M  B    ","MEDIUM NOT PRESENT - LOADABLE"},
  {0x3A,0x04,"D|T|W|R|O|   B    ","MEDIUM NOT PRESENT - MEDIUM AUXILIARY MEMORY ACCESSIBLE"},
  {0x3B,0x00,"  T|L            ","SEQUENTIAL POSITIONING ERROR"},
  {0x3B,0x01,"  T             ","TAPE POSITION ERROR AT BEGINNING-OF-MEDIUM"},
  {0x3B,0x02,"  T             ","TAPE POSITION ERROR AT END-OF-MEDIUM"},
  {0x3B,0x03,"   L            ","TAPE OR ELECTRONIC VERTICAL FORMS UNIT NOT READY"},
  {0x3B,0x04,"   L            ","SLEW FAILURE"},
  {0x3B,0x05,"   L            ","PAPER JAM"},
  {0x3B,0x06,"   L            ","FAILED TO SENSE TOP-OF-FORM"},
  {0x3B,0x07,"   L            ","FAILED TO SENSE BOTTOM-OF-FORM"},
  {0x3B,0x08,"  T             ","REPOSITION ERROR"},
  {0x3B,0x09,"                ","READ PAST END OF MEDIUM"},
  {0x3B,0x0A,"                ","READ PAST BEGINNING OF MEDIUM"},
  {0x3B,0x0B,"                ","POSITION PAST END OF MEDIUM"},
  {0x3B,0x0C,"  T             ","POSITION PAST BEGINNING OF MEDIUM"},
  {0x3B,0x0D,"D|T|W|R|O|M |B|K   ","MEDIUM DESTINATION ELEMENT FULL"},
  {0x3B,0x0E,"D|T|W|R|O|M |B|K   ","MEDIUM SOURCE ELEMENT EMPTY"},
  {0x3B,0x0F,"      R         ","END OF MEDIUM REACHED"},
  {0x3B,0x11,"D|T|W|R|O|M |B|K   ","MEDIUM MAGAZINE NOT ACCESSIBLE"},
  {0x3B,0x12,"D|T|W|R|O|M |B|K   ","MEDIUM MAGAZINE REMOVED"},
  {0x3B,0x13,"D|T|W|R|O|M |B|K   ","MEDIUM MAGAZINE INSERTED"},
  {0x3B,0x14,"D|T|W|R|O|M |B|K   ","MEDIUM MAGAZINE LOCKED"},
  {0x3B,0x15,"D|T|W|R|O|M |B|K   ","MEDIUM MAGAZINE UNLOCKED"},
  {0x3B,0x16,"      R         ","MECHANICAL POSITIONING OR CHANGER ERROR"},
  {0x3B,0x17,"              F ","READ PAST END OF USER OBJECT"},
  {0x3B,0x18,"        M       ","ELEMENT DISABLED"},
  {0x3B,0x19,"        M       ","ELEMENT ENABLED"},
  {0x3B,0x1A,"        M       ","DATA TRANSFER DEVICE REMOVED"},
  {0x3B,0x1B,"        M       ","DATA TRANSFER DEVICE INSERTED"},
  {0x3C,0x00,"                ","Reserved"},
  {0x3D,0x00," D|T|L|P|W|R|O|M|A|E K   ","INVALID BITS IN IDENTIFY MESSAGE"},
  {0x3E,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT HAS NOT SELF-CONFIGURED YET"},
  {0x3E,0x01," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT FAILURE"},
  {0x3E,0x02," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","TIMEOUT ON LOGICAL UNIT"},
  {0x3E,0x03," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT FAILED SELF-TEST"},
  {0x3E,0x04," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT UNABLE TO UPDATE SELF-TEST LOG"},
  {0x3F,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","TARGET OPERATING CONDITIONS HAVE CHANGED"},
  {0x3F,0x01," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","MICROCODE HAS BEEN CHANGED"},
  {0x3F,0x02," D|T|L|P|WROM |B|K   ","CHANGED OPERATING DEFINITION"},
  {0x3F,0x03," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INQUIRY DATA HAS CHANGED"},
  {0x3F,0x04,"D|T|W|R|O|M|A|E|B|K   ","COMPONENT DEVICE ATTACHED"},
  {0x3F,0x05,"D|T|W|R|O|M|A|E|B|K   ","DEVICE IDENTIFIER CHANGED"},
  {0x3F,0x06,"D|T|W|R|O|M|A|E|B    ","REDUNDANCY GROUP CREATED OR MODIFIED"},
  {0x3F,0x07,"D|T|W|R|O|M|A|E|B    ","REDUNDANCY GROUP DELETED"},
  {0x3F,0x08,"D|T|W|R|O|M|A|E|B    ","SPARE CREATED OR MODIFIED"},
  {0x3F,0x09,"D|T|W|R|O|M|A|E|B    ","SPARE DELETED"},
  {0x3F,0x0A,"D|T|W|R|O|M|A|E|B|K   ","VOLUME SET CREATED OR MODIFIED"},
  {0x3F,0x0B,"D|T|W|R|O|M|A|E|B|K   ","VOLUME SET DELETED"},
  {0x3F,0x0C,"D|T|W|R|O|M|A|E|B|K   ","VOLUME SET DEASSIGNED"},
  {0x3F,0x0D,"D|T|W|R|O|M|A|E|B|K   ","VOLUME SET REASSIGNED"},
  {0x3F,0x0E," D|T|L|P|W|R|O|M|A|E     ","REPORTED LUNS DATA HAS CHANGED"},
  {0x3F,0x0F," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ECHO BUFFER OVERWRITTEN"},
  {0x3F,0x10,"D|T|W|R|O|M|  B    ","MEDIUM LOADABLE"},
  {0x3F,0x11,"D|T|W|R|O|M|  B    ","MEDIUM AUXILIARY MEMORY ACCESSIBLE"},
  {0x3F,0x12," D|T|L|P|W|R| M|A|E|B|K F ","iSCSI IP ADDRESS ADDED"},
  {0x3F,0x13," D|T|L|P|W|R| M|A|E|B|K F ","iSCSI IP ADDRESS REMOVED"},
  {0x3F,0x14," D|T|L|P|W|R| M|A|E|B|K F ","iSCSI IP ADDRESS CHANGED"},
  {0x40,0x00," D              ","RAM FAILURE (SHOULD USE 40 NN)"},
  {0x40,0x80/*NN*/," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","DIAGNOSTIC FAILURE ON COMPONENT NN (80h-FFh)"},
  {0x41,0x00," D              ","DATA PATH FAILURE (SHOULD USE 40 NN)"},
  {0x42,0x00," D              ","POWER-ON OR SELF-TEST FAILURE (SHOULD USE 40 NN)"},
  {0x43,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","MESSAGE ERROR"},
  {0x44,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INTERNAL TARGET FAILURE"},
  {0x44,0x71," D|T |       B    ","ATA DEVICE FAILED SET FEATURES"},
  {0x45,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","SELECT OR RESELECT FAILURE"},
  {0x46,0x00," D|T|L|P|WROM |B|K   ","UNSUCCESSFUL SOFT RESET"},
  {0x47,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","SCSI PARITY ERROR"},
  {0x47,0x01," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","DATA PHASE CRC ERROR DETECTED"},
  {0x47,0x02," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","SCSI PARITY ERROR DETECTED DURING ST DATA PHASE"},
  {0x47,0x03," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INFORMATION UNIT iuCRC ERROR DETECTED"},
  {0x47,0x04," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","ASYNCHRONOUS INFORMATION PROTECTION ERROR DETECTED"},
  {0x47,0x05," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","PROTOCOL SERVICE CRC ERROR"},
  {0x47,0x06," D|T|M|A|E|B|K|V|F ","PHY TEST FUNCTION IN PROGRESS"},
  {0x47,0x7F," D|T|P|W|R|O|M|A|E|B|K   ","SOME COMMANDS CLEARED BY ISCSI PROTOCOL EVENT"},
  {0x48,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INITIATOR DETECTED ERROR MESSAGE RECEIVED"},
  {0x49,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INVALID MESSAGE ERROR"},
  {0x4A,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","COMMAND PHASE ERROR"},
  {0x4B,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","DATA PHASE ERROR"},
  {0x4B,0x01," D|T|P|W|R|O|M|A|E|B|K   ","INVALID TARGET PORT TRANSFER TAG RECEIVED"},
  {0x4B,0x02," D|T|P|W|R|O|M|A|E|B|K   ","TOO MUCH WRITE DATA"},
  {0x4B,0x03," D|T|P|W|R|O|M|A|E|B|K   ","ACK/NAK TIMEOUT"},
  {0x4B,0x04," D|T|P|W|R|O|M|A|E|B|K   ","NAK RECEIVED"},
  {0x4B,0x05," D|T|P|W|R|O|M|A|E|B|K   ","DATA OFFSET ERROR"},
  {0x4B,0x06," D|T|P|W|R|O|M|A|E|B|K   ","INITIATOR RESPONSE TIMEOUT"},
  {0x4B,0x07," D|T|P|W|R|O|M|A|E|B|K F ","CONNECTION LOST"},
  {0x4C,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","LOGICAL UNIT FAILED SELF-CONFIGURATION"},
  {0x4D,0x80/*NN*/," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","TAGGED OVERLAPPED COMMANDS (NN = TASK TAG)"},
  {0x4E,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","OVERLAPPED COMMANDS ATTEMPTED"},
  {0x4F,0x00,"		      ","Reserved"},
  {0x50,0x00,"  T             ","WRITE APPEND ERROR"},
  {0x50,0x01,"  T             ","WRITE APPEND POSITION ERROR"},
  {0x50,0x02,"  T             ","POSITION ERROR RELATED TO TIMING"},
  {0x51,0x00,"  T|   R|O        ","ERASE FAILURE"},
  {0x51,0x01,"      R         ","ERASE FAILURE - INCOMPLETE ERASE OPERATION DETECTED"},
  {0x52,0x00,"  T             ","CARTRIDGE FAULT"},
  {0x53,0x00," D|T|L|W|R|O|M |B|K   ","MEDIA LOAD OR EJECT FAILED"},
  {0x53,0x01,"  T             ","UNLOAD TAPE FAILURE"},
  {0x53,0x02," D|T |W|R|O|M |B|K   ","MEDIUM REMOVAL PREVENTED"},
  {0x53,0x03,"        M       ","MEDIUM REMOVAL PREVENTED BY DATA TRANSFER ELEMENT"},
  {0x53,0x04,"  T             ","MEDIUM THREAD OR UNTHREAD FAILURE"},
  {0x53,0x05,"        M       ","VOLUME IDENTIFIER INVALID"},
  {0x53,0x06,"        M       ","VOLUME IDENTIFIER MISSING"},
  {0x53,0x07,"        M       ","DUPLICATE VOLUME IDENTIFIER"},
  {0x53,0x08,"        M       ","ELEMENT STATUS UNKNOWN"},
  {0x54,0x00,"    P           ","SCSI TO HOST SYSTEM INTERFACE FAILURE"},
  {0x55,0x00,"    P           ","SYSTEM RESOURCE FAILURE"},
  {0x55,0x01," D  |   O  |B|K   ","SYSTEM BUFFER FULL"},
  {0x55,0x02," D|T|L|P|W|R|O|M|A|E |K   ","INSUFFICIENT RESERVATION RESOURCES"},
  {0x55,0x03," D|T|L|P|W|R|O|M|A|E |K   ","INSUFFICIENT RESOURCES"},
  {0x55,0x04," D|T|L|P|W|R|O|M|A|E |K   ","INSUFFICIENT REGISTRATION RESOURCES"},
  {0x55,0x05," D|T| P|W|R|O|M|A|EB|K   ","INSUFFICIENT ACCESS CONTROL RESOURCES"},
  {0x55,0x06," D|T |W|R|O|M  |B    ","AUXILIARY MEMORY OUT OF SPACE"},
  {0x55,0x07,"              F ","QUOTA ERROR"},
  {0x55,0x08,"  T             ","MAXIMUM NUMBER OF SUPPLEMENTAL DECRYPTION KEYS EXCEEDED"},
  {0x55,0x09,"        M       ","MEDIUM AUXILIARY MEMORY NOT ACCESSIBLE"},
  {0x55,0x0A,"        M       ","DATA CURRENTLY UNAVAILABLE"},
  {0x55,0x0B," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","INSUFFICIENT POWER FOR OPERATION"},
  {0x56,0x00," 		      ","Reserved"},
  {0x57,0x00,"      R         ","UNABLE TO RECOVER TABLE-OF-CONTENTS"},
  {0x58,0x00,"       O        ","GENERATION DOES NOT EXIST"},
  {0x59,0x00,"       O        ","UPDATED BLOCK READ"},
  {0x5A,0x00," D|T|L|P|W|R|O|B|K   ","OPERATOR REQUEST OR STATE CHANGE INPUT"},
  {0x5A,0x01,"D|T|W|R|O|M |B|K   ","OPERATOR MEDIUM REMOVAL REQUEST"},
  {0x5A,0x02,"D|T|W|R|O| A|B|K   ","OPERATOR SELECTED WRITE PROTECT"},
  {0x5A,0x03,"D|T|W|R|O| A|B|K   ","OPERATOR SELECTED WRITE PERMIT"},
  {0x5B,0x00," D|T|L|P|W|R|O|M|K   ","LOG EXCEPTION"},
  {0x5B,0x01," D|T|L|P|W|R|O|M|K   ","THRESHOLD CONDITION MET"},
  {0x5B,0x02," D|T|L|P|W|R|O|M|K   ","LOG COUNTER AT MAXIMUM"},
  {0x5B,0x03," D|T|L|P|W|R|O|M|K   ","LOG LIST CODES EXHAUSTED"},
  {0x5C,0x00," D  |  O        ","RPL STATUS CHANGE"},
  {0x5C,0x01," D  |  O        ","SPINDLES SYNCHRONIZED"},
  {0x5C,0x02," D  |  O        ","SPINDLES NOT SYNCHRONIZED"},
  {0x5D,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","FAILURE PREDICTION THRESHOLD EXCEEDED"},
  {0x5D,0x01,"      R  |  B    ","MEDIA FAILURE PREDICTION THRESHOLD EXCEEDED"},
  {0x5D,0x02,"      R         ","LOGICAL UNIT FAILURE PREDICTION THRESHOLD EXCEEDED"},
  {0x5D,0x03,"      R         ","SPARE AREA EXHAUSTION PREDICTION THRESHOLD EXCEEDED"},
  {0x5D,0x10," D|B    ","HARDWARE IMPENDING FAILURE GENERAL HARD DRIVE FAILURE"},
  {0x5D,0x11," D|B    ","HARDWARE IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH"},
  {0x5D,0x12," D|B    ","HARDWARE IMPENDING FAILURE DATA ERROR RATE TOO HIGH"},
  {0x5D,0x13," D|B    ","HARDWARE IMPENDING FAILURE SEEK ERROR RATE TOO HIGH"},
  {0x5D,0x14," D|B    ","HARDWARE IMPENDING FAILURE TOO MANY BLOCK REASSIGNS"},
  {0x5D,0x15," D|B    ","HARDWARE IMPENDING FAILURE ACCESS TIMES TOO HIGH"},
  {0x5D,0x16," D|B    ","HARDWARE IMPENDING FAILURE START UNIT TIMES TOO HIGH"},
  {0x5D,0x17," D|B    ","HARDWARE IMPENDING FAILURE CHANNEL PARAMETRICS"},
  {0x5D,0x18," D|B    ","HARDWARE IMPENDING FAILURE CONTROLLER DETECTED"},
  {0x5D,0x19," D|B    ","HARDWARE IMPENDING FAILURE THROUGHPUT PERFORMANCE"},
  {0x5D,0x1A," D|B    ","HARDWARE IMPENDING FAILURE SEEK TIME PERFORMANCE"},
  {0x5D,0x1B," D|B    ","HARDWARE IMPENDING FAILURE SPIN-UP RETRY COUNT"},
  {0x5D,0x1C," D|B    ","HARDWARE IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT"},
  {0x5D,0x20," D|B    ","CONTROLLER IMPENDING FAILURE GENERAL HARD DRIVE FAILURE"},
  {0x5D,0x21," D|B    ","CONTROLLER IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH"},
  {0x5D,0x22," D|B    ","CONTROLLER IMPENDING FAILURE DATA ERROR RATE TOO HIGH"},
  {0x5D,0x23," D|B    ","CONTROLLER IMPENDING FAILURE SEEK ERROR RATE TOO HIGH"},
  {0x5D,0x24," D|B    ","CONTROLLER IMPENDING FAILURE TOO MANY BLOCK REASSIGNS"},
  {0x5D,0x25," D|B    ","CONTROLLER IMPENDING FAILURE ACCESS TIMES TOO HIGH"},
  {0x5D,0x26," D|B    ","CONTROLLER IMPENDING FAILURE START UNIT TIMES TOO HIGH"},
  {0x5D,0x27," D|B    ","CONTROLLER IMPENDING FAILURE CHANNEL PARAMETRICS"},
  {0x5D,0x28," D|B    ","CONTROLLER IMPENDING FAILURE CONTROLLER DETECTED"},
  {0x5D,0x29," D|B    ","CONTROLLER IMPENDING FAILURE THROUGHPUT PERFORMANCE"},
  {0x5D,0x2A," D|B    ","CONTROLLER IMPENDING FAILURE SEEK TIME PERFORMANCE"},
  {0x5D,0x2B," D|B    ","CONTROLLER IMPENDING FAILURE SPIN-UP RETRY COUNT"},
  {0x5D,0x2C," D|B    ","CONTROLLER IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT"},
  {0x5D,0x30," D|B    ","DATA CHANNEL IMPENDING FAILURE GENERAL HARD DRIVE FAILURE"},
  {0x5D,0x31," D|B    ","DATA CHANNEL IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH"},
  {0x5D,0x32," D|B    ","DATA CHANNEL IMPENDING FAILURE DATA ERROR RATE TOO HIGH"},
  {0x5D,0x33," D|B    ","DATA CHANNEL IMPENDING FAILURE SEEK ERROR RATE TOO HIGH"},
  {0x5D,0x34," D|B    ","DATA CHANNEL IMPENDING FAILURE TOO MANY BLOCK REASSIGNS"},
  {0x5D,0x35," D|B    ","DATA CHANNEL IMPENDING FAILURE ACCESS TIMES TOO HIGH"},
  {0x5D,0x36," D|B    ","DATA CHANNEL IMPENDING FAILURE START UNIT TIMES TOO HIGH"},
  {0x5D,0x37," D|B    ","DATA CHANNEL IMPENDING FAILURE CHANNEL PARAMETRICS"},
  {0x5D,0x38," D|B    ","DATA CHANNEL IMPENDING FAILURE CONTROLLER DETECTED"},
  {0x5D,0x39," D|B    ","DATA CHANNEL IMPENDING FAILURE THROUGHPUT PERFORMANCE"},
  {0x5D,0x3A," D|B    ","DATA CHANNEL IMPENDING FAILURE SEEK TIME PERFORMANCE"},
  {0x5D,0x3B," D|B    ","DATA CHANNEL IMPENDING FAILURE SPIN-UP RETRY COUNT"},
  {0x5D,0x3C," D|B    ","DATA CHANNEL IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT"},
  {0x5D,0x40," D|B    ","SERVO IMPENDING FAILURE GENERAL HARD DRIVE FAILURE"},
  {0x5D,0x41," D|B    ","SERVO IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH"},
  {0x5D,0x42," D|B    ","SERVO IMPENDING FAILURE DATA ERROR RATE TOO HIGH"},
  {0x5D,0x43," D|B    ","SERVO IMPENDING FAILURE SEEK ERROR RATE TOO HIGH"},
  {0x5D,0x44," D|B    ","SERVO IMPENDING FAILURE TOO MANY BLOCK REASSIGNS"},
  {0x5D,0x45," D|B    ","SERVO IMPENDING FAILURE ACCESS TIMES TOO HIGH"},
  {0x5D,0x46," D|B    ","SERVO IMPENDING FAILURE START UNIT TIMES TOO HIGH"},
  {0x5D,0x47," D|B    ","SERVO IMPENDING FAILURE CHANNEL PARAMETRICS"},
  {0x5D,0x48," D|B    ","SERVO IMPENDING FAILURE CONTROLLER DETECTED"},
  {0x5D,0x49," D|B    ","SERVO IMPENDING FAILURE THROUGHPUT PERFORMANCE"},
  {0x5D,0x4A," D|B    ","SERVO IMPENDING FAILURE SEEK TIME PERFORMANCE"},
  {0x5D,0x4B," D|B    ","SERVO IMPENDING FAILURE SPIN-UP RETRY COUNT"},
  {0x5D,0x4C," D|B    ","SERVO IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT"},
  {0x5D,0x50," D|B    ","SPINDLE IMPENDING FAILURE GENERAL HARD DRIVE FAILURE"},
  {0x5D,0x51," D|B    ","SPINDLE IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH"},
  {0x5D,0x52," D|B    ","SPINDLE IMPENDING FAILURE DATA ERROR RATE TOO HIGH"},
  {0x5D,0x53," D|B    ","SPINDLE IMPENDING FAILURE SEEK ERROR RATE TOO HIGH"},
  {0x5D,0x54," D|B    ","SPINDLE IMPENDING FAILURE TOO MANY BLOCK REASSIGNS"},
  {0x5D,0x55," D|B    ","SPINDLE IMPENDING FAILURE ACCESS TIMES TOO HIGH"},
  {0x5D,0x56," D|B    ","SPINDLE IMPENDING FAILURE START UNIT TIMES TOO HIGH"},
  {0x5D,0x57," D|B    ","SPINDLE IMPENDING FAILURE CHANNEL PARAMETRICS"},
  {0x5D,0x58," D|B    ","SPINDLE IMPENDING FAILURE CONTROLLER DETECTED"},
  {0x5D,0x59," D|B    ","SPINDLE IMPENDING FAILURE THROUGHPUT PERFORMANCE"},
  {0x5D,0x5A," D|B    ","SPINDLE IMPENDING FAILURE SEEK TIME PERFORMANCE"},
  {0x5D,0x5B," D|B    ","SPINDLE IMPENDING FAILURE SPIN-UP RETRY COUNT"},
  {0x5D,0x5C," D|B    ","SPINDLE IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT"},
  {0x5D,0x60," D|B    ","FIRMWARE IMPENDING FAILURE GENERAL HARD DRIVE FAILURE"},
  {0x5D,0x61," D|B    ","FIRMWARE IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH"},
  {0x5D,0x62," D|B    ","FIRMWARE IMPENDING FAILURE DATA ERROR RATE TOO HIGH"},
  {0x5D,0x63," D|B    ","FIRMWARE IMPENDING FAILURE SEEK ERROR RATE TOO HIGH"},
  {0x5D,0x64," D|B    ","FIRMWARE IMPENDING FAILURE TOO MANY BLOCK REASSIGNS"},
  {0x5D,0x65," D|B    ","FIRMWARE IMPENDING FAILURE ACCESS TIMES TOO HIGH"},
  {0x5D,0x66," D|B    ","FIRMWARE IMPENDING FAILURE START UNIT TIMES TOO HIGH"},
  {0x5D,0x67," D|B    ","FIRMWARE IMPENDING FAILURE CHANNEL PARAMETRICS"},
  {0x5D,0x68," D|B    ","FIRMWARE IMPENDING FAILURE CONTROLLER DETECTED"},
  {0x5D,0x69," D|B    ","FIRMWARE IMPENDING FAILURE THROUGHPUT PERFORMANCE"},
  {0x5D,0x6A," D|B    ","FIRMWARE IMPENDING FAILURE SEEK TIME PERFORMANCE"},
  {0x5D,0x6B," D|B    ","FIRMWARE IMPENDING FAILURE SPIN-UP RETRY COUNT"},
  {0x5D,0x6C," D|B    ","FIRMWARE IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT"},
  {0x5D,0xFF," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","FAILURE PREDICTION THRESHOLD EXCEEDED (FALSE)"},
  {0x5E,0x00," D|T|L|P|W|R|O|A|K   ","LOW POWER CONDITION ON"},
  {0x5E,0x01," D|T|L|P|W|R|O|A|K   ","IDLE CONDITION ACTIVATED BY TIMER"},
  {0x5E,0x02," D|T|L|P|W|R|O|A|K   ","STANDBY CONDITION ACTIVATED BY TIMER"},
  {0x5E,0x03," D|T|L|P|W|R|O|A|K   ","IDLE CONDITION ACTIVATED BY COMMAND"},
  {0x5E,0x04," D|T|L|P|W|R|O|A|K   ","STANDBY CONDITION ACTIVATED BY COMMAND"},
  {0x5E,0x05," D|T|L|P|W|R|O|A|K   ","IDLE_B CONDITION ACTIVATED BY TIMER"},
  {0x5E,0x06," D|T|L|P|W|R|O|A|K   ","IDLE_B CONDITION ACTIVATED BY COMMAND"},
  {0x5E,0x07," D|T|L|P|W|R|O|A|K   ","IDLE_C CONDITION ACTIVATED BY TIMER"},
  {0x5E,0x08," D|T|L|P|W|R|O|A|K   ","IDLE_C CONDITION ACTIVATED BY COMMAND"},
  {0x5E,0x09," D|T|L|P|W|R|O|A|K   ","STANDBY_Y CONDITION ACTIVATED BY TIMER"},
  {0x5E,0x0A," D|T|L|P|W|R|O|A|K   ","STANDBY_Y CONDITION ACTIVATED BY COMMAND"},
  {0x5E,0x41,"           B    ","POWER STATE CHANGE TO ACTIVE"},
  {0x5E,0x42,"           B    ","POWER STATE CHANGE TO IDLE"},
  {0x5E,0x43,"           B    ","POWER STATE CHANGE TO STANDBY"},
  {0x5E,0x45,"           B    ","POWER STATE CHANGE TO SLEEP"},
  {0x5E,0x47,"          B|K   ","POWER STATE CHANGE TO DEVICE CONTROL"},
  {0x5F,0x00," 	0      ","Reserved"},
  {0x60,0x00,"  0             ","LAMP FAILURE"},
  {0x61,0x00,"  0             ","VIDEO ACQUISITION ERROR"},
  {0x61,0x01,"  0             ","UNABLE TO ACQUIRE VIDEO"},
  {0x61,0x02,"  0             ","OUT OF FOCUS"},
  {0x62,0x00,"  0             ","SCAN HEAD POSITIONING ERROR"},
  {0x63,0x00,"      R         ","END OF USER AREA ENCOUNTERED ON THIS TRACK"},
  {0x63,0x01,"      R         ","PACKET DOES NOT FIT IN AVAILABLE SPACE"},
  {0x64,0x00,"      R         ","ILLEGAL MODE FOR THIS TRACK"},
  {0x64,0x01,"      R         ","INVALID PACKET SIZE"},
  {0x65,0x00," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","VOLTAGE FAULT"},
  {0x66,0x00,"      0         ","AUTOMATIC DOCUMENT FEEDER COVER UP"},
  {0x66,0x01,"      0         ","AUTOMATIC DOCUMENT FEEDER LIFT UP"},
  {0x66,0x02,"      0         ","DOCUMENT JAM IN AUTOMATIC DOCUMENT FEEDER"},
  {0x66,0x03,"      0         ","DOCUMENT MISS FEED AUTOMATIC IN DOCUMENT FEEDER"},
  {0x67,0x00,"         A      ","CONFIGURATION FAILURE"},
  {0x67,0x01,"         A      ","CONFIGURATION OF INCAPABLE LOGICAL UNITS FAILED"},
  {0x67,0x02,"         A      ","ADD LOGICAL UNIT FAILED"},
  {0x67,0x03,"         A      ","MODIFICATION OF LOGICAL UNIT FAILED"},
  {0x67,0x04,"         A      ","EXCHANGE OF LOGICAL UNIT FAILED"},
  {0x67,0x05,"         A      ","REMOVE OF LOGICAL UNIT FAILED"},
  {0x67,0x06,"         A      ","ATTACHMENT OF LOGICAL UNIT FAILED"},
  {0x67,0x07,"         A      ","CREATION OF LOGICAL UNIT FAILED"},
  {0x67,0x08,"         A      ","ASSIGN FAILURE OCCURRED"},
  {0x67,0x09,"         A      ","MULTIPLY ASSIGNED LOGICAL UNIT"},
  {0x67,0x0A," D|T|L|P|W|R|O|M|A|E|B|K|V|F ","SET TARGET PORT GROUPS COMMAND FAILED"},
  {0x67,0x0B," D|T |       B    ","ATA DEVICE FEATURE NOT ENABLED"},
  {0x68,0x00,"         A      ","LOGICAL UNIT NOT CONFIGURED"},
  {0x69,0x00,"         A      ","DATA LOSS ON LOGICAL UNIT"},
  {0x69,0x01,"         A      ","MULTIPLE LOGICAL UNIT FAILURES"},
  {0x69,0x02,"         A      ","PARITY/DATA MISMATCH"},
  {0x6A,0x00,"         A      ","INFORMATIONAL, REFER TO LOG"},
  {0x6B,0x00,"         A      ","STATE CHANGE HAS OCCURRED"},
  {0x6B,0x01,"         A      ","REDUNDANCY LEVEL GOT BETTER"},
  {0x6B,0x02,"         A      ","REDUNDANCY LEVEL GOT WORSE"},
  {0x6C,0x00,"         A      ","REBUILD FAILURE OCCURRED"},
  {0x6D,0x00,"         A      ","RECALCULATE FAILURE OCCURRED"},
  {0x6E,0x00,"         A      ","COMMAND TO LOGICAL UNIT FAILED"},
  {0x6F,0x00,"      R         ","COPY PROTECTION KEY EXCHANGE FAILURE - AUTHENTICATION FAILURE"},
  {0x6F,0x01,"      R         ","COPY PROTECTION KEY EXCHANGE FAILURE - KEY NOT PRESENT"},
  {0x6F,0x02,"      R         ","COPY PROTECTION KEY EXCHANGE FAILURE - KEY NOT ESTABLISHED"},
  {0x6F,0x03,"      R         ","READ OF SCRAMBLED SECTOR WITHOUT AUTHENTICATION"},
  {0x6F,0x04,"      R         ","MEDIA REGION CODE IS MISMATCHED TO LOGICAL UNIT REGION"},
  {0x6F,0x05,"      R         ","DRIVE REGION MUST BE PERMANENT/REGION RESET COUNT ERROR"},
  {0x6F,0x06,"      R         ","INSUFFICIENT BLOCK COUNT FOR BINDING NONCE RECORDING"},
  {0x6F,0x07,"      R         ","CONFLICT IN BINDING NONCE RECORDING"},
  {0x70,0x80/*NN*/,"  T       ","DECOMPRESSION EXCEPTION SHORT ALGORITHM ID OF NN"},
  {0x71,0x00,"  T             ","DECOMPRESSION EXCEPTION LONG ALGORITHM ID"},
  {0x72,0x00,"      R         ","SESSION FIXATION ERROR"},
  {0x72,0x01,"      R         ","SESSION FIXATION ERROR WRITING LEAD-IN"},
  {0x72,0x02,"      R         ","SESSION FIXATION ERROR WRITING LEAD-OUT"},
  {0x72,0x03,"      R         ","SESSION FIXATION ERROR - INCOMPLETE TRACK IN SESSION"},
  {0x72,0x04,"      R         ","EMPTY OR PARTIALLY WRITTEN RESERVED TRACK"},
  {0x72,0x05,"      R         ","NO MORE TRACK RESERVATIONS ALLOWED"},
  {0x72,0x06,"      R         ","RMZ EXTENSION IS NOT ALLOWED"},
  {0x72,0x07,"      R         ","NO MORE TEST ZONE EXTENSIONS ARE ALLOWED"},
  {0x73,0x00,"      R         ","CD CONTROL ERROR"},
  {0x73,0x01,"      R         ","POWER CALIBRATION AREA ALMOST FULL"},
  {0x73,0x02,"      R         ","POWER CALIBRATION AREA IS FULL"},
  {0x73,0x03,"      R         ","POWER CALIBRATION AREA ERROR"},
  {0x73,0x04,"      R         ","PROGRAM MEMORY AREA UPDATE FAILURE"},
  {0x73,0x05,"      R         ","PROGRAM MEMORY AREA IS FULL"},
  {0x73,0x06,"      R         ","RMA/PMA IS ALMOST FULL"},
  {0x73,0x10,"      R         ","CURRENT POWER CALIBRATION AREA ALMOST FULL"},
  {0x73,0x11,"      R         ","CURRENT POWER CALIBRATION AREA IS FULL"},
  {0x73,0x17,"      R         ","RDZ IS FULL"},
  {0x74,0x00,"  T             ","SECURITY ERROR"},
  {0x74,0x01,"  T             ","UNABLE TO DECRYPT DATA"},
  {0x74,0x02,"  T             ","UNENCRYPTED DATA ENCOUNTERED WHILE DECRYPTING"},
  {0x74,0x03,"  T             ","INCORRECT DATA ENCRYPTION KEY"},
  {0x74,0x04,"  T             ","CRYPTOGRAPHIC INTEGRITY VALIDATION FAILED"},
  {0x74,0x05,"  T             ","ERROR DECRYPTING DATA"},
  {0x74,0x06,"  T             ","UNKNOWN SIGNATURE VERIFICATION KEY"},
  {0x74,0x07,"  T             ","ENCRYPTION PARAMETERS NOT USEABLE"},
  {0x74,0x08," D|T|   R| M| E | V|F ","DIGITAL SIGNATURE VALIDATION FAILURE"},
  {0x74,0x09,"  T             ","ENCRYPTION MODE MISMATCH ON READ"},
  {0x74,0x0A,"  T             ","ENCRYPTED BLOCK NOT RAW READ ENABLED"},
  {0x74,0x0B,"  T             ","INCORRECT ENCRYPTION PARAMETERS"},
  {0x74,0x0C," D|T |  R| M|A|E|B|K|V  ","UNABLE TO DECRYPT PARAMETER LIST"},
  {0x74,0x0D,"  T             ","ENCRYPTION ALGORITHM DISABLED"},
  {0x74,0x10," D|T  | R |M|A|E|B|K|V  ","SA CREATION PARAMETER VALUE INVALID"},
  {0x74,0x11," D|T  | R |M|A|E|B|K|V  ","SA CREATION PARAMETER VALUE REJECTED"},
  {0x74,0x12," D|T  | R |M|A|E|B|K|V  ","INVALID SA USAGE"},
  {0x74,0x21,"  T             ","DATA ENCRYPTION CONFIGURATION PREVENTED"},
  {0x74,0x30," D|T  | R |M|A|E|B|K|V  ","SA CREATION PARAMETER NOT SUPPORTED"},
  {0x74,0x40," D|T  | R |M|A|E|B|K|V  ","AUTHENTICATION FAILED"},
  {0x74,0x61,"             V  ","EXTERNAL DATA ENCRYPTION KEY MANAGER ACCESS ERROR"},
  {0x74,0x62,"             V  ","EXTERNAL DATA ENCRYPTION KEY MANAGER ERROR"},
  {0x74,0x63,"             V  ","EXTERNAL DATA ENCRYPTION KEY NOT FOUND"},
  {0x74,0x64,"             V  ","EXTERNAL DATA ENCRYPTION REQUEST NOT AUTHORIZED"},
  {0x74,0x6E,"  T             ","EXTERNAL DATA ENCRYPTION CONTROL TIMEOUT"},
  {0x74,0x6F,"  T             ","EXTERNAL DATA ENCRYPTION CONTROL ERROR"},
  {0x74,0x71," D|T |  R| M |E|  V  ","LOGICAL UNIT ACCESS NOT AUTHORIZED"},
  {0x74,0x79," D              ","SECURITY CONFLICT IN TRANSLATED DEVICE"},
  {0, 0, NULL, NULL}
};

