/* $Id: xmsprint.c,v 1.1 2011/06/01 02:42:25 ve3wwg Exp $
 * Warren W. Gay VE3WWG		Sat Mar  1 14:04:46 1997
 *
 * Format a string: XmString XmSprintf(format,...)
 *
 * 	X LessTif WAV Play :
 * 
 * 	Copyright (C) 1997  Warren W. Gay VE3WWG
 * 
 * This  program is free software; you can redistribute it and/or modify it
 * under the  terms  of  the GNU General Public License as published by the
 * Free Software Foundation.
 * 
 * This  program  is  distributed  in  the hope that it will be useful, but
 * WITHOUT   ANY   WARRANTY;   without   even  the   implied   warranty  of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details (licensed by file COPYING or GPLv*).
 */
static const char rcsid[] = "$Id: xmsprint.c,v 1.1 2011/06/01 02:42:25 ve3wwg Exp $";

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include "xmsprint.h"

/*
 * This function returns a formatted XmString
 */
XmString
XmSprintf(const char *format,...) {
	char buf[2048];
	va_list ap;

	/*
	 * First format the message:
	 */
	va_start(ap,format);
	vsprintf(buf,format,ap);
	va_end(ap);
	
	/*
	 * Now create the XmString to return:
	 */
	return XmStringCreateLtoR(buf,(char *)XmSTRING_DEFAULT_CHARSET);
}

/*
 * This function does a sprintf() into a label widget:
 */
void
XmSprintfLabel(Widget w,const char *format,...) {
	char buf[2048];
	va_list ap;
	XmString s;

	/*
	 * First format the message:
	 */
	va_start(ap,format);
	vsprintf(buf,format,ap);
	va_end(ap);
	
	/*
	 * Now create the XmString to return:
	 */
	s = XmStringCreateLtoR(buf,(char *)XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(w,XmNlabelString,s,NULL);
	XmStringFree(s);
}

/*
 * This function does a sprintf() into a text widget:
 */
void
XmSprintfText(Widget w,const char *format,...) {
	char buf[2048];
	va_list ap;

	/*
	 * First format the message:
	 */
	va_start(ap,format);
	vsprintf(buf,format,ap);
	va_end(ap);
	
	XmTextSetString(w,buf);					/* Set text in widget now */
	XmTextSetInsertionPosition(w,0);			/* Put cursor at start of field */
}

/*
 * Return an ascii string date, without the newline:
 */
char *
StrDate(time_t td) {
	char *cp;
	static char stbuf[64];

	strcpy(stbuf,ctime(&td));
	if ( (cp = strchr(stbuf,'\n')) != NULL )
		*cp = 0;					/* Stomp on the newline */	
	return stbuf;
}

/* $Source: /cvsroot/wavplay/code/src/xmsprint.c,v $ */
