/*++

Copyright (C) 2019 Calculation developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++-Header file in order to allow an easy
 use of Calculation library

Interface version: 1.0.0

*/

#ifndef __CALCULATION_CPPHEADER_IMPLICIT_CPP
#define __CALCULATION_CPPHEADER_IMPLICIT_CPP

#include "calculation_types.hpp"
#include "calculation_abi.hpp"

#include "numbers_dynamic.hpp"

#ifdef _WIN32
#include <windows.h>
#else // _WIN32
#include <dlfcn.h>
#endif // _WIN32
#include <string>
#include <memory>
#include <vector>
#include <exception>

namespace Calculation {

/*************************************************************************************************************************
 Forward Declaration of all classes
**************************************************************************************************************************/
class CWrapper;
class CBase;
class CCalculator;

/*************************************************************************************************************************
 Declaration of deprecated class types
**************************************************************************************************************************/
typedef CWrapper CCalculationWrapper;
typedef CBase CCalculationBase;
typedef CCalculator CCalculationCalculator;

/*************************************************************************************************************************
 Declaration of shared pointer types
**************************************************************************************************************************/
typedef std::shared_ptr<CWrapper> PWrapper;
typedef std::shared_ptr<CBase> PBase;
typedef std::shared_ptr<CCalculator> PCalculator;

/*************************************************************************************************************************
 Declaration of deprecated shared pointer types
**************************************************************************************************************************/
typedef PWrapper PCalculationWrapper;
typedef PBase PCalculationBase;
typedef PCalculator PCalculationCalculator;


/*************************************************************************************************************************
 Class ECalculationException 
**************************************************************************************************************************/
class ECalculationException : public std::exception {
protected:
	/**
	* Error code for the Exception.
	*/
	CalculationResult m_errorCode;
	/**
	* Error message for the Exception.
	*/
	std::string m_errorMessage;

public:
	/**
	* Exception Constructor.
	*/
	ECalculationException(CalculationResult errorCode, const std::string & sErrorMessage)
		: m_errorMessage("Calculation Error " + std::to_string(errorCode) + " (" + sErrorMessage + ")")
	{
		m_errorCode = errorCode;
	}

	/**
	* Returns error code
	*/
	CalculationResult getErrorCode() const noexcept
	{
		return m_errorCode;
	}

	/**
	* Returns error message
	*/
	const char* what() const noexcept
	{
		return m_errorMessage.c_str();
	}

};

/*************************************************************************************************************************
 Class CInputVector
**************************************************************************************************************************/
template <typename T>
class CInputVector {
private:
	
	const T* m_data;
	size_t m_size;
	
public:
	
	CInputVector( const std::vector<T>& vec)
		: m_data( vec.data() ), m_size( vec.size() )
	{
	}
	
	CInputVector( const T* in_data, size_t in_size)
		: m_data( in_data ), m_size(in_size )
	{
	}
	
	const T* data() const
	{
		return m_data;
	}
	
	size_t size() const
	{
		return m_size;
	}
	
};

// declare deprecated class name
template<typename T>
using CCalculationInputVector = CInputVector<T>;

/*************************************************************************************************************************
 Class CWrapper 
**************************************************************************************************************************/
class CWrapper {
public:
	
	CWrapper()
	{
	}
	
	~CWrapper()
	{
	}
	static inline PWrapper loadLibrary()
	{
		return std::make_shared<CWrapper>();
	}
	
	inline void CheckError(CBase * pBaseClass, CalculationResult nResult);

	inline PCalculator CreateCalculator();
	inline void GetVersion(Calculation_uint32 & nMajor, Calculation_uint32 & nMinor, Calculation_uint32 & nMicro);
	inline bool GetLastError(CBase * pInstance, std::string & sErrorMessage);
	inline void ReleaseInstance(CBase * pInstance);
	inline void AcquireInstance(CBase * pInstance);
	inline void InjectComponent(const std::string & sNameSpace, const Calculation_pvoid pSymbolAddressMethod);
	inline Calculation_pvoid GetSymbolLookupMethod();

private:
	// Injected Components
	Numbers::PWrapper m_pNumbersWrapper;

	
	CalculationResult checkBinaryVersion()
	{
		Calculation_uint32 nMajor, nMinor, nMicro;
		GetVersion(nMajor, nMinor, nMicro);
		if ( (nMajor != CALCULATION_VERSION_MAJOR) || (nMinor < CALCULATION_VERSION_MINOR) ) {
			return CALCULATION_ERROR_INCOMPATIBLEBINARYVERSION;
		}
		return CALCULATION_SUCCESS;
	}

	friend class CBase;
	friend class CCalculator;

};

	
/*************************************************************************************************************************
 Class CBase 
**************************************************************************************************************************/
class CBase {
public:
	
protected:
	/* Wrapper Object that created the class. */
	CWrapper * m_pWrapper;
	/* Handle to Instance in library*/
	CalculationHandle m_pHandle;

	/* Checks for an Error code and raises Exceptions */
	void CheckError(CalculationResult nResult)
	{
		if (m_pWrapper != nullptr)
			m_pWrapper->CheckError(this, nResult);
	}
public:
	/**
	* CBase::CBase - Constructor for Base class.
	*/
	CBase(CWrapper * pWrapper, CalculationHandle pHandle)
		: m_pWrapper(pWrapper), m_pHandle(pHandle)
	{
	}

	/**
	* CBase::~CBase - Destructor for Base class.
	*/
	virtual ~CBase()
	{
		if (m_pWrapper != nullptr)
			m_pWrapper->ReleaseInstance(this);
		m_pWrapper = nullptr;
	}

	/**
	* CBase::GetHandle - Returns handle to instance.
	*/
	CalculationHandle GetHandle()
	{
		return m_pHandle;
	}
	
	friend class CWrapper;
};
	
/*************************************************************************************************************************
 Class CCalculator 
**************************************************************************************************************************/
class CCalculator : public CBase {
public:
	
	/**
	* CCalculator::CCalculator - Constructor for Calculator class.
	*/
	CCalculator(CWrapper* pWrapper, CalculationHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline void EnlistVariable(Numbers::CVariable * pVariable);
	inline Numbers::PVariable GetEnlistedVariable(const Calculation_uint32 nIndex);
	inline void ClearVariables();
	inline Numbers::PVariable Multiply();
	inline Numbers::PVariable Add();
};
	
	/**
	* CWrapper::CreateCalculator - Creates a new Calculator instance
	* @return New Calculator instance
	*/
	inline PCalculator CWrapper::CreateCalculator()
	{
		CalculationHandle hInstance = nullptr;
		CheckError(nullptr,calculation_createcalculator(&hInstance));
		
		if (!hInstance) {
			CheckError(nullptr,CALCULATION_ERROR_INVALIDPARAM);
		}
		return std::make_shared<CCalculator>(this, hInstance);
	}
	
	/**
	* CWrapper::GetVersion - retrieves the binary version of this library.
	* @param[out] nMajor - returns the major version of this library
	* @param[out] nMinor - returns the minor version of this library
	* @param[out] nMicro - returns the micro version of this library
	*/
	inline void CWrapper::GetVersion(Calculation_uint32 & nMajor, Calculation_uint32 & nMinor, Calculation_uint32 & nMicro)
	{
		CheckError(nullptr,calculation_getversion(&nMajor, &nMinor, &nMicro));
	}
	
	/**
	* CWrapper::GetLastError - Returns the last error recorded on this object
	* @param[in] pInstance - Instance Handle
	* @param[out] sErrorMessage - Message of the last error
	* @return Is there a last error to query
	*/
	inline bool CWrapper::GetLastError(CBase * pInstance, std::string & sErrorMessage)
	{
		CalculationHandle hInstance = nullptr;
		if (pInstance != nullptr) {
			hInstance = pInstance->GetHandle();
		};
		Calculation_uint32 bytesNeededErrorMessage = 0;
		Calculation_uint32 bytesWrittenErrorMessage = 0;
		bool resultHasError = 0;
		CheckError(nullptr,calculation_getlasterror(hInstance, 0, &bytesNeededErrorMessage, nullptr, &resultHasError));
		std::vector<char> bufferErrorMessage(bytesNeededErrorMessage);
		CheckError(nullptr,calculation_getlasterror(hInstance, bytesNeededErrorMessage, &bytesWrittenErrorMessage, &bufferErrorMessage[0], &resultHasError));
		sErrorMessage = std::string(&bufferErrorMessage[0]);
		
		return resultHasError;
	}
	
	/**
	* CWrapper::ReleaseInstance - Releases shared ownership of an Instance
	* @param[in] pInstance - Instance Handle
	*/
	inline void CWrapper::ReleaseInstance(CBase * pInstance)
	{
		CalculationHandle hInstance = nullptr;
		if (pInstance != nullptr) {
			hInstance = pInstance->GetHandle();
		};
		CheckError(nullptr,calculation_releaseinstance(hInstance));
	}
	
	/**
	* CWrapper::AcquireInstance - Acquires shared ownership of an Instance
	* @param[in] pInstance - Instance Handle
	*/
	inline void CWrapper::AcquireInstance(CBase * pInstance)
	{
		CalculationHandle hInstance = nullptr;
		if (pInstance != nullptr) {
			hInstance = pInstance->GetHandle();
		};
		CheckError(nullptr,calculation_acquireinstance(hInstance));
	}
	
	/**
	* CWrapper::InjectComponent - Injects an imported component for usage within this component
	* @param[in] sNameSpace - NameSpace of the injected component
	* @param[in] pSymbolAddressMethod - Address of the SymbolAddressMethod of the injected component
	*/
	inline void CWrapper::InjectComponent(const std::string & sNameSpace, const Calculation_pvoid pSymbolAddressMethod)
	{
		CheckError(nullptr,calculation_injectcomponent(sNameSpace.c_str(), pSymbolAddressMethod));
		
		bool bNameSpaceFound = false;
		if (sNameSpace == "Numbers") {
			if (m_pNumbersWrapper != nullptr) {
				throw ECalculationException(CALCULATION_ERROR_COULDNOTLOADLIBRARY, "Library with namespace " + sNameSpace + " is already registered.");
			}
			m_pNumbersWrapper = Numbers::CWrapper::loadLibraryFromSymbolLookupMethod(pSymbolAddressMethod);
			bNameSpaceFound = true;
		}
		if (!bNameSpaceFound)
			throw ECalculationException(CALCULATION_ERROR_COULDNOTLOADLIBRARY, "Unknown namespace " + sNameSpace);
	}
	
	/**
	* CWrapper::GetSymbolLookupMethod - Returns the address of the SymbolLookupMethod
	* @return Address of the SymbolAddressMethod
	*/
	inline Calculation_pvoid CWrapper::GetSymbolLookupMethod()
	{
		Calculation_pvoid resultSymbolLookupMethod = 0;
		CheckError(nullptr,calculation_getsymbollookupmethod(&resultSymbolLookupMethod));
		
		return resultSymbolLookupMethod;
	}
	
	inline void CWrapper::CheckError(CBase * pBaseClass, CalculationResult nResult)
	{
		if (nResult != 0) {
			std::string sErrorMessage;
			if (pBaseClass != nullptr) {
				GetLastError(pBaseClass, sErrorMessage);
			}
			throw ECalculationException(nResult, sErrorMessage);
		}
	}
	

	
	/**
	 * Method definitions for class CBase
	 */
	
	/**
	 * Method definitions for class CCalculator
	 */
	
	/**
	* CCalculator::EnlistVariable - Adds a Variable to the list of Variables this calculator works on
	* @param[in] pVariable - The new variable in this calculator
	*/
	void CCalculator::EnlistVariable(Numbers::CVariable * pVariable)
	{
		NumbersHandle hVariable = nullptr;
		if (pVariable != nullptr) {
			hVariable = pVariable->GetHandle();
		};
		CheckError(calculation_calculator_enlistvariable(m_pHandle, hVariable));
	}
	
	/**
	* CCalculator::GetEnlistedVariable - Returns an instance of a enlisted variable
	* @param[in] nIndex - The index of the variable to query
	* @return The Index-th variable in this calculator
	*/
	Numbers::PVariable CCalculator::GetEnlistedVariable(const Calculation_uint32 nIndex)
	{
		CalculationHandle hVariable = nullptr;
		CheckError(calculation_calculator_getenlistedvariable(m_pHandle, nIndex, &hVariable));
		
		if (!hVariable) {
			CheckError(CALCULATION_ERROR_INVALIDPARAM);
		}
		return std::make_shared<Numbers::CVariable>(m_pWrapper->m_pNumbersWrapper.get(), hVariable);
	}
	
	/**
	* CCalculator::ClearVariables - Clears all variables in enlisted in this calculator
	*/
	void CCalculator::ClearVariables()
	{
		CheckError(calculation_calculator_clearvariables(m_pHandle));
	}
	
	/**
	* CCalculator::Multiply - Multiplies all enlisted variables
	* @return Variable that holds the product of all enlisted Variables
	*/
	Numbers::PVariable CCalculator::Multiply()
	{
		CalculationHandle hInstance = nullptr;
		CheckError(calculation_calculator_multiply(m_pHandle, &hInstance));
		
		if (!hInstance) {
			CheckError(CALCULATION_ERROR_INVALIDPARAM);
		}
		return std::make_shared<Numbers::CVariable>(m_pWrapper->m_pNumbersWrapper.get(), hInstance);
	}
	
	/**
	* CCalculator::Add - Sums all enlisted variables
	* @return Variable that holds the sum of all enlisted Variables
	*/
	Numbers::PVariable CCalculator::Add()
	{
		CalculationHandle hInstance = nullptr;
		CheckError(calculation_calculator_add(m_pHandle, &hInstance));
		
		if (!hInstance) {
			CheckError(CALCULATION_ERROR_INVALIDPARAM);
		}
		return std::make_shared<Numbers::CVariable>(m_pWrapper->m_pNumbersWrapper.get(), hInstance);
	}

} // namespace Calculation

#endif // __CALCULATION_CPPHEADER_IMPLICIT_CPP

