# Contributor's Guide
The Automatic Component Toolkit is an open source project.

Contributions are welcome and we are looking for people that can improve existing language bindings or create new bindings or implementation stubs.

You can also contribute by reporting bugs in the [Issue tracker](../../issues), helping review pull requests, participate in discussions about issues and more.

## Filing issues
1. When filing an [issue](../../issues) to report errors or problems, make sure to answer these five questions:
	1. Which version of ACT are you using?
		Run <br/>`act.* -v`<br/> to print ACT's version.
	2. Which operating system, programming language(s) and development tools (compiler/interpreter) are you using?
	3. What did you do?
	4. What did you expect to see?
	5. What did you see instead?

2. When contributing to this repository, please first discuss the change you wish to make via issue with the [maintainers](#maintainers) of this repository. This way, we can ensure that there is no overlap between contributions or internal development work.

3. Adhere to the [code of conduct](CODE_OF_CONDUCT.md).

## Submitting a pull request
When ready to contribute, fork this repository and submit a pull request that references the issue it resolves. Be sure to include a clear and detailed description of the changes you've made so that we can verify them and eventually merge.

ACT follows the [git-flow](https://www.atlassian.com/git/tutorials/comparing-workflows/gitflow-workflow) branching model. New developments are integrated into the [develop](../../tree/develop)-branch. ACT's maintainers will create releases from the develop-branch when appropriate.

__NOTE__ _Before your code can be accepted into the project you must also sign the Contributor License Agreement (CLA). Please contact the maintainers via automatic-component-toolkit.contributor.agreements@autodesk.com for a copy of the CLA._


## Maintainers
Maintainers are responsible for responding to pull requests and issues, as well as guiding the direction of the project.

We currently have two maintainers:
- Alexander Oster alexander.oster@autodesk.com
- Martin Weismann martin.weismann@autodesk.com

If you've established yourself as an impactful contributor to the project, and are willing take on the extra work, we'd love to have your help maintaining it! Email the current maintainers for details.
