# AMD GPU Helm Chart

![Version: 0.2.0](https://img.shields.io/badge/Version-0.2.0-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 1.18.0](https://img.shields.io/badge/AppVersion-1.18.0-informational?style=flat-square)

A Helm chart for deploying Kubernetes AMD GPU device plugin

## Requirements

Kubernetes: `>= 1.18.0`

## Optional Dependencies

| Repository | Name | Version |
|------------|------|---------|
| https://kubernetes-sigs.github.io/node-feature-discovery/charts | node-feature-discovery | 0.8.1 |

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| dp.image.repository | string | `"docker.io/rocm/k8s-device-plugin"` |  |
| dp.image.tag | string | `""` |  |
| imagePullSecrets | list | `[]` |  |
| labeller.enabled | bool | `false` |  |
| lbl.image.repository | string | `"docker.io/rocm/k8s-device-plugin"` |  |
| lbl.image.tag | string | `"labeller-latest"` |  |
| namespace | string | `"kube-system"` |  |
| nfd.enabled | bool | `false` |  |
| node_selector."feature.node.kubernetes.io/pci-0300_1002.present" | string | `"true"` |  |
| securityContext.allowPrivilegeEscalation | bool | `false` |  |
| securityContext.capabilities.drop[0] | string | `"ALL"` |  |
| tolerations[0].key | string | `"CriticalAddonsOnly"` |  |
| tolerations[0].operator | string | `"Exists"` |  |

## More information

https://github.com/RadeonOpenCompute/k8s-device-plugin

----------------------------------------------
Autogenerated from chart metadata using [helm-docs v1.5.0](https://github.com/norwoodj/helm-docs/releases/v1.5.0)
