/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.util.FilenameUtils;
import org.apache.maven.scm.util.ThreadSafeDateFormat;
import org.codehaus.plexus.util.StringUtils;

public class ChangeSet
implements Serializable {
    private static final long serialVersionUID = 7097705862222539801L;
    public static final String LESS_THAN_ENTITY = "&lt;";
    public static final String GREATER_THAN_ENTITY = "&gt;";
    public static final String AMPERSAND_ENTITY = "&amp;";
    public static final String APOSTROPHE_ENTITY = "&apos;";
    public static final String QUOTE_ENTITY = "&quot;";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final ThreadSafeDateFormat DATE_FORMAT = new ThreadSafeDateFormat("yyyy-MM-dd");
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final ThreadSafeDateFormat TIME_FORMAT = new ThreadSafeDateFormat("HH:mm:ss");
    private static final ThreadSafeDateFormat TIMESTAMP_FORMAT_1 = new ThreadSafeDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final ThreadSafeDateFormat TIMESTAMP_FORMAT_2 = new ThreadSafeDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final ThreadSafeDateFormat TIMESTAMP_FORMAT_3 = new ThreadSafeDateFormat("yyyy/MM/dd HH:mm:ss z");
    private static final ThreadSafeDateFormat TIMESTAMP_FORMAT_4 = new ThreadSafeDateFormat("yyyy-MM-dd HH:mm:ss z");
    private Date date;
    private String author;
    private String comment = "";
    private List files;
    private String revision;

    public ChangeSet(String strDate, String userDatePattern, String comment, String author, List files) {
        this(null, comment, author, files);
        this.setDate(strDate, userDatePattern);
    }

    public ChangeSet(Date date, String comment, String author, List files) {
        this.setDate(date);
        this.setAuthor(author);
        this.setComment(comment);
        this.files = files;
    }

    public ChangeSet() {
    }

    public List getFiles() {
        if (this.files == null) {
            return new ArrayList();
        }
        return this.files;
    }

    public void setFiles(List files) {
        this.files = files;
    }

    public void addFile(ChangeFile file) {
        if (this.files == null) {
            this.files = new ArrayList();
        }
        this.files.add(file);
    }

    public boolean containsFilename(String filename, ScmProviderRepository repository) {
        return this.containsFilename(filename);
    }

    public boolean containsFilename(String filename) {
        if (this.files != null) {
            Iterator i = this.files.iterator();
            while (i.hasNext()) {
                String f2;
                ChangeFile file = (ChangeFile)i.next();
                String f1 = FilenameUtils.normalizeFilename(file.getName());
                if (f1.indexOf(f2 = FilenameUtils.normalizeFilename(filename)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getDate() {
        if (this.date != null) {
            return (Date)this.date.clone();
        }
        return null;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.date = new Date(date.getTime());
        }
    }

    public void setDate(String date) {
        this.setDate(date, null);
    }

    public void setDate(String date, String userDatePattern) {
        block19: {
            try {
                if (!StringUtils.isEmpty(userDatePattern)) {
                    SimpleDateFormat format = new SimpleDateFormat(userDatePattern);
                    this.date = format.parse(date);
                } else {
                    this.date = TIMESTAMP_FORMAT_3.parse(date);
                }
            }
            catch (ParseException e) {
                if (!StringUtils.isEmpty(userDatePattern)) {
                    try {
                        this.date = TIMESTAMP_FORMAT_3.parse(date);
                    }
                    catch (ParseException pe) {
                        try {
                            this.date = TIMESTAMP_FORMAT_4.parse(date);
                            break block19;
                        }
                        catch (ParseException pe1) {
                            try {
                                this.date = TIMESTAMP_FORMAT_1.parse(date);
                                break block19;
                            }
                            catch (ParseException pe2) {
                                try {
                                    this.date = TIMESTAMP_FORMAT_2.parse(date);
                                    break block19;
                                }
                                catch (ParseException pe3) {
                                    throw new IllegalArgumentException("Unable to parse date: " + date);
                                }
                            }
                        }
                    }
                }
                try {
                    this.date = TIMESTAMP_FORMAT_4.parse(date);
                }
                catch (ParseException pe1) {
                    try {
                        this.date = TIMESTAMP_FORMAT_1.parse(date);
                    }
                    catch (ParseException pe2) {
                        try {
                            this.date = TIMESTAMP_FORMAT_2.parse(date);
                        }
                        catch (ParseException pe3) {
                            throw new IllegalArgumentException("Unable to parse date: " + date);
                        }
                    }
                }
            }
        }
    }

    public String getDateFormatted() {
        return DATE_FORMAT.format(this.getDate());
    }

    public String getTimeFormatted() {
        return TIME_FORMAT.format(this.getDate());
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.author == null ? " null " : this.author);
        result.append("\n").append(this.date == null ? "null " : this.date.toString()).append("\n");
        if (this.files != null) {
            Iterator i = this.files.iterator();
            while (i.hasNext()) {
                ChangeFile file = (ChangeFile)i.next();
                result.append(file == null ? " null " : file.toString()).append("\n");
            }
        }
        result.append(this.comment == null ? " null " : this.comment);
        return result.toString();
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t<changelog-entry>\n");
        if (this.getDate() != null) {
            buffer.append("\t\t<date pattern=\"yyyy-MM-dd\">").append(this.getDateFormatted()).append("</date>\n").append("\t\t<time pattern=\"HH:mm:ss\">").append(this.getTimeFormatted()).append("</time>\n");
        }
        buffer.append("\t\t<author><![CDATA[").append(this.author).append("]]></author>\n");
        if (this.files != null) {
            Iterator i = this.files.iterator();
            while (i.hasNext()) {
                ChangeFile file = (ChangeFile)i.next();
                buffer.append("\t\t<file>\n").append("\t\t\t<name>").append(ChangeSet.escapeValue(file.getName())).append("</name>\n").append("\t\t\t<revision>").append(file.getRevision()).append("</revision>\n");
                buffer.append("\t\t</file>\n");
            }
        }
        buffer.append("\t\t<msg><![CDATA[").append(this.removeCDataEnd(this.comment)).append("]]></msg>\n");
        buffer.append("\t</changelog-entry>\n");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeSet) {
            ChangeSet changeSet = (ChangeSet)obj;
            if (this.toString().equals(changeSet.toString())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.files == null ? 0 : ((Object)this.files).hashCode());
        return result;
    }

    private String removeCDataEnd(String message) {
        int endCdata;
        while (message != null && (endCdata = message.indexOf("]]>")) > -1) {
            message = message.substring(0, endCdata) + "] ] >" + message.substring(endCdata + 3, message.length());
        }
        return message;
    }

    public static String escapeValue(Object value) {
        StringBuffer buffer = new StringBuffer(value.toString());
        int size = buffer.length();
        block7: for (int i = 0; i < size; ++i) {
            switch (buffer.charAt(i)) {
                case '<': {
                    buffer.replace(i, i + 1, LESS_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    continue block7;
                }
                case '>': {
                    buffer.replace(i, i + 1, GREATER_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    continue block7;
                }
                case '&': {
                    buffer.replace(i, i + 1, AMPERSAND_ENTITY);
                    size += 4;
                    i += 4;
                    continue block7;
                }
                case '\'': {
                    buffer.replace(i, i + 1, APOSTROPHE_ENTITY);
                    size += 5;
                    i += 5;
                    continue block7;
                }
                case '\"': {
                    buffer.replace(i, i + 1, QUOTE_ENTITY);
                    size += 5;
                    i += 5;
                }
            }
        }
        return buffer.toString();
    }
}

