/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import net.pms.PMS;
import net.pms.io.Gob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtil.class);
    private static final int TERM_TIMEOUT = 10000;
    private static final int ALRM_TIMEOUT = 2000;

    public static int waitFor(Process p) {
        int exit = -1;
        try {
            exit = p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        return exit;
    }

    public static Integer getProcessID(Process p) {
        Integer pid = null;
        if (p != null && p.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getInt(p);
            }
            catch (Throwable e) {
                logger.debug("Can't determine the Unix process ID: " + e.getMessage());
            }
        }
        return pid;
    }

    public static void kill(Integer pid) {
        ProcessUtil.kill(pid, 9);
    }

    public static boolean kill(Integer pid, int signal) {
        boolean killed = false;
        logger.warn("Sending kill -" + signal + " to the Unix process: " + pid);
        try {
            Process process = Runtime.getRuntime().exec("kill -" + signal + " " + pid);
            new Gob(process.getErrorStream()).start();
            new Gob(process.getInputStream()).start();
            int exit = ProcessUtil.waitFor(process);
            if (exit == 0) {
                killed = true;
                logger.debug("Successfully sent kill -" + signal + " to the Unix process: " + pid);
            }
        }
        catch (IOException e) {
            logger.error("Error calling: kill -" + signal + " " + pid, e);
        }
        return killed;
    }

    public static void destroy(final Process p) {
        if (p != null) {
            final Integer pid = ProcessUtil.getProcessID(p);
            if (pid != null) {
                logger.trace("Killing the Unix process: " + pid);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            try {
                                p.exitValue();
                            }
                            catch (IllegalThreadStateException itse) {
                                if (ProcessUtil.kill(pid, 14)) break block6;
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                ProcessUtil.kill(pid, 9);
                            }
                        }
                    }
                };
                Thread failsafe = new Thread(r, "Process Destroyer");
                failsafe.start();
            }
            p.destroy();
        }
    }

    public static String getShortFileNameIfWideChars(String name) {
        return PMS.get().getRegistry().getShortPathNameW(name);
    }

    public static String run(String ... cmd) {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((line = br.readLine()) != null) {
                output.append(line).append("\n");
            }
            return output.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

