/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.jna.Platform;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerFactory;
import net.pms.encoders.PlayerPurpose;
import net.pms.newgui.FontFileFilter;
import net.pms.newgui.LooksFrame;
import net.pms.newgui.MyComboBoxModel;
import net.pms.newgui.RestrictedFileSystemView;
import net.pms.newgui.TreeNodeSettings;
import net.pms.newgui.TreeRenderer;
import net.pms.util.FormLayoutUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranscodingTab {
    private static final Logger logger = LoggerFactory.getLogger(TranscodingTab.class);
    private static final String COMMON_COL_SPEC = "left:pref, 3dlu, pref:grow";
    private static final String COMMON_ROW_SPEC = "4*(pref, 3dlu), pref, 9dlu, pref, 9dlu:grow, pref";
    private static final String EMPTY_COL_SPEC = "left:pref, 3dlu, pref:grow";
    private static final String EMPTY_ROW_SPEC = "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p , 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 20dlu, p, 3dlu, p, 3dlu, p";
    private static final String LEFT_COL_SPEC = "left:pref, pref, pref, pref, 0:grow";
    private static final String LEFT_ROW_SPEC = "fill:10:grow, 3dlu, p, 3dlu, p, 3dlu, p";
    private static final String MAIN_COL_SPEC = "left:pref, pref, 7dlu, pref, pref, fill:10:grow";
    private static final String MAIN_ROW_SPEC = "fill:10:grow";
    private final PmsConfiguration configuration;
    private ComponentOrientation orientation;
    private JCheckBox disableSubs;
    private JTextField forcetranscode;
    private JTextField notranscode;
    private JTextField maxbuffer;
    private JComboBox nbcores;
    private Map<PlayerPurpose, DefaultMutableTreeNode> engineTreeNodes;
    private JPanel tabbedPanel;
    private CardLayout cl;
    private JTextField abitrate;
    private JTree tree;
    private JCheckBox forcePCM;
    private JCheckBox forceDTSinPCM;
    private JComboBox channels;
    private JComboBox vq;
    private JCheckBox ac3remux;
    private JCheckBox mpeg2remux;
    private JCheckBox chapter_support;
    private JTextField chapter_interval;
    private JCheckBox videoHWacceleration;
    private JTextField langs;
    private JTextField defaultsubs;
    private JTextField forcedsub;
    private JTextField forcedtags;
    private JTextField alternateSubFolder;
    private JButton folderSelectButton;
    private JCheckBox subs;
    private JTextField defaultaudiosubs;
    private JComboBox subtitleCodePage;
    private JTextField defaultfont;
    private JButton fontselect;
    private JCheckBox fribidi;
    private JTextField ass_scale;
    private JTextField ass_outline;
    private JTextField ass_shadow;
    private JTextField ass_margin;
    private JButton subColor;
    private static final int MAX_CORES = 16;

    TranscodingTab(PmsConfiguration configuration) {
        this.configuration = configuration;
        Locale locale = new Locale(configuration.getLanguage());
        this.orientation = ComponentOrientation.getOrientation(locale);
    }

    private void updateEngineModel() {
        ArrayList<String> engines = new ArrayList<String>();
        Object root = this.tree.getModel().getRoot();
        for (int i = 0; i < this.tree.getModel().getChildCount(root); ++i) {
            Object firstChild = this.tree.getModel().getChild(root, i);
            if (this.tree.getModel().isLeaf(firstChild)) continue;
            for (int j = 0; j < this.tree.getModel().getChildCount(firstChild); ++j) {
                TreeNodeSettings tns;
                Object secondChild = this.tree.getModel().getChild(firstChild, j);
                if (!(secondChild instanceof TreeNodeSettings) || !(tns = (TreeNodeSettings)secondChild).isEnable() || tns.getPlayer() == null) continue;
                engines.add(tns.getPlayer().id());
            }
        }
        this.configuration.setEnginesAsList(engines);
    }

    private void handleCardComponentChange(Component component) {
        this.tabbedPanel.setPreferredSize(component.getPreferredSize());
        this.tabbedPanel.getParent().invalidate();
        this.tabbedPanel.getParent().validate();
        this.tabbedPanel.getParent().repaint();
    }

    public JComponent build() {
        String colSpec = FormLayoutUtil.getColSpec(MAIN_COL_SPEC, this.orientation);
        FormLayout mainlayout = new FormLayout(colSpec, MAIN_ROW_SPEC);
        PanelBuilder builder = new PanelBuilder(mainlayout);
        builder.setBorder(Borders.DLU4_BORDER);
        builder.setOpaque(true);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.buildRightTabbedPanel(), FormLayoutUtil.flip(cc.xyw(4, 1, 3), colSpec, this.orientation));
        builder.add((Component)this.buildLeft(), FormLayoutUtil.flip(cc.xy(2, 1), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private JComponent buildRightTabbedPanel() {
        this.cl = new CardLayout();
        this.tabbedPanel = new JPanel(this.cl);
        this.tabbedPanel.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane scrollPane = new JScrollPane(this.tabbedPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    public JComponent buildLeft() {
        String colSpec = FormLayoutUtil.getColSpec(LEFT_COL_SPEC, this.orientation);
        FormLayout layout = new FormLayout(colSpec, LEFT_ROW_SPEC);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        JButton but = new JButton(LooksFrame.readImageIcon("kdevelop_down-32.png"));
        but.setToolTipText(Messages.getString("TrTab2.6"));
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeModel dtm;
                int index;
                TreeNodeSettings node;
                TreePath path = TranscodingTab.this.tree.getSelectionModel().getSelectionPath();
                if (path != null && path.getLastPathComponent() instanceof TreeNodeSettings && (node = (TreeNodeSettings)path.getLastPathComponent()).getPlayer() != null && (index = (dtm = (DefaultTreeModel)TranscodingTab.this.tree.getModel()).getIndexOfChild(node.getParent(), node)) < node.getParent().getChildCount() - 1) {
                    dtm.insertNodeInto(node, (DefaultMutableTreeNode)node.getParent(), index + 1);
                    dtm.reload();
                    for (int i = 0; i < TranscodingTab.this.tree.getRowCount(); ++i) {
                        TranscodingTab.this.tree.expandRow(i);
                    }
                    TranscodingTab.this.tree.getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
                    TranscodingTab.this.updateEngineModel();
                }
            }
        });
        builder.add((Component)but, FormLayoutUtil.flip(cc.xy(2, 3), colSpec, this.orientation));
        JButton but2 = new JButton(LooksFrame.readImageIcon("up-32.png"));
        but2.setToolTipText(Messages.getString("TrTab2.6"));
        but2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeModel dtm;
                int index;
                TreeNodeSettings node;
                TreePath path = TranscodingTab.this.tree.getSelectionModel().getSelectionPath();
                if (path != null && path.getLastPathComponent() instanceof TreeNodeSettings && (node = (TreeNodeSettings)path.getLastPathComponent()).getPlayer() != null && (index = (dtm = (DefaultTreeModel)TranscodingTab.this.tree.getModel()).getIndexOfChild(node.getParent(), node)) != 0) {
                    dtm.insertNodeInto(node, (DefaultMutableTreeNode)node.getParent(), index - 1);
                    dtm.reload();
                    for (int i = 0; i < TranscodingTab.this.tree.getRowCount(); ++i) {
                        TranscodingTab.this.tree.expandRow(i);
                    }
                    TranscodingTab.this.tree.getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
                    TranscodingTab.this.updateEngineModel();
                }
            }
        });
        builder.add((Component)but2, FormLayoutUtil.flip(cc.xy(3, 3), colSpec, this.orientation));
        JButton but3 = new JButton(LooksFrame.readImageIcon("connect_no-32.png"));
        but3.setToolTipText(Messages.getString("TrTab2.0"));
        but3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = TranscodingTab.this.tree.getSelectionModel().getSelectionPath();
                if (path != null && path.getLastPathComponent() instanceof TreeNodeSettings && ((TreeNodeSettings)path.getLastPathComponent()).getPlayer() != null) {
                    ((TreeNodeSettings)path.getLastPathComponent()).setEnable(!((TreeNodeSettings)path.getLastPathComponent()).isEnable());
                    TranscodingTab.this.updateEngineModel();
                    TranscodingTab.this.tree.updateUI();
                }
            }
        });
        builder.add((Component)but3, FormLayoutUtil.flip(cc.xy(4, 3), colSpec, this.orientation));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Messages.getString("TrTab2.11"));
        TreeNodeSettings commonEnc = new TreeNodeSettings(Messages.getString("TrTab2.5"), null, this.buildCommon());
        commonEnc.getConfigPanel().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                TranscodingTab.this.handleCardComponentChange(e.getComponent());
            }
        });
        this.tabbedPanel.add(commonEnc.id(), commonEnc.getConfigPanel());
        root.add(commonEnc);
        this.engineTreeNodes = new HashMap<PlayerPurpose, DefaultMutableTreeNode>(5);
        this.engineTreeNodes.put(PlayerPurpose.VIDEO_FILE_PLAYER, new DefaultMutableTreeNode(Messages.getString("TrTab2.14")));
        this.engineTreeNodes.put(PlayerPurpose.AUDIO_FILE_PLAYER, new DefaultMutableTreeNode(Messages.getString("TrTab2.15")));
        this.engineTreeNodes.put(PlayerPurpose.VIDEO_WEB_STREAM_PLAYER, new DefaultMutableTreeNode(Messages.getString("TrTab2.16")));
        this.engineTreeNodes.put(PlayerPurpose.AUDIO_WEB_STREAM_PLAYER, new DefaultMutableTreeNode(Messages.getString("TrTab2.17")));
        this.engineTreeNodes.put(PlayerPurpose.MISC_PLAYER, new DefaultMutableTreeNode(Messages.getString("TrTab2.18")));
        root.add(this.engineTreeNodes.get((Object)PlayerPurpose.VIDEO_FILE_PLAYER));
        root.add(this.engineTreeNodes.get((Object)PlayerPurpose.AUDIO_FILE_PLAYER));
        root.add(this.engineTreeNodes.get((Object)PlayerPurpose.VIDEO_WEB_STREAM_PLAYER));
        root.add(this.engineTreeNodes.get((Object)PlayerPurpose.AUDIO_WEB_STREAM_PLAYER));
        root.add(this.engineTreeNodes.get((Object)PlayerPurpose.MISC_PLAYER));
        this.tree = new JTree(new DefaultTreeModel(root)){
            private static final long serialVersionUID = -6703434752606636290L;
        };
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() instanceof TreeNodeSettings) {
                    TreeNodeSettings tns = (TreeNodeSettings)e.getNewLeadSelectionPath().getLastPathComponent();
                    TranscodingTab.this.cl.show(TranscodingTab.this.tabbedPanel, tns.id());
                }
            }
        });
        this.tree.setRequestFocusEnabled(false);
        this.tree.setCellRenderer(new TreeRenderer());
        JScrollPane pane = new JScrollPane(this.tree, 20, 31);
        builder.add((Component)pane, FormLayoutUtil.flip(cc.xyw(2, 1, 4), colSpec, this.orientation));
        builder.addLabel(Messages.getString("TrTab2.19"), FormLayoutUtil.flip(cc.xyw(2, 5, 4), colSpec, this.orientation));
        builder.addLabel(Messages.getString("TrTab2.20"), FormLayoutUtil.flip(cc.xyw(2, 7, 4), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    public void addEngines() {
        ArrayList<Player> disPlayers = new ArrayList<Player>();
        ArrayList<Player> ordPlayers = new ArrayList<Player>();
        for (String id : this.configuration.getEnginesAsList()) {
            for (Player p : PlayerFactory.getAllPlayers()) {
                if (!p.id().equals(id)) continue;
                ordPlayers.add(p);
                if (!p.isVideoHardwareAccelerationReady()) continue;
                this.videoHWacceleration.setEnabled(true);
                this.videoHWacceleration.setSelected(this.configuration.isVideoHardwareAcceleration());
            }
        }
        for (Player p : PlayerFactory.getAllPlayers()) {
            if (ordPlayers.contains(p)) continue;
            ordPlayers.add(p);
            disPlayers.add(p);
        }
        for (Player p : ordPlayers) {
            JComponent jc;
            TreeNodeSettings engine = new TreeNodeSettings(p.name(), p, null);
            if (disPlayers.contains(p)) {
                engine.setEnable(false);
            }
            if ((jc = engine.getConfigPanel()) == null) {
                jc = this.buildEmpty();
            }
            jc.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    TranscodingTab.this.handleCardComponentChange(e.getComponent());
                }
            });
            this.tabbedPanel.add(engine.id(), jc);
            this.engineTreeNodes.get((Object)p.getPurpose()).add(engine);
        }
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.setSelectionRow(0);
    }

    public JComponent buildEmpty() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 3dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, EMPTY_ROW_SPEC);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Messages.getString("TrTab2.1"), FormLayoutUtil.flip(cc.xyw(1, 1, 3), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    public JComponent buildCommon() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 3dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, COMMON_ROW_SPEC);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        JComponent cmp = builder.addSeparator(Messages.getString("NetworkTab.5"), FormLayoutUtil.flip(cc.xyw(1, 1, 3), colSpec, this.orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.disableSubs = new JCheckBox(Messages.getString("TrTab2.51"), this.configuration.isDisableSubtitles());
        this.disableSubs.setContentAreaFilled(false);
        this.disableSubs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setDisableSubtitles(e.getStateChange() == 1);
            }
        });
        builder.addLabel(Messages.getString("TrTab2.23"), FormLayoutUtil.flip(cc.xy(1, 3), colSpec, this.orientation));
        this.maxbuffer = new JTextField("" + this.configuration.getMaxMemoryBufferSize());
        this.maxbuffer.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    int ab = Integer.parseInt(TranscodingTab.this.maxbuffer.getText());
                    TranscodingTab.this.configuration.setMaxMemoryBufferSize(ab);
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Could not parse max memory buffer size from \"" + TranscodingTab.this.maxbuffer.getText() + "\"");
                }
            }
        });
        builder.add((Component)this.maxbuffer, FormLayoutUtil.flip(cc.xy(3, 3), colSpec, this.orientation));
        String nCpusLabel = String.format(Messages.getString("TrTab2.24"), Runtime.getRuntime().availableProcessors());
        builder.addLabel(nCpusLabel, FormLayoutUtil.flip(cc.xy(1, 5), colSpec, this.orientation));
        String[] guiCores = new String[16];
        for (int i = 0; i < 16; ++i) {
            guiCores[i] = Integer.toString(i + 1);
        }
        this.nbcores = new JComboBox<String>(guiCores);
        this.nbcores.setEditable(false);
        int nbConfCores = this.configuration.getNumberOfCpuCores();
        if (nbConfCores > 0 && nbConfCores <= 16) {
            this.nbcores.setSelectedItem(Integer.toString(nbConfCores));
        } else {
            this.nbcores.setSelectedIndex(0);
        }
        this.nbcores.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setNumberOfCpuCores(Integer.parseInt(e.getItem().toString()));
            }
        });
        builder.add((Component)this.nbcores, FormLayoutUtil.flip(cc.xy(3, 5), colSpec, this.orientation));
        this.chapter_support = new JCheckBox(Messages.getString("TrTab2.52"), this.configuration.isChapterSupport());
        this.chapter_support.setContentAreaFilled(false);
        this.chapter_support.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setChapterSupport(e.getStateChange() == 1);
                TranscodingTab.this.chapter_interval.setEnabled(TranscodingTab.this.configuration.isChapterSupport());
            }
        });
        builder.add((Component)this.chapter_support, FormLayoutUtil.flip(cc.xy(1, 7), colSpec, this.orientation));
        this.chapter_interval = new JTextField("" + this.configuration.getChapterInterval());
        this.chapter_interval.setEnabled(this.configuration.isChapterSupport());
        this.chapter_interval.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    int ab = Integer.parseInt(TranscodingTab.this.chapter_interval.getText());
                    TranscodingTab.this.configuration.setChapterInterval(ab);
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Could not parse chapter interval from \"" + TranscodingTab.this.chapter_interval.getText() + "\"");
                }
            }
        });
        builder.add((Component)this.chapter_interval, FormLayoutUtil.flip(cc.xy(3, 7), colSpec, this.orientation));
        builder.add((Component)this.disableSubs, FormLayoutUtil.flip(cc.xy(1, 9), colSpec, this.orientation));
        JTabbedPane setupTabbedPanel = new JTabbedPane();
        setupTabbedPanel.addTab(Messages.getString("TrTab2.67"), this.buildVideoSetupPanel());
        setupTabbedPanel.addTab(Messages.getString("TrTab2.68"), this.buildAudioSetupPanel());
        setupTabbedPanel.addTab(Messages.getString("MEncoderVideo.8"), this.buildSubtitlesSetupPanel());
        builder.add((Component)setupTabbedPanel, FormLayoutUtil.flip(cc.xywh(1, 11, 3, 3), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private JComponent buildVideoSetupPanel() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 2dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, "$lgap, 2*(pref, 2dlu), 10dlu, 10dlu, 3*(pref, 2dlu), pref");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.DLU4_BORDER);
        CellConstraints cc = new CellConstraints();
        this.videoHWacceleration = new JCheckBox(Messages.getString("TrTab2.70"), this.configuration.isVideoHardwareAcceleration());
        this.videoHWacceleration.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setVideoHardwareAcceleration(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.videoHWacceleration, FormLayoutUtil.flip(cc.xy(1, 2), colSpec, this.orientation));
        this.videoHWacceleration.setEnabled(false);
        this.mpeg2remux = new JCheckBox(Messages.getString("MEncoderVideo.39") + (Platform.isWindows() ? " " + Messages.getString("TrTab2.21") : ""), this.configuration.isMencoderRemuxMPEG2());
        this.mpeg2remux.setContentAreaFilled(false);
        this.mpeg2remux.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setMencoderRemuxMPEG2(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.mpeg2remux, FormLayoutUtil.flip(cc.xyw(1, 6, 3), colSpec, this.orientation));
        JComponent cmp = builder.addSeparator(Messages.getString("TrTab2.7"), FormLayoutUtil.flip(cc.xyw(1, 8, 3), colSpec, this.orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        builder.add((Component)new JLabel(Messages.getString("TrTab2.32")), FormLayoutUtil.flip(cc.xy(1, 10), colSpec, this.orientation));
        Object[] data = new Object[]{this.configuration.getMPEG2MainSettings(), String.format("Automatic (Wired)  /* %s */", Messages.getString("TrTab2.71")), String.format("Automatic (Wireless)  /* %s */", Messages.getString("TrTab2.72")), String.format("keyint=5:vqscale=1:vqmin=2  /* %s */", Messages.getString("TrTab2.60")), String.format("keyint=5:vqscale=1:vqmin=1  /* %s */", Messages.getString("TrTab2.61")), String.format("keyint=5:vqscale=2:vqmin=3  /* %s */", Messages.getString("TrTab2.62")), String.format("keyint=25:vqmax=5:vqmin=2  /* %s */", Messages.getString("TrTab2.63")), String.format("keyint=25:vqmax=7:vqmin=2  /* %s */", Messages.getString("TrTab2.64")), String.format("keyint=25:vqmax=8:vqmin=3  /* %s */", Messages.getString("TrTab2.65"))};
        MyComboBoxModel cbm = new MyComboBoxModel(data);
        this.vq = new JComboBox(cbm);
        this.vq.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String s = (String)e.getItem();
                    if (s.indexOf("/*") > -1) {
                        s = s.substring(0, s.indexOf("/*")).trim();
                    }
                    TranscodingTab.this.configuration.setMPEG2MainSettings(s);
                }
            }
        });
        this.vq.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.vq.getItemListeners()[0].itemStateChanged(new ItemEvent(TranscodingTab.this.vq, 0, TranscodingTab.this.vq.getEditor().getItem(), 1));
            }
        });
        this.vq.setEditable(true);
        builder.add((Component)this.vq, FormLayoutUtil.flip(cc.xy(3, 10), colSpec, this.orientation));
        builder.add((Component)new JLabel(Messages.getString("TrTab2.8")), FormLayoutUtil.flip(cc.xy(1, 12), colSpec, this.orientation));
        this.notranscode = new JTextField(this.configuration.getDisableTranscodeForExtensions());
        this.notranscode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setDisableTranscodeForExtensions(TranscodingTab.this.notranscode.getText());
            }
        });
        builder.add((Component)this.notranscode, FormLayoutUtil.flip(cc.xy(3, 12), colSpec, this.orientation));
        builder.addLabel(Messages.getString("TrTab2.9"), FormLayoutUtil.flip(cc.xy(1, 14), colSpec, this.orientation));
        this.forcetranscode = new JTextField(this.configuration.getForceTranscodeForExtensions());
        this.forcetranscode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setForceTranscodeForEtensions(TranscodingTab.this.forcetranscode.getText());
            }
        });
        builder.add((Component)this.forcetranscode, FormLayoutUtil.flip(cc.xy(3, 14), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private JComponent buildAudioSetupPanel() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 2dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, "$lgap, pref, 2dlu, 4*(pref, 2dlu), pref, 12dlu, 3*(pref, 2dlu), pref:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.DLU4_BORDER);
        CellConstraints cc = new CellConstraints();
        builder.addLabel(Messages.getString("TrTab2.50"), FormLayoutUtil.flip(cc.xy(1, 2), colSpec, this.orientation));
        this.channels = new JComboBox<Object>(new Object[]{Messages.getString("TrTab2.55"), Messages.getString("TrTab2.56")});
        this.channels.setEditable(false);
        if (this.configuration.getAudioChannelCount() == 2) {
            this.channels.setSelectedIndex(0);
        } else {
            this.channels.setSelectedIndex(1);
        }
        this.channels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setAudioChannelCount(Integer.parseInt(e.getItem().toString().substring(0, 1)));
            }
        });
        builder.add((Component)this.channels, FormLayoutUtil.flip(cc.xy(3, 2), colSpec, this.orientation));
        this.forcePCM = new JCheckBox(Messages.getString("TrTab2.27"), this.configuration.isAudioUsePCM());
        this.forcePCM.setContentAreaFilled(false);
        this.forcePCM.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setAudioUsePCM(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.forcePCM, FormLayoutUtil.flip(cc.xy(1, 4), colSpec, this.orientation));
        this.ac3remux = new JCheckBox(Messages.getString("TrTab2.26") + " " + (Platform.isWindows() ? Messages.getString("TrTab2.21") : ""));
        if (this.configuration.isAudioRemuxAC3()) {
            this.ac3remux.setSelected(true);
        }
        this.ac3remux.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setAudioRemuxAC3(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.ac3remux, FormLayoutUtil.flip(cc.xyw(1, 6, 3), colSpec, this.orientation));
        this.forceDTSinPCM = new JCheckBox(Messages.getString("TrTab2.28") + (Platform.isWindows() ? " " + Messages.getString("TrTab2.21") : ""), this.configuration.isAudioEmbedDtsInPcm());
        this.forceDTSinPCM.setContentAreaFilled(false);
        this.forceDTSinPCM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranscodingTab.this.configuration.setAudioEmbedDtsInPcm(TranscodingTab.this.forceDTSinPCM.isSelected());
                if (TranscodingTab.this.configuration.isAudioEmbedDtsInPcm()) {
                    JOptionPane.showMessageDialog((JFrame)SwingUtilities.getWindowAncestor((Component)((Object)PMS.get().getFrame())), Messages.getString("TrTab2.10"), Messages.getString("Dialog.Information"), 1);
                }
            }
        });
        builder.add((Component)this.forceDTSinPCM, FormLayoutUtil.flip(cc.xyw(1, 8, 3), colSpec, this.orientation));
        builder.addLabel(Messages.getString("TrTab2.29"), FormLayoutUtil.flip(cc.xy(1, 10), colSpec, this.orientation));
        this.abitrate = new JTextField("" + this.configuration.getAudioBitrate());
        this.abitrate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    int ab = Integer.parseInt(TranscodingTab.this.abitrate.getText());
                    TranscodingTab.this.configuration.setAudioBitrate(ab);
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Could not parse audio bitrate from \"" + TranscodingTab.this.abitrate.getText() + "\"");
                }
            }
        });
        builder.add((Component)this.abitrate, FormLayoutUtil.flip(cc.xy(3, 10), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.7"), FormLayoutUtil.flip(cc.xy(1, 12), colSpec, this.orientation));
        this.langs = new JTextField(this.configuration.getAudioLanguages());
        this.langs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAudioLanguages(TranscodingTab.this.langs.getText());
            }
        });
        builder.add((Component)this.langs, FormLayoutUtil.flip(cc.xy(3, 12), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private JComponent buildSubtitlesSetupPanel() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 3dlu, p:grow, 3dlu, right:p:grow, 3dlu, p:grow, 3dlu, right:p:grow,3dlu, p:grow, 3dlu, right:p:grow,3dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, "$lgap, 7*(pref, 3dlu), pref");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.DLU4_BORDER);
        CellConstraints cc = new CellConstraints();
        builder.addLabel(Messages.getString("MEncoderVideo.9"), FormLayoutUtil.flip(cc.xy(1, 2), colSpec, this.orientation));
        this.defaultsubs = new JTextField(this.configuration.getSubtitlesLanguages());
        this.defaultsubs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setSubtitlesLanguages(TranscodingTab.this.defaultsubs.getText());
            }
        });
        builder.add((Component)this.defaultsubs, FormLayoutUtil.flip(cc.xyw(3, 2, 5), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.94"), FormLayoutUtil.flip(cc.xyw(8, 2, 2, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, this.orientation));
        this.forcedsub = new JTextField(this.configuration.getForcedSubtitleLanguage());
        this.forcedsub.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setForcedSubtitleLanguage(TranscodingTab.this.forcedsub.getText());
            }
        });
        builder.add((Component)this.forcedsub, FormLayoutUtil.flip(cc.xyw(11, 2, 2), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.95"), FormLayoutUtil.flip(cc.xyw(12, 2, 2, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, this.orientation));
        this.forcedtags = new JTextField(this.configuration.getForcedSubtitleTags());
        this.forcedtags.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setForcedSubtitleTags(TranscodingTab.this.forcedtags.getText());
            }
        });
        builder.add((Component)this.forcedtags, FormLayoutUtil.flip(cc.xyw(14, 2, 2), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.10"), FormLayoutUtil.flip(cc.xy(1, 4), colSpec, this.orientation));
        this.defaultaudiosubs = new JTextField(this.configuration.getAudioSubLanguages());
        this.defaultaudiosubs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAudioSubLanguages(TranscodingTab.this.defaultaudiosubs.getText());
            }
        });
        builder.add((Component)this.defaultaudiosubs, FormLayoutUtil.flip(cc.xyw(3, 4, 8), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.37"), FormLayoutUtil.flip(cc.xyw(1, 6, 2), colSpec, this.orientation));
        this.alternateSubFolder = new JTextField(this.configuration.getAlternateSubtitlesFolder());
        this.alternateSubFolder.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAlternateSubtitlesFolder(TranscodingTab.this.alternateSubFolder.getText());
            }
        });
        builder.add((Component)this.alternateSubFolder, FormLayoutUtil.flip(cc.xyw(3, 6, 8), colSpec, this.orientation));
        this.folderSelectButton = new JButton("...");
        this.folderSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser;
                try {
                    chooser = new JFileChooser();
                }
                catch (Exception ee) {
                    chooser = new JFileChooser(new RestrictedFileSystemView());
                }
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showDialog((Component)e.getSource(), Messages.getString("FoldTab.28"));
                if (returnVal == 0) {
                    TranscodingTab.this.alternateSubFolder.setText(chooser.getSelectedFile().getAbsolutePath());
                    TranscodingTab.this.configuration.setAlternateSubtitlesFolder(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        builder.add((Component)this.folderSelectButton, FormLayoutUtil.flip(cc.xyw(11, 6, 2), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.11"), FormLayoutUtil.flip(cc.xy(1, 8), colSpec, this.orientation));
        Object[] data = new Object[]{this.configuration.getSubtitlesCodepage(), Messages.getString("MEncoderVideo.96"), Messages.getString("MEncoderVideo.97"), Messages.getString("MEncoderVideo.98"), Messages.getString("MEncoderVideo.99"), Messages.getString("MEncoderVideo.100"), Messages.getString("MEncoderVideo.101"), Messages.getString("MEncoderVideo.102"), Messages.getString("MEncoderVideo.103"), Messages.getString("MEncoderVideo.104"), Messages.getString("MEncoderVideo.105"), Messages.getString("MEncoderVideo.106"), Messages.getString("MEncoderVideo.107"), Messages.getString("MEncoderVideo.108"), Messages.getString("MEncoderVideo.109"), Messages.getString("MEncoderVideo.110"), Messages.getString("MEncoderVideo.111"), Messages.getString("MEncoderVideo.112"), Messages.getString("MEncoderVideo.113"), Messages.getString("MEncoderVideo.114"), Messages.getString("MEncoderVideo.115"), Messages.getString("MEncoderVideo.116"), Messages.getString("MEncoderVideo.117"), Messages.getString("MEncoderVideo.118"), Messages.getString("MEncoderVideo.119"), Messages.getString("MEncoderVideo.120"), Messages.getString("MEncoderVideo.121"), Messages.getString("MEncoderVideo.122"), Messages.getString("MEncoderVideo.123"), Messages.getString("MEncoderVideo.124")};
        MyComboBoxModel cbm = new MyComboBoxModel(data);
        this.subtitleCodePage = new JComboBox(cbm);
        this.subtitleCodePage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String s = (String)e.getItem();
                    int offset = s.indexOf("/*");
                    if (offset > -1) {
                        s = s.substring(0, offset).trim();
                    }
                    TranscodingTab.this.configuration.setSubtitlesCodepage(s);
                }
            }
        });
        this.subtitleCodePage.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.subtitleCodePage.getItemListeners()[0].itemStateChanged(new ItemEvent(TranscodingTab.this.subtitleCodePage, 0, TranscodingTab.this.subtitleCodePage.getEditor().getItem(), 1));
            }
        });
        this.subtitleCodePage.setEditable(true);
        builder.add((Component)this.subtitleCodePage, FormLayoutUtil.flip(cc.xyw(3, 8, 7), colSpec, this.orientation));
        this.fribidi = new JCheckBox(Messages.getString("MEncoderVideo.23"));
        this.fribidi.setContentAreaFilled(false);
        if (this.configuration.isMencoderSubFribidi()) {
            this.fribidi.setSelected(true);
        }
        this.fribidi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setMencoderSubFribidi(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.fribidi, FormLayoutUtil.flip(cc.xyw(11, 8, 4), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.24"), FormLayoutUtil.flip(cc.xy(1, 10), colSpec, this.orientation));
        this.defaultfont = new JTextField(this.configuration.getFont());
        this.defaultfont.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setFont(TranscodingTab.this.defaultfont.getText());
            }
        });
        builder.add((Component)this.defaultfont, FormLayoutUtil.flip(cc.xyw(3, 10, 8), colSpec, this.orientation));
        this.fontselect = new JButton("...");
        this.fontselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FontFileFilter());
                int returnVal = chooser.showDialog((Component)e.getSource(), Messages.getString("MEncoderVideo.25"));
                if (returnVal == 0) {
                    TranscodingTab.this.defaultfont.setText(chooser.getSelectedFile().getAbsolutePath());
                    TranscodingTab.this.configuration.setFont(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        builder.add((Component)this.fontselect, FormLayoutUtil.flip(cc.xyw(11, 10, 2), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.12"), FormLayoutUtil.flip(cc.xy(1, 12), colSpec, this.orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.133"), FormLayoutUtil.flip(cc.xy(1, 14), colSpec, this.orientation));
        this.ass_scale = new JTextField(this.configuration.getAssScale());
        this.ass_scale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAssScale(TranscodingTab.this.ass_scale.getText());
            }
        });
        builder.addLabel(Messages.getString("MEncoderVideo.13"), FormLayoutUtil.flip(cc.xy(5, 12), colSpec, this.orientation));
        this.ass_outline = new JTextField(this.configuration.getAssOutline());
        this.ass_outline.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAssOutline(TranscodingTab.this.ass_outline.getText());
            }
        });
        builder.addLabel(Messages.getString("MEncoderVideo.14"), FormLayoutUtil.flip(cc.xy(9, 12), colSpec, this.orientation));
        this.ass_shadow = new JTextField(this.configuration.getAssShadow());
        this.ass_shadow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAssShadow(TranscodingTab.this.ass_shadow.getText());
            }
        });
        builder.addLabel(Messages.getString("MEncoderVideo.15"), FormLayoutUtil.flip(cc.xy(13, 12), colSpec, this.orientation));
        this.ass_margin = new JTextField(this.configuration.getAssMargin());
        this.ass_margin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAssMargin(TranscodingTab.this.ass_margin.getText());
            }
        });
        builder.add((Component)this.ass_scale, FormLayoutUtil.flip(cc.xy(3, 12), colSpec, this.orientation));
        builder.add((Component)this.ass_outline, FormLayoutUtil.flip(cc.xy(7, 12), colSpec, this.orientation));
        builder.add((Component)this.ass_shadow, FormLayoutUtil.flip(cc.xy(11, 12), colSpec, this.orientation));
        builder.add((Component)this.ass_margin, FormLayoutUtil.flip(cc.xy(15, 12), colSpec, this.orientation));
        this.subs = new JCheckBox(Messages.getString("MEncoderVideo.22"), this.configuration.isAutoloadExternalSubtitles());
        this.subs.setContentAreaFilled(false);
        this.subs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranscodingTab.this.configuration.setAutoloadExternalSubtitles(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.subs, FormLayoutUtil.flip(cc.xyw(1, 16, 13), colSpec, this.orientation));
        this.subColor = new JButton();
        this.subColor.setText(Messages.getString("MEncoderVideo.31"));
        this.subColor.setBackground(new Color(this.configuration.getSubsColor()));
        this.subColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(SwingUtilities.getWindowAncestor((Component)((Object)PMS.get().getFrame())), Messages.getString("MEncoderVideo.125"), TranscodingTab.this.subColor.getBackground());
                if (newColor != null) {
                    TranscodingTab.this.subColor.setBackground(newColor);
                    TranscodingTab.this.configuration.setSubsColor(newColor.getRGB());
                }
            }
        });
        builder.add((Component)this.subColor, FormLayoutUtil.flip(cc.xyw(13, 16, 3), colSpec, this.orientation));
        final JPanel panel = builder.getPanel();
        boolean enable = !this.configuration.isDisableSubtitles();
        for (Component component : panel.getComponents()) {
            component.setEnabled(enable);
        }
        this.disableSubs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() != 1;
                for (Component component : panel.getComponents()) {
                    component.setEnabled(enabled);
                }
            }
        });
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }
}

