/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import net.pms.io.UnusedProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnusedInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(UnusedInputStream.class);
    private InputStream inputStream;
    private UnusedProcess processToTerminate;
    private int timeout;

    public UnusedInputStream(InputStream inputStream, UnusedProcess processToTerminate, int timeout) {
        this.inputStream = inputStream;
        this.processToTerminate = processToTerminate;
        this.timeout = timeout;
        processToTerminate.setReadyToStop(false);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        if (this.processToTerminate != null) {
            this.processToTerminate.setReadyToStop(true);
        }
        Runnable checkEnd = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(UnusedInputStream.this.timeout);
                }
                catch (InterruptedException e) {
                    logger.error(null, e);
                }
                if (UnusedInputStream.this.processToTerminate != null && UnusedInputStream.this.processToTerminate.isReadyToStop()) {
                    logger.debug("Destroying / Stopping attached process: " + UnusedInputStream.this.processToTerminate);
                    if (UnusedInputStream.this.processToTerminate != null) {
                        UnusedInputStream.this.processToTerminate.stopProcess();
                    }
                    UnusedInputStream.this.processToTerminate = null;
                    UnusedInputStream.this.unusedStreamSignal();
                }
            }
        };
        new Thread(checkEnd, "Process Reaper").start();
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    public String toString() {
        return this.inputStream.toString();
    }

    public abstract void unusedStreamSignal();
}

