/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import com.sun.jna.Platform;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.io.SystemUtils;
import net.pms.newgui.LooksFrame;
import net.pms.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSystemUtils
implements SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(BasicSystemUtils.class);
    protected String vlcp;
    protected String vlcv;
    protected boolean avis;

    @Override
    public void disableGoToSleep() {
    }

    @Override
    public void reenableGoToSleep() {
    }

    @Override
    public File getAvsPluginsDir() {
        return null;
    }

    @Override
    public String getShortPathNameW(String longPathName) {
        return longPathName;
    }

    @Override
    public String getWindowsDirectory() {
        return null;
    }

    @Override
    public String getDiskLabel(File f) {
        return null;
    }

    @Override
    public boolean isKerioFirewall() {
        return false;
    }

    @Override
    public String getVlcPath() {
        return this.vlcp;
    }

    @Override
    public String getVlcVersion() {
        return this.vlcv;
    }

    @Override
    public boolean isAvis() {
        return this.avis;
    }

    @Override
    public void browseURI(String uri) {
        try {
            Desktop.getDesktop().browse(new URI(uri));
        }
        catch (IOException e) {
            logger.trace("Unable to open the given URI: " + uri + ".");
        }
        catch (URISyntaxException e) {
            logger.trace("Unable to open the given URI: " + uri + ".");
        }
    }

    @Override
    public boolean isNetworkInterfaceLoopback(NetworkInterface ni) throws SocketException {
        return ni.isLoopback();
    }

    @Override
    public void addSystemTray(final LooksFrame frame) {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image trayIconImage = this.resolveTrayIcon();
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem(Messages.getString("LooksFrame.5"));
            MenuItem traceItem = new MenuItem(Messages.getString("LooksFrame.6"));
            defaultItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    frame.quit();
                }
            });
            traceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    frame.setVisible(true);
                }
            });
            popup.add(traceItem);
            popup.add(defaultItem);
            TrayIcon trayIcon = new TrayIcon(trayIconImage, PropertiesUtil.getProjectProperties().get("project.name") + " " + PMS.getVersion(), popup);
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    frame.setVisible(true);
                    frame.setFocusable(true);
                }
            });
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                logger.debug("Caught exception", e);
            }
        }
    }

    @Override
    public byte[] getHardwareAddress(NetworkInterface ni) throws SocketException {
        return ni.getHardwareAddress();
    }

    @Override
    public String[] getPingCommand(String hostAddress, int count, int packetSize) {
        return new String[]{"ping", "-c", Integer.toString(count), "-s", Integer.toString(packetSize), hostAddress};
    }

    private Image resolveTrayIcon() {
        String icon = "icon-16.png";
        if (Platform.isMac()) {
            icon = "icon-22.png";
        }
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/" + icon));
    }
}

