/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.pms.formats.DVRMS;
import net.pms.formats.FLAC;
import net.pms.formats.Format;
import net.pms.formats.GIF;
import net.pms.formats.ISO;
import net.pms.formats.JPG;
import net.pms.formats.M4A;
import net.pms.formats.MKV;
import net.pms.formats.MP3;
import net.pms.formats.MPG;
import net.pms.formats.OGG;
import net.pms.formats.PNG;
import net.pms.formats.RAW;
import net.pms.formats.TIF;
import net.pms.formats.WAV;
import net.pms.formats.WEB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormatFactory {
    private static final Logger logger = LoggerFactory.getLogger(FormatFactory.class);
    private static final Format[] FORMATS = new Format[]{new DVRMS(), new FLAC(), new GIF(), new ISO(), new JPG(), new M4A(), new MKV(), new MP3(), new MPG(), new OGG(), new PNG(), new RAW(), new TIF(), new WAV(), new WEB()};
    private static List<Format> formats = new ArrayList<Format>(Arrays.asList(FORMATS));

    private FormatFactory() {
    }

    @Deprecated
    public static Format getAssociatedExtension(String filename) {
        return FormatFactory.getAssociatedFormat(filename);
    }

    public static Format getAssociatedFormat(String filename) {
        for (Format format : formats) {
            if (!format.match(filename)) continue;
            logger.trace("Matched format {} to \"{}\"", (Object)format, (Object)filename);
            return format.duplicate();
        }
        logger.trace("Could not match any format to \"{}\"", (Object)filename);
        return null;
    }

    public static List<Format> getSupportedFormats() {
        return formats;
    }

    public static void setFormats(List<Format> formatList) {
        formats = formatList;
    }
}

