/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats;

import java.util.StringTokenizer;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.InputFile;
import net.pms.network.HTTPResource;
import net.pms.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Format
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(Format.class);
    private String icon = null;
    protected int type = 8;
    protected Format secondaryFormat;
    private String matchedExtension;
    public static final int AUDIO = 1;
    public static final int IMAGE = 2;
    public static final int VIDEO = 4;
    public static final int UNKNOWN = 8;
    public static final int PLAYLIST = 16;
    public static final int ISO = 32;

    public int getType() {
        return this.type;
    }

    public String getMatchedExtension() {
        return this.matchedExtension;
    }

    public void setMatchedExtension(String extension) {
        this.matchedExtension = extension;
    }

    public Format getSecondaryFormat() {
        return this.secondaryFormat;
    }

    public void setSecondaryFormat(Format secondaryFormat) {
        this.secondaryFormat = secondaryFormat;
    }

    public void setType(int type) {
        if (this.isUnknown()) {
            this.type = type;
        }
    }

    @Deprecated
    public String[] getId() {
        return this.getSupportedExtensions();
    }

    public String[] getSupportedExtensions() {
        return null;
    }

    @Deprecated
    public abstract boolean ps3compatible();

    public boolean isCompatible(DLNAMediaInfo media, RendererConfiguration renderer) {
        RendererConfiguration referenceRenderer = renderer != null ? renderer : RendererConfiguration.getDefaultConf();
        return referenceRenderer.isCompatible(media, this);
    }

    public abstract boolean transcodable();

    public String mimeType() {
        return HTTPResource.getDefaultMimeType(this.type);
    }

    public void setIcon(String filename) {
        this.icon = filename;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean match(String filename) {
        if (filename == null) {
            return false;
        }
        filename = filename.toLowerCase();
        String[] supportedExtensions = this.getSupportedExtensions();
        if (supportedExtensions != null) {
            String protocol = FileUtil.getProtocol(filename);
            if (protocol != null) {
                return false;
            }
            for (String extension : supportedExtensions) {
                String ext = extension.toLowerCase();
                if (!filename.endsWith("." + ext)) continue;
                this.setMatchedExtension(ext);
                return true;
            }
        }
        return false;
    }

    public boolean isVideo() {
        return (this.type & 4) == 4;
    }

    public boolean isAudio() {
        return (this.type & 1) == 1;
    }

    public boolean isImage() {
        return (this.type & 2) == 2;
    }

    public boolean isUnknown() {
        return (this.type & 8) == 8;
    }

    protected Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error(null, e);
        }
        return o;
    }

    public Format duplicate() {
        return (Format)this.clone();
    }

    public void parse(DLNAMediaInfo media, InputFile file, int type) {
        this.parse(media, file, type, null);
    }

    public void parse(DLNAMediaInfo media, InputFile file, int type, RendererConfiguration renderer) {
        if (renderer != null && renderer.isMediaParserV2()) {
            renderer.getFormatConfiguration().parse(media, file, this, type);
        } else {
            media.parse(file, this, type, false);
        }
        logger.trace("Parsing results: " + file + " / " + media);
    }

    public boolean skip(String extensions, String moreExtensions) {
        String id;
        StringTokenizer st;
        if (extensions != null && extensions.length() > 0) {
            st = new StringTokenizer(extensions, ",");
            while (st.hasMoreTokens()) {
                id = st.nextToken().toLowerCase();
                if (this.matchedExtension == null || !this.matchedExtension.toLowerCase().equals(id)) continue;
                return true;
            }
        }
        if (moreExtensions != null && moreExtensions.length() > 0) {
            st = new StringTokenizer(moreExtensions, ",");
            while (st.hasMoreTokens()) {
                id = st.nextToken().toLowerCase();
                if (this.matchedExtension == null || !this.matchedExtension.toLowerCase().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public abstract Identifier getIdentifier();

    public static enum Identifier {
        AUDIO_AS_VIDEO,
        DVRMS,
        FLAC,
        GIF,
        ISO,
        JPG,
        M4A,
        MKV,
        MP3,
        MPG,
        OGG,
        PNG,
        RAW,
        TIF,
        WAV,
        WEB,
        CUSTOM;

    }
}

