/*
 * Decompiled with CFR 0.152.
 */
package mediautil.gen;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class BasicIo {
    public static final String[] FACTOR_ABVS = new String[]{"", "KB", "MB", "GB", "TB", "BB"};

    public static int s2n(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = 0;
        if (bl2) {
            n3 = 0;
            for (int i = n; i < n2 + n && i < byArray.length; ++i) {
                n4 += (byArray[i] & 0xFF) << n3;
                n3 += 8;
            }
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                n4 = (n4 << 8) + (byArray[n + n3] & 0xFF);
            }
        }
        if (bl && (n4 & (n3 = 1 << 8 * n2 - 1)) > 0) {
            n4 -= n3 << 1;
        }
        return n4;
    }

    public static void in2s(byte[] byArray, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[n + i] = (byte)(n2 & 0xFF);
            n2 >>= 8;
        }
    }

    public static void bn2s(byte[] byArray, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[n + n3 - i - 1] = (byte)(n2 & 0xFF);
            n2 >>= 8;
        }
    }

    public static byte[] bn2s(int n, int n2) {
        byte[] byArray = new byte[n2];
        BasicIo.bn2s(byArray, 0, n, n2);
        return byArray;
    }

    public static boolean isSignature(byte[] byArray, int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == (byArray[n + i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public static long skip(InputStream inputStream, long l) throws IOException {
        long l2 = l;
        if (l > 0L) {
            long l3;
            do {
                if ((l3 = inputStream.skip(l2)) >= 1L || inputStream.read() == -1) continue;
                l3 = 1L;
            } while ((l2 -= l3) > 0L && l3 > 0L);
        }
        return l - l2;
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        if (n3 < 0 || n2 > n3) {
            throw new IOException("Invalid parameters minBytes = " + n2 + " n = " + n3);
        }
        int n4 = n3;
        if (n3 > 0) {
            int n5;
            int n6 = n2;
            do {
                if ((n5 = inputStream.read(byArray, n, n4)) <= 0) continue;
                n += n5;
                n4 -= n5;
                n6 -= n5;
            } while (n6 > 0 && n5 >= 0);
        }
        return n3 - n4;
    }

    public static int read(InputStream inputStream, byte[] byArray) throws IOException {
        return BasicIo.read(inputStream, byArray, 0, byArray.length, byArray.length);
    }

    public static String convertLength(long l) {
        int n = 0;
        while (l >= 1024L) {
            l /= 1024L;
            ++n;
        }
        return "" + l + FACTOR_ABVS[n];
    }

    public static int asInt(String string) {
        try {
            return ((ByteBuffer)ByteBuffer.allocate(4).put(string.getBytes("ISO8859_1")).order(ByteOrder.LITTLE_ENDIAN).flip()).getInt();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Can't represent  " + string + " as int");
        }
    }

    public static String asString(int n) {
        return Charset.forName("ISO8859_1").decode((ByteBuffer)ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(n).flip()).toString();
    }
}

