/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SimpleOptionsParser {
    private static final Logger logger = Logger.getLogger(SimpleOptionsParser.class.getCanonicalName());
    Map<String, OptionHandler> optionHandlers = new HashMap<String, OptionHandler>();

    public SimpleOptionsParser() {
        logger.entering(SimpleOptionsParser.class.getCanonicalName(), "SimpleOptionsParser()");
        logger.exiting(SimpleOptionsParser.class.getCanonicalName(), "SimpleOptionsParser()");
    }

    public void registerOption(String string, OptionHandler optionHandler) {
        logger.entering(SimpleOptionsParser.class.getCanonicalName(), "registerOption(String,OptionHandler)", new Object[]{string, optionHandler});
        this.optionHandlers.put(string, optionHandler);
        logger.exiting(SimpleOptionsParser.class.getCanonicalName(), "registerOption(String,OptionHandler)");
    }

    public void registerOption(OptionHandler optionHandler, String ... stringArray) {
        logger.entering(SimpleOptionsParser.class.getCanonicalName(), "registerOption(OptionHandler,String[])", new Object[]{optionHandler, stringArray});
        for (String string : stringArray) {
            this.optionHandlers.put(string, optionHandler);
        }
        logger.exiting(SimpleOptionsParser.class.getCanonicalName(), "registerOption(OptionHandler,String[])");
    }

    public int parseOptions(String[] stringArray) {
        logger.entering(SimpleOptionsParser.class.getCanonicalName(), "parseOptions(String[])", new Object[]{stringArray});
        int n = this.parseOptions(stringArray, 0);
        logger.exiting(SimpleOptionsParser.class.getCanonicalName(), "registerOption(OptionHandler,String[])", n);
        return n;
    }

    public int parseOptions(String[] stringArray, int n) {
        logger.entering(SimpleOptionsParser.class.getCanonicalName(), "parseOptions(String[],int)", new Object[]{stringArray, n});
        int n2 = n;
        OptionHandler optionHandler = null;
        while (n2 < stringArray.length && (optionHandler = this.optionHandlers.get(stringArray[n2])) != null) {
            int n3 = optionHandler.handleOption(stringArray, n2);
            if (n3 == n2) {
                IllegalStateException illegalStateException = new IllegalStateException("Handler registered for option \"" + stringArray[n2] + "\" did not handle it.");
                logger.throwing(SimpleOptionsParser.class.getCanonicalName(), "parseOptions(String[],int)", illegalStateException);
                throw illegalStateException;
            }
            if (n3 > stringArray.length) {
                IllegalStateException illegalStateException = new IllegalStateException("Handler registered for option \"" + stringArray[n2] + "\" claims to have handled more options than are existent.");
                logger.throwing(SimpleOptionsParser.class.getCanonicalName(), "parseOptions(String[],int)", illegalStateException);
                throw illegalStateException;
            }
            n2 = n3;
        }
        logger.exiting(SimpleOptionsParser.class.getCanonicalName(), "parseOptions(String[],int)", n2);
        return n2;
    }

    public static interface OptionHandler {
        public int handleOption(String[] var1, int var2);
    }
}

