/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.cuelib.tools.trackcutter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jwbroek.cuelib.CueParser;
import jwbroek.cuelib.CueSheet;
import jwbroek.cuelib.FileData;
import jwbroek.cuelib.Position;
import jwbroek.cuelib.TrackData;
import jwbroek.cuelib.tools.trackcutter.TrackCutterConfiguration;
import jwbroek.cuelib.tools.trackcutter.TrackCutterProcessingAction;
import jwbroek.io.StreamPiper;
import jwbroek.util.LogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackCutter {
    private static final Logger logger = Logger.getLogger(TrackCutter.class.getCanonicalName());
    private TrackCutterConfiguration configuration;

    public TrackCutter(TrackCutterConfiguration trackCutterConfiguration) {
        logger.entering(TrackCutter.class.getCanonicalName(), "TrackCutter(TrackCutterConfiguration)", trackCutterConfiguration);
        this.configuration = trackCutterConfiguration;
        logger.exiting(TrackCutter.class.getCanonicalName(), "TrackCutter(TrackCutterConfiguration)");
    }

    public void cutTracksInCueSheet(File file) throws IOException {
        logger.entering(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(File)", file);
        logger.info("Cutting tracks in cue sheet from file '" + file.toString() + "'.");
        CueSheet cueSheet = null;
        if (this.getConfiguration().getParentDirectory() == null) {
            this.getConfiguration().setParentDirectory(file.getParentFile());
            logger.fine("Have set base directory to directory of File  '" + file.toString() + "'.");
        }
        try {
            logger.fine("Parsing cue sheet.");
            cueSheet = CueParser.parse(file);
        }
        catch (IOException iOException) {
            logger.severe("Was unable to parse the cue sheet in file '" + file.toString() + "'.");
            LogUtil.logStacktrace(logger, Level.SEVERE, iOException);
            IOException iOException2 = new IOException("Problem parsing cue file.");
            iOException2.initCause(iOException);
            logger.throwing(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(File)", iOException2);
            throw iOException2;
        }
        this.cutTracksInCueSheet(cueSheet);
        logger.exiting(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(File)");
    }

    public void cutTracksInCueSheet(InputStream inputStream) throws IOException {
        logger.entering(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(InputStream)", inputStream);
        logger.info("Cutting tracks in cue sheet from InputStream.");
        CueSheet cueSheet = null;
        try {
            logger.fine("Parsing cue sheet.");
            cueSheet = CueParser.parse(inputStream);
        }
        catch (IOException iOException) {
            logger.severe("Was unable to parse the cue sheet from InputStream.");
            LogUtil.logStacktrace(logger, Level.SEVERE, iOException);
            IOException iOException2 = new IOException("Problem parsing cue file.");
            iOException2.initCause(iOException);
            logger.throwing(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(File)", iOException2);
            throw iOException2;
        }
        this.cutTracksInCueSheet(cueSheet);
        logger.exiting(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(InputStream)");
    }

    public void cutTracksInCueSheet(CueSheet cueSheet) throws IOException {
        logger.entering(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(CueSheet)", cueSheet);
        logger.info("Cutting tracks in cue sheet.");
        for (FileData fileData : cueSheet.getFileData()) {
            try {
                this.cutTracksInFileData(fileData);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                this.logCaughtException(unsupportedAudioFileException);
            }
            catch (IOException iOException) {
                this.logCaughtException(iOException);
            }
        }
        logger.info("Done cutting tracks in cue sheet.");
        logger.exiting(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(CueSheet)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cutTracksInFileData(FileData fileData) throws IOException, UnsupportedAudioFileException {
        logger.entering(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(FileData)", fileData);
        logger.info("Cutting tracks from file: '" + fileData.getFile() + "'.");
        AudioInputStream audioInputStream = null;
        try {
            logger.fine("Determining complete path to audio file.");
            File file = this.getConfiguration().getAudioFile(fileData);
            logger.fine("Opening audio stream.");
            audioInputStream = AudioSystem.getAudioInputStream(file);
            long l = 0L;
            for (TrackCutterProcessingAction trackCutterProcessingAction : this.getProcessActionList(fileData)) {
                l = this.performProcessAction(trackCutterProcessingAction, audioInputStream, l);
            }
        }
        finally {
            if (audioInputStream != null) {
                logger.fine("Closing audio stream.");
                audioInputStream.close();
            }
        }
        logger.exiting(TrackCutter.class.getCanonicalName(), "cutTracksInCueSheet(FileData)");
    }

    private List<TrackCutterProcessingAction> getProcessActionList(FileData fileData) {
        logger.entering(TrackCutter.class.getCanonicalName(), "getProcessActionList(FileData)", fileData);
        logger.fine("Determining processing actions for file: '" + fileData.getFile() + "'.");
        ArrayList<TrackCutterProcessingAction> arrayList = new ArrayList<TrackCutterProcessingAction>();
        TrackData trackData = null;
        for (TrackData trackData2 : fileData.getTrackData()) {
            if (trackData != null) {
                if (trackData2.getIndex(0) != null) {
                    this.addProcessActions(trackData, trackData2.getIndex(0).getPosition(), arrayList);
                } else {
                    this.addProcessActions(trackData, trackData2.getIndex(1).getPosition(), arrayList);
                }
            }
            trackData = trackData2;
        }
        if (trackData != null) {
            this.addProcessActions(trackData, null, arrayList);
        }
        logger.exiting(TrackCutter.class.getCanonicalName(), "getProcessActionList(FileData)", arrayList);
        return arrayList;
    }

    private void addProcessActions(TrackData trackData, Position position, List<TrackCutterProcessingAction> list) {
        logger.entering(TrackCutter.class.getCanonicalName(), "addProcessActions(TrackData,Position,List<TrackCutterProcessingAction>)", new Object[]{trackData, position, list});
        logger.fine("Adding processing action for track #" + trackData.getNumber() + ".");
        if (trackData.getIndex(0) == null) {
            list.add(new TrackCutterProcessingAction(trackData.getIndex(1).getPosition(), position, trackData, false, this.getConfiguration()));
        } else {
            switch (this.configuration.getPregapHandling()) {
                case DISCARD: {
                    list.add(new TrackCutterProcessingAction(trackData.getIndex(1).getPosition(), position, trackData, false, this.getConfiguration()));
                    break;
                }
                case PREPEND: {
                    if ((long)(trackData.getIndex(1).getPosition().getTotalFrames() - trackData.getIndex(0).getPosition().getTotalFrames()) >= this.getConfiguration().getPregapFrameLengthThreshold()) {
                        list.add(new TrackCutterProcessingAction(trackData.getIndex(0).getPosition(), position, trackData, true, this.getConfiguration()));
                        break;
                    }
                    list.add(new TrackCutterProcessingAction(trackData.getIndex(1).getPosition(), position, trackData, false, this.getConfiguration()));
                    break;
                }
                case SEPARATE: {
                    if ((long)(trackData.getIndex(1).getPosition().getTotalFrames() - trackData.getIndex(0).getPosition().getTotalFrames()) >= this.getConfiguration().getPregapFrameLengthThreshold()) {
                        list.add(new TrackCutterProcessingAction(trackData.getIndex(0).getPosition(), trackData.getIndex(1).getPosition(), trackData, true, this.getConfiguration()));
                    }
                    list.add(new TrackCutterProcessingAction(trackData.getIndex(1).getPosition(), position, trackData, false, this.getConfiguration()));
                }
            }
        }
        logger.exiting(TrackCutter.class.getCanonicalName(), "addProcessActions(TrackData,Position,List<TrackCutterProcessingAction>)");
    }

    private long performProcessAction(TrackCutterProcessingAction trackCutterProcessingAction, AudioInputStream audioInputStream, long l) throws IOException {
        logger.entering(TrackCutter.class.getCanonicalName(), "performProcessAction(TrackCutterProcessingAction,AudioInputStream,long)", new Object[]{trackCutterProcessingAction, audioInputStream, l});
        logger.fine("Determining audio substream for processing action for " + (trackCutterProcessingAction.getIsPregap() ? "pregap of " : "") + "track #" + trackCutterProcessingAction.getTrackData().getNumber() + ".");
        long l2 = this.skipToPosition(trackCutterProcessingAction.getStartPosition(), audioInputStream, l);
        long l3 = audioInputStream.getFrameLength();
        if (trackCutterProcessingAction.getEndPosition() != null) {
            l3 = TrackCutter.getAudioFormatFrames(trackCutterProcessingAction.getEndPosition(), audioInputStream.getFormat());
        }
        this.performProcessAction(trackCutterProcessingAction, new AudioInputStream(audioInputStream, audioInputStream.getFormat(), l3 - l2));
        logger.exiting(TrackCutter.class.getCanonicalName(), "performProcessAction(TrackCutterProcessingAction,AudioInputStream,long)");
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performProcessAction(TrackCutterProcessingAction trackCutterProcessingAction, AudioInputStream audioInputStream) throws IOException {
        logger.entering(TrackCutter.class.getCanonicalName(), "performProcessAction(TrackCutterProcessingAction,AudioInputStream)", new Object[]{trackCutterProcessingAction, audioInputStream});
        logger.info("Performing processing action for " + (trackCutterProcessingAction.getIsPregap() ? "pregap of " : "") + "track #" + trackCutterProcessingAction.getTrackData().getNumber() + ".");
        if (!this.getConfiguration().getRedirectToPostprocessing()) {
            logger.fine("Creating directory for target files.");
            trackCutterProcessingAction.getCutFile().getParentFile().mkdirs();
        }
        if (this.configuration.getDoPostProcessing() && this.configuration.getRedirectToPostprocessing()) {
            OutputStream outputStream = null;
            try {
                logger.fine("Writing audio to postprocessor.");
                outputStream = this.createPostProcessingProcess(trackCutterProcessingAction).getOutputStream();
                AudioSystem.write(audioInputStream, this.configuration.getTargetType(), outputStream);
            }
            finally {
                if (outputStream != null) {
                    logger.fine("Closing audio stream.");
                    outputStream.close();
                }
            }
        } else {
            logger.fine("Writing audio to file.");
            AudioSystem.write(audioInputStream, this.configuration.getTargetType(), trackCutterProcessingAction.getCutFile());
            if (this.configuration.getDoPostProcessing()) {
                logger.fine("Performing postprocessing.");
                this.createPostProcessingProcess(trackCutterProcessingAction);
            }
        }
        logger.exiting(TrackCutter.class.getCanonicalName(), "performProcessAction(TrackCutterProcessingAction,AudioInputStream)");
    }

    private Process createPostProcessingProcess(TrackCutterProcessingAction trackCutterProcessingAction) throws IOException {
        logger.entering(TrackCutter.class.getCanonicalName(), "performProcessAction(TrackCutterProcessingAction)", trackCutterProcessingAction);
        logger.fine("Creating post-processing process for command: " + trackCutterProcessingAction.getPostProcessCommand());
        trackCutterProcessingAction.getPostProcessFile().getParentFile().mkdirs();
        Process process = Runtime.getRuntime().exec(trackCutterProcessingAction.getPostProcessCommand());
        StreamPiper.pipeStream(process.getInputStream(), trackCutterProcessingAction.getStdOutRedirectFile());
        StreamPiper.pipeStream(process.getErrorStream(), trackCutterProcessingAction.getErrRedirectFile());
        logger.exiting(TrackCutter.class.getCanonicalName(), "performProcessAction(TrackCutterProcessingAction)", process);
        return process;
    }

    private static long getAudioFormatFrames(Position position, AudioFormat audioFormat) {
        logger.entering(TrackCutter.class.getCanonicalName(), "getAudioFormatFrames(Position,AudioFormat)", new Object[]{position, audioFormat});
        long l = Math.round((double)audioFormat.getFrameRate() / 75.0 * (double)position.getTotalFrames());
        logger.exiting(TrackCutter.class.getCanonicalName(), "getAudioFormatFrames(Position,AudioFormat)", l);
        return l;
    }

    private long skipToPosition(Position position, AudioInputStream audioInputStream, long l) throws IOException {
        logger.entering(TrackCutter.class.getCanonicalName(), "skipToPosition(Position,AudioInputStream,long)", new Object[]{position, audioInputStream, l});
        long l2 = TrackCutter.getAudioFormatFrames(position, audioInputStream.getFormat());
        audioInputStream.skip((l2 - l) * (long)audioInputStream.getFormat().getFrameSize());
        logger.exiting(TrackCutter.class.getCanonicalName(), "skipToPosition(Position,AudioInputStream,long)", l2);
        return l2;
    }

    private void logCaughtException(Exception exception) {
        logger.entering(TrackCutter.class.getCanonicalName(), "logCaughtException(Exception)", exception);
        logger.severe("Encountered an " + exception.getClass().getCanonicalName() + ": " + exception.getMessage());
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        logger.fine(stringWriter.toString());
        logger.exiting(TrackCutter.class.getCanonicalName(), "logCaughtException(Exception)");
    }

    private TrackCutterConfiguration getConfiguration() {
        logger.entering(TrackCutter.class.getCanonicalName(), "getConfiguration()");
        logger.exiting(TrackCutter.class.getCanonicalName(), "getConfiguration()", this.configuration);
        return this.configuration;
    }
}

