> [!NOTE]
This page is about the [website icons](https://bitwarden.com/help/website-icons/#using-website-icons) displayed next your entries (when using the `internal` icon service). If you want to customize the look of the web-vault you should refer to [Customize Vaultwarden CSS](Customize-Vaultwarden-CSS)

> [!IMPORTANT]
The clients will only request icons for entries where you have configured an Autofill URI.
Be aware that you can also turn off website icons in your client settings, in which case the client will not request icons from Vaultwarden.

If you want to add custom icons for your website entries you can place them in the location of the `ICON_CACHE_FOLDER` (which defaults to `data/icon_cache`). The naming is based on the specified IP or fully qualified domain name (FQDN) of your entry, i.e. what Bitwarden calls Hostname in [this graphic](https://bitwarden.com/help/uri-match-detection/#match-detection-options):
![bitwarden-uri-graphic](https://github.com/user-attachments/assets/47bdf0f1-46f9-41af-8030-d0f860e2a056)  
This means the scheme and port will be ignored when requesting icons, so you can't provide different icons based on the port number.

While the web-vault supports a couple of image types like ICO, BMP, GIF, JPG, WEBP and PNG, the cached icons themselves are always named `<fqdn>.png` or `<IP>.png` (eg. `data/icon_cache/en.wikipedia.org.png`). So you should name your custom icons accordingly.

## How the icon cache expiration works

If an icon file already exists it will check its last modification time if it is outdated (which is configurable via `ICON_CACHE_TTL`). If it is expired, it will try to fetch a new icon instead of serving that icon. You can disable the expiration feature by setting `ICON_CACHE_TTL=0` so that Vaultwarden will keep any existing icon locally cached forever.

If setting `ICON_CACHE_TTL=0` is not an option for you (because you want to get new icons for most websites and only provide a few custom ones), you can also write a cron job that regularly calls `touch` on your custom placed icons so their modification time is kept fresh and they won't expire. 

> [!IMPORTANT]
By default `ICON_CACHE_TTL` is set to 2592000 seconds so if you don't disable expiration or regularly update the modification time any manually placed icon will be ignored and possible overwritten after 30 days.

If fetching an icon fails (for whatever reason), Vaultwarden will create an (empty) `.miss` file for that domain (e.g. `data/icon_cache/en.wikipedia.org.png.miss`) in the `ICON_CACHE_FOLDER` and not try fetching an icon again for `ICON_CACHE_NEGTTL` and instead serve an fallback icon instead. The miss file is removed automatically on a new request once the miss file has expired. (Expired in this case means its age is larger than `ICON_CACHE_NEGTTL` seconds which defaults to 3 days.)

> [!IMPORTANT]
As long as there is an `.miss` file (that has not yet expired) Vaultwarden will always serve the fallback icon even if there is a valid icon. So remove the corresponding miss file for any custom icon you have created or which modification time you have updated.

### Website Icon Troubleshooting

If you have not disabled icon download (`DISABLE_ICON_DOWNLOAD`) Vaultwardens `internal` icon service will download the requested icon from a given resource. This is done using a network request to the given domain / ip (disregarding the port). If your Vaultwarden server cannot make outgoing requests (e.g. because of missing internet access) downloading new icons will not work.

By default, Vaultwarden will also [block certain IP ranges](https://github.com/dani-garcia/vaultwarden/blob/9059437c35e35ab8eb7d1d4716bf13eec0a4ee64/src/util.rs#L776-L819) which it considers non-global (i.e. your private network) due to security concerns. You can also further configure which hosts Vaultwarden should block additionally by specifying a `HTTP_REQUEST_BLOCK_REGEX`.

If you set `ICON_CACHE_NEGTTL=0` you disable the expiration of the miss indicator which means that Vaultwarden will always serve the default fallback icon for the given domain.