#ifndef ATL_dtGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,102,180,219,258,297,336,414,492,531,570,609,648,686,725,764,803,881,959,1037,1115,1193,1271,1582,1894,2206,2518,3141,3765,3842,3920,3998,4076,4232,4388,4700,5012,6259,7506,10000
 * N : 25,102,180,219,258,297,336,414,492,531,570,609,648,686,725,764,803,881,959,1037,1115,1193,1271,1582,1894,2206,2518,3141,3765,3842,3920,3998,4076,4232,4388,4700,5012,6259,7506,10000
 * NB : 1,1,7,15,23,26,27,27,28,29,30,34,35,34,41,42,43,44,47,47,48,50,51,58,99,99,126,132,134,135,138,142,166,174,252,315,315,315,504,504
 */
#define ATL_dtGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 141) (nb_) = 1; \
   else if ((n_) < 199) (nb_) = 7; \
   else if ((n_) < 238) (nb_) = 15; \
   else if ((n_) < 277) (nb_) = 23; \
   else if ((n_) < 316) (nb_) = 26; \
   else if ((n_) < 453) (nb_) = 27; \
   else if ((n_) < 511) (nb_) = 28; \
   else if ((n_) < 550) (nb_) = 29; \
   else if ((n_) < 589) (nb_) = 30; \
   else if ((n_) < 628) (nb_) = 34; \
   else if ((n_) < 667) (nb_) = 35; \
   else if ((n_) < 705) (nb_) = 34; \
   else if ((n_) < 744) (nb_) = 41; \
   else if ((n_) < 783) (nb_) = 42; \
   else if ((n_) < 842) (nb_) = 43; \
   else if ((n_) < 920) (nb_) = 44; \
   else if ((n_) < 1076) (nb_) = 47; \
   else if ((n_) < 1154) (nb_) = 48; \
   else if ((n_) < 1232) (nb_) = 50; \
   else if ((n_) < 1426) (nb_) = 51; \
   else if ((n_) < 1738) (nb_) = 58; \
   else if ((n_) < 2362) (nb_) = 99; \
   else if ((n_) < 2829) (nb_) = 126; \
   else if ((n_) < 3453) (nb_) = 132; \
   else if ((n_) < 3803) (nb_) = 134; \
   else if ((n_) < 3881) (nb_) = 135; \
   else if ((n_) < 3959) (nb_) = 138; \
   else if ((n_) < 4037) (nb_) = 142; \
   else if ((n_) < 4154) (nb_) = 166; \
   else if ((n_) < 4310) (nb_) = 174; \
   else if ((n_) < 4544) (nb_) = 252; \
   else if ((n_) < 6882) (nb_) = 315; \
   else (nb_) = 504; \
}


#endif    /* end ifndef ATL_dtGetNB_geqrf */
