#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,190,355,437,520,603,686,851,1017,1182,1348,1679,2010,2341,2672,2713,2754,2795,2837,3003,3334,3996,5320
 * N : 25,190,355,437,520,603,686,851,1017,1182,1348,1679,2010,2341,2672,2713,2754,2795,2837,3003,3334,3996,5320
 * NB : 1,1,11,11,12,12,15,15,16,16,23,23,24,24,27,27,28,28,332,332,332,332,332
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 272) (nb_) = 1; \
   else if ((n_) < 478) (nb_) = 11; \
   else if ((n_) < 644) (nb_) = 12; \
   else if ((n_) < 934) (nb_) = 15; \
   else if ((n_) < 1265) (nb_) = 16; \
   else if ((n_) < 1844) (nb_) = 23; \
   else if ((n_) < 2506) (nb_) = 24; \
   else if ((n_) < 2733) (nb_) = 27; \
   else if ((n_) < 2816) (nb_) = 28; \
   else (nb_) = 332; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
