/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.testing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextArea;
import net.sf.wraplog.AbstractLogger;

class TestAppLogger
extends AbstractLogger {
    private JTextArea debugTextArea;
    private String[] levelText;
    private SimpleDateFormat format;

    public TestAppLogger(JTextArea debugTextArea, String[] levelLabels, String dateFormat) {
        this.debugTextArea = debugTextArea;
        this.levelText = levelLabels;
        this.format = new SimpleDateFormat(dateFormat);
    }

    protected void reallyLog(int logLevel, String message, Throwable error) throws Exception {
        if (message == null) {
            message = "null";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        String threadName = Thread.currentThread().getName();
        String dateAndTime = this.format.format(new Date());
        printWriter.println(dateAndTime + " [" + threadName + "] " + this.getLevelText(logLevel) + " " + message);
        if (error != null) {
            error.printStackTrace(printWriter);
        }
        printWriter.println();
        printWriter.close();
        this.debugTextArea.append(stringWriter.toString());
    }

    public String getLevelText() {
        return this.getLevelText(this.getLevel());
    }

    public String[] getLevelOptions() {
        return this.levelText;
    }

    private String getLevelText(int logLevel) {
        if (logLevel < 0 || logLevel > 3) {
            throw new IllegalArgumentException("logLevel must be one of those defined in net.sf.warplog.Level, but is " + logLevel);
        }
        return this.levelText[logLevel];
    }
}

