/*
 * curs_util.h - curses utitlites
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 *
 * Description:
 *
 *     This module is some kind of curses wrapper to enhance curses and make
 *     it easier to work with it when writing apps needed to print text only
 *
 *
 * Howto Use:
 *
 *     1) Call curs_init() to initialize the screen
 *     2) Set row to 0 before starting to draw in _every_ mainloop cycle
 *     3) use the this API or the curses API directly to draw stuff
 *
 *
 * TODO:
 *  - there are still functions not belonging into this module but they are
 *    used everywhere, i don't want to make a special module for them. I
 *    should maybe put them into utils.
 *
 */

#ifndef CURS_UTIL_H_
#define CURS_UTIL_H_

#include <curses.h>

/*
 * Safe move(++row,0)
 */
#define NEXT_ROW {                      \
    row++;                              \
    if (row >= LINES-1)                 \
        return;                         \
    move(row,0);                        \
}


/*
 * global variable of current row
 */
extern int row;
extern int redraw_screen;

/*
 * initialize curses screen
 */
void curs_init(void);


/*
 * prints full lines, this means it will not print over the right border
 * and it will fill out the space between the last character ant the
 * right border with spaces
 *
 * Note: current column must be 0
 */
void print_full_line(const char *fmt, ...);


/*
 * prints a seperator
 *
 * Note: current column must be 0
 */
void print_sep(void);

/*
 * fill current row + 1 to end of screen - 1 with empty lines
 */
void print_to_end(void);

/*
 * print status bar in reverse mode
 */
void print_status(const char *appname);

/*
 * print top title in reverse mode
 */
void print_top(const char *fmt, ...);

#endif
