#include "defs.h"
#include <stdio.h>
#include <stdlib.h>
#include "printtext.h"
#include "imageio.h"
#include "arglist.h"
#include "patternlist.h"
#include "asciichars.h"
#include "pattern.h"
#ifdef USE_CLUSTER
#include "cluster.h"
#endif

void printerrorstring(char* title,char *errormessage) {

   if (errormessage!=NULL) fprintf(stderr,"%s: Error: %s!\n\n",title,errormessage);
   fprintf(stderr,"This program will create an image containing\n   some detected ASCII patterns in the source!\n\n");
   fprintf(stderr,"Usage: %s <source1> [<destination>] \\\n",title);
#ifdef USE_CLUSTER
   fprintf(stderr,"        [ -j <threads> ] \\\n");
#endif
   fprintf(stderr,"        [--help] [-h]\n\n");
}

int main (int argc, char *argv[]) {
   ImagePtr imsource, imdest;	/*Working images*/
   struct patternfield answer;	/*return value*/
   struct arglist* carglist;	/*commandline options*/
   struct patternlist* patterns;/*patterns to detect*/
   int t,tt;			/*tmp integers ;)*/
#ifdef USE_CLUSTER
   int threads;			/*number of threads*/
#endif


   patterns=asciichars();
   /*load ascii patterns ;) */
   
   carglist = arglist_new(argc, argv);
   arglist_addarg (carglist,"--help",0);
   arglist_addarg (carglist,"-h",0);
#ifdef USE_CLUSTER
   arglist_addarg (carglist,"-j",1);
#endif



   printwelcomestring();

   if ((arglist_arggiven(carglist,"--help")==0) || (arglist_arggiven(carglist,"-h")==0)) {
      printerrorstring(argv[0],NULL);
      printusagestring();
      return -1;
   }

   if ((arglist_parameter(carglist,"VOIDARGS",2)!=NULL) || (arglist_parameter(carglist,"VOIDARGS",0)==NULL)){
      printerrorstring(argv[0],"Error parsing commandline");
      printusagestring();
      return -1;
   }
   /*Check parameter count*/

#ifdef USE_CLUSTER
   threads=DEFAULT_THREADS;
   if (arglist_arggiven(carglist,"-j")==0) {
      threads=arglist_integer(arglist_parameter(carglist,"-j",0));
   }
   if (threads<1) {
      printerrorstring(argv[0],"Error parsing commandline,\nprocess amount <threads> has to be greater 0.");
      printusagestring();
      return -1;
   }
   /*Check process count */

   cluster_setpnum(threads);
#endif

   imsource=loadim(arglist_parameter(carglist,"VOIDARGS",0));
   if (imsource==NULL) {
      printerrorstring(argv[0],"Error loading source image 1");
      printusagestring();
      return -1;
   }
   /*Load Sourcefile*/
   
   answer=pattern(&imdest,imsource,ascii_width-ascii_xdepth,ascii_height-ascii_ydepth,ascii_xdepth,ascii_ydepth,patterns);
   /*Do the main work in pattern.h*/

   if (arglist_parameter(carglist,"VOIDARGS",1)!=NULL) {
      if (saveim(imdest,arglist_parameter(carglist,"VOIDARGS",1))!=0) {
         printerrorstring(argv[0],"Error saving destination image");
      }
      /*Save the resulting image*/
   }

   destroyim(imsource);
   destroyim(imdest);
   /*We free our memory*/

   fprintf(stderr,"Here follows the detected ascii chart:\n");
   t=0;
   while (t<answer.height) {
      tt=0;
      while (tt<answer.width) {
         fprintf(stdout,"%c",answer.pattern[answer.width*t+tt]);
         tt++;
      };
      fprintf(stdout,"\n");
      t++;
   }
   
   arglist_kill(carglist);
   /*i forgot to kill the commandline argument list*/

   patternlist_kill(patterns);
   free(answer.pattern);
   /*free some memory*/
   return 0;

}
