#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 4018
#define LARGE_STATE_COUNT 2321
#define SYMBOL_COUNT 573
#define ALIAS_COUNT 1
#define TOKEN_COUNT 390
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 55
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 110

enum ts_symbol_identifiers {
  sym_command_name = 1,
  sym__whitespace = 2,
  sym_line_comment = 3,
  anon_sym_BSLASHiffalse = 4,
  anon_sym_BSLASHfi = 5,
  anon_sym_LBRACK = 6,
  anon_sym_RBRACK = 7,
  anon_sym_COMMA = 8,
  anon_sym_EQ = 9,
  anon_sym_LPAREN = 10,
  anon_sym_RPAREN = 11,
  anon_sym_BSLASHpart = 12,
  anon_sym_BSLASHpart_STAR = 13,
  anon_sym_BSLASHaddpart = 14,
  anon_sym_BSLASHaddpart_STAR = 15,
  anon_sym_BSLASHchapter = 16,
  anon_sym_BSLASHchapter_STAR = 17,
  anon_sym_BSLASHaddchap = 18,
  anon_sym_BSLASHaddchap_STAR = 19,
  anon_sym_BSLASHsection = 20,
  anon_sym_BSLASHsection_STAR = 21,
  anon_sym_BSLASHaddsec = 22,
  anon_sym_BSLASHaddsec_STAR = 23,
  anon_sym_BSLASHsubsection = 24,
  anon_sym_BSLASHsubsection_STAR = 25,
  anon_sym_BSLASHsubsubsection = 26,
  anon_sym_BSLASHsubsubsection_STAR = 27,
  anon_sym_BSLASHparagraph = 28,
  anon_sym_BSLASHparagraph_STAR = 29,
  anon_sym_BSLASHsubparagraph = 30,
  anon_sym_BSLASHsubparagraph_STAR = 31,
  anon_sym_BSLASHitem = 32,
  anon_sym_BSLASHitem_STAR = 33,
  anon_sym_LBRACE = 34,
  anon_sym_RBRACE = 35,
  anon_sym_BSLASHand = 36,
  sym_word = 37,
  sym_placeholder = 38,
  sym_delimiter = 39,
  sym_path = 40,
  sym_uri = 41,
  sym_argc = 42,
  aux_sym__glob_pattern_fragment_token1 = 43,
  anon_sym_PLUS = 44,
  anon_sym_DASH = 45,
  anon_sym_STAR = 46,
  anon_sym_SLASH = 47,
  anon_sym_LT = 48,
  anon_sym_GT = 49,
  anon_sym_BANG = 50,
  anon_sym_PIPE = 51,
  anon_sym_COLON = 52,
  anon_sym_SQUOTE = 53,
  sym_letter = 54,
  anon_sym__ = 55,
  anon_sym_CARET = 56,
  anon_sym_DOLLAR_DOLLAR = 57,
  anon_sym_BSLASH_LBRACK = 58,
  anon_sym_BSLASH_RBRACK = 59,
  anon_sym_DOLLAR = 60,
  anon_sym_BSLASH_LPAREN = 61,
  anon_sym_BSLASH_RPAREN = 62,
  anon_sym_BSLASHleft = 63,
  anon_sym_BSLASHbigl = 64,
  anon_sym_BSLASHBigl = 65,
  anon_sym_BSLASHbiggl = 66,
  anon_sym_BSLASHBiggl = 67,
  anon_sym_BSLASHright = 68,
  anon_sym_BSLASHbigr = 69,
  anon_sym_BSLASHBigr = 70,
  anon_sym_BSLASHbiggr = 71,
  anon_sym_BSLASHBiggr = 72,
  anon_sym_BSLASHtext = 73,
  anon_sym_BSLASHintertext = 74,
  anon_sym_BSLASHshortintertext = 75,
  anon_sym_BSLASHbegin = 76,
  anon_sym_BSLASHend = 77,
  anon_sym_comment = 78,
  anon_sym_verbatim = 79,
  anon_sym_lstlisting = 80,
  anon_sym_minted = 81,
  anon_sym_asy = 82,
  anon_sym_asydef = 83,
  anon_sym_pycode = 84,
  anon_sym_luacode = 85,
  anon_sym_luacode_STAR = 86,
  anon_sym_sagesilent = 87,
  anon_sym_sageblock = 88,
  anon_sym_math = 89,
  anon_sym_displaymath = 90,
  anon_sym_displaymath_STAR = 91,
  anon_sym_equation = 92,
  anon_sym_equation_STAR = 93,
  anon_sym_multline = 94,
  anon_sym_multline_STAR = 95,
  anon_sym_eqnarray = 96,
  anon_sym_eqnarray_STAR = 97,
  anon_sym_align = 98,
  anon_sym_align_STAR = 99,
  anon_sym_aligned = 100,
  anon_sym_aligned_STAR = 101,
  anon_sym_array = 102,
  anon_sym_array_STAR = 103,
  anon_sym_split = 104,
  anon_sym_split_STAR = 105,
  anon_sym_alignat = 106,
  anon_sym_alignat_STAR = 107,
  anon_sym_alignedat = 108,
  anon_sym_alignedat_STAR = 109,
  anon_sym_gather = 110,
  anon_sym_gather_STAR = 111,
  anon_sym_gathered = 112,
  anon_sym_gathered_STAR = 113,
  anon_sym_flalign = 114,
  anon_sym_flalign_STAR = 115,
  anon_sym_BSLASHtitle = 116,
  anon_sym_BSLASHauthor = 117,
  anon_sym_BSLASHusepackage = 118,
  anon_sym_BSLASHRequirePackage = 119,
  anon_sym_BSLASHdocumentclass = 120,
  anon_sym_BSLASHinclude = 121,
  anon_sym_BSLASHsubfileinclude = 122,
  anon_sym_BSLASHinput = 123,
  anon_sym_BSLASHsubfile = 124,
  anon_sym_BSLASHaddbibresource = 125,
  anon_sym_BSLASHbibliographystyle = 126,
  anon_sym_BSLASHbibliography = 127,
  anon_sym_BSLASHincludegraphics = 128,
  anon_sym_BSLASHincludesvg = 129,
  anon_sym_BSLASHincludeinkscape = 130,
  anon_sym_BSLASHverbatiminput = 131,
  anon_sym_BSLASHVerbatimInput = 132,
  anon_sym_BSLASHimport = 133,
  anon_sym_BSLASHsubimport = 134,
  anon_sym_BSLASHinputfrom = 135,
  anon_sym_BSLASHsubimportfrom = 136,
  anon_sym_BSLASHincludefrom = 137,
  anon_sym_BSLASHsubincludefrom = 138,
  anon_sym_BSLASHcaption = 139,
  anon_sym_BSLASHcite = 140,
  anon_sym_BSLASHcite_STAR = 141,
  anon_sym_BSLASHCite = 142,
  anon_sym_BSLASHnocite = 143,
  anon_sym_BSLASHcitet = 144,
  anon_sym_BSLASHcitep = 145,
  anon_sym_BSLASHcitet_STAR = 146,
  anon_sym_BSLASHcitep_STAR = 147,
  anon_sym_BSLASHciteA = 148,
  anon_sym_BSLASHciteR = 149,
  anon_sym_BSLASHciteS = 150,
  anon_sym_BSLASHciteyearR = 151,
  anon_sym_BSLASHciteauthor = 152,
  anon_sym_BSLASHciteauthor_STAR = 153,
  anon_sym_BSLASHCiteauthor = 154,
  anon_sym_BSLASHCiteauthor_STAR = 155,
  anon_sym_BSLASHcitetitle = 156,
  anon_sym_BSLASHcitetitle_STAR = 157,
  anon_sym_BSLASHciteyear = 158,
  anon_sym_BSLASHciteyear_STAR = 159,
  anon_sym_BSLASHcitedate = 160,
  anon_sym_BSLASHcitedate_STAR = 161,
  anon_sym_BSLASHciteurl = 162,
  anon_sym_BSLASHfullcite = 163,
  anon_sym_BSLASHciteyearpar = 164,
  anon_sym_BSLASHcitealt = 165,
  anon_sym_BSLASHcitealp = 166,
  anon_sym_BSLASHcitetext = 167,
  anon_sym_BSLASHparencite = 168,
  anon_sym_BSLASHparencite_STAR = 169,
  anon_sym_BSLASHParencite = 170,
  anon_sym_BSLASHfootcite = 171,
  anon_sym_BSLASHfootfullcite = 172,
  anon_sym_BSLASHfootcitetext = 173,
  anon_sym_BSLASHtextcite = 174,
  anon_sym_BSLASHTextcite = 175,
  anon_sym_BSLASHsmartcite = 176,
  anon_sym_BSLASHSmartcite = 177,
  anon_sym_BSLASHsupercite = 178,
  anon_sym_BSLASHautocite = 179,
  anon_sym_BSLASHAutocite = 180,
  anon_sym_BSLASHautocite_STAR = 181,
  anon_sym_BSLASHAutocite_STAR = 182,
  anon_sym_BSLASHvolcite = 183,
  anon_sym_BSLASHVolcite = 184,
  anon_sym_BSLASHpvolcite = 185,
  anon_sym_BSLASHPvolcite = 186,
  anon_sym_BSLASHfvolcite = 187,
  anon_sym_BSLASHftvolcite = 188,
  anon_sym_BSLASHsvolcite = 189,
  anon_sym_BSLASHSvolcite = 190,
  anon_sym_BSLASHtvolcite = 191,
  anon_sym_BSLASHTvolcite = 192,
  anon_sym_BSLASHavolcite = 193,
  anon_sym_BSLASHAvolcite = 194,
  anon_sym_BSLASHnotecite = 195,
  anon_sym_BSLASHNotecite = 196,
  anon_sym_BSLASHpnotecite = 197,
  anon_sym_BSLASHPnotecite = 198,
  anon_sym_BSLASHfnotecite = 199,
  anon_sym_BSLASHlabel = 200,
  anon_sym_BSLASHref = 201,
  anon_sym_BSLASHeqref = 202,
  anon_sym_BSLASHvref = 203,
  anon_sym_BSLASHVref = 204,
  anon_sym_BSLASHautoref = 205,
  anon_sym_BSLASHautoref_STAR = 206,
  anon_sym_BSLASHpageref = 207,
  anon_sym_BSLASHpageref_STAR = 208,
  anon_sym_BSLASHautopageref = 209,
  anon_sym_BSLASHautopageref_STAR = 210,
  anon_sym_BSLASHcref = 211,
  anon_sym_BSLASHcref_STAR = 212,
  anon_sym_BSLASHCref = 213,
  anon_sym_BSLASHCref_STAR = 214,
  anon_sym_BSLASHcpageref = 215,
  anon_sym_BSLASHCpageref = 216,
  anon_sym_BSLASHnamecref = 217,
  anon_sym_BSLASHnameCref = 218,
  anon_sym_BSLASHlcnamecref = 219,
  anon_sym_BSLASHnamecrefs = 220,
  anon_sym_BSLASHnameCrefs = 221,
  anon_sym_BSLASHlcnamecrefs = 222,
  anon_sym_BSLASHlabelcref = 223,
  anon_sym_BSLASHlabelcref_STAR = 224,
  anon_sym_BSLASHlabelcpageref = 225,
  anon_sym_BSLASHlabelcpageref_STAR = 226,
  anon_sym_BSLASHcrefrange = 227,
  anon_sym_BSLASHcrefrange_STAR = 228,
  anon_sym_BSLASHCrefrange = 229,
  anon_sym_BSLASHCrefrange_STAR = 230,
  anon_sym_BSLASHcpagerefrange = 231,
  anon_sym_BSLASHCpagerefrange = 232,
  anon_sym_BSLASHnewlabel = 233,
  anon_sym_BSLASHnewcommand = 234,
  anon_sym_BSLASHnewcommand_STAR = 235,
  anon_sym_BSLASHrenewcommand = 236,
  anon_sym_BSLASHrenewcommand_STAR = 237,
  anon_sym_BSLASHprovidecommand = 238,
  anon_sym_BSLASHprovidecommand_STAR = 239,
  anon_sym_BSLASHDeclareRobustCommand = 240,
  anon_sym_BSLASHDeclareRobustCommand_STAR = 241,
  anon_sym_BSLASHDeclareMathOperator = 242,
  anon_sym_BSLASHDeclareMathOperator_STAR = 243,
  anon_sym_BSLASHNewDocumentCommand = 244,
  anon_sym_BSLASHRenewDocumentCommand = 245,
  anon_sym_BSLASHProvideDocumentCommand = 246,
  anon_sym_BSLASHDeclareDocumentCommand = 247,
  anon_sym_BSLASHNewExpandableDocumentCommand = 248,
  anon_sym_BSLASHRenewExpandableDocumentCommand = 249,
  anon_sym_BSLASHProvideExpandableDocumentCommand = 250,
  anon_sym_BSLASHDeclareExpandableDocumentCommand = 251,
  anon_sym_BSLASHNewCommandCopy = 252,
  anon_sym_BSLASHRenewCommandCopy = 253,
  anon_sym_BSLASHDeclareCommandCopy = 254,
  anon_sym_BSLASHdef = 255,
  anon_sym_BSLASHgdef = 256,
  anon_sym_BSLASHedef = 257,
  anon_sym_BSLASHxdef = 258,
  anon_sym_BSLASHlet = 259,
  anon_sym_BSLASHglet = 260,
  anon_sym_BSLASHDeclarePairedDelimiter = 261,
  anon_sym_BSLASHDeclarePairedDelimiterX = 262,
  anon_sym_BSLASHnewenvironment = 263,
  anon_sym_BSLASHrenewenvironment = 264,
  anon_sym_BSLASHNewDocumentEnvironment = 265,
  anon_sym_BSLASHRenewDocumentEnvironment = 266,
  anon_sym_BSLASHProvideDocumentEnvironment = 267,
  anon_sym_BSLASHDeclareDocumentEnvironment = 268,
  anon_sym_BSLASHNewEnvironmentCopy = 269,
  anon_sym_BSLASHRenewEnvironmentCopy = 270,
  anon_sym_BSLASHDeclareEnvironmentCopy = 271,
  anon_sym_BSLASHnewglossaryentry = 272,
  anon_sym_BSLASHgls = 273,
  anon_sym_BSLASHGls = 274,
  anon_sym_BSLASHGLS = 275,
  anon_sym_BSLASHglspl = 276,
  anon_sym_BSLASHGlspl = 277,
  anon_sym_BSLASHGLSpl = 278,
  anon_sym_BSLASHglsdisp = 279,
  anon_sym_BSLASHglslink = 280,
  anon_sym_BSLASHglstext = 281,
  anon_sym_BSLASHGlstext = 282,
  anon_sym_BSLASHGLStext = 283,
  anon_sym_BSLASHglsfirst = 284,
  anon_sym_BSLASHGlsfirst = 285,
  anon_sym_BSLASHGLSfirst = 286,
  anon_sym_BSLASHglsplural = 287,
  anon_sym_BSLASHGlsplural = 288,
  anon_sym_BSLASHGLSplural = 289,
  anon_sym_BSLASHglsfirstplural = 290,
  anon_sym_BSLASHGlsfirstplural = 291,
  anon_sym_BSLASHGLSfirstplural = 292,
  anon_sym_BSLASHglsname = 293,
  anon_sym_BSLASHGlsname = 294,
  anon_sym_BSLASHGLSname = 295,
  anon_sym_BSLASHglssymbol = 296,
  anon_sym_BSLASHGlssymbol = 297,
  anon_sym_BSLASHglsdesc = 298,
  anon_sym_BSLASHGlsdesc = 299,
  anon_sym_BSLASHGLSdesc = 300,
  anon_sym_BSLASHglsuseri = 301,
  anon_sym_BSLASHGlsuseri = 302,
  anon_sym_BSLASHGLSuseri = 303,
  anon_sym_BSLASHglsuserii = 304,
  anon_sym_BSLASHGlsuserii = 305,
  anon_sym_BSLASHGLSuserii = 306,
  anon_sym_BSLASHglsuseriii = 307,
  anon_sym_BSLASHGlsuseriii = 308,
  anon_sym_BSLASHGLSuseriii = 309,
  anon_sym_BSLASHglsuseriv = 310,
  anon_sym_BSLASHGlsuseriv = 311,
  anon_sym_BSLASHGLSuseriv = 312,
  anon_sym_BSLASHglsuserv = 313,
  anon_sym_BSLASHGlsuserv = 314,
  anon_sym_BSLASHGLSuserv = 315,
  anon_sym_BSLASHglsuservi = 316,
  anon_sym_BSLASHGlsuservi = 317,
  anon_sym_BSLASHGLSuservi = 318,
  anon_sym_BSLASHnewacronym = 319,
  anon_sym_BSLASHacrshort = 320,
  anon_sym_BSLASHAcrshort = 321,
  anon_sym_BSLASHACRshort = 322,
  anon_sym_BSLASHacrshortpl = 323,
  anon_sym_BSLASHAcrshortpl = 324,
  anon_sym_BSLASHACRshortpl = 325,
  anon_sym_BSLASHacrlong = 326,
  anon_sym_BSLASHAcrlong = 327,
  anon_sym_BSLASHACRlong = 328,
  anon_sym_BSLASHacrlongpl = 329,
  anon_sym_BSLASHAcrlongpl = 330,
  anon_sym_BSLASHACRlongpl = 331,
  anon_sym_BSLASHacrfull = 332,
  anon_sym_BSLASHAcrfull = 333,
  anon_sym_BSLASHACRfull = 334,
  anon_sym_BSLASHacrfullpl = 335,
  anon_sym_BSLASHAcrfullpl = 336,
  anon_sym_BSLASHACRfullpl = 337,
  anon_sym_BSLASHacs = 338,
  anon_sym_BSLASHAcs = 339,
  anon_sym_BSLASHacsp = 340,
  anon_sym_BSLASHAcsp = 341,
  anon_sym_BSLASHacl = 342,
  anon_sym_BSLASHAcl = 343,
  anon_sym_BSLASHaclp = 344,
  anon_sym_BSLASHAclp = 345,
  anon_sym_BSLASHacf = 346,
  anon_sym_BSLASHAcf = 347,
  anon_sym_BSLASHacfp = 348,
  anon_sym_BSLASHAcfp = 349,
  anon_sym_BSLASHac = 350,
  anon_sym_BSLASHAc = 351,
  anon_sym_BSLASHacp = 352,
  anon_sym_BSLASHglsentrylong = 353,
  anon_sym_BSLASHGlsentrylong = 354,
  anon_sym_BSLASHglsentrylongpl = 355,
  anon_sym_BSLASHGlsentrylongpl = 356,
  anon_sym_BSLASHglsentryshort = 357,
  anon_sym_BSLASHGlsentryshort = 358,
  anon_sym_BSLASHglsentryshortpl = 359,
  anon_sym_BSLASHGlsentryshortpl = 360,
  anon_sym_BSLASHglsentryfullpl = 361,
  anon_sym_BSLASHGlsentryfullpl = 362,
  anon_sym_BSLASHnewtheorem = 363,
  anon_sym_BSLASHnewtheorem_STAR = 364,
  anon_sym_BSLASHdeclaretheorem = 365,
  anon_sym_BSLASHdeclaretheorem_STAR = 366,
  anon_sym_BSLASHdefinecolor = 367,
  anon_sym_BSLASHdefinecolorset = 368,
  anon_sym_BSLASHcolor = 369,
  anon_sym_BSLASHpagecolor = 370,
  anon_sym_BSLASHtextcolor = 371,
  anon_sym_BSLASHmathcolor = 372,
  anon_sym_BSLASHcolorbox = 373,
  anon_sym_BSLASHusepgflibrary = 374,
  anon_sym_BSLASHusetikzlibrary = 375,
  anon_sym_BSLASHurl = 376,
  anon_sym_BSLASHhref = 377,
  sym__trivia_raw_fi = 378,
  sym__trivia_raw_env_comment = 379,
  sym__trivia_raw_env_verbatim = 380,
  sym__trivia_raw_env_listing = 381,
  sym__trivia_raw_env_minted = 382,
  sym__trivia_raw_env_asy = 383,
  sym__trivia_raw_env_asydef = 384,
  sym__trivia_raw_env_pycode = 385,
  sym__trivia_raw_env_luacode = 386,
  sym__trivia_raw_env_luacode_star = 387,
  sym__trivia_raw_env_sagesilent = 388,
  sym__trivia_raw_env_sageblock = 389,
  sym_source_file = 390,
  sym_block_comment = 391,
  sym__root_content = 392,
  sym__flat_content = 393,
  sym__text_with_env_content = 394,
  sym__text_content = 395,
  sym__section = 396,
  sym__paragraph = 397,
  sym__section_part = 398,
  sym__part_declaration = 399,
  sym_part = 400,
  sym__chapter_declaration = 401,
  sym_chapter = 402,
  sym__section_declaration = 403,
  sym_section = 404,
  sym__subsection_declaration = 405,
  sym_subsection = 406,
  sym__subsubsection_declaration = 407,
  sym_subsubsection = 408,
  sym__paragraph_declaration = 409,
  sym_paragraph = 410,
  sym__subparagraph_declaration = 411,
  sym_subparagraph = 412,
  sym__enum_itemdeclaration = 413,
  sym_enum_item = 414,
  sym_curly_group = 415,
  sym_curly_group_text = 416,
  sym_curly_group_spec = 417,
  sym_curly_group_text_list = 418,
  sym_curly_group_path = 419,
  sym_curly_group_path_list = 420,
  sym_curly_group_uri = 421,
  sym_curly_group_command_name = 422,
  sym_curly_group_key_value = 423,
  sym_curly_group_glob_pattern = 424,
  sym_curly_group_impl = 425,
  sym_curly_group_author_list = 426,
  sym_brack_group = 427,
  sym_brack_group_text = 428,
  sym_brack_group_argc = 429,
  sym_brack_group_key_value = 430,
  sym_text = 431,
  sym_glob_pattern = 432,
  sym__glob_pattern_fragment = 433,
  sym_operator = 434,
  sym_subscript = 435,
  sym_superscript = 436,
  sym_key_value_pair = 437,
  sym_value = 438,
  sym__math_content = 439,
  sym_displayed_equation = 440,
  sym_inline_formula = 441,
  sym__math_delimiter_part = 442,
  sym_math_delimiter = 443,
  sym_text_mode = 444,
  sym_begin = 445,
  sym_end = 446,
  sym_generic_environment = 447,
  sym_comment_environment = 448,
  sym__comment_environment_begin = 449,
  sym__comment_environment_end = 450,
  sym__comment_environment_group = 451,
  sym__comment_environment_name = 452,
  sym_verbatim_environment = 453,
  sym__verbatim_environment_begin = 454,
  sym__verbatim_environment_end = 455,
  sym__verbatim_environment_group = 456,
  sym__verbatim_environment_name = 457,
  sym_listing_environment = 458,
  sym__listing_environment_begin = 459,
  sym__listing_environment_end = 460,
  sym__listing_environment_group = 461,
  sym__listing_environment_name = 462,
  sym_minted_environment = 463,
  sym__minted_environment_begin = 464,
  sym__minted_environment_end = 465,
  sym__minted_environment_group = 466,
  sym__minted_environment_name = 467,
  sym_asy_environment = 468,
  sym__asy_environment_begin = 469,
  sym__asy_environment_end = 470,
  sym__asy_environment_group = 471,
  sym__asy_environment_name = 472,
  sym_asydef_environment = 473,
  sym__asydef_environment_begin = 474,
  sym__asydef_environment_end = 475,
  sym__asydef_environment_group = 476,
  sym__asydef_environment_name = 477,
  sym_pycode_environment = 478,
  sym__pycode_environment_begin = 479,
  sym__pycode_environment_end = 480,
  sym__pycode_environment_group = 481,
  sym__pycode_environment_name = 482,
  sym_luacode_environment = 483,
  sym__luacode_environment = 484,
  sym___luacode_environment_begin = 485,
  sym___luacode_environment_end = 486,
  sym___luacode_environment_group = 487,
  sym___luacode_environment_name = 488,
  sym__luacode_environment_star = 489,
  sym___luacode_environment_star_begin = 490,
  sym___luacode_environment_star_end = 491,
  sym___luacode_environment_star_group = 492,
  sym___luacode_environment_star_name = 493,
  sym_sagesilent_environment = 494,
  sym__sagesilent_environment_begin = 495,
  sym__sagesilent_environment_end = 496,
  sym__sagesilent_environment_group = 497,
  sym__sagesilent_environment_name = 498,
  sym_sageblock_environment = 499,
  sym__sageblock_environment_begin = 500,
  sym__sageblock_environment_end = 501,
  sym__sageblock_environment_group = 502,
  sym__sageblock_environment_name = 503,
  sym_math_environment = 504,
  sym__math_environment_begin = 505,
  sym__math_environment_end = 506,
  sym__math_environment_group = 507,
  sym__math_environment_name = 508,
  sym__command = 509,
  sym_generic_command = 510,
  sym_title_declaration = 511,
  sym_author_declaration = 512,
  sym_package_include = 513,
  sym_class_include = 514,
  sym_latex_include = 515,
  sym_biblatex_include = 516,
  sym_bibstyle_include = 517,
  sym_bibtex_include = 518,
  sym_graphics_include = 519,
  sym_svg_include = 520,
  sym_inkscape_include = 521,
  sym_verbatim_include = 522,
  sym_import_include = 523,
  sym_caption = 524,
  sym_citation = 525,
  sym_label_definition = 526,
  sym_label_reference = 527,
  sym_label_reference_range = 528,
  sym_label_number = 529,
  sym_new_command_definition = 530,
  sym__new_command_definition = 531,
  sym__newer_command_definition = 532,
  sym__new_command_copy = 533,
  sym_old_command_definition = 534,
  sym_let_command_definition = 535,
  sym_paired_delimiter_definition = 536,
  sym_environment_definition = 537,
  sym__environment_definition = 538,
  sym__newer_environment_definition = 539,
  sym__new_environment_copy = 540,
  sym_glossary_entry_definition = 541,
  sym_glossary_entry_reference = 542,
  sym_acronym_definition = 543,
  sym_acronym_reference = 544,
  sym_theorem_definition = 545,
  sym_color_definition = 546,
  sym_color_set_definition = 547,
  sym_color_reference = 548,
  sym_tikz_library_import = 549,
  sym_hyperlink = 550,
  aux_sym_source_file_repeat1 = 551,
  aux_sym__section_repeat1 = 552,
  aux_sym__section_repeat2 = 553,
  aux_sym__section_repeat3 = 554,
  aux_sym__section_repeat4 = 555,
  aux_sym__section_repeat5 = 556,
  aux_sym__paragraph_repeat1 = 557,
  aux_sym__paragraph_repeat2 = 558,
  aux_sym__paragraph_repeat3 = 559,
  aux_sym_part_repeat1 = 560,
  aux_sym_curly_group_spec_repeat1 = 561,
  aux_sym_curly_group_text_list_repeat1 = 562,
  aux_sym_curly_group_path_list_repeat1 = 563,
  aux_sym_curly_group_key_value_repeat1 = 564,
  aux_sym_curly_group_impl_repeat1 = 565,
  aux_sym_curly_group_author_list_repeat1 = 566,
  aux_sym_curly_group_author_list_repeat2 = 567,
  aux_sym_brack_group_repeat1 = 568,
  aux_sym_text_repeat1 = 569,
  aux_sym_glob_pattern_repeat1 = 570,
  aux_sym_value_repeat1 = 571,
  aux_sym_generic_command_repeat1 = 572,
  alias_sym_author = 573,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_command_name] = "command_name",
  [sym__whitespace] = "_whitespace",
  [sym_line_comment] = "line_comment",
  [anon_sym_BSLASHiffalse] = "\\iffalse",
  [anon_sym_BSLASHfi] = "\\fi",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_BSLASHpart] = "\\part",
  [anon_sym_BSLASHpart_STAR] = "\\part*",
  [anon_sym_BSLASHaddpart] = "\\addpart",
  [anon_sym_BSLASHaddpart_STAR] = "\\addpart*",
  [anon_sym_BSLASHchapter] = "\\chapter",
  [anon_sym_BSLASHchapter_STAR] = "\\chapter*",
  [anon_sym_BSLASHaddchap] = "\\addchap",
  [anon_sym_BSLASHaddchap_STAR] = "\\addchap*",
  [anon_sym_BSLASHsection] = "\\section",
  [anon_sym_BSLASHsection_STAR] = "\\section*",
  [anon_sym_BSLASHaddsec] = "\\addsec",
  [anon_sym_BSLASHaddsec_STAR] = "\\addsec*",
  [anon_sym_BSLASHsubsection] = "\\subsection",
  [anon_sym_BSLASHsubsection_STAR] = "\\subsection*",
  [anon_sym_BSLASHsubsubsection] = "\\subsubsection",
  [anon_sym_BSLASHsubsubsection_STAR] = "\\subsubsection*",
  [anon_sym_BSLASHparagraph] = "\\paragraph",
  [anon_sym_BSLASHparagraph_STAR] = "\\paragraph*",
  [anon_sym_BSLASHsubparagraph] = "\\subparagraph",
  [anon_sym_BSLASHsubparagraph_STAR] = "\\subparagraph*",
  [anon_sym_BSLASHitem] = "\\item",
  [anon_sym_BSLASHitem_STAR] = "\\item*",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_BSLASHand] = "command_name",
  [sym_word] = "word",
  [sym_placeholder] = "placeholder",
  [sym_delimiter] = "delimiter",
  [sym_path] = "path",
  [sym_uri] = "uri",
  [sym_argc] = "argc",
  [aux_sym__glob_pattern_fragment_token1] = "_glob_pattern_fragment_token1",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_BANG] = "!",
  [anon_sym_PIPE] = "|",
  [anon_sym_COLON] = ":",
  [anon_sym_SQUOTE] = "'",
  [sym_letter] = "letter",
  [anon_sym__] = "_",
  [anon_sym_CARET] = "^",
  [anon_sym_DOLLAR_DOLLAR] = "$$",
  [anon_sym_BSLASH_LBRACK] = "\\[",
  [anon_sym_BSLASH_RBRACK] = "\\]",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_BSLASH_RPAREN] = "\\)",
  [anon_sym_BSLASHleft] = "\\left",
  [anon_sym_BSLASHbigl] = "\\bigl",
  [anon_sym_BSLASHBigl] = "\\Bigl",
  [anon_sym_BSLASHbiggl] = "\\biggl",
  [anon_sym_BSLASHBiggl] = "\\Biggl",
  [anon_sym_BSLASHright] = "\\right",
  [anon_sym_BSLASHbigr] = "\\bigr",
  [anon_sym_BSLASHBigr] = "\\Bigr",
  [anon_sym_BSLASHbiggr] = "\\biggr",
  [anon_sym_BSLASHBiggr] = "\\Biggr",
  [anon_sym_BSLASHtext] = "\\text",
  [anon_sym_BSLASHintertext] = "\\intertext",
  [anon_sym_BSLASHshortintertext] = "\\shortintertext",
  [anon_sym_BSLASHbegin] = "\\begin",
  [anon_sym_BSLASHend] = "\\end",
  [anon_sym_comment] = "word",
  [anon_sym_verbatim] = "word",
  [anon_sym_lstlisting] = "word",
  [anon_sym_minted] = "word",
  [anon_sym_asy] = "word",
  [anon_sym_asydef] = "word",
  [anon_sym_pycode] = "word",
  [anon_sym_luacode] = "word",
  [anon_sym_luacode_STAR] = "word",
  [anon_sym_sagesilent] = "word",
  [anon_sym_sageblock] = "word",
  [anon_sym_math] = "word",
  [anon_sym_displaymath] = "word",
  [anon_sym_displaymath_STAR] = "word",
  [anon_sym_equation] = "word",
  [anon_sym_equation_STAR] = "word",
  [anon_sym_multline] = "word",
  [anon_sym_multline_STAR] = "word",
  [anon_sym_eqnarray] = "word",
  [anon_sym_eqnarray_STAR] = "word",
  [anon_sym_align] = "word",
  [anon_sym_align_STAR] = "word",
  [anon_sym_aligned] = "word",
  [anon_sym_aligned_STAR] = "word",
  [anon_sym_array] = "word",
  [anon_sym_array_STAR] = "word",
  [anon_sym_split] = "word",
  [anon_sym_split_STAR] = "word",
  [anon_sym_alignat] = "word",
  [anon_sym_alignat_STAR] = "word",
  [anon_sym_alignedat] = "word",
  [anon_sym_alignedat_STAR] = "word",
  [anon_sym_gather] = "word",
  [anon_sym_gather_STAR] = "word",
  [anon_sym_gathered] = "word",
  [anon_sym_gathered_STAR] = "word",
  [anon_sym_flalign] = "word",
  [anon_sym_flalign_STAR] = "word",
  [anon_sym_BSLASHtitle] = "\\title",
  [anon_sym_BSLASHauthor] = "\\author",
  [anon_sym_BSLASHusepackage] = "\\usepackage",
  [anon_sym_BSLASHRequirePackage] = "\\RequirePackage",
  [anon_sym_BSLASHdocumentclass] = "\\documentclass",
  [anon_sym_BSLASHinclude] = "\\include",
  [anon_sym_BSLASHsubfileinclude] = "\\subfileinclude",
  [anon_sym_BSLASHinput] = "\\input",
  [anon_sym_BSLASHsubfile] = "\\subfile",
  [anon_sym_BSLASHaddbibresource] = "\\addbibresource",
  [anon_sym_BSLASHbibliographystyle] = "\\bibliographystyle",
  [anon_sym_BSLASHbibliography] = "\\bibliography",
  [anon_sym_BSLASHincludegraphics] = "\\includegraphics",
  [anon_sym_BSLASHincludesvg] = "\\includesvg",
  [anon_sym_BSLASHincludeinkscape] = "\\includeinkscape",
  [anon_sym_BSLASHverbatiminput] = "\\verbatiminput",
  [anon_sym_BSLASHVerbatimInput] = "\\VerbatimInput",
  [anon_sym_BSLASHimport] = "\\import",
  [anon_sym_BSLASHsubimport] = "\\subimport",
  [anon_sym_BSLASHinputfrom] = "\\inputfrom",
  [anon_sym_BSLASHsubimportfrom] = "\\subimportfrom",
  [anon_sym_BSLASHincludefrom] = "\\includefrom",
  [anon_sym_BSLASHsubincludefrom] = "\\subincludefrom",
  [anon_sym_BSLASHcaption] = "\\caption",
  [anon_sym_BSLASHcite] = "\\cite",
  [anon_sym_BSLASHcite_STAR] = "\\cite*",
  [anon_sym_BSLASHCite] = "\\Cite",
  [anon_sym_BSLASHnocite] = "\\nocite",
  [anon_sym_BSLASHcitet] = "\\citet",
  [anon_sym_BSLASHcitep] = "\\citep",
  [anon_sym_BSLASHcitet_STAR] = "\\citet*",
  [anon_sym_BSLASHcitep_STAR] = "\\citep*",
  [anon_sym_BSLASHciteA] = "\\citeA",
  [anon_sym_BSLASHciteR] = "\\citeR",
  [anon_sym_BSLASHciteS] = "\\citeS",
  [anon_sym_BSLASHciteyearR] = "\\citeyearR",
  [anon_sym_BSLASHciteauthor] = "\\citeauthor",
  [anon_sym_BSLASHciteauthor_STAR] = "\\citeauthor*",
  [anon_sym_BSLASHCiteauthor] = "\\Citeauthor",
  [anon_sym_BSLASHCiteauthor_STAR] = "\\Citeauthor*",
  [anon_sym_BSLASHcitetitle] = "\\citetitle",
  [anon_sym_BSLASHcitetitle_STAR] = "\\citetitle*",
  [anon_sym_BSLASHciteyear] = "\\citeyear",
  [anon_sym_BSLASHciteyear_STAR] = "\\citeyear*",
  [anon_sym_BSLASHcitedate] = "\\citedate",
  [anon_sym_BSLASHcitedate_STAR] = "\\citedate*",
  [anon_sym_BSLASHciteurl] = "\\citeurl",
  [anon_sym_BSLASHfullcite] = "\\fullcite",
  [anon_sym_BSLASHciteyearpar] = "\\citeyearpar",
  [anon_sym_BSLASHcitealt] = "\\citealt",
  [anon_sym_BSLASHcitealp] = "\\citealp",
  [anon_sym_BSLASHcitetext] = "\\citetext",
  [anon_sym_BSLASHparencite] = "\\parencite",
  [anon_sym_BSLASHparencite_STAR] = "\\parencite*",
  [anon_sym_BSLASHParencite] = "\\Parencite",
  [anon_sym_BSLASHfootcite] = "\\footcite",
  [anon_sym_BSLASHfootfullcite] = "\\footfullcite",
  [anon_sym_BSLASHfootcitetext] = "\\footcitetext",
  [anon_sym_BSLASHtextcite] = "\\textcite",
  [anon_sym_BSLASHTextcite] = "\\Textcite",
  [anon_sym_BSLASHsmartcite] = "\\smartcite",
  [anon_sym_BSLASHSmartcite] = "\\Smartcite",
  [anon_sym_BSLASHsupercite] = "\\supercite",
  [anon_sym_BSLASHautocite] = "\\autocite",
  [anon_sym_BSLASHAutocite] = "\\Autocite",
  [anon_sym_BSLASHautocite_STAR] = "\\autocite*",
  [anon_sym_BSLASHAutocite_STAR] = "\\Autocite*",
  [anon_sym_BSLASHvolcite] = "\\volcite",
  [anon_sym_BSLASHVolcite] = "\\Volcite",
  [anon_sym_BSLASHpvolcite] = "\\pvolcite",
  [anon_sym_BSLASHPvolcite] = "\\Pvolcite",
  [anon_sym_BSLASHfvolcite] = "\\fvolcite",
  [anon_sym_BSLASHftvolcite] = "\\ftvolcite",
  [anon_sym_BSLASHsvolcite] = "\\svolcite",
  [anon_sym_BSLASHSvolcite] = "\\Svolcite",
  [anon_sym_BSLASHtvolcite] = "\\tvolcite",
  [anon_sym_BSLASHTvolcite] = "\\Tvolcite",
  [anon_sym_BSLASHavolcite] = "\\avolcite",
  [anon_sym_BSLASHAvolcite] = "\\Avolcite",
  [anon_sym_BSLASHnotecite] = "\\notecite",
  [anon_sym_BSLASHNotecite] = "\\Notecite",
  [anon_sym_BSLASHpnotecite] = "\\pnotecite",
  [anon_sym_BSLASHPnotecite] = "\\Pnotecite",
  [anon_sym_BSLASHfnotecite] = "\\fnotecite",
  [anon_sym_BSLASHlabel] = "\\label",
  [anon_sym_BSLASHref] = "\\ref",
  [anon_sym_BSLASHeqref] = "\\eqref",
  [anon_sym_BSLASHvref] = "\\vref",
  [anon_sym_BSLASHVref] = "\\Vref",
  [anon_sym_BSLASHautoref] = "\\autoref",
  [anon_sym_BSLASHautoref_STAR] = "\\autoref*",
  [anon_sym_BSLASHpageref] = "\\pageref",
  [anon_sym_BSLASHpageref_STAR] = "\\pageref*",
  [anon_sym_BSLASHautopageref] = "\\autopageref",
  [anon_sym_BSLASHautopageref_STAR] = "\\autopageref*",
  [anon_sym_BSLASHcref] = "\\cref",
  [anon_sym_BSLASHcref_STAR] = "\\cref*",
  [anon_sym_BSLASHCref] = "\\Cref",
  [anon_sym_BSLASHCref_STAR] = "\\Cref*",
  [anon_sym_BSLASHcpageref] = "\\cpageref",
  [anon_sym_BSLASHCpageref] = "\\Cpageref",
  [anon_sym_BSLASHnamecref] = "\\namecref",
  [anon_sym_BSLASHnameCref] = "\\nameCref",
  [anon_sym_BSLASHlcnamecref] = "\\lcnamecref",
  [anon_sym_BSLASHnamecrefs] = "\\namecrefs",
  [anon_sym_BSLASHnameCrefs] = "\\nameCrefs",
  [anon_sym_BSLASHlcnamecrefs] = "\\lcnamecrefs",
  [anon_sym_BSLASHlabelcref] = "\\labelcref",
  [anon_sym_BSLASHlabelcref_STAR] = "\\labelcref*",
  [anon_sym_BSLASHlabelcpageref] = "\\labelcpageref",
  [anon_sym_BSLASHlabelcpageref_STAR] = "\\labelcpageref*",
  [anon_sym_BSLASHcrefrange] = "\\crefrange",
  [anon_sym_BSLASHcrefrange_STAR] = "\\crefrange*",
  [anon_sym_BSLASHCrefrange] = "\\Crefrange",
  [anon_sym_BSLASHCrefrange_STAR] = "\\Crefrange*",
  [anon_sym_BSLASHcpagerefrange] = "\\cpagerefrange",
  [anon_sym_BSLASHCpagerefrange] = "\\Cpagerefrange",
  [anon_sym_BSLASHnewlabel] = "\\newlabel",
  [anon_sym_BSLASHnewcommand] = "\\newcommand",
  [anon_sym_BSLASHnewcommand_STAR] = "\\newcommand*",
  [anon_sym_BSLASHrenewcommand] = "\\renewcommand",
  [anon_sym_BSLASHrenewcommand_STAR] = "\\renewcommand*",
  [anon_sym_BSLASHprovidecommand] = "\\providecommand",
  [anon_sym_BSLASHprovidecommand_STAR] = "\\providecommand*",
  [anon_sym_BSLASHDeclareRobustCommand] = "\\DeclareRobustCommand",
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = "\\DeclareRobustCommand*",
  [anon_sym_BSLASHDeclareMathOperator] = "\\DeclareMathOperator",
  [anon_sym_BSLASHDeclareMathOperator_STAR] = "\\DeclareMathOperator*",
  [anon_sym_BSLASHNewDocumentCommand] = "\\NewDocumentCommand",
  [anon_sym_BSLASHRenewDocumentCommand] = "\\RenewDocumentCommand",
  [anon_sym_BSLASHProvideDocumentCommand] = "\\ProvideDocumentCommand",
  [anon_sym_BSLASHDeclareDocumentCommand] = "\\DeclareDocumentCommand",
  [anon_sym_BSLASHNewExpandableDocumentCommand] = "\\NewExpandableDocumentCommand",
  [anon_sym_BSLASHRenewExpandableDocumentCommand] = "\\RenewExpandableDocumentCommand",
  [anon_sym_BSLASHProvideExpandableDocumentCommand] = "\\ProvideExpandableDocumentCommand",
  [anon_sym_BSLASHDeclareExpandableDocumentCommand] = "\\DeclareExpandableDocumentCommand",
  [anon_sym_BSLASHNewCommandCopy] = "\\NewCommandCopy",
  [anon_sym_BSLASHRenewCommandCopy] = "\\RenewCommandCopy",
  [anon_sym_BSLASHDeclareCommandCopy] = "\\DeclareCommandCopy",
  [anon_sym_BSLASHdef] = "\\def",
  [anon_sym_BSLASHgdef] = "\\gdef",
  [anon_sym_BSLASHedef] = "\\edef",
  [anon_sym_BSLASHxdef] = "\\xdef",
  [anon_sym_BSLASHlet] = "\\let",
  [anon_sym_BSLASHglet] = "\\glet",
  [anon_sym_BSLASHDeclarePairedDelimiter] = "\\DeclarePairedDelimiter",
  [anon_sym_BSLASHDeclarePairedDelimiterX] = "\\DeclarePairedDelimiterX",
  [anon_sym_BSLASHnewenvironment] = "\\newenvironment",
  [anon_sym_BSLASHrenewenvironment] = "\\renewenvironment",
  [anon_sym_BSLASHNewDocumentEnvironment] = "\\NewDocumentEnvironment",
  [anon_sym_BSLASHRenewDocumentEnvironment] = "\\RenewDocumentEnvironment",
  [anon_sym_BSLASHProvideDocumentEnvironment] = "\\ProvideDocumentEnvironment",
  [anon_sym_BSLASHDeclareDocumentEnvironment] = "\\DeclareDocumentEnvironment",
  [anon_sym_BSLASHNewEnvironmentCopy] = "\\NewEnvironmentCopy",
  [anon_sym_BSLASHRenewEnvironmentCopy] = "\\RenewEnvironmentCopy",
  [anon_sym_BSLASHDeclareEnvironmentCopy] = "\\DeclareEnvironmentCopy",
  [anon_sym_BSLASHnewglossaryentry] = "\\newglossaryentry",
  [anon_sym_BSLASHgls] = "\\gls",
  [anon_sym_BSLASHGls] = "\\Gls",
  [anon_sym_BSLASHGLS] = "\\GLS",
  [anon_sym_BSLASHglspl] = "\\glspl",
  [anon_sym_BSLASHGlspl] = "\\Glspl",
  [anon_sym_BSLASHGLSpl] = "\\GLSpl",
  [anon_sym_BSLASHglsdisp] = "\\glsdisp",
  [anon_sym_BSLASHglslink] = "\\glslink",
  [anon_sym_BSLASHglstext] = "\\glstext",
  [anon_sym_BSLASHGlstext] = "\\Glstext",
  [anon_sym_BSLASHGLStext] = "\\GLStext",
  [anon_sym_BSLASHglsfirst] = "\\glsfirst",
  [anon_sym_BSLASHGlsfirst] = "\\Glsfirst",
  [anon_sym_BSLASHGLSfirst] = "\\GLSfirst",
  [anon_sym_BSLASHglsplural] = "\\glsplural",
  [anon_sym_BSLASHGlsplural] = "\\Glsplural",
  [anon_sym_BSLASHGLSplural] = "\\GLSplural",
  [anon_sym_BSLASHglsfirstplural] = "\\glsfirstplural",
  [anon_sym_BSLASHGlsfirstplural] = "\\Glsfirstplural",
  [anon_sym_BSLASHGLSfirstplural] = "\\GLSfirstplural",
  [anon_sym_BSLASHglsname] = "\\glsname",
  [anon_sym_BSLASHGlsname] = "\\Glsname",
  [anon_sym_BSLASHGLSname] = "\\GLSname",
  [anon_sym_BSLASHglssymbol] = "\\glssymbol",
  [anon_sym_BSLASHGlssymbol] = "\\Glssymbol",
  [anon_sym_BSLASHglsdesc] = "\\glsdesc",
  [anon_sym_BSLASHGlsdesc] = "\\Glsdesc",
  [anon_sym_BSLASHGLSdesc] = "\\GLSdesc",
  [anon_sym_BSLASHglsuseri] = "\\glsuseri",
  [anon_sym_BSLASHGlsuseri] = "\\Glsuseri",
  [anon_sym_BSLASHGLSuseri] = "\\GLSuseri",
  [anon_sym_BSLASHglsuserii] = "\\glsuserii",
  [anon_sym_BSLASHGlsuserii] = "\\Glsuserii",
  [anon_sym_BSLASHGLSuserii] = "\\GLSuserii",
  [anon_sym_BSLASHglsuseriii] = "\\glsuseriii",
  [anon_sym_BSLASHGlsuseriii] = "\\Glsuseriii",
  [anon_sym_BSLASHGLSuseriii] = "\\GLSuseriii",
  [anon_sym_BSLASHglsuseriv] = "\\glsuseriv",
  [anon_sym_BSLASHGlsuseriv] = "\\Glsuseriv",
  [anon_sym_BSLASHGLSuseriv] = "\\GLSuseriv",
  [anon_sym_BSLASHglsuserv] = "\\glsuserv",
  [anon_sym_BSLASHGlsuserv] = "\\Glsuserv",
  [anon_sym_BSLASHGLSuserv] = "\\GLSuserv",
  [anon_sym_BSLASHglsuservi] = "\\glsuservi",
  [anon_sym_BSLASHGlsuservi] = "\\Glsuservi",
  [anon_sym_BSLASHGLSuservi] = "\\GLSuservi",
  [anon_sym_BSLASHnewacronym] = "\\newacronym",
  [anon_sym_BSLASHacrshort] = "\\acrshort",
  [anon_sym_BSLASHAcrshort] = "\\Acrshort",
  [anon_sym_BSLASHACRshort] = "\\ACRshort",
  [anon_sym_BSLASHacrshortpl] = "\\acrshortpl",
  [anon_sym_BSLASHAcrshortpl] = "\\Acrshortpl",
  [anon_sym_BSLASHACRshortpl] = "\\ACRshortpl",
  [anon_sym_BSLASHacrlong] = "\\acrlong",
  [anon_sym_BSLASHAcrlong] = "\\Acrlong",
  [anon_sym_BSLASHACRlong] = "\\ACRlong",
  [anon_sym_BSLASHacrlongpl] = "\\acrlongpl",
  [anon_sym_BSLASHAcrlongpl] = "\\Acrlongpl",
  [anon_sym_BSLASHACRlongpl] = "\\ACRlongpl",
  [anon_sym_BSLASHacrfull] = "\\acrfull",
  [anon_sym_BSLASHAcrfull] = "\\Acrfull",
  [anon_sym_BSLASHACRfull] = "\\ACRfull",
  [anon_sym_BSLASHacrfullpl] = "\\acrfullpl",
  [anon_sym_BSLASHAcrfullpl] = "\\Acrfullpl",
  [anon_sym_BSLASHACRfullpl] = "\\ACRfullpl",
  [anon_sym_BSLASHacs] = "\\acs",
  [anon_sym_BSLASHAcs] = "\\Acs",
  [anon_sym_BSLASHacsp] = "\\acsp",
  [anon_sym_BSLASHAcsp] = "\\Acsp",
  [anon_sym_BSLASHacl] = "\\acl",
  [anon_sym_BSLASHAcl] = "\\Acl",
  [anon_sym_BSLASHaclp] = "\\aclp",
  [anon_sym_BSLASHAclp] = "\\Aclp",
  [anon_sym_BSLASHacf] = "\\acf",
  [anon_sym_BSLASHAcf] = "\\Acf",
  [anon_sym_BSLASHacfp] = "\\acfp",
  [anon_sym_BSLASHAcfp] = "\\Acfp",
  [anon_sym_BSLASHac] = "\\ac",
  [anon_sym_BSLASHAc] = "\\Ac",
  [anon_sym_BSLASHacp] = "\\acp",
  [anon_sym_BSLASHglsentrylong] = "\\glsentrylong",
  [anon_sym_BSLASHGlsentrylong] = "\\Glsentrylong",
  [anon_sym_BSLASHglsentrylongpl] = "\\glsentrylongpl",
  [anon_sym_BSLASHGlsentrylongpl] = "\\Glsentrylongpl",
  [anon_sym_BSLASHglsentryshort] = "\\glsentryshort",
  [anon_sym_BSLASHGlsentryshort] = "\\Glsentryshort",
  [anon_sym_BSLASHglsentryshortpl] = "\\glsentryshortpl",
  [anon_sym_BSLASHGlsentryshortpl] = "\\Glsentryshortpl",
  [anon_sym_BSLASHglsentryfullpl] = "\\glsentryfullpl",
  [anon_sym_BSLASHGlsentryfullpl] = "\\Glsentryfullpl",
  [anon_sym_BSLASHnewtheorem] = "\\newtheorem",
  [anon_sym_BSLASHnewtheorem_STAR] = "\\newtheorem*",
  [anon_sym_BSLASHdeclaretheorem] = "\\declaretheorem",
  [anon_sym_BSLASHdeclaretheorem_STAR] = "\\declaretheorem*",
  [anon_sym_BSLASHdefinecolor] = "\\definecolor",
  [anon_sym_BSLASHdefinecolorset] = "\\definecolorset",
  [anon_sym_BSLASHcolor] = "\\color",
  [anon_sym_BSLASHpagecolor] = "\\pagecolor",
  [anon_sym_BSLASHtextcolor] = "\\textcolor",
  [anon_sym_BSLASHmathcolor] = "\\mathcolor",
  [anon_sym_BSLASHcolorbox] = "\\colorbox",
  [anon_sym_BSLASHusepgflibrary] = "\\usepgflibrary",
  [anon_sym_BSLASHusetikzlibrary] = "\\usetikzlibrary",
  [anon_sym_BSLASHurl] = "\\url",
  [anon_sym_BSLASHhref] = "\\href",
  [sym__trivia_raw_fi] = "comment",
  [sym__trivia_raw_env_comment] = "comment",
  [sym__trivia_raw_env_verbatim] = "comment",
  [sym__trivia_raw_env_listing] = "source_code",
  [sym__trivia_raw_env_minted] = "source_code",
  [sym__trivia_raw_env_asy] = "source_code",
  [sym__trivia_raw_env_asydef] = "source_code",
  [sym__trivia_raw_env_pycode] = "source_code",
  [sym__trivia_raw_env_luacode] = "source_code",
  [sym__trivia_raw_env_luacode_star] = "source_code",
  [sym__trivia_raw_env_sagesilent] = "source_code",
  [sym__trivia_raw_env_sageblock] = "source_code",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym__root_content] = "_root_content",
  [sym__flat_content] = "_flat_content",
  [sym__text_with_env_content] = "_text_with_env_content",
  [sym__text_content] = "_text_content",
  [sym__section] = "_section",
  [sym__paragraph] = "_paragraph",
  [sym__section_part] = "_section_part",
  [sym__part_declaration] = "_part_declaration",
  [sym_part] = "part",
  [sym__chapter_declaration] = "_chapter_declaration",
  [sym_chapter] = "chapter",
  [sym__section_declaration] = "_section_declaration",
  [sym_section] = "section",
  [sym__subsection_declaration] = "_subsection_declaration",
  [sym_subsection] = "subsection",
  [sym__subsubsection_declaration] = "_subsubsection_declaration",
  [sym_subsubsection] = "subsubsection",
  [sym__paragraph_declaration] = "_paragraph_declaration",
  [sym_paragraph] = "paragraph",
  [sym__subparagraph_declaration] = "_subparagraph_declaration",
  [sym_subparagraph] = "subparagraph",
  [sym__enum_itemdeclaration] = "_enum_itemdeclaration",
  [sym_enum_item] = "enum_item",
  [sym_curly_group] = "curly_group",
  [sym_curly_group_text] = "curly_group_text",
  [sym_curly_group_spec] = "curly_group_spec",
  [sym_curly_group_text_list] = "curly_group_text_list",
  [sym_curly_group_path] = "curly_group_path",
  [sym_curly_group_path_list] = "curly_group_path_list",
  [sym_curly_group_uri] = "curly_group_uri",
  [sym_curly_group_command_name] = "curly_group_command_name",
  [sym_curly_group_key_value] = "curly_group_key_value",
  [sym_curly_group_glob_pattern] = "curly_group_glob_pattern",
  [sym_curly_group_impl] = "curly_group_impl",
  [sym_curly_group_author_list] = "curly_group_author_list",
  [sym_brack_group] = "brack_group",
  [sym_brack_group_text] = "brack_group_text",
  [sym_brack_group_argc] = "brack_group_argc",
  [sym_brack_group_key_value] = "brack_group_key_value",
  [sym_text] = "text",
  [sym_glob_pattern] = "glob_pattern",
  [sym__glob_pattern_fragment] = "_glob_pattern_fragment",
  [sym_operator] = "operator",
  [sym_subscript] = "subscript",
  [sym_superscript] = "superscript",
  [sym_key_value_pair] = "key_value_pair",
  [sym_value] = "value",
  [sym__math_content] = "_math_content",
  [sym_displayed_equation] = "displayed_equation",
  [sym_inline_formula] = "inline_formula",
  [sym__math_delimiter_part] = "_math_delimiter_part",
  [sym_math_delimiter] = "math_delimiter",
  [sym_text_mode] = "text_mode",
  [sym_begin] = "begin",
  [sym_end] = "end",
  [sym_generic_environment] = "generic_environment",
  [sym_comment_environment] = "comment_environment",
  [sym__comment_environment_begin] = "begin",
  [sym__comment_environment_end] = "end",
  [sym__comment_environment_group] = "curly_group_text",
  [sym__comment_environment_name] = "text",
  [sym_verbatim_environment] = "verbatim_environment",
  [sym__verbatim_environment_begin] = "begin",
  [sym__verbatim_environment_end] = "end",
  [sym__verbatim_environment_group] = "curly_group_text",
  [sym__verbatim_environment_name] = "text",
  [sym_listing_environment] = "listing_environment",
  [sym__listing_environment_begin] = "begin",
  [sym__listing_environment_end] = "end",
  [sym__listing_environment_group] = "curly_group_text",
  [sym__listing_environment_name] = "text",
  [sym_minted_environment] = "minted_environment",
  [sym__minted_environment_begin] = "begin",
  [sym__minted_environment_end] = "end",
  [sym__minted_environment_group] = "curly_group_text",
  [sym__minted_environment_name] = "text",
  [sym_asy_environment] = "asy_environment",
  [sym__asy_environment_begin] = "begin",
  [sym__asy_environment_end] = "end",
  [sym__asy_environment_group] = "curly_group_text",
  [sym__asy_environment_name] = "text",
  [sym_asydef_environment] = "asydef_environment",
  [sym__asydef_environment_begin] = "begin",
  [sym__asydef_environment_end] = "end",
  [sym__asydef_environment_group] = "curly_group_text",
  [sym__asydef_environment_name] = "text",
  [sym_pycode_environment] = "pycode_environment",
  [sym__pycode_environment_begin] = "begin",
  [sym__pycode_environment_end] = "end",
  [sym__pycode_environment_group] = "curly_group_text",
  [sym__pycode_environment_name] = "text",
  [sym_luacode_environment] = "luacode_environment",
  [sym__luacode_environment] = "_luacode_environment",
  [sym___luacode_environment_begin] = "begin",
  [sym___luacode_environment_end] = "end",
  [sym___luacode_environment_group] = "curly_group_text",
  [sym___luacode_environment_name] = "text",
  [sym__luacode_environment_star] = "_luacode_environment_star",
  [sym___luacode_environment_star_begin] = "begin",
  [sym___luacode_environment_star_end] = "end",
  [sym___luacode_environment_star_group] = "curly_group_text",
  [sym___luacode_environment_star_name] = "text",
  [sym_sagesilent_environment] = "sagesilent_environment",
  [sym__sagesilent_environment_begin] = "begin",
  [sym__sagesilent_environment_end] = "end",
  [sym__sagesilent_environment_group] = "curly_group_text",
  [sym__sagesilent_environment_name] = "text",
  [sym_sageblock_environment] = "sageblock_environment",
  [sym__sageblock_environment_begin] = "begin",
  [sym__sageblock_environment_end] = "end",
  [sym__sageblock_environment_group] = "curly_group_text",
  [sym__sageblock_environment_name] = "text",
  [sym_math_environment] = "math_environment",
  [sym__math_environment_begin] = "begin",
  [sym__math_environment_end] = "end",
  [sym__math_environment_group] = "curly_group_text",
  [sym__math_environment_name] = "text",
  [sym__command] = "_command",
  [sym_generic_command] = "generic_command",
  [sym_title_declaration] = "title_declaration",
  [sym_author_declaration] = "author_declaration",
  [sym_package_include] = "package_include",
  [sym_class_include] = "class_include",
  [sym_latex_include] = "latex_include",
  [sym_biblatex_include] = "biblatex_include",
  [sym_bibstyle_include] = "bibstyle_include",
  [sym_bibtex_include] = "bibtex_include",
  [sym_graphics_include] = "graphics_include",
  [sym_svg_include] = "svg_include",
  [sym_inkscape_include] = "inkscape_include",
  [sym_verbatim_include] = "verbatim_include",
  [sym_import_include] = "import_include",
  [sym_caption] = "caption",
  [sym_citation] = "citation",
  [sym_label_definition] = "label_definition",
  [sym_label_reference] = "label_reference",
  [sym_label_reference_range] = "label_reference_range",
  [sym_label_number] = "label_number",
  [sym_new_command_definition] = "new_command_definition",
  [sym__new_command_definition] = "_new_command_definition",
  [sym__newer_command_definition] = "_newer_command_definition",
  [sym__new_command_copy] = "_new_command_copy",
  [sym_old_command_definition] = "old_command_definition",
  [sym_let_command_definition] = "let_command_definition",
  [sym_paired_delimiter_definition] = "paired_delimiter_definition",
  [sym_environment_definition] = "environment_definition",
  [sym__environment_definition] = "_environment_definition",
  [sym__newer_environment_definition] = "_newer_environment_definition",
  [sym__new_environment_copy] = "_new_environment_copy",
  [sym_glossary_entry_definition] = "glossary_entry_definition",
  [sym_glossary_entry_reference] = "glossary_entry_reference",
  [sym_acronym_definition] = "acronym_definition",
  [sym_acronym_reference] = "acronym_reference",
  [sym_theorem_definition] = "theorem_definition",
  [sym_color_definition] = "color_definition",
  [sym_color_set_definition] = "color_set_definition",
  [sym_color_reference] = "color_reference",
  [sym_tikz_library_import] = "tikz_library_import",
  [sym_hyperlink] = "hyperlink",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym__section_repeat1] = "_section_repeat1",
  [aux_sym__section_repeat2] = "_section_repeat2",
  [aux_sym__section_repeat3] = "_section_repeat3",
  [aux_sym__section_repeat4] = "_section_repeat4",
  [aux_sym__section_repeat5] = "_section_repeat5",
  [aux_sym__paragraph_repeat1] = "_paragraph_repeat1",
  [aux_sym__paragraph_repeat2] = "_paragraph_repeat2",
  [aux_sym__paragraph_repeat3] = "_paragraph_repeat3",
  [aux_sym_part_repeat1] = "part_repeat1",
  [aux_sym_curly_group_spec_repeat1] = "curly_group_spec_repeat1",
  [aux_sym_curly_group_text_list_repeat1] = "curly_group_text_list_repeat1",
  [aux_sym_curly_group_path_list_repeat1] = "curly_group_path_list_repeat1",
  [aux_sym_curly_group_key_value_repeat1] = "curly_group_key_value_repeat1",
  [aux_sym_curly_group_impl_repeat1] = "curly_group_impl_repeat1",
  [aux_sym_curly_group_author_list_repeat1] = "curly_group_author_list_repeat1",
  [aux_sym_curly_group_author_list_repeat2] = "curly_group_author_list_repeat2",
  [aux_sym_brack_group_repeat1] = "brack_group_repeat1",
  [aux_sym_text_repeat1] = "text_repeat1",
  [aux_sym_glob_pattern_repeat1] = "glob_pattern_repeat1",
  [aux_sym_value_repeat1] = "value_repeat1",
  [aux_sym_generic_command_repeat1] = "generic_command_repeat1",
  [alias_sym_author] = "author",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_command_name] = sym_command_name,
  [sym__whitespace] = sym__whitespace,
  [sym_line_comment] = sym_line_comment,
  [anon_sym_BSLASHiffalse] = anon_sym_BSLASHiffalse,
  [anon_sym_BSLASHfi] = anon_sym_BSLASHfi,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_BSLASHpart] = anon_sym_BSLASHpart,
  [anon_sym_BSLASHpart_STAR] = anon_sym_BSLASHpart_STAR,
  [anon_sym_BSLASHaddpart] = anon_sym_BSLASHaddpart,
  [anon_sym_BSLASHaddpart_STAR] = anon_sym_BSLASHaddpart_STAR,
  [anon_sym_BSLASHchapter] = anon_sym_BSLASHchapter,
  [anon_sym_BSLASHchapter_STAR] = anon_sym_BSLASHchapter_STAR,
  [anon_sym_BSLASHaddchap] = anon_sym_BSLASHaddchap,
  [anon_sym_BSLASHaddchap_STAR] = anon_sym_BSLASHaddchap_STAR,
  [anon_sym_BSLASHsection] = anon_sym_BSLASHsection,
  [anon_sym_BSLASHsection_STAR] = anon_sym_BSLASHsection_STAR,
  [anon_sym_BSLASHaddsec] = anon_sym_BSLASHaddsec,
  [anon_sym_BSLASHaddsec_STAR] = anon_sym_BSLASHaddsec_STAR,
  [anon_sym_BSLASHsubsection] = anon_sym_BSLASHsubsection,
  [anon_sym_BSLASHsubsection_STAR] = anon_sym_BSLASHsubsection_STAR,
  [anon_sym_BSLASHsubsubsection] = anon_sym_BSLASHsubsubsection,
  [anon_sym_BSLASHsubsubsection_STAR] = anon_sym_BSLASHsubsubsection_STAR,
  [anon_sym_BSLASHparagraph] = anon_sym_BSLASHparagraph,
  [anon_sym_BSLASHparagraph_STAR] = anon_sym_BSLASHparagraph_STAR,
  [anon_sym_BSLASHsubparagraph] = anon_sym_BSLASHsubparagraph,
  [anon_sym_BSLASHsubparagraph_STAR] = anon_sym_BSLASHsubparagraph_STAR,
  [anon_sym_BSLASHitem] = anon_sym_BSLASHitem,
  [anon_sym_BSLASHitem_STAR] = anon_sym_BSLASHitem_STAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_BSLASHand] = sym_command_name,
  [sym_word] = sym_word,
  [sym_placeholder] = sym_placeholder,
  [sym_delimiter] = sym_delimiter,
  [sym_path] = sym_path,
  [sym_uri] = sym_uri,
  [sym_argc] = sym_argc,
  [aux_sym__glob_pattern_fragment_token1] = aux_sym__glob_pattern_fragment_token1,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_letter] = sym_letter,
  [anon_sym__] = anon_sym__,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_DOLLAR_DOLLAR] = anon_sym_DOLLAR_DOLLAR,
  [anon_sym_BSLASH_LBRACK] = anon_sym_BSLASH_LBRACK,
  [anon_sym_BSLASH_RBRACK] = anon_sym_BSLASH_RBRACK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_BSLASH_RPAREN] = anon_sym_BSLASH_RPAREN,
  [anon_sym_BSLASHleft] = anon_sym_BSLASHleft,
  [anon_sym_BSLASHbigl] = anon_sym_BSLASHbigl,
  [anon_sym_BSLASHBigl] = anon_sym_BSLASHBigl,
  [anon_sym_BSLASHbiggl] = anon_sym_BSLASHbiggl,
  [anon_sym_BSLASHBiggl] = anon_sym_BSLASHBiggl,
  [anon_sym_BSLASHright] = anon_sym_BSLASHright,
  [anon_sym_BSLASHbigr] = anon_sym_BSLASHbigr,
  [anon_sym_BSLASHBigr] = anon_sym_BSLASHBigr,
  [anon_sym_BSLASHbiggr] = anon_sym_BSLASHbiggr,
  [anon_sym_BSLASHBiggr] = anon_sym_BSLASHBiggr,
  [anon_sym_BSLASHtext] = anon_sym_BSLASHtext,
  [anon_sym_BSLASHintertext] = anon_sym_BSLASHintertext,
  [anon_sym_BSLASHshortintertext] = anon_sym_BSLASHshortintertext,
  [anon_sym_BSLASHbegin] = anon_sym_BSLASHbegin,
  [anon_sym_BSLASHend] = anon_sym_BSLASHend,
  [anon_sym_comment] = sym_word,
  [anon_sym_verbatim] = sym_word,
  [anon_sym_lstlisting] = sym_word,
  [anon_sym_minted] = sym_word,
  [anon_sym_asy] = sym_word,
  [anon_sym_asydef] = sym_word,
  [anon_sym_pycode] = sym_word,
  [anon_sym_luacode] = sym_word,
  [anon_sym_luacode_STAR] = sym_word,
  [anon_sym_sagesilent] = sym_word,
  [anon_sym_sageblock] = sym_word,
  [anon_sym_math] = sym_word,
  [anon_sym_displaymath] = sym_word,
  [anon_sym_displaymath_STAR] = sym_word,
  [anon_sym_equation] = sym_word,
  [anon_sym_equation_STAR] = sym_word,
  [anon_sym_multline] = sym_word,
  [anon_sym_multline_STAR] = sym_word,
  [anon_sym_eqnarray] = sym_word,
  [anon_sym_eqnarray_STAR] = sym_word,
  [anon_sym_align] = sym_word,
  [anon_sym_align_STAR] = sym_word,
  [anon_sym_aligned] = sym_word,
  [anon_sym_aligned_STAR] = sym_word,
  [anon_sym_array] = sym_word,
  [anon_sym_array_STAR] = sym_word,
  [anon_sym_split] = sym_word,
  [anon_sym_split_STAR] = sym_word,
  [anon_sym_alignat] = sym_word,
  [anon_sym_alignat_STAR] = sym_word,
  [anon_sym_alignedat] = sym_word,
  [anon_sym_alignedat_STAR] = sym_word,
  [anon_sym_gather] = sym_word,
  [anon_sym_gather_STAR] = sym_word,
  [anon_sym_gathered] = sym_word,
  [anon_sym_gathered_STAR] = sym_word,
  [anon_sym_flalign] = sym_word,
  [anon_sym_flalign_STAR] = sym_word,
  [anon_sym_BSLASHtitle] = anon_sym_BSLASHtitle,
  [anon_sym_BSLASHauthor] = anon_sym_BSLASHauthor,
  [anon_sym_BSLASHusepackage] = anon_sym_BSLASHusepackage,
  [anon_sym_BSLASHRequirePackage] = anon_sym_BSLASHRequirePackage,
  [anon_sym_BSLASHdocumentclass] = anon_sym_BSLASHdocumentclass,
  [anon_sym_BSLASHinclude] = anon_sym_BSLASHinclude,
  [anon_sym_BSLASHsubfileinclude] = anon_sym_BSLASHsubfileinclude,
  [anon_sym_BSLASHinput] = anon_sym_BSLASHinput,
  [anon_sym_BSLASHsubfile] = anon_sym_BSLASHsubfile,
  [anon_sym_BSLASHaddbibresource] = anon_sym_BSLASHaddbibresource,
  [anon_sym_BSLASHbibliographystyle] = anon_sym_BSLASHbibliographystyle,
  [anon_sym_BSLASHbibliography] = anon_sym_BSLASHbibliography,
  [anon_sym_BSLASHincludegraphics] = anon_sym_BSLASHincludegraphics,
  [anon_sym_BSLASHincludesvg] = anon_sym_BSLASHincludesvg,
  [anon_sym_BSLASHincludeinkscape] = anon_sym_BSLASHincludeinkscape,
  [anon_sym_BSLASHverbatiminput] = anon_sym_BSLASHverbatiminput,
  [anon_sym_BSLASHVerbatimInput] = anon_sym_BSLASHVerbatimInput,
  [anon_sym_BSLASHimport] = anon_sym_BSLASHimport,
  [anon_sym_BSLASHsubimport] = anon_sym_BSLASHsubimport,
  [anon_sym_BSLASHinputfrom] = anon_sym_BSLASHinputfrom,
  [anon_sym_BSLASHsubimportfrom] = anon_sym_BSLASHsubimportfrom,
  [anon_sym_BSLASHincludefrom] = anon_sym_BSLASHincludefrom,
  [anon_sym_BSLASHsubincludefrom] = anon_sym_BSLASHsubincludefrom,
  [anon_sym_BSLASHcaption] = anon_sym_BSLASHcaption,
  [anon_sym_BSLASHcite] = anon_sym_BSLASHcite,
  [anon_sym_BSLASHcite_STAR] = anon_sym_BSLASHcite_STAR,
  [anon_sym_BSLASHCite] = anon_sym_BSLASHCite,
  [anon_sym_BSLASHnocite] = anon_sym_BSLASHnocite,
  [anon_sym_BSLASHcitet] = anon_sym_BSLASHcitet,
  [anon_sym_BSLASHcitep] = anon_sym_BSLASHcitep,
  [anon_sym_BSLASHcitet_STAR] = anon_sym_BSLASHcitet_STAR,
  [anon_sym_BSLASHcitep_STAR] = anon_sym_BSLASHcitep_STAR,
  [anon_sym_BSLASHciteA] = anon_sym_BSLASHciteA,
  [anon_sym_BSLASHciteR] = anon_sym_BSLASHciteR,
  [anon_sym_BSLASHciteS] = anon_sym_BSLASHciteS,
  [anon_sym_BSLASHciteyearR] = anon_sym_BSLASHciteyearR,
  [anon_sym_BSLASHciteauthor] = anon_sym_BSLASHciteauthor,
  [anon_sym_BSLASHciteauthor_STAR] = anon_sym_BSLASHciteauthor_STAR,
  [anon_sym_BSLASHCiteauthor] = anon_sym_BSLASHCiteauthor,
  [anon_sym_BSLASHCiteauthor_STAR] = anon_sym_BSLASHCiteauthor_STAR,
  [anon_sym_BSLASHcitetitle] = anon_sym_BSLASHcitetitle,
  [anon_sym_BSLASHcitetitle_STAR] = anon_sym_BSLASHcitetitle_STAR,
  [anon_sym_BSLASHciteyear] = anon_sym_BSLASHciteyear,
  [anon_sym_BSLASHciteyear_STAR] = anon_sym_BSLASHciteyear_STAR,
  [anon_sym_BSLASHcitedate] = anon_sym_BSLASHcitedate,
  [anon_sym_BSLASHcitedate_STAR] = anon_sym_BSLASHcitedate_STAR,
  [anon_sym_BSLASHciteurl] = anon_sym_BSLASHciteurl,
  [anon_sym_BSLASHfullcite] = anon_sym_BSLASHfullcite,
  [anon_sym_BSLASHciteyearpar] = anon_sym_BSLASHciteyearpar,
  [anon_sym_BSLASHcitealt] = anon_sym_BSLASHcitealt,
  [anon_sym_BSLASHcitealp] = anon_sym_BSLASHcitealp,
  [anon_sym_BSLASHcitetext] = anon_sym_BSLASHcitetext,
  [anon_sym_BSLASHparencite] = anon_sym_BSLASHparencite,
  [anon_sym_BSLASHparencite_STAR] = anon_sym_BSLASHparencite_STAR,
  [anon_sym_BSLASHParencite] = anon_sym_BSLASHParencite,
  [anon_sym_BSLASHfootcite] = anon_sym_BSLASHfootcite,
  [anon_sym_BSLASHfootfullcite] = anon_sym_BSLASHfootfullcite,
  [anon_sym_BSLASHfootcitetext] = anon_sym_BSLASHfootcitetext,
  [anon_sym_BSLASHtextcite] = anon_sym_BSLASHtextcite,
  [anon_sym_BSLASHTextcite] = anon_sym_BSLASHTextcite,
  [anon_sym_BSLASHsmartcite] = anon_sym_BSLASHsmartcite,
  [anon_sym_BSLASHSmartcite] = anon_sym_BSLASHSmartcite,
  [anon_sym_BSLASHsupercite] = anon_sym_BSLASHsupercite,
  [anon_sym_BSLASHautocite] = anon_sym_BSLASHautocite,
  [anon_sym_BSLASHAutocite] = anon_sym_BSLASHAutocite,
  [anon_sym_BSLASHautocite_STAR] = anon_sym_BSLASHautocite_STAR,
  [anon_sym_BSLASHAutocite_STAR] = anon_sym_BSLASHAutocite_STAR,
  [anon_sym_BSLASHvolcite] = anon_sym_BSLASHvolcite,
  [anon_sym_BSLASHVolcite] = anon_sym_BSLASHVolcite,
  [anon_sym_BSLASHpvolcite] = anon_sym_BSLASHpvolcite,
  [anon_sym_BSLASHPvolcite] = anon_sym_BSLASHPvolcite,
  [anon_sym_BSLASHfvolcite] = anon_sym_BSLASHfvolcite,
  [anon_sym_BSLASHftvolcite] = anon_sym_BSLASHftvolcite,
  [anon_sym_BSLASHsvolcite] = anon_sym_BSLASHsvolcite,
  [anon_sym_BSLASHSvolcite] = anon_sym_BSLASHSvolcite,
  [anon_sym_BSLASHtvolcite] = anon_sym_BSLASHtvolcite,
  [anon_sym_BSLASHTvolcite] = anon_sym_BSLASHTvolcite,
  [anon_sym_BSLASHavolcite] = anon_sym_BSLASHavolcite,
  [anon_sym_BSLASHAvolcite] = anon_sym_BSLASHAvolcite,
  [anon_sym_BSLASHnotecite] = anon_sym_BSLASHnotecite,
  [anon_sym_BSLASHNotecite] = anon_sym_BSLASHNotecite,
  [anon_sym_BSLASHpnotecite] = anon_sym_BSLASHpnotecite,
  [anon_sym_BSLASHPnotecite] = anon_sym_BSLASHPnotecite,
  [anon_sym_BSLASHfnotecite] = anon_sym_BSLASHfnotecite,
  [anon_sym_BSLASHlabel] = anon_sym_BSLASHlabel,
  [anon_sym_BSLASHref] = anon_sym_BSLASHref,
  [anon_sym_BSLASHeqref] = anon_sym_BSLASHeqref,
  [anon_sym_BSLASHvref] = anon_sym_BSLASHvref,
  [anon_sym_BSLASHVref] = anon_sym_BSLASHVref,
  [anon_sym_BSLASHautoref] = anon_sym_BSLASHautoref,
  [anon_sym_BSLASHautoref_STAR] = anon_sym_BSLASHautoref_STAR,
  [anon_sym_BSLASHpageref] = anon_sym_BSLASHpageref,
  [anon_sym_BSLASHpageref_STAR] = anon_sym_BSLASHpageref_STAR,
  [anon_sym_BSLASHautopageref] = anon_sym_BSLASHautopageref,
  [anon_sym_BSLASHautopageref_STAR] = anon_sym_BSLASHautopageref_STAR,
  [anon_sym_BSLASHcref] = anon_sym_BSLASHcref,
  [anon_sym_BSLASHcref_STAR] = anon_sym_BSLASHcref_STAR,
  [anon_sym_BSLASHCref] = anon_sym_BSLASHCref,
  [anon_sym_BSLASHCref_STAR] = anon_sym_BSLASHCref_STAR,
  [anon_sym_BSLASHcpageref] = anon_sym_BSLASHcpageref,
  [anon_sym_BSLASHCpageref] = anon_sym_BSLASHCpageref,
  [anon_sym_BSLASHnamecref] = anon_sym_BSLASHnamecref,
  [anon_sym_BSLASHnameCref] = anon_sym_BSLASHnameCref,
  [anon_sym_BSLASHlcnamecref] = anon_sym_BSLASHlcnamecref,
  [anon_sym_BSLASHnamecrefs] = anon_sym_BSLASHnamecrefs,
  [anon_sym_BSLASHnameCrefs] = anon_sym_BSLASHnameCrefs,
  [anon_sym_BSLASHlcnamecrefs] = anon_sym_BSLASHlcnamecrefs,
  [anon_sym_BSLASHlabelcref] = anon_sym_BSLASHlabelcref,
  [anon_sym_BSLASHlabelcref_STAR] = anon_sym_BSLASHlabelcref_STAR,
  [anon_sym_BSLASHlabelcpageref] = anon_sym_BSLASHlabelcpageref,
  [anon_sym_BSLASHlabelcpageref_STAR] = anon_sym_BSLASHlabelcpageref_STAR,
  [anon_sym_BSLASHcrefrange] = anon_sym_BSLASHcrefrange,
  [anon_sym_BSLASHcrefrange_STAR] = anon_sym_BSLASHcrefrange_STAR,
  [anon_sym_BSLASHCrefrange] = anon_sym_BSLASHCrefrange,
  [anon_sym_BSLASHCrefrange_STAR] = anon_sym_BSLASHCrefrange_STAR,
  [anon_sym_BSLASHcpagerefrange] = anon_sym_BSLASHcpagerefrange,
  [anon_sym_BSLASHCpagerefrange] = anon_sym_BSLASHCpagerefrange,
  [anon_sym_BSLASHnewlabel] = anon_sym_BSLASHnewlabel,
  [anon_sym_BSLASHnewcommand] = anon_sym_BSLASHnewcommand,
  [anon_sym_BSLASHnewcommand_STAR] = anon_sym_BSLASHnewcommand_STAR,
  [anon_sym_BSLASHrenewcommand] = anon_sym_BSLASHrenewcommand,
  [anon_sym_BSLASHrenewcommand_STAR] = anon_sym_BSLASHrenewcommand_STAR,
  [anon_sym_BSLASHprovidecommand] = anon_sym_BSLASHprovidecommand,
  [anon_sym_BSLASHprovidecommand_STAR] = anon_sym_BSLASHprovidecommand_STAR,
  [anon_sym_BSLASHDeclareRobustCommand] = anon_sym_BSLASHDeclareRobustCommand,
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = anon_sym_BSLASHDeclareRobustCommand_STAR,
  [anon_sym_BSLASHDeclareMathOperator] = anon_sym_BSLASHDeclareMathOperator,
  [anon_sym_BSLASHDeclareMathOperator_STAR] = anon_sym_BSLASHDeclareMathOperator_STAR,
  [anon_sym_BSLASHNewDocumentCommand] = anon_sym_BSLASHNewDocumentCommand,
  [anon_sym_BSLASHRenewDocumentCommand] = anon_sym_BSLASHRenewDocumentCommand,
  [anon_sym_BSLASHProvideDocumentCommand] = anon_sym_BSLASHProvideDocumentCommand,
  [anon_sym_BSLASHDeclareDocumentCommand] = anon_sym_BSLASHDeclareDocumentCommand,
  [anon_sym_BSLASHNewExpandableDocumentCommand] = anon_sym_BSLASHNewExpandableDocumentCommand,
  [anon_sym_BSLASHRenewExpandableDocumentCommand] = anon_sym_BSLASHRenewExpandableDocumentCommand,
  [anon_sym_BSLASHProvideExpandableDocumentCommand] = anon_sym_BSLASHProvideExpandableDocumentCommand,
  [anon_sym_BSLASHDeclareExpandableDocumentCommand] = anon_sym_BSLASHDeclareExpandableDocumentCommand,
  [anon_sym_BSLASHNewCommandCopy] = anon_sym_BSLASHNewCommandCopy,
  [anon_sym_BSLASHRenewCommandCopy] = anon_sym_BSLASHRenewCommandCopy,
  [anon_sym_BSLASHDeclareCommandCopy] = anon_sym_BSLASHDeclareCommandCopy,
  [anon_sym_BSLASHdef] = anon_sym_BSLASHdef,
  [anon_sym_BSLASHgdef] = anon_sym_BSLASHgdef,
  [anon_sym_BSLASHedef] = anon_sym_BSLASHedef,
  [anon_sym_BSLASHxdef] = anon_sym_BSLASHxdef,
  [anon_sym_BSLASHlet] = anon_sym_BSLASHlet,
  [anon_sym_BSLASHglet] = anon_sym_BSLASHglet,
  [anon_sym_BSLASHDeclarePairedDelimiter] = anon_sym_BSLASHDeclarePairedDelimiter,
  [anon_sym_BSLASHDeclarePairedDelimiterX] = anon_sym_BSLASHDeclarePairedDelimiterX,
  [anon_sym_BSLASHnewenvironment] = anon_sym_BSLASHnewenvironment,
  [anon_sym_BSLASHrenewenvironment] = anon_sym_BSLASHrenewenvironment,
  [anon_sym_BSLASHNewDocumentEnvironment] = anon_sym_BSLASHNewDocumentEnvironment,
  [anon_sym_BSLASHRenewDocumentEnvironment] = anon_sym_BSLASHRenewDocumentEnvironment,
  [anon_sym_BSLASHProvideDocumentEnvironment] = anon_sym_BSLASHProvideDocumentEnvironment,
  [anon_sym_BSLASHDeclareDocumentEnvironment] = anon_sym_BSLASHDeclareDocumentEnvironment,
  [anon_sym_BSLASHNewEnvironmentCopy] = anon_sym_BSLASHNewEnvironmentCopy,
  [anon_sym_BSLASHRenewEnvironmentCopy] = anon_sym_BSLASHRenewEnvironmentCopy,
  [anon_sym_BSLASHDeclareEnvironmentCopy] = anon_sym_BSLASHDeclareEnvironmentCopy,
  [anon_sym_BSLASHnewglossaryentry] = anon_sym_BSLASHnewglossaryentry,
  [anon_sym_BSLASHgls] = anon_sym_BSLASHgls,
  [anon_sym_BSLASHGls] = anon_sym_BSLASHGls,
  [anon_sym_BSLASHGLS] = anon_sym_BSLASHGLS,
  [anon_sym_BSLASHglspl] = anon_sym_BSLASHglspl,
  [anon_sym_BSLASHGlspl] = anon_sym_BSLASHGlspl,
  [anon_sym_BSLASHGLSpl] = anon_sym_BSLASHGLSpl,
  [anon_sym_BSLASHglsdisp] = anon_sym_BSLASHglsdisp,
  [anon_sym_BSLASHglslink] = anon_sym_BSLASHglslink,
  [anon_sym_BSLASHglstext] = anon_sym_BSLASHglstext,
  [anon_sym_BSLASHGlstext] = anon_sym_BSLASHGlstext,
  [anon_sym_BSLASHGLStext] = anon_sym_BSLASHGLStext,
  [anon_sym_BSLASHglsfirst] = anon_sym_BSLASHglsfirst,
  [anon_sym_BSLASHGlsfirst] = anon_sym_BSLASHGlsfirst,
  [anon_sym_BSLASHGLSfirst] = anon_sym_BSLASHGLSfirst,
  [anon_sym_BSLASHglsplural] = anon_sym_BSLASHglsplural,
  [anon_sym_BSLASHGlsplural] = anon_sym_BSLASHGlsplural,
  [anon_sym_BSLASHGLSplural] = anon_sym_BSLASHGLSplural,
  [anon_sym_BSLASHglsfirstplural] = anon_sym_BSLASHglsfirstplural,
  [anon_sym_BSLASHGlsfirstplural] = anon_sym_BSLASHGlsfirstplural,
  [anon_sym_BSLASHGLSfirstplural] = anon_sym_BSLASHGLSfirstplural,
  [anon_sym_BSLASHglsname] = anon_sym_BSLASHglsname,
  [anon_sym_BSLASHGlsname] = anon_sym_BSLASHGlsname,
  [anon_sym_BSLASHGLSname] = anon_sym_BSLASHGLSname,
  [anon_sym_BSLASHglssymbol] = anon_sym_BSLASHglssymbol,
  [anon_sym_BSLASHGlssymbol] = anon_sym_BSLASHGlssymbol,
  [anon_sym_BSLASHglsdesc] = anon_sym_BSLASHglsdesc,
  [anon_sym_BSLASHGlsdesc] = anon_sym_BSLASHGlsdesc,
  [anon_sym_BSLASHGLSdesc] = anon_sym_BSLASHGLSdesc,
  [anon_sym_BSLASHglsuseri] = anon_sym_BSLASHglsuseri,
  [anon_sym_BSLASHGlsuseri] = anon_sym_BSLASHGlsuseri,
  [anon_sym_BSLASHGLSuseri] = anon_sym_BSLASHGLSuseri,
  [anon_sym_BSLASHglsuserii] = anon_sym_BSLASHglsuserii,
  [anon_sym_BSLASHGlsuserii] = anon_sym_BSLASHGlsuserii,
  [anon_sym_BSLASHGLSuserii] = anon_sym_BSLASHGLSuserii,
  [anon_sym_BSLASHglsuseriii] = anon_sym_BSLASHglsuseriii,
  [anon_sym_BSLASHGlsuseriii] = anon_sym_BSLASHGlsuseriii,
  [anon_sym_BSLASHGLSuseriii] = anon_sym_BSLASHGLSuseriii,
  [anon_sym_BSLASHglsuseriv] = anon_sym_BSLASHglsuseriv,
  [anon_sym_BSLASHGlsuseriv] = anon_sym_BSLASHGlsuseriv,
  [anon_sym_BSLASHGLSuseriv] = anon_sym_BSLASHGLSuseriv,
  [anon_sym_BSLASHglsuserv] = anon_sym_BSLASHglsuserv,
  [anon_sym_BSLASHGlsuserv] = anon_sym_BSLASHGlsuserv,
  [anon_sym_BSLASHGLSuserv] = anon_sym_BSLASHGLSuserv,
  [anon_sym_BSLASHglsuservi] = anon_sym_BSLASHglsuservi,
  [anon_sym_BSLASHGlsuservi] = anon_sym_BSLASHGlsuservi,
  [anon_sym_BSLASHGLSuservi] = anon_sym_BSLASHGLSuservi,
  [anon_sym_BSLASHnewacronym] = anon_sym_BSLASHnewacronym,
  [anon_sym_BSLASHacrshort] = anon_sym_BSLASHacrshort,
  [anon_sym_BSLASHAcrshort] = anon_sym_BSLASHAcrshort,
  [anon_sym_BSLASHACRshort] = anon_sym_BSLASHACRshort,
  [anon_sym_BSLASHacrshortpl] = anon_sym_BSLASHacrshortpl,
  [anon_sym_BSLASHAcrshortpl] = anon_sym_BSLASHAcrshortpl,
  [anon_sym_BSLASHACRshortpl] = anon_sym_BSLASHACRshortpl,
  [anon_sym_BSLASHacrlong] = anon_sym_BSLASHacrlong,
  [anon_sym_BSLASHAcrlong] = anon_sym_BSLASHAcrlong,
  [anon_sym_BSLASHACRlong] = anon_sym_BSLASHACRlong,
  [anon_sym_BSLASHacrlongpl] = anon_sym_BSLASHacrlongpl,
  [anon_sym_BSLASHAcrlongpl] = anon_sym_BSLASHAcrlongpl,
  [anon_sym_BSLASHACRlongpl] = anon_sym_BSLASHACRlongpl,
  [anon_sym_BSLASHacrfull] = anon_sym_BSLASHacrfull,
  [anon_sym_BSLASHAcrfull] = anon_sym_BSLASHAcrfull,
  [anon_sym_BSLASHACRfull] = anon_sym_BSLASHACRfull,
  [anon_sym_BSLASHacrfullpl] = anon_sym_BSLASHacrfullpl,
  [anon_sym_BSLASHAcrfullpl] = anon_sym_BSLASHAcrfullpl,
  [anon_sym_BSLASHACRfullpl] = anon_sym_BSLASHACRfullpl,
  [anon_sym_BSLASHacs] = anon_sym_BSLASHacs,
  [anon_sym_BSLASHAcs] = anon_sym_BSLASHAcs,
  [anon_sym_BSLASHacsp] = anon_sym_BSLASHacsp,
  [anon_sym_BSLASHAcsp] = anon_sym_BSLASHAcsp,
  [anon_sym_BSLASHacl] = anon_sym_BSLASHacl,
  [anon_sym_BSLASHAcl] = anon_sym_BSLASHAcl,
  [anon_sym_BSLASHaclp] = anon_sym_BSLASHaclp,
  [anon_sym_BSLASHAclp] = anon_sym_BSLASHAclp,
  [anon_sym_BSLASHacf] = anon_sym_BSLASHacf,
  [anon_sym_BSLASHAcf] = anon_sym_BSLASHAcf,
  [anon_sym_BSLASHacfp] = anon_sym_BSLASHacfp,
  [anon_sym_BSLASHAcfp] = anon_sym_BSLASHAcfp,
  [anon_sym_BSLASHac] = anon_sym_BSLASHac,
  [anon_sym_BSLASHAc] = anon_sym_BSLASHAc,
  [anon_sym_BSLASHacp] = anon_sym_BSLASHacp,
  [anon_sym_BSLASHglsentrylong] = anon_sym_BSLASHglsentrylong,
  [anon_sym_BSLASHGlsentrylong] = anon_sym_BSLASHGlsentrylong,
  [anon_sym_BSLASHglsentrylongpl] = anon_sym_BSLASHglsentrylongpl,
  [anon_sym_BSLASHGlsentrylongpl] = anon_sym_BSLASHGlsentrylongpl,
  [anon_sym_BSLASHglsentryshort] = anon_sym_BSLASHglsentryshort,
  [anon_sym_BSLASHGlsentryshort] = anon_sym_BSLASHGlsentryshort,
  [anon_sym_BSLASHglsentryshortpl] = anon_sym_BSLASHglsentryshortpl,
  [anon_sym_BSLASHGlsentryshortpl] = anon_sym_BSLASHGlsentryshortpl,
  [anon_sym_BSLASHglsentryfullpl] = anon_sym_BSLASHglsentryfullpl,
  [anon_sym_BSLASHGlsentryfullpl] = anon_sym_BSLASHGlsentryfullpl,
  [anon_sym_BSLASHnewtheorem] = anon_sym_BSLASHnewtheorem,
  [anon_sym_BSLASHnewtheorem_STAR] = anon_sym_BSLASHnewtheorem_STAR,
  [anon_sym_BSLASHdeclaretheorem] = anon_sym_BSLASHdeclaretheorem,
  [anon_sym_BSLASHdeclaretheorem_STAR] = anon_sym_BSLASHdeclaretheorem_STAR,
  [anon_sym_BSLASHdefinecolor] = anon_sym_BSLASHdefinecolor,
  [anon_sym_BSLASHdefinecolorset] = anon_sym_BSLASHdefinecolorset,
  [anon_sym_BSLASHcolor] = anon_sym_BSLASHcolor,
  [anon_sym_BSLASHpagecolor] = anon_sym_BSLASHpagecolor,
  [anon_sym_BSLASHtextcolor] = anon_sym_BSLASHtextcolor,
  [anon_sym_BSLASHmathcolor] = anon_sym_BSLASHmathcolor,
  [anon_sym_BSLASHcolorbox] = anon_sym_BSLASHcolorbox,
  [anon_sym_BSLASHusepgflibrary] = anon_sym_BSLASHusepgflibrary,
  [anon_sym_BSLASHusetikzlibrary] = anon_sym_BSLASHusetikzlibrary,
  [anon_sym_BSLASHurl] = anon_sym_BSLASHurl,
  [anon_sym_BSLASHhref] = anon_sym_BSLASHhref,
  [sym__trivia_raw_fi] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_comment] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_verbatim] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_listing] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_minted] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_asy] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_asydef] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_pycode] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_luacode] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_luacode_star] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_sagesilent] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_sageblock] = sym__trivia_raw_env_listing,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym__root_content] = sym__root_content,
  [sym__flat_content] = sym__flat_content,
  [sym__text_with_env_content] = sym__text_with_env_content,
  [sym__text_content] = sym__text_content,
  [sym__section] = sym__section,
  [sym__paragraph] = sym__paragraph,
  [sym__section_part] = sym__section_part,
  [sym__part_declaration] = sym__part_declaration,
  [sym_part] = sym_part,
  [sym__chapter_declaration] = sym__chapter_declaration,
  [sym_chapter] = sym_chapter,
  [sym__section_declaration] = sym__section_declaration,
  [sym_section] = sym_section,
  [sym__subsection_declaration] = sym__subsection_declaration,
  [sym_subsection] = sym_subsection,
  [sym__subsubsection_declaration] = sym__subsubsection_declaration,
  [sym_subsubsection] = sym_subsubsection,
  [sym__paragraph_declaration] = sym__paragraph_declaration,
  [sym_paragraph] = sym_paragraph,
  [sym__subparagraph_declaration] = sym__subparagraph_declaration,
  [sym_subparagraph] = sym_subparagraph,
  [sym__enum_itemdeclaration] = sym__enum_itemdeclaration,
  [sym_enum_item] = sym_enum_item,
  [sym_curly_group] = sym_curly_group,
  [sym_curly_group_text] = sym_curly_group_text,
  [sym_curly_group_spec] = sym_curly_group_spec,
  [sym_curly_group_text_list] = sym_curly_group_text_list,
  [sym_curly_group_path] = sym_curly_group_path,
  [sym_curly_group_path_list] = sym_curly_group_path_list,
  [sym_curly_group_uri] = sym_curly_group_uri,
  [sym_curly_group_command_name] = sym_curly_group_command_name,
  [sym_curly_group_key_value] = sym_curly_group_key_value,
  [sym_curly_group_glob_pattern] = sym_curly_group_glob_pattern,
  [sym_curly_group_impl] = sym_curly_group_impl,
  [sym_curly_group_author_list] = sym_curly_group_author_list,
  [sym_brack_group] = sym_brack_group,
  [sym_brack_group_text] = sym_brack_group_text,
  [sym_brack_group_argc] = sym_brack_group_argc,
  [sym_brack_group_key_value] = sym_brack_group_key_value,
  [sym_text] = sym_text,
  [sym_glob_pattern] = sym_glob_pattern,
  [sym__glob_pattern_fragment] = sym__glob_pattern_fragment,
  [sym_operator] = sym_operator,
  [sym_subscript] = sym_subscript,
  [sym_superscript] = sym_superscript,
  [sym_key_value_pair] = sym_key_value_pair,
  [sym_value] = sym_value,
  [sym__math_content] = sym__math_content,
  [sym_displayed_equation] = sym_displayed_equation,
  [sym_inline_formula] = sym_inline_formula,
  [sym__math_delimiter_part] = sym__math_delimiter_part,
  [sym_math_delimiter] = sym_math_delimiter,
  [sym_text_mode] = sym_text_mode,
  [sym_begin] = sym_begin,
  [sym_end] = sym_end,
  [sym_generic_environment] = sym_generic_environment,
  [sym_comment_environment] = sym_comment_environment,
  [sym__comment_environment_begin] = sym_begin,
  [sym__comment_environment_end] = sym_end,
  [sym__comment_environment_group] = sym_curly_group_text,
  [sym__comment_environment_name] = sym_text,
  [sym_verbatim_environment] = sym_verbatim_environment,
  [sym__verbatim_environment_begin] = sym_begin,
  [sym__verbatim_environment_end] = sym_end,
  [sym__verbatim_environment_group] = sym_curly_group_text,
  [sym__verbatim_environment_name] = sym_text,
  [sym_listing_environment] = sym_listing_environment,
  [sym__listing_environment_begin] = sym_begin,
  [sym__listing_environment_end] = sym_end,
  [sym__listing_environment_group] = sym_curly_group_text,
  [sym__listing_environment_name] = sym_text,
  [sym_minted_environment] = sym_minted_environment,
  [sym__minted_environment_begin] = sym_begin,
  [sym__minted_environment_end] = sym_end,
  [sym__minted_environment_group] = sym_curly_group_text,
  [sym__minted_environment_name] = sym_text,
  [sym_asy_environment] = sym_asy_environment,
  [sym__asy_environment_begin] = sym_begin,
  [sym__asy_environment_end] = sym_end,
  [sym__asy_environment_group] = sym_curly_group_text,
  [sym__asy_environment_name] = sym_text,
  [sym_asydef_environment] = sym_asydef_environment,
  [sym__asydef_environment_begin] = sym_begin,
  [sym__asydef_environment_end] = sym_end,
  [sym__asydef_environment_group] = sym_curly_group_text,
  [sym__asydef_environment_name] = sym_text,
  [sym_pycode_environment] = sym_pycode_environment,
  [sym__pycode_environment_begin] = sym_begin,
  [sym__pycode_environment_end] = sym_end,
  [sym__pycode_environment_group] = sym_curly_group_text,
  [sym__pycode_environment_name] = sym_text,
  [sym_luacode_environment] = sym_luacode_environment,
  [sym__luacode_environment] = sym__luacode_environment,
  [sym___luacode_environment_begin] = sym_begin,
  [sym___luacode_environment_end] = sym_end,
  [sym___luacode_environment_group] = sym_curly_group_text,
  [sym___luacode_environment_name] = sym_text,
  [sym__luacode_environment_star] = sym__luacode_environment_star,
  [sym___luacode_environment_star_begin] = sym_begin,
  [sym___luacode_environment_star_end] = sym_end,
  [sym___luacode_environment_star_group] = sym_curly_group_text,
  [sym___luacode_environment_star_name] = sym_text,
  [sym_sagesilent_environment] = sym_sagesilent_environment,
  [sym__sagesilent_environment_begin] = sym_begin,
  [sym__sagesilent_environment_end] = sym_end,
  [sym__sagesilent_environment_group] = sym_curly_group_text,
  [sym__sagesilent_environment_name] = sym_text,
  [sym_sageblock_environment] = sym_sageblock_environment,
  [sym__sageblock_environment_begin] = sym_begin,
  [sym__sageblock_environment_end] = sym_end,
  [sym__sageblock_environment_group] = sym_curly_group_text,
  [sym__sageblock_environment_name] = sym_text,
  [sym_math_environment] = sym_math_environment,
  [sym__math_environment_begin] = sym_begin,
  [sym__math_environment_end] = sym_end,
  [sym__math_environment_group] = sym_curly_group_text,
  [sym__math_environment_name] = sym_text,
  [sym__command] = sym__command,
  [sym_generic_command] = sym_generic_command,
  [sym_title_declaration] = sym_title_declaration,
  [sym_author_declaration] = sym_author_declaration,
  [sym_package_include] = sym_package_include,
  [sym_class_include] = sym_class_include,
  [sym_latex_include] = sym_latex_include,
  [sym_biblatex_include] = sym_biblatex_include,
  [sym_bibstyle_include] = sym_bibstyle_include,
  [sym_bibtex_include] = sym_bibtex_include,
  [sym_graphics_include] = sym_graphics_include,
  [sym_svg_include] = sym_svg_include,
  [sym_inkscape_include] = sym_inkscape_include,
  [sym_verbatim_include] = sym_verbatim_include,
  [sym_import_include] = sym_import_include,
  [sym_caption] = sym_caption,
  [sym_citation] = sym_citation,
  [sym_label_definition] = sym_label_definition,
  [sym_label_reference] = sym_label_reference,
  [sym_label_reference_range] = sym_label_reference_range,
  [sym_label_number] = sym_label_number,
  [sym_new_command_definition] = sym_new_command_definition,
  [sym__new_command_definition] = sym__new_command_definition,
  [sym__newer_command_definition] = sym__newer_command_definition,
  [sym__new_command_copy] = sym__new_command_copy,
  [sym_old_command_definition] = sym_old_command_definition,
  [sym_let_command_definition] = sym_let_command_definition,
  [sym_paired_delimiter_definition] = sym_paired_delimiter_definition,
  [sym_environment_definition] = sym_environment_definition,
  [sym__environment_definition] = sym__environment_definition,
  [sym__newer_environment_definition] = sym__newer_environment_definition,
  [sym__new_environment_copy] = sym__new_environment_copy,
  [sym_glossary_entry_definition] = sym_glossary_entry_definition,
  [sym_glossary_entry_reference] = sym_glossary_entry_reference,
  [sym_acronym_definition] = sym_acronym_definition,
  [sym_acronym_reference] = sym_acronym_reference,
  [sym_theorem_definition] = sym_theorem_definition,
  [sym_color_definition] = sym_color_definition,
  [sym_color_set_definition] = sym_color_set_definition,
  [sym_color_reference] = sym_color_reference,
  [sym_tikz_library_import] = sym_tikz_library_import,
  [sym_hyperlink] = sym_hyperlink,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym__section_repeat1] = aux_sym__section_repeat1,
  [aux_sym__section_repeat2] = aux_sym__section_repeat2,
  [aux_sym__section_repeat3] = aux_sym__section_repeat3,
  [aux_sym__section_repeat4] = aux_sym__section_repeat4,
  [aux_sym__section_repeat5] = aux_sym__section_repeat5,
  [aux_sym__paragraph_repeat1] = aux_sym__paragraph_repeat1,
  [aux_sym__paragraph_repeat2] = aux_sym__paragraph_repeat2,
  [aux_sym__paragraph_repeat3] = aux_sym__paragraph_repeat3,
  [aux_sym_part_repeat1] = aux_sym_part_repeat1,
  [aux_sym_curly_group_spec_repeat1] = aux_sym_curly_group_spec_repeat1,
  [aux_sym_curly_group_text_list_repeat1] = aux_sym_curly_group_text_list_repeat1,
  [aux_sym_curly_group_path_list_repeat1] = aux_sym_curly_group_path_list_repeat1,
  [aux_sym_curly_group_key_value_repeat1] = aux_sym_curly_group_key_value_repeat1,
  [aux_sym_curly_group_impl_repeat1] = aux_sym_curly_group_impl_repeat1,
  [aux_sym_curly_group_author_list_repeat1] = aux_sym_curly_group_author_list_repeat1,
  [aux_sym_curly_group_author_list_repeat2] = aux_sym_curly_group_author_list_repeat2,
  [aux_sym_brack_group_repeat1] = aux_sym_brack_group_repeat1,
  [aux_sym_text_repeat1] = aux_sym_text_repeat1,
  [aux_sym_glob_pattern_repeat1] = aux_sym_glob_pattern_repeat1,
  [aux_sym_value_repeat1] = aux_sym_value_repeat1,
  [aux_sym_generic_command_repeat1] = aux_sym_generic_command_repeat1,
  [alias_sym_author] = alias_sym_author,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHiffalse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpart_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddpart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddpart_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHchapter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHchapter_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddchap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddchap_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddsec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddsec_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsubsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsubsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparagraph] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparagraph_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubparagraph] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubparagraph_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHitem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHitem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHand] = {
    .visible = true,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [sym_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym_path] = {
    .visible = true,
    .named = true,
  },
  [sym_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_argc] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__glob_pattern_fragment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_letter] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleft] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbigl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBigl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbiggl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBiggl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHright] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbigr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBigr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbiggr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBiggr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintertext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHshortintertext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbegin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_verbatim] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_lstlisting] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_minted] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_asy] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_asydef] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_pycode] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_luacode] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_luacode_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_sagesilent] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_sageblock] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_math] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_displaymath] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_displaymath_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_equation] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_equation_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_multline] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_multline_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_eqnarray] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_eqnarray_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_align] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_align_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_aligned] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_aligned_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_array] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_array_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_split] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_split_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alignat] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alignat_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alignedat] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alignedat_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_gather] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_gather_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_gathered] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_gathered_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_flalign] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_flalign_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHtitle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusepackage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRequirePackage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdocumentclass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubfileinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubfile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddbibresource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbibliographystyle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbibliography] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludegraphics] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludesvg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludeinkscape] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHverbatiminput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVerbatimInput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinputfrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubimportfrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludefrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubincludefrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcaption] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitep] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitet_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitep_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyearR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteauthor_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCiteauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCiteauthor_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetitle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetitle_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyear_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitedate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitedate_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteurl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfullcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyearpar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitealt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitealp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparencite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparencite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHParencite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootfullcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootcitetext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtextcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHTextcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsmartcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHSmartcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupercite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAutocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautocite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAutocite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHPvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHftvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHSvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHTvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHavolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHPnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHeqref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHvref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautoref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautoref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpageref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautopageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautopageref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcpageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCpageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnamecref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnameCref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlcnamecref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnamecrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnameCrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlcnamecrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabelcref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabelcref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabelcpageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabelcpageref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcrefrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcrefrange_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCrefrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCrefrange_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcpagerefrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCpagerefrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewlabel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewcommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewcommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewcommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewcommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHprovidecommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHprovidecommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareRobustCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareMathOperator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareMathOperator_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNewDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRenewDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHProvideDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNewExpandableDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRenewExpandableDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHProvideExpandableDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareExpandableDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNewCommandCopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRenewCommandCopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareCommandCopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHxdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclarePairedDelimiter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclarePairedDelimiterX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewenvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewenvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNewDocumentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRenewDocumentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHProvideDocumentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareDocumentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNewEnvironmentCopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRenewEnvironmentCopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareEnvironmentCopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewglossaryentry] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgls] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGls] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglspl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlspl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsdisp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglslink] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglstext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlstext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLStext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglssymbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlssymbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewacronym] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacsp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcsp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaclp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAclp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentrylong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentrylong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentrylongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentrylongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewtheorem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewtheorem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdeclaretheorem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdeclaretheorem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdefinecolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdefinecolorset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpagecolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtextcolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHmathcolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcolorbox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusepgflibrary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusetikzlibrary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHurl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHhref] = {
    .visible = true,
    .named = false,
  },
  [sym__trivia_raw_fi] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_verbatim] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_listing] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_minted] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_asy] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_asydef] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_pycode] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_luacode] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_luacode_star] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_sagesilent] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_sageblock] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__root_content] = {
    .visible = false,
    .named = true,
  },
  [sym__flat_content] = {
    .visible = false,
    .named = true,
  },
  [sym__text_with_env_content] = {
    .visible = false,
    .named = true,
  },
  [sym__text_content] = {
    .visible = false,
    .named = true,
  },
  [sym__section] = {
    .visible = false,
    .named = true,
  },
  [sym__paragraph] = {
    .visible = false,
    .named = true,
  },
  [sym__section_part] = {
    .visible = false,
    .named = true,
  },
  [sym__part_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_part] = {
    .visible = true,
    .named = true,
  },
  [sym__chapter_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_chapter] = {
    .visible = true,
    .named = true,
  },
  [sym__section_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym__subsection_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subsection] = {
    .visible = true,
    .named = true,
  },
  [sym__subsubsection_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subsubsection] = {
    .visible = true,
    .named = true,
  },
  [sym__paragraph_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_paragraph] = {
    .visible = true,
    .named = true,
  },
  [sym__subparagraph_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subparagraph] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_itemdeclaration] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_item] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_text] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_text_list] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_path] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_path_list] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_glob_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_impl] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_author_list] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_text] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_argc] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym_glob_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__glob_pattern_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_superscript] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym__math_content] = {
    .visible = false,
    .named = true,
  },
  [sym_displayed_equation] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_formula] = {
    .visible = true,
    .named = true,
  },
  [sym__math_delimiter_part] = {
    .visible = false,
    .named = true,
  },
  [sym_math_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym_text_mode] = {
    .visible = true,
    .named = true,
  },
  [sym_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_end] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_environment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_listing_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_minted_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_asy_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__asy_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__asy_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__asy_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__asy_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_asydef_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__asydef_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__asydef_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__asydef_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__asydef_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_pycode_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_luacode_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__luacode_environment] = {
    .visible = false,
    .named = true,
  },
  [sym___luacode_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym___luacode_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym___luacode_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym___luacode_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym__luacode_environment_star] = {
    .visible = false,
    .named = true,
  },
  [sym___luacode_environment_star_begin] = {
    .visible = true,
    .named = true,
  },
  [sym___luacode_environment_star_end] = {
    .visible = true,
    .named = true,
  },
  [sym___luacode_environment_star_group] = {
    .visible = true,
    .named = true,
  },
  [sym___luacode_environment_star_name] = {
    .visible = true,
    .named = true,
  },
  [sym_sagesilent_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__sagesilent_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__sagesilent_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__sagesilent_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__sagesilent_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_sageblock_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__sageblock_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__sageblock_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__sageblock_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__sageblock_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_math_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym__command] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_command] = {
    .visible = true,
    .named = true,
  },
  [sym_title_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_author_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_package_include] = {
    .visible = true,
    .named = true,
  },
  [sym_class_include] = {
    .visible = true,
    .named = true,
  },
  [sym_latex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_biblatex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_bibstyle_include] = {
    .visible = true,
    .named = true,
  },
  [sym_bibtex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_graphics_include] = {
    .visible = true,
    .named = true,
  },
  [sym_svg_include] = {
    .visible = true,
    .named = true,
  },
  [sym_inkscape_include] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_include] = {
    .visible = true,
    .named = true,
  },
  [sym_import_include] = {
    .visible = true,
    .named = true,
  },
  [sym_caption] = {
    .visible = true,
    .named = true,
  },
  [sym_citation] = {
    .visible = true,
    .named = true,
  },
  [sym_label_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_label_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_label_reference_range] = {
    .visible = true,
    .named = true,
  },
  [sym_label_number] = {
    .visible = true,
    .named = true,
  },
  [sym_new_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__new_command_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__newer_command_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__new_command_copy] = {
    .visible = false,
    .named = true,
  },
  [sym_old_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_let_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_paired_delimiter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_environment_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__environment_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__newer_environment_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__new_environment_copy] = {
    .visible = false,
    .named = true,
  },
  [sym_glossary_entry_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_glossary_entry_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_acronym_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_acronym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_set_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_tikz_library_import] = {
    .visible = true,
    .named = true,
  },
  [sym_hyperlink] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paragraph_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paragraph_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paragraph_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_part_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_spec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_text_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_path_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_key_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_impl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_author_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_author_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brack_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_glob_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_author] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_arg = 1,
  field_argc = 2,
  field_authors = 3,
  field_begin = 4,
  field_body = 5,
  field_code = 6,
  field_command = 7,
  field_comment = 8,
  field_content = 9,
  field_counter = 10,
  field_declaration = 11,
  field_default = 12,
  field_directory = 13,
  field_end = 14,
  field_file = 15,
  field_from = 16,
  field_glob = 17,
  field_head = 18,
  field_implementation = 19,
  field_key = 20,
  field_keys = 21,
  field_label = 22,
  field_language = 23,
  field_left = 24,
  field_left_command = 25,
  field_left_delimiter = 26,
  field_long = 27,
  field_model = 28,
  field_name = 29,
  field_names = 30,
  field_number = 31,
  field_options = 32,
  field_pair = 33,
  field_path = 34,
  field_paths = 35,
  field_pattern = 36,
  field_postnote = 37,
  field_prenote = 38,
  field_right = 39,
  field_right_command = 40,
  field_right_delimiter = 41,
  field_short = 42,
  field_spec = 43,
  field_subscript = 44,
  field_superscript = 45,
  field_tail = 46,
  field_text = 47,
  field_title = 48,
  field_to = 49,
  field_toc = 50,
  field_ty = 51,
  field_uri = 52,
  field_value = 53,
  field_verbatim = 54,
  field_word = 55,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_argc] = "argc",
  [field_authors] = "authors",
  [field_begin] = "begin",
  [field_body] = "body",
  [field_code] = "code",
  [field_command] = "command",
  [field_comment] = "comment",
  [field_content] = "content",
  [field_counter] = "counter",
  [field_declaration] = "declaration",
  [field_default] = "default",
  [field_directory] = "directory",
  [field_end] = "end",
  [field_file] = "file",
  [field_from] = "from",
  [field_glob] = "glob",
  [field_head] = "head",
  [field_implementation] = "implementation",
  [field_key] = "key",
  [field_keys] = "keys",
  [field_label] = "label",
  [field_language] = "language",
  [field_left] = "left",
  [field_left_command] = "left_command",
  [field_left_delimiter] = "left_delimiter",
  [field_long] = "long",
  [field_model] = "model",
  [field_name] = "name",
  [field_names] = "names",
  [field_number] = "number",
  [field_options] = "options",
  [field_pair] = "pair",
  [field_path] = "path",
  [field_paths] = "paths",
  [field_pattern] = "pattern",
  [field_postnote] = "postnote",
  [field_prenote] = "prenote",
  [field_right] = "right",
  [field_right_command] = "right_command",
  [field_right_delimiter] = "right_delimiter",
  [field_short] = "short",
  [field_spec] = "spec",
  [field_subscript] = "subscript",
  [field_superscript] = "superscript",
  [field_tail] = "tail",
  [field_text] = "text",
  [field_title] = "title",
  [field_to] = "to",
  [field_toc] = "toc",
  [field_ty] = "ty",
  [field_uri] = "uri",
  [field_value] = "value",
  [field_verbatim] = "verbatim",
  [field_word] = "word",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 3},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 3},
  [7] = {.index = 11, .length = 5},
  [8] = {.index = 16, .length = 4},
  [9] = {.index = 20, .length = 3},
  [10] = {.index = 23, .length = 5},
  [11] = {.index = 28, .length = 5},
  [12] = {.index = 33, .length = 2},
  [13] = {.index = 35, .length = 1},
  [14] = {.index = 36, .length = 2},
  [15] = {.index = 38, .length = 2},
  [16] = {.index = 40, .length = 3},
  [17] = {.index = 43, .length = 1},
  [18] = {.index = 44, .length = 2},
  [19] = {.index = 46, .length = 1},
  [20] = {.index = 47, .length = 1},
  [21] = {.index = 48, .length = 2},
  [22] = {.index = 50, .length = 2},
  [23] = {.index = 52, .length = 3},
  [24] = {.index = 55, .length = 1},
  [25] = {.index = 56, .length = 2},
  [26] = {.index = 58, .length = 2},
  [27] = {.index = 60, .length = 2},
  [28] = {.index = 62, .length = 2},
  [29] = {.index = 64, .length = 2},
  [30] = {.index = 66, .length = 1},
  [31] = {.index = 67, .length = 2},
  [32] = {.index = 69, .length = 2},
  [33] = {.index = 71, .length = 2},
  [34] = {.index = 73, .length = 2},
  [35] = {.index = 75, .length = 2},
  [36] = {.index = 77, .length = 6},
  [37] = {.index = 83, .length = 2},
  [38] = {.index = 85, .length = 3},
  [39] = {.index = 88, .length = 2},
  [40] = {.index = 90, .length = 3},
  [41] = {.index = 93, .length = 4},
  [42] = {.index = 97, .length = 2},
  [43] = {.index = 99, .length = 3},
  [44] = {.index = 102, .length = 3},
  [45] = {.index = 105, .length = 1},
  [46] = {.index = 106, .length = 3},
  [47] = {.index = 109, .length = 3},
  [48] = {.index = 112, .length = 2},
  [49] = {.index = 114, .length = 3},
  [50] = {.index = 117, .length = 3},
  [51] = {.index = 120, .length = 3},
  [52] = {.index = 123, .length = 3},
  [53] = {.index = 126, .length = 3},
  [54] = {.index = 129, .length = 3},
  [55] = {.index = 132, .length = 3},
  [56] = {.index = 135, .length = 3},
  [57] = {.index = 138, .length = 3},
  [58] = {.index = 141, .length = 3},
  [59] = {.index = 144, .length = 3},
  [60] = {.index = 147, .length = 3},
  [61] = {.index = 150, .length = 2},
  [62] = {.index = 152, .length = 7},
  [63] = {.index = 159, .length = 7},
  [64] = {.index = 166, .length = 7},
  [65] = {.index = 173, .length = 9},
  [66] = {.index = 182, .length = 6},
  [67] = {.index = 188, .length = 1},
  [68] = {.index = 189, .length = 4},
  [69] = {.index = 193, .length = 2},
  [70] = {.index = 195, .length = 5},
  [72] = {.index = 200, .length = 1},
  [73] = {.index = 201, .length = 1},
  [74] = {.index = 202, .length = 1},
  [75] = {.index = 203, .length = 4},
  [76] = {.index = 207, .length = 1},
  [77] = {.index = 208, .length = 4},
  [78] = {.index = 212, .length = 4},
  [79] = {.index = 216, .length = 3},
  [80] = {.index = 219, .length = 4},
  [81] = {.index = 223, .length = 4},
  [82] = {.index = 227, .length = 4},
  [83] = {.index = 231, .length = 4},
  [84] = {.index = 235, .length = 4},
  [85] = {.index = 239, .length = 4},
  [86] = {.index = 243, .length = 4},
  [87] = {.index = 247, .length = 4},
  [88] = {.index = 251, .length = 1},
  [89] = {.index = 252, .length = 4},
  [90] = {.index = 256, .length = 2},
  [91] = {.index = 258, .length = 2},
  [92] = {.index = 260, .length = 2},
  [93] = {.index = 262, .length = 2},
  [94] = {.index = 264, .length = 2},
  [95] = {.index = 266, .length = 2},
  [96] = {.index = 268, .length = 2},
  [97] = {.index = 270, .length = 1},
  [98] = {.index = 271, .length = 5},
  [99] = {.index = 276, .length = 5},
  [100] = {.index = 281, .length = 5},
  [101] = {.index = 286, .length = 5},
  [102] = {.index = 291, .length = 5},
  [103] = {.index = 296, .length = 5},
  [104] = {.index = 301, .length = 5},
  [105] = {.index = 306, .length = 5},
  [106] = {.index = 311, .length = 4},
  [107] = {.index = 315, .length = 5},
  [108] = {.index = 320, .length = 6},
  [109] = {.index = 326, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_begin, 0},
  [1] =
    {field_command, 0},
  [2] =
    {field_word, 0},
  [3] =
    {field_command, 0, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_toc, 0, .inherited = true},
  [6] =
    {field_command, 0, .inherited = true},
    {field_label, 0, .inherited = true},
  [8] =
    {field_begin, 0, .inherited = true},
    {field_code, 0, .inherited = true},
    {field_end, 0, .inherited = true},
  [11] =
    {field_argc, 0, .inherited = true},
    {field_command, 0, .inherited = true},
    {field_declaration, 0, .inherited = true},
    {field_default, 0, .inherited = true},
    {field_implementation, 0, .inherited = true},
  [16] =
    {field_command, 0, .inherited = true},
    {field_declaration, 0, .inherited = true},
    {field_implementation, 0, .inherited = true},
    {field_spec, 0, .inherited = true},
  [20] =
    {field_command, 0, .inherited = true},
    {field_declaration, 0, .inherited = true},
    {field_implementation, 0, .inherited = true},
  [23] =
    {field_argc, 0, .inherited = true},
    {field_begin, 0, .inherited = true},
    {field_command, 0, .inherited = true},
    {field_end, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [28] =
    {field_begin, 0, .inherited = true},
    {field_command, 0, .inherited = true},
    {field_end, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_spec, 0, .inherited = true},
  [33] =
    {field_command, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [35] =
    {field_word, 0, .inherited = true},
  [36] =
    {field_begin, 0},
    {field_comment, 1},
  [38] =
    {field_begin, 0},
    {field_end, 1},
  [40] =
    {field_command, 0},
    {field_text, 1, .inherited = true},
    {field_toc, 1, .inherited = true},
  [43] =
    {field_text, 0},
  [44] =
    {field_command, 0},
    {field_label, 1},
  [46] =
    {field_subscript, 1},
  [47] =
    {field_superscript, 1},
  [48] =
    {field_command, 0},
    {field_content, 1},
  [50] =
    {field_command, 0},
    {field_name, 1},
  [52] =
    {field_command, 0},
    {field_name, 1},
    {field_text, 1, .inherited = true},
  [55] =
    {field_arg, 0},
  [56] =
    {field_arg, 1, .inherited = true},
    {field_command, 0},
  [58] =
    {field_command, 0},
    {field_text, 1},
  [60] =
    {field_authors, 1},
    {field_command, 0},
  [62] =
    {field_command, 0},
    {field_paths, 1},
  [64] =
    {field_command, 0},
    {field_path, 1},
  [66] =
    {field_glob, 1},
  [67] =
    {field_command, 0},
    {field_long, 1},
  [69] =
    {field_command, 0},
    {field_keys, 1},
  [71] =
    {field_command, 0},
    {field_names, 1},
  [73] =
    {field_command, 0},
    {field_declaration, 1},
  [75] =
    {field_command, 0},
    {field_uri, 1},
  [77] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 1, .inherited = true},
    {field_end, 1},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [83] =
    {field_word, 0, .inherited = true},
    {field_word, 1, .inherited = true},
  [85] =
    {field_begin, 0},
    {field_comment, 1},
    {field_end, 2},
  [88] =
    {field_text, 1},
    {field_toc, 0},
  [90] =
    {field_command, 0},
    {field_name, 1},
    {field_options, 2},
  [93] =
    {field_command, 0},
    {field_language, 2},
    {field_name, 1},
    {field_text, 1, .inherited = true},
  [97] =
    {field_arg, 0, .inherited = true},
    {field_arg, 1, .inherited = true},
  [99] =
    {field_command, 0},
    {field_options, 1},
    {field_text, 2},
  [102] =
    {field_authors, 2},
    {field_command, 0},
    {field_options, 1},
  [105] =
    {field_key, 0},
  [106] =
    {field_command, 0},
    {field_options, 1},
    {field_paths, 2},
  [109] =
    {field_command, 0},
    {field_options, 1},
    {field_path, 2},
  [112] =
    {field_glob, 2},
    {field_options, 1},
  [114] =
    {field_command, 0},
    {field_directory, 1},
    {field_file, 2},
  [117] =
    {field_command, 0},
    {field_long, 2},
    {field_short, 1},
  [120] =
    {field_command, 0},
    {field_keys, 2},
    {field_prenote, 1},
  [123] =
    {field_command, 0},
    {field_from, 1},
    {field_to, 2},
  [126] =
    {field_command, 0},
    {field_name, 1},
    {field_number, 2},
  [129] =
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 2},
  [132] =
    {field_command, 0},
    {field_name, 1},
    {field_name, 2},
  [135] =
    {field_command, 0},
    {field_name, 2},
    {field_options, 1},
  [138] =
    {field_command, 0},
    {field_name, 1},
    {field_title, 2},
  [141] =
    {field_command, 0},
    {field_name, 1},
    {field_text, 2},
  [144] =
    {field_command, 0},
    {field_model, 1},
    {field_spec, 2},
  [147] =
    {field_command, 0},
    {field_label, 2},
    {field_uri, 1},
  [150] =
    {field_begin, 0},
    {field_end, 2},
  [152] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_comment, 1},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [159] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_verbatim, 1},
  [166] =
    {field_begin, 0},
    {field_code, 1},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [173] =
    {field_begin, 0},
    {field_code, 1},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_language, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_options, 0, .inherited = true},
  [182] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [188] =
    {field_text, 1},
  [189] =
    {field_left_command, 0},
    {field_left_delimiter, 1},
    {field_right_command, 2},
    {field_right_delimiter, 3},
  [193] =
    {field_text, 1},
    {field_word, 1, .inherited = true},
  [195] =
    {field_command, 0},
    {field_language, 3},
    {field_name, 1},
    {field_options, 2},
    {field_text, 1, .inherited = true},
  [200] =
    {field_pair, 1},
  [201] =
    {field_path, 1},
  [202] =
    {field_pattern, 1},
  [203] =
    {field_command, 0},
    {field_keys, 3},
    {field_postnote, 2},
    {field_prenote, 1},
  [207] =
    {field_command, 1},
  [208] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 3},
  [212] =
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 3},
    {field_spec, 2},
  [216] =
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 3},
  [219] =
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 2},
    {field_right, 3},
  [223] =
    {field_begin, 2},
    {field_command, 0},
    {field_end, 3},
    {field_name, 1},
  [227] =
    {field_command, 0},
    {field_long, 3},
    {field_name, 1},
    {field_short, 2},
  [231] =
    {field_command, 0},
    {field_counter, 3},
    {field_name, 1},
    {field_title, 2},
  [235] =
    {field_command, 0},
    {field_counter, 2},
    {field_name, 1},
    {field_title, 3},
  [239] =
    {field_command, 0},
    {field_name, 2},
    {field_options, 1},
    {field_title, 3},
  [243] =
    {field_command, 0},
    {field_model, 2},
    {field_name, 1},
    {field_spec, 3},
  [247] =
    {field_command, 0},
    {field_model, 1},
    {field_spec, 2},
    {field_text, 3},
  [251] =
    {field_uri, 1},
  [252] =
    {field_left_command, 0},
    {field_left_delimiter, 1},
    {field_right_command, 3},
    {field_right_delimiter, 4},
  [256] =
    {field_key, 0},
    {field_value, 2},
  [258] =
    {field_pair, 1},
    {field_pair, 2, .inherited = true},
  [260] =
    {field_pair, 0, .inherited = true},
    {field_pair, 1, .inherited = true},
  [262] =
    {field_path, 1},
    {field_path, 2, .inherited = true},
  [264] =
    {field_path, 0, .inherited = true},
    {field_path, 1, .inherited = true},
  [266] =
    {field_text, 1},
    {field_text, 2, .inherited = true},
  [268] =
    {field_text, 0, .inherited = true},
    {field_text, 1, .inherited = true},
  [270] =
    {field_value, 1},
  [271] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_default, 3},
    {field_implementation, 4},
  [276] =
    {field_body, 4},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 2},
    {field_right, 3},
  [281] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 3},
    {field_right, 4},
  [286] =
    {field_argc, 2},
    {field_begin, 3},
    {field_command, 0},
    {field_end, 4},
    {field_name, 1},
  [291] =
    {field_begin, 3},
    {field_command, 0},
    {field_end, 4},
    {field_name, 1},
    {field_spec, 2},
  [296] =
    {field_command, 0},
    {field_long, 4},
    {field_name, 2},
    {field_options, 1},
    {field_short, 3},
  [301] =
    {field_command, 0},
    {field_counter, 4},
    {field_name, 2},
    {field_options, 1},
    {field_title, 3},
  [306] =
    {field_command, 0},
    {field_counter, 3},
    {field_name, 2},
    {field_options, 1},
    {field_title, 4},
  [311] =
    {field_command, 0},
    {field_model, 3},
    {field_name, 2},
    {field_spec, 4},
  [315] =
    {field_command, 0},
    {field_head, 2},
    {field_model, 1},
    {field_spec, 4},
    {field_tail, 3},
  [320] =
    {field_argc, 2},
    {field_body, 5},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 3},
    {field_right, 4},
  [326] =
    {field_command, 0},
    {field_head, 3},
    {field_model, 2},
    {field_spec, 5},
    {field_tail, 4},
    {field_ty, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [71] = {
    [1] = alias_sym_author,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym_curly_group_author_list_repeat1, 2,
    aux_sym_curly_group_author_list_repeat1,
    alias_sym_author,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 6,
  [8] = 6,
  [9] = 9,
  [10] = 10,
  [11] = 9,
  [12] = 9,
  [13] = 9,
  [14] = 6,
  [15] = 9,
  [16] = 6,
  [17] = 9,
  [18] = 6,
  [19] = 9,
  [20] = 6,
  [21] = 9,
  [22] = 6,
  [23] = 6,
  [24] = 9,
  [25] = 2,
  [26] = 3,
  [27] = 4,
  [28] = 5,
  [29] = 5,
  [30] = 3,
  [31] = 4,
  [32] = 2,
  [33] = 5,
  [34] = 5,
  [35] = 2,
  [36] = 3,
  [37] = 4,
  [38] = 5,
  [39] = 2,
  [40] = 3,
  [41] = 4,
  [42] = 42,
  [43] = 42,
  [44] = 5,
  [45] = 45,
  [46] = 2,
  [47] = 42,
  [48] = 45,
  [49] = 4,
  [50] = 45,
  [51] = 42,
  [52] = 45,
  [53] = 42,
  [54] = 45,
  [55] = 42,
  [56] = 45,
  [57] = 3,
  [58] = 3,
  [59] = 4,
  [60] = 5,
  [61] = 5,
  [62] = 2,
  [63] = 45,
  [64] = 10,
  [65] = 4,
  [66] = 2,
  [67] = 3,
  [68] = 4,
  [69] = 2,
  [70] = 3,
  [71] = 42,
  [72] = 72,
  [73] = 10,
  [74] = 4,
  [75] = 75,
  [76] = 76,
  [77] = 3,
  [78] = 10,
  [79] = 5,
  [80] = 80,
  [81] = 10,
  [82] = 82,
  [83] = 83,
  [84] = 2,
  [85] = 3,
  [86] = 4,
  [87] = 5,
  [88] = 2,
  [89] = 3,
  [90] = 4,
  [91] = 5,
  [92] = 72,
  [93] = 93,
  [94] = 76,
  [95] = 93,
  [96] = 80,
  [97] = 82,
  [98] = 83,
  [99] = 93,
  [100] = 76,
  [101] = 72,
  [102] = 80,
  [103] = 82,
  [104] = 83,
  [105] = 93,
  [106] = 76,
  [107] = 72,
  [108] = 80,
  [109] = 82,
  [110] = 93,
  [111] = 76,
  [112] = 72,
  [113] = 80,
  [114] = 82,
  [115] = 83,
  [116] = 93,
  [117] = 76,
  [118] = 72,
  [119] = 80,
  [120] = 82,
  [121] = 83,
  [122] = 93,
  [123] = 76,
  [124] = 72,
  [125] = 80,
  [126] = 82,
  [127] = 83,
  [128] = 93,
  [129] = 76,
  [130] = 72,
  [131] = 80,
  [132] = 82,
  [133] = 83,
  [134] = 93,
  [135] = 76,
  [136] = 72,
  [137] = 80,
  [138] = 82,
  [139] = 83,
  [140] = 93,
  [141] = 76,
  [142] = 72,
  [143] = 80,
  [144] = 82,
  [145] = 83,
  [146] = 76,
  [147] = 72,
  [148] = 82,
  [149] = 83,
  [150] = 76,
  [151] = 72,
  [152] = 82,
  [153] = 83,
  [154] = 2,
  [155] = 83,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 156,
  [161] = 157,
  [162] = 156,
  [163] = 157,
  [164] = 156,
  [165] = 157,
  [166] = 157,
  [167] = 156,
  [168] = 168,
  [169] = 158,
  [170] = 159,
  [171] = 171,
  [172] = 158,
  [173] = 158,
  [174] = 159,
  [175] = 159,
  [176] = 159,
  [177] = 158,
  [178] = 171,
  [179] = 168,
  [180] = 180,
  [181] = 181,
  [182] = 171,
  [183] = 171,
  [184] = 171,
  [185] = 168,
  [186] = 168,
  [187] = 168,
  [188] = 181,
  [189] = 189,
  [190] = 180,
  [191] = 191,
  [192] = 180,
  [193] = 181,
  [194] = 180,
  [195] = 181,
  [196] = 181,
  [197] = 180,
  [198] = 191,
  [199] = 189,
  [200] = 189,
  [201] = 191,
  [202] = 191,
  [203] = 189,
  [204] = 189,
  [205] = 205,
  [206] = 191,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 205,
  [211] = 207,
  [212] = 205,
  [213] = 207,
  [214] = 207,
  [215] = 205,
  [216] = 205,
  [217] = 207,
  [218] = 218,
  [219] = 208,
  [220] = 220,
  [221] = 221,
  [222] = 209,
  [223] = 209,
  [224] = 209,
  [225] = 208,
  [226] = 208,
  [227] = 208,
  [228] = 209,
  [229] = 218,
  [230] = 220,
  [231] = 221,
  [232] = 221,
  [233] = 218,
  [234] = 220,
  [235] = 221,
  [236] = 218,
  [237] = 218,
  [238] = 220,
  [239] = 220,
  [240] = 221,
  [241] = 241,
  [242] = 241,
  [243] = 241,
  [244] = 244,
  [245] = 244,
  [246] = 244,
  [247] = 241,
  [248] = 244,
  [249] = 241,
  [250] = 241,
  [251] = 244,
  [252] = 241,
  [253] = 244,
  [254] = 244,
  [255] = 220,
  [256] = 256,
  [257] = 256,
  [258] = 258,
  [259] = 258,
  [260] = 260,
  [261] = 258,
  [262] = 256,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 265,
  [267] = 264,
  [268] = 265,
  [269] = 265,
  [270] = 264,
  [271] = 264,
  [272] = 264,
  [273] = 265,
  [274] = 274,
  [275] = 275,
  [276] = 274,
  [277] = 275,
  [278] = 275,
  [279] = 275,
  [280] = 274,
  [281] = 281,
  [282] = 274,
  [283] = 274,
  [284] = 275,
  [285] = 274,
  [286] = 275,
  [287] = 274,
  [288] = 274,
  [289] = 275,
  [290] = 274,
  [291] = 274,
  [292] = 275,
  [293] = 274,
  [294] = 275,
  [295] = 275,
  [296] = 275,
  [297] = 297,
  [298] = 298,
  [299] = 298,
  [300] = 297,
  [301] = 301,
  [302] = 301,
  [303] = 303,
  [304] = 301,
  [305] = 301,
  [306] = 301,
  [307] = 301,
  [308] = 301,
  [309] = 301,
  [310] = 301,
  [311] = 301,
  [312] = 303,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 318,
  [320] = 318,
  [321] = 318,
  [322] = 318,
  [323] = 318,
  [324] = 318,
  [325] = 318,
  [326] = 318,
  [327] = 318,
  [328] = 328,
  [329] = 265,
  [330] = 264,
  [331] = 265,
  [332] = 265,
  [333] = 264,
  [334] = 264,
  [335] = 265,
  [336] = 264,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 338,
  [341] = 337,
  [342] = 342,
  [343] = 338,
  [344] = 337,
  [345] = 338,
  [346] = 337,
  [347] = 338,
  [348] = 337,
  [349] = 349,
  [350] = 339,
  [351] = 342,
  [352] = 352,
  [353] = 339,
  [354] = 342,
  [355] = 339,
  [356] = 342,
  [357] = 342,
  [358] = 339,
  [359] = 264,
  [360] = 265,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 349,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 352,
  [377] = 366,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 366,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 366,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 366,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 366,
  [412] = 366,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 366,
  [420] = 366,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 366,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 445,
  [447] = 352,
  [448] = 445,
  [449] = 349,
  [450] = 450,
  [451] = 451,
  [452] = 352,
  [453] = 445,
  [454] = 454,
  [455] = 455,
  [456] = 445,
  [457] = 457,
  [458] = 352,
  [459] = 445,
  [460] = 445,
  [461] = 455,
  [462] = 349,
  [463] = 349,
  [464] = 445,
  [465] = 445,
  [466] = 466,
  [467] = 467,
  [468] = 445,
  [469] = 469,
  [470] = 469,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 469,
  [475] = 475,
  [476] = 472,
  [477] = 477,
  [478] = 469,
  [479] = 479,
  [480] = 472,
  [481] = 469,
  [482] = 469,
  [483] = 483,
  [484] = 472,
  [485] = 472,
  [486] = 472,
  [487] = 469,
  [488] = 488,
  [489] = 472,
  [490] = 490,
  [491] = 469,
  [492] = 492,
  [493] = 472,
  [494] = 494,
  [495] = 469,
  [496] = 472,
  [497] = 469,
  [498] = 472,
  [499] = 472,
  [500] = 425,
  [501] = 378,
  [502] = 379,
  [503] = 380,
  [504] = 381,
  [505] = 384,
  [506] = 385,
  [507] = 386,
  [508] = 398,
  [509] = 444,
  [510] = 388,
  [511] = 389,
  [512] = 369,
  [513] = 392,
  [514] = 393,
  [515] = 370,
  [516] = 371,
  [517] = 396,
  [518] = 397,
  [519] = 372,
  [520] = 399,
  [521] = 373,
  [522] = 374,
  [523] = 375,
  [524] = 400,
  [525] = 403,
  [526] = 404,
  [527] = 405,
  [528] = 406,
  [529] = 407,
  [530] = 408,
  [531] = 409,
  [532] = 410,
  [533] = 401,
  [534] = 413,
  [535] = 414,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 415,
  [546] = 416,
  [547] = 417,
  [548] = 418,
  [549] = 421,
  [550] = 422,
  [551] = 423,
  [552] = 424,
  [553] = 426,
  [554] = 427,
  [555] = 428,
  [556] = 429,
  [557] = 430,
  [558] = 390,
  [559] = 431,
  [560] = 432,
  [561] = 561,
  [562] = 433,
  [563] = 435,
  [564] = 361,
  [565] = 436,
  [566] = 437,
  [567] = 438,
  [568] = 387,
  [569] = 569,
  [570] = 394,
  [571] = 395,
  [572] = 572,
  [573] = 573,
  [574] = 439,
  [575] = 440,
  [576] = 441,
  [577] = 442,
  [578] = 443,
  [579] = 362,
  [580] = 363,
  [581] = 364,
  [582] = 365,
  [583] = 367,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 466,
  [731] = 437,
  [732] = 440,
  [733] = 441,
  [734] = 403,
  [735] = 404,
  [736] = 405,
  [737] = 406,
  [738] = 407,
  [739] = 408,
  [740] = 409,
  [741] = 410,
  [742] = 442,
  [743] = 443,
  [744] = 413,
  [745] = 414,
  [746] = 415,
  [747] = 416,
  [748] = 362,
  [749] = 417,
  [750] = 418,
  [751] = 421,
  [752] = 422,
  [753] = 423,
  [754] = 424,
  [755] = 425,
  [756] = 363,
  [757] = 426,
  [758] = 427,
  [759] = 428,
  [760] = 429,
  [761] = 430,
  [762] = 431,
  [763] = 432,
  [764] = 433,
  [765] = 435,
  [766] = 361,
  [767] = 436,
  [768] = 437,
  [769] = 438,
  [770] = 439,
  [771] = 440,
  [772] = 441,
  [773] = 442,
  [774] = 443,
  [775] = 362,
  [776] = 363,
  [777] = 364,
  [778] = 365,
  [779] = 367,
  [780] = 387,
  [781] = 390,
  [782] = 394,
  [783] = 395,
  [784] = 398,
  [785] = 400,
  [786] = 401,
  [787] = 444,
  [788] = 369,
  [789] = 370,
  [790] = 371,
  [791] = 372,
  [792] = 373,
  [793] = 374,
  [794] = 375,
  [795] = 444,
  [796] = 369,
  [797] = 370,
  [798] = 371,
  [799] = 372,
  [800] = 373,
  [801] = 374,
  [802] = 375,
  [803] = 364,
  [804] = 378,
  [805] = 379,
  [806] = 380,
  [807] = 381,
  [808] = 384,
  [809] = 385,
  [810] = 386,
  [811] = 388,
  [812] = 389,
  [813] = 392,
  [814] = 393,
  [815] = 396,
  [816] = 397,
  [817] = 399,
  [818] = 450,
  [819] = 403,
  [820] = 404,
  [821] = 405,
  [822] = 406,
  [823] = 407,
  [824] = 408,
  [825] = 409,
  [826] = 410,
  [827] = 413,
  [828] = 414,
  [829] = 415,
  [830] = 416,
  [831] = 417,
  [832] = 418,
  [833] = 421,
  [834] = 422,
  [835] = 423,
  [836] = 424,
  [837] = 425,
  [838] = 426,
  [839] = 427,
  [840] = 428,
  [841] = 429,
  [842] = 430,
  [843] = 431,
  [844] = 432,
  [845] = 433,
  [846] = 435,
  [847] = 361,
  [848] = 436,
  [849] = 437,
  [850] = 439,
  [851] = 439,
  [852] = 440,
  [853] = 441,
  [854] = 442,
  [855] = 443,
  [856] = 362,
  [857] = 363,
  [858] = 364,
  [859] = 365,
  [860] = 367,
  [861] = 454,
  [862] = 365,
  [863] = 367,
  [864] = 378,
  [865] = 379,
  [866] = 380,
  [867] = 381,
  [868] = 387,
  [869] = 390,
  [870] = 384,
  [871] = 385,
  [872] = 386,
  [873] = 394,
  [874] = 395,
  [875] = 388,
  [876] = 389,
  [877] = 398,
  [878] = 451,
  [879] = 392,
  [880] = 393,
  [881] = 400,
  [882] = 396,
  [883] = 397,
  [884] = 401,
  [885] = 399,
  [886] = 387,
  [887] = 390,
  [888] = 394,
  [889] = 395,
  [890] = 398,
  [891] = 400,
  [892] = 401,
  [893] = 438,
  [894] = 457,
  [895] = 444,
  [896] = 369,
  [897] = 370,
  [898] = 371,
  [899] = 372,
  [900] = 373,
  [901] = 374,
  [902] = 375,
  [903] = 378,
  [904] = 379,
  [905] = 380,
  [906] = 381,
  [907] = 384,
  [908] = 385,
  [909] = 386,
  [910] = 388,
  [911] = 389,
  [912] = 392,
  [913] = 393,
  [914] = 396,
  [915] = 397,
  [916] = 399,
  [917] = 403,
  [918] = 404,
  [919] = 405,
  [920] = 406,
  [921] = 407,
  [922] = 408,
  [923] = 409,
  [924] = 410,
  [925] = 467,
  [926] = 413,
  [927] = 414,
  [928] = 415,
  [929] = 416,
  [930] = 417,
  [931] = 418,
  [932] = 421,
  [933] = 422,
  [934] = 423,
  [935] = 424,
  [936] = 425,
  [937] = 426,
  [938] = 427,
  [939] = 428,
  [940] = 429,
  [941] = 430,
  [942] = 431,
  [943] = 432,
  [944] = 433,
  [945] = 435,
  [946] = 361,
  [947] = 436,
  [948] = 438,
  [949] = 457,
  [950] = 454,
  [951] = 451,
  [952] = 457,
  [953] = 471,
  [954] = 450,
  [955] = 494,
  [956] = 477,
  [957] = 454,
  [958] = 473,
  [959] = 479,
  [960] = 457,
  [961] = 488,
  [962] = 454,
  [963] = 492,
  [964] = 466,
  [965] = 466,
  [966] = 467,
  [967] = 451,
  [968] = 467,
  [969] = 475,
  [970] = 483,
  [971] = 451,
  [972] = 466,
  [973] = 467,
  [974] = 450,
  [975] = 450,
  [976] = 600,
  [977] = 661,
  [978] = 726,
  [979] = 473,
  [980] = 683,
  [981] = 488,
  [982] = 684,
  [983] = 685,
  [984] = 686,
  [985] = 662,
  [986] = 663,
  [987] = 664,
  [988] = 561,
  [989] = 665,
  [990] = 475,
  [991] = 479,
  [992] = 624,
  [993] = 483,
  [994] = 483,
  [995] = 666,
  [996] = 667,
  [997] = 668,
  [998] = 669,
  [999] = 670,
  [1000] = 671,
  [1001] = 672,
  [1002] = 673,
  [1003] = 674,
  [1004] = 541,
  [1005] = 675,
  [1006] = 676,
  [1007] = 542,
  [1008] = 677,
  [1009] = 543,
  [1010] = 678,
  [1011] = 679,
  [1012] = 680,
  [1013] = 681,
  [1014] = 682,
  [1015] = 590,
  [1016] = 544,
  [1017] = 586,
  [1018] = 473,
  [1019] = 488,
  [1020] = 572,
  [1021] = 687,
  [1022] = 688,
  [1023] = 595,
  [1024] = 596,
  [1025] = 597,
  [1026] = 598,
  [1027] = 599,
  [1028] = 689,
  [1029] = 601,
  [1030] = 602,
  [1031] = 603,
  [1032] = 604,
  [1033] = 690,
  [1034] = 605,
  [1035] = 606,
  [1036] = 607,
  [1037] = 608,
  [1038] = 609,
  [1039] = 634,
  [1040] = 573,
  [1041] = 610,
  [1042] = 611,
  [1043] = 693,
  [1044] = 635,
  [1045] = 625,
  [1046] = 587,
  [1047] = 626,
  [1048] = 694,
  [1049] = 695,
  [1050] = 696,
  [1051] = 691,
  [1052] = 697,
  [1053] = 698,
  [1054] = 699,
  [1055] = 588,
  [1056] = 700,
  [1057] = 701,
  [1058] = 692,
  [1059] = 591,
  [1060] = 612,
  [1061] = 702,
  [1062] = 703,
  [1063] = 704,
  [1064] = 705,
  [1065] = 706,
  [1066] = 477,
  [1067] = 707,
  [1068] = 708,
  [1069] = 709,
  [1070] = 631,
  [1071] = 632,
  [1072] = 727,
  [1073] = 613,
  [1074] = 614,
  [1075] = 615,
  [1076] = 660,
  [1077] = 617,
  [1078] = 618,
  [1079] = 619,
  [1080] = 620,
  [1081] = 475,
  [1082] = 621,
  [1083] = 622,
  [1084] = 623,
  [1085] = 729,
  [1086] = 584,
  [1087] = 479,
  [1088] = 728,
  [1089] = 475,
  [1090] = 710,
  [1091] = 589,
  [1092] = 711,
  [1093] = 712,
  [1094] = 713,
  [1095] = 585,
  [1096] = 1096,
  [1097] = 483,
  [1098] = 714,
  [1099] = 715,
  [1100] = 471,
  [1101] = 477,
  [1102] = 716,
  [1103] = 717,
  [1104] = 479,
  [1105] = 718,
  [1106] = 633,
  [1107] = 471,
  [1108] = 719,
  [1109] = 720,
  [1110] = 721,
  [1111] = 722,
  [1112] = 723,
  [1113] = 724,
  [1114] = 725,
  [1115] = 657,
  [1116] = 477,
  [1117] = 636,
  [1118] = 637,
  [1119] = 638,
  [1120] = 627,
  [1121] = 639,
  [1122] = 640,
  [1123] = 641,
  [1124] = 471,
  [1125] = 642,
  [1126] = 643,
  [1127] = 494,
  [1128] = 492,
  [1129] = 644,
  [1130] = 645,
  [1131] = 646,
  [1132] = 647,
  [1133] = 648,
  [1134] = 494,
  [1135] = 649,
  [1136] = 492,
  [1137] = 536,
  [1138] = 628,
  [1139] = 650,
  [1140] = 629,
  [1141] = 651,
  [1142] = 652,
  [1143] = 653,
  [1144] = 569,
  [1145] = 592,
  [1146] = 537,
  [1147] = 593,
  [1148] = 654,
  [1149] = 655,
  [1150] = 473,
  [1151] = 538,
  [1152] = 488,
  [1153] = 594,
  [1154] = 539,
  [1155] = 656,
  [1156] = 658,
  [1157] = 659,
  [1158] = 494,
  [1159] = 492,
  [1160] = 630,
  [1161] = 540,
  [1162] = 616,
  [1163] = 603,
  [1164] = 613,
  [1165] = 614,
  [1166] = 594,
  [1167] = 721,
  [1168] = 658,
  [1169] = 659,
  [1170] = 660,
  [1171] = 661,
  [1172] = 662,
  [1173] = 663,
  [1174] = 664,
  [1175] = 665,
  [1176] = 666,
  [1177] = 667,
  [1178] = 668,
  [1179] = 669,
  [1180] = 670,
  [1181] = 671,
  [1182] = 672,
  [1183] = 615,
  [1184] = 673,
  [1185] = 674,
  [1186] = 675,
  [1187] = 616,
  [1188] = 676,
  [1189] = 677,
  [1190] = 678,
  [1191] = 679,
  [1192] = 680,
  [1193] = 663,
  [1194] = 722,
  [1195] = 681,
  [1196] = 617,
  [1197] = 682,
  [1198] = 723,
  [1199] = 724,
  [1200] = 618,
  [1201] = 725,
  [1202] = 619,
  [1203] = 664,
  [1204] = 665,
  [1205] = 561,
  [1206] = 620,
  [1207] = 621,
  [1208] = 622,
  [1209] = 666,
  [1210] = 623,
  [1211] = 729,
  [1212] = 710,
  [1213] = 711,
  [1214] = 590,
  [1215] = 572,
  [1216] = 591,
  [1217] = 712,
  [1218] = 713,
  [1219] = 595,
  [1220] = 596,
  [1221] = 597,
  [1222] = 598,
  [1223] = 726,
  [1224] = 599,
  [1225] = 600,
  [1226] = 601,
  [1227] = 602,
  [1228] = 603,
  [1229] = 604,
  [1230] = 605,
  [1231] = 606,
  [1232] = 607,
  [1233] = 608,
  [1234] = 609,
  [1235] = 573,
  [1236] = 610,
  [1237] = 726,
  [1238] = 683,
  [1239] = 684,
  [1240] = 685,
  [1241] = 611,
  [1242] = 686,
  [1243] = 687,
  [1244] = 688,
  [1245] = 693,
  [1246] = 683,
  [1247] = 684,
  [1248] = 685,
  [1249] = 686,
  [1250] = 687,
  [1251] = 688,
  [1252] = 689,
  [1253] = 690,
  [1254] = 691,
  [1255] = 692,
  [1256] = 612,
  [1257] = 727,
  [1258] = 728,
  [1259] = 689,
  [1260] = 690,
  [1261] = 691,
  [1262] = 692,
  [1263] = 612,
  [1264] = 693,
  [1265] = 694,
  [1266] = 625,
  [1267] = 626,
  [1268] = 694,
  [1269] = 624,
  [1270] = 695,
  [1271] = 696,
  [1272] = 697,
  [1273] = 698,
  [1274] = 695,
  [1275] = 696,
  [1276] = 697,
  [1277] = 699,
  [1278] = 584,
  [1279] = 698,
  [1280] = 572,
  [1281] = 727,
  [1282] = 585,
  [1283] = 699,
  [1284] = 627,
  [1285] = 628,
  [1286] = 595,
  [1287] = 596,
  [1288] = 700,
  [1289] = 597,
  [1290] = 701,
  [1291] = 598,
  [1292] = 728,
  [1293] = 599,
  [1294] = 600,
  [1295] = 601,
  [1296] = 602,
  [1297] = 608,
  [1298] = 604,
  [1299] = 605,
  [1300] = 606,
  [1301] = 607,
  [1302] = 608,
  [1303] = 609,
  [1304] = 573,
  [1305] = 610,
  [1306] = 726,
  [1307] = 683,
  [1308] = 684,
  [1309] = 685,
  [1310] = 611,
  [1311] = 686,
  [1312] = 687,
  [1313] = 688,
  [1314] = 689,
  [1315] = 690,
  [1316] = 691,
  [1317] = 692,
  [1318] = 612,
  [1319] = 693,
  [1320] = 694,
  [1321] = 695,
  [1322] = 696,
  [1323] = 697,
  [1324] = 667,
  [1325] = 698,
  [1326] = 727,
  [1327] = 702,
  [1328] = 699,
  [1329] = 700,
  [1330] = 701,
  [1331] = 728,
  [1332] = 703,
  [1333] = 702,
  [1334] = 704,
  [1335] = 705,
  [1336] = 703,
  [1337] = 704,
  [1338] = 705,
  [1339] = 706,
  [1340] = 668,
  [1341] = 706,
  [1342] = 707,
  [1343] = 708,
  [1344] = 707,
  [1345] = 708,
  [1346] = 709,
  [1347] = 629,
  [1348] = 630,
  [1349] = 631,
  [1350] = 632,
  [1351] = 700,
  [1352] = 701,
  [1353] = 709,
  [1354] = 669,
  [1355] = 702,
  [1356] = 703,
  [1357] = 613,
  [1358] = 614,
  [1359] = 615,
  [1360] = 616,
  [1361] = 617,
  [1362] = 714,
  [1363] = 670,
  [1364] = 618,
  [1365] = 715,
  [1366] = 716,
  [1367] = 619,
  [1368] = 717,
  [1369] = 718,
  [1370] = 719,
  [1371] = 620,
  [1372] = 621,
  [1373] = 622,
  [1374] = 623,
  [1375] = 729,
  [1376] = 593,
  [1377] = 711,
  [1378] = 712,
  [1379] = 713,
  [1380] = 624,
  [1381] = 714,
  [1382] = 657,
  [1383] = 715,
  [1384] = 716,
  [1385] = 717,
  [1386] = 718,
  [1387] = 719,
  [1388] = 720,
  [1389] = 721,
  [1390] = 722,
  [1391] = 723,
  [1392] = 724,
  [1393] = 725,
  [1394] = 569,
  [1395] = 704,
  [1396] = 705,
  [1397] = 613,
  [1398] = 706,
  [1399] = 614,
  [1400] = 633,
  [1401] = 536,
  [1402] = 537,
  [1403] = 538,
  [1404] = 615,
  [1405] = 625,
  [1406] = 626,
  [1407] = 539,
  [1408] = 540,
  [1409] = 541,
  [1410] = 542,
  [1411] = 543,
  [1412] = 544,
  [1413] = 586,
  [1414] = 634,
  [1415] = 635,
  [1416] = 584,
  [1417] = 585,
  [1418] = 616,
  [1419] = 627,
  [1420] = 628,
  [1421] = 629,
  [1422] = 630,
  [1423] = 631,
  [1424] = 617,
  [1425] = 632,
  [1426] = 618,
  [1427] = 587,
  [1428] = 707,
  [1429] = 588,
  [1430] = 589,
  [1431] = 636,
  [1432] = 708,
  [1433] = 619,
  [1434] = 637,
  [1435] = 620,
  [1436] = 621,
  [1437] = 633,
  [1438] = 536,
  [1439] = 537,
  [1440] = 538,
  [1441] = 539,
  [1442] = 540,
  [1443] = 541,
  [1444] = 542,
  [1445] = 622,
  [1446] = 623,
  [1447] = 729,
  [1448] = 710,
  [1449] = 711,
  [1450] = 543,
  [1451] = 544,
  [1452] = 586,
  [1453] = 634,
  [1454] = 712,
  [1455] = 713,
  [1456] = 635,
  [1457] = 624,
  [1458] = 587,
  [1459] = 638,
  [1460] = 588,
  [1461] = 589,
  [1462] = 636,
  [1463] = 639,
  [1464] = 714,
  [1465] = 625,
  [1466] = 626,
  [1467] = 637,
  [1468] = 671,
  [1469] = 638,
  [1470] = 715,
  [1471] = 639,
  [1472] = 716,
  [1473] = 717,
  [1474] = 718,
  [1475] = 719,
  [1476] = 584,
  [1477] = 585,
  [1478] = 627,
  [1479] = 628,
  [1480] = 629,
  [1481] = 630,
  [1482] = 631,
  [1483] = 632,
  [1484] = 640,
  [1485] = 641,
  [1486] = 642,
  [1487] = 643,
  [1488] = 644,
  [1489] = 645,
  [1490] = 646,
  [1491] = 647,
  [1492] = 720,
  [1493] = 721,
  [1494] = 633,
  [1495] = 536,
  [1496] = 537,
  [1497] = 538,
  [1498] = 539,
  [1499] = 540,
  [1500] = 541,
  [1501] = 542,
  [1502] = 543,
  [1503] = 544,
  [1504] = 586,
  [1505] = 634,
  [1506] = 635,
  [1507] = 722,
  [1508] = 587,
  [1509] = 723,
  [1510] = 588,
  [1511] = 589,
  [1512] = 636,
  [1513] = 648,
  [1514] = 637,
  [1515] = 638,
  [1516] = 639,
  [1517] = 640,
  [1518] = 641,
  [1519] = 642,
  [1520] = 643,
  [1521] = 644,
  [1522] = 645,
  [1523] = 646,
  [1524] = 647,
  [1525] = 648,
  [1526] = 649,
  [1527] = 650,
  [1528] = 651,
  [1529] = 652,
  [1530] = 653,
  [1531] = 654,
  [1532] = 655,
  [1533] = 649,
  [1534] = 724,
  [1535] = 656,
  [1536] = 725,
  [1537] = 650,
  [1538] = 651,
  [1539] = 652,
  [1540] = 653,
  [1541] = 672,
  [1542] = 673,
  [1543] = 654,
  [1544] = 655,
  [1545] = 640,
  [1546] = 674,
  [1547] = 675,
  [1548] = 676,
  [1549] = 656,
  [1550] = 677,
  [1551] = 678,
  [1552] = 679,
  [1553] = 561,
  [1554] = 641,
  [1555] = 642,
  [1556] = 643,
  [1557] = 680,
  [1558] = 594,
  [1559] = 590,
  [1560] = 591,
  [1561] = 593,
  [1562] = 644,
  [1563] = 681,
  [1564] = 658,
  [1565] = 645,
  [1566] = 646,
  [1567] = 647,
  [1568] = 682,
  [1569] = 659,
  [1570] = 660,
  [1571] = 657,
  [1572] = 1572,
  [1573] = 569,
  [1574] = 592,
  [1575] = 593,
  [1576] = 648,
  [1577] = 594,
  [1578] = 649,
  [1579] = 658,
  [1580] = 659,
  [1581] = 660,
  [1582] = 661,
  [1583] = 662,
  [1584] = 663,
  [1585] = 664,
  [1586] = 665,
  [1587] = 666,
  [1588] = 667,
  [1589] = 668,
  [1590] = 669,
  [1591] = 670,
  [1592] = 671,
  [1593] = 672,
  [1594] = 673,
  [1595] = 674,
  [1596] = 675,
  [1597] = 676,
  [1598] = 677,
  [1599] = 678,
  [1600] = 679,
  [1601] = 680,
  [1602] = 681,
  [1603] = 682,
  [1604] = 650,
  [1605] = 651,
  [1606] = 561,
  [1607] = 652,
  [1608] = 653,
  [1609] = 1609,
  [1610] = 654,
  [1611] = 655,
  [1612] = 590,
  [1613] = 591,
  [1614] = 611,
  [1615] = 709,
  [1616] = 661,
  [1617] = 656,
  [1618] = 592,
  [1619] = 720,
  [1620] = 609,
  [1621] = 1621,
  [1622] = 573,
  [1623] = 610,
  [1624] = 662,
  [1625] = 572,
  [1626] = 657,
  [1627] = 569,
  [1628] = 592,
  [1629] = 595,
  [1630] = 596,
  [1631] = 597,
  [1632] = 598,
  [1633] = 599,
  [1634] = 600,
  [1635] = 601,
  [1636] = 602,
  [1637] = 603,
  [1638] = 604,
  [1639] = 605,
  [1640] = 606,
  [1641] = 607,
  [1642] = 710,
  [1643] = 450,
  [1644] = 467,
  [1645] = 457,
  [1646] = 451,
  [1647] = 454,
  [1648] = 466,
  [1649] = 494,
  [1650] = 454,
  [1651] = 492,
  [1652] = 471,
  [1653] = 479,
  [1654] = 483,
  [1655] = 475,
  [1656] = 451,
  [1657] = 457,
  [1658] = 467,
  [1659] = 450,
  [1660] = 473,
  [1661] = 466,
  [1662] = 488,
  [1663] = 454,
  [1664] = 451,
  [1665] = 457,
  [1666] = 466,
  [1667] = 467,
  [1668] = 450,
  [1669] = 719,
  [1670] = 652,
  [1671] = 610,
  [1672] = 586,
  [1673] = 634,
  [1674] = 635,
  [1675] = 611,
  [1676] = 657,
  [1677] = 633,
  [1678] = 592,
  [1679] = 587,
  [1680] = 593,
  [1681] = 590,
  [1682] = 594,
  [1683] = 591,
  [1684] = 693,
  [1685] = 694,
  [1686] = 695,
  [1687] = 696,
  [1688] = 697,
  [1689] = 698,
  [1690] = 658,
  [1691] = 699,
  [1692] = 700,
  [1693] = 701,
  [1694] = 659,
  [1695] = 653,
  [1696] = 702,
  [1697] = 703,
  [1698] = 704,
  [1699] = 705,
  [1700] = 706,
  [1701] = 654,
  [1702] = 707,
  [1703] = 708,
  [1704] = 709,
  [1705] = 660,
  [1706] = 661,
  [1707] = 662,
  [1708] = 663,
  [1709] = 664,
  [1710] = 665,
  [1711] = 666,
  [1712] = 667,
  [1713] = 668,
  [1714] = 669,
  [1715] = 655,
  [1716] = 613,
  [1717] = 614,
  [1718] = 615,
  [1719] = 616,
  [1720] = 617,
  [1721] = 618,
  [1722] = 619,
  [1723] = 620,
  [1724] = 621,
  [1725] = 622,
  [1726] = 623,
  [1727] = 729,
  [1728] = 710,
  [1729] = 711,
  [1730] = 712,
  [1731] = 713,
  [1732] = 625,
  [1733] = 670,
  [1734] = 626,
  [1735] = 714,
  [1736] = 650,
  [1737] = 651,
  [1738] = 715,
  [1739] = 716,
  [1740] = 717,
  [1741] = 718,
  [1742] = 648,
  [1743] = 720,
  [1744] = 721,
  [1745] = 722,
  [1746] = 723,
  [1747] = 724,
  [1748] = 725,
  [1749] = 656,
  [1750] = 595,
  [1751] = 671,
  [1752] = 471,
  [1753] = 672,
  [1754] = 673,
  [1755] = 596,
  [1756] = 597,
  [1757] = 649,
  [1758] = 494,
  [1759] = 492,
  [1760] = 674,
  [1761] = 675,
  [1762] = 676,
  [1763] = 598,
  [1764] = 473,
  [1765] = 599,
  [1766] = 488,
  [1767] = 677,
  [1768] = 573,
  [1769] = 726,
  [1770] = 683,
  [1771] = 684,
  [1772] = 685,
  [1773] = 686,
  [1774] = 687,
  [1775] = 688,
  [1776] = 689,
  [1777] = 690,
  [1778] = 691,
  [1779] = 692,
  [1780] = 727,
  [1781] = 728,
  [1782] = 475,
  [1783] = 479,
  [1784] = 624,
  [1785] = 585,
  [1786] = 627,
  [1787] = 483,
  [1788] = 628,
  [1789] = 678,
  [1790] = 679,
  [1791] = 680,
  [1792] = 629,
  [1793] = 600,
  [1794] = 630,
  [1795] = 601,
  [1796] = 681,
  [1797] = 602,
  [1798] = 682,
  [1799] = 631,
  [1800] = 588,
  [1801] = 632,
  [1802] = 1802,
  [1803] = 589,
  [1804] = 636,
  [1805] = 603,
  [1806] = 637,
  [1807] = 638,
  [1808] = 604,
  [1809] = 605,
  [1810] = 639,
  [1811] = 471,
  [1812] = 640,
  [1813] = 612,
  [1814] = 606,
  [1815] = 607,
  [1816] = 494,
  [1817] = 492,
  [1818] = 641,
  [1819] = 642,
  [1820] = 643,
  [1821] = 608,
  [1822] = 473,
  [1823] = 609,
  [1824] = 488,
  [1825] = 475,
  [1826] = 479,
  [1827] = 483,
  [1828] = 644,
  [1829] = 645,
  [1830] = 646,
  [1831] = 647,
  [1832] = 584,
  [1833] = 1572,
  [1834] = 652,
  [1835] = 653,
  [1836] = 654,
  [1837] = 651,
  [1838] = 656,
  [1839] = 590,
  [1840] = 591,
  [1841] = 657,
  [1842] = 592,
  [1843] = 593,
  [1844] = 594,
  [1845] = 658,
  [1846] = 659,
  [1847] = 660,
  [1848] = 661,
  [1849] = 662,
  [1850] = 663,
  [1851] = 664,
  [1852] = 665,
  [1853] = 666,
  [1854] = 667,
  [1855] = 668,
  [1856] = 669,
  [1857] = 670,
  [1858] = 671,
  [1859] = 672,
  [1860] = 673,
  [1861] = 674,
  [1862] = 675,
  [1863] = 676,
  [1864] = 677,
  [1865] = 678,
  [1866] = 679,
  [1867] = 680,
  [1868] = 681,
  [1869] = 682,
  [1870] = 595,
  [1871] = 596,
  [1872] = 597,
  [1873] = 598,
  [1874] = 599,
  [1875] = 600,
  [1876] = 601,
  [1877] = 602,
  [1878] = 603,
  [1879] = 604,
  [1880] = 605,
  [1881] = 606,
  [1882] = 607,
  [1883] = 608,
  [1884] = 609,
  [1885] = 610,
  [1886] = 611,
  [1887] = 612,
  [1888] = 693,
  [1889] = 694,
  [1890] = 695,
  [1891] = 696,
  [1892] = 697,
  [1893] = 698,
  [1894] = 699,
  [1895] = 700,
  [1896] = 701,
  [1897] = 702,
  [1898] = 703,
  [1899] = 704,
  [1900] = 705,
  [1901] = 706,
  [1902] = 707,
  [1903] = 708,
  [1904] = 709,
  [1905] = 613,
  [1906] = 587,
  [1907] = 614,
  [1908] = 588,
  [1909] = 589,
  [1910] = 467,
  [1911] = 615,
  [1912] = 616,
  [1913] = 593,
  [1914] = 617,
  [1915] = 594,
  [1916] = 454,
  [1917] = 610,
  [1918] = 618,
  [1919] = 619,
  [1920] = 620,
  [1921] = 729,
  [1922] = 621,
  [1923] = 622,
  [1924] = 625,
  [1925] = 626,
  [1926] = 623,
  [1927] = 627,
  [1928] = 628,
  [1929] = 629,
  [1930] = 630,
  [1931] = 631,
  [1932] = 632,
  [1933] = 729,
  [1934] = 710,
  [1935] = 633,
  [1936] = 586,
  [1937] = 634,
  [1938] = 635,
  [1939] = 711,
  [1940] = 712,
  [1941] = 636,
  [1942] = 713,
  [1943] = 637,
  [1944] = 638,
  [1945] = 639,
  [1946] = 640,
  [1947] = 641,
  [1948] = 642,
  [1949] = 643,
  [1950] = 644,
  [1951] = 645,
  [1952] = 646,
  [1953] = 647,
  [1954] = 648,
  [1955] = 649,
  [1956] = 650,
  [1957] = 651,
  [1958] = 652,
  [1959] = 653,
  [1960] = 654,
  [1961] = 655,
  [1962] = 714,
  [1963] = 656,
  [1964] = 715,
  [1965] = 657,
  [1966] = 592,
  [1967] = 716,
  [1968] = 717,
  [1969] = 718,
  [1970] = 658,
  [1971] = 659,
  [1972] = 660,
  [1973] = 661,
  [1974] = 662,
  [1975] = 663,
  [1976] = 664,
  [1977] = 665,
  [1978] = 666,
  [1979] = 667,
  [1980] = 668,
  [1981] = 669,
  [1982] = 670,
  [1983] = 671,
  [1984] = 672,
  [1985] = 673,
  [1986] = 674,
  [1987] = 675,
  [1988] = 676,
  [1989] = 677,
  [1990] = 678,
  [1991] = 679,
  [1992] = 680,
  [1993] = 719,
  [1994] = 720,
  [1995] = 681,
  [1996] = 721,
  [1997] = 682,
  [1998] = 573,
  [1999] = 693,
  [2000] = 694,
  [2001] = 695,
  [2002] = 696,
  [2003] = 697,
  [2004] = 698,
  [2005] = 699,
  [2006] = 700,
  [2007] = 701,
  [2008] = 722,
  [2009] = 702,
  [2010] = 703,
  [2011] = 704,
  [2012] = 705,
  [2013] = 706,
  [2014] = 723,
  [2015] = 707,
  [2016] = 708,
  [2017] = 709,
  [2018] = 710,
  [2019] = 711,
  [2020] = 712,
  [2021] = 713,
  [2022] = 714,
  [2023] = 724,
  [2024] = 715,
  [2025] = 716,
  [2026] = 717,
  [2027] = 718,
  [2028] = 719,
  [2029] = 720,
  [2030] = 721,
  [2031] = 722,
  [2032] = 723,
  [2033] = 724,
  [2034] = 725,
  [2035] = 725,
  [2036] = 726,
  [2037] = 727,
  [2038] = 728,
  [2039] = 624,
  [2040] = 1621,
  [2041] = 573,
  [2042] = 625,
  [2043] = 726,
  [2044] = 683,
  [2045] = 684,
  [2046] = 685,
  [2047] = 626,
  [2048] = 686,
  [2049] = 687,
  [2050] = 688,
  [2051] = 689,
  [2052] = 690,
  [2053] = 691,
  [2054] = 692,
  [2055] = 727,
  [2056] = 728,
  [2057] = 584,
  [2058] = 585,
  [2059] = 627,
  [2060] = 628,
  [2061] = 629,
  [2062] = 630,
  [2063] = 631,
  [2064] = 632,
  [2065] = 633,
  [2066] = 586,
  [2067] = 624,
  [2068] = 634,
  [2069] = 635,
  [2070] = 650,
  [2071] = 587,
  [2072] = 588,
  [2073] = 589,
  [2074] = 636,
  [2075] = 637,
  [2076] = 638,
  [2077] = 639,
  [2078] = 640,
  [2079] = 641,
  [2080] = 642,
  [2081] = 643,
  [2082] = 644,
  [2083] = 645,
  [2084] = 646,
  [2085] = 647,
  [2086] = 648,
  [2087] = 649,
  [2088] = 655,
  [2089] = 473,
  [2090] = 450,
  [2091] = 451,
  [2092] = 479,
  [2093] = 1572,
  [2094] = 457,
  [2095] = 1621,
  [2096] = 466,
  [2097] = 670,
  [2098] = 488,
  [2099] = 494,
  [2100] = 697,
  [2101] = 592,
  [2102] = 475,
  [2103] = 483,
  [2104] = 471,
  [2105] = 712,
  [2106] = 492,
  [2107] = 586,
  [2108] = 626,
  [2109] = 676,
  [2110] = 677,
  [2111] = 678,
  [2112] = 679,
  [2113] = 680,
  [2114] = 659,
  [2115] = 593,
  [2116] = 726,
  [2117] = 681,
  [2118] = 660,
  [2119] = 682,
  [2120] = 573,
  [2121] = 661,
  [2122] = 594,
  [2123] = 727,
  [2124] = 693,
  [2125] = 694,
  [2126] = 695,
  [2127] = 728,
  [2128] = 696,
  [2129] = 662,
  [2130] = 698,
  [2131] = 729,
  [2132] = 699,
  [2133] = 700,
  [2134] = 701,
  [2135] = 663,
  [2136] = 664,
  [2137] = 702,
  [2138] = 703,
  [2139] = 704,
  [2140] = 705,
  [2141] = 706,
  [2142] = 624,
  [2143] = 665,
  [2144] = 707,
  [2145] = 708,
  [2146] = 709,
  [2147] = 625,
  [2148] = 710,
  [2149] = 711,
  [2150] = 666,
  [2151] = 713,
  [2152] = 656,
  [2153] = 714,
  [2154] = 667,
  [2155] = 715,
  [2156] = 716,
  [2157] = 717,
  [2158] = 718,
  [2159] = 719,
  [2160] = 657,
  [2161] = 2161,
  [2162] = 721,
  [2163] = 668,
  [2164] = 669,
  [2165] = 722,
  [2166] = 723,
  [2167] = 724,
  [2168] = 725,
  [2169] = 658,
  [2170] = 627,
  [2171] = 628,
  [2172] = 629,
  [2173] = 630,
  [2174] = 631,
  [2175] = 632,
  [2176] = 671,
  [2177] = 633,
  [2178] = 634,
  [2179] = 635,
  [2180] = 672,
  [2181] = 610,
  [2182] = 636,
  [2183] = 673,
  [2184] = 637,
  [2185] = 638,
  [2186] = 639,
  [2187] = 640,
  [2188] = 641,
  [2189] = 642,
  [2190] = 643,
  [2191] = 644,
  [2192] = 645,
  [2193] = 646,
  [2194] = 647,
  [2195] = 648,
  [2196] = 649,
  [2197] = 650,
  [2198] = 674,
  [2199] = 651,
  [2200] = 652,
  [2201] = 653,
  [2202] = 587,
  [2203] = 654,
  [2204] = 588,
  [2205] = 589,
  [2206] = 655,
  [2207] = 675,
  [2208] = 720,
  [2209] = 454,
  [2210] = 467,
  [2211] = 450,
  [2212] = 457,
  [2213] = 466,
  [2214] = 492,
  [2215] = 473,
  [2216] = 494,
  [2217] = 670,
  [2218] = 488,
  [2219] = 592,
  [2220] = 697,
  [2221] = 586,
  [2222] = 479,
  [2223] = 475,
  [2224] = 451,
  [2225] = 712,
  [2226] = 483,
  [2227] = 728,
  [2228] = 726,
  [2229] = 709,
  [2230] = 471,
  [2231] = 624,
  [2232] = 636,
  [2233] = 648,
  [2234] = 654,
  [2235] = 671,
  [2236] = 672,
  [2237] = 673,
  [2238] = 674,
  [2239] = 675,
  [2240] = 676,
  [2241] = 677,
  [2242] = 678,
  [2243] = 679,
  [2244] = 680,
  [2245] = 657,
  [2246] = 626,
  [2247] = 681,
  [2248] = 682,
  [2249] = 656,
  [2250] = 627,
  [2251] = 628,
  [2252] = 629,
  [2253] = 630,
  [2254] = 631,
  [2255] = 632,
  [2256] = 693,
  [2257] = 694,
  [2258] = 695,
  [2259] = 696,
  [2260] = 658,
  [2261] = 698,
  [2262] = 659,
  [2263] = 699,
  [2264] = 700,
  [2265] = 701,
  [2266] = 660,
  [2267] = 702,
  [2268] = 703,
  [2269] = 704,
  [2270] = 705,
  [2271] = 706,
  [2272] = 661,
  [2273] = 707,
  [2274] = 708,
  [2275] = 662,
  [2276] = 633,
  [2277] = 573,
  [2278] = 727,
  [2279] = 663,
  [2280] = 664,
  [2281] = 634,
  [2282] = 635,
  [2283] = 625,
  [2284] = 710,
  [2285] = 711,
  [2286] = 665,
  [2287] = 713,
  [2288] = 666,
  [2289] = 714,
  [2290] = 667,
  [2291] = 715,
  [2292] = 716,
  [2293] = 717,
  [2294] = 718,
  [2295] = 719,
  [2296] = 720,
  [2297] = 721,
  [2298] = 722,
  [2299] = 723,
  [2300] = 724,
  [2301] = 725,
  [2302] = 668,
  [2303] = 637,
  [2304] = 638,
  [2305] = 639,
  [2306] = 640,
  [2307] = 641,
  [2308] = 642,
  [2309] = 643,
  [2310] = 644,
  [2311] = 645,
  [2312] = 646,
  [2313] = 647,
  [2314] = 669,
  [2315] = 649,
  [2316] = 650,
  [2317] = 651,
  [2318] = 652,
  [2319] = 653,
  [2320] = 655,
  [2321] = 2321,
  [2322] = 2321,
  [2323] = 2321,
  [2324] = 2321,
  [2325] = 2321,
  [2326] = 2321,
  [2327] = 2321,
  [2328] = 2328,
  [2329] = 2329,
  [2330] = 2330,
  [2331] = 2331,
  [2332] = 2329,
  [2333] = 2329,
  [2334] = 2329,
  [2335] = 2331,
  [2336] = 2329,
  [2337] = 2331,
  [2338] = 2331,
  [2339] = 2331,
  [2340] = 2330,
  [2341] = 2329,
  [2342] = 2331,
  [2343] = 2331,
  [2344] = 2329,
  [2345] = 2331,
  [2346] = 2330,
  [2347] = 2329,
  [2348] = 2330,
  [2349] = 2329,
  [2350] = 2330,
  [2351] = 2330,
  [2352] = 2330,
  [2353] = 2330,
  [2354] = 2330,
  [2355] = 2331,
  [2356] = 2356,
  [2357] = 2357,
  [2358] = 2358,
  [2359] = 2357,
  [2360] = 2360,
  [2361] = 2360,
  [2362] = 2357,
  [2363] = 2357,
  [2364] = 2357,
  [2365] = 2360,
  [2366] = 2360,
  [2367] = 2360,
  [2368] = 2357,
  [2369] = 2360,
  [2370] = 2360,
  [2371] = 2371,
  [2372] = 2360,
  [2373] = 2357,
  [2374] = 2357,
  [2375] = 2360,
  [2376] = 2357,
  [2377] = 2357,
  [2378] = 2360,
  [2379] = 2379,
  [2380] = 2380,
  [2381] = 2381,
  [2382] = 2382,
  [2383] = 2383,
  [2384] = 2384,
  [2385] = 2385,
  [2386] = 2386,
  [2387] = 2387,
  [2388] = 2388,
  [2389] = 2389,
  [2390] = 2390,
  [2391] = 2391,
  [2392] = 2392,
  [2393] = 2393,
  [2394] = 2394,
  [2395] = 2395,
  [2396] = 2396,
  [2397] = 2397,
  [2398] = 2398,
  [2399] = 2386,
  [2400] = 2383,
  [2401] = 2384,
  [2402] = 2387,
  [2403] = 2393,
  [2404] = 2404,
  [2405] = 2405,
  [2406] = 2385,
  [2407] = 2407,
  [2408] = 2386,
  [2409] = 2394,
  [2410] = 2383,
  [2411] = 2384,
  [2412] = 2385,
  [2413] = 2386,
  [2414] = 2387,
  [2415] = 2388,
  [2416] = 2389,
  [2417] = 2390,
  [2418] = 2391,
  [2419] = 2392,
  [2420] = 2393,
  [2421] = 2394,
  [2422] = 2395,
  [2423] = 2396,
  [2424] = 2397,
  [2425] = 2398,
  [2426] = 2387,
  [2427] = 2388,
  [2428] = 2389,
  [2429] = 2404,
  [2430] = 2405,
  [2431] = 2390,
  [2432] = 2391,
  [2433] = 2392,
  [2434] = 2393,
  [2435] = 2407,
  [2436] = 2394,
  [2437] = 2395,
  [2438] = 2396,
  [2439] = 2397,
  [2440] = 2398,
  [2441] = 2383,
  [2442] = 2384,
  [2443] = 2380,
  [2444] = 2383,
  [2445] = 2385,
  [2446] = 2386,
  [2447] = 2387,
  [2448] = 2388,
  [2449] = 2389,
  [2450] = 2390,
  [2451] = 2391,
  [2452] = 2392,
  [2453] = 2393,
  [2454] = 2394,
  [2455] = 2395,
  [2456] = 2396,
  [2457] = 2397,
  [2458] = 2398,
  [2459] = 2384,
  [2460] = 2460,
  [2461] = 2381,
  [2462] = 2385,
  [2463] = 2404,
  [2464] = 2405,
  [2465] = 2386,
  [2466] = 2387,
  [2467] = 2407,
  [2468] = 2404,
  [2469] = 2405,
  [2470] = 2388,
  [2471] = 2389,
  [2472] = 2390,
  [2473] = 2383,
  [2474] = 2384,
  [2475] = 2391,
  [2476] = 2392,
  [2477] = 2385,
  [2478] = 2386,
  [2479] = 2387,
  [2480] = 2388,
  [2481] = 2389,
  [2482] = 2390,
  [2483] = 2391,
  [2484] = 2392,
  [2485] = 2393,
  [2486] = 2394,
  [2487] = 2395,
  [2488] = 2396,
  [2489] = 2397,
  [2490] = 2398,
  [2491] = 2407,
  [2492] = 2393,
  [2493] = 2404,
  [2494] = 2405,
  [2495] = 2394,
  [2496] = 2407,
  [2497] = 2395,
  [2498] = 2383,
  [2499] = 2396,
  [2500] = 2385,
  [2501] = 2386,
  [2502] = 2387,
  [2503] = 2388,
  [2504] = 2389,
  [2505] = 2390,
  [2506] = 2391,
  [2507] = 2392,
  [2508] = 2393,
  [2509] = 2394,
  [2510] = 2395,
  [2511] = 2396,
  [2512] = 2397,
  [2513] = 2398,
  [2514] = 2397,
  [2515] = 2383,
  [2516] = 2384,
  [2517] = 2404,
  [2518] = 2405,
  [2519] = 2398,
  [2520] = 2407,
  [2521] = 2398,
  [2522] = 2385,
  [2523] = 2386,
  [2524] = 2387,
  [2525] = 2388,
  [2526] = 2389,
  [2527] = 2390,
  [2528] = 2391,
  [2529] = 2392,
  [2530] = 2393,
  [2531] = 2394,
  [2532] = 2395,
  [2533] = 2396,
  [2534] = 2397,
  [2535] = 2398,
  [2536] = 2389,
  [2537] = 2390,
  [2538] = 2380,
  [2539] = 2407,
  [2540] = 2391,
  [2541] = 2541,
  [2542] = 2404,
  [2543] = 2405,
  [2544] = 2392,
  [2545] = 2384,
  [2546] = 2380,
  [2547] = 2407,
  [2548] = 2395,
  [2549] = 2388,
  [2550] = 2404,
  [2551] = 2380,
  [2552] = 2405,
  [2553] = 2383,
  [2554] = 2384,
  [2555] = 2385,
  [2556] = 2380,
  [2557] = 2386,
  [2558] = 2387,
  [2559] = 2388,
  [2560] = 2389,
  [2561] = 2390,
  [2562] = 2391,
  [2563] = 2392,
  [2564] = 2393,
  [2565] = 2380,
  [2566] = 2394,
  [2567] = 2395,
  [2568] = 2396,
  [2569] = 2397,
  [2570] = 2398,
  [2571] = 2380,
  [2572] = 2396,
  [2573] = 2397,
  [2574] = 2380,
  [2575] = 2407,
  [2576] = 2404,
  [2577] = 2405,
  [2578] = 2405,
  [2579] = 2380,
  [2580] = 2404,
  [2581] = 2460,
  [2582] = 2382,
  [2583] = 2383,
  [2584] = 2460,
  [2585] = 2382,
  [2586] = 2460,
  [2587] = 2382,
  [2588] = 2407,
  [2589] = 2460,
  [2590] = 2382,
  [2591] = 2385,
  [2592] = 2460,
  [2593] = 2382,
  [2594] = 2460,
  [2595] = 2382,
  [2596] = 2460,
  [2597] = 2382,
  [2598] = 2460,
  [2599] = 2382,
  [2600] = 2460,
  [2601] = 2382,
  [2602] = 2381,
  [2603] = 2381,
  [2604] = 2381,
  [2605] = 2381,
  [2606] = 2381,
  [2607] = 2381,
  [2608] = 2381,
  [2609] = 2381,
  [2610] = 2384,
  [2611] = 2611,
  [2612] = 2612,
  [2613] = 2613,
  [2614] = 2614,
  [2615] = 2615,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2618,
  [2619] = 2618,
  [2620] = 2620,
  [2621] = 2611,
  [2622] = 2622,
  [2623] = 2623,
  [2624] = 2618,
  [2625] = 2625,
  [2626] = 2620,
  [2627] = 2613,
  [2628] = 2614,
  [2629] = 2629,
  [2630] = 2630,
  [2631] = 2631,
  [2632] = 2629,
  [2633] = 2629,
  [2634] = 2634,
  [2635] = 2618,
  [2636] = 2622,
  [2637] = 2620,
  [2638] = 2613,
  [2639] = 2614,
  [2640] = 2640,
  [2641] = 2613,
  [2642] = 2629,
  [2643] = 2622,
  [2644] = 2618,
  [2645] = 2630,
  [2646] = 2646,
  [2647] = 2622,
  [2648] = 2616,
  [2649] = 2613,
  [2650] = 2614,
  [2651] = 2620,
  [2652] = 2616,
  [2653] = 2653,
  [2654] = 2625,
  [2655] = 2611,
  [2656] = 2656,
  [2657] = 2653,
  [2658] = 2622,
  [2659] = 2629,
  [2660] = 2613,
  [2661] = 2614,
  [2662] = 2630,
  [2663] = 2611,
  [2664] = 2664,
  [2665] = 2665,
  [2666] = 2630,
  [2667] = 2646,
  [2668] = 2616,
  [2669] = 2622,
  [2670] = 2646,
  [2671] = 2653,
  [2672] = 2613,
  [2673] = 2614,
  [2674] = 2625,
  [2675] = 2611,
  [2676] = 2616,
  [2677] = 2630,
  [2678] = 2646,
  [2679] = 2646,
  [2680] = 2653,
  [2681] = 2622,
  [2682] = 2613,
  [2683] = 2614,
  [2684] = 2616,
  [2685] = 2625,
  [2686] = 2686,
  [2687] = 2653,
  [2688] = 727,
  [2689] = 2625,
  [2690] = 2630,
  [2691] = 2616,
  [2692] = 2613,
  [2693] = 2614,
  [2694] = 2620,
  [2695] = 2695,
  [2696] = 2618,
  [2697] = 2620,
  [2698] = 2618,
  [2699] = 2622,
  [2700] = 2613,
  [2701] = 2614,
  [2702] = 2618,
  [2703] = 2620,
  [2704] = 2620,
  [2705] = 2653,
  [2706] = 2629,
  [2707] = 2622,
  [2708] = 2629,
  [2709] = 2625,
  [2710] = 2686,
  [2711] = 2625,
  [2712] = 2611,
  [2713] = 2664,
  [2714] = 2629,
  [2715] = 2631,
  [2716] = 2618,
  [2717] = 2686,
  [2718] = 2630,
  [2719] = 2646,
  [2720] = 2620,
  [2721] = 2686,
  [2722] = 2616,
  [2723] = 2723,
  [2724] = 2653,
  [2725] = 2686,
  [2726] = 2618,
  [2727] = 2620,
  [2728] = 2625,
  [2729] = 2686,
  [2730] = 2611,
  [2731] = 2629,
  [2732] = 2629,
  [2733] = 2686,
  [2734] = 2646,
  [2735] = 2630,
  [2736] = 2630,
  [2737] = 2686,
  [2738] = 2646,
  [2739] = 2616,
  [2740] = 2686,
  [2741] = 2630,
  [2742] = 2653,
  [2743] = 2686,
  [2744] = 2625,
  [2745] = 2611,
  [2746] = 2646,
  [2747] = 2614,
  [2748] = 2616,
  [2749] = 2653,
  [2750] = 2653,
  [2751] = 2625,
  [2752] = 2611,
  [2753] = 2611,
  [2754] = 2646,
  [2755] = 2622,
  [2756] = 2756,
  [2757] = 2757,
  [2758] = 2758,
  [2759] = 2759,
  [2760] = 2760,
  [2761] = 2761,
  [2762] = 2762,
  [2763] = 2763,
  [2764] = 2764,
  [2765] = 2765,
  [2766] = 2766,
  [2767] = 2767,
  [2768] = 2768,
  [2769] = 2769,
  [2770] = 2770,
  [2771] = 2771,
  [2772] = 2772,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2777,
  [2778] = 2778,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2782,
  [2783] = 2761,
  [2784] = 2762,
  [2785] = 2780,
  [2786] = 2786,
  [2787] = 2787,
  [2788] = 2788,
  [2789] = 2789,
  [2790] = 2786,
  [2791] = 2791,
  [2792] = 2792,
  [2793] = 2787,
  [2794] = 2788,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2797,
  [2798] = 2798,
  [2799] = 2799,
  [2800] = 2757,
  [2801] = 2801,
  [2802] = 2802,
  [2803] = 2803,
  [2804] = 2804,
  [2805] = 2805,
  [2806] = 2806,
  [2807] = 2807,
  [2808] = 2758,
  [2809] = 2809,
  [2810] = 2810,
  [2811] = 2811,
  [2812] = 2812,
  [2813] = 2813,
  [2814] = 2814,
  [2815] = 2789,
  [2816] = 2816,
  [2817] = 2817,
  [2818] = 2818,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 2821,
  [2822] = 2822,
  [2823] = 2823,
  [2824] = 2824,
  [2825] = 2825,
  [2826] = 2826,
  [2827] = 2827,
  [2828] = 2828,
  [2829] = 2829,
  [2830] = 2830,
  [2831] = 2831,
  [2832] = 2832,
  [2833] = 2833,
  [2834] = 2834,
  [2835] = 2759,
  [2836] = 2782,
  [2837] = 2792,
  [2838] = 2804,
  [2839] = 2839,
  [2840] = 2840,
  [2841] = 2841,
  [2842] = 2842,
  [2843] = 2843,
  [2844] = 2844,
  [2845] = 2845,
  [2846] = 2846,
  [2847] = 2847,
  [2848] = 2848,
  [2849] = 2849,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2852,
  [2853] = 2853,
  [2854] = 2760,
  [2855] = 2855,
  [2856] = 2758,
  [2857] = 2857,
  [2858] = 2760,
  [2859] = 2859,
  [2860] = 2763,
  [2861] = 2861,
  [2862] = 2764,
  [2863] = 2765,
  [2864] = 2766,
  [2865] = 2767,
  [2866] = 2768,
  [2867] = 2769,
  [2868] = 2770,
  [2869] = 2771,
  [2870] = 2772,
  [2871] = 2773,
  [2872] = 2774,
  [2873] = 2775,
  [2874] = 2776,
  [2875] = 2777,
  [2876] = 2876,
  [2877] = 2877,
  [2878] = 2878,
  [2879] = 2763,
  [2880] = 2781,
  [2881] = 2881,
  [2882] = 2882,
  [2883] = 2761,
  [2884] = 2762,
  [2885] = 2816,
  [2886] = 2780,
  [2887] = 2786,
  [2888] = 2787,
  [2889] = 2788,
  [2890] = 2789,
  [2891] = 2791,
  [2892] = 2796,
  [2893] = 2893,
  [2894] = 2818,
  [2895] = 2796,
  [2896] = 2764,
  [2897] = 2801,
  [2898] = 2898,
  [2899] = 2802,
  [2900] = 2801,
  [2901] = 2803,
  [2902] = 2802,
  [2903] = 2803,
  [2904] = 2904,
  [2905] = 2819,
  [2906] = 2805,
  [2907] = 2805,
  [2908] = 2765,
  [2909] = 2806,
  [2910] = 2807,
  [2911] = 2806,
  [2912] = 2807,
  [2913] = 2811,
  [2914] = 2812,
  [2915] = 624,
  [2916] = 2766,
  [2917] = 2917,
  [2918] = 2811,
  [2919] = 2816,
  [2920] = 2812,
  [2921] = 2818,
  [2922] = 2819,
  [2923] = 2820,
  [2924] = 2821,
  [2925] = 2822,
  [2926] = 2823,
  [2927] = 2824,
  [2928] = 2825,
  [2929] = 2826,
  [2930] = 2827,
  [2931] = 2931,
  [2932] = 2932,
  [2933] = 2829,
  [2934] = 2830,
  [2935] = 2820,
  [2936] = 2831,
  [2937] = 2832,
  [2938] = 2833,
  [2939] = 2834,
  [2940] = 2759,
  [2941] = 2782,
  [2942] = 2792,
  [2943] = 2804,
  [2944] = 2839,
  [2945] = 2814,
  [2946] = 2841,
  [2947] = 2842,
  [2948] = 2843,
  [2949] = 2844,
  [2950] = 2845,
  [2951] = 2846,
  [2952] = 2847,
  [2953] = 2848,
  [2954] = 2849,
  [2955] = 2850,
  [2956] = 2851,
  [2957] = 2852,
  [2958] = 2814,
  [2959] = 2821,
  [2960] = 2816,
  [2961] = 2758,
  [2962] = 2760,
  [2963] = 2818,
  [2964] = 2819,
  [2965] = 2763,
  [2966] = 2820,
  [2967] = 2764,
  [2968] = 2765,
  [2969] = 2766,
  [2970] = 2767,
  [2971] = 2768,
  [2972] = 2769,
  [2973] = 2770,
  [2974] = 2771,
  [2975] = 2772,
  [2976] = 2773,
  [2977] = 2774,
  [2978] = 2775,
  [2979] = 2776,
  [2980] = 2777,
  [2981] = 2821,
  [2982] = 2822,
  [2983] = 2823,
  [2984] = 2824,
  [2985] = 2781,
  [2986] = 2825,
  [2987] = 2826,
  [2988] = 2761,
  [2989] = 2762,
  [2990] = 2827,
  [2991] = 2780,
  [2992] = 2786,
  [2993] = 2787,
  [2994] = 2788,
  [2995] = 2789,
  [2996] = 2791,
  [2997] = 2829,
  [2998] = 2830,
  [2999] = 2791,
  [3000] = 2831,
  [3001] = 2796,
  [3002] = 2832,
  [3003] = 2833,
  [3004] = 2834,
  [3005] = 2759,
  [3006] = 2801,
  [3007] = 2782,
  [3008] = 2802,
  [3009] = 2803,
  [3010] = 2792,
  [3011] = 2804,
  [3012] = 2839,
  [3013] = 2805,
  [3014] = 2822,
  [3015] = 2841,
  [3016] = 2806,
  [3017] = 2807,
  [3018] = 2842,
  [3019] = 2843,
  [3020] = 2844,
  [3021] = 2845,
  [3022] = 2811,
  [3023] = 2812,
  [3024] = 2846,
  [3025] = 2847,
  [3026] = 2848,
  [3027] = 2849,
  [3028] = 2850,
  [3029] = 2816,
  [3030] = 2851,
  [3031] = 2818,
  [3032] = 2819,
  [3033] = 2820,
  [3034] = 2821,
  [3035] = 2822,
  [3036] = 2823,
  [3037] = 2824,
  [3038] = 2825,
  [3039] = 2826,
  [3040] = 2827,
  [3041] = 2852,
  [3042] = 2839,
  [3043] = 2829,
  [3044] = 2830,
  [3045] = 3045,
  [3046] = 2831,
  [3047] = 2832,
  [3048] = 2833,
  [3049] = 2834,
  [3050] = 2759,
  [3051] = 2782,
  [3052] = 2792,
  [3053] = 2804,
  [3054] = 2839,
  [3055] = 2841,
  [3056] = 2842,
  [3057] = 2843,
  [3058] = 2844,
  [3059] = 2845,
  [3060] = 2846,
  [3061] = 2847,
  [3062] = 2848,
  [3063] = 2849,
  [3064] = 2850,
  [3065] = 2851,
  [3066] = 2852,
  [3067] = 2841,
  [3068] = 2758,
  [3069] = 2760,
  [3070] = 2763,
  [3071] = 2764,
  [3072] = 2765,
  [3073] = 2766,
  [3074] = 2767,
  [3075] = 2768,
  [3076] = 2769,
  [3077] = 2770,
  [3078] = 2771,
  [3079] = 2772,
  [3080] = 2773,
  [3081] = 2774,
  [3082] = 2775,
  [3083] = 2776,
  [3084] = 2777,
  [3085] = 2781,
  [3086] = 2761,
  [3087] = 2762,
  [3088] = 2842,
  [3089] = 2780,
  [3090] = 2786,
  [3091] = 2787,
  [3092] = 2788,
  [3093] = 2789,
  [3094] = 2843,
  [3095] = 2791,
  [3096] = 2844,
  [3097] = 2758,
  [3098] = 2796,
  [3099] = 2845,
  [3100] = 2760,
  [3101] = 2846,
  [3102] = 2801,
  [3103] = 2847,
  [3104] = 2802,
  [3105] = 2803,
  [3106] = 2763,
  [3107] = 2848,
  [3108] = 2764,
  [3109] = 2805,
  [3110] = 2765,
  [3111] = 2766,
  [3112] = 2806,
  [3113] = 2807,
  [3114] = 2767,
  [3115] = 2768,
  [3116] = 2769,
  [3117] = 2811,
  [3118] = 2812,
  [3119] = 2770,
  [3120] = 2771,
  [3121] = 2772,
  [3122] = 2816,
  [3123] = 2773,
  [3124] = 2818,
  [3125] = 2819,
  [3126] = 2820,
  [3127] = 2821,
  [3128] = 2822,
  [3129] = 2823,
  [3130] = 2824,
  [3131] = 2825,
  [3132] = 2826,
  [3133] = 2827,
  [3134] = 2774,
  [3135] = 2775,
  [3136] = 2829,
  [3137] = 2830,
  [3138] = 2776,
  [3139] = 2831,
  [3140] = 2832,
  [3141] = 2833,
  [3142] = 2834,
  [3143] = 2759,
  [3144] = 2782,
  [3145] = 2792,
  [3146] = 2804,
  [3147] = 2777,
  [3148] = 2849,
  [3149] = 2850,
  [3150] = 2851,
  [3151] = 2758,
  [3152] = 2852,
  [3153] = 2760,
  [3154] = 3154,
  [3155] = 2781,
  [3156] = 2763,
  [3157] = 2823,
  [3158] = 2764,
  [3159] = 2765,
  [3160] = 2766,
  [3161] = 2761,
  [3162] = 2762,
  [3163] = 2824,
  [3164] = 2781,
  [3165] = 2780,
  [3166] = 2786,
  [3167] = 2761,
  [3168] = 2762,
  [3169] = 2787,
  [3170] = 2780,
  [3171] = 2786,
  [3172] = 2787,
  [3173] = 2788,
  [3174] = 2788,
  [3175] = 2791,
  [3176] = 2789,
  [3177] = 2791,
  [3178] = 2825,
  [3179] = 2796,
  [3180] = 2826,
  [3181] = 2803,
  [3182] = 2827,
  [3183] = 2796,
  [3184] = 2801,
  [3185] = 2801,
  [3186] = 2802,
  [3187] = 2803,
  [3188] = 2767,
  [3189] = 2806,
  [3190] = 2768,
  [3191] = 2805,
  [3192] = 2801,
  [3193] = 2807,
  [3194] = 2806,
  [3195] = 2807,
  [3196] = 2802,
  [3197] = 2803,
  [3198] = 2769,
  [3199] = 3199,
  [3200] = 2811,
  [3201] = 2812,
  [3202] = 2770,
  [3203] = 2805,
  [3204] = 2756,
  [3205] = 2816,
  [3206] = 2771,
  [3207] = 2818,
  [3208] = 2819,
  [3209] = 2820,
  [3210] = 2821,
  [3211] = 2822,
  [3212] = 2823,
  [3213] = 2824,
  [3214] = 2825,
  [3215] = 2826,
  [3216] = 2827,
  [3217] = 2806,
  [3218] = 2807,
  [3219] = 2829,
  [3220] = 2830,
  [3221] = 2831,
  [3222] = 2832,
  [3223] = 2833,
  [3224] = 2834,
  [3225] = 2759,
  [3226] = 2782,
  [3227] = 2792,
  [3228] = 2804,
  [3229] = 2811,
  [3230] = 2772,
  [3231] = 2758,
  [3232] = 2773,
  [3233] = 2760,
  [3234] = 2811,
  [3235] = 2812,
  [3236] = 2763,
  [3237] = 2829,
  [3238] = 2764,
  [3239] = 2766,
  [3240] = 2774,
  [3241] = 2830,
  [3242] = 2814,
  [3243] = 2781,
  [3244] = 2775,
  [3245] = 2761,
  [3246] = 2762,
  [3247] = 2776,
  [3248] = 2780,
  [3249] = 2786,
  [3250] = 2787,
  [3251] = 2788,
  [3252] = 2816,
  [3253] = 2791,
  [3254] = 2812,
  [3255] = 2818,
  [3256] = 2819,
  [3257] = 2820,
  [3258] = 2821,
  [3259] = 2822,
  [3260] = 2823,
  [3261] = 2824,
  [3262] = 2825,
  [3263] = 2801,
  [3264] = 2826,
  [3265] = 2802,
  [3266] = 2803,
  [3267] = 2827,
  [3268] = 2777,
  [3269] = 3269,
  [3270] = 2805,
  [3271] = 2829,
  [3272] = 2830,
  [3273] = 2806,
  [3274] = 2807,
  [3275] = 2831,
  [3276] = 2831,
  [3277] = 2832,
  [3278] = 2833,
  [3279] = 2811,
  [3280] = 2812,
  [3281] = 2834,
  [3282] = 2759,
  [3283] = 2782,
  [3284] = 2816,
  [3285] = 2792,
  [3286] = 2818,
  [3287] = 2819,
  [3288] = 2820,
  [3289] = 2821,
  [3290] = 2822,
  [3291] = 2823,
  [3292] = 2824,
  [3293] = 2825,
  [3294] = 2826,
  [3295] = 2827,
  [3296] = 2804,
  [3297] = 2839,
  [3298] = 2829,
  [3299] = 2830,
  [3300] = 2831,
  [3301] = 2832,
  [3302] = 2833,
  [3303] = 2834,
  [3304] = 2759,
  [3305] = 2782,
  [3306] = 2792,
  [3307] = 2804,
  [3308] = 2841,
  [3309] = 2842,
  [3310] = 2843,
  [3311] = 2758,
  [3312] = 2844,
  [3313] = 2760,
  [3314] = 2845,
  [3315] = 2846,
  [3316] = 2763,
  [3317] = 2847,
  [3318] = 2764,
  [3319] = 2765,
  [3320] = 2766,
  [3321] = 2848,
  [3322] = 2849,
  [3323] = 2850,
  [3324] = 2781,
  [3325] = 2851,
  [3326] = 2852,
  [3327] = 2761,
  [3328] = 2762,
  [3329] = 2780,
  [3330] = 2786,
  [3331] = 2787,
  [3332] = 2788,
  [3333] = 2791,
  [3334] = 3154,
  [3335] = 3199,
  [3336] = 2756,
  [3337] = 2878,
  [3338] = 3045,
  [3339] = 3269,
  [3340] = 2778,
  [3341] = 2797,
  [3342] = 2758,
  [3343] = 2881,
  [3344] = 2882,
  [3345] = 2904,
  [3346] = 2917,
  [3347] = 2931,
  [3348] = 2795,
  [3349] = 2809,
  [3350] = 2810,
  [3351] = 2813,
  [3352] = 2817,
  [3353] = 2828,
  [3354] = 2840,
  [3355] = 2853,
  [3356] = 2855,
  [3357] = 2857,
  [3358] = 2859,
  [3359] = 2760,
  [3360] = 3154,
  [3361] = 3199,
  [3362] = 2756,
  [3363] = 2878,
  [3364] = 3045,
  [3365] = 2763,
  [3366] = 2764,
  [3367] = 2765,
  [3368] = 3269,
  [3369] = 2766,
  [3370] = 2778,
  [3371] = 2797,
  [3372] = 2767,
  [3373] = 2768,
  [3374] = 2881,
  [3375] = 2882,
  [3376] = 2904,
  [3377] = 2917,
  [3378] = 2931,
  [3379] = 2769,
  [3380] = 2795,
  [3381] = 2809,
  [3382] = 2810,
  [3383] = 2813,
  [3384] = 2817,
  [3385] = 2828,
  [3386] = 2840,
  [3387] = 2853,
  [3388] = 2855,
  [3389] = 2857,
  [3390] = 2859,
  [3391] = 3154,
  [3392] = 3199,
  [3393] = 2756,
  [3394] = 2770,
  [3395] = 2771,
  [3396] = 2878,
  [3397] = 3045,
  [3398] = 2772,
  [3399] = 2773,
  [3400] = 2774,
  [3401] = 2775,
  [3402] = 3269,
  [3403] = 2776,
  [3404] = 2777,
  [3405] = 2778,
  [3406] = 2797,
  [3407] = 2881,
  [3408] = 2882,
  [3409] = 2904,
  [3410] = 2917,
  [3411] = 2931,
  [3412] = 2795,
  [3413] = 2809,
  [3414] = 2810,
  [3415] = 2813,
  [3416] = 2817,
  [3417] = 2828,
  [3418] = 2840,
  [3419] = 2853,
  [3420] = 2855,
  [3421] = 2857,
  [3422] = 2859,
  [3423] = 3154,
  [3424] = 3199,
  [3425] = 2756,
  [3426] = 2781,
  [3427] = 2878,
  [3428] = 3045,
  [3429] = 2761,
  [3430] = 2762,
  [3431] = 3269,
  [3432] = 2780,
  [3433] = 2778,
  [3434] = 2797,
  [3435] = 2786,
  [3436] = 2787,
  [3437] = 2881,
  [3438] = 2882,
  [3439] = 2904,
  [3440] = 2917,
  [3441] = 2931,
  [3442] = 2788,
  [3443] = 2795,
  [3444] = 2809,
  [3445] = 2810,
  [3446] = 2813,
  [3447] = 2817,
  [3448] = 2828,
  [3449] = 2840,
  [3450] = 2853,
  [3451] = 2855,
  [3452] = 2857,
  [3453] = 2859,
  [3454] = 3154,
  [3455] = 3199,
  [3456] = 2756,
  [3457] = 2789,
  [3458] = 2878,
  [3459] = 3045,
  [3460] = 2791,
  [3461] = 3269,
  [3462] = 2778,
  [3463] = 2797,
  [3464] = 2796,
  [3465] = 2881,
  [3466] = 2882,
  [3467] = 2904,
  [3468] = 2917,
  [3469] = 2931,
  [3470] = 2795,
  [3471] = 2809,
  [3472] = 2810,
  [3473] = 2813,
  [3474] = 2817,
  [3475] = 2828,
  [3476] = 2840,
  [3477] = 2853,
  [3478] = 2855,
  [3479] = 2857,
  [3480] = 2859,
  [3481] = 3154,
  [3482] = 3199,
  [3483] = 2801,
  [3484] = 2878,
  [3485] = 3045,
  [3486] = 2802,
  [3487] = 2803,
  [3488] = 3269,
  [3489] = 2778,
  [3490] = 2797,
  [3491] = 2805,
  [3492] = 2881,
  [3493] = 2882,
  [3494] = 2904,
  [3495] = 2917,
  [3496] = 2931,
  [3497] = 2795,
  [3498] = 2809,
  [3499] = 2810,
  [3500] = 2813,
  [3501] = 2817,
  [3502] = 2828,
  [3503] = 2840,
  [3504] = 2853,
  [3505] = 2855,
  [3506] = 2857,
  [3507] = 2859,
  [3508] = 3154,
  [3509] = 3199,
  [3510] = 2756,
  [3511] = 2806,
  [3512] = 2878,
  [3513] = 3045,
  [3514] = 2807,
  [3515] = 3269,
  [3516] = 2778,
  [3517] = 2797,
  [3518] = 2811,
  [3519] = 2812,
  [3520] = 2881,
  [3521] = 2882,
  [3522] = 2904,
  [3523] = 2917,
  [3524] = 2931,
  [3525] = 2795,
  [3526] = 3154,
  [3527] = 3199,
  [3528] = 2756,
  [3529] = 2832,
  [3530] = 2878,
  [3531] = 3045,
  [3532] = 2814,
  [3533] = 3533,
  [3534] = 3269,
  [3535] = 2816,
  [3536] = 2778,
  [3537] = 2797,
  [3538] = 2796,
  [3539] = 2881,
  [3540] = 2882,
  [3541] = 2904,
  [3542] = 2917,
  [3543] = 2931,
  [3544] = 2795,
  [3545] = 3154,
  [3546] = 3199,
  [3547] = 2756,
  [3548] = 2818,
  [3549] = 2819,
  [3550] = 2878,
  [3551] = 3045,
  [3552] = 2820,
  [3553] = 2821,
  [3554] = 2822,
  [3555] = 3269,
  [3556] = 2823,
  [3557] = 2824,
  [3558] = 2778,
  [3559] = 2797,
  [3560] = 2825,
  [3561] = 2881,
  [3562] = 2882,
  [3563] = 2904,
  [3564] = 2917,
  [3565] = 2931,
  [3566] = 2795,
  [3567] = 2826,
  [3568] = 2827,
  [3569] = 2781,
  [3570] = 2861,
  [3571] = 2876,
  [3572] = 2829,
  [3573] = 3573,
  [3574] = 2779,
  [3575] = 2798,
  [3576] = 2799,
  [3577] = 2830,
  [3578] = 2932,
  [3579] = 2802,
  [3580] = 2831,
  [3581] = 2832,
  [3582] = 2833,
  [3583] = 2861,
  [3584] = 2876,
  [3585] = 2834,
  [3586] = 2759,
  [3587] = 3573,
  [3588] = 2779,
  [3589] = 2798,
  [3590] = 2799,
  [3591] = 2932,
  [3592] = 2782,
  [3593] = 2792,
  [3594] = 2861,
  [3595] = 2876,
  [3596] = 2804,
  [3597] = 2839,
  [3598] = 3573,
  [3599] = 2779,
  [3600] = 2798,
  [3601] = 2799,
  [3602] = 2932,
  [3603] = 3573,
  [3604] = 2841,
  [3605] = 2861,
  [3606] = 2876,
  [3607] = 2842,
  [3608] = 2843,
  [3609] = 3573,
  [3610] = 2779,
  [3611] = 2798,
  [3612] = 2799,
  [3613] = 2932,
  [3614] = 2844,
  [3615] = 2845,
  [3616] = 2861,
  [3617] = 2876,
  [3618] = 2846,
  [3619] = 2847,
  [3620] = 3573,
  [3621] = 2779,
  [3622] = 2798,
  [3623] = 2799,
  [3624] = 2932,
  [3625] = 2848,
  [3626] = 2849,
  [3627] = 2861,
  [3628] = 2876,
  [3629] = 2850,
  [3630] = 2851,
  [3631] = 3573,
  [3632] = 2779,
  [3633] = 2798,
  [3634] = 2799,
  [3635] = 2932,
  [3636] = 2852,
  [3637] = 2833,
  [3638] = 2861,
  [3639] = 2876,
  [3640] = 728,
  [3641] = 3573,
  [3642] = 2779,
  [3643] = 2798,
  [3644] = 2799,
  [3645] = 2932,
  [3646] = 2861,
  [3647] = 2876,
  [3648] = 3573,
  [3649] = 2779,
  [3650] = 2798,
  [3651] = 2799,
  [3652] = 2932,
  [3653] = 2861,
  [3654] = 2876,
  [3655] = 3573,
  [3656] = 2779,
  [3657] = 2798,
  [3658] = 2799,
  [3659] = 2932,
  [3660] = 2877,
  [3661] = 2757,
  [3662] = 2877,
  [3663] = 2757,
  [3664] = 2877,
  [3665] = 2757,
  [3666] = 2877,
  [3667] = 2757,
  [3668] = 2877,
  [3669] = 2757,
  [3670] = 2877,
  [3671] = 2757,
  [3672] = 2877,
  [3673] = 2757,
  [3674] = 2877,
  [3675] = 2834,
  [3676] = 2757,
  [3677] = 2877,
  [3678] = 2805,
  [3679] = 2765,
  [3680] = 3680,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 3683,
  [3684] = 3684,
  [3685] = 691,
  [3686] = 3686,
  [3687] = 3687,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 3690,
  [3691] = 3691,
  [3692] = 3692,
  [3693] = 3693,
  [3694] = 3694,
  [3695] = 3695,
  [3696] = 3696,
  [3697] = 3697,
  [3698] = 3698,
  [3699] = 3699,
  [3700] = 3700,
  [3701] = 3701,
  [3702] = 3702,
  [3703] = 3680,
  [3704] = 3704,
  [3705] = 3684,
  [3706] = 3681,
  [3707] = 3707,
  [3708] = 3688,
  [3709] = 3682,
  [3710] = 3686,
  [3711] = 3688,
  [3712] = 3687,
  [3713] = 692,
  [3714] = 3680,
  [3715] = 3715,
  [3716] = 3696,
  [3717] = 3717,
  [3718] = 3718,
  [3719] = 3719,
  [3720] = 3720,
  [3721] = 3721,
  [3722] = 3707,
  [3723] = 3723,
  [3724] = 3724,
  [3725] = 3698,
  [3726] = 3726,
  [3727] = 3727,
  [3728] = 3723,
  [3729] = 3729,
  [3730] = 3730,
  [3731] = 3731,
  [3732] = 3732,
  [3733] = 3683,
  [3734] = 3688,
  [3735] = 3735,
  [3736] = 3736,
  [3737] = 3700,
  [3738] = 3701,
  [3739] = 3689,
  [3740] = 3740,
  [3741] = 3696,
  [3742] = 3726,
  [3743] = 3684,
  [3744] = 3697,
  [3745] = 3700,
  [3746] = 3688,
  [3747] = 3699,
  [3748] = 3727,
  [3749] = 3749,
  [3750] = 3750,
  [3751] = 3719,
  [3752] = 3684,
  [3753] = 3753,
  [3754] = 3697,
  [3755] = 3697,
  [3756] = 3756,
  [3757] = 3750,
  [3758] = 3758,
  [3759] = 3730,
  [3760] = 3690,
  [3761] = 3761,
  [3762] = 3702,
  [3763] = 3691,
  [3764] = 3680,
  [3765] = 3692,
  [3766] = 3693,
  [3767] = 3717,
  [3768] = 3718,
  [3769] = 3719,
  [3770] = 3720,
  [3771] = 3721,
  [3772] = 3707,
  [3773] = 3723,
  [3774] = 3724,
  [3775] = 3698,
  [3776] = 3726,
  [3777] = 3727,
  [3778] = 3681,
  [3779] = 3779,
  [3780] = 3730,
  [3781] = 3715,
  [3782] = 3782,
  [3783] = 3683,
  [3784] = 3694,
  [3785] = 3682,
  [3786] = 3686,
  [3787] = 3695,
  [3788] = 3750,
  [3789] = 3689,
  [3790] = 3790,
  [3791] = 3687,
  [3792] = 3697,
  [3793] = 3715,
  [3794] = 3794,
  [3795] = 3696,
  [3796] = 3699,
  [3797] = 3696,
  [3798] = 3684,
  [3799] = 3702,
  [3800] = 3681,
  [3801] = 3682,
  [3802] = 3686,
  [3803] = 3687,
  [3804] = 3690,
  [3805] = 3691,
  [3806] = 3696,
  [3807] = 3699,
  [3808] = 3702,
  [3809] = 3692,
  [3810] = 3693,
  [3811] = 3690,
  [3812] = 3680,
  [3813] = 3680,
  [3814] = 3681,
  [3815] = 3682,
  [3816] = 3717,
  [3817] = 3750,
  [3818] = 3730,
  [3819] = 3691,
  [3820] = 3692,
  [3821] = 3683,
  [3822] = 3718,
  [3823] = 3693,
  [3824] = 3694,
  [3825] = 3719,
  [3826] = 3720,
  [3827] = 3689,
  [3828] = 3721,
  [3829] = 3707,
  [3830] = 3723,
  [3831] = 3724,
  [3832] = 3698,
  [3833] = 3726,
  [3834] = 3727,
  [3835] = 3694,
  [3836] = 3695,
  [3837] = 3730,
  [3838] = 3838,
  [3839] = 3695,
  [3840] = 3840,
  [3841] = 3680,
  [3842] = 3683,
  [3843] = 3686,
  [3844] = 3700,
  [3845] = 3730,
  [3846] = 3846,
  [3847] = 3701,
  [3848] = 3683,
  [3849] = 3750,
  [3850] = 3850,
  [3851] = 3687,
  [3852] = 3689,
  [3853] = 3853,
  [3854] = 3689,
  [3855] = 3690,
  [3856] = 3700,
  [3857] = 3701,
  [3858] = 3691,
  [3859] = 3692,
  [3860] = 3684,
  [3861] = 3684,
  [3862] = 3862,
  [3863] = 3693,
  [3864] = 3694,
  [3865] = 3695,
  [3866] = 3688,
  [3867] = 3701,
  [3868] = 3730,
  [3869] = 3869,
  [3870] = 3700,
  [3871] = 3730,
  [3872] = 3701,
  [3873] = 3873,
  [3874] = 3683,
  [3875] = 3688,
  [3876] = 3750,
  [3877] = 3684,
  [3878] = 3688,
  [3879] = 3721,
  [3880] = 3689,
  [3881] = 3750,
  [3882] = 3688,
  [3883] = 683,
  [3884] = 684,
  [3885] = 3680,
  [3886] = 3886,
  [3887] = 3697,
  [3888] = 3717,
  [3889] = 3683,
  [3890] = 3718,
  [3891] = 3719,
  [3892] = 3720,
  [3893] = 3721,
  [3894] = 3894,
  [3895] = 3707,
  [3896] = 3723,
  [3897] = 3724,
  [3898] = 3698,
  [3899] = 3726,
  [3900] = 3727,
  [3901] = 3720,
  [3902] = 685,
  [3903] = 3730,
  [3904] = 3750,
  [3905] = 3715,
  [3906] = 3683,
  [3907] = 3696,
  [3908] = 3697,
  [3909] = 3697,
  [3910] = 3910,
  [3911] = 3700,
  [3912] = 3689,
  [3913] = 3701,
  [3914] = 3715,
  [3915] = 3701,
  [3916] = 3684,
  [3917] = 3917,
  [3918] = 3715,
  [3919] = 3688,
  [3920] = 3697,
  [3921] = 3684,
  [3922] = 3696,
  [3923] = 3699,
  [3924] = 3702,
  [3925] = 3700,
  [3926] = 3681,
  [3927] = 3697,
  [3928] = 3682,
  [3929] = 3686,
  [3930] = 3687,
  [3931] = 3690,
  [3932] = 3691,
  [3933] = 3683,
  [3934] = 3692,
  [3935] = 3693,
  [3936] = 3715,
  [3937] = 3680,
  [3938] = 3694,
  [3939] = 3695,
  [3940] = 3717,
  [3941] = 3718,
  [3942] = 3719,
  [3943] = 3720,
  [3944] = 3721,
  [3945] = 3707,
  [3946] = 3723,
  [3947] = 3724,
  [3948] = 3698,
  [3949] = 3726,
  [3950] = 3727,
  [3951] = 3951,
  [3952] = 3952,
  [3953] = 3730,
  [3954] = 3954,
  [3955] = 3717,
  [3956] = 3683,
  [3957] = 3700,
  [3958] = 3701,
  [3959] = 3718,
  [3960] = 3960,
  [3961] = 3689,
  [3962] = 3689,
  [3963] = 3715,
  [3964] = 3964,
  [3965] = 686,
  [3966] = 3684,
  [3967] = 3724,
  [3968] = 3715,
  [3969] = 726,
  [3970] = 3696,
  [3971] = 3715,
  [3972] = 687,
  [3973] = 3699,
  [3974] = 3702,
  [3975] = 3696,
  [3976] = 3696,
  [3977] = 3699,
  [3978] = 3702,
  [3979] = 3681,
  [3980] = 3681,
  [3981] = 3686,
  [3982] = 3687,
  [3983] = 3682,
  [3984] = 3686,
  [3985] = 3690,
  [3986] = 3691,
  [3987] = 3692,
  [3988] = 3693,
  [3989] = 3750,
  [3990] = 3694,
  [3991] = 3687,
  [3992] = 3699,
  [3993] = 688,
  [3994] = 3690,
  [3995] = 3702,
  [3996] = 3680,
  [3997] = 3691,
  [3998] = 3700,
  [3999] = 3701,
  [4000] = 3692,
  [4001] = 3717,
  [4002] = 3718,
  [4003] = 3693,
  [4004] = 3719,
  [4005] = 3720,
  [4006] = 3694,
  [4007] = 3721,
  [4008] = 3707,
  [4009] = 3695,
  [4010] = 3723,
  [4011] = 3724,
  [4012] = 3698,
  [4013] = 3726,
  [4014] = 3727,
  [4015] = 689,
  [4016] = 690,
  [4017] = 3750,
};

static TSCharacterRange sym_word_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '"'}, {'\'', '\''}, {'.', '.'}, {'0', '<'}, {'>', 'Z'}, {'`', 'z'},
  {'|', '|'}, {'~', 0x10ffff},
};

static TSCharacterRange sym_path_character_set_1[] = {
  {0, '!'}, {'#', ')'}, {'+', '+'}, {'-', '9'}, {'=', '='}, {'?', 'Z'}, {'\\', '\\'}, {'^', 'z'},
  {'~', 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(39);
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 270,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 277,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 271,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 272,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 279,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 280,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 273,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 285,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 293,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 281,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 274,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 295,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 282,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 275,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 291,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 278,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 284,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 292,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 294,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 19:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 290,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '>', 202,
        '[', 50,
        '\\', 289,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '#' || '-' < lookahead) &&
          (lookahead < '<' || '>' < lookahead) &&
          (lookahead < '[' || '_' < lookahead)) ADVANCE(190);
      END_STATE();
    case 21:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '>', 202,
        '\\', 288,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '#' || '-' < lookahead) &&
          (lookahead < '<' || '>' < lookahead) &&
          (lookahead < '[' || '_' < lookahead)) ADVANCE(190);
      END_STATE();
    case 22:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '%', 47,
        '&', 192,
        '\'', 206,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 1533,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '#' || '-' < lookahead)) ADVANCE(190);
      END_STATE();
    case 23:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '%', 47,
        '&', 192,
        '\'', 206,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '\\', 1532,
        ']', 51,
        '^', 209,
        '_', 208,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '#' || '-' < lookahead) &&
          (lookahead < '[' || '_' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 24:
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '%', 47,
        '&', 192,
        '\'', 206,
        '*', 199,
        '+', 197,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '>', 202,
        '\\', 1533,
        '^', 209,
        '_', 208,
        'a', 133,
        'c', 156,
        'd', 122,
        'e', 162,
        'f', 134,
        'g', 82,
        'l', 169,
        'm', 91,
        'p', 185,
        's', 83,
        'v', 109,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '#' || '-' < lookahead) &&
          (lookahead < '<' || '>' < lookahead) &&
          (lookahead < '[' || '_' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 25:
      if (lookahead == '#') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 26:
      ADVANCE_MAP(
        '%', 47,
        '(', 54,
        ')', 55,
        '=', 53,
        '[', 50,
        '\\', 1534,
        ']', 51,
        '{', 78,
        '|', 204,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '#' || '&' < lookahead) &&
          (lookahead < '(' || '-' < lookahead) &&
          lookahead != '/' &&
          (lookahead < '[' || '_' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(190);
      END_STATE();
    case 27:
      if (lookahead == '%') ADVANCE(47);
      if (lookahead == '\\') ADVANCE(1534);
      if (lookahead == '{') ADVANCE(78);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '#' || '%' < lookahead) &&
          lookahead != '^' &&
          lookahead != '_' &&
          lookahead != '}') ADVANCE(207);
      END_STATE();
    case 28:
      if (lookahead == '%') ADVANCE(47);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '}') ADVANCE(79);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 29:
      if (lookahead == '%') ADVANCE(44);
      if (lookahead == '{') ADVANCE(78);
      if (lookahead == '}') ADVANCE(79);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(196);
      END_STATE();
    case 30:
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '}') ADVANCE(79);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if ((!eof && set_contains(sym_path_character_set_1, 9, lookahead))) ADVANCE(193);
      END_STATE();
    case 31:
      if (lookahead == '%') ADVANCE(46);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(43);
      if (lookahead != 0 &&
          lookahead != '[' &&
          lookahead != ']' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(194);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(34);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(80);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 35:
      if (eof) ADVANCE(39);
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 287,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 36:
      if (eof) ADVANCE(39);
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 283,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 37:
      if (eof) ADVANCE(39);
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 276,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 38:
      if (eof) ADVANCE(39);
      ADVANCE_MAP(
        '!', 203,
        '#', 25,
        '$', 213,
        '%', 47,
        '&', 192,
        '\'', 206,
        '(', 54,
        ')', 55,
        '*', 199,
        '+', 197,
        ',', 52,
        '-', 198,
        '/', 200,
        ':', 205,
        '<', 201,
        '=', 53,
        '>', 202,
        '[', 50,
        '\\', 286,
        ']', 51,
        '^', 209,
        '_', 208,
        '{', 78,
        '|', 204,
        '}', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym__whitespace);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym__whitespace);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(196);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym__whitespace);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if ((!eof && set_contains(sym_path_character_set_1, 9, lookahead))) ADVANCE(193);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym__whitespace);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(43);
      if (lookahead != 0 &&
          lookahead != '[' &&
          lookahead != ']' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(194);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(196);
      if (lookahead == '"' ||
          (':' <= lookahead && lookahead <= '<') ||
          lookahead == '>' ||
          lookahead == '[' ||
          lookahead == ']' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(47);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(193);
      if (lookahead == '"' ||
          lookahead == '*' ||
          lookahead == ',' ||
          (':' <= lookahead && lookahead <= '<') ||
          lookahead == '>' ||
          lookahead == '[' ||
          lookahead == ']' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(47);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(194);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(47);
      if (lookahead != 0) ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_BSLASHiffalse);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_BSLASHfi);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_BSLASHpart);
      if (lookahead == '*') ADVANCE(57);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_BSLASHpart_STAR);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_BSLASHaddpart);
      if (lookahead == '*') ADVANCE(59);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_BSLASHaddpart_STAR);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_BSLASHchapter);
      if (lookahead == '*') ADVANCE(61);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_BSLASHchapter_STAR);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_BSLASHaddchap);
      if (lookahead == '*') ADVANCE(63);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_BSLASHaddchap_STAR);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_BSLASHsection);
      if (lookahead == '*') ADVANCE(65);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_BSLASHsection_STAR);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_BSLASHaddsec);
      if (lookahead == '*') ADVANCE(67);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_BSLASHaddsec_STAR);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsection);
      if (lookahead == '*') ADVANCE(69);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsection_STAR);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsubsection);
      if (lookahead == '*') ADVANCE(71);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsubsection_STAR);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_BSLASHparagraph);
      if (lookahead == '*') ADVANCE(73);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_BSLASHparagraph_STAR);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_BSLASHsubparagraph);
      if (lookahead == '*') ADVANCE(75);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_BSLASHsubparagraph_STAR);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_BSLASHitem);
      if (lookahead == '*') ADVANCE(77);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_BSLASHitem_STAR);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_BSLASHand);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_BSLASHand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(171);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(116);
      if (lookahead == 'p') ADVANCE(135);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(187);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(167);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(140);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(189);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(179);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(188);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(183);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(177);
      if (lookahead == 'i') ADVANCE(150);
      if (lookahead == 'u') ADVANCE(141);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(178);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(98);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'b') ADVANCE(136);
      if (lookahead == 's') ADVANCE(131);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'b') ADVANCE(90);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(132);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(157);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(160);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(234);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(253);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(265);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(106);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(107);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(94);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(114);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(237);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(238);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(247);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(163);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(99);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(164);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(154);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(155);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'f') ADVANCE(236);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(233);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(104);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(147);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(148);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(242);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(243);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(111);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(168);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(170);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(117);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(159);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(118);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(143);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(153);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(172);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(151);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(142);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'k') ADVANCE(241);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(124);
      if (lookahead == 'r') ADVANCE(165);
      if (lookahead == 's') ADVANCE(186);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(86);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(129);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(158);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(128);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(87);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(123);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(126);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(182);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(113);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(232);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(145);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(112);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(92);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(251);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(267);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(245);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(181);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(115);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(85);
      if (lookahead == 'u') ADVANCE(88);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(108);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(174);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(176);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(144);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(102);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(96);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(149);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(103);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'p') ADVANCE(138);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'q') ADVANCE(152);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(95);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(263);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(84);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(89);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(166);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(161);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(180);
      if (lookahead == 'u') ADVANCE(93);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(184);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(121);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(257);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(259);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(231);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(261);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(240);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(119);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(120);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(125);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(139);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(110);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(137);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(127);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(130);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(97);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(235);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(255);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(249);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(146);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_word);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_delimiter);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_path);
      if ((!eof && set_contains(sym_path_character_set_1, 9, lookahead))) ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_uri);
      if (lookahead != 0 &&
          lookahead != '[' &&
          lookahead != ']' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_argc);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym__glob_pattern_fragment_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_LT);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_GT);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_BANG);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_COLON);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_letter);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_BSLASH_LBRACK);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_BSLASH_RBRACK);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(210);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_BSLASH_LPAREN);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_BSLASH_RPAREN);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_BSLASHleft);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_BSLASHbigl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_BSLASHBigl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_BSLASHbiggl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_BSLASHBiggl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_BSLASHright);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_BSLASHbigr);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_BSLASHBigr);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_BSLASHbiggr);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_BSLASHBiggr);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_BSLASHtext);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(833);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_BSLASHintertext);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_BSLASHshortintertext);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_BSLASHbegin);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_BSLASHend);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_comment);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_verbatim);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_lstlisting);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_minted);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_asy);
      if (lookahead == 'd') ADVANCE(105);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_asydef);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_pycode);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_luacode);
      if (lookahead == '*') ADVANCE(239);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_luacode_STAR);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_sagesilent);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_sageblock);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_math);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_displaymath);
      if (lookahead == '*') ADVANCE(244);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_displaymath_STAR);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_equation);
      if (lookahead == '*') ADVANCE(246);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_equation_STAR);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_multline);
      if (lookahead == '*') ADVANCE(248);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_multline_STAR);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_eqnarray);
      if (lookahead == '*') ADVANCE(250);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_eqnarray_STAR);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_align);
      if (lookahead == '*') ADVANCE(252);
      if (lookahead == 'a') ADVANCE(173);
      if (lookahead == 'e') ADVANCE(100);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_align_STAR);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_aligned);
      if (lookahead == '*') ADVANCE(254);
      if (lookahead == 'a') ADVANCE(175);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_aligned_STAR);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_array);
      if (lookahead == '*') ADVANCE(256);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_array_STAR);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_split);
      if (lookahead == '*') ADVANCE(258);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_split_STAR);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_alignat);
      if (lookahead == '*') ADVANCE(260);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_alignat_STAR);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_alignedat);
      if (lookahead == '*') ADVANCE(262);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_alignedat_STAR);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_gather);
      if (lookahead == '*') ADVANCE(264);
      if (lookahead == 'e') ADVANCE(101);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_gather_STAR);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_gathered);
      if (lookahead == '*') ADVANCE(266);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_gathered_STAR);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_flalign);
      if (lookahead == '*') ADVANCE(268);
      if ((!eof && set_contains(sym_word_character_set_1, 10, lookahead))) ADVANCE(190);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_flalign_STAR);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_command_name);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        ')', 215,
        'A', 296,
        'B', 783,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        ']', 212,
        'a', 434,
        'b', 601,
        'c', 328,
        'd', 540,
        'e', 520,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 541,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        ')', 215,
        'A', 296,
        'B', 783,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 601,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 541,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        ')', 215,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        ']', 212,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        ')', 215,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 434,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        ')', 215,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 520,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        ')', 215,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        ')', 215,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 783,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        ']', 212,
        'a', 435,
        'b', 601,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 541,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 783,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 601,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 541,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 783,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 601,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 541,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        ']', 212,
        'a', 434,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        ']', 212,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 520,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        ']', 212,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        ']', 212,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 520,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 520,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 435,
        'b', 602,
        'c', 328,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 701,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 333,
        'r', 542,
        's', 606,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 436,
        'b', 790,
        'c', 329,
        'd', 540,
        'e', 521,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 702,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 767,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 436,
        'b', 790,
        'c', 329,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 702,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 767,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 437,
        'b', 790,
        'c', 329,
        'd', 540,
        'e', 521,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 702,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 767,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 437,
        'b', 790,
        'c', 329,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 702,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 767,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 437,
        'b', 602,
        'c', 329,
        'd', 540,
        'e', 520,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 702,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 767,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 437,
        'b', 602,
        'c', 329,
        'd', 540,
        'e', 520,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 702,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 767,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 437,
        'b', 602,
        'c', 329,
        'd', 540,
        'e', 521,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 702,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 767,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        '(', 214,
        'A', 296,
        'B', 801,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        '[', 211,
        'a', 437,
        'b', 602,
        'c', 329,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 702,
        'l', 330,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 767,
        't', 650,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(326);
      if (lookahead == 'c') ADVANCE(1770);
      if (lookahead == 'u') ADVANCE(1379);
      if (lookahead == 'v') ADVANCE(1182);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1108);
      if (lookahead == 'D') ADVANCE(1180);
      if (lookahead == 'E') ADVANCE(1062);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1117);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1118);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1119);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1122);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1125);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1126);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1280);
      if (lookahead == 'c') ADVANCE(1281);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1162);
      if (lookahead == 'D') ADVANCE(1183);
      if (lookahead == 'E') ADVANCE(1096);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1166);
      if (lookahead == 'D') ADVANCE(1186);
      if (lookahead == 'E') ADVANCE(1098);
      if (lookahead == 'M') ADVANCE(365);
      if (lookahead == 'P') ADVANCE(396);
      if (lookahead == 'R') ADVANCE(1110);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1170);
      if (lookahead == 'E') ADVANCE(1091);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1172);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1173);
      if (lookahead == 'E') ADVANCE(1092);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1174);
      if (lookahead == 'E') ADVANCE(1093);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1175);
      if (lookahead == 'E') ADVANCE(1094);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1176);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1177);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1178);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'C') ADVANCE(1179);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'D') ADVANCE(657);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'D') ADVANCE(1188);
      if (lookahead == 'E') ADVANCE(1512);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'D') ADVANCE(1190);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'D') ADVANCE(1200);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'D') ADVANCE(1201);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'D') ADVANCE(1202);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'I') ADVANCE(1032);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'L') ADVANCE(327);
      if (lookahead == 'l') ADVANCE(1321);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'O') ADVANCE(1220);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'P') ADVANCE(401);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'R') ADVANCE(724);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'S') ADVANCE(1694);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1209);
      if (lookahead == 'h') ADVANCE(376);
      if (lookahead == 'i') ADVANCE(1388);
      if (lookahead == 'o') ADVANCE(902);
      if (lookahead == 'p') ADVANCE(400);
      if (lookahead == 'r') ADVANCE(611);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1209);
      if (lookahead == 'i') ADVANCE(1388);
      if (lookahead == 'o') ADVANCE(902);
      if (lookahead == 'p') ADVANCE(400);
      if (lookahead == 'r') ADVANCE(611);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(421);
      if (lookahead == 'c') ADVANCE(1027);
      if (lookahead == 'e') ADVANCE(728);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(421);
      if (lookahead == 'c') ADVANCE(1027);
      if (lookahead == 'e') ADVANCE(1343);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(963);
      if (lookahead == 'e') ADVANCE(1498);
      if (lookahead == 'o') ADVANCE(444);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(748);
      if (lookahead == 'n') ADVANCE(1199);
      if (lookahead == 'r') ADVANCE(1143);
      if (lookahead == 'v') ADVANCE(1193);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(749);
      if (lookahead == 'n') ADVANCE(1199);
      if (lookahead == 'r') ADVANCE(1143);
      if (lookahead == 'v') ADVANCE(1193);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1317);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(971);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(750);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1204);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1344);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(747);
      if (lookahead == 'e') ADVANCE(1085);
      if (lookahead == 't') ADVANCE(56);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(449);
      if (lookahead == 'c') ADVANCE(1159);
      if (lookahead == 'e') ADVANCE(1087);
      if (lookahead == 'g') ADVANCE(907);
      if (lookahead == 'l') ADVANCE(377);
      if (lookahead == 't') ADVANCE(774);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1207);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(445);
      if (lookahead == 'g') ADVANCE(730);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(427);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1060);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1289);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(925);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1028);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1030);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1033);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1236);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(880);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(881);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1035);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1249);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1037);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1242);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(885);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1039);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1040);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1041);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1043);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1044);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1253);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1380);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1046);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1254);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1047);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(890);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1048);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1049);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(893);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(896);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1258);
      if (lookahead == 'n') ADVANCE(1197);
      if (lookahead == 'r') ADVANCE(1106);
      if (lookahead == 'v') ADVANCE(1185);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1432);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1223);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(423);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1328);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1210);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1384);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1221);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1061);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(965);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1211);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1386);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1064);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(966);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1266);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(755);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1213);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1275);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(967);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(758);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1279);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1404);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(824);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1063);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1066);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1067);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(760);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(489);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(761);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(762);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(763);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1319);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(431);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(432);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(433);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1102);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1103);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1104);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(726);
      if (lookahead == 'p') ADVANCE(614);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(727);
      if (lookahead == 'p') ADVANCE(614);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(904);
      if (lookahead == 'g') ADVANCE(746);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(904);
      if (lookahead == 'g') ADVANCE(752);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(904);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(791);
      if (lookahead == 'c') ADVANCE(771);
      if (lookahead == 'p') ADVANCE(388);
      if (lookahead == 's') ADVANCE(616);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(791);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(1341);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(1468);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(628);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(1300);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(641);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(380);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(1138);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(1141);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(919);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(1282);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(1304);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(385);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(948);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(949);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(950);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1769);
      if (lookahead == 'd') ADVANCE(503);
      if (lookahead == 'n') ADVANCE(504);
      if (lookahead == 'u') ADVANCE(1342);
      if (lookahead == 'v') ADVANCE(1191);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1769);
      if (lookahead == 'd') ADVANCE(503);
      if (lookahead == 'u') ADVANCE(1342);
      if (lookahead == 'v') ADVANCE(1191);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1769);
      if (lookahead == 'd') ADVANCE(523);
      if (lookahead == 'n') ADVANCE(504);
      if (lookahead == 'u') ADVANCE(1342);
      if (lookahead == 'v') ADVANCE(1191);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1769);
      if (lookahead == 'd') ADVANCE(523);
      if (lookahead == 'u') ADVANCE(1342);
      if (lookahead == 'v') ADVANCE(1191);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(833);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(66);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1719);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1718);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1717);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1463);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(809);
      if (lookahead == 't') ADVANCE(682);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(860);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(903);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(901);
      if (lookahead == 'p') ADVANCE(1457);
      if (lookahead == 't') ADVANCE(612);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(901);
      if (lookahead == 'p') ADVANCE(1457);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1303);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1323);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(381);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(596);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1146);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(913);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1283);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(811);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(927);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1148);
      if (lookahead == 'r') ADVANCE(629);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(814);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(929);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1150);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(815);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(817);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(818);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(819);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(821);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(822);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(823);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(825);
      if (lookahead == 'p') ADVANCE(402);
      if (lookahead == 'r') ADVANCE(626);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(826);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(827);
      if (lookahead == 'f') ADVANCE(1480);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(828);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(829);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(830);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(831);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(832);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(834);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(835);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(836);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(837);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(838);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(839);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(840);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(841);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(842);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(843);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(844);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1472);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(861);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(928);
      if (lookahead == 'f') ADVANCE(1674);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1434);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1476);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1436);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1437);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1164);
      if (lookahead == 'e') ADVANCE(1089);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1168);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1477);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1478);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1479);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1481);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1482);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1483);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(417);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(81);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(230);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(298);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1653);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1655);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(316);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1657);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1663);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1659);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1664);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1666);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1665);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1667);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1668);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1670);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(1669);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(613);
      if (lookahead == 'n') ADVANCE(505);
      if (lookahead == 'q') ADVANCE(1262);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(613);
      if (lookahead == 'q') ADVANCE(1262);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(622);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(418);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(620);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(344);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(553);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(558);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(644);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(597);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(299);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(300);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(627);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(406);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(407);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(408);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(446);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1497);
      if (lookahead == 'o') ADVANCE(1424);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1042);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1502);
      if (lookahead == 'v') ADVANCE(1189);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(490);
      if (lookahead == 'o') ADVANCE(443);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(704);
      if (lookahead == 'i') ADVANCE(745);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(704);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1203);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1561);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1559);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(304);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(458);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1535);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1562);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(306);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1714);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1713);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(317);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(325);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1603);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1712);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(48);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1540);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1543);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1602);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1599);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1613);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1615);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1605);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1609);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1594);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1611);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1598);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1612);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1579);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1590);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1582);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1606);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1614);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1604);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1608);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1593);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1610);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1648);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1589);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1617);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1596);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1575);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1646);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1618);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1607);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1587);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1616);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1595);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1597);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1537);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1591);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1651);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1650);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1538);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1544);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1541);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1549);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1545);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1246);
      if (lookahead == 'o') ADVANCE(900);
      if (lookahead == 'r') ADVANCE(609);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(744);
      if (lookahead == 'i') ADVANCE(414);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(744);
      if (lookahead == 'i') ADVANCE(415);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(705);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(951);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(318);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(491);
      if (lookahead == 'h') ADVANCE(1144);
      if (lookahead == 'm') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(412);
      if (lookahead == 'v') ADVANCE(1194);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1326);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1499);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(706);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1084);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(707);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1301);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(708);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1316);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(709);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(439);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(710);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(711);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1331);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(712);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(509);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1345);
      if (lookahead == 's') ADVANCE(1692);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(713);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(955);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(455);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(714);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(496);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(870);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(715);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1234);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1156);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(716);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(958);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(717);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1248);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(718);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1235);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(719);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1250);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(720);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(875);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(721);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(722);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(729);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(723);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1440);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1298);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1245);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1370);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1503);
      if (lookahead == 'i') ADVANCE(1381);
      if (lookahead == 'v') ADVANCE(1195);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1050);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1327);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(351);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1504);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1051);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1329);
      if (lookahead == 'i') ADVANCE(1324);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(912);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1273);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1505);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1070);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1506);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1052);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1053);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1278);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1508);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1054);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1509);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1055);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1510);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1056);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1511);
      if (lookahead == 'i') ADVANCE(1381);
      if (lookahead == 'v') ADVANCE(1195);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1057);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1058);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1285);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1287);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1157);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1095);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(461);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1071);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1073);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(464);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(474);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(479);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(481);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(484);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1307);
      if (lookahead == 'o') ADVANCE(930);
      if (lookahead == 'r') ADVANCE(618);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(493);
      if (lookahead == 'u') ADVANCE(419);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1085);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1309);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1086);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(494);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1088);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1090);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1500);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1097);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1099);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(1100);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(319);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(320);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'e') ADVANCE(321);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(725);
      if (lookahead == 'm') ADVANCE(1226);
      if (lookahead == 'n') ADVANCE(447);
      if (lookahead == 't') ADVANCE(604);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(725);
      if (lookahead == 'm') ADVANCE(1226);
      if (lookahead == 'n') ADVANCE(447);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(725);
      if (lookahead == 'm') ADVANCE(1226);
      if (lookahead == 'n') ADVANCE(448);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1620);
      if (lookahead == 'n') ADVANCE(608);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1632);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1623);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1630);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1676);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1675);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1796);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1622);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1677);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1621);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1624);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1626);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1635);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1634);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1637);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1636);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1642);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1638);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1628);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1644);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1458);
      if (lookahead == 'l') ADVANCE(1111);
      if (lookahead == 's') ADVANCE(778);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(347);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(807);
      if (lookahead == 'i') ADVANCE(1010);
      if (lookahead == 'p') ADVANCE(346);
      if (lookahead == 's') ADVANCE(687);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(807);
      if (lookahead == 'i') ADVANCE(1010);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1346);
      if (lookahead == 't') ADVANCE(1678);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1268);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(908);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1464);
      if (lookahead == 'l') ADVANCE(1113);
      if (lookahead == 's') ADVANCE(779);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1466);
      if (lookahead == 'l') ADVANCE(1115);
      if (lookahead == 's') ADVANCE(780);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1469);
      if (lookahead == 'l') ADVANCE(1134);
      if (lookahead == 's') ADVANCE(781);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1471);
      if (lookahead == 'l') ADVANCE(1136);
      if (lookahead == 's') ADVANCE(782);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(736);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(863);
      if (lookahead == 'l') ADVANCE(218);
      if (lookahead == 'r') ADVANCE(223);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1747);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1746);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1745);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1548);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1773);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1772);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(751);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(792);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(772);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(867);
      if (lookahead == 'l') ADVANCE(217);
      if (lookahead == 'r') ADVANCE(222);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1257);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(547);
      if (lookahead == 'r') ADVANCE(340);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(547);
      if (lookahead == 'r') ADVANCE(688);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(658);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(864);
      if (lookahead == 'l') ADVANCE(218);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(868);
      if (lookahead == 'l') ADVANCE(217);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(579);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(584);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(591);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(593);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(594);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(595);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1292);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(664);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(674);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(1297);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'g') ADVANCE(675);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(72);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(324);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(74);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1144);
      if (lookahead == 'm') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(413);
      if (lookahead == 'v') ADVANCE(1194);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1513);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(453);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1112);
      if (lookahead == 'o') ADVANCE(469);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(338);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1349);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(803);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(631);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1135);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1137);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(676);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1149);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1151);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1152);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1154);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'h') ADVANCE(1155);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(735);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(1198);
      if (lookahead == 'o') ADVANCE(1114);
      if (lookahead == 't') ADVANCE(1496);
      if (lookahead == 'u') ADVANCE(946);
      if (lookahead == 'v') ADVANCE(1192);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(857);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1722);
      if (lookahead == 'v') ADVANCE(1734);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1721);
      if (lookahead == 'v') ADVANCE(1733);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1720);
      if (lookahead == 'v') ADVANCE(1732);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1385);
      if (lookahead == 'p') ADVANCE(337);
      if (lookahead == 'r') ADVANCE(603);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(415);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(428);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1020);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(532);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(422);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1252);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(952);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(969);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(416);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1025);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1158);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(743);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1068);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(450);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1009);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(526);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1291);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(917);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1294);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1391);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1120);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1393);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1123);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1277);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1394);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1395);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1132);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1396);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1397);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1398);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1139);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1399);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1400);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1401);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1286);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1402);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1403);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1405);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1406);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1407);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1408);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1409);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1410);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1411);
      if (lookahead == 'o') ADVANCE(924);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1412);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1413);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1414);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1415);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1416);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1417);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1418);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1419);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1420);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1421);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1422);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1423);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1306);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1069);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(429);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1310);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1311);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1312);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1313);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1314);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1315);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1318);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1320);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'k') ADVANCE(1530);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'k') ADVANCE(1699);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'k') ADVANCE(1330);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'k') ADVANCE(389);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'k') ADVANCE(393);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1795);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(220);
      if (lookahead == 'r') ADVANCE(225);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(220);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1697);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1696);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(219);
      if (lookahead == 'r') ADVANCE(224);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(219);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1695);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1619);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1753);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1752);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1751);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1581);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1652);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1756);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1750);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1755);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1749);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1708);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1707);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1716);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1754);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1748);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1706);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1715);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1744);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1743);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1742);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1711);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1781);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1775);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1710);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1780);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1774);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1709);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1779);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1778);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1205);
      if (lookahead == 'u') ADVANCE(1435);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(456);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1465);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1107);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(391);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(800);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1473);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1218);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1109);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(794);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(871);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1130);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(872);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(804);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(378);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(873);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(548);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(906);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(559);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(583);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(605);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(599);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1219);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1131);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(921);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1133);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1339);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1140);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1467);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(394);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1470);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(459);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1474);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(848);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(1475);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(463);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(465);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(466);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(468);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(470);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(472);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(473);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(475);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(476);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(477);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(482);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(487);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(939);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(945);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(698);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(699);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'l') ADVANCE(700);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(76);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(322);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(1554);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(1738);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(1782);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(1556);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(1555);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(1784);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(1557);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(335);
      if (lookahead == 'v') ADVANCE(1187);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(425);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(968);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(546);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(651);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(551);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(552);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(556);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(349);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(847);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(350);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(625);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(382);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(354);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(386);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(356);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(359);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(360);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(361);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(362);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(363);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(366);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(368);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(370);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(371);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(426);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(970);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(655);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(972);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(660);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(973);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(662);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(974);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(975);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(666);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(976);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(677);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(977);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(668);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(978);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(670);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(979);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(672);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(980);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(673);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(981);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(982);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(983);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(984);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(845);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(1227);
      if (lookahead == 'n') ADVANCE(457);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(679);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(680);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(690);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(692);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(693);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(413);
      if (lookahead == 'v') ADVANCE(1194);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(695);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(696);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'm') ADVANCE(697);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(229);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1558);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(64);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(68);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(70);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(858);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(859);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(336);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(525);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(737);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(506);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(738);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1224);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(507);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(739);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(508);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(741);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(510);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(742);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(511);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(512);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(513);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(694);
      if (lookahead == 'q') ADVANCE(1456);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(514);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(515);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1387);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(516);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(517);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(518);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(519);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1433);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1364);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1371);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1392);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1373);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1374);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1375);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1376);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1377);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1524);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(753);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(530);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1487);
      if (lookahead == 'x') ADVANCE(1222);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(754);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(531);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(678);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(756);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(757);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1446);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1225);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1429);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1430);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(989);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1431);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(991);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(994);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1441);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(460);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1011);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1012);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(998);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1000);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1002);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1004);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(478);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(483);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1445);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1488);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1448);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1489);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1451);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1490);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1491);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1492);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1493);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1447);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1494);
      if (lookahead == 'x') ADVANCE(1229);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1450);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1495);
      if (lookahead == 'x') ADVANCE(1230);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1453);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1455);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(1198);
      if (lookahead == 'o') ADVANCE(1114);
      if (lookahead == 't') ADVANCE(1496);
      if (lookahead == 'u') ADVANCE(946);
      if (lookahead == 'v') ADVANCE(1192);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(533);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(534);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'n') ADVANCE(535);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1501);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1484);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1232);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(962);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1325);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(420);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1029);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1233);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1031);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1378);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1034);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(953);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1208);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1212);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1214);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1021);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(956);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1215);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1022);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(957);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1216);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1217);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(959);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1059);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1072);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1237);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1238);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1023);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1239);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1036);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1240);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1038);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1241);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(882);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1024);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1243);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(886);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1244);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1486);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1259);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1460);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(910);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1263);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(922);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(926);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1270);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1152:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1271);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1153:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1272);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1154:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1274);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1155:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1276);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1156:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1284);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1157:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1288);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(759);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1159:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(986);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1074);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1161:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(462);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(988);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1163:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1075);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1164:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(990);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1080);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1166:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(992);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1167:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1081);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1168:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(993);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1082);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(995);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1083);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1172:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(997);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(999);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1174:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1001);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1003);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1005);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1177:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1006);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1007);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1179:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1008);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(488);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1181:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1078);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1182:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(934);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(497);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1184:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1079);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1185:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(935);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(498);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1187:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(936);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1188:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(499);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(937);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1190:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(492);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(938);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1192:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(940);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1193:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(941);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1194:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(942);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1195:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(943);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(944);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1197:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1449);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1198:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1452);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(1454);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1200:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(500);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(501);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(502);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(343);
      if (lookahead == 't') ADVANCE(785);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1204:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(62);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1585);
      if (lookahead == 't') ADVANCE(1584);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1698);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(764);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1208:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1515);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1209:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1383);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(768);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1211:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(773);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1212:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1517);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1213:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(766);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1214:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1519);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1520);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1216:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1521);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1522);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1218:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(891);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1219:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(894);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(647);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(598);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1222:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(348);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1223:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1390);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1224:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1461);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1225:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1462);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1226:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1147);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1227:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1153);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1228:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(404);
      if (lookahead == 'r') ADVANCE(640);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1229:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(409);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(410);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(411);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1788);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1536);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(786);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(60);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1577);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1791);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1789);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1239:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1790);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1573);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1571);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1583);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1786);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1661);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1245:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1680);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1246:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(424);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1247:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1526);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1248:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(787);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1528);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1250:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(788);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1251:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(862);
      if (lookahead == 's') ADVANCE(543);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1332);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1253:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1514);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1516);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1255:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(617);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1518);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(342);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1258:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(610);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1259:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1427);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1260:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1116);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(452);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(623);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1263:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1350);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1264:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(874);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1265:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1121);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1266:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1353);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1267:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1124);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1268:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1127);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1355);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1270:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1356);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1359);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1272:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1363);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(632);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1274:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1366);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1275:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(550);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1276:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1368);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1277:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(554);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1278:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(634);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1279:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(646);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1280:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(636);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1281:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(638);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1282:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(619);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1283:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(642);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1284:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(624);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1285:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(643);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1286:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(621);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1287:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(645);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1288:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(633);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1289:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(403);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1290:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(352);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1291:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1333);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1292:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(379);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1293:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(353);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1294:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1336);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1295:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(384);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1296:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(358);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1297:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(390);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1298:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(375);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1299:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(369);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1300:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(364);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1301:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1438);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1302:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(372);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1303:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1128);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1304:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(367);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1305:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(373);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1306:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1129);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1307:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(430);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1308:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1527);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1309:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1439);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1310:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1160);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1311:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1163);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1312:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1165);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1313:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1167);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1314:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1169);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1315:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1171);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1316:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(486);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1317:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1443);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1318:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1181);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1319:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1444);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1320:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(1184);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1321:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1693);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1322:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1539);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1323:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1547);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1324:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1206);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1325:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1340);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1326:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(440);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1327:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(441);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1328:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1322);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1329:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(442);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1330:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(451);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1331:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1145);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1332:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1357);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1333:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1358);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1334:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(630);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1335:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(635);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1336:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1361);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1337:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(639);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1338:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1426);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1339:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(557);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1340:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(355);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1341:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(691);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1342:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(770);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1343:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1678);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1344:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(769);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1345:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1679);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1346:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(216);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1347:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(226);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1348:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1542);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1349:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(221);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1350:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1552);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1351:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1702);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1352:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1701);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1353:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(58);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1354:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1700);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1355:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1741);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1356:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1740);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1357:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1705);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1358:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1704);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1359:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1739);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1360:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1586);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1361:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1703);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1362:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(227);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1363:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1553);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1364:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(307);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1365:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1592);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1366:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1777);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1367:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1551);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1368:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1776);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1369:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1550);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1370:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1787);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1371:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1682);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1372:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1373:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1683);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1374:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1684);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1375:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1685);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1376:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1687);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1377:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1686);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1378:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(471);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1379:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1161);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1380:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(765);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1381:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(915);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1382:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1525);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1383:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(810);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1384:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(796);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1385:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(544);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1386:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(797);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1387:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1247);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1388:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(545);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1389:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(438);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1390:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(637);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1391:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(549);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1392:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1256);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1393:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(555);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1394:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(560);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1395:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(561);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1396:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(562);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1397:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(563);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1398:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(564);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1399:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(565);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1400:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(566);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1401:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(567);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1402:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(568);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1403:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(569);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1404:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(570);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1405:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(571);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1406:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(572);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1407:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(573);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1408:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(574);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1409:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(575);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1410:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(576);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1411:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(577);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1412:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(578);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1413:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(580);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1414:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(581);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1415:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(582);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1416:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(585);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1417:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(586);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1418:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(587);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1419:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(588);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1420:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(589);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1421:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(590);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1422:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(592);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1423:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(648);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1424:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(681);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1425:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(775);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1426:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(308);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1427:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(802);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1428:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(918);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1429:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(301);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1430:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(302);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1431:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(303);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1432:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1142);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1433:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(454);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1434:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(812);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1435:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(776);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1436:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(816);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1437:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(820);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1438:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(665);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1439:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(669);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1440:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(777);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1441:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(1308);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1442:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(467);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1443:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(480);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1444:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(485);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1445:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(309);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1446:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(689);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1447:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(312);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1448:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(310);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1449:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(683);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1450:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(313);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1451:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(311);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1452:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(684);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1453:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(314);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1454:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(685);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1455:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(315);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1456:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(813);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1457:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1348);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1458:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(909);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1459:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1425);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1460:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1261);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1461:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1367);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1462:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1369);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1463:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(964);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1464:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(911);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1465:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(527);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1466:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(914);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1467:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(528);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1468:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1338);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1469:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(916);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1470:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(529);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1471:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(923);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1472:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(987);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1473:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1299);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1474:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1302);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1475:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1305);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1476:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(996);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1477:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1013);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1478:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1014);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1479:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1015);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1480:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(947);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1481:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1017);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1482:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1018);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1483:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1019);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1484:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(805);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1485:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(740);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1486:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(793);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1487:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(846);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1488:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(849);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1489:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(850);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1490:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(851);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1491:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(852);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1492:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(853);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1493:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(854);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1494:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(855);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1495:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(856);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1496:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'v') ADVANCE(1196);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1497:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'w') ADVANCE(297);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1498:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'w') ADVANCE(341);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1499:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'w') ADVANCE(495);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1500:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'w') ADVANCE(305);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1501:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1792);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1502:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1442);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1503:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1347);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1504:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1351);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1505:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1352);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1506:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1354);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1507:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1360);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1508:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1362);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1509:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1365);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1510:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1372);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1511:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1389);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1512:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'x') ADVANCE(1231);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1513:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1546);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1514:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1793);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1515:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1671);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1516:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1794);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1517:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1672);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1518:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1691);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1519:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1673);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1520:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1688);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1521:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1689);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1522:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(1690);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1523:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(961);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1524:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(954);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1525:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(920);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1526:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(733);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1527:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(734);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1528:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(663);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1529:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'y') ADVANCE(985);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1530:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'z') ADVANCE(932);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1531);
      END_STATE();
    case 1531:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1532:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        'A', 296,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        'a', 437,
        'b', 798,
        'c', 329,
        'd', 540,
        'e', 521,
        'f', 784,
        'g', 522,
        'h', 1255,
        'i', 703,
        'l', 331,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 1016,
        't', 671,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 1533:
      ACCEPT_TOKEN(sym_command_name);
      ADVANCE_MAP(
        'A', 296,
        'C', 789,
        'D', 536,
        'G', 323,
        'N', 537,
        'P', 374,
        'R', 538,
        'S', 960,
        'T', 539,
        'V', 600,
        'a', 437,
        'b', 798,
        'c', 329,
        'd', 540,
        'e', 521,
        'f', 1101,
        'g', 522,
        'h', 1255,
        'i', 703,
        'l', 331,
        'm', 339,
        'n', 332,
        'p', 334,
        'r', 542,
        's', 1016,
        't', 671,
        'u', 1251,
        'v', 686,
        'x', 524,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 1534:
      ACCEPT_TOKEN(sym_command_name);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(269);
      END_STATE();
    case 1535:
      ACCEPT_TOKEN(anon_sym_BSLASHtitle);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1536:
      ACCEPT_TOKEN(anon_sym_BSLASHauthor);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1537:
      ACCEPT_TOKEN(anon_sym_BSLASHusepackage);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1538:
      ACCEPT_TOKEN(anon_sym_BSLASHRequirePackage);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1539:
      ACCEPT_TOKEN(anon_sym_BSLASHdocumentclass);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1540:
      ACCEPT_TOKEN(anon_sym_BSLASHinclude);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1265);
      if (lookahead == 'g') ADVANCE(1295);
      if (lookahead == 'i') ADVANCE(1026);
      if (lookahead == 's') ADVANCE(1485);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1541:
      ACCEPT_TOKEN(anon_sym_BSLASHsubfileinclude);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1542:
      ACCEPT_TOKEN(anon_sym_BSLASHinput);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1260);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1543:
      ACCEPT_TOKEN(anon_sym_BSLASHsubfile);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1077);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1544:
      ACCEPT_TOKEN(anon_sym_BSLASHaddbibresource);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1545:
      ACCEPT_TOKEN(anon_sym_BSLASHbibliographystyle);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1546:
      ACCEPT_TOKEN(anon_sym_BSLASHbibliography);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1382);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1547:
      ACCEPT_TOKEN(anon_sym_BSLASHincludegraphics);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1548:
      ACCEPT_TOKEN(anon_sym_BSLASHincludesvg);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1549:
      ACCEPT_TOKEN(anon_sym_BSLASHincludeinkscape);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1550:
      ACCEPT_TOKEN(anon_sym_BSLASHverbatiminput);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1551:
      ACCEPT_TOKEN(anon_sym_BSLASHVerbatimInput);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1552:
      ACCEPT_TOKEN(anon_sym_BSLASHimport);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1553:
      ACCEPT_TOKEN(anon_sym_BSLASHsubimport);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1267);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1554:
      ACCEPT_TOKEN(anon_sym_BSLASHinputfrom);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1555:
      ACCEPT_TOKEN(anon_sym_BSLASHsubimportfrom);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1556:
      ACCEPT_TOKEN(anon_sym_BSLASHincludefrom);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1557:
      ACCEPT_TOKEN(anon_sym_BSLASHsubincludefrom);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1558:
      ACCEPT_TOKEN(anon_sym_BSLASHcaption);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1559:
      ACCEPT_TOKEN(anon_sym_BSLASHcite);
      ADVANCE_MAP(
        '*', 1560,
        'A', 1567,
        'R', 1568,
        'S', 1569,
        'a', 899,
        'd', 395,
        'p', 1564,
        't', 1563,
        'u', 1264,
        'y', 653,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1560:
      ACCEPT_TOKEN(anon_sym_BSLASHcite_STAR);
      END_STATE();
    case 1561:
      ACCEPT_TOKEN(anon_sym_BSLASHCite);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'a') ADVANCE(1459);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1562:
      ACCEPT_TOKEN(anon_sym_BSLASHnocite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1563:
      ACCEPT_TOKEN(anon_sym_BSLASHcitet);
      if (lookahead == '*') ADVANCE(1565);
      if (lookahead == 'e') ADVANCE(1507);
      if (lookahead == 'i') ADVANCE(1428);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1564:
      ACCEPT_TOKEN(anon_sym_BSLASHcitep);
      if (lookahead == '*') ADVANCE(1566);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1565:
      ACCEPT_TOKEN(anon_sym_BSLASHcitet_STAR);
      END_STATE();
    case 1566:
      ACCEPT_TOKEN(anon_sym_BSLASHcitep_STAR);
      END_STATE();
    case 1567:
      ACCEPT_TOKEN(anon_sym_BSLASHciteA);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1568:
      ACCEPT_TOKEN(anon_sym_BSLASHciteR);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1569:
      ACCEPT_TOKEN(anon_sym_BSLASHciteS);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1570:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyearR);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1571:
      ACCEPT_TOKEN(anon_sym_BSLASHciteauthor);
      if (lookahead == '*') ADVANCE(1572);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1572:
      ACCEPT_TOKEN(anon_sym_BSLASHciteauthor_STAR);
      END_STATE();
    case 1573:
      ACCEPT_TOKEN(anon_sym_BSLASHCiteauthor);
      if (lookahead == '*') ADVANCE(1574);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1574:
      ACCEPT_TOKEN(anon_sym_BSLASHCiteauthor_STAR);
      END_STATE();
    case 1575:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetitle);
      if (lookahead == '*') ADVANCE(1576);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1576:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetitle_STAR);
      END_STATE();
    case 1577:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyear);
      if (lookahead == '*') ADVANCE(1578);
      if (lookahead == 'R') ADVANCE(1570);
      if (lookahead == 'p') ADVANCE(357);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1578:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyear_STAR);
      END_STATE();
    case 1579:
      ACCEPT_TOKEN(anon_sym_BSLASHcitedate);
      if (lookahead == '*') ADVANCE(1580);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1580:
      ACCEPT_TOKEN(anon_sym_BSLASHcitedate_STAR);
      END_STATE();
    case 1581:
      ACCEPT_TOKEN(anon_sym_BSLASHciteurl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1582:
      ACCEPT_TOKEN(anon_sym_BSLASHfullcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1583:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyearpar);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1584:
      ACCEPT_TOKEN(anon_sym_BSLASHcitealt);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1585:
      ACCEPT_TOKEN(anon_sym_BSLASHcitealp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1586:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetext);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1587:
      ACCEPT_TOKEN(anon_sym_BSLASHparencite);
      if (lookahead == '*') ADVANCE(1588);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1588:
      ACCEPT_TOKEN(anon_sym_BSLASHparencite_STAR);
      END_STATE();
    case 1589:
      ACCEPT_TOKEN(anon_sym_BSLASHParencite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1590:
      ACCEPT_TOKEN(anon_sym_BSLASHfootcite);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 't') ADVANCE(667);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1591:
      ACCEPT_TOKEN(anon_sym_BSLASHfootfullcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1592:
      ACCEPT_TOKEN(anon_sym_BSLASHfootcitetext);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1593:
      ACCEPT_TOKEN(anon_sym_BSLASHtextcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1594:
      ACCEPT_TOKEN(anon_sym_BSLASHTextcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1595:
      ACCEPT_TOKEN(anon_sym_BSLASHsmartcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1596:
      ACCEPT_TOKEN(anon_sym_BSLASHSmartcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1597:
      ACCEPT_TOKEN(anon_sym_BSLASHsupercite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1598:
      ACCEPT_TOKEN(anon_sym_BSLASHautocite);
      if (lookahead == '*') ADVANCE(1600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1599:
      ACCEPT_TOKEN(anon_sym_BSLASHAutocite);
      if (lookahead == '*') ADVANCE(1601);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1600:
      ACCEPT_TOKEN(anon_sym_BSLASHautocite_STAR);
      END_STATE();
    case 1601:
      ACCEPT_TOKEN(anon_sym_BSLASHAutocite_STAR);
      END_STATE();
    case 1602:
      ACCEPT_TOKEN(anon_sym_BSLASHvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1603:
      ACCEPT_TOKEN(anon_sym_BSLASHVolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1604:
      ACCEPT_TOKEN(anon_sym_BSLASHpvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1605:
      ACCEPT_TOKEN(anon_sym_BSLASHPvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1606:
      ACCEPT_TOKEN(anon_sym_BSLASHfvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1607:
      ACCEPT_TOKEN(anon_sym_BSLASHftvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1608:
      ACCEPT_TOKEN(anon_sym_BSLASHsvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1609:
      ACCEPT_TOKEN(anon_sym_BSLASHSvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1610:
      ACCEPT_TOKEN(anon_sym_BSLASHtvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1611:
      ACCEPT_TOKEN(anon_sym_BSLASHTvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1612:
      ACCEPT_TOKEN(anon_sym_BSLASHavolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1613:
      ACCEPT_TOKEN(anon_sym_BSLASHAvolcite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1614:
      ACCEPT_TOKEN(anon_sym_BSLASHnotecite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1615:
      ACCEPT_TOKEN(anon_sym_BSLASHNotecite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1616:
      ACCEPT_TOKEN(anon_sym_BSLASHpnotecite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1617:
      ACCEPT_TOKEN(anon_sym_BSLASHPnotecite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1618:
      ACCEPT_TOKEN(anon_sym_BSLASHfnotecite);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1619:
      ACCEPT_TOKEN(anon_sym_BSLASHlabel);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'c') ADVANCE(1228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1620:
      ACCEPT_TOKEN(anon_sym_BSLASHref);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1621:
      ACCEPT_TOKEN(anon_sym_BSLASHeqref);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1622:
      ACCEPT_TOKEN(anon_sym_BSLASHvref);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1623:
      ACCEPT_TOKEN(anon_sym_BSLASHVref);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1624:
      ACCEPT_TOKEN(anon_sym_BSLASHautoref);
      if (lookahead == '*') ADVANCE(1625);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1625:
      ACCEPT_TOKEN(anon_sym_BSLASHautoref_STAR);
      END_STATE();
    case 1626:
      ACCEPT_TOKEN(anon_sym_BSLASHpageref);
      if (lookahead == '*') ADVANCE(1627);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1627:
      ACCEPT_TOKEN(anon_sym_BSLASHpageref_STAR);
      END_STATE();
    case 1628:
      ACCEPT_TOKEN(anon_sym_BSLASHautopageref);
      if (lookahead == '*') ADVANCE(1629);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1629:
      ACCEPT_TOKEN(anon_sym_BSLASHautopageref_STAR);
      END_STATE();
    case 1630:
      ACCEPT_TOKEN(anon_sym_BSLASHcref);
      if (lookahead == '*') ADVANCE(1631);
      if (lookahead == 'r') ADVANCE(397);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1631:
      ACCEPT_TOKEN(anon_sym_BSLASHcref_STAR);
      END_STATE();
    case 1632:
      ACCEPT_TOKEN(anon_sym_BSLASHCref);
      if (lookahead == '*') ADVANCE(1633);
      if (lookahead == 'r') ADVANCE(345);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1633:
      ACCEPT_TOKEN(anon_sym_BSLASHCref_STAR);
      END_STATE();
    case 1634:
      ACCEPT_TOKEN(anon_sym_BSLASHcpageref);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(399);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1635:
      ACCEPT_TOKEN(anon_sym_BSLASHCpageref);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(398);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1636:
      ACCEPT_TOKEN(anon_sym_BSLASHnamecref);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1639);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1637:
      ACCEPT_TOKEN(anon_sym_BSLASHnameCref);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1640);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1638:
      ACCEPT_TOKEN(anon_sym_BSLASHlcnamecref);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(1641);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1639:
      ACCEPT_TOKEN(anon_sym_BSLASHnamecrefs);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1640:
      ACCEPT_TOKEN(anon_sym_BSLASHnameCrefs);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1641:
      ACCEPT_TOKEN(anon_sym_BSLASHlcnamecrefs);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1642:
      ACCEPT_TOKEN(anon_sym_BSLASHlabelcref);
      if (lookahead == '*') ADVANCE(1643);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1643:
      ACCEPT_TOKEN(anon_sym_BSLASHlabelcref_STAR);
      END_STATE();
    case 1644:
      ACCEPT_TOKEN(anon_sym_BSLASHlabelcpageref);
      if (lookahead == '*') ADVANCE(1645);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1645:
      ACCEPT_TOKEN(anon_sym_BSLASHlabelcpageref_STAR);
      END_STATE();
    case 1646:
      ACCEPT_TOKEN(anon_sym_BSLASHcrefrange);
      if (lookahead == '*') ADVANCE(1647);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1647:
      ACCEPT_TOKEN(anon_sym_BSLASHcrefrange_STAR);
      END_STATE();
    case 1648:
      ACCEPT_TOKEN(anon_sym_BSLASHCrefrange);
      if (lookahead == '*') ADVANCE(1649);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1649:
      ACCEPT_TOKEN(anon_sym_BSLASHCrefrange_STAR);
      END_STATE();
    case 1650:
      ACCEPT_TOKEN(anon_sym_BSLASHcpagerefrange);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1651:
      ACCEPT_TOKEN(anon_sym_BSLASHCpagerefrange);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1652:
      ACCEPT_TOKEN(anon_sym_BSLASHnewlabel);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1653:
      ACCEPT_TOKEN(anon_sym_BSLASHnewcommand);
      if (lookahead == '*') ADVANCE(1654);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1654:
      ACCEPT_TOKEN(anon_sym_BSLASHnewcommand_STAR);
      END_STATE();
    case 1655:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewcommand);
      if (lookahead == '*') ADVANCE(1656);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1656:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewcommand_STAR);
      END_STATE();
    case 1657:
      ACCEPT_TOKEN(anon_sym_BSLASHprovidecommand);
      if (lookahead == '*') ADVANCE(1658);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1658:
      ACCEPT_TOKEN(anon_sym_BSLASHprovidecommand_STAR);
      END_STATE();
    case 1659:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareRobustCommand);
      if (lookahead == '*') ADVANCE(1660);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1660:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareRobustCommand_STAR);
      END_STATE();
    case 1661:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareMathOperator);
      if (lookahead == '*') ADVANCE(1662);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1662:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareMathOperator_STAR);
      END_STATE();
    case 1663:
      ACCEPT_TOKEN(anon_sym_BSLASHNewDocumentCommand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1664:
      ACCEPT_TOKEN(anon_sym_BSLASHRenewDocumentCommand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1665:
      ACCEPT_TOKEN(anon_sym_BSLASHProvideDocumentCommand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1666:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareDocumentCommand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1667:
      ACCEPT_TOKEN(anon_sym_BSLASHNewExpandableDocumentCommand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1668:
      ACCEPT_TOKEN(anon_sym_BSLASHRenewExpandableDocumentCommand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1669:
      ACCEPT_TOKEN(anon_sym_BSLASHProvideExpandableDocumentCommand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1670:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareExpandableDocumentCommand);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1671:
      ACCEPT_TOKEN(anon_sym_BSLASHNewCommandCopy);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1672:
      ACCEPT_TOKEN(anon_sym_BSLASHRenewCommandCopy);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1673:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareCommandCopy);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1674:
      ACCEPT_TOKEN(anon_sym_BSLASHdef);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1065);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1675:
      ACCEPT_TOKEN(anon_sym_BSLASHgdef);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1676:
      ACCEPT_TOKEN(anon_sym_BSLASHedef);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1677:
      ACCEPT_TOKEN(anon_sym_BSLASHxdef);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1678:
      ACCEPT_TOKEN(anon_sym_BSLASHlet);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1679:
      ACCEPT_TOKEN(anon_sym_BSLASHglet);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1680:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclarePairedDelimiter);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'X') ADVANCE(1681);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1681:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclarePairedDelimiterX);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1682:
      ACCEPT_TOKEN(anon_sym_BSLASHnewenvironment);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1683:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewenvironment);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1684:
      ACCEPT_TOKEN(anon_sym_BSLASHNewDocumentEnvironment);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1685:
      ACCEPT_TOKEN(anon_sym_BSLASHRenewDocumentEnvironment);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1686:
      ACCEPT_TOKEN(anon_sym_BSLASHProvideDocumentEnvironment);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1687:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareDocumentEnvironment);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1688:
      ACCEPT_TOKEN(anon_sym_BSLASHNewEnvironmentCopy);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1689:
      ACCEPT_TOKEN(anon_sym_BSLASHRenewEnvironmentCopy);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1690:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareEnvironmentCopy);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1691:
      ACCEPT_TOKEN(anon_sym_BSLASHnewglossaryentry);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1692:
      ACCEPT_TOKEN(anon_sym_BSLASHgls);
      ADVANCE_MAP(
        '*', 269,
        'd', 656,
        'e', 1076,
        'f', 808,
        'l', 799,
        'n', 392,
        'p', 869,
        's', 1529,
        't', 661,
        'u', 1337,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1693:
      ACCEPT_TOKEN(anon_sym_BSLASHGls);
      ADVANCE_MAP(
        '*', 269,
        'd', 652,
        'e', 1045,
        'f', 806,
        'n', 387,
        'p', 866,
        's', 1523,
        't', 659,
        'u', 1335,
      );
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1694:
      ACCEPT_TOKEN(anon_sym_BSLASHGLS);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(607);
      if (lookahead == 'f') ADVANCE(795);
      if (lookahead == 'n') ADVANCE(383);
      if (lookahead == 'p') ADVANCE(865);
      if (lookahead == 't') ADVANCE(654);
      if (lookahead == 'u') ADVANCE(1334);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1695:
      ACCEPT_TOKEN(anon_sym_BSLASHglspl);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1296);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1696:
      ACCEPT_TOKEN(anon_sym_BSLASHGlspl);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1293);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1697:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSpl);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'u') ADVANCE(1290);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1698:
      ACCEPT_TOKEN(anon_sym_BSLASHglsdisp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1699:
      ACCEPT_TOKEN(anon_sym_BSLASHglslink);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1700:
      ACCEPT_TOKEN(anon_sym_BSLASHglstext);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1701:
      ACCEPT_TOKEN(anon_sym_BSLASHGlstext);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1702:
      ACCEPT_TOKEN(anon_sym_BSLASHGLStext);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1703:
      ACCEPT_TOKEN(anon_sym_BSLASHglsfirst);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(933);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1704:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsfirst);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(931);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1705:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSfirst);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(905);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1706:
      ACCEPT_TOKEN(anon_sym_BSLASHglsplural);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1707:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsplural);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1708:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSplural);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1709:
      ACCEPT_TOKEN(anon_sym_BSLASHglsfirstplural);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1710:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsfirstplural);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1711:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSfirstplural);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1712:
      ACCEPT_TOKEN(anon_sym_BSLASHglsname);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1713:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsname);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1714:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSname);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1715:
      ACCEPT_TOKEN(anon_sym_BSLASHglssymbol);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1716:
      ACCEPT_TOKEN(anon_sym_BSLASHGlssymbol);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1717:
      ACCEPT_TOKEN(anon_sym_BSLASHglsdesc);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1718:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsdesc);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1719:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSdesc);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1720:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseri);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1723);
      if (lookahead == 'v') ADVANCE(1729);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1721:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseri);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1724);
      if (lookahead == 'v') ADVANCE(1730);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1722:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseri);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1725);
      if (lookahead == 'v') ADVANCE(1731);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1723:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuserii);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1726);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1724:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuserii);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1727);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1725:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuserii);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1728);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1726:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseriii);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1727:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseriii);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1728:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseriii);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1729:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseriv);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1730:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseriv);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1731:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseriv);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1732:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuserv);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1735);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1733:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuserv);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1736);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1734:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuserv);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(1737);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1735:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuservi);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1736:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuservi);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1737:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuservi);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1738:
      ACCEPT_TOKEN(anon_sym_BSLASHnewacronym);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1739:
      ACCEPT_TOKEN(anon_sym_BSLASHacrshort);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(889);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1740:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrshort);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(888);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1741:
      ACCEPT_TOKEN(anon_sym_BSLASHACRshort);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(887);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1742:
      ACCEPT_TOKEN(anon_sym_BSLASHacrshortpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1743:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrshortpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1744:
      ACCEPT_TOKEN(anon_sym_BSLASHACRshortpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1745:
      ACCEPT_TOKEN(anon_sym_BSLASHacrlong);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(884);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1746:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrlong);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(879);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1747:
      ACCEPT_TOKEN(anon_sym_BSLASHACRlong);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(877);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1748:
      ACCEPT_TOKEN(anon_sym_BSLASHacrlongpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1749:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrlongpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1750:
      ACCEPT_TOKEN(anon_sym_BSLASHACRlongpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1751:
      ACCEPT_TOKEN(anon_sym_BSLASHacrfull);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(883);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1752:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrfull);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(878);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1753:
      ACCEPT_TOKEN(anon_sym_BSLASHACRfull);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(876);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1754:
      ACCEPT_TOKEN(anon_sym_BSLASHacrfullpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1755:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrfullpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1756:
      ACCEPT_TOKEN(anon_sym_BSLASHACRfullpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1757:
      ACCEPT_TOKEN(anon_sym_BSLASHacs);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1759);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1758:
      ACCEPT_TOKEN(anon_sym_BSLASHAcs);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1760);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1759:
      ACCEPT_TOKEN(anon_sym_BSLASHacsp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1760:
      ACCEPT_TOKEN(anon_sym_BSLASHAcsp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1761:
      ACCEPT_TOKEN(anon_sym_BSLASHacl);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1763);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1762:
      ACCEPT_TOKEN(anon_sym_BSLASHAcl);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1764);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1763:
      ACCEPT_TOKEN(anon_sym_BSLASHaclp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1764:
      ACCEPT_TOKEN(anon_sym_BSLASHAclp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1765:
      ACCEPT_TOKEN(anon_sym_BSLASHacf);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1767);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1766:
      ACCEPT_TOKEN(anon_sym_BSLASHAcf);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(1768);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1767:
      ACCEPT_TOKEN(anon_sym_BSLASHacfp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1768:
      ACCEPT_TOKEN(anon_sym_BSLASHAcfp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1769:
      ACCEPT_TOKEN(anon_sym_BSLASHac);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1765);
      if (lookahead == 'l') ADVANCE(1761);
      if (lookahead == 'p') ADVANCE(1771);
      if (lookahead == 'r') ADVANCE(732);
      if (lookahead == 's') ADVANCE(1757);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1770:
      ACCEPT_TOKEN(anon_sym_BSLASHAc);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'f') ADVANCE(1766);
      if (lookahead == 'l') ADVANCE(1762);
      if (lookahead == 'r') ADVANCE(731);
      if (lookahead == 's') ADVANCE(1758);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1771:
      ACCEPT_TOKEN(anon_sym_BSLASHacp);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1772:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentrylong);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(895);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1773:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentrylong);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(892);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1774:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentrylongpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1775:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentrylongpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1776:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryshort);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(898);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1777:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryshort);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'p') ADVANCE(897);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1778:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryshortpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1779:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryshortpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1780:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryfullpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1781:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryfullpl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1782:
      ACCEPT_TOKEN(anon_sym_BSLASHnewtheorem);
      if (lookahead == '*') ADVANCE(1783);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1783:
      ACCEPT_TOKEN(anon_sym_BSLASHnewtheorem_STAR);
      END_STATE();
    case 1784:
      ACCEPT_TOKEN(anon_sym_BSLASHdeclaretheorem);
      if (lookahead == '*') ADVANCE(1785);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1785:
      ACCEPT_TOKEN(anon_sym_BSLASHdeclaretheorem_STAR);
      END_STATE();
    case 1786:
      ACCEPT_TOKEN(anon_sym_BSLASHdefinecolor);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 's') ADVANCE(649);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1787:
      ACCEPT_TOKEN(anon_sym_BSLASHdefinecolorset);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1788:
      ACCEPT_TOKEN(anon_sym_BSLASHcolor);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == 'b') ADVANCE(1105);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1789:
      ACCEPT_TOKEN(anon_sym_BSLASHpagecolor);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1790:
      ACCEPT_TOKEN(anon_sym_BSLASHtextcolor);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1791:
      ACCEPT_TOKEN(anon_sym_BSLASHmathcolor);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1792:
      ACCEPT_TOKEN(anon_sym_BSLASHcolorbox);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1793:
      ACCEPT_TOKEN(anon_sym_BSLASHusepgflibrary);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1794:
      ACCEPT_TOKEN(anon_sym_BSLASHusetikzlibrary);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1795:
      ACCEPT_TOKEN(anon_sym_BSLASHurl);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    case 1796:
      ACCEPT_TOKEN(anon_sym_BSLASHhref);
      if (lookahead == '*') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1531);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 35},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 2},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 4},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 4},
  [12] = {.lex_state = 4},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 4},
  [15] = {.lex_state = 4},
  [16] = {.lex_state = 4},
  [17] = {.lex_state = 4},
  [18] = {.lex_state = 4},
  [19] = {.lex_state = 4},
  [20] = {.lex_state = 4},
  [21] = {.lex_state = 4},
  [22] = {.lex_state = 4},
  [23] = {.lex_state = 4},
  [24] = {.lex_state = 4},
  [25] = {.lex_state = 5},
  [26] = {.lex_state = 6},
  [27] = {.lex_state = 5},
  [28] = {.lex_state = 6},
  [29] = {.lex_state = 37},
  [30] = {.lex_state = 37},
  [31] = {.lex_state = 36},
  [32] = {.lex_state = 36},
  [33] = {.lex_state = 37},
  [34] = {.lex_state = 37},
  [35] = {.lex_state = 36},
  [36] = {.lex_state = 37},
  [37] = {.lex_state = 36},
  [38] = {.lex_state = 37},
  [39] = {.lex_state = 36},
  [40] = {.lex_state = 37},
  [41] = {.lex_state = 36},
  [42] = {.lex_state = 7},
  [43] = {.lex_state = 7},
  [44] = {.lex_state = 10},
  [45] = {.lex_state = 7},
  [46] = {.lex_state = 9},
  [47] = {.lex_state = 7},
  [48] = {.lex_state = 7},
  [49] = {.lex_state = 36},
  [50] = {.lex_state = 7},
  [51] = {.lex_state = 7},
  [52] = {.lex_state = 7},
  [53] = {.lex_state = 7},
  [54] = {.lex_state = 7},
  [55] = {.lex_state = 7},
  [56] = {.lex_state = 7},
  [57] = {.lex_state = 10},
  [58] = {.lex_state = 3},
  [59] = {.lex_state = 9},
  [60] = {.lex_state = 10},
  [61] = {.lex_state = 3},
  [62] = {.lex_state = 3},
  [63] = {.lex_state = 7},
  [64] = {.lex_state = 35},
  [65] = {.lex_state = 3},
  [66] = {.lex_state = 9},
  [67] = {.lex_state = 10},
  [68] = {.lex_state = 9},
  [69] = {.lex_state = 36},
  [70] = {.lex_state = 37},
  [71] = {.lex_state = 7},
  [72] = {.lex_state = 37},
  [73] = {.lex_state = 36},
  [74] = {.lex_state = 36},
  [75] = {.lex_state = 35},
  [76] = {.lex_state = 36},
  [77] = {.lex_state = 37},
  [78] = {.lex_state = 37},
  [79] = {.lex_state = 37},
  [80] = {.lex_state = 35},
  [81] = {.lex_state = 7},
  [82] = {.lex_state = 36},
  [83] = {.lex_state = 37},
  [84] = {.lex_state = 36},
  [85] = {.lex_state = 37},
  [86] = {.lex_state = 36},
  [87] = {.lex_state = 37},
  [88] = {.lex_state = 36},
  [89] = {.lex_state = 37},
  [90] = {.lex_state = 36},
  [91] = {.lex_state = 37},
  [92] = {.lex_state = 37},
  [93] = {.lex_state = 35},
  [94] = {.lex_state = 36},
  [95] = {.lex_state = 35},
  [96] = {.lex_state = 35},
  [97] = {.lex_state = 36},
  [98] = {.lex_state = 37},
  [99] = {.lex_state = 35},
  [100] = {.lex_state = 36},
  [101] = {.lex_state = 37},
  [102] = {.lex_state = 35},
  [103] = {.lex_state = 36},
  [104] = {.lex_state = 37},
  [105] = {.lex_state = 35},
  [106] = {.lex_state = 36},
  [107] = {.lex_state = 37},
  [108] = {.lex_state = 35},
  [109] = {.lex_state = 36},
  [110] = {.lex_state = 35},
  [111] = {.lex_state = 36},
  [112] = {.lex_state = 37},
  [113] = {.lex_state = 35},
  [114] = {.lex_state = 36},
  [115] = {.lex_state = 37},
  [116] = {.lex_state = 35},
  [117] = {.lex_state = 36},
  [118] = {.lex_state = 37},
  [119] = {.lex_state = 35},
  [120] = {.lex_state = 36},
  [121] = {.lex_state = 37},
  [122] = {.lex_state = 35},
  [123] = {.lex_state = 36},
  [124] = {.lex_state = 37},
  [125] = {.lex_state = 35},
  [126] = {.lex_state = 36},
  [127] = {.lex_state = 37},
  [128] = {.lex_state = 35},
  [129] = {.lex_state = 36},
  [130] = {.lex_state = 37},
  [131] = {.lex_state = 35},
  [132] = {.lex_state = 36},
  [133] = {.lex_state = 37},
  [134] = {.lex_state = 35},
  [135] = {.lex_state = 36},
  [136] = {.lex_state = 37},
  [137] = {.lex_state = 35},
  [138] = {.lex_state = 36},
  [139] = {.lex_state = 37},
  [140] = {.lex_state = 35},
  [141] = {.lex_state = 36},
  [142] = {.lex_state = 37},
  [143] = {.lex_state = 35},
  [144] = {.lex_state = 36},
  [145] = {.lex_state = 37},
  [146] = {.lex_state = 36},
  [147] = {.lex_state = 37},
  [148] = {.lex_state = 36},
  [149] = {.lex_state = 37},
  [150] = {.lex_state = 36},
  [151] = {.lex_state = 37},
  [152] = {.lex_state = 36},
  [153] = {.lex_state = 37},
  [154] = {.lex_state = 36},
  [155] = {.lex_state = 37},
  [156] = {.lex_state = 4},
  [157] = {.lex_state = 4},
  [158] = {.lex_state = 4},
  [159] = {.lex_state = 4},
  [160] = {.lex_state = 35},
  [161] = {.lex_state = 35},
  [162] = {.lex_state = 7},
  [163] = {.lex_state = 7},
  [164] = {.lex_state = 37},
  [165] = {.lex_state = 37},
  [166] = {.lex_state = 36},
  [167] = {.lex_state = 36},
  [168] = {.lex_state = 4},
  [169] = {.lex_state = 35},
  [170] = {.lex_state = 35},
  [171] = {.lex_state = 4},
  [172] = {.lex_state = 37},
  [173] = {.lex_state = 7},
  [174] = {.lex_state = 7},
  [175] = {.lex_state = 37},
  [176] = {.lex_state = 36},
  [177] = {.lex_state = 36},
  [178] = {.lex_state = 35},
  [179] = {.lex_state = 35},
  [180] = {.lex_state = 4},
  [181] = {.lex_state = 4},
  [182] = {.lex_state = 36},
  [183] = {.lex_state = 37},
  [184] = {.lex_state = 7},
  [185] = {.lex_state = 37},
  [186] = {.lex_state = 7},
  [187] = {.lex_state = 36},
  [188] = {.lex_state = 35},
  [189] = {.lex_state = 4},
  [190] = {.lex_state = 35},
  [191] = {.lex_state = 4},
  [192] = {.lex_state = 7},
  [193] = {.lex_state = 36},
  [194] = {.lex_state = 37},
  [195] = {.lex_state = 7},
  [196] = {.lex_state = 37},
  [197] = {.lex_state = 36},
  [198] = {.lex_state = 35},
  [199] = {.lex_state = 35},
  [200] = {.lex_state = 36},
  [201] = {.lex_state = 36},
  [202] = {.lex_state = 7},
  [203] = {.lex_state = 7},
  [204] = {.lex_state = 37},
  [205] = {.lex_state = 4},
  [206] = {.lex_state = 37},
  [207] = {.lex_state = 4},
  [208] = {.lex_state = 4},
  [209] = {.lex_state = 4},
  [210] = {.lex_state = 35},
  [211] = {.lex_state = 35},
  [212] = {.lex_state = 37},
  [213] = {.lex_state = 7},
  [214] = {.lex_state = 37},
  [215] = {.lex_state = 7},
  [216] = {.lex_state = 36},
  [217] = {.lex_state = 36},
  [218] = {.lex_state = 4},
  [219] = {.lex_state = 35},
  [220] = {.lex_state = 4},
  [221] = {.lex_state = 4},
  [222] = {.lex_state = 35},
  [223] = {.lex_state = 7},
  [224] = {.lex_state = 37},
  [225] = {.lex_state = 7},
  [226] = {.lex_state = 37},
  [227] = {.lex_state = 36},
  [228] = {.lex_state = 36},
  [229] = {.lex_state = 35},
  [230] = {.lex_state = 35},
  [231] = {.lex_state = 35},
  [232] = {.lex_state = 7},
  [233] = {.lex_state = 7},
  [234] = {.lex_state = 7},
  [235] = {.lex_state = 37},
  [236] = {.lex_state = 37},
  [237] = {.lex_state = 36},
  [238] = {.lex_state = 37},
  [239] = {.lex_state = 36},
  [240] = {.lex_state = 36},
  [241] = {.lex_state = 8},
  [242] = {.lex_state = 8},
  [243] = {.lex_state = 8},
  [244] = {.lex_state = 8},
  [245] = {.lex_state = 8},
  [246] = {.lex_state = 8},
  [247] = {.lex_state = 8},
  [248] = {.lex_state = 8},
  [249] = {.lex_state = 8},
  [250] = {.lex_state = 8},
  [251] = {.lex_state = 8},
  [252] = {.lex_state = 8},
  [253] = {.lex_state = 8},
  [254] = {.lex_state = 8},
  [255] = {.lex_state = 8},
  [256] = {.lex_state = 11},
  [257] = {.lex_state = 11},
  [258] = {.lex_state = 11},
  [259] = {.lex_state = 11},
  [260] = {.lex_state = 11},
  [261] = {.lex_state = 11},
  [262] = {.lex_state = 11},
  [263] = {.lex_state = 24},
  [264] = {.lex_state = 4},
  [265] = {.lex_state = 4},
  [266] = {.lex_state = 35},
  [267] = {.lex_state = 35},
  [268] = {.lex_state = 37},
  [269] = {.lex_state = 7},
  [270] = {.lex_state = 7},
  [271] = {.lex_state = 37},
  [272] = {.lex_state = 36},
  [273] = {.lex_state = 36},
  [274] = {.lex_state = 14},
  [275] = {.lex_state = 14},
  [276] = {.lex_state = 14},
  [277] = {.lex_state = 14},
  [278] = {.lex_state = 14},
  [279] = {.lex_state = 14},
  [280] = {.lex_state = 14},
  [281] = {.lex_state = 14},
  [282] = {.lex_state = 14},
  [283] = {.lex_state = 14},
  [284] = {.lex_state = 14},
  [285] = {.lex_state = 14},
  [286] = {.lex_state = 14},
  [287] = {.lex_state = 14},
  [288] = {.lex_state = 14},
  [289] = {.lex_state = 14},
  [290] = {.lex_state = 14},
  [291] = {.lex_state = 14},
  [292] = {.lex_state = 14},
  [293] = {.lex_state = 14},
  [294] = {.lex_state = 14},
  [295] = {.lex_state = 14},
  [296] = {.lex_state = 14},
  [297] = {.lex_state = 14},
  [298] = {.lex_state = 14},
  [299] = {.lex_state = 14},
  [300] = {.lex_state = 14},
  [301] = {.lex_state = 20},
  [302] = {.lex_state = 20},
  [303] = {.lex_state = 14},
  [304] = {.lex_state = 20},
  [305] = {.lex_state = 20},
  [306] = {.lex_state = 20},
  [307] = {.lex_state = 20},
  [308] = {.lex_state = 20},
  [309] = {.lex_state = 20},
  [310] = {.lex_state = 20},
  [311] = {.lex_state = 20},
  [312] = {.lex_state = 14},
  [313] = {.lex_state = 14},
  [314] = {.lex_state = 20},
  [315] = {.lex_state = 20},
  [316] = {.lex_state = 14},
  [317] = {.lex_state = 14},
  [318] = {.lex_state = 14},
  [319] = {.lex_state = 14},
  [320] = {.lex_state = 14},
  [321] = {.lex_state = 14},
  [322] = {.lex_state = 14},
  [323] = {.lex_state = 14},
  [324] = {.lex_state = 14},
  [325] = {.lex_state = 14},
  [326] = {.lex_state = 14},
  [327] = {.lex_state = 14},
  [328] = {.lex_state = 14},
  [329] = {.lex_state = 8},
  [330] = {.lex_state = 8},
  [331] = {.lex_state = 14},
  [332] = {.lex_state = 11},
  [333] = {.lex_state = 14},
  [334] = {.lex_state = 11},
  [335] = {.lex_state = 20},
  [336] = {.lex_state = 20},
  [337] = {.lex_state = 4},
  [338] = {.lex_state = 4},
  [339] = {.lex_state = 4},
  [340] = {.lex_state = 35},
  [341] = {.lex_state = 35},
  [342] = {.lex_state = 4},
  [343] = {.lex_state = 36},
  [344] = {.lex_state = 7},
  [345] = {.lex_state = 7},
  [346] = {.lex_state = 37},
  [347] = {.lex_state = 37},
  [348] = {.lex_state = 36},
  [349] = {.lex_state = 4},
  [350] = {.lex_state = 35},
  [351] = {.lex_state = 35},
  [352] = {.lex_state = 4},
  [353] = {.lex_state = 7},
  [354] = {.lex_state = 36},
  [355] = {.lex_state = 37},
  [356] = {.lex_state = 7},
  [357] = {.lex_state = 37},
  [358] = {.lex_state = 36},
  [359] = {.lex_state = 22},
  [360] = {.lex_state = 22},
  [361] = {.lex_state = 4},
  [362] = {.lex_state = 4},
  [363] = {.lex_state = 4},
  [364] = {.lex_state = 4},
  [365] = {.lex_state = 4},
  [366] = {.lex_state = 22},
  [367] = {.lex_state = 4},
  [368] = {.lex_state = 35},
  [369] = {.lex_state = 4},
  [370] = {.lex_state = 4},
  [371] = {.lex_state = 4},
  [372] = {.lex_state = 4},
  [373] = {.lex_state = 4},
  [374] = {.lex_state = 4},
  [375] = {.lex_state = 4},
  [376] = {.lex_state = 35},
  [377] = {.lex_state = 22},
  [378] = {.lex_state = 4},
  [379] = {.lex_state = 4},
  [380] = {.lex_state = 4},
  [381] = {.lex_state = 4},
  [382] = {.lex_state = 22},
  [383] = {.lex_state = 22},
  [384] = {.lex_state = 4},
  [385] = {.lex_state = 4},
  [386] = {.lex_state = 4},
  [387] = {.lex_state = 4},
  [388] = {.lex_state = 4},
  [389] = {.lex_state = 4},
  [390] = {.lex_state = 4},
  [391] = {.lex_state = 22},
  [392] = {.lex_state = 4},
  [393] = {.lex_state = 4},
  [394] = {.lex_state = 4},
  [395] = {.lex_state = 4},
  [396] = {.lex_state = 4},
  [397] = {.lex_state = 4},
  [398] = {.lex_state = 4},
  [399] = {.lex_state = 4},
  [400] = {.lex_state = 4},
  [401] = {.lex_state = 4},
  [402] = {.lex_state = 22},
  [403] = {.lex_state = 4},
  [404] = {.lex_state = 4},
  [405] = {.lex_state = 4},
  [406] = {.lex_state = 4},
  [407] = {.lex_state = 4},
  [408] = {.lex_state = 4},
  [409] = {.lex_state = 4},
  [410] = {.lex_state = 4},
  [411] = {.lex_state = 22},
  [412] = {.lex_state = 22},
  [413] = {.lex_state = 4},
  [414] = {.lex_state = 4},
  [415] = {.lex_state = 4},
  [416] = {.lex_state = 4},
  [417] = {.lex_state = 4},
  [418] = {.lex_state = 4},
  [419] = {.lex_state = 22},
  [420] = {.lex_state = 22},
  [421] = {.lex_state = 4},
  [422] = {.lex_state = 4},
  [423] = {.lex_state = 4},
  [424] = {.lex_state = 4},
  [425] = {.lex_state = 4},
  [426] = {.lex_state = 4},
  [427] = {.lex_state = 4},
  [428] = {.lex_state = 4},
  [429] = {.lex_state = 4},
  [430] = {.lex_state = 4},
  [431] = {.lex_state = 4},
  [432] = {.lex_state = 4},
  [433] = {.lex_state = 4},
  [434] = {.lex_state = 22},
  [435] = {.lex_state = 4},
  [436] = {.lex_state = 4},
  [437] = {.lex_state = 4},
  [438] = {.lex_state = 4},
  [439] = {.lex_state = 4},
  [440] = {.lex_state = 4},
  [441] = {.lex_state = 4},
  [442] = {.lex_state = 4},
  [443] = {.lex_state = 4},
  [444] = {.lex_state = 4},
  [445] = {.lex_state = 22},
  [446] = {.lex_state = 22},
  [447] = {.lex_state = 37},
  [448] = {.lex_state = 22},
  [449] = {.lex_state = 36},
  [450] = {.lex_state = 4},
  [451] = {.lex_state = 15, .external_lex_state = 2},
  [452] = {.lex_state = 36},
  [453] = {.lex_state = 22},
  [454] = {.lex_state = 4},
  [455] = {.lex_state = 22},
  [456] = {.lex_state = 22},
  [457] = {.lex_state = 4},
  [458] = {.lex_state = 7},
  [459] = {.lex_state = 22},
  [460] = {.lex_state = 22},
  [461] = {.lex_state = 22},
  [462] = {.lex_state = 37},
  [463] = {.lex_state = 7},
  [464] = {.lex_state = 22},
  [465] = {.lex_state = 22},
  [466] = {.lex_state = 4},
  [467] = {.lex_state = 4},
  [468] = {.lex_state = 22},
  [469] = {.lex_state = 22},
  [470] = {.lex_state = 22},
  [471] = {.lex_state = 15},
  [472] = {.lex_state = 22},
  [473] = {.lex_state = 4},
  [474] = {.lex_state = 22},
  [475] = {.lex_state = 4},
  [476] = {.lex_state = 22},
  [477] = {.lex_state = 4},
  [478] = {.lex_state = 22},
  [479] = {.lex_state = 4},
  [480] = {.lex_state = 22},
  [481] = {.lex_state = 22},
  [482] = {.lex_state = 22},
  [483] = {.lex_state = 4},
  [484] = {.lex_state = 22},
  [485] = {.lex_state = 22},
  [486] = {.lex_state = 22},
  [487] = {.lex_state = 22},
  [488] = {.lex_state = 4},
  [489] = {.lex_state = 22},
  [490] = {.lex_state = 22},
  [491] = {.lex_state = 22},
  [492] = {.lex_state = 4},
  [493] = {.lex_state = 22},
  [494] = {.lex_state = 4},
  [495] = {.lex_state = 22},
  [496] = {.lex_state = 22},
  [497] = {.lex_state = 22},
  [498] = {.lex_state = 22},
  [499] = {.lex_state = 22},
  [500] = {.lex_state = 35},
  [501] = {.lex_state = 35},
  [502] = {.lex_state = 35},
  [503] = {.lex_state = 35},
  [504] = {.lex_state = 35},
  [505] = {.lex_state = 35},
  [506] = {.lex_state = 35},
  [507] = {.lex_state = 35},
  [508] = {.lex_state = 35},
  [509] = {.lex_state = 35},
  [510] = {.lex_state = 35},
  [511] = {.lex_state = 35},
  [512] = {.lex_state = 35},
  [513] = {.lex_state = 35},
  [514] = {.lex_state = 35},
  [515] = {.lex_state = 35},
  [516] = {.lex_state = 35},
  [517] = {.lex_state = 35},
  [518] = {.lex_state = 35},
  [519] = {.lex_state = 35},
  [520] = {.lex_state = 35},
  [521] = {.lex_state = 35},
  [522] = {.lex_state = 35},
  [523] = {.lex_state = 35},
  [524] = {.lex_state = 35},
  [525] = {.lex_state = 35},
  [526] = {.lex_state = 35},
  [527] = {.lex_state = 35},
  [528] = {.lex_state = 35},
  [529] = {.lex_state = 35},
  [530] = {.lex_state = 35},
  [531] = {.lex_state = 35},
  [532] = {.lex_state = 35},
  [533] = {.lex_state = 35},
  [534] = {.lex_state = 35},
  [535] = {.lex_state = 35},
  [536] = {.lex_state = 4},
  [537] = {.lex_state = 4},
  [538] = {.lex_state = 4},
  [539] = {.lex_state = 4},
  [540] = {.lex_state = 4},
  [541] = {.lex_state = 4},
  [542] = {.lex_state = 4},
  [543] = {.lex_state = 4},
  [544] = {.lex_state = 4},
  [545] = {.lex_state = 35},
  [546] = {.lex_state = 35},
  [547] = {.lex_state = 35},
  [548] = {.lex_state = 35},
  [549] = {.lex_state = 35},
  [550] = {.lex_state = 35},
  [551] = {.lex_state = 35},
  [552] = {.lex_state = 35},
  [553] = {.lex_state = 35},
  [554] = {.lex_state = 35},
  [555] = {.lex_state = 35},
  [556] = {.lex_state = 35},
  [557] = {.lex_state = 35},
  [558] = {.lex_state = 35},
  [559] = {.lex_state = 35},
  [560] = {.lex_state = 35},
  [561] = {.lex_state = 4},
  [562] = {.lex_state = 35},
  [563] = {.lex_state = 35},
  [564] = {.lex_state = 35},
  [565] = {.lex_state = 35},
  [566] = {.lex_state = 35},
  [567] = {.lex_state = 35},
  [568] = {.lex_state = 35},
  [569] = {.lex_state = 4},
  [570] = {.lex_state = 35},
  [571] = {.lex_state = 35},
  [572] = {.lex_state = 4},
  [573] = {.lex_state = 4},
  [574] = {.lex_state = 35},
  [575] = {.lex_state = 35},
  [576] = {.lex_state = 35},
  [577] = {.lex_state = 35},
  [578] = {.lex_state = 35},
  [579] = {.lex_state = 35},
  [580] = {.lex_state = 35},
  [581] = {.lex_state = 35},
  [582] = {.lex_state = 35},
  [583] = {.lex_state = 35},
  [584] = {.lex_state = 4},
  [585] = {.lex_state = 4},
  [586] = {.lex_state = 4},
  [587] = {.lex_state = 4},
  [588] = {.lex_state = 4},
  [589] = {.lex_state = 4},
  [590] = {.lex_state = 4},
  [591] = {.lex_state = 4},
  [592] = {.lex_state = 4},
  [593] = {.lex_state = 4},
  [594] = {.lex_state = 4},
  [595] = {.lex_state = 4},
  [596] = {.lex_state = 4},
  [597] = {.lex_state = 4},
  [598] = {.lex_state = 4},
  [599] = {.lex_state = 4},
  [600] = {.lex_state = 4},
  [601] = {.lex_state = 4},
  [602] = {.lex_state = 4},
  [603] = {.lex_state = 4},
  [604] = {.lex_state = 4},
  [605] = {.lex_state = 4},
  [606] = {.lex_state = 4},
  [607] = {.lex_state = 4},
  [608] = {.lex_state = 4},
  [609] = {.lex_state = 4},
  [610] = {.lex_state = 4},
  [611] = {.lex_state = 4},
  [612] = {.lex_state = 4},
  [613] = {.lex_state = 4},
  [614] = {.lex_state = 4},
  [615] = {.lex_state = 4},
  [616] = {.lex_state = 4},
  [617] = {.lex_state = 4},
  [618] = {.lex_state = 4},
  [619] = {.lex_state = 4},
  [620] = {.lex_state = 4},
  [621] = {.lex_state = 4},
  [622] = {.lex_state = 4},
  [623] = {.lex_state = 4},
  [624] = {.lex_state = 4},
  [625] = {.lex_state = 4},
  [626] = {.lex_state = 4},
  [627] = {.lex_state = 4},
  [628] = {.lex_state = 4},
  [629] = {.lex_state = 4},
  [630] = {.lex_state = 4},
  [631] = {.lex_state = 4},
  [632] = {.lex_state = 4},
  [633] = {.lex_state = 4},
  [634] = {.lex_state = 4},
  [635] = {.lex_state = 4},
  [636] = {.lex_state = 4},
  [637] = {.lex_state = 4},
  [638] = {.lex_state = 4},
  [639] = {.lex_state = 4},
  [640] = {.lex_state = 4},
  [641] = {.lex_state = 4},
  [642] = {.lex_state = 4},
  [643] = {.lex_state = 4},
  [644] = {.lex_state = 4},
  [645] = {.lex_state = 4},
  [646] = {.lex_state = 4},
  [647] = {.lex_state = 4},
  [648] = {.lex_state = 4},
  [649] = {.lex_state = 4},
  [650] = {.lex_state = 4},
  [651] = {.lex_state = 4},
  [652] = {.lex_state = 4},
  [653] = {.lex_state = 4},
  [654] = {.lex_state = 4},
  [655] = {.lex_state = 4},
  [656] = {.lex_state = 4},
  [657] = {.lex_state = 4},
  [658] = {.lex_state = 4},
  [659] = {.lex_state = 4},
  [660] = {.lex_state = 4},
  [661] = {.lex_state = 4},
  [662] = {.lex_state = 4},
  [663] = {.lex_state = 4},
  [664] = {.lex_state = 4},
  [665] = {.lex_state = 4},
  [666] = {.lex_state = 4},
  [667] = {.lex_state = 4},
  [668] = {.lex_state = 4},
  [669] = {.lex_state = 4},
  [670] = {.lex_state = 4},
  [671] = {.lex_state = 4},
  [672] = {.lex_state = 4},
  [673] = {.lex_state = 4},
  [674] = {.lex_state = 4},
  [675] = {.lex_state = 4},
  [676] = {.lex_state = 4},
  [677] = {.lex_state = 4},
  [678] = {.lex_state = 4},
  [679] = {.lex_state = 4},
  [680] = {.lex_state = 4},
  [681] = {.lex_state = 4},
  [682] = {.lex_state = 4},
  [683] = {.lex_state = 4},
  [684] = {.lex_state = 4},
  [685] = {.lex_state = 4},
  [686] = {.lex_state = 4},
  [687] = {.lex_state = 4},
  [688] = {.lex_state = 4},
  [689] = {.lex_state = 4},
  [690] = {.lex_state = 4},
  [691] = {.lex_state = 4},
  [692] = {.lex_state = 4},
  [693] = {.lex_state = 4},
  [694] = {.lex_state = 4},
  [695] = {.lex_state = 4},
  [696] = {.lex_state = 4},
  [697] = {.lex_state = 4},
  [698] = {.lex_state = 4},
  [699] = {.lex_state = 4},
  [700] = {.lex_state = 4},
  [701] = {.lex_state = 4},
  [702] = {.lex_state = 4},
  [703] = {.lex_state = 4},
  [704] = {.lex_state = 4},
  [705] = {.lex_state = 4},
  [706] = {.lex_state = 4},
  [707] = {.lex_state = 4},
  [708] = {.lex_state = 4},
  [709] = {.lex_state = 4},
  [710] = {.lex_state = 4},
  [711] = {.lex_state = 4},
  [712] = {.lex_state = 4},
  [713] = {.lex_state = 4},
  [714] = {.lex_state = 4},
  [715] = {.lex_state = 4},
  [716] = {.lex_state = 4},
  [717] = {.lex_state = 4},
  [718] = {.lex_state = 4},
  [719] = {.lex_state = 4},
  [720] = {.lex_state = 4},
  [721] = {.lex_state = 4},
  [722] = {.lex_state = 4},
  [723] = {.lex_state = 4},
  [724] = {.lex_state = 4},
  [725] = {.lex_state = 4},
  [726] = {.lex_state = 4},
  [727] = {.lex_state = 4},
  [728] = {.lex_state = 4},
  [729] = {.lex_state = 4},
  [730] = {.lex_state = 35},
  [731] = {.lex_state = 36},
  [732] = {.lex_state = 36},
  [733] = {.lex_state = 36},
  [734] = {.lex_state = 37},
  [735] = {.lex_state = 37},
  [736] = {.lex_state = 37},
  [737] = {.lex_state = 37},
  [738] = {.lex_state = 37},
  [739] = {.lex_state = 37},
  [740] = {.lex_state = 37},
  [741] = {.lex_state = 37},
  [742] = {.lex_state = 36},
  [743] = {.lex_state = 36},
  [744] = {.lex_state = 37},
  [745] = {.lex_state = 37},
  [746] = {.lex_state = 37},
  [747] = {.lex_state = 37},
  [748] = {.lex_state = 36},
  [749] = {.lex_state = 37},
  [750] = {.lex_state = 37},
  [751] = {.lex_state = 37},
  [752] = {.lex_state = 37},
  [753] = {.lex_state = 37},
  [754] = {.lex_state = 37},
  [755] = {.lex_state = 37},
  [756] = {.lex_state = 36},
  [757] = {.lex_state = 37},
  [758] = {.lex_state = 37},
  [759] = {.lex_state = 37},
  [760] = {.lex_state = 37},
  [761] = {.lex_state = 37},
  [762] = {.lex_state = 37},
  [763] = {.lex_state = 37},
  [764] = {.lex_state = 37},
  [765] = {.lex_state = 37},
  [766] = {.lex_state = 37},
  [767] = {.lex_state = 37},
  [768] = {.lex_state = 37},
  [769] = {.lex_state = 37},
  [770] = {.lex_state = 37},
  [771] = {.lex_state = 37},
  [772] = {.lex_state = 37},
  [773] = {.lex_state = 37},
  [774] = {.lex_state = 37},
  [775] = {.lex_state = 37},
  [776] = {.lex_state = 37},
  [777] = {.lex_state = 37},
  [778] = {.lex_state = 37},
  [779] = {.lex_state = 37},
  [780] = {.lex_state = 7},
  [781] = {.lex_state = 7},
  [782] = {.lex_state = 7},
  [783] = {.lex_state = 7},
  [784] = {.lex_state = 7},
  [785] = {.lex_state = 7},
  [786] = {.lex_state = 7},
  [787] = {.lex_state = 37},
  [788] = {.lex_state = 37},
  [789] = {.lex_state = 37},
  [790] = {.lex_state = 37},
  [791] = {.lex_state = 37},
  [792] = {.lex_state = 37},
  [793] = {.lex_state = 37},
  [794] = {.lex_state = 37},
  [795] = {.lex_state = 7},
  [796] = {.lex_state = 7},
  [797] = {.lex_state = 7},
  [798] = {.lex_state = 7},
  [799] = {.lex_state = 7},
  [800] = {.lex_state = 7},
  [801] = {.lex_state = 7},
  [802] = {.lex_state = 7},
  [803] = {.lex_state = 36},
  [804] = {.lex_state = 7},
  [805] = {.lex_state = 7},
  [806] = {.lex_state = 7},
  [807] = {.lex_state = 7},
  [808] = {.lex_state = 7},
  [809] = {.lex_state = 7},
  [810] = {.lex_state = 7},
  [811] = {.lex_state = 7},
  [812] = {.lex_state = 7},
  [813] = {.lex_state = 7},
  [814] = {.lex_state = 7},
  [815] = {.lex_state = 7},
  [816] = {.lex_state = 7},
  [817] = {.lex_state = 7},
  [818] = {.lex_state = 35},
  [819] = {.lex_state = 7},
  [820] = {.lex_state = 7},
  [821] = {.lex_state = 7},
  [822] = {.lex_state = 7},
  [823] = {.lex_state = 7},
  [824] = {.lex_state = 7},
  [825] = {.lex_state = 7},
  [826] = {.lex_state = 7},
  [827] = {.lex_state = 7},
  [828] = {.lex_state = 7},
  [829] = {.lex_state = 7},
  [830] = {.lex_state = 7},
  [831] = {.lex_state = 7},
  [832] = {.lex_state = 7},
  [833] = {.lex_state = 7},
  [834] = {.lex_state = 7},
  [835] = {.lex_state = 7},
  [836] = {.lex_state = 7},
  [837] = {.lex_state = 7},
  [838] = {.lex_state = 7},
  [839] = {.lex_state = 7},
  [840] = {.lex_state = 7},
  [841] = {.lex_state = 7},
  [842] = {.lex_state = 7},
  [843] = {.lex_state = 7},
  [844] = {.lex_state = 7},
  [845] = {.lex_state = 7},
  [846] = {.lex_state = 7},
  [847] = {.lex_state = 7},
  [848] = {.lex_state = 7},
  [849] = {.lex_state = 7},
  [850] = {.lex_state = 36},
  [851] = {.lex_state = 7},
  [852] = {.lex_state = 7},
  [853] = {.lex_state = 7},
  [854] = {.lex_state = 7},
  [855] = {.lex_state = 7},
  [856] = {.lex_state = 7},
  [857] = {.lex_state = 7},
  [858] = {.lex_state = 7},
  [859] = {.lex_state = 7},
  [860] = {.lex_state = 7},
  [861] = {.lex_state = 35},
  [862] = {.lex_state = 36},
  [863] = {.lex_state = 36},
  [864] = {.lex_state = 37},
  [865] = {.lex_state = 37},
  [866] = {.lex_state = 37},
  [867] = {.lex_state = 37},
  [868] = {.lex_state = 37},
  [869] = {.lex_state = 37},
  [870] = {.lex_state = 37},
  [871] = {.lex_state = 37},
  [872] = {.lex_state = 37},
  [873] = {.lex_state = 37},
  [874] = {.lex_state = 37},
  [875] = {.lex_state = 37},
  [876] = {.lex_state = 37},
  [877] = {.lex_state = 37},
  [878] = {.lex_state = 38, .external_lex_state = 2},
  [879] = {.lex_state = 37},
  [880] = {.lex_state = 37},
  [881] = {.lex_state = 37},
  [882] = {.lex_state = 37},
  [883] = {.lex_state = 37},
  [884] = {.lex_state = 37},
  [885] = {.lex_state = 37},
  [886] = {.lex_state = 36},
  [887] = {.lex_state = 36},
  [888] = {.lex_state = 36},
  [889] = {.lex_state = 36},
  [890] = {.lex_state = 36},
  [891] = {.lex_state = 36},
  [892] = {.lex_state = 36},
  [893] = {.lex_state = 36},
  [894] = {.lex_state = 35},
  [895] = {.lex_state = 36},
  [896] = {.lex_state = 36},
  [897] = {.lex_state = 36},
  [898] = {.lex_state = 36},
  [899] = {.lex_state = 36},
  [900] = {.lex_state = 36},
  [901] = {.lex_state = 36},
  [902] = {.lex_state = 36},
  [903] = {.lex_state = 36},
  [904] = {.lex_state = 36},
  [905] = {.lex_state = 36},
  [906] = {.lex_state = 36},
  [907] = {.lex_state = 36},
  [908] = {.lex_state = 36},
  [909] = {.lex_state = 36},
  [910] = {.lex_state = 36},
  [911] = {.lex_state = 36},
  [912] = {.lex_state = 36},
  [913] = {.lex_state = 36},
  [914] = {.lex_state = 36},
  [915] = {.lex_state = 36},
  [916] = {.lex_state = 36},
  [917] = {.lex_state = 36},
  [918] = {.lex_state = 36},
  [919] = {.lex_state = 36},
  [920] = {.lex_state = 36},
  [921] = {.lex_state = 36},
  [922] = {.lex_state = 36},
  [923] = {.lex_state = 36},
  [924] = {.lex_state = 36},
  [925] = {.lex_state = 35},
  [926] = {.lex_state = 36},
  [927] = {.lex_state = 36},
  [928] = {.lex_state = 36},
  [929] = {.lex_state = 36},
  [930] = {.lex_state = 36},
  [931] = {.lex_state = 36},
  [932] = {.lex_state = 36},
  [933] = {.lex_state = 36},
  [934] = {.lex_state = 36},
  [935] = {.lex_state = 36},
  [936] = {.lex_state = 36},
  [937] = {.lex_state = 36},
  [938] = {.lex_state = 36},
  [939] = {.lex_state = 36},
  [940] = {.lex_state = 36},
  [941] = {.lex_state = 36},
  [942] = {.lex_state = 36},
  [943] = {.lex_state = 36},
  [944] = {.lex_state = 36},
  [945] = {.lex_state = 36},
  [946] = {.lex_state = 36},
  [947] = {.lex_state = 36},
  [948] = {.lex_state = 7},
  [949] = {.lex_state = 37},
  [950] = {.lex_state = 36},
  [951] = {.lex_state = 12, .external_lex_state = 2},
  [952] = {.lex_state = 7},
  [953] = {.lex_state = 38},
  [954] = {.lex_state = 7},
  [955] = {.lex_state = 35},
  [956] = {.lex_state = 35},
  [957] = {.lex_state = 7},
  [958] = {.lex_state = 35},
  [959] = {.lex_state = 35},
  [960] = {.lex_state = 36},
  [961] = {.lex_state = 35},
  [962] = {.lex_state = 37},
  [963] = {.lex_state = 35},
  [964] = {.lex_state = 7},
  [965] = {.lex_state = 37},
  [966] = {.lex_state = 37},
  [967] = {.lex_state = 13, .external_lex_state = 2},
  [968] = {.lex_state = 7},
  [969] = {.lex_state = 35},
  [970] = {.lex_state = 35},
  [971] = {.lex_state = 16, .external_lex_state = 2},
  [972] = {.lex_state = 36},
  [973] = {.lex_state = 36},
  [974] = {.lex_state = 37},
  [975] = {.lex_state = 36},
  [976] = {.lex_state = 35},
  [977] = {.lex_state = 35},
  [978] = {.lex_state = 35},
  [979] = {.lex_state = 7},
  [980] = {.lex_state = 35},
  [981] = {.lex_state = 7},
  [982] = {.lex_state = 35},
  [983] = {.lex_state = 35},
  [984] = {.lex_state = 35},
  [985] = {.lex_state = 35},
  [986] = {.lex_state = 35},
  [987] = {.lex_state = 35},
  [988] = {.lex_state = 35},
  [989] = {.lex_state = 35},
  [990] = {.lex_state = 7},
  [991] = {.lex_state = 7},
  [992] = {.lex_state = 35},
  [993] = {.lex_state = 36},
  [994] = {.lex_state = 7},
  [995] = {.lex_state = 35},
  [996] = {.lex_state = 35},
  [997] = {.lex_state = 35},
  [998] = {.lex_state = 35},
  [999] = {.lex_state = 35},
  [1000] = {.lex_state = 35},
  [1001] = {.lex_state = 35},
  [1002] = {.lex_state = 35},
  [1003] = {.lex_state = 35},
  [1004] = {.lex_state = 35},
  [1005] = {.lex_state = 35},
  [1006] = {.lex_state = 35},
  [1007] = {.lex_state = 35},
  [1008] = {.lex_state = 35},
  [1009] = {.lex_state = 35},
  [1010] = {.lex_state = 35},
  [1011] = {.lex_state = 35},
  [1012] = {.lex_state = 35},
  [1013] = {.lex_state = 35},
  [1014] = {.lex_state = 35},
  [1015] = {.lex_state = 35},
  [1016] = {.lex_state = 35},
  [1017] = {.lex_state = 35},
  [1018] = {.lex_state = 37},
  [1019] = {.lex_state = 37},
  [1020] = {.lex_state = 35},
  [1021] = {.lex_state = 35},
  [1022] = {.lex_state = 35},
  [1023] = {.lex_state = 35},
  [1024] = {.lex_state = 35},
  [1025] = {.lex_state = 35},
  [1026] = {.lex_state = 35},
  [1027] = {.lex_state = 35},
  [1028] = {.lex_state = 35},
  [1029] = {.lex_state = 35},
  [1030] = {.lex_state = 35},
  [1031] = {.lex_state = 35},
  [1032] = {.lex_state = 35},
  [1033] = {.lex_state = 35},
  [1034] = {.lex_state = 35},
  [1035] = {.lex_state = 35},
  [1036] = {.lex_state = 35},
  [1037] = {.lex_state = 35},
  [1038] = {.lex_state = 35},
  [1039] = {.lex_state = 35},
  [1040] = {.lex_state = 35},
  [1041] = {.lex_state = 35},
  [1042] = {.lex_state = 35},
  [1043] = {.lex_state = 35},
  [1044] = {.lex_state = 35},
  [1045] = {.lex_state = 35},
  [1046] = {.lex_state = 35},
  [1047] = {.lex_state = 35},
  [1048] = {.lex_state = 35},
  [1049] = {.lex_state = 35},
  [1050] = {.lex_state = 35},
  [1051] = {.lex_state = 35},
  [1052] = {.lex_state = 35},
  [1053] = {.lex_state = 35},
  [1054] = {.lex_state = 35},
  [1055] = {.lex_state = 35},
  [1056] = {.lex_state = 35},
  [1057] = {.lex_state = 35},
  [1058] = {.lex_state = 35},
  [1059] = {.lex_state = 35},
  [1060] = {.lex_state = 35},
  [1061] = {.lex_state = 35},
  [1062] = {.lex_state = 35},
  [1063] = {.lex_state = 35},
  [1064] = {.lex_state = 35},
  [1065] = {.lex_state = 35},
  [1066] = {.lex_state = 37},
  [1067] = {.lex_state = 35},
  [1068] = {.lex_state = 35},
  [1069] = {.lex_state = 35},
  [1070] = {.lex_state = 35},
  [1071] = {.lex_state = 35},
  [1072] = {.lex_state = 35},
  [1073] = {.lex_state = 35},
  [1074] = {.lex_state = 35},
  [1075] = {.lex_state = 35},
  [1076] = {.lex_state = 35},
  [1077] = {.lex_state = 35},
  [1078] = {.lex_state = 35},
  [1079] = {.lex_state = 35},
  [1080] = {.lex_state = 35},
  [1081] = {.lex_state = 37},
  [1082] = {.lex_state = 35},
  [1083] = {.lex_state = 35},
  [1084] = {.lex_state = 35},
  [1085] = {.lex_state = 35},
  [1086] = {.lex_state = 35},
  [1087] = {.lex_state = 37},
  [1088] = {.lex_state = 35},
  [1089] = {.lex_state = 36},
  [1090] = {.lex_state = 35},
  [1091] = {.lex_state = 35},
  [1092] = {.lex_state = 35},
  [1093] = {.lex_state = 35},
  [1094] = {.lex_state = 35},
  [1095] = {.lex_state = 35},
  [1096] = {.lex_state = 7},
  [1097] = {.lex_state = 37},
  [1098] = {.lex_state = 35},
  [1099] = {.lex_state = 35},
  [1100] = {.lex_state = 13},
  [1101] = {.lex_state = 7},
  [1102] = {.lex_state = 35},
  [1103] = {.lex_state = 35},
  [1104] = {.lex_state = 36},
  [1105] = {.lex_state = 35},
  [1106] = {.lex_state = 35},
  [1107] = {.lex_state = 16},
  [1108] = {.lex_state = 35},
  [1109] = {.lex_state = 35},
  [1110] = {.lex_state = 35},
  [1111] = {.lex_state = 35},
  [1112] = {.lex_state = 35},
  [1113] = {.lex_state = 35},
  [1114] = {.lex_state = 35},
  [1115] = {.lex_state = 35},
  [1116] = {.lex_state = 36},
  [1117] = {.lex_state = 35},
  [1118] = {.lex_state = 35},
  [1119] = {.lex_state = 35},
  [1120] = {.lex_state = 35},
  [1121] = {.lex_state = 35},
  [1122] = {.lex_state = 35},
  [1123] = {.lex_state = 35},
  [1124] = {.lex_state = 12},
  [1125] = {.lex_state = 35},
  [1126] = {.lex_state = 35},
  [1127] = {.lex_state = 36},
  [1128] = {.lex_state = 36},
  [1129] = {.lex_state = 35},
  [1130] = {.lex_state = 35},
  [1131] = {.lex_state = 35},
  [1132] = {.lex_state = 35},
  [1133] = {.lex_state = 35},
  [1134] = {.lex_state = 7},
  [1135] = {.lex_state = 35},
  [1136] = {.lex_state = 7},
  [1137] = {.lex_state = 35},
  [1138] = {.lex_state = 35},
  [1139] = {.lex_state = 35},
  [1140] = {.lex_state = 35},
  [1141] = {.lex_state = 35},
  [1142] = {.lex_state = 35},
  [1143] = {.lex_state = 35},
  [1144] = {.lex_state = 35},
  [1145] = {.lex_state = 35},
  [1146] = {.lex_state = 35},
  [1147] = {.lex_state = 35},
  [1148] = {.lex_state = 35},
  [1149] = {.lex_state = 35},
  [1150] = {.lex_state = 36},
  [1151] = {.lex_state = 35},
  [1152] = {.lex_state = 36},
  [1153] = {.lex_state = 35},
  [1154] = {.lex_state = 35},
  [1155] = {.lex_state = 35},
  [1156] = {.lex_state = 35},
  [1157] = {.lex_state = 35},
  [1158] = {.lex_state = 37},
  [1159] = {.lex_state = 37},
  [1160] = {.lex_state = 35},
  [1161] = {.lex_state = 35},
  [1162] = {.lex_state = 35},
  [1163] = {.lex_state = 37},
  [1164] = {.lex_state = 36},
  [1165] = {.lex_state = 36},
  [1166] = {.lex_state = 37},
  [1167] = {.lex_state = 36},
  [1168] = {.lex_state = 37},
  [1169] = {.lex_state = 37},
  [1170] = {.lex_state = 37},
  [1171] = {.lex_state = 37},
  [1172] = {.lex_state = 37},
  [1173] = {.lex_state = 37},
  [1174] = {.lex_state = 37},
  [1175] = {.lex_state = 37},
  [1176] = {.lex_state = 37},
  [1177] = {.lex_state = 37},
  [1178] = {.lex_state = 37},
  [1179] = {.lex_state = 37},
  [1180] = {.lex_state = 37},
  [1181] = {.lex_state = 37},
  [1182] = {.lex_state = 37},
  [1183] = {.lex_state = 36},
  [1184] = {.lex_state = 37},
  [1185] = {.lex_state = 37},
  [1186] = {.lex_state = 37},
  [1187] = {.lex_state = 36},
  [1188] = {.lex_state = 37},
  [1189] = {.lex_state = 37},
  [1190] = {.lex_state = 37},
  [1191] = {.lex_state = 37},
  [1192] = {.lex_state = 37},
  [1193] = {.lex_state = 7},
  [1194] = {.lex_state = 36},
  [1195] = {.lex_state = 37},
  [1196] = {.lex_state = 36},
  [1197] = {.lex_state = 37},
  [1198] = {.lex_state = 36},
  [1199] = {.lex_state = 36},
  [1200] = {.lex_state = 36},
  [1201] = {.lex_state = 36},
  [1202] = {.lex_state = 36},
  [1203] = {.lex_state = 7},
  [1204] = {.lex_state = 7},
  [1205] = {.lex_state = 37},
  [1206] = {.lex_state = 36},
  [1207] = {.lex_state = 36},
  [1208] = {.lex_state = 36},
  [1209] = {.lex_state = 7},
  [1210] = {.lex_state = 36},
  [1211] = {.lex_state = 36},
  [1212] = {.lex_state = 36},
  [1213] = {.lex_state = 36},
  [1214] = {.lex_state = 37},
  [1215] = {.lex_state = 7},
  [1216] = {.lex_state = 37},
  [1217] = {.lex_state = 36},
  [1218] = {.lex_state = 36},
  [1219] = {.lex_state = 7},
  [1220] = {.lex_state = 7},
  [1221] = {.lex_state = 7},
  [1222] = {.lex_state = 7},
  [1223] = {.lex_state = 7},
  [1224] = {.lex_state = 7},
  [1225] = {.lex_state = 7},
  [1226] = {.lex_state = 7},
  [1227] = {.lex_state = 7},
  [1228] = {.lex_state = 7},
  [1229] = {.lex_state = 7},
  [1230] = {.lex_state = 7},
  [1231] = {.lex_state = 7},
  [1232] = {.lex_state = 7},
  [1233] = {.lex_state = 7},
  [1234] = {.lex_state = 7},
  [1235] = {.lex_state = 7},
  [1236] = {.lex_state = 7},
  [1237] = {.lex_state = 37},
  [1238] = {.lex_state = 37},
  [1239] = {.lex_state = 37},
  [1240] = {.lex_state = 37},
  [1241] = {.lex_state = 7},
  [1242] = {.lex_state = 37},
  [1243] = {.lex_state = 37},
  [1244] = {.lex_state = 37},
  [1245] = {.lex_state = 36},
  [1246] = {.lex_state = 7},
  [1247] = {.lex_state = 7},
  [1248] = {.lex_state = 7},
  [1249] = {.lex_state = 7},
  [1250] = {.lex_state = 7},
  [1251] = {.lex_state = 7},
  [1252] = {.lex_state = 7},
  [1253] = {.lex_state = 7},
  [1254] = {.lex_state = 7},
  [1255] = {.lex_state = 7},
  [1256] = {.lex_state = 7},
  [1257] = {.lex_state = 7},
  [1258] = {.lex_state = 7},
  [1259] = {.lex_state = 37},
  [1260] = {.lex_state = 37},
  [1261] = {.lex_state = 37},
  [1262] = {.lex_state = 37},
  [1263] = {.lex_state = 37},
  [1264] = {.lex_state = 7},
  [1265] = {.lex_state = 7},
  [1266] = {.lex_state = 37},
  [1267] = {.lex_state = 37},
  [1268] = {.lex_state = 36},
  [1269] = {.lex_state = 7},
  [1270] = {.lex_state = 36},
  [1271] = {.lex_state = 36},
  [1272] = {.lex_state = 36},
  [1273] = {.lex_state = 36},
  [1274] = {.lex_state = 7},
  [1275] = {.lex_state = 7},
  [1276] = {.lex_state = 7},
  [1277] = {.lex_state = 36},
  [1278] = {.lex_state = 37},
  [1279] = {.lex_state = 7},
  [1280] = {.lex_state = 37},
  [1281] = {.lex_state = 37},
  [1282] = {.lex_state = 37},
  [1283] = {.lex_state = 7},
  [1284] = {.lex_state = 37},
  [1285] = {.lex_state = 37},
  [1286] = {.lex_state = 37},
  [1287] = {.lex_state = 37},
  [1288] = {.lex_state = 7},
  [1289] = {.lex_state = 37},
  [1290] = {.lex_state = 7},
  [1291] = {.lex_state = 37},
  [1292] = {.lex_state = 37},
  [1293] = {.lex_state = 37},
  [1294] = {.lex_state = 37},
  [1295] = {.lex_state = 37},
  [1296] = {.lex_state = 37},
  [1297] = {.lex_state = 36},
  [1298] = {.lex_state = 37},
  [1299] = {.lex_state = 37},
  [1300] = {.lex_state = 37},
  [1301] = {.lex_state = 37},
  [1302] = {.lex_state = 37},
  [1303] = {.lex_state = 37},
  [1304] = {.lex_state = 37},
  [1305] = {.lex_state = 37},
  [1306] = {.lex_state = 36},
  [1307] = {.lex_state = 36},
  [1308] = {.lex_state = 36},
  [1309] = {.lex_state = 36},
  [1310] = {.lex_state = 37},
  [1311] = {.lex_state = 36},
  [1312] = {.lex_state = 36},
  [1313] = {.lex_state = 36},
  [1314] = {.lex_state = 36},
  [1315] = {.lex_state = 36},
  [1316] = {.lex_state = 36},
  [1317] = {.lex_state = 36},
  [1318] = {.lex_state = 36},
  [1319] = {.lex_state = 37},
  [1320] = {.lex_state = 37},
  [1321] = {.lex_state = 37},
  [1322] = {.lex_state = 37},
  [1323] = {.lex_state = 37},
  [1324] = {.lex_state = 7},
  [1325] = {.lex_state = 37},
  [1326] = {.lex_state = 36},
  [1327] = {.lex_state = 7},
  [1328] = {.lex_state = 37},
  [1329] = {.lex_state = 37},
  [1330] = {.lex_state = 37},
  [1331] = {.lex_state = 36},
  [1332] = {.lex_state = 7},
  [1333] = {.lex_state = 37},
  [1334] = {.lex_state = 7},
  [1335] = {.lex_state = 7},
  [1336] = {.lex_state = 37},
  [1337] = {.lex_state = 37},
  [1338] = {.lex_state = 37},
  [1339] = {.lex_state = 7},
  [1340] = {.lex_state = 7},
  [1341] = {.lex_state = 37},
  [1342] = {.lex_state = 7},
  [1343] = {.lex_state = 7},
  [1344] = {.lex_state = 37},
  [1345] = {.lex_state = 37},
  [1346] = {.lex_state = 37},
  [1347] = {.lex_state = 37},
  [1348] = {.lex_state = 37},
  [1349] = {.lex_state = 37},
  [1350] = {.lex_state = 37},
  [1351] = {.lex_state = 36},
  [1352] = {.lex_state = 36},
  [1353] = {.lex_state = 7},
  [1354] = {.lex_state = 7},
  [1355] = {.lex_state = 36},
  [1356] = {.lex_state = 36},
  [1357] = {.lex_state = 37},
  [1358] = {.lex_state = 37},
  [1359] = {.lex_state = 37},
  [1360] = {.lex_state = 37},
  [1361] = {.lex_state = 37},
  [1362] = {.lex_state = 36},
  [1363] = {.lex_state = 7},
  [1364] = {.lex_state = 37},
  [1365] = {.lex_state = 36},
  [1366] = {.lex_state = 36},
  [1367] = {.lex_state = 37},
  [1368] = {.lex_state = 36},
  [1369] = {.lex_state = 36},
  [1370] = {.lex_state = 36},
  [1371] = {.lex_state = 37},
  [1372] = {.lex_state = 37},
  [1373] = {.lex_state = 37},
  [1374] = {.lex_state = 37},
  [1375] = {.lex_state = 37},
  [1376] = {.lex_state = 37},
  [1377] = {.lex_state = 37},
  [1378] = {.lex_state = 37},
  [1379] = {.lex_state = 37},
  [1380] = {.lex_state = 36},
  [1381] = {.lex_state = 37},
  [1382] = {.lex_state = 37},
  [1383] = {.lex_state = 37},
  [1384] = {.lex_state = 37},
  [1385] = {.lex_state = 37},
  [1386] = {.lex_state = 37},
  [1387] = {.lex_state = 37},
  [1388] = {.lex_state = 37},
  [1389] = {.lex_state = 37},
  [1390] = {.lex_state = 37},
  [1391] = {.lex_state = 37},
  [1392] = {.lex_state = 37},
  [1393] = {.lex_state = 37},
  [1394] = {.lex_state = 37},
  [1395] = {.lex_state = 36},
  [1396] = {.lex_state = 36},
  [1397] = {.lex_state = 7},
  [1398] = {.lex_state = 36},
  [1399] = {.lex_state = 7},
  [1400] = {.lex_state = 37},
  [1401] = {.lex_state = 37},
  [1402] = {.lex_state = 37},
  [1403] = {.lex_state = 37},
  [1404] = {.lex_state = 7},
  [1405] = {.lex_state = 7},
  [1406] = {.lex_state = 7},
  [1407] = {.lex_state = 37},
  [1408] = {.lex_state = 37},
  [1409] = {.lex_state = 37},
  [1410] = {.lex_state = 37},
  [1411] = {.lex_state = 37},
  [1412] = {.lex_state = 37},
  [1413] = {.lex_state = 37},
  [1414] = {.lex_state = 37},
  [1415] = {.lex_state = 37},
  [1416] = {.lex_state = 7},
  [1417] = {.lex_state = 7},
  [1418] = {.lex_state = 7},
  [1419] = {.lex_state = 7},
  [1420] = {.lex_state = 7},
  [1421] = {.lex_state = 7},
  [1422] = {.lex_state = 7},
  [1423] = {.lex_state = 7},
  [1424] = {.lex_state = 7},
  [1425] = {.lex_state = 7},
  [1426] = {.lex_state = 7},
  [1427] = {.lex_state = 37},
  [1428] = {.lex_state = 36},
  [1429] = {.lex_state = 37},
  [1430] = {.lex_state = 37},
  [1431] = {.lex_state = 37},
  [1432] = {.lex_state = 36},
  [1433] = {.lex_state = 7},
  [1434] = {.lex_state = 37},
  [1435] = {.lex_state = 7},
  [1436] = {.lex_state = 7},
  [1437] = {.lex_state = 7},
  [1438] = {.lex_state = 7},
  [1439] = {.lex_state = 7},
  [1440] = {.lex_state = 7},
  [1441] = {.lex_state = 7},
  [1442] = {.lex_state = 7},
  [1443] = {.lex_state = 7},
  [1444] = {.lex_state = 7},
  [1445] = {.lex_state = 7},
  [1446] = {.lex_state = 7},
  [1447] = {.lex_state = 7},
  [1448] = {.lex_state = 7},
  [1449] = {.lex_state = 7},
  [1450] = {.lex_state = 7},
  [1451] = {.lex_state = 7},
  [1452] = {.lex_state = 7},
  [1453] = {.lex_state = 7},
  [1454] = {.lex_state = 7},
  [1455] = {.lex_state = 7},
  [1456] = {.lex_state = 7},
  [1457] = {.lex_state = 37},
  [1458] = {.lex_state = 7},
  [1459] = {.lex_state = 37},
  [1460] = {.lex_state = 7},
  [1461] = {.lex_state = 7},
  [1462] = {.lex_state = 7},
  [1463] = {.lex_state = 37},
  [1464] = {.lex_state = 7},
  [1465] = {.lex_state = 36},
  [1466] = {.lex_state = 36},
  [1467] = {.lex_state = 7},
  [1468] = {.lex_state = 7},
  [1469] = {.lex_state = 7},
  [1470] = {.lex_state = 7},
  [1471] = {.lex_state = 7},
  [1472] = {.lex_state = 7},
  [1473] = {.lex_state = 7},
  [1474] = {.lex_state = 7},
  [1475] = {.lex_state = 7},
  [1476] = {.lex_state = 36},
  [1477] = {.lex_state = 36},
  [1478] = {.lex_state = 36},
  [1479] = {.lex_state = 36},
  [1480] = {.lex_state = 36},
  [1481] = {.lex_state = 36},
  [1482] = {.lex_state = 36},
  [1483] = {.lex_state = 36},
  [1484] = {.lex_state = 7},
  [1485] = {.lex_state = 7},
  [1486] = {.lex_state = 7},
  [1487] = {.lex_state = 7},
  [1488] = {.lex_state = 7},
  [1489] = {.lex_state = 7},
  [1490] = {.lex_state = 7},
  [1491] = {.lex_state = 7},
  [1492] = {.lex_state = 7},
  [1493] = {.lex_state = 7},
  [1494] = {.lex_state = 36},
  [1495] = {.lex_state = 36},
  [1496] = {.lex_state = 36},
  [1497] = {.lex_state = 36},
  [1498] = {.lex_state = 36},
  [1499] = {.lex_state = 36},
  [1500] = {.lex_state = 36},
  [1501] = {.lex_state = 36},
  [1502] = {.lex_state = 36},
  [1503] = {.lex_state = 36},
  [1504] = {.lex_state = 36},
  [1505] = {.lex_state = 36},
  [1506] = {.lex_state = 36},
  [1507] = {.lex_state = 7},
  [1508] = {.lex_state = 36},
  [1509] = {.lex_state = 7},
  [1510] = {.lex_state = 36},
  [1511] = {.lex_state = 36},
  [1512] = {.lex_state = 36},
  [1513] = {.lex_state = 7},
  [1514] = {.lex_state = 36},
  [1515] = {.lex_state = 36},
  [1516] = {.lex_state = 36},
  [1517] = {.lex_state = 36},
  [1518] = {.lex_state = 36},
  [1519] = {.lex_state = 36},
  [1520] = {.lex_state = 36},
  [1521] = {.lex_state = 36},
  [1522] = {.lex_state = 36},
  [1523] = {.lex_state = 36},
  [1524] = {.lex_state = 36},
  [1525] = {.lex_state = 36},
  [1526] = {.lex_state = 36},
  [1527] = {.lex_state = 36},
  [1528] = {.lex_state = 36},
  [1529] = {.lex_state = 36},
  [1530] = {.lex_state = 36},
  [1531] = {.lex_state = 36},
  [1532] = {.lex_state = 36},
  [1533] = {.lex_state = 7},
  [1534] = {.lex_state = 7},
  [1535] = {.lex_state = 36},
  [1536] = {.lex_state = 7},
  [1537] = {.lex_state = 7},
  [1538] = {.lex_state = 7},
  [1539] = {.lex_state = 7},
  [1540] = {.lex_state = 7},
  [1541] = {.lex_state = 7},
  [1542] = {.lex_state = 7},
  [1543] = {.lex_state = 7},
  [1544] = {.lex_state = 7},
  [1545] = {.lex_state = 37},
  [1546] = {.lex_state = 7},
  [1547] = {.lex_state = 7},
  [1548] = {.lex_state = 7},
  [1549] = {.lex_state = 7},
  [1550] = {.lex_state = 7},
  [1551] = {.lex_state = 7},
  [1552] = {.lex_state = 7},
  [1553] = {.lex_state = 36},
  [1554] = {.lex_state = 37},
  [1555] = {.lex_state = 37},
  [1556] = {.lex_state = 37},
  [1557] = {.lex_state = 7},
  [1558] = {.lex_state = 7},
  [1559] = {.lex_state = 36},
  [1560] = {.lex_state = 36},
  [1561] = {.lex_state = 7},
  [1562] = {.lex_state = 37},
  [1563] = {.lex_state = 7},
  [1564] = {.lex_state = 7},
  [1565] = {.lex_state = 37},
  [1566] = {.lex_state = 37},
  [1567] = {.lex_state = 37},
  [1568] = {.lex_state = 7},
  [1569] = {.lex_state = 7},
  [1570] = {.lex_state = 7},
  [1571] = {.lex_state = 36},
  [1572] = {.lex_state = 7},
  [1573] = {.lex_state = 36},
  [1574] = {.lex_state = 36},
  [1575] = {.lex_state = 36},
  [1576] = {.lex_state = 37},
  [1577] = {.lex_state = 36},
  [1578] = {.lex_state = 37},
  [1579] = {.lex_state = 36},
  [1580] = {.lex_state = 36},
  [1581] = {.lex_state = 36},
  [1582] = {.lex_state = 36},
  [1583] = {.lex_state = 36},
  [1584] = {.lex_state = 36},
  [1585] = {.lex_state = 36},
  [1586] = {.lex_state = 36},
  [1587] = {.lex_state = 36},
  [1588] = {.lex_state = 36},
  [1589] = {.lex_state = 36},
  [1590] = {.lex_state = 36},
  [1591] = {.lex_state = 36},
  [1592] = {.lex_state = 36},
  [1593] = {.lex_state = 36},
  [1594] = {.lex_state = 36},
  [1595] = {.lex_state = 36},
  [1596] = {.lex_state = 36},
  [1597] = {.lex_state = 36},
  [1598] = {.lex_state = 36},
  [1599] = {.lex_state = 36},
  [1600] = {.lex_state = 36},
  [1601] = {.lex_state = 36},
  [1602] = {.lex_state = 36},
  [1603] = {.lex_state = 36},
  [1604] = {.lex_state = 37},
  [1605] = {.lex_state = 37},
  [1606] = {.lex_state = 7},
  [1607] = {.lex_state = 37},
  [1608] = {.lex_state = 37},
  [1609] = {.lex_state = 7},
  [1610] = {.lex_state = 37},
  [1611] = {.lex_state = 37},
  [1612] = {.lex_state = 7},
  [1613] = {.lex_state = 7},
  [1614] = {.lex_state = 36},
  [1615] = {.lex_state = 36},
  [1616] = {.lex_state = 7},
  [1617] = {.lex_state = 37},
  [1618] = {.lex_state = 37},
  [1619] = {.lex_state = 36},
  [1620] = {.lex_state = 36},
  [1621] = {.lex_state = 7},
  [1622] = {.lex_state = 36},
  [1623] = {.lex_state = 36},
  [1624] = {.lex_state = 7},
  [1625] = {.lex_state = 36},
  [1626] = {.lex_state = 7},
  [1627] = {.lex_state = 7},
  [1628] = {.lex_state = 7},
  [1629] = {.lex_state = 36},
  [1630] = {.lex_state = 36},
  [1631] = {.lex_state = 36},
  [1632] = {.lex_state = 36},
  [1633] = {.lex_state = 36},
  [1634] = {.lex_state = 36},
  [1635] = {.lex_state = 36},
  [1636] = {.lex_state = 36},
  [1637] = {.lex_state = 36},
  [1638] = {.lex_state = 36},
  [1639] = {.lex_state = 36},
  [1640] = {.lex_state = 36},
  [1641] = {.lex_state = 36},
  [1642] = {.lex_state = 37},
  [1643] = {.lex_state = 8},
  [1644] = {.lex_state = 8},
  [1645] = {.lex_state = 8},
  [1646] = {.lex_state = 17, .external_lex_state = 2},
  [1647] = {.lex_state = 8},
  [1648] = {.lex_state = 8},
  [1649] = {.lex_state = 8},
  [1650] = {.lex_state = 14},
  [1651] = {.lex_state = 8},
  [1652] = {.lex_state = 17},
  [1653] = {.lex_state = 8},
  [1654] = {.lex_state = 8},
  [1655] = {.lex_state = 8},
  [1656] = {.lex_state = 18, .external_lex_state = 2},
  [1657] = {.lex_state = 11},
  [1658] = {.lex_state = 11},
  [1659] = {.lex_state = 11},
  [1660] = {.lex_state = 8},
  [1661] = {.lex_state = 11},
  [1662] = {.lex_state = 8},
  [1663] = {.lex_state = 11},
  [1664] = {.lex_state = 19, .external_lex_state = 2},
  [1665] = {.lex_state = 14},
  [1666] = {.lex_state = 14},
  [1667] = {.lex_state = 14},
  [1668] = {.lex_state = 14},
  [1669] = {.lex_state = 8},
  [1670] = {.lex_state = 8},
  [1671] = {.lex_state = 8},
  [1672] = {.lex_state = 8},
  [1673] = {.lex_state = 8},
  [1674] = {.lex_state = 8},
  [1675] = {.lex_state = 8},
  [1676] = {.lex_state = 8},
  [1677] = {.lex_state = 8},
  [1678] = {.lex_state = 8},
  [1679] = {.lex_state = 8},
  [1680] = {.lex_state = 8},
  [1681] = {.lex_state = 8},
  [1682] = {.lex_state = 8},
  [1683] = {.lex_state = 8},
  [1684] = {.lex_state = 8},
  [1685] = {.lex_state = 8},
  [1686] = {.lex_state = 8},
  [1687] = {.lex_state = 8},
  [1688] = {.lex_state = 8},
  [1689] = {.lex_state = 8},
  [1690] = {.lex_state = 8},
  [1691] = {.lex_state = 8},
  [1692] = {.lex_state = 8},
  [1693] = {.lex_state = 8},
  [1694] = {.lex_state = 8},
  [1695] = {.lex_state = 8},
  [1696] = {.lex_state = 8},
  [1697] = {.lex_state = 8},
  [1698] = {.lex_state = 8},
  [1699] = {.lex_state = 8},
  [1700] = {.lex_state = 8},
  [1701] = {.lex_state = 8},
  [1702] = {.lex_state = 8},
  [1703] = {.lex_state = 8},
  [1704] = {.lex_state = 8},
  [1705] = {.lex_state = 8},
  [1706] = {.lex_state = 8},
  [1707] = {.lex_state = 8},
  [1708] = {.lex_state = 8},
  [1709] = {.lex_state = 8},
  [1710] = {.lex_state = 8},
  [1711] = {.lex_state = 8},
  [1712] = {.lex_state = 8},
  [1713] = {.lex_state = 8},
  [1714] = {.lex_state = 8},
  [1715] = {.lex_state = 8},
  [1716] = {.lex_state = 8},
  [1717] = {.lex_state = 8},
  [1718] = {.lex_state = 8},
  [1719] = {.lex_state = 8},
  [1720] = {.lex_state = 8},
  [1721] = {.lex_state = 8},
  [1722] = {.lex_state = 8},
  [1723] = {.lex_state = 8},
  [1724] = {.lex_state = 8},
  [1725] = {.lex_state = 8},
  [1726] = {.lex_state = 8},
  [1727] = {.lex_state = 8},
  [1728] = {.lex_state = 8},
  [1729] = {.lex_state = 8},
  [1730] = {.lex_state = 8},
  [1731] = {.lex_state = 8},
  [1732] = {.lex_state = 8},
  [1733] = {.lex_state = 8},
  [1734] = {.lex_state = 8},
  [1735] = {.lex_state = 8},
  [1736] = {.lex_state = 8},
  [1737] = {.lex_state = 8},
  [1738] = {.lex_state = 8},
  [1739] = {.lex_state = 8},
  [1740] = {.lex_state = 8},
  [1741] = {.lex_state = 8},
  [1742] = {.lex_state = 8},
  [1743] = {.lex_state = 8},
  [1744] = {.lex_state = 8},
  [1745] = {.lex_state = 8},
  [1746] = {.lex_state = 8},
  [1747] = {.lex_state = 8},
  [1748] = {.lex_state = 8},
  [1749] = {.lex_state = 8},
  [1750] = {.lex_state = 8},
  [1751] = {.lex_state = 8},
  [1752] = {.lex_state = 18},
  [1753] = {.lex_state = 8},
  [1754] = {.lex_state = 8},
  [1755] = {.lex_state = 8},
  [1756] = {.lex_state = 8},
  [1757] = {.lex_state = 8},
  [1758] = {.lex_state = 11},
  [1759] = {.lex_state = 11},
  [1760] = {.lex_state = 8},
  [1761] = {.lex_state = 8},
  [1762] = {.lex_state = 8},
  [1763] = {.lex_state = 8},
  [1764] = {.lex_state = 11},
  [1765] = {.lex_state = 8},
  [1766] = {.lex_state = 11},
  [1767] = {.lex_state = 8},
  [1768] = {.lex_state = 8},
  [1769] = {.lex_state = 8},
  [1770] = {.lex_state = 8},
  [1771] = {.lex_state = 8},
  [1772] = {.lex_state = 8},
  [1773] = {.lex_state = 8},
  [1774] = {.lex_state = 8},
  [1775] = {.lex_state = 8},
  [1776] = {.lex_state = 8},
  [1777] = {.lex_state = 8},
  [1778] = {.lex_state = 8},
  [1779] = {.lex_state = 8},
  [1780] = {.lex_state = 8},
  [1781] = {.lex_state = 8},
  [1782] = {.lex_state = 11},
  [1783] = {.lex_state = 11},
  [1784] = {.lex_state = 8},
  [1785] = {.lex_state = 8},
  [1786] = {.lex_state = 8},
  [1787] = {.lex_state = 11},
  [1788] = {.lex_state = 8},
  [1789] = {.lex_state = 8},
  [1790] = {.lex_state = 8},
  [1791] = {.lex_state = 8},
  [1792] = {.lex_state = 8},
  [1793] = {.lex_state = 8},
  [1794] = {.lex_state = 8},
  [1795] = {.lex_state = 8},
  [1796] = {.lex_state = 8},
  [1797] = {.lex_state = 8},
  [1798] = {.lex_state = 8},
  [1799] = {.lex_state = 8},
  [1800] = {.lex_state = 8},
  [1801] = {.lex_state = 8},
  [1802] = {.lex_state = 8},
  [1803] = {.lex_state = 8},
  [1804] = {.lex_state = 8},
  [1805] = {.lex_state = 8},
  [1806] = {.lex_state = 8},
  [1807] = {.lex_state = 8},
  [1808] = {.lex_state = 8},
  [1809] = {.lex_state = 8},
  [1810] = {.lex_state = 8},
  [1811] = {.lex_state = 19},
  [1812] = {.lex_state = 8},
  [1813] = {.lex_state = 8},
  [1814] = {.lex_state = 8},
  [1815] = {.lex_state = 8},
  [1816] = {.lex_state = 14},
  [1817] = {.lex_state = 14},
  [1818] = {.lex_state = 8},
  [1819] = {.lex_state = 8},
  [1820] = {.lex_state = 8},
  [1821] = {.lex_state = 8},
  [1822] = {.lex_state = 14},
  [1823] = {.lex_state = 8},
  [1824] = {.lex_state = 14},
  [1825] = {.lex_state = 14},
  [1826] = {.lex_state = 14},
  [1827] = {.lex_state = 14},
  [1828] = {.lex_state = 8},
  [1829] = {.lex_state = 8},
  [1830] = {.lex_state = 8},
  [1831] = {.lex_state = 8},
  [1832] = {.lex_state = 8},
  [1833] = {.lex_state = 11},
  [1834] = {.lex_state = 11},
  [1835] = {.lex_state = 11},
  [1836] = {.lex_state = 11},
  [1837] = {.lex_state = 11},
  [1838] = {.lex_state = 11},
  [1839] = {.lex_state = 11},
  [1840] = {.lex_state = 11},
  [1841] = {.lex_state = 11},
  [1842] = {.lex_state = 11},
  [1843] = {.lex_state = 11},
  [1844] = {.lex_state = 11},
  [1845] = {.lex_state = 11},
  [1846] = {.lex_state = 11},
  [1847] = {.lex_state = 11},
  [1848] = {.lex_state = 11},
  [1849] = {.lex_state = 11},
  [1850] = {.lex_state = 11},
  [1851] = {.lex_state = 11},
  [1852] = {.lex_state = 11},
  [1853] = {.lex_state = 11},
  [1854] = {.lex_state = 11},
  [1855] = {.lex_state = 11},
  [1856] = {.lex_state = 11},
  [1857] = {.lex_state = 11},
  [1858] = {.lex_state = 11},
  [1859] = {.lex_state = 11},
  [1860] = {.lex_state = 11},
  [1861] = {.lex_state = 11},
  [1862] = {.lex_state = 11},
  [1863] = {.lex_state = 11},
  [1864] = {.lex_state = 11},
  [1865] = {.lex_state = 11},
  [1866] = {.lex_state = 11},
  [1867] = {.lex_state = 11},
  [1868] = {.lex_state = 11},
  [1869] = {.lex_state = 11},
  [1870] = {.lex_state = 11},
  [1871] = {.lex_state = 11},
  [1872] = {.lex_state = 11},
  [1873] = {.lex_state = 11},
  [1874] = {.lex_state = 11},
  [1875] = {.lex_state = 11},
  [1876] = {.lex_state = 11},
  [1877] = {.lex_state = 11},
  [1878] = {.lex_state = 11},
  [1879] = {.lex_state = 11},
  [1880] = {.lex_state = 11},
  [1881] = {.lex_state = 11},
  [1882] = {.lex_state = 11},
  [1883] = {.lex_state = 11},
  [1884] = {.lex_state = 11},
  [1885] = {.lex_state = 11},
  [1886] = {.lex_state = 11},
  [1887] = {.lex_state = 11},
  [1888] = {.lex_state = 11},
  [1889] = {.lex_state = 11},
  [1890] = {.lex_state = 11},
  [1891] = {.lex_state = 11},
  [1892] = {.lex_state = 11},
  [1893] = {.lex_state = 11},
  [1894] = {.lex_state = 11},
  [1895] = {.lex_state = 11},
  [1896] = {.lex_state = 11},
  [1897] = {.lex_state = 11},
  [1898] = {.lex_state = 11},
  [1899] = {.lex_state = 11},
  [1900] = {.lex_state = 11},
  [1901] = {.lex_state = 11},
  [1902] = {.lex_state = 11},
  [1903] = {.lex_state = 11},
  [1904] = {.lex_state = 11},
  [1905] = {.lex_state = 11},
  [1906] = {.lex_state = 14},
  [1907] = {.lex_state = 11},
  [1908] = {.lex_state = 14},
  [1909] = {.lex_state = 14},
  [1910] = {.lex_state = 20},
  [1911] = {.lex_state = 11},
  [1912] = {.lex_state = 11},
  [1913] = {.lex_state = 14},
  [1914] = {.lex_state = 11},
  [1915] = {.lex_state = 14},
  [1916] = {.lex_state = 20},
  [1917] = {.lex_state = 14},
  [1918] = {.lex_state = 11},
  [1919] = {.lex_state = 11},
  [1920] = {.lex_state = 11},
  [1921] = {.lex_state = 14},
  [1922] = {.lex_state = 11},
  [1923] = {.lex_state = 11},
  [1924] = {.lex_state = 14},
  [1925] = {.lex_state = 14},
  [1926] = {.lex_state = 11},
  [1927] = {.lex_state = 14},
  [1928] = {.lex_state = 14},
  [1929] = {.lex_state = 14},
  [1930] = {.lex_state = 14},
  [1931] = {.lex_state = 14},
  [1932] = {.lex_state = 14},
  [1933] = {.lex_state = 11},
  [1934] = {.lex_state = 11},
  [1935] = {.lex_state = 14},
  [1936] = {.lex_state = 14},
  [1937] = {.lex_state = 14},
  [1938] = {.lex_state = 14},
  [1939] = {.lex_state = 11},
  [1940] = {.lex_state = 11},
  [1941] = {.lex_state = 14},
  [1942] = {.lex_state = 11},
  [1943] = {.lex_state = 14},
  [1944] = {.lex_state = 14},
  [1945] = {.lex_state = 14},
  [1946] = {.lex_state = 14},
  [1947] = {.lex_state = 14},
  [1948] = {.lex_state = 14},
  [1949] = {.lex_state = 14},
  [1950] = {.lex_state = 14},
  [1951] = {.lex_state = 14},
  [1952] = {.lex_state = 14},
  [1953] = {.lex_state = 14},
  [1954] = {.lex_state = 14},
  [1955] = {.lex_state = 14},
  [1956] = {.lex_state = 14},
  [1957] = {.lex_state = 14},
  [1958] = {.lex_state = 14},
  [1959] = {.lex_state = 14},
  [1960] = {.lex_state = 14},
  [1961] = {.lex_state = 14},
  [1962] = {.lex_state = 11},
  [1963] = {.lex_state = 14},
  [1964] = {.lex_state = 11},
  [1965] = {.lex_state = 14},
  [1966] = {.lex_state = 14},
  [1967] = {.lex_state = 11},
  [1968] = {.lex_state = 11},
  [1969] = {.lex_state = 11},
  [1970] = {.lex_state = 14},
  [1971] = {.lex_state = 14},
  [1972] = {.lex_state = 14},
  [1973] = {.lex_state = 14},
  [1974] = {.lex_state = 14},
  [1975] = {.lex_state = 14},
  [1976] = {.lex_state = 14},
  [1977] = {.lex_state = 14},
  [1978] = {.lex_state = 14},
  [1979] = {.lex_state = 14},
  [1980] = {.lex_state = 14},
  [1981] = {.lex_state = 14},
  [1982] = {.lex_state = 14},
  [1983] = {.lex_state = 14},
  [1984] = {.lex_state = 14},
  [1985] = {.lex_state = 14},
  [1986] = {.lex_state = 14},
  [1987] = {.lex_state = 14},
  [1988] = {.lex_state = 14},
  [1989] = {.lex_state = 14},
  [1990] = {.lex_state = 14},
  [1991] = {.lex_state = 14},
  [1992] = {.lex_state = 14},
  [1993] = {.lex_state = 11},
  [1994] = {.lex_state = 11},
  [1995] = {.lex_state = 14},
  [1996] = {.lex_state = 11},
  [1997] = {.lex_state = 14},
  [1998] = {.lex_state = 14},
  [1999] = {.lex_state = 14},
  [2000] = {.lex_state = 14},
  [2001] = {.lex_state = 14},
  [2002] = {.lex_state = 14},
  [2003] = {.lex_state = 14},
  [2004] = {.lex_state = 14},
  [2005] = {.lex_state = 14},
  [2006] = {.lex_state = 14},
  [2007] = {.lex_state = 14},
  [2008] = {.lex_state = 11},
  [2009] = {.lex_state = 14},
  [2010] = {.lex_state = 14},
  [2011] = {.lex_state = 14},
  [2012] = {.lex_state = 14},
  [2013] = {.lex_state = 14},
  [2014] = {.lex_state = 11},
  [2015] = {.lex_state = 14},
  [2016] = {.lex_state = 14},
  [2017] = {.lex_state = 14},
  [2018] = {.lex_state = 14},
  [2019] = {.lex_state = 14},
  [2020] = {.lex_state = 14},
  [2021] = {.lex_state = 14},
  [2022] = {.lex_state = 14},
  [2023] = {.lex_state = 11},
  [2024] = {.lex_state = 14},
  [2025] = {.lex_state = 14},
  [2026] = {.lex_state = 14},
  [2027] = {.lex_state = 14},
  [2028] = {.lex_state = 14},
  [2029] = {.lex_state = 14},
  [2030] = {.lex_state = 14},
  [2031] = {.lex_state = 14},
  [2032] = {.lex_state = 14},
  [2033] = {.lex_state = 14},
  [2034] = {.lex_state = 14},
  [2035] = {.lex_state = 11},
  [2036] = {.lex_state = 14},
  [2037] = {.lex_state = 14},
  [2038] = {.lex_state = 14},
  [2039] = {.lex_state = 14},
  [2040] = {.lex_state = 11},
  [2041] = {.lex_state = 11},
  [2042] = {.lex_state = 11},
  [2043] = {.lex_state = 11},
  [2044] = {.lex_state = 11},
  [2045] = {.lex_state = 11},
  [2046] = {.lex_state = 11},
  [2047] = {.lex_state = 11},
  [2048] = {.lex_state = 11},
  [2049] = {.lex_state = 11},
  [2050] = {.lex_state = 11},
  [2051] = {.lex_state = 11},
  [2052] = {.lex_state = 11},
  [2053] = {.lex_state = 11},
  [2054] = {.lex_state = 11},
  [2055] = {.lex_state = 11},
  [2056] = {.lex_state = 11},
  [2057] = {.lex_state = 11},
  [2058] = {.lex_state = 11},
  [2059] = {.lex_state = 11},
  [2060] = {.lex_state = 11},
  [2061] = {.lex_state = 11},
  [2062] = {.lex_state = 11},
  [2063] = {.lex_state = 11},
  [2064] = {.lex_state = 11},
  [2065] = {.lex_state = 11},
  [2066] = {.lex_state = 11},
  [2067] = {.lex_state = 11},
  [2068] = {.lex_state = 11},
  [2069] = {.lex_state = 11},
  [2070] = {.lex_state = 11},
  [2071] = {.lex_state = 11},
  [2072] = {.lex_state = 11},
  [2073] = {.lex_state = 11},
  [2074] = {.lex_state = 11},
  [2075] = {.lex_state = 11},
  [2076] = {.lex_state = 11},
  [2077] = {.lex_state = 11},
  [2078] = {.lex_state = 11},
  [2079] = {.lex_state = 11},
  [2080] = {.lex_state = 11},
  [2081] = {.lex_state = 11},
  [2082] = {.lex_state = 11},
  [2083] = {.lex_state = 11},
  [2084] = {.lex_state = 11},
  [2085] = {.lex_state = 11},
  [2086] = {.lex_state = 11},
  [2087] = {.lex_state = 11},
  [2088] = {.lex_state = 11},
  [2089] = {.lex_state = 20},
  [2090] = {.lex_state = 20},
  [2091] = {.lex_state = 21, .external_lex_state = 2},
  [2092] = {.lex_state = 20},
  [2093] = {.lex_state = 14},
  [2094] = {.lex_state = 20},
  [2095] = {.lex_state = 14},
  [2096] = {.lex_state = 20},
  [2097] = {.lex_state = 20},
  [2098] = {.lex_state = 20},
  [2099] = {.lex_state = 20},
  [2100] = {.lex_state = 20},
  [2101] = {.lex_state = 20},
  [2102] = {.lex_state = 20},
  [2103] = {.lex_state = 20},
  [2104] = {.lex_state = 21},
  [2105] = {.lex_state = 20},
  [2106] = {.lex_state = 20},
  [2107] = {.lex_state = 20},
  [2108] = {.lex_state = 20},
  [2109] = {.lex_state = 20},
  [2110] = {.lex_state = 20},
  [2111] = {.lex_state = 20},
  [2112] = {.lex_state = 20},
  [2113] = {.lex_state = 20},
  [2114] = {.lex_state = 20},
  [2115] = {.lex_state = 20},
  [2116] = {.lex_state = 20},
  [2117] = {.lex_state = 20},
  [2118] = {.lex_state = 20},
  [2119] = {.lex_state = 20},
  [2120] = {.lex_state = 20},
  [2121] = {.lex_state = 20},
  [2122] = {.lex_state = 20},
  [2123] = {.lex_state = 20},
  [2124] = {.lex_state = 20},
  [2125] = {.lex_state = 20},
  [2126] = {.lex_state = 20},
  [2127] = {.lex_state = 20},
  [2128] = {.lex_state = 20},
  [2129] = {.lex_state = 20},
  [2130] = {.lex_state = 20},
  [2131] = {.lex_state = 20},
  [2132] = {.lex_state = 20},
  [2133] = {.lex_state = 20},
  [2134] = {.lex_state = 20},
  [2135] = {.lex_state = 20},
  [2136] = {.lex_state = 20},
  [2137] = {.lex_state = 20},
  [2138] = {.lex_state = 20},
  [2139] = {.lex_state = 20},
  [2140] = {.lex_state = 20},
  [2141] = {.lex_state = 20},
  [2142] = {.lex_state = 20},
  [2143] = {.lex_state = 20},
  [2144] = {.lex_state = 20},
  [2145] = {.lex_state = 20},
  [2146] = {.lex_state = 20},
  [2147] = {.lex_state = 20},
  [2148] = {.lex_state = 20},
  [2149] = {.lex_state = 20},
  [2150] = {.lex_state = 20},
  [2151] = {.lex_state = 20},
  [2152] = {.lex_state = 20},
  [2153] = {.lex_state = 20},
  [2154] = {.lex_state = 20},
  [2155] = {.lex_state = 20},
  [2156] = {.lex_state = 20},
  [2157] = {.lex_state = 20},
  [2158] = {.lex_state = 20},
  [2159] = {.lex_state = 20},
  [2160] = {.lex_state = 20},
  [2161] = {.lex_state = 20},
  [2162] = {.lex_state = 20},
  [2163] = {.lex_state = 20},
  [2164] = {.lex_state = 20},
  [2165] = {.lex_state = 20},
  [2166] = {.lex_state = 20},
  [2167] = {.lex_state = 20},
  [2168] = {.lex_state = 20},
  [2169] = {.lex_state = 20},
  [2170] = {.lex_state = 20},
  [2171] = {.lex_state = 20},
  [2172] = {.lex_state = 20},
  [2173] = {.lex_state = 20},
  [2174] = {.lex_state = 20},
  [2175] = {.lex_state = 20},
  [2176] = {.lex_state = 20},
  [2177] = {.lex_state = 20},
  [2178] = {.lex_state = 20},
  [2179] = {.lex_state = 20},
  [2180] = {.lex_state = 20},
  [2181] = {.lex_state = 20},
  [2182] = {.lex_state = 20},
  [2183] = {.lex_state = 20},
  [2184] = {.lex_state = 20},
  [2185] = {.lex_state = 20},
  [2186] = {.lex_state = 20},
  [2187] = {.lex_state = 20},
  [2188] = {.lex_state = 20},
  [2189] = {.lex_state = 20},
  [2190] = {.lex_state = 20},
  [2191] = {.lex_state = 20},
  [2192] = {.lex_state = 20},
  [2193] = {.lex_state = 20},
  [2194] = {.lex_state = 20},
  [2195] = {.lex_state = 20},
  [2196] = {.lex_state = 20},
  [2197] = {.lex_state = 20},
  [2198] = {.lex_state = 20},
  [2199] = {.lex_state = 20},
  [2200] = {.lex_state = 20},
  [2201] = {.lex_state = 20},
  [2202] = {.lex_state = 20},
  [2203] = {.lex_state = 20},
  [2204] = {.lex_state = 20},
  [2205] = {.lex_state = 20},
  [2206] = {.lex_state = 20},
  [2207] = {.lex_state = 20},
  [2208] = {.lex_state = 20},
  [2209] = {.lex_state = 22},
  [2210] = {.lex_state = 22},
  [2211] = {.lex_state = 22},
  [2212] = {.lex_state = 22},
  [2213] = {.lex_state = 22},
  [2214] = {.lex_state = 22},
  [2215] = {.lex_state = 22},
  [2216] = {.lex_state = 22},
  [2217] = {.lex_state = 22},
  [2218] = {.lex_state = 22},
  [2219] = {.lex_state = 22},
  [2220] = {.lex_state = 22},
  [2221] = {.lex_state = 22},
  [2222] = {.lex_state = 22},
  [2223] = {.lex_state = 22},
  [2224] = {.lex_state = 23, .external_lex_state = 2},
  [2225] = {.lex_state = 22},
  [2226] = {.lex_state = 22},
  [2227] = {.lex_state = 22},
  [2228] = {.lex_state = 22},
  [2229] = {.lex_state = 22},
  [2230] = {.lex_state = 23},
  [2231] = {.lex_state = 22},
  [2232] = {.lex_state = 22},
  [2233] = {.lex_state = 22},
  [2234] = {.lex_state = 22},
  [2235] = {.lex_state = 22},
  [2236] = {.lex_state = 22},
  [2237] = {.lex_state = 22},
  [2238] = {.lex_state = 22},
  [2239] = {.lex_state = 22},
  [2240] = {.lex_state = 22},
  [2241] = {.lex_state = 22},
  [2242] = {.lex_state = 22},
  [2243] = {.lex_state = 22},
  [2244] = {.lex_state = 22},
  [2245] = {.lex_state = 22},
  [2246] = {.lex_state = 22},
  [2247] = {.lex_state = 22},
  [2248] = {.lex_state = 22},
  [2249] = {.lex_state = 22},
  [2250] = {.lex_state = 22},
  [2251] = {.lex_state = 22},
  [2252] = {.lex_state = 22},
  [2253] = {.lex_state = 22},
  [2254] = {.lex_state = 22},
  [2255] = {.lex_state = 22},
  [2256] = {.lex_state = 22},
  [2257] = {.lex_state = 22},
  [2258] = {.lex_state = 22},
  [2259] = {.lex_state = 22},
  [2260] = {.lex_state = 22},
  [2261] = {.lex_state = 22},
  [2262] = {.lex_state = 22},
  [2263] = {.lex_state = 22},
  [2264] = {.lex_state = 22},
  [2265] = {.lex_state = 22},
  [2266] = {.lex_state = 22},
  [2267] = {.lex_state = 22},
  [2268] = {.lex_state = 22},
  [2269] = {.lex_state = 22},
  [2270] = {.lex_state = 22},
  [2271] = {.lex_state = 22},
  [2272] = {.lex_state = 22},
  [2273] = {.lex_state = 22},
  [2274] = {.lex_state = 22},
  [2275] = {.lex_state = 22},
  [2276] = {.lex_state = 22},
  [2277] = {.lex_state = 22},
  [2278] = {.lex_state = 22},
  [2279] = {.lex_state = 22},
  [2280] = {.lex_state = 22},
  [2281] = {.lex_state = 22},
  [2282] = {.lex_state = 22},
  [2283] = {.lex_state = 22},
  [2284] = {.lex_state = 22},
  [2285] = {.lex_state = 22},
  [2286] = {.lex_state = 22},
  [2287] = {.lex_state = 22},
  [2288] = {.lex_state = 22},
  [2289] = {.lex_state = 22},
  [2290] = {.lex_state = 22},
  [2291] = {.lex_state = 22},
  [2292] = {.lex_state = 22},
  [2293] = {.lex_state = 22},
  [2294] = {.lex_state = 22},
  [2295] = {.lex_state = 22},
  [2296] = {.lex_state = 22},
  [2297] = {.lex_state = 22},
  [2298] = {.lex_state = 22},
  [2299] = {.lex_state = 22},
  [2300] = {.lex_state = 22},
  [2301] = {.lex_state = 22},
  [2302] = {.lex_state = 22},
  [2303] = {.lex_state = 22},
  [2304] = {.lex_state = 22},
  [2305] = {.lex_state = 22},
  [2306] = {.lex_state = 22},
  [2307] = {.lex_state = 22},
  [2308] = {.lex_state = 22},
  [2309] = {.lex_state = 22},
  [2310] = {.lex_state = 22},
  [2311] = {.lex_state = 22},
  [2312] = {.lex_state = 22},
  [2313] = {.lex_state = 22},
  [2314] = {.lex_state = 22},
  [2315] = {.lex_state = 22},
  [2316] = {.lex_state = 22},
  [2317] = {.lex_state = 22},
  [2318] = {.lex_state = 22},
  [2319] = {.lex_state = 22},
  [2320] = {.lex_state = 22},
  [2321] = {.lex_state = 24},
  [2322] = {.lex_state = 24},
  [2323] = {.lex_state = 24},
  [2324] = {.lex_state = 24},
  [2325] = {.lex_state = 24},
  [2326] = {.lex_state = 24},
  [2327] = {.lex_state = 24},
  [2328] = {.lex_state = 0},
  [2329] = {.lex_state = 26},
  [2330] = {.lex_state = 26},
  [2331] = {.lex_state = 26},
  [2332] = {.lex_state = 26},
  [2333] = {.lex_state = 26},
  [2334] = {.lex_state = 26},
  [2335] = {.lex_state = 26},
  [2336] = {.lex_state = 26},
  [2337] = {.lex_state = 26},
  [2338] = {.lex_state = 26},
  [2339] = {.lex_state = 26},
  [2340] = {.lex_state = 26},
  [2341] = {.lex_state = 26},
  [2342] = {.lex_state = 26},
  [2343] = {.lex_state = 26},
  [2344] = {.lex_state = 26},
  [2345] = {.lex_state = 26},
  [2346] = {.lex_state = 26},
  [2347] = {.lex_state = 26},
  [2348] = {.lex_state = 26},
  [2349] = {.lex_state = 26},
  [2350] = {.lex_state = 26},
  [2351] = {.lex_state = 26},
  [2352] = {.lex_state = 26},
  [2353] = {.lex_state = 26},
  [2354] = {.lex_state = 26},
  [2355] = {.lex_state = 26},
  [2356] = {.lex_state = 29},
  [2357] = {.lex_state = 29},
  [2358] = {.lex_state = 29},
  [2359] = {.lex_state = 29},
  [2360] = {.lex_state = 26},
  [2361] = {.lex_state = 26},
  [2362] = {.lex_state = 29},
  [2363] = {.lex_state = 29},
  [2364] = {.lex_state = 29},
  [2365] = {.lex_state = 26},
  [2366] = {.lex_state = 26},
  [2367] = {.lex_state = 26},
  [2368] = {.lex_state = 29},
  [2369] = {.lex_state = 26},
  [2370] = {.lex_state = 26},
  [2371] = {.lex_state = 29},
  [2372] = {.lex_state = 26},
  [2373] = {.lex_state = 29},
  [2374] = {.lex_state = 29},
  [2375] = {.lex_state = 26},
  [2376] = {.lex_state = 29},
  [2377] = {.lex_state = 29},
  [2378] = {.lex_state = 26},
  [2379] = {.lex_state = 29},
  [2380] = {.lex_state = 35},
  [2381] = {.lex_state = 35},
  [2382] = {.lex_state = 35},
  [2383] = {.lex_state = 27},
  [2384] = {.lex_state = 27},
  [2385] = {.lex_state = 35},
  [2386] = {.lex_state = 35},
  [2387] = {.lex_state = 35},
  [2388] = {.lex_state = 35},
  [2389] = {.lex_state = 35},
  [2390] = {.lex_state = 35},
  [2391] = {.lex_state = 35},
  [2392] = {.lex_state = 35},
  [2393] = {.lex_state = 35},
  [2394] = {.lex_state = 35},
  [2395] = {.lex_state = 35},
  [2396] = {.lex_state = 35},
  [2397] = {.lex_state = 35},
  [2398] = {.lex_state = 35},
  [2399] = {.lex_state = 35},
  [2400] = {.lex_state = 27},
  [2401] = {.lex_state = 27},
  [2402] = {.lex_state = 35},
  [2403] = {.lex_state = 35},
  [2404] = {.lex_state = 35},
  [2405] = {.lex_state = 35},
  [2406] = {.lex_state = 35},
  [2407] = {.lex_state = 35},
  [2408] = {.lex_state = 35},
  [2409] = {.lex_state = 35},
  [2410] = {.lex_state = 27},
  [2411] = {.lex_state = 27},
  [2412] = {.lex_state = 35},
  [2413] = {.lex_state = 35},
  [2414] = {.lex_state = 35},
  [2415] = {.lex_state = 35},
  [2416] = {.lex_state = 35},
  [2417] = {.lex_state = 35},
  [2418] = {.lex_state = 35},
  [2419] = {.lex_state = 35},
  [2420] = {.lex_state = 35},
  [2421] = {.lex_state = 35},
  [2422] = {.lex_state = 35},
  [2423] = {.lex_state = 35},
  [2424] = {.lex_state = 35},
  [2425] = {.lex_state = 35},
  [2426] = {.lex_state = 35},
  [2427] = {.lex_state = 35},
  [2428] = {.lex_state = 35},
  [2429] = {.lex_state = 35},
  [2430] = {.lex_state = 35},
  [2431] = {.lex_state = 35},
  [2432] = {.lex_state = 35},
  [2433] = {.lex_state = 35},
  [2434] = {.lex_state = 35},
  [2435] = {.lex_state = 35},
  [2436] = {.lex_state = 35},
  [2437] = {.lex_state = 35},
  [2438] = {.lex_state = 35},
  [2439] = {.lex_state = 35},
  [2440] = {.lex_state = 35},
  [2441] = {.lex_state = 27},
  [2442] = {.lex_state = 27},
  [2443] = {.lex_state = 35},
  [2444] = {.lex_state = 27},
  [2445] = {.lex_state = 35},
  [2446] = {.lex_state = 35},
  [2447] = {.lex_state = 35},
  [2448] = {.lex_state = 35},
  [2449] = {.lex_state = 35},
  [2450] = {.lex_state = 35},
  [2451] = {.lex_state = 35},
  [2452] = {.lex_state = 35},
  [2453] = {.lex_state = 35},
  [2454] = {.lex_state = 35},
  [2455] = {.lex_state = 35},
  [2456] = {.lex_state = 35},
  [2457] = {.lex_state = 35},
  [2458] = {.lex_state = 35},
  [2459] = {.lex_state = 27},
  [2460] = {.lex_state = 35},
  [2461] = {.lex_state = 35},
  [2462] = {.lex_state = 35},
  [2463] = {.lex_state = 35},
  [2464] = {.lex_state = 35},
  [2465] = {.lex_state = 35},
  [2466] = {.lex_state = 35},
  [2467] = {.lex_state = 35},
  [2468] = {.lex_state = 35},
  [2469] = {.lex_state = 35},
  [2470] = {.lex_state = 35},
  [2471] = {.lex_state = 35},
  [2472] = {.lex_state = 35},
  [2473] = {.lex_state = 27},
  [2474] = {.lex_state = 27},
  [2475] = {.lex_state = 35},
  [2476] = {.lex_state = 35},
  [2477] = {.lex_state = 35},
  [2478] = {.lex_state = 35},
  [2479] = {.lex_state = 35},
  [2480] = {.lex_state = 35},
  [2481] = {.lex_state = 35},
  [2482] = {.lex_state = 35},
  [2483] = {.lex_state = 35},
  [2484] = {.lex_state = 35},
  [2485] = {.lex_state = 35},
  [2486] = {.lex_state = 35},
  [2487] = {.lex_state = 35},
  [2488] = {.lex_state = 35},
  [2489] = {.lex_state = 35},
  [2490] = {.lex_state = 35},
  [2491] = {.lex_state = 35},
  [2492] = {.lex_state = 35},
  [2493] = {.lex_state = 35},
  [2494] = {.lex_state = 35},
  [2495] = {.lex_state = 35},
  [2496] = {.lex_state = 35},
  [2497] = {.lex_state = 35},
  [2498] = {.lex_state = 27},
  [2499] = {.lex_state = 35},
  [2500] = {.lex_state = 35},
  [2501] = {.lex_state = 35},
  [2502] = {.lex_state = 35},
  [2503] = {.lex_state = 35},
  [2504] = {.lex_state = 35},
  [2505] = {.lex_state = 35},
  [2506] = {.lex_state = 35},
  [2507] = {.lex_state = 35},
  [2508] = {.lex_state = 35},
  [2509] = {.lex_state = 35},
  [2510] = {.lex_state = 35},
  [2511] = {.lex_state = 35},
  [2512] = {.lex_state = 35},
  [2513] = {.lex_state = 35},
  [2514] = {.lex_state = 35},
  [2515] = {.lex_state = 27},
  [2516] = {.lex_state = 27},
  [2517] = {.lex_state = 35},
  [2518] = {.lex_state = 35},
  [2519] = {.lex_state = 35},
  [2520] = {.lex_state = 35},
  [2521] = {.lex_state = 35},
  [2522] = {.lex_state = 35},
  [2523] = {.lex_state = 35},
  [2524] = {.lex_state = 35},
  [2525] = {.lex_state = 35},
  [2526] = {.lex_state = 35},
  [2527] = {.lex_state = 35},
  [2528] = {.lex_state = 35},
  [2529] = {.lex_state = 35},
  [2530] = {.lex_state = 35},
  [2531] = {.lex_state = 35},
  [2532] = {.lex_state = 35},
  [2533] = {.lex_state = 35},
  [2534] = {.lex_state = 35},
  [2535] = {.lex_state = 35},
  [2536] = {.lex_state = 35},
  [2537] = {.lex_state = 35},
  [2538] = {.lex_state = 35},
  [2539] = {.lex_state = 35},
  [2540] = {.lex_state = 35},
  [2541] = {.lex_state = 35},
  [2542] = {.lex_state = 35},
  [2543] = {.lex_state = 35},
  [2544] = {.lex_state = 35},
  [2545] = {.lex_state = 27},
  [2546] = {.lex_state = 35},
  [2547] = {.lex_state = 35},
  [2548] = {.lex_state = 35},
  [2549] = {.lex_state = 35},
  [2550] = {.lex_state = 35},
  [2551] = {.lex_state = 35},
  [2552] = {.lex_state = 35},
  [2553] = {.lex_state = 27},
  [2554] = {.lex_state = 27},
  [2555] = {.lex_state = 35},
  [2556] = {.lex_state = 35},
  [2557] = {.lex_state = 35},
  [2558] = {.lex_state = 35},
  [2559] = {.lex_state = 35},
  [2560] = {.lex_state = 35},
  [2561] = {.lex_state = 35},
  [2562] = {.lex_state = 35},
  [2563] = {.lex_state = 35},
  [2564] = {.lex_state = 35},
  [2565] = {.lex_state = 35},
  [2566] = {.lex_state = 35},
  [2567] = {.lex_state = 35},
  [2568] = {.lex_state = 35},
  [2569] = {.lex_state = 35},
  [2570] = {.lex_state = 35},
  [2571] = {.lex_state = 35},
  [2572] = {.lex_state = 35},
  [2573] = {.lex_state = 35},
  [2574] = {.lex_state = 35},
  [2575] = {.lex_state = 35},
  [2576] = {.lex_state = 35},
  [2577] = {.lex_state = 35},
  [2578] = {.lex_state = 35},
  [2579] = {.lex_state = 35},
  [2580] = {.lex_state = 35},
  [2581] = {.lex_state = 35},
  [2582] = {.lex_state = 35},
  [2583] = {.lex_state = 27},
  [2584] = {.lex_state = 35},
  [2585] = {.lex_state = 35},
  [2586] = {.lex_state = 35},
  [2587] = {.lex_state = 35},
  [2588] = {.lex_state = 35},
  [2589] = {.lex_state = 35},
  [2590] = {.lex_state = 35},
  [2591] = {.lex_state = 35},
  [2592] = {.lex_state = 35},
  [2593] = {.lex_state = 35},
  [2594] = {.lex_state = 35},
  [2595] = {.lex_state = 35},
  [2596] = {.lex_state = 35},
  [2597] = {.lex_state = 35},
  [2598] = {.lex_state = 35},
  [2599] = {.lex_state = 35},
  [2600] = {.lex_state = 35},
  [2601] = {.lex_state = 35},
  [2602] = {.lex_state = 35},
  [2603] = {.lex_state = 35},
  [2604] = {.lex_state = 35},
  [2605] = {.lex_state = 35},
  [2606] = {.lex_state = 35},
  [2607] = {.lex_state = 35},
  [2608] = {.lex_state = 35},
  [2609] = {.lex_state = 35},
  [2610] = {.lex_state = 27},
  [2611] = {.lex_state = 35},
  [2612] = {.lex_state = 28},
  [2613] = {.lex_state = 26},
  [2614] = {.lex_state = 26},
  [2615] = {.lex_state = 35},
  [2616] = {.lex_state = 35},
  [2617] = {.lex_state = 35},
  [2618] = {.lex_state = 35},
  [2619] = {.lex_state = 35},
  [2620] = {.lex_state = 35},
  [2621] = {.lex_state = 35},
  [2622] = {.lex_state = 26},
  [2623] = {.lex_state = 35},
  [2624] = {.lex_state = 35},
  [2625] = {.lex_state = 35},
  [2626] = {.lex_state = 35},
  [2627] = {.lex_state = 26},
  [2628] = {.lex_state = 26},
  [2629] = {.lex_state = 26},
  [2630] = {.lex_state = 28},
  [2631] = {.lex_state = 35},
  [2632] = {.lex_state = 26},
  [2633] = {.lex_state = 26},
  [2634] = {.lex_state = 35},
  [2635] = {.lex_state = 35},
  [2636] = {.lex_state = 26},
  [2637] = {.lex_state = 35},
  [2638] = {.lex_state = 26},
  [2639] = {.lex_state = 26},
  [2640] = {.lex_state = 26},
  [2641] = {.lex_state = 26},
  [2642] = {.lex_state = 26},
  [2643] = {.lex_state = 26},
  [2644] = {.lex_state = 35},
  [2645] = {.lex_state = 28},
  [2646] = {.lex_state = 35},
  [2647] = {.lex_state = 26},
  [2648] = {.lex_state = 35},
  [2649] = {.lex_state = 26},
  [2650] = {.lex_state = 26},
  [2651] = {.lex_state = 35},
  [2652] = {.lex_state = 35},
  [2653] = {.lex_state = 26},
  [2654] = {.lex_state = 35},
  [2655] = {.lex_state = 35},
  [2656] = {.lex_state = 29},
  [2657] = {.lex_state = 26},
  [2658] = {.lex_state = 26},
  [2659] = {.lex_state = 26},
  [2660] = {.lex_state = 26},
  [2661] = {.lex_state = 26},
  [2662] = {.lex_state = 28},
  [2663] = {.lex_state = 35},
  [2664] = {.lex_state = 35},
  [2665] = {.lex_state = 35},
  [2666] = {.lex_state = 28},
  [2667] = {.lex_state = 35},
  [2668] = {.lex_state = 35},
  [2669] = {.lex_state = 26},
  [2670] = {.lex_state = 35},
  [2671] = {.lex_state = 26},
  [2672] = {.lex_state = 26},
  [2673] = {.lex_state = 26},
  [2674] = {.lex_state = 35},
  [2675] = {.lex_state = 35},
  [2676] = {.lex_state = 35},
  [2677] = {.lex_state = 28},
  [2678] = {.lex_state = 35},
  [2679] = {.lex_state = 35},
  [2680] = {.lex_state = 26},
  [2681] = {.lex_state = 26},
  [2682] = {.lex_state = 26},
  [2683] = {.lex_state = 26},
  [2684] = {.lex_state = 35},
  [2685] = {.lex_state = 35},
  [2686] = {.lex_state = 26},
  [2687] = {.lex_state = 26},
  [2688] = {.lex_state = 26},
  [2689] = {.lex_state = 35},
  [2690] = {.lex_state = 28},
  [2691] = {.lex_state = 35},
  [2692] = {.lex_state = 26},
  [2693] = {.lex_state = 26},
  [2694] = {.lex_state = 35},
  [2695] = {.lex_state = 35},
  [2696] = {.lex_state = 35},
  [2697] = {.lex_state = 35},
  [2698] = {.lex_state = 35},
  [2699] = {.lex_state = 26},
  [2700] = {.lex_state = 26},
  [2701] = {.lex_state = 26},
  [2702] = {.lex_state = 35},
  [2703] = {.lex_state = 35},
  [2704] = {.lex_state = 35},
  [2705] = {.lex_state = 26},
  [2706] = {.lex_state = 26},
  [2707] = {.lex_state = 26},
  [2708] = {.lex_state = 26},
  [2709] = {.lex_state = 35},
  [2710] = {.lex_state = 26},
  [2711] = {.lex_state = 35},
  [2712] = {.lex_state = 35},
  [2713] = {.lex_state = 35},
  [2714] = {.lex_state = 26},
  [2715] = {.lex_state = 35},
  [2716] = {.lex_state = 35},
  [2717] = {.lex_state = 26},
  [2718] = {.lex_state = 28},
  [2719] = {.lex_state = 35},
  [2720] = {.lex_state = 35},
  [2721] = {.lex_state = 26},
  [2722] = {.lex_state = 35},
  [2723] = {.lex_state = 29},
  [2724] = {.lex_state = 26},
  [2725] = {.lex_state = 26},
  [2726] = {.lex_state = 35},
  [2727] = {.lex_state = 35},
  [2728] = {.lex_state = 35},
  [2729] = {.lex_state = 26},
  [2730] = {.lex_state = 35},
  [2731] = {.lex_state = 26},
  [2732] = {.lex_state = 26},
  [2733] = {.lex_state = 26},
  [2734] = {.lex_state = 35},
  [2735] = {.lex_state = 28},
  [2736] = {.lex_state = 28},
  [2737] = {.lex_state = 26},
  [2738] = {.lex_state = 35},
  [2739] = {.lex_state = 35},
  [2740] = {.lex_state = 26},
  [2741] = {.lex_state = 28},
  [2742] = {.lex_state = 26},
  [2743] = {.lex_state = 26},
  [2744] = {.lex_state = 35},
  [2745] = {.lex_state = 35},
  [2746] = {.lex_state = 35},
  [2747] = {.lex_state = 26},
  [2748] = {.lex_state = 35},
  [2749] = {.lex_state = 26},
  [2750] = {.lex_state = 26},
  [2751] = {.lex_state = 35},
  [2752] = {.lex_state = 35},
  [2753] = {.lex_state = 35},
  [2754] = {.lex_state = 35},
  [2755] = {.lex_state = 26},
  [2756] = {.lex_state = 0},
  [2757] = {.lex_state = 0},
  [2758] = {.lex_state = 0},
  [2759] = {.lex_state = 0},
  [2760] = {.lex_state = 0},
  [2761] = {.lex_state = 0},
  [2762] = {.lex_state = 0},
  [2763] = {.lex_state = 0},
  [2764] = {.lex_state = 0},
  [2765] = {.lex_state = 0},
  [2766] = {.lex_state = 0},
  [2767] = {.lex_state = 0},
  [2768] = {.lex_state = 0},
  [2769] = {.lex_state = 0},
  [2770] = {.lex_state = 0},
  [2771] = {.lex_state = 0},
  [2772] = {.lex_state = 0},
  [2773] = {.lex_state = 0},
  [2774] = {.lex_state = 0},
  [2775] = {.lex_state = 0},
  [2776] = {.lex_state = 0},
  [2777] = {.lex_state = 0},
  [2778] = {.lex_state = 0},
  [2779] = {.lex_state = 0},
  [2780] = {.lex_state = 0},
  [2781] = {.lex_state = 0},
  [2782] = {.lex_state = 0},
  [2783] = {.lex_state = 0},
  [2784] = {.lex_state = 0},
  [2785] = {.lex_state = 0},
  [2786] = {.lex_state = 0},
  [2787] = {.lex_state = 0},
  [2788] = {.lex_state = 0},
  [2789] = {.lex_state = 24},
  [2790] = {.lex_state = 0},
  [2791] = {.lex_state = 0},
  [2792] = {.lex_state = 0},
  [2793] = {.lex_state = 0},
  [2794] = {.lex_state = 0},
  [2795] = {.lex_state = 0},
  [2796] = {.lex_state = 0},
  [2797] = {.lex_state = 0},
  [2798] = {.lex_state = 0},
  [2799] = {.lex_state = 0},
  [2800] = {.lex_state = 0},
  [2801] = {.lex_state = 0},
  [2802] = {.lex_state = 0},
  [2803] = {.lex_state = 0},
  [2804] = {.lex_state = 0},
  [2805] = {.lex_state = 0},
  [2806] = {.lex_state = 0},
  [2807] = {.lex_state = 0},
  [2808] = {.lex_state = 0},
  [2809] = {.lex_state = 24},
  [2810] = {.lex_state = 24},
  [2811] = {.lex_state = 0},
  [2812] = {.lex_state = 0},
  [2813] = {.lex_state = 24},
  [2814] = {.lex_state = 0},
  [2815] = {.lex_state = 24},
  [2816] = {.lex_state = 0},
  [2817] = {.lex_state = 24},
  [2818] = {.lex_state = 0},
  [2819] = {.lex_state = 30},
  [2820] = {.lex_state = 0},
  [2821] = {.lex_state = 0},
  [2822] = {.lex_state = 0},
  [2823] = {.lex_state = 0},
  [2824] = {.lex_state = 0},
  [2825] = {.lex_state = 0},
  [2826] = {.lex_state = 0},
  [2827] = {.lex_state = 0},
  [2828] = {.lex_state = 24},
  [2829] = {.lex_state = 0},
  [2830] = {.lex_state = 0},
  [2831] = {.lex_state = 0},
  [2832] = {.lex_state = 26},
  [2833] = {.lex_state = 0},
  [2834] = {.lex_state = 0},
  [2835] = {.lex_state = 0},
  [2836] = {.lex_state = 0},
  [2837] = {.lex_state = 0},
  [2838] = {.lex_state = 0},
  [2839] = {.lex_state = 0},
  [2840] = {.lex_state = 24},
  [2841] = {.lex_state = 0},
  [2842] = {.lex_state = 0},
  [2843] = {.lex_state = 0},
  [2844] = {.lex_state = 0},
  [2845] = {.lex_state = 0},
  [2846] = {.lex_state = 0},
  [2847] = {.lex_state = 0},
  [2848] = {.lex_state = 0},
  [2849] = {.lex_state = 0},
  [2850] = {.lex_state = 0},
  [2851] = {.lex_state = 0},
  [2852] = {.lex_state = 0},
  [2853] = {.lex_state = 24},
  [2854] = {.lex_state = 0},
  [2855] = {.lex_state = 24},
  [2856] = {.lex_state = 0},
  [2857] = {.lex_state = 24},
  [2858] = {.lex_state = 0},
  [2859] = {.lex_state = 24},
  [2860] = {.lex_state = 0},
  [2861] = {.lex_state = 0},
  [2862] = {.lex_state = 0},
  [2863] = {.lex_state = 0},
  [2864] = {.lex_state = 0},
  [2865] = {.lex_state = 0},
  [2866] = {.lex_state = 0},
  [2867] = {.lex_state = 0},
  [2868] = {.lex_state = 0},
  [2869] = {.lex_state = 0},
  [2870] = {.lex_state = 0},
  [2871] = {.lex_state = 0},
  [2872] = {.lex_state = 0},
  [2873] = {.lex_state = 0},
  [2874] = {.lex_state = 0},
  [2875] = {.lex_state = 0},
  [2876] = {.lex_state = 0},
  [2877] = {.lex_state = 0},
  [2878] = {.lex_state = 0},
  [2879] = {.lex_state = 0},
  [2880] = {.lex_state = 0},
  [2881] = {.lex_state = 0},
  [2882] = {.lex_state = 0},
  [2883] = {.lex_state = 0},
  [2884] = {.lex_state = 0},
  [2885] = {.lex_state = 0},
  [2886] = {.lex_state = 0},
  [2887] = {.lex_state = 0},
  [2888] = {.lex_state = 0},
  [2889] = {.lex_state = 0},
  [2890] = {.lex_state = 24},
  [2891] = {.lex_state = 0},
  [2892] = {.lex_state = 0},
  [2893] = {.lex_state = 35},
  [2894] = {.lex_state = 0},
  [2895] = {.lex_state = 0},
  [2896] = {.lex_state = 0},
  [2897] = {.lex_state = 0},
  [2898] = {.lex_state = 35},
  [2899] = {.lex_state = 0},
  [2900] = {.lex_state = 0},
  [2901] = {.lex_state = 0},
  [2902] = {.lex_state = 0},
  [2903] = {.lex_state = 0},
  [2904] = {.lex_state = 0},
  [2905] = {.lex_state = 30},
  [2906] = {.lex_state = 0},
  [2907] = {.lex_state = 0},
  [2908] = {.lex_state = 0},
  [2909] = {.lex_state = 0},
  [2910] = {.lex_state = 0},
  [2911] = {.lex_state = 0},
  [2912] = {.lex_state = 0},
  [2913] = {.lex_state = 0},
  [2914] = {.lex_state = 0},
  [2915] = {.lex_state = 26},
  [2916] = {.lex_state = 0},
  [2917] = {.lex_state = 0},
  [2918] = {.lex_state = 0},
  [2919] = {.lex_state = 0},
  [2920] = {.lex_state = 0},
  [2921] = {.lex_state = 0},
  [2922] = {.lex_state = 30},
  [2923] = {.lex_state = 0},
  [2924] = {.lex_state = 0},
  [2925] = {.lex_state = 0},
  [2926] = {.lex_state = 0},
  [2927] = {.lex_state = 0},
  [2928] = {.lex_state = 0},
  [2929] = {.lex_state = 0},
  [2930] = {.lex_state = 0},
  [2931] = {.lex_state = 0},
  [2932] = {.lex_state = 0},
  [2933] = {.lex_state = 0},
  [2934] = {.lex_state = 0},
  [2935] = {.lex_state = 0},
  [2936] = {.lex_state = 0},
  [2937] = {.lex_state = 26},
  [2938] = {.lex_state = 0},
  [2939] = {.lex_state = 0},
  [2940] = {.lex_state = 0},
  [2941] = {.lex_state = 0},
  [2942] = {.lex_state = 0},
  [2943] = {.lex_state = 0},
  [2944] = {.lex_state = 0},
  [2945] = {.lex_state = 0},
  [2946] = {.lex_state = 0},
  [2947] = {.lex_state = 0},
  [2948] = {.lex_state = 0},
  [2949] = {.lex_state = 0},
  [2950] = {.lex_state = 0},
  [2951] = {.lex_state = 0},
  [2952] = {.lex_state = 0},
  [2953] = {.lex_state = 0},
  [2954] = {.lex_state = 0},
  [2955] = {.lex_state = 0},
  [2956] = {.lex_state = 0},
  [2957] = {.lex_state = 0},
  [2958] = {.lex_state = 0},
  [2959] = {.lex_state = 0},
  [2960] = {.lex_state = 0},
  [2961] = {.lex_state = 0},
  [2962] = {.lex_state = 0},
  [2963] = {.lex_state = 0},
  [2964] = {.lex_state = 30},
  [2965] = {.lex_state = 0},
  [2966] = {.lex_state = 0},
  [2967] = {.lex_state = 0},
  [2968] = {.lex_state = 0},
  [2969] = {.lex_state = 0},
  [2970] = {.lex_state = 0},
  [2971] = {.lex_state = 0},
  [2972] = {.lex_state = 0},
  [2973] = {.lex_state = 0},
  [2974] = {.lex_state = 0},
  [2975] = {.lex_state = 0},
  [2976] = {.lex_state = 0},
  [2977] = {.lex_state = 0},
  [2978] = {.lex_state = 0},
  [2979] = {.lex_state = 0},
  [2980] = {.lex_state = 0},
  [2981] = {.lex_state = 0},
  [2982] = {.lex_state = 0},
  [2983] = {.lex_state = 0},
  [2984] = {.lex_state = 0},
  [2985] = {.lex_state = 0},
  [2986] = {.lex_state = 0},
  [2987] = {.lex_state = 0},
  [2988] = {.lex_state = 0},
  [2989] = {.lex_state = 0},
  [2990] = {.lex_state = 0},
  [2991] = {.lex_state = 0},
  [2992] = {.lex_state = 0},
  [2993] = {.lex_state = 0},
  [2994] = {.lex_state = 0},
  [2995] = {.lex_state = 24},
  [2996] = {.lex_state = 0},
  [2997] = {.lex_state = 0},
  [2998] = {.lex_state = 0},
  [2999] = {.lex_state = 0},
  [3000] = {.lex_state = 0},
  [3001] = {.lex_state = 0},
  [3002] = {.lex_state = 26},
  [3003] = {.lex_state = 0},
  [3004] = {.lex_state = 0},
  [3005] = {.lex_state = 0},
  [3006] = {.lex_state = 0},
  [3007] = {.lex_state = 0},
  [3008] = {.lex_state = 0},
  [3009] = {.lex_state = 0},
  [3010] = {.lex_state = 0},
  [3011] = {.lex_state = 0},
  [3012] = {.lex_state = 0},
  [3013] = {.lex_state = 0},
  [3014] = {.lex_state = 0},
  [3015] = {.lex_state = 0},
  [3016] = {.lex_state = 0},
  [3017] = {.lex_state = 0},
  [3018] = {.lex_state = 0},
  [3019] = {.lex_state = 0},
  [3020] = {.lex_state = 0},
  [3021] = {.lex_state = 0},
  [3022] = {.lex_state = 0},
  [3023] = {.lex_state = 0},
  [3024] = {.lex_state = 0},
  [3025] = {.lex_state = 0},
  [3026] = {.lex_state = 0},
  [3027] = {.lex_state = 0},
  [3028] = {.lex_state = 0},
  [3029] = {.lex_state = 0},
  [3030] = {.lex_state = 0},
  [3031] = {.lex_state = 0},
  [3032] = {.lex_state = 30},
  [3033] = {.lex_state = 0},
  [3034] = {.lex_state = 0},
  [3035] = {.lex_state = 0},
  [3036] = {.lex_state = 0},
  [3037] = {.lex_state = 0},
  [3038] = {.lex_state = 0},
  [3039] = {.lex_state = 0},
  [3040] = {.lex_state = 0},
  [3041] = {.lex_state = 0},
  [3042] = {.lex_state = 0},
  [3043] = {.lex_state = 0},
  [3044] = {.lex_state = 0},
  [3045] = {.lex_state = 0},
  [3046] = {.lex_state = 0},
  [3047] = {.lex_state = 26},
  [3048] = {.lex_state = 0},
  [3049] = {.lex_state = 0},
  [3050] = {.lex_state = 0},
  [3051] = {.lex_state = 0},
  [3052] = {.lex_state = 0},
  [3053] = {.lex_state = 0},
  [3054] = {.lex_state = 0},
  [3055] = {.lex_state = 0},
  [3056] = {.lex_state = 0},
  [3057] = {.lex_state = 0},
  [3058] = {.lex_state = 0},
  [3059] = {.lex_state = 0},
  [3060] = {.lex_state = 0},
  [3061] = {.lex_state = 0},
  [3062] = {.lex_state = 0},
  [3063] = {.lex_state = 0},
  [3064] = {.lex_state = 0},
  [3065] = {.lex_state = 0},
  [3066] = {.lex_state = 0},
  [3067] = {.lex_state = 0},
  [3068] = {.lex_state = 0},
  [3069] = {.lex_state = 0},
  [3070] = {.lex_state = 0},
  [3071] = {.lex_state = 0},
  [3072] = {.lex_state = 0},
  [3073] = {.lex_state = 0},
  [3074] = {.lex_state = 0},
  [3075] = {.lex_state = 0},
  [3076] = {.lex_state = 0},
  [3077] = {.lex_state = 0},
  [3078] = {.lex_state = 0},
  [3079] = {.lex_state = 0},
  [3080] = {.lex_state = 0},
  [3081] = {.lex_state = 0},
  [3082] = {.lex_state = 0},
  [3083] = {.lex_state = 0},
  [3084] = {.lex_state = 0},
  [3085] = {.lex_state = 0},
  [3086] = {.lex_state = 0},
  [3087] = {.lex_state = 0},
  [3088] = {.lex_state = 0},
  [3089] = {.lex_state = 0},
  [3090] = {.lex_state = 0},
  [3091] = {.lex_state = 0},
  [3092] = {.lex_state = 0},
  [3093] = {.lex_state = 24},
  [3094] = {.lex_state = 0},
  [3095] = {.lex_state = 0},
  [3096] = {.lex_state = 0},
  [3097] = {.lex_state = 0},
  [3098] = {.lex_state = 0},
  [3099] = {.lex_state = 0},
  [3100] = {.lex_state = 0},
  [3101] = {.lex_state = 0},
  [3102] = {.lex_state = 0},
  [3103] = {.lex_state = 0},
  [3104] = {.lex_state = 0},
  [3105] = {.lex_state = 0},
  [3106] = {.lex_state = 0},
  [3107] = {.lex_state = 0},
  [3108] = {.lex_state = 0},
  [3109] = {.lex_state = 0},
  [3110] = {.lex_state = 0},
  [3111] = {.lex_state = 0},
  [3112] = {.lex_state = 0},
  [3113] = {.lex_state = 0},
  [3114] = {.lex_state = 0},
  [3115] = {.lex_state = 0},
  [3116] = {.lex_state = 0},
  [3117] = {.lex_state = 0},
  [3118] = {.lex_state = 0},
  [3119] = {.lex_state = 0},
  [3120] = {.lex_state = 0},
  [3121] = {.lex_state = 0},
  [3122] = {.lex_state = 0},
  [3123] = {.lex_state = 0},
  [3124] = {.lex_state = 0},
  [3125] = {.lex_state = 30},
  [3126] = {.lex_state = 0},
  [3127] = {.lex_state = 0},
  [3128] = {.lex_state = 0},
  [3129] = {.lex_state = 0},
  [3130] = {.lex_state = 0},
  [3131] = {.lex_state = 0},
  [3132] = {.lex_state = 0},
  [3133] = {.lex_state = 0},
  [3134] = {.lex_state = 0},
  [3135] = {.lex_state = 0},
  [3136] = {.lex_state = 0},
  [3137] = {.lex_state = 0},
  [3138] = {.lex_state = 0},
  [3139] = {.lex_state = 0},
  [3140] = {.lex_state = 26},
  [3141] = {.lex_state = 0},
  [3142] = {.lex_state = 0},
  [3143] = {.lex_state = 0},
  [3144] = {.lex_state = 0},
  [3145] = {.lex_state = 0},
  [3146] = {.lex_state = 0},
  [3147] = {.lex_state = 0},
  [3148] = {.lex_state = 0},
  [3149] = {.lex_state = 0},
  [3150] = {.lex_state = 0},
  [3151] = {.lex_state = 0},
  [3152] = {.lex_state = 0},
  [3153] = {.lex_state = 0},
  [3154] = {.lex_state = 0},
  [3155] = {.lex_state = 0},
  [3156] = {.lex_state = 0},
  [3157] = {.lex_state = 0},
  [3158] = {.lex_state = 0},
  [3159] = {.lex_state = 0},
  [3160] = {.lex_state = 0},
  [3161] = {.lex_state = 0},
  [3162] = {.lex_state = 0},
  [3163] = {.lex_state = 0},
  [3164] = {.lex_state = 0},
  [3165] = {.lex_state = 0},
  [3166] = {.lex_state = 0},
  [3167] = {.lex_state = 0},
  [3168] = {.lex_state = 0},
  [3169] = {.lex_state = 0},
  [3170] = {.lex_state = 0},
  [3171] = {.lex_state = 0},
  [3172] = {.lex_state = 0},
  [3173] = {.lex_state = 0},
  [3174] = {.lex_state = 0},
  [3175] = {.lex_state = 0},
  [3176] = {.lex_state = 24},
  [3177] = {.lex_state = 0},
  [3178] = {.lex_state = 0},
  [3179] = {.lex_state = 0},
  [3180] = {.lex_state = 0},
  [3181] = {.lex_state = 0},
  [3182] = {.lex_state = 0},
  [3183] = {.lex_state = 0},
  [3184] = {.lex_state = 0},
  [3185] = {.lex_state = 0},
  [3186] = {.lex_state = 0},
  [3187] = {.lex_state = 0},
  [3188] = {.lex_state = 0},
  [3189] = {.lex_state = 0},
  [3190] = {.lex_state = 0},
  [3191] = {.lex_state = 0},
  [3192] = {.lex_state = 0},
  [3193] = {.lex_state = 0},
  [3194] = {.lex_state = 0},
  [3195] = {.lex_state = 0},
  [3196] = {.lex_state = 0},
  [3197] = {.lex_state = 0},
  [3198] = {.lex_state = 0},
  [3199] = {.lex_state = 0},
  [3200] = {.lex_state = 0},
  [3201] = {.lex_state = 0},
  [3202] = {.lex_state = 0},
  [3203] = {.lex_state = 0},
  [3204] = {.lex_state = 0},
  [3205] = {.lex_state = 0},
  [3206] = {.lex_state = 0},
  [3207] = {.lex_state = 0},
  [3208] = {.lex_state = 30},
  [3209] = {.lex_state = 0},
  [3210] = {.lex_state = 0},
  [3211] = {.lex_state = 0},
  [3212] = {.lex_state = 0},
  [3213] = {.lex_state = 0},
  [3214] = {.lex_state = 0},
  [3215] = {.lex_state = 0},
  [3216] = {.lex_state = 0},
  [3217] = {.lex_state = 0},
  [3218] = {.lex_state = 0},
  [3219] = {.lex_state = 0},
  [3220] = {.lex_state = 0},
  [3221] = {.lex_state = 0},
  [3222] = {.lex_state = 26},
  [3223] = {.lex_state = 0},
  [3224] = {.lex_state = 0},
  [3225] = {.lex_state = 0},
  [3226] = {.lex_state = 0},
  [3227] = {.lex_state = 0},
  [3228] = {.lex_state = 0},
  [3229] = {.lex_state = 0},
  [3230] = {.lex_state = 0},
  [3231] = {.lex_state = 0},
  [3232] = {.lex_state = 0},
  [3233] = {.lex_state = 0},
  [3234] = {.lex_state = 0},
  [3235] = {.lex_state = 0},
  [3236] = {.lex_state = 0},
  [3237] = {.lex_state = 0},
  [3238] = {.lex_state = 0},
  [3239] = {.lex_state = 0},
  [3240] = {.lex_state = 0},
  [3241] = {.lex_state = 0},
  [3242] = {.lex_state = 0},
  [3243] = {.lex_state = 0},
  [3244] = {.lex_state = 0},
  [3245] = {.lex_state = 0},
  [3246] = {.lex_state = 0},
  [3247] = {.lex_state = 0},
  [3248] = {.lex_state = 0},
  [3249] = {.lex_state = 0},
  [3250] = {.lex_state = 0},
  [3251] = {.lex_state = 0},
  [3252] = {.lex_state = 0},
  [3253] = {.lex_state = 0},
  [3254] = {.lex_state = 0},
  [3255] = {.lex_state = 0},
  [3256] = {.lex_state = 30},
  [3257] = {.lex_state = 0},
  [3258] = {.lex_state = 0},
  [3259] = {.lex_state = 0},
  [3260] = {.lex_state = 0},
  [3261] = {.lex_state = 0},
  [3262] = {.lex_state = 0},
  [3263] = {.lex_state = 0},
  [3264] = {.lex_state = 0},
  [3265] = {.lex_state = 0},
  [3266] = {.lex_state = 0},
  [3267] = {.lex_state = 0},
  [3268] = {.lex_state = 0},
  [3269] = {.lex_state = 0},
  [3270] = {.lex_state = 0},
  [3271] = {.lex_state = 0},
  [3272] = {.lex_state = 0},
  [3273] = {.lex_state = 0},
  [3274] = {.lex_state = 0},
  [3275] = {.lex_state = 0},
  [3276] = {.lex_state = 0},
  [3277] = {.lex_state = 26},
  [3278] = {.lex_state = 0},
  [3279] = {.lex_state = 0},
  [3280] = {.lex_state = 0},
  [3281] = {.lex_state = 0},
  [3282] = {.lex_state = 0},
  [3283] = {.lex_state = 0},
  [3284] = {.lex_state = 0},
  [3285] = {.lex_state = 0},
  [3286] = {.lex_state = 0},
  [3287] = {.lex_state = 30},
  [3288] = {.lex_state = 0},
  [3289] = {.lex_state = 0},
  [3290] = {.lex_state = 0},
  [3291] = {.lex_state = 0},
  [3292] = {.lex_state = 0},
  [3293] = {.lex_state = 0},
  [3294] = {.lex_state = 0},
  [3295] = {.lex_state = 0},
  [3296] = {.lex_state = 0},
  [3297] = {.lex_state = 0},
  [3298] = {.lex_state = 0},
  [3299] = {.lex_state = 0},
  [3300] = {.lex_state = 0},
  [3301] = {.lex_state = 26},
  [3302] = {.lex_state = 0},
  [3303] = {.lex_state = 0},
  [3304] = {.lex_state = 0},
  [3305] = {.lex_state = 0},
  [3306] = {.lex_state = 0},
  [3307] = {.lex_state = 0},
  [3308] = {.lex_state = 0},
  [3309] = {.lex_state = 0},
  [3310] = {.lex_state = 0},
  [3311] = {.lex_state = 0},
  [3312] = {.lex_state = 0},
  [3313] = {.lex_state = 0},
  [3314] = {.lex_state = 0},
  [3315] = {.lex_state = 0},
  [3316] = {.lex_state = 0},
  [3317] = {.lex_state = 0},
  [3318] = {.lex_state = 0},
  [3319] = {.lex_state = 0},
  [3320] = {.lex_state = 0},
  [3321] = {.lex_state = 0},
  [3322] = {.lex_state = 0},
  [3323] = {.lex_state = 0},
  [3324] = {.lex_state = 0},
  [3325] = {.lex_state = 0},
  [3326] = {.lex_state = 0},
  [3327] = {.lex_state = 0},
  [3328] = {.lex_state = 0},
  [3329] = {.lex_state = 0},
  [3330] = {.lex_state = 0},
  [3331] = {.lex_state = 0},
  [3332] = {.lex_state = 0},
  [3333] = {.lex_state = 0},
  [3334] = {.lex_state = 0},
  [3335] = {.lex_state = 0},
  [3336] = {.lex_state = 0},
  [3337] = {.lex_state = 0},
  [3338] = {.lex_state = 0},
  [3339] = {.lex_state = 0},
  [3340] = {.lex_state = 0},
  [3341] = {.lex_state = 0},
  [3342] = {.lex_state = 0},
  [3343] = {.lex_state = 0},
  [3344] = {.lex_state = 0},
  [3345] = {.lex_state = 0},
  [3346] = {.lex_state = 0},
  [3347] = {.lex_state = 0},
  [3348] = {.lex_state = 0},
  [3349] = {.lex_state = 24},
  [3350] = {.lex_state = 24},
  [3351] = {.lex_state = 24},
  [3352] = {.lex_state = 24},
  [3353] = {.lex_state = 24},
  [3354] = {.lex_state = 24},
  [3355] = {.lex_state = 24},
  [3356] = {.lex_state = 24},
  [3357] = {.lex_state = 24},
  [3358] = {.lex_state = 24},
  [3359] = {.lex_state = 0},
  [3360] = {.lex_state = 0},
  [3361] = {.lex_state = 0},
  [3362] = {.lex_state = 0},
  [3363] = {.lex_state = 0},
  [3364] = {.lex_state = 0},
  [3365] = {.lex_state = 0},
  [3366] = {.lex_state = 0},
  [3367] = {.lex_state = 0},
  [3368] = {.lex_state = 0},
  [3369] = {.lex_state = 0},
  [3370] = {.lex_state = 0},
  [3371] = {.lex_state = 0},
  [3372] = {.lex_state = 0},
  [3373] = {.lex_state = 0},
  [3374] = {.lex_state = 0},
  [3375] = {.lex_state = 0},
  [3376] = {.lex_state = 0},
  [3377] = {.lex_state = 0},
  [3378] = {.lex_state = 0},
  [3379] = {.lex_state = 0},
  [3380] = {.lex_state = 0},
  [3381] = {.lex_state = 24},
  [3382] = {.lex_state = 24},
  [3383] = {.lex_state = 24},
  [3384] = {.lex_state = 24},
  [3385] = {.lex_state = 24},
  [3386] = {.lex_state = 24},
  [3387] = {.lex_state = 24},
  [3388] = {.lex_state = 24},
  [3389] = {.lex_state = 24},
  [3390] = {.lex_state = 24},
  [3391] = {.lex_state = 0},
  [3392] = {.lex_state = 0},
  [3393] = {.lex_state = 0},
  [3394] = {.lex_state = 0},
  [3395] = {.lex_state = 0},
  [3396] = {.lex_state = 0},
  [3397] = {.lex_state = 0},
  [3398] = {.lex_state = 0},
  [3399] = {.lex_state = 0},
  [3400] = {.lex_state = 0},
  [3401] = {.lex_state = 0},
  [3402] = {.lex_state = 0},
  [3403] = {.lex_state = 0},
  [3404] = {.lex_state = 0},
  [3405] = {.lex_state = 0},
  [3406] = {.lex_state = 0},
  [3407] = {.lex_state = 0},
  [3408] = {.lex_state = 0},
  [3409] = {.lex_state = 0},
  [3410] = {.lex_state = 0},
  [3411] = {.lex_state = 0},
  [3412] = {.lex_state = 0},
  [3413] = {.lex_state = 24},
  [3414] = {.lex_state = 24},
  [3415] = {.lex_state = 24},
  [3416] = {.lex_state = 24},
  [3417] = {.lex_state = 24},
  [3418] = {.lex_state = 24},
  [3419] = {.lex_state = 24},
  [3420] = {.lex_state = 24},
  [3421] = {.lex_state = 24},
  [3422] = {.lex_state = 24},
  [3423] = {.lex_state = 0},
  [3424] = {.lex_state = 0},
  [3425] = {.lex_state = 0},
  [3426] = {.lex_state = 0},
  [3427] = {.lex_state = 0},
  [3428] = {.lex_state = 0},
  [3429] = {.lex_state = 0},
  [3430] = {.lex_state = 0},
  [3431] = {.lex_state = 0},
  [3432] = {.lex_state = 0},
  [3433] = {.lex_state = 0},
  [3434] = {.lex_state = 0},
  [3435] = {.lex_state = 0},
  [3436] = {.lex_state = 0},
  [3437] = {.lex_state = 0},
  [3438] = {.lex_state = 0},
  [3439] = {.lex_state = 0},
  [3440] = {.lex_state = 0},
  [3441] = {.lex_state = 0},
  [3442] = {.lex_state = 0},
  [3443] = {.lex_state = 0},
  [3444] = {.lex_state = 24},
  [3445] = {.lex_state = 24},
  [3446] = {.lex_state = 24},
  [3447] = {.lex_state = 24},
  [3448] = {.lex_state = 24},
  [3449] = {.lex_state = 24},
  [3450] = {.lex_state = 24},
  [3451] = {.lex_state = 24},
  [3452] = {.lex_state = 24},
  [3453] = {.lex_state = 24},
  [3454] = {.lex_state = 0},
  [3455] = {.lex_state = 0},
  [3456] = {.lex_state = 0},
  [3457] = {.lex_state = 24},
  [3458] = {.lex_state = 0},
  [3459] = {.lex_state = 0},
  [3460] = {.lex_state = 0},
  [3461] = {.lex_state = 0},
  [3462] = {.lex_state = 0},
  [3463] = {.lex_state = 0},
  [3464] = {.lex_state = 0},
  [3465] = {.lex_state = 0},
  [3466] = {.lex_state = 0},
  [3467] = {.lex_state = 0},
  [3468] = {.lex_state = 0},
  [3469] = {.lex_state = 0},
  [3470] = {.lex_state = 0},
  [3471] = {.lex_state = 24},
  [3472] = {.lex_state = 24},
  [3473] = {.lex_state = 24},
  [3474] = {.lex_state = 24},
  [3475] = {.lex_state = 24},
  [3476] = {.lex_state = 24},
  [3477] = {.lex_state = 24},
  [3478] = {.lex_state = 24},
  [3479] = {.lex_state = 24},
  [3480] = {.lex_state = 24},
  [3481] = {.lex_state = 0},
  [3482] = {.lex_state = 0},
  [3483] = {.lex_state = 0},
  [3484] = {.lex_state = 0},
  [3485] = {.lex_state = 0},
  [3486] = {.lex_state = 0},
  [3487] = {.lex_state = 0},
  [3488] = {.lex_state = 0},
  [3489] = {.lex_state = 0},
  [3490] = {.lex_state = 0},
  [3491] = {.lex_state = 0},
  [3492] = {.lex_state = 0},
  [3493] = {.lex_state = 0},
  [3494] = {.lex_state = 0},
  [3495] = {.lex_state = 0},
  [3496] = {.lex_state = 0},
  [3497] = {.lex_state = 0},
  [3498] = {.lex_state = 24},
  [3499] = {.lex_state = 24},
  [3500] = {.lex_state = 24},
  [3501] = {.lex_state = 24},
  [3502] = {.lex_state = 24},
  [3503] = {.lex_state = 24},
  [3504] = {.lex_state = 24},
  [3505] = {.lex_state = 24},
  [3506] = {.lex_state = 24},
  [3507] = {.lex_state = 24},
  [3508] = {.lex_state = 0},
  [3509] = {.lex_state = 0},
  [3510] = {.lex_state = 0},
  [3511] = {.lex_state = 0},
  [3512] = {.lex_state = 0},
  [3513] = {.lex_state = 0},
  [3514] = {.lex_state = 0},
  [3515] = {.lex_state = 0},
  [3516] = {.lex_state = 0},
  [3517] = {.lex_state = 0},
  [3518] = {.lex_state = 0},
  [3519] = {.lex_state = 0},
  [3520] = {.lex_state = 0},
  [3521] = {.lex_state = 0},
  [3522] = {.lex_state = 0},
  [3523] = {.lex_state = 0},
  [3524] = {.lex_state = 0},
  [3525] = {.lex_state = 0},
  [3526] = {.lex_state = 0},
  [3527] = {.lex_state = 0},
  [3528] = {.lex_state = 0},
  [3529] = {.lex_state = 26},
  [3530] = {.lex_state = 0},
  [3531] = {.lex_state = 0},
  [3532] = {.lex_state = 0},
  [3533] = {.lex_state = 0},
  [3534] = {.lex_state = 0},
  [3535] = {.lex_state = 0},
  [3536] = {.lex_state = 0},
  [3537] = {.lex_state = 0},
  [3538] = {.lex_state = 0},
  [3539] = {.lex_state = 0},
  [3540] = {.lex_state = 0},
  [3541] = {.lex_state = 0},
  [3542] = {.lex_state = 0},
  [3543] = {.lex_state = 0},
  [3544] = {.lex_state = 0},
  [3545] = {.lex_state = 0},
  [3546] = {.lex_state = 0},
  [3547] = {.lex_state = 0},
  [3548] = {.lex_state = 0},
  [3549] = {.lex_state = 30},
  [3550] = {.lex_state = 0},
  [3551] = {.lex_state = 0},
  [3552] = {.lex_state = 0},
  [3553] = {.lex_state = 0},
  [3554] = {.lex_state = 0},
  [3555] = {.lex_state = 0},
  [3556] = {.lex_state = 0},
  [3557] = {.lex_state = 0},
  [3558] = {.lex_state = 0},
  [3559] = {.lex_state = 0},
  [3560] = {.lex_state = 0},
  [3561] = {.lex_state = 0},
  [3562] = {.lex_state = 0},
  [3563] = {.lex_state = 0},
  [3564] = {.lex_state = 0},
  [3565] = {.lex_state = 0},
  [3566] = {.lex_state = 0},
  [3567] = {.lex_state = 0},
  [3568] = {.lex_state = 0},
  [3569] = {.lex_state = 0},
  [3570] = {.lex_state = 0},
  [3571] = {.lex_state = 0},
  [3572] = {.lex_state = 0},
  [3573] = {.lex_state = 0},
  [3574] = {.lex_state = 0},
  [3575] = {.lex_state = 0},
  [3576] = {.lex_state = 0},
  [3577] = {.lex_state = 0},
  [3578] = {.lex_state = 0},
  [3579] = {.lex_state = 0},
  [3580] = {.lex_state = 0},
  [3581] = {.lex_state = 26},
  [3582] = {.lex_state = 0},
  [3583] = {.lex_state = 0},
  [3584] = {.lex_state = 0},
  [3585] = {.lex_state = 0},
  [3586] = {.lex_state = 0},
  [3587] = {.lex_state = 0},
  [3588] = {.lex_state = 0},
  [3589] = {.lex_state = 0},
  [3590] = {.lex_state = 0},
  [3591] = {.lex_state = 0},
  [3592] = {.lex_state = 0},
  [3593] = {.lex_state = 0},
  [3594] = {.lex_state = 0},
  [3595] = {.lex_state = 0},
  [3596] = {.lex_state = 0},
  [3597] = {.lex_state = 0},
  [3598] = {.lex_state = 0},
  [3599] = {.lex_state = 0},
  [3600] = {.lex_state = 0},
  [3601] = {.lex_state = 0},
  [3602] = {.lex_state = 0},
  [3603] = {.lex_state = 0},
  [3604] = {.lex_state = 0},
  [3605] = {.lex_state = 0},
  [3606] = {.lex_state = 0},
  [3607] = {.lex_state = 0},
  [3608] = {.lex_state = 0},
  [3609] = {.lex_state = 0},
  [3610] = {.lex_state = 0},
  [3611] = {.lex_state = 0},
  [3612] = {.lex_state = 0},
  [3613] = {.lex_state = 0},
  [3614] = {.lex_state = 0},
  [3615] = {.lex_state = 0},
  [3616] = {.lex_state = 0},
  [3617] = {.lex_state = 0},
  [3618] = {.lex_state = 0},
  [3619] = {.lex_state = 0},
  [3620] = {.lex_state = 0},
  [3621] = {.lex_state = 0},
  [3622] = {.lex_state = 0},
  [3623] = {.lex_state = 0},
  [3624] = {.lex_state = 0},
  [3625] = {.lex_state = 0},
  [3626] = {.lex_state = 0},
  [3627] = {.lex_state = 0},
  [3628] = {.lex_state = 0},
  [3629] = {.lex_state = 0},
  [3630] = {.lex_state = 0},
  [3631] = {.lex_state = 0},
  [3632] = {.lex_state = 0},
  [3633] = {.lex_state = 0},
  [3634] = {.lex_state = 0},
  [3635] = {.lex_state = 0},
  [3636] = {.lex_state = 0},
  [3637] = {.lex_state = 0},
  [3638] = {.lex_state = 0},
  [3639] = {.lex_state = 0},
  [3640] = {.lex_state = 26},
  [3641] = {.lex_state = 0},
  [3642] = {.lex_state = 0},
  [3643] = {.lex_state = 0},
  [3644] = {.lex_state = 0},
  [3645] = {.lex_state = 0},
  [3646] = {.lex_state = 0},
  [3647] = {.lex_state = 0},
  [3648] = {.lex_state = 0},
  [3649] = {.lex_state = 0},
  [3650] = {.lex_state = 0},
  [3651] = {.lex_state = 0},
  [3652] = {.lex_state = 0},
  [3653] = {.lex_state = 0},
  [3654] = {.lex_state = 0},
  [3655] = {.lex_state = 0},
  [3656] = {.lex_state = 0},
  [3657] = {.lex_state = 0},
  [3658] = {.lex_state = 0},
  [3659] = {.lex_state = 0},
  [3660] = {.lex_state = 0},
  [3661] = {.lex_state = 0},
  [3662] = {.lex_state = 0},
  [3663] = {.lex_state = 0},
  [3664] = {.lex_state = 0},
  [3665] = {.lex_state = 0},
  [3666] = {.lex_state = 0},
  [3667] = {.lex_state = 0},
  [3668] = {.lex_state = 0},
  [3669] = {.lex_state = 0},
  [3670] = {.lex_state = 0},
  [3671] = {.lex_state = 0},
  [3672] = {.lex_state = 0},
  [3673] = {.lex_state = 0},
  [3674] = {.lex_state = 0},
  [3675] = {.lex_state = 0},
  [3676] = {.lex_state = 0},
  [3677] = {.lex_state = 0},
  [3678] = {.lex_state = 0},
  [3679] = {.lex_state = 0},
  [3680] = {.lex_state = 26},
  [3681] = {.lex_state = 0},
  [3682] = {.lex_state = 0},
  [3683] = {.lex_state = 26},
  [3684] = {.lex_state = 0},
  [3685] = {.lex_state = 0, .external_lex_state = 3},
  [3686] = {.lex_state = 0},
  [3687] = {.lex_state = 0},
  [3688] = {.lex_state = 26},
  [3689] = {.lex_state = 31},
  [3690] = {.lex_state = 0},
  [3691] = {.lex_state = 0},
  [3692] = {.lex_state = 0},
  [3693] = {.lex_state = 0},
  [3694] = {.lex_state = 0},
  [3695] = {.lex_state = 0},
  [3696] = {.lex_state = 0},
  [3697] = {.lex_state = 0},
  [3698] = {.lex_state = 0, .external_lex_state = 4},
  [3699] = {.lex_state = 0},
  [3700] = {.lex_state = 0},
  [3701] = {.lex_state = 0},
  [3702] = {.lex_state = 0},
  [3703] = {.lex_state = 26},
  [3704] = {.lex_state = 0},
  [3705] = {.lex_state = 0},
  [3706] = {.lex_state = 0},
  [3707] = {.lex_state = 0, .external_lex_state = 5},
  [3708] = {.lex_state = 26},
  [3709] = {.lex_state = 0},
  [3710] = {.lex_state = 0},
  [3711] = {.lex_state = 26},
  [3712] = {.lex_state = 0},
  [3713] = {.lex_state = 0, .external_lex_state = 6},
  [3714] = {.lex_state = 26},
  [3715] = {.lex_state = 35},
  [3716] = {.lex_state = 0},
  [3717] = {.lex_state = 0, .external_lex_state = 7},
  [3718] = {.lex_state = 0, .external_lex_state = 8},
  [3719] = {.lex_state = 0, .external_lex_state = 9},
  [3720] = {.lex_state = 0, .external_lex_state = 10},
  [3721] = {.lex_state = 0, .external_lex_state = 11},
  [3722] = {.lex_state = 0, .external_lex_state = 5},
  [3723] = {.lex_state = 0, .external_lex_state = 12},
  [3724] = {.lex_state = 0, .external_lex_state = 13},
  [3725] = {.lex_state = 0, .external_lex_state = 4},
  [3726] = {.lex_state = 0, .external_lex_state = 3},
  [3727] = {.lex_state = 0, .external_lex_state = 6},
  [3728] = {.lex_state = 0, .external_lex_state = 12},
  [3729] = {.lex_state = 0},
  [3730] = {.lex_state = 30},
  [3731] = {.lex_state = 0, .external_lex_state = 10},
  [3732] = {.lex_state = 0},
  [3733] = {.lex_state = 26},
  [3734] = {.lex_state = 26},
  [3735] = {.lex_state = 0},
  [3736] = {.lex_state = 0},
  [3737] = {.lex_state = 0},
  [3738] = {.lex_state = 0},
  [3739] = {.lex_state = 31},
  [3740] = {.lex_state = 0, .external_lex_state = 11},
  [3741] = {.lex_state = 0},
  [3742] = {.lex_state = 0, .external_lex_state = 3},
  [3743] = {.lex_state = 0},
  [3744] = {.lex_state = 0},
  [3745] = {.lex_state = 0},
  [3746] = {.lex_state = 26},
  [3747] = {.lex_state = 0},
  [3748] = {.lex_state = 0, .external_lex_state = 6},
  [3749] = {.lex_state = 0},
  [3750] = {.lex_state = 26},
  [3751] = {.lex_state = 0, .external_lex_state = 9},
  [3752] = {.lex_state = 0},
  [3753] = {.lex_state = 0, .external_lex_state = 7},
  [3754] = {.lex_state = 0},
  [3755] = {.lex_state = 0},
  [3756] = {.lex_state = 0, .external_lex_state = 5},
  [3757] = {.lex_state = 26},
  [3758] = {.lex_state = 0, .external_lex_state = 8},
  [3759] = {.lex_state = 30},
  [3760] = {.lex_state = 0},
  [3761] = {.lex_state = 0},
  [3762] = {.lex_state = 0},
  [3763] = {.lex_state = 0},
  [3764] = {.lex_state = 26},
  [3765] = {.lex_state = 0},
  [3766] = {.lex_state = 0},
  [3767] = {.lex_state = 0, .external_lex_state = 7},
  [3768] = {.lex_state = 0, .external_lex_state = 8},
  [3769] = {.lex_state = 0, .external_lex_state = 9},
  [3770] = {.lex_state = 0, .external_lex_state = 10},
  [3771] = {.lex_state = 0, .external_lex_state = 11},
  [3772] = {.lex_state = 0, .external_lex_state = 5},
  [3773] = {.lex_state = 0, .external_lex_state = 12},
  [3774] = {.lex_state = 0, .external_lex_state = 13},
  [3775] = {.lex_state = 0, .external_lex_state = 4},
  [3776] = {.lex_state = 0, .external_lex_state = 3},
  [3777] = {.lex_state = 0, .external_lex_state = 6},
  [3778] = {.lex_state = 0},
  [3779] = {.lex_state = 0},
  [3780] = {.lex_state = 30},
  [3781] = {.lex_state = 35},
  [3782] = {.lex_state = 30},
  [3783] = {.lex_state = 26},
  [3784] = {.lex_state = 0},
  [3785] = {.lex_state = 0},
  [3786] = {.lex_state = 0},
  [3787] = {.lex_state = 0},
  [3788] = {.lex_state = 26},
  [3789] = {.lex_state = 31},
  [3790] = {.lex_state = 0},
  [3791] = {.lex_state = 0},
  [3792] = {.lex_state = 0},
  [3793] = {.lex_state = 35},
  [3794] = {.lex_state = 0},
  [3795] = {.lex_state = 0},
  [3796] = {.lex_state = 0},
  [3797] = {.lex_state = 0},
  [3798] = {.lex_state = 0},
  [3799] = {.lex_state = 0},
  [3800] = {.lex_state = 0},
  [3801] = {.lex_state = 0},
  [3802] = {.lex_state = 0},
  [3803] = {.lex_state = 0},
  [3804] = {.lex_state = 0},
  [3805] = {.lex_state = 0},
  [3806] = {.lex_state = 0},
  [3807] = {.lex_state = 0},
  [3808] = {.lex_state = 0},
  [3809] = {.lex_state = 0},
  [3810] = {.lex_state = 0},
  [3811] = {.lex_state = 0},
  [3812] = {.lex_state = 26},
  [3813] = {.lex_state = 26},
  [3814] = {.lex_state = 0},
  [3815] = {.lex_state = 0},
  [3816] = {.lex_state = 0, .external_lex_state = 7},
  [3817] = {.lex_state = 26},
  [3818] = {.lex_state = 30},
  [3819] = {.lex_state = 0},
  [3820] = {.lex_state = 0},
  [3821] = {.lex_state = 26},
  [3822] = {.lex_state = 0, .external_lex_state = 8},
  [3823] = {.lex_state = 0},
  [3824] = {.lex_state = 0},
  [3825] = {.lex_state = 0, .external_lex_state = 9},
  [3826] = {.lex_state = 0, .external_lex_state = 10},
  [3827] = {.lex_state = 31},
  [3828] = {.lex_state = 0, .external_lex_state = 11},
  [3829] = {.lex_state = 0, .external_lex_state = 5},
  [3830] = {.lex_state = 0, .external_lex_state = 12},
  [3831] = {.lex_state = 0, .external_lex_state = 13},
  [3832] = {.lex_state = 0, .external_lex_state = 4},
  [3833] = {.lex_state = 0, .external_lex_state = 3},
  [3834] = {.lex_state = 0, .external_lex_state = 6},
  [3835] = {.lex_state = 0},
  [3836] = {.lex_state = 0},
  [3837] = {.lex_state = 30},
  [3838] = {.lex_state = 0},
  [3839] = {.lex_state = 0},
  [3840] = {.lex_state = 0},
  [3841] = {.lex_state = 26},
  [3842] = {.lex_state = 26},
  [3843] = {.lex_state = 0},
  [3844] = {.lex_state = 0},
  [3845] = {.lex_state = 30},
  [3846] = {.lex_state = 0, .external_lex_state = 10},
  [3847] = {.lex_state = 0},
  [3848] = {.lex_state = 26},
  [3849] = {.lex_state = 26},
  [3850] = {.lex_state = 35},
  [3851] = {.lex_state = 0},
  [3852] = {.lex_state = 31},
  [3853] = {.lex_state = 0},
  [3854] = {.lex_state = 31},
  [3855] = {.lex_state = 0},
  [3856] = {.lex_state = 0},
  [3857] = {.lex_state = 0},
  [3858] = {.lex_state = 0},
  [3859] = {.lex_state = 0},
  [3860] = {.lex_state = 0},
  [3861] = {.lex_state = 0},
  [3862] = {.lex_state = 0},
  [3863] = {.lex_state = 0},
  [3864] = {.lex_state = 0},
  [3865] = {.lex_state = 0},
  [3866] = {.lex_state = 26},
  [3867] = {.lex_state = 0},
  [3868] = {.lex_state = 30},
  [3869] = {.lex_state = 0},
  [3870] = {.lex_state = 0},
  [3871] = {.lex_state = 30},
  [3872] = {.lex_state = 0},
  [3873] = {.lex_state = 0, .external_lex_state = 13},
  [3874] = {.lex_state = 26},
  [3875] = {.lex_state = 26},
  [3876] = {.lex_state = 26},
  [3877] = {.lex_state = 0},
  [3878] = {.lex_state = 26},
  [3879] = {.lex_state = 0, .external_lex_state = 11},
  [3880] = {.lex_state = 31},
  [3881] = {.lex_state = 26},
  [3882] = {.lex_state = 26},
  [3883] = {.lex_state = 0, .external_lex_state = 7},
  [3884] = {.lex_state = 0, .external_lex_state = 8},
  [3885] = {.lex_state = 26},
  [3886] = {.lex_state = 0, .external_lex_state = 12},
  [3887] = {.lex_state = 0},
  [3888] = {.lex_state = 0, .external_lex_state = 7},
  [3889] = {.lex_state = 26},
  [3890] = {.lex_state = 0, .external_lex_state = 8},
  [3891] = {.lex_state = 0, .external_lex_state = 9},
  [3892] = {.lex_state = 0, .external_lex_state = 10},
  [3893] = {.lex_state = 0, .external_lex_state = 11},
  [3894] = {.lex_state = 0},
  [3895] = {.lex_state = 0, .external_lex_state = 5},
  [3896] = {.lex_state = 0, .external_lex_state = 12},
  [3897] = {.lex_state = 0, .external_lex_state = 13},
  [3898] = {.lex_state = 0, .external_lex_state = 4},
  [3899] = {.lex_state = 0, .external_lex_state = 3},
  [3900] = {.lex_state = 0, .external_lex_state = 6},
  [3901] = {.lex_state = 0, .external_lex_state = 10},
  [3902] = {.lex_state = 0, .external_lex_state = 9},
  [3903] = {.lex_state = 30},
  [3904] = {.lex_state = 26},
  [3905] = {.lex_state = 35},
  [3906] = {.lex_state = 26},
  [3907] = {.lex_state = 0},
  [3908] = {.lex_state = 0},
  [3909] = {.lex_state = 0},
  [3910] = {.lex_state = 0, .external_lex_state = 4},
  [3911] = {.lex_state = 0},
  [3912] = {.lex_state = 31},
  [3913] = {.lex_state = 0},
  [3914] = {.lex_state = 35},
  [3915] = {.lex_state = 0},
  [3916] = {.lex_state = 0},
  [3917] = {.lex_state = 0, .external_lex_state = 3},
  [3918] = {.lex_state = 35},
  [3919] = {.lex_state = 26},
  [3920] = {.lex_state = 0},
  [3921] = {.lex_state = 0},
  [3922] = {.lex_state = 0},
  [3923] = {.lex_state = 0},
  [3924] = {.lex_state = 0},
  [3925] = {.lex_state = 0},
  [3926] = {.lex_state = 0},
  [3927] = {.lex_state = 0},
  [3928] = {.lex_state = 0},
  [3929] = {.lex_state = 0},
  [3930] = {.lex_state = 0},
  [3931] = {.lex_state = 0},
  [3932] = {.lex_state = 0},
  [3933] = {.lex_state = 26},
  [3934] = {.lex_state = 0},
  [3935] = {.lex_state = 0},
  [3936] = {.lex_state = 35},
  [3937] = {.lex_state = 26},
  [3938] = {.lex_state = 0},
  [3939] = {.lex_state = 0},
  [3940] = {.lex_state = 0, .external_lex_state = 7},
  [3941] = {.lex_state = 0, .external_lex_state = 8},
  [3942] = {.lex_state = 0, .external_lex_state = 9},
  [3943] = {.lex_state = 0, .external_lex_state = 10},
  [3944] = {.lex_state = 0, .external_lex_state = 11},
  [3945] = {.lex_state = 0, .external_lex_state = 5},
  [3946] = {.lex_state = 0, .external_lex_state = 12},
  [3947] = {.lex_state = 0, .external_lex_state = 13},
  [3948] = {.lex_state = 0, .external_lex_state = 4},
  [3949] = {.lex_state = 0, .external_lex_state = 3},
  [3950] = {.lex_state = 0, .external_lex_state = 6},
  [3951] = {.lex_state = 0, .external_lex_state = 9},
  [3952] = {.lex_state = 0},
  [3953] = {.lex_state = 30},
  [3954] = {.lex_state = 28},
  [3955] = {.lex_state = 0, .external_lex_state = 7},
  [3956] = {.lex_state = 26},
  [3957] = {.lex_state = 0},
  [3958] = {.lex_state = 0},
  [3959] = {.lex_state = 0, .external_lex_state = 8},
  [3960] = {.lex_state = 0, .external_lex_state = 6},
  [3961] = {.lex_state = 31},
  [3962] = {.lex_state = 31},
  [3963] = {.lex_state = 35},
  [3964] = {.lex_state = 0},
  [3965] = {.lex_state = 0, .external_lex_state = 11},
  [3966] = {.lex_state = 0},
  [3967] = {.lex_state = 0, .external_lex_state = 13},
  [3968] = {.lex_state = 35},
  [3969] = {.lex_state = 0, .external_lex_state = 10},
  [3970] = {.lex_state = 0},
  [3971] = {.lex_state = 35},
  [3972] = {.lex_state = 0, .external_lex_state = 5},
  [3973] = {.lex_state = 0},
  [3974] = {.lex_state = 0},
  [3975] = {.lex_state = 0},
  [3976] = {.lex_state = 0},
  [3977] = {.lex_state = 0},
  [3978] = {.lex_state = 0},
  [3979] = {.lex_state = 0},
  [3980] = {.lex_state = 0},
  [3981] = {.lex_state = 0},
  [3982] = {.lex_state = 0},
  [3983] = {.lex_state = 0},
  [3984] = {.lex_state = 0},
  [3985] = {.lex_state = 0},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 0},
  [3988] = {.lex_state = 0},
  [3989] = {.lex_state = 26},
  [3990] = {.lex_state = 0},
  [3991] = {.lex_state = 0},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 0, .external_lex_state = 12},
  [3994] = {.lex_state = 0},
  [3995] = {.lex_state = 0},
  [3996] = {.lex_state = 26},
  [3997] = {.lex_state = 0},
  [3998] = {.lex_state = 0},
  [3999] = {.lex_state = 0},
  [4000] = {.lex_state = 0},
  [4001] = {.lex_state = 0, .external_lex_state = 7},
  [4002] = {.lex_state = 0, .external_lex_state = 8},
  [4003] = {.lex_state = 0},
  [4004] = {.lex_state = 0, .external_lex_state = 9},
  [4005] = {.lex_state = 0, .external_lex_state = 10},
  [4006] = {.lex_state = 0},
  [4007] = {.lex_state = 0, .external_lex_state = 11},
  [4008] = {.lex_state = 0, .external_lex_state = 5},
  [4009] = {.lex_state = 0},
  [4010] = {.lex_state = 0, .external_lex_state = 12},
  [4011] = {.lex_state = 0, .external_lex_state = 13},
  [4012] = {.lex_state = 0, .external_lex_state = 4},
  [4013] = {.lex_state = 0, .external_lex_state = 3},
  [4014] = {.lex_state = 0, .external_lex_state = 6},
  [4015] = {.lex_state = 0, .external_lex_state = 13},
  [4016] = {.lex_state = 0, .external_lex_state = 4},
  [4017] = {.lex_state = 26},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_command_name] = ACTIONS(1),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(1),
    [anon_sym_BSLASHfi] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_BSLASHpart] = ACTIONS(1),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddpart] = ACTIONS(1),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(1),
    [anon_sym_BSLASHchapter] = ACTIONS(1),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddchap] = ACTIONS(1),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsection] = ACTIONS(1),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddsec] = ACTIONS(1),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubsection] = ACTIONS(1),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(1),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHparagraph] = ACTIONS(1),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(1),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(1),
    [anon_sym_BSLASHitem] = ACTIONS(1),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_BSLASHand] = ACTIONS(1),
    [sym_word] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [sym_delimiter] = ACTIONS(1),
    [sym_argc] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_letter] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(1),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(1),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(1),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(1),
    [anon_sym_BSLASHleft] = ACTIONS(1),
    [anon_sym_BSLASHbigl] = ACTIONS(1),
    [anon_sym_BSLASHBigl] = ACTIONS(1),
    [anon_sym_BSLASHbiggl] = ACTIONS(1),
    [anon_sym_BSLASHBiggl] = ACTIONS(1),
    [anon_sym_BSLASHright] = ACTIONS(1),
    [anon_sym_BSLASHbigr] = ACTIONS(1),
    [anon_sym_BSLASHBigr] = ACTIONS(1),
    [anon_sym_BSLASHbiggr] = ACTIONS(1),
    [anon_sym_BSLASHBiggr] = ACTIONS(1),
    [anon_sym_BSLASHtext] = ACTIONS(1),
    [anon_sym_BSLASHintertext] = ACTIONS(1),
    [anon_sym_BSLASHshortintertext] = ACTIONS(1),
    [anon_sym_BSLASHbegin] = ACTIONS(1),
    [anon_sym_BSLASHend] = ACTIONS(1),
    [anon_sym_BSLASHtitle] = ACTIONS(1),
    [anon_sym_BSLASHauthor] = ACTIONS(1),
    [anon_sym_BSLASHusepackage] = ACTIONS(1),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(1),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(1),
    [anon_sym_BSLASHinclude] = ACTIONS(1),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(1),
    [anon_sym_BSLASHinput] = ACTIONS(1),
    [anon_sym_BSLASHsubfile] = ACTIONS(1),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(1),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(1),
    [anon_sym_BSLASHbibliography] = ACTIONS(1),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(1),
    [anon_sym_BSLASHincludesvg] = ACTIONS(1),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(1),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(1),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(1),
    [anon_sym_BSLASHimport] = ACTIONS(1),
    [anon_sym_BSLASHsubimport] = ACTIONS(1),
    [anon_sym_BSLASHinputfrom] = ACTIONS(1),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(1),
    [anon_sym_BSLASHincludefrom] = ACTIONS(1),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(1),
    [anon_sym_BSLASHcaption] = ACTIONS(1),
    [anon_sym_BSLASHcite] = ACTIONS(1),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCite] = ACTIONS(1),
    [anon_sym_BSLASHnocite] = ACTIONS(1),
    [anon_sym_BSLASHcitet] = ACTIONS(1),
    [anon_sym_BSLASHcitep] = ACTIONS(1),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteA] = ACTIONS(1),
    [anon_sym_BSLASHciteR] = ACTIONS(1),
    [anon_sym_BSLASHciteS] = ACTIONS(1),
    [anon_sym_BSLASHciteyearR] = ACTIONS(1),
    [anon_sym_BSLASHciteauthor] = ACTIONS(1),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(1),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitetitle] = ACTIONS(1),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteyear] = ACTIONS(1),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitedate] = ACTIONS(1),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteurl] = ACTIONS(1),
    [anon_sym_BSLASHfullcite] = ACTIONS(1),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(1),
    [anon_sym_BSLASHcitealt] = ACTIONS(1),
    [anon_sym_BSLASHcitealp] = ACTIONS(1),
    [anon_sym_BSLASHcitetext] = ACTIONS(1),
    [anon_sym_BSLASHparencite] = ACTIONS(1),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHParencite] = ACTIONS(1),
    [anon_sym_BSLASHfootcite] = ACTIONS(1),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(1),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(1),
    [anon_sym_BSLASHtextcite] = ACTIONS(1),
    [anon_sym_BSLASHTextcite] = ACTIONS(1),
    [anon_sym_BSLASHsmartcite] = ACTIONS(1),
    [anon_sym_BSLASHSmartcite] = ACTIONS(1),
    [anon_sym_BSLASHsupercite] = ACTIONS(1),
    [anon_sym_BSLASHautocite] = ACTIONS(1),
    [anon_sym_BSLASHAutocite] = ACTIONS(1),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHvolcite] = ACTIONS(1),
    [anon_sym_BSLASHVolcite] = ACTIONS(1),
    [anon_sym_BSLASHpvolcite] = ACTIONS(1),
    [anon_sym_BSLASHPvolcite] = ACTIONS(1),
    [anon_sym_BSLASHfvolcite] = ACTIONS(1),
    [anon_sym_BSLASHftvolcite] = ACTIONS(1),
    [anon_sym_BSLASHsvolcite] = ACTIONS(1),
    [anon_sym_BSLASHSvolcite] = ACTIONS(1),
    [anon_sym_BSLASHtvolcite] = ACTIONS(1),
    [anon_sym_BSLASHTvolcite] = ACTIONS(1),
    [anon_sym_BSLASHavolcite] = ACTIONS(1),
    [anon_sym_BSLASHAvolcite] = ACTIONS(1),
    [anon_sym_BSLASHnotecite] = ACTIONS(1),
    [anon_sym_BSLASHNotecite] = ACTIONS(1),
    [anon_sym_BSLASHpnotecite] = ACTIONS(1),
    [anon_sym_BSLASHPnotecite] = ACTIONS(1),
    [anon_sym_BSLASHfnotecite] = ACTIONS(1),
    [anon_sym_BSLASHlabel] = ACTIONS(1),
    [anon_sym_BSLASHref] = ACTIONS(1),
    [anon_sym_BSLASHeqref] = ACTIONS(1),
    [anon_sym_BSLASHvref] = ACTIONS(1),
    [anon_sym_BSLASHVref] = ACTIONS(1),
    [anon_sym_BSLASHautoref] = ACTIONS(1),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHpageref] = ACTIONS(1),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHautopageref] = ACTIONS(1),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcref] = ACTIONS(1),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCref] = ACTIONS(1),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcpageref] = ACTIONS(1),
    [anon_sym_BSLASHCpageref] = ACTIONS(1),
    [anon_sym_BSLASHnamecref] = ACTIONS(1),
    [anon_sym_BSLASHnameCref] = ACTIONS(1),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(1),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(1),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(1),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(1),
    [anon_sym_BSLASHlabelcref] = ACTIONS(1),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(1),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcrefrange] = ACTIONS(1),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCrefrange] = ACTIONS(1),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(1),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(1),
    [anon_sym_BSLASHnewlabel] = ACTIONS(1),
    [anon_sym_BSLASHnewcommand] = ACTIONS(1),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(1),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(1),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(1),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(1),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(1),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(1),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(1),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(1),
    [anon_sym_BSLASHdef] = ACTIONS(1),
    [anon_sym_BSLASHgdef] = ACTIONS(1),
    [anon_sym_BSLASHedef] = ACTIONS(1),
    [anon_sym_BSLASHxdef] = ACTIONS(1),
    [anon_sym_BSLASHlet] = ACTIONS(1),
    [anon_sym_BSLASHglet] = ACTIONS(1),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(1),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(1),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(1),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(1),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(1),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(1),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(1),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(1),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(1),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(1),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(1),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(1),
    [anon_sym_BSLASHgls] = ACTIONS(1),
    [anon_sym_BSLASHGls] = ACTIONS(1),
    [anon_sym_BSLASHGLS] = ACTIONS(1),
    [anon_sym_BSLASHglspl] = ACTIONS(1),
    [anon_sym_BSLASHGlspl] = ACTIONS(1),
    [anon_sym_BSLASHGLSpl] = ACTIONS(1),
    [anon_sym_BSLASHglsdisp] = ACTIONS(1),
    [anon_sym_BSLASHglslink] = ACTIONS(1),
    [anon_sym_BSLASHglstext] = ACTIONS(1),
    [anon_sym_BSLASHGlstext] = ACTIONS(1),
    [anon_sym_BSLASHGLStext] = ACTIONS(1),
    [anon_sym_BSLASHglsfirst] = ACTIONS(1),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(1),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(1),
    [anon_sym_BSLASHglsplural] = ACTIONS(1),
    [anon_sym_BSLASHGlsplural] = ACTIONS(1),
    [anon_sym_BSLASHGLSplural] = ACTIONS(1),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHglsname] = ACTIONS(1),
    [anon_sym_BSLASHGlsname] = ACTIONS(1),
    [anon_sym_BSLASHGLSname] = ACTIONS(1),
    [anon_sym_BSLASHglssymbol] = ACTIONS(1),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(1),
    [anon_sym_BSLASHglsdesc] = ACTIONS(1),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(1),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(1),
    [anon_sym_BSLASHglsuseri] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(1),
    [anon_sym_BSLASHglsuserii] = ACTIONS(1),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(1),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(1),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(1),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(1),
    [anon_sym_BSLASHglsuserv] = ACTIONS(1),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(1),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(1),
    [anon_sym_BSLASHglsuservi] = ACTIONS(1),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(1),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(1),
    [anon_sym_BSLASHnewacronym] = ACTIONS(1),
    [anon_sym_BSLASHacrshort] = ACTIONS(1),
    [anon_sym_BSLASHAcrshort] = ACTIONS(1),
    [anon_sym_BSLASHACRshort] = ACTIONS(1),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(1),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(1),
    [anon_sym_BSLASHacrlong] = ACTIONS(1),
    [anon_sym_BSLASHAcrlong] = ACTIONS(1),
    [anon_sym_BSLASHACRlong] = ACTIONS(1),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(1),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(1),
    [anon_sym_BSLASHacrfull] = ACTIONS(1),
    [anon_sym_BSLASHAcrfull] = ACTIONS(1),
    [anon_sym_BSLASHACRfull] = ACTIONS(1),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(1),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(1),
    [anon_sym_BSLASHacs] = ACTIONS(1),
    [anon_sym_BSLASHAcs] = ACTIONS(1),
    [anon_sym_BSLASHacsp] = ACTIONS(1),
    [anon_sym_BSLASHAcsp] = ACTIONS(1),
    [anon_sym_BSLASHacl] = ACTIONS(1),
    [anon_sym_BSLASHAcl] = ACTIONS(1),
    [anon_sym_BSLASHaclp] = ACTIONS(1),
    [anon_sym_BSLASHAclp] = ACTIONS(1),
    [anon_sym_BSLASHacf] = ACTIONS(1),
    [anon_sym_BSLASHAcf] = ACTIONS(1),
    [anon_sym_BSLASHacfp] = ACTIONS(1),
    [anon_sym_BSLASHAcfp] = ACTIONS(1),
    [anon_sym_BSLASHac] = ACTIONS(1),
    [anon_sym_BSLASHAc] = ACTIONS(1),
    [anon_sym_BSLASHacp] = ACTIONS(1),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(1),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(1),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(1),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(1),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(1),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(1),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(1),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(1),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(1),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(1),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(1),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(1),
    [anon_sym_BSLASHcolor] = ACTIONS(1),
    [anon_sym_BSLASHpagecolor] = ACTIONS(1),
    [anon_sym_BSLASHtextcolor] = ACTIONS(1),
    [anon_sym_BSLASHmathcolor] = ACTIONS(1),
    [anon_sym_BSLASHcolorbox] = ACTIONS(1),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(1),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(1),
    [anon_sym_BSLASHurl] = ACTIONS(1),
    [anon_sym_BSLASHhref] = ACTIONS(1),
    [sym__trivia_raw_fi] = ACTIONS(1),
    [sym__trivia_raw_env_comment] = ACTIONS(1),
    [sym__trivia_raw_env_verbatim] = ACTIONS(1),
    [sym__trivia_raw_env_listing] = ACTIONS(1),
    [sym__trivia_raw_env_minted] = ACTIONS(1),
    [sym__trivia_raw_env_asy] = ACTIONS(1),
    [sym__trivia_raw_env_asydef] = ACTIONS(1),
    [sym__trivia_raw_env_pycode] = ACTIONS(1),
    [sym__trivia_raw_env_luacode] = ACTIONS(1),
    [sym__trivia_raw_env_luacode_star] = ACTIONS(1),
    [sym__trivia_raw_env_sagesilent] = ACTIONS(1),
    [sym__trivia_raw_env_sageblock] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(3704),
    [sym_block_comment] = STATE(75),
    [sym__root_content] = STATE(75),
    [sym__flat_content] = STATE(75),
    [sym__text_with_env_content] = STATE(75),
    [sym__text_content] = STATE(75),
    [sym__section] = STATE(75),
    [sym__paragraph] = STATE(75),
    [sym__part_declaration] = STATE(161),
    [sym_part] = STATE(509),
    [sym__chapter_declaration] = STATE(169),
    [sym_chapter] = STATE(512),
    [sym__section_declaration] = STATE(179),
    [sym_section] = STATE(515),
    [sym__subsection_declaration] = STATE(190),
    [sym_subsection] = STATE(516),
    [sym__subsubsection_declaration] = STATE(199),
    [sym_subsubsection] = STATE(519),
    [sym__paragraph_declaration] = STATE(211),
    [sym_paragraph] = STATE(521),
    [sym__subparagraph_declaration] = STATE(222),
    [sym_subparagraph] = STATE(522),
    [sym__enum_itemdeclaration] = STATE(229),
    [sym_enum_item] = STATE(523),
    [sym_curly_group] = STATE(75),
    [sym_text] = STATE(75),
    [sym_operator] = STATE(1045),
    [sym_subscript] = STATE(1045),
    [sym_superscript] = STATE(1045),
    [sym__math_content] = STATE(75),
    [sym_displayed_equation] = STATE(75),
    [sym_inline_formula] = STATE(75),
    [sym_math_delimiter] = STATE(75),
    [sym_text_mode] = STATE(75),
    [sym_begin] = STATE(42),
    [sym_generic_environment] = STATE(75),
    [sym_comment_environment] = STATE(75),
    [sym__comment_environment_begin] = STATE(3955),
    [sym_verbatim_environment] = STATE(75),
    [sym__verbatim_environment_begin] = STATE(3959),
    [sym_listing_environment] = STATE(75),
    [sym__listing_environment_begin] = STATE(3751),
    [sym_minted_environment] = STATE(75),
    [sym__minted_environment_begin] = STATE(3901),
    [sym_asy_environment] = STATE(75),
    [sym__asy_environment_begin] = STATE(3879),
    [sym_asydef_environment] = STATE(75),
    [sym__asydef_environment_begin] = STATE(3707),
    [sym_pycode_environment] = STATE(75),
    [sym__pycode_environment_begin] = STATE(3728),
    [sym_luacode_environment] = STATE(75),
    [sym__luacode_environment] = STATE(1086),
    [sym___luacode_environment_begin] = STATE(3967),
    [sym__luacode_environment_star] = STATE(1095),
    [sym___luacode_environment_star_begin] = STATE(3698),
    [sym_sagesilent_environment] = STATE(75),
    [sym__sagesilent_environment_begin] = STATE(3742),
    [sym_sageblock_environment] = STATE(75),
    [sym__sageblock_environment_begin] = STATE(3748),
    [sym_math_environment] = STATE(75),
    [sym__math_environment_begin] = STATE(242),
    [sym__command] = STATE(75),
    [sym_generic_command] = STATE(75),
    [sym_title_declaration] = STATE(75),
    [sym_author_declaration] = STATE(75),
    [sym_package_include] = STATE(75),
    [sym_class_include] = STATE(75),
    [sym_latex_include] = STATE(75),
    [sym_biblatex_include] = STATE(75),
    [sym_bibstyle_include] = STATE(75),
    [sym_bibtex_include] = STATE(75),
    [sym_graphics_include] = STATE(75),
    [sym_svg_include] = STATE(75),
    [sym_inkscape_include] = STATE(75),
    [sym_verbatim_include] = STATE(75),
    [sym_import_include] = STATE(75),
    [sym_caption] = STATE(75),
    [sym_citation] = STATE(75),
    [sym_label_definition] = STATE(75),
    [sym_label_reference] = STATE(75),
    [sym_label_reference_range] = STATE(75),
    [sym_label_number] = STATE(75),
    [sym_new_command_definition] = STATE(75),
    [sym__new_command_definition] = STATE(1120),
    [sym__newer_command_definition] = STATE(1138),
    [sym__new_command_copy] = STATE(1140),
    [sym_old_command_definition] = STATE(75),
    [sym_let_command_definition] = STATE(75),
    [sym_paired_delimiter_definition] = STATE(75),
    [sym_environment_definition] = STATE(75),
    [sym__environment_definition] = STATE(1160),
    [sym__newer_environment_definition] = STATE(1070),
    [sym__new_environment_copy] = STATE(1071),
    [sym_glossary_entry_definition] = STATE(75),
    [sym_glossary_entry_reference] = STATE(75),
    [sym_acronym_definition] = STATE(75),
    [sym_acronym_reference] = STATE(75),
    [sym_theorem_definition] = STATE(75),
    [sym_color_definition] = STATE(75),
    [sym_color_set_definition] = STATE(75),
    [sym_color_reference] = STATE(75),
    [sym_tikz_library_import] = STATE(75),
    [sym_hyperlink] = STATE(75),
    [aux_sym_source_file_repeat1] = STATE(75),
    [aux_sym__section_repeat1] = STATE(509),
    [aux_sym__section_repeat2] = STATE(512),
    [aux_sym__section_repeat3] = STATE(515),
    [aux_sym__section_repeat4] = STATE(516),
    [aux_sym__section_repeat5] = STATE(519),
    [aux_sym__paragraph_repeat1] = STATE(521),
    [aux_sym__paragraph_repeat2] = STATE(522),
    [aux_sym__paragraph_repeat3] = STATE(523),
    [aux_sym_text_repeat1] = STATE(266),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_command_name] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(11),
    [anon_sym_COMMA] = ACTIONS(11),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_RPAREN] = ACTIONS(11),
    [anon_sym_BSLASHpart] = ACTIONS(13),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(15),
    [anon_sym_BSLASHaddpart] = ACTIONS(13),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(15),
    [anon_sym_BSLASHchapter] = ACTIONS(17),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(19),
    [anon_sym_BSLASHaddchap] = ACTIONS(17),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(19),
    [anon_sym_BSLASHsection] = ACTIONS(21),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(23),
    [anon_sym_BSLASHaddsec] = ACTIONS(21),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(23),
    [anon_sym_BSLASHsubsection] = ACTIONS(25),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(27),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(29),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(31),
    [anon_sym_BSLASHparagraph] = ACTIONS(33),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(35),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(37),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(39),
    [anon_sym_BSLASHitem] = ACTIONS(41),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [sym_word] = ACTIONS(47),
    [sym_placeholder] = ACTIONS(49),
    [sym_delimiter] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_BANG] = ACTIONS(53),
    [anon_sym_PIPE] = ACTIONS(53),
    [anon_sym_COLON] = ACTIONS(53),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym__] = ACTIONS(55),
    [anon_sym_CARET] = ACTIONS(57),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(59),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(63),
    [anon_sym_BSLASHleft] = ACTIONS(65),
    [anon_sym_BSLASHbigl] = ACTIONS(65),
    [anon_sym_BSLASHBigl] = ACTIONS(65),
    [anon_sym_BSLASHbiggl] = ACTIONS(65),
    [anon_sym_BSLASHBiggl] = ACTIONS(65),
    [anon_sym_BSLASHtext] = ACTIONS(67),
    [anon_sym_BSLASHintertext] = ACTIONS(67),
    [anon_sym_BSLASHshortintertext] = ACTIONS(67),
    [anon_sym_BSLASHbegin] = ACTIONS(69),
    [anon_sym_BSLASHtitle] = ACTIONS(71),
    [anon_sym_BSLASHauthor] = ACTIONS(73),
    [anon_sym_BSLASHusepackage] = ACTIONS(75),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(75),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(77),
    [anon_sym_BSLASHinclude] = ACTIONS(79),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(79),
    [anon_sym_BSLASHinput] = ACTIONS(79),
    [anon_sym_BSLASHsubfile] = ACTIONS(79),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(81),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(83),
    [anon_sym_BSLASHbibliography] = ACTIONS(85),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(87),
    [anon_sym_BSLASHincludesvg] = ACTIONS(89),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(91),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(93),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(93),
    [anon_sym_BSLASHimport] = ACTIONS(95),
    [anon_sym_BSLASHsubimport] = ACTIONS(95),
    [anon_sym_BSLASHinputfrom] = ACTIONS(95),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(95),
    [anon_sym_BSLASHincludefrom] = ACTIONS(95),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(95),
    [anon_sym_BSLASHcaption] = ACTIONS(97),
    [anon_sym_BSLASHcite] = ACTIONS(99),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(101),
    [anon_sym_BSLASHCite] = ACTIONS(99),
    [anon_sym_BSLASHnocite] = ACTIONS(99),
    [anon_sym_BSLASHcitet] = ACTIONS(99),
    [anon_sym_BSLASHcitep] = ACTIONS(99),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(101),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(101),
    [anon_sym_BSLASHciteA] = ACTIONS(99),
    [anon_sym_BSLASHciteR] = ACTIONS(99),
    [anon_sym_BSLASHciteS] = ACTIONS(99),
    [anon_sym_BSLASHciteyearR] = ACTIONS(99),
    [anon_sym_BSLASHciteauthor] = ACTIONS(99),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(101),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(99),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(101),
    [anon_sym_BSLASHcitetitle] = ACTIONS(99),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(101),
    [anon_sym_BSLASHciteyear] = ACTIONS(99),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(101),
    [anon_sym_BSLASHcitedate] = ACTIONS(99),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(101),
    [anon_sym_BSLASHciteurl] = ACTIONS(99),
    [anon_sym_BSLASHfullcite] = ACTIONS(99),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(99),
    [anon_sym_BSLASHcitealt] = ACTIONS(99),
    [anon_sym_BSLASHcitealp] = ACTIONS(99),
    [anon_sym_BSLASHcitetext] = ACTIONS(99),
    [anon_sym_BSLASHparencite] = ACTIONS(99),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(101),
    [anon_sym_BSLASHParencite] = ACTIONS(99),
    [anon_sym_BSLASHfootcite] = ACTIONS(99),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(99),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(99),
    [anon_sym_BSLASHtextcite] = ACTIONS(99),
    [anon_sym_BSLASHTextcite] = ACTIONS(99),
    [anon_sym_BSLASHsmartcite] = ACTIONS(99),
    [anon_sym_BSLASHSmartcite] = ACTIONS(99),
    [anon_sym_BSLASHsupercite] = ACTIONS(99),
    [anon_sym_BSLASHautocite] = ACTIONS(99),
    [anon_sym_BSLASHAutocite] = ACTIONS(99),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(101),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(101),
    [anon_sym_BSLASHvolcite] = ACTIONS(99),
    [anon_sym_BSLASHVolcite] = ACTIONS(99),
    [anon_sym_BSLASHpvolcite] = ACTIONS(99),
    [anon_sym_BSLASHPvolcite] = ACTIONS(99),
    [anon_sym_BSLASHfvolcite] = ACTIONS(99),
    [anon_sym_BSLASHftvolcite] = ACTIONS(99),
    [anon_sym_BSLASHsvolcite] = ACTIONS(99),
    [anon_sym_BSLASHSvolcite] = ACTIONS(99),
    [anon_sym_BSLASHtvolcite] = ACTIONS(99),
    [anon_sym_BSLASHTvolcite] = ACTIONS(99),
    [anon_sym_BSLASHavolcite] = ACTIONS(99),
    [anon_sym_BSLASHAvolcite] = ACTIONS(99),
    [anon_sym_BSLASHnotecite] = ACTIONS(99),
    [anon_sym_BSLASHNotecite] = ACTIONS(99),
    [anon_sym_BSLASHpnotecite] = ACTIONS(99),
    [anon_sym_BSLASHPnotecite] = ACTIONS(99),
    [anon_sym_BSLASHfnotecite] = ACTIONS(99),
    [anon_sym_BSLASHlabel] = ACTIONS(103),
    [anon_sym_BSLASHref] = ACTIONS(105),
    [anon_sym_BSLASHeqref] = ACTIONS(105),
    [anon_sym_BSLASHvref] = ACTIONS(105),
    [anon_sym_BSLASHVref] = ACTIONS(105),
    [anon_sym_BSLASHautoref] = ACTIONS(105),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(107),
    [anon_sym_BSLASHpageref] = ACTIONS(105),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(107),
    [anon_sym_BSLASHautopageref] = ACTIONS(105),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(107),
    [anon_sym_BSLASHcref] = ACTIONS(105),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(107),
    [anon_sym_BSLASHCref] = ACTIONS(105),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(107),
    [anon_sym_BSLASHcpageref] = ACTIONS(105),
    [anon_sym_BSLASHCpageref] = ACTIONS(105),
    [anon_sym_BSLASHnamecref] = ACTIONS(105),
    [anon_sym_BSLASHnameCref] = ACTIONS(105),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(105),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(105),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(105),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(105),
    [anon_sym_BSLASHlabelcref] = ACTIONS(105),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(107),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(105),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(107),
    [anon_sym_BSLASHcrefrange] = ACTIONS(109),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(111),
    [anon_sym_BSLASHCrefrange] = ACTIONS(109),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(111),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(109),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(109),
    [anon_sym_BSLASHnewlabel] = ACTIONS(113),
    [anon_sym_BSLASHnewcommand] = ACTIONS(115),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(117),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(115),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(117),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(115),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(117),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(115),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(117),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(115),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(117),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(119),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(119),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(119),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(119),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(119),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(119),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(119),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(119),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(121),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(121),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(121),
    [anon_sym_BSLASHdef] = ACTIONS(123),
    [anon_sym_BSLASHgdef] = ACTIONS(123),
    [anon_sym_BSLASHedef] = ACTIONS(123),
    [anon_sym_BSLASHxdef] = ACTIONS(123),
    [anon_sym_BSLASHlet] = ACTIONS(125),
    [anon_sym_BSLASHglet] = ACTIONS(125),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(127),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(127),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(129),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(129),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(131),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(131),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(131),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(131),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(133),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(133),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(133),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(135),
    [anon_sym_BSLASHgls] = ACTIONS(137),
    [anon_sym_BSLASHGls] = ACTIONS(137),
    [anon_sym_BSLASHGLS] = ACTIONS(137),
    [anon_sym_BSLASHglspl] = ACTIONS(137),
    [anon_sym_BSLASHGlspl] = ACTIONS(137),
    [anon_sym_BSLASHGLSpl] = ACTIONS(137),
    [anon_sym_BSLASHglsdisp] = ACTIONS(137),
    [anon_sym_BSLASHglslink] = ACTIONS(137),
    [anon_sym_BSLASHglstext] = ACTIONS(137),
    [anon_sym_BSLASHGlstext] = ACTIONS(137),
    [anon_sym_BSLASHGLStext] = ACTIONS(137),
    [anon_sym_BSLASHglsfirst] = ACTIONS(137),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(137),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(137),
    [anon_sym_BSLASHglsplural] = ACTIONS(137),
    [anon_sym_BSLASHGlsplural] = ACTIONS(137),
    [anon_sym_BSLASHGLSplural] = ACTIONS(137),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(137),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(137),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(137),
    [anon_sym_BSLASHglsname] = ACTIONS(137),
    [anon_sym_BSLASHGlsname] = ACTIONS(137),
    [anon_sym_BSLASHGLSname] = ACTIONS(137),
    [anon_sym_BSLASHglssymbol] = ACTIONS(137),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(137),
    [anon_sym_BSLASHglsdesc] = ACTIONS(137),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(137),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(137),
    [anon_sym_BSLASHglsuseri] = ACTIONS(137),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(137),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(137),
    [anon_sym_BSLASHglsuserii] = ACTIONS(137),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(137),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(137),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(137),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(137),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(137),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(137),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(137),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(137),
    [anon_sym_BSLASHglsuserv] = ACTIONS(137),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(137),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(137),
    [anon_sym_BSLASHglsuservi] = ACTIONS(137),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(137),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(137),
    [anon_sym_BSLASHnewacronym] = ACTIONS(139),
    [anon_sym_BSLASHacrshort] = ACTIONS(141),
    [anon_sym_BSLASHAcrshort] = ACTIONS(141),
    [anon_sym_BSLASHACRshort] = ACTIONS(141),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(141),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(141),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(141),
    [anon_sym_BSLASHacrlong] = ACTIONS(141),
    [anon_sym_BSLASHAcrlong] = ACTIONS(141),
    [anon_sym_BSLASHACRlong] = ACTIONS(141),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(141),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(141),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(141),
    [anon_sym_BSLASHacrfull] = ACTIONS(141),
    [anon_sym_BSLASHAcrfull] = ACTIONS(141),
    [anon_sym_BSLASHACRfull] = ACTIONS(141),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(141),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(141),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(141),
    [anon_sym_BSLASHacs] = ACTIONS(141),
    [anon_sym_BSLASHAcs] = ACTIONS(141),
    [anon_sym_BSLASHacsp] = ACTIONS(141),
    [anon_sym_BSLASHAcsp] = ACTIONS(141),
    [anon_sym_BSLASHacl] = ACTIONS(141),
    [anon_sym_BSLASHAcl] = ACTIONS(141),
    [anon_sym_BSLASHaclp] = ACTIONS(141),
    [anon_sym_BSLASHAclp] = ACTIONS(141),
    [anon_sym_BSLASHacf] = ACTIONS(141),
    [anon_sym_BSLASHAcf] = ACTIONS(141),
    [anon_sym_BSLASHacfp] = ACTIONS(141),
    [anon_sym_BSLASHAcfp] = ACTIONS(141),
    [anon_sym_BSLASHac] = ACTIONS(141),
    [anon_sym_BSLASHAc] = ACTIONS(141),
    [anon_sym_BSLASHacp] = ACTIONS(141),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(141),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(141),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(141),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(141),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(141),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(141),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(141),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(141),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(141),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(141),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(143),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(145),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(143),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(145),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(147),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(149),
    [anon_sym_BSLASHcolor] = ACTIONS(151),
    [anon_sym_BSLASHpagecolor] = ACTIONS(151),
    [anon_sym_BSLASHtextcolor] = ACTIONS(151),
    [anon_sym_BSLASHmathcolor] = ACTIONS(151),
    [anon_sym_BSLASHcolorbox] = ACTIONS(151),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(153),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(153),
    [anon_sym_BSLASHurl] = ACTIONS(155),
    [anon_sym_BSLASHhref] = ACTIONS(155),
  },
  [2] = {
    [sym_block_comment] = STATE(97),
    [sym__root_content] = STATE(97),
    [sym__flat_content] = STATE(97),
    [sym__text_with_env_content] = STATE(97),
    [sym__text_content] = STATE(97),
    [sym__section] = STATE(97),
    [sym__paragraph] = STATE(97),
    [sym__part_declaration] = STATE(166),
    [sym_part] = STATE(895),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(896),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(897),
    [sym__subsection_declaration] = STATE(197),
    [sym_subsection] = STATE(898),
    [sym__subsubsection_declaration] = STATE(200),
    [sym_subsubsection] = STATE(899),
    [sym__paragraph_declaration] = STATE(217),
    [sym_paragraph] = STATE(900),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(901),
    [sym__enum_itemdeclaration] = STATE(237),
    [sym_enum_item] = STATE(902),
    [sym_curly_group] = STATE(97),
    [sym_text] = STATE(97),
    [sym_operator] = STATE(1465),
    [sym_subscript] = STATE(1465),
    [sym_superscript] = STATE(1465),
    [sym__math_content] = STATE(97),
    [sym_displayed_equation] = STATE(97),
    [sym_inline_formula] = STATE(97),
    [sym_math_delimiter] = STATE(97),
    [sym_text_mode] = STATE(97),
    [sym_begin] = STATE(43),
    [sym_generic_environment] = STATE(97),
    [sym_comment_environment] = STATE(97),
    [sym__comment_environment_begin] = STATE(3816),
    [sym_verbatim_environment] = STATE(97),
    [sym__verbatim_environment_begin] = STATE(3822),
    [sym_listing_environment] = STATE(97),
    [sym__listing_environment_begin] = STATE(3825),
    [sym_minted_environment] = STATE(97),
    [sym__minted_environment_begin] = STATE(3826),
    [sym_asy_environment] = STATE(97),
    [sym__asy_environment_begin] = STATE(3828),
    [sym_asydef_environment] = STATE(97),
    [sym__asydef_environment_begin] = STATE(3829),
    [sym_pycode_environment] = STATE(97),
    [sym__pycode_environment_begin] = STATE(3830),
    [sym_luacode_environment] = STATE(97),
    [sym__luacode_environment] = STATE(1476),
    [sym___luacode_environment_begin] = STATE(3831),
    [sym__luacode_environment_star] = STATE(1477),
    [sym___luacode_environment_star_begin] = STATE(3832),
    [sym_sagesilent_environment] = STATE(97),
    [sym__sagesilent_environment_begin] = STATE(3833),
    [sym_sageblock_environment] = STATE(97),
    [sym__sageblock_environment_begin] = STATE(3834),
    [sym_math_environment] = STATE(97),
    [sym__math_environment_begin] = STATE(249),
    [sym__command] = STATE(97),
    [sym_generic_command] = STATE(97),
    [sym_title_declaration] = STATE(97),
    [sym_author_declaration] = STATE(97),
    [sym_package_include] = STATE(97),
    [sym_class_include] = STATE(97),
    [sym_latex_include] = STATE(97),
    [sym_biblatex_include] = STATE(97),
    [sym_bibstyle_include] = STATE(97),
    [sym_bibtex_include] = STATE(97),
    [sym_graphics_include] = STATE(97),
    [sym_svg_include] = STATE(97),
    [sym_inkscape_include] = STATE(97),
    [sym_verbatim_include] = STATE(97),
    [sym_import_include] = STATE(97),
    [sym_caption] = STATE(97),
    [sym_citation] = STATE(97),
    [sym_label_definition] = STATE(97),
    [sym_label_reference] = STATE(97),
    [sym_label_reference_range] = STATE(97),
    [sym_label_number] = STATE(97),
    [sym_new_command_definition] = STATE(97),
    [sym__new_command_definition] = STATE(1478),
    [sym__newer_command_definition] = STATE(1479),
    [sym__new_command_copy] = STATE(1480),
    [sym_old_command_definition] = STATE(97),
    [sym_let_command_definition] = STATE(97),
    [sym_paired_delimiter_definition] = STATE(97),
    [sym_environment_definition] = STATE(97),
    [sym__environment_definition] = STATE(1481),
    [sym__newer_environment_definition] = STATE(1482),
    [sym__new_environment_copy] = STATE(1483),
    [sym_glossary_entry_definition] = STATE(97),
    [sym_glossary_entry_reference] = STATE(97),
    [sym_acronym_definition] = STATE(97),
    [sym_acronym_reference] = STATE(97),
    [sym_theorem_definition] = STATE(97),
    [sym_color_definition] = STATE(97),
    [sym_color_set_definition] = STATE(97),
    [sym_color_reference] = STATE(97),
    [sym_tikz_library_import] = STATE(97),
    [sym_hyperlink] = STATE(97),
    [aux_sym_source_file_repeat1] = STATE(97),
    [aux_sym__section_repeat1] = STATE(895),
    [aux_sym__section_repeat2] = STATE(896),
    [aux_sym__section_repeat3] = STATE(897),
    [aux_sym__section_repeat4] = STATE(898),
    [aux_sym__section_repeat5] = STATE(899),
    [aux_sym__paragraph_repeat1] = STATE(900),
    [aux_sym__paragraph_repeat2] = STATE(901),
    [aux_sym__paragraph_repeat3] = STATE(902),
    [aux_sym_text_repeat1] = STATE(273),
    [sym_command_name] = ACTIONS(157),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(157),
    [anon_sym_LBRACK] = ACTIONS(159),
    [anon_sym_RBRACK] = ACTIONS(159),
    [anon_sym_COMMA] = ACTIONS(159),
    [anon_sym_EQ] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_RPAREN] = ACTIONS(159),
    [anon_sym_BSLASHpart] = ACTIONS(157),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(159),
    [anon_sym_BSLASHaddpart] = ACTIONS(157),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(159),
    [anon_sym_BSLASHchapter] = ACTIONS(157),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(159),
    [anon_sym_BSLASHaddchap] = ACTIONS(157),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsection] = ACTIONS(157),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(159),
    [anon_sym_BSLASHaddsec] = ACTIONS(157),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsubsection] = ACTIONS(157),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(157),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(159),
    [anon_sym_BSLASHparagraph] = ACTIONS(157),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(157),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(159),
    [anon_sym_BSLASHitem] = ACTIONS(157),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(159),
    [anon_sym_LBRACE] = ACTIONS(159),
    [sym_word] = ACTIONS(157),
    [sym_placeholder] = ACTIONS(159),
    [sym_delimiter] = ACTIONS(159),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_STAR] = ACTIONS(159),
    [anon_sym_SLASH] = ACTIONS(159),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_COLON] = ACTIONS(157),
    [anon_sym_SQUOTE] = ACTIONS(157),
    [anon_sym__] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(159),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(159),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(159),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(157),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(159),
    [anon_sym_BSLASHleft] = ACTIONS(157),
    [anon_sym_BSLASHbigl] = ACTIONS(157),
    [anon_sym_BSLASHBigl] = ACTIONS(157),
    [anon_sym_BSLASHbiggl] = ACTIONS(157),
    [anon_sym_BSLASHBiggl] = ACTIONS(157),
    [anon_sym_BSLASHright] = ACTIONS(157),
    [anon_sym_BSLASHbigr] = ACTIONS(157),
    [anon_sym_BSLASHBigr] = ACTIONS(157),
    [anon_sym_BSLASHbiggr] = ACTIONS(157),
    [anon_sym_BSLASHBiggr] = ACTIONS(157),
    [anon_sym_BSLASHtext] = ACTIONS(157),
    [anon_sym_BSLASHintertext] = ACTIONS(157),
    [anon_sym_BSLASHshortintertext] = ACTIONS(157),
    [anon_sym_BSLASHbegin] = ACTIONS(157),
    [anon_sym_BSLASHtitle] = ACTIONS(157),
    [anon_sym_BSLASHauthor] = ACTIONS(157),
    [anon_sym_BSLASHusepackage] = ACTIONS(157),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(157),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(157),
    [anon_sym_BSLASHinclude] = ACTIONS(157),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(157),
    [anon_sym_BSLASHinput] = ACTIONS(157),
    [anon_sym_BSLASHsubfile] = ACTIONS(157),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(157),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(157),
    [anon_sym_BSLASHbibliography] = ACTIONS(157),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(157),
    [anon_sym_BSLASHincludesvg] = ACTIONS(157),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(157),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(157),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(157),
    [anon_sym_BSLASHimport] = ACTIONS(157),
    [anon_sym_BSLASHsubimport] = ACTIONS(157),
    [anon_sym_BSLASHinputfrom] = ACTIONS(157),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(157),
    [anon_sym_BSLASHincludefrom] = ACTIONS(157),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(157),
    [anon_sym_BSLASHcaption] = ACTIONS(157),
    [anon_sym_BSLASHcite] = ACTIONS(157),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(159),
    [anon_sym_BSLASHCite] = ACTIONS(157),
    [anon_sym_BSLASHnocite] = ACTIONS(157),
    [anon_sym_BSLASHcitet] = ACTIONS(157),
    [anon_sym_BSLASHcitep] = ACTIONS(157),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(159),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(159),
    [anon_sym_BSLASHciteA] = ACTIONS(157),
    [anon_sym_BSLASHciteR] = ACTIONS(157),
    [anon_sym_BSLASHciteS] = ACTIONS(157),
    [anon_sym_BSLASHciteyearR] = ACTIONS(157),
    [anon_sym_BSLASHciteauthor] = ACTIONS(157),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(159),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(157),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(159),
    [anon_sym_BSLASHcitetitle] = ACTIONS(157),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(159),
    [anon_sym_BSLASHciteyear] = ACTIONS(157),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(159),
    [anon_sym_BSLASHcitedate] = ACTIONS(157),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(159),
    [anon_sym_BSLASHciteurl] = ACTIONS(157),
    [anon_sym_BSLASHfullcite] = ACTIONS(157),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(157),
    [anon_sym_BSLASHcitealt] = ACTIONS(157),
    [anon_sym_BSLASHcitealp] = ACTIONS(157),
    [anon_sym_BSLASHcitetext] = ACTIONS(157),
    [anon_sym_BSLASHparencite] = ACTIONS(157),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(159),
    [anon_sym_BSLASHParencite] = ACTIONS(157),
    [anon_sym_BSLASHfootcite] = ACTIONS(157),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(157),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(157),
    [anon_sym_BSLASHtextcite] = ACTIONS(157),
    [anon_sym_BSLASHTextcite] = ACTIONS(157),
    [anon_sym_BSLASHsmartcite] = ACTIONS(157),
    [anon_sym_BSLASHSmartcite] = ACTIONS(157),
    [anon_sym_BSLASHsupercite] = ACTIONS(157),
    [anon_sym_BSLASHautocite] = ACTIONS(157),
    [anon_sym_BSLASHAutocite] = ACTIONS(157),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(159),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(159),
    [anon_sym_BSLASHvolcite] = ACTIONS(157),
    [anon_sym_BSLASHVolcite] = ACTIONS(157),
    [anon_sym_BSLASHpvolcite] = ACTIONS(157),
    [anon_sym_BSLASHPvolcite] = ACTIONS(157),
    [anon_sym_BSLASHfvolcite] = ACTIONS(157),
    [anon_sym_BSLASHftvolcite] = ACTIONS(157),
    [anon_sym_BSLASHsvolcite] = ACTIONS(157),
    [anon_sym_BSLASHSvolcite] = ACTIONS(157),
    [anon_sym_BSLASHtvolcite] = ACTIONS(157),
    [anon_sym_BSLASHTvolcite] = ACTIONS(157),
    [anon_sym_BSLASHavolcite] = ACTIONS(157),
    [anon_sym_BSLASHAvolcite] = ACTIONS(157),
    [anon_sym_BSLASHnotecite] = ACTIONS(157),
    [anon_sym_BSLASHNotecite] = ACTIONS(157),
    [anon_sym_BSLASHpnotecite] = ACTIONS(157),
    [anon_sym_BSLASHPnotecite] = ACTIONS(157),
    [anon_sym_BSLASHfnotecite] = ACTIONS(157),
    [anon_sym_BSLASHlabel] = ACTIONS(157),
    [anon_sym_BSLASHref] = ACTIONS(157),
    [anon_sym_BSLASHeqref] = ACTIONS(157),
    [anon_sym_BSLASHvref] = ACTIONS(157),
    [anon_sym_BSLASHVref] = ACTIONS(157),
    [anon_sym_BSLASHautoref] = ACTIONS(157),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(159),
    [anon_sym_BSLASHpageref] = ACTIONS(157),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(159),
    [anon_sym_BSLASHautopageref] = ACTIONS(157),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(159),
    [anon_sym_BSLASHcref] = ACTIONS(157),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(159),
    [anon_sym_BSLASHCref] = ACTIONS(157),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(159),
    [anon_sym_BSLASHcpageref] = ACTIONS(157),
    [anon_sym_BSLASHCpageref] = ACTIONS(157),
    [anon_sym_BSLASHnamecref] = ACTIONS(157),
    [anon_sym_BSLASHnameCref] = ACTIONS(157),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(157),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(157),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(157),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(157),
    [anon_sym_BSLASHlabelcref] = ACTIONS(157),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(159),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(157),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(159),
    [anon_sym_BSLASHcrefrange] = ACTIONS(157),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(159),
    [anon_sym_BSLASHCrefrange] = ACTIONS(157),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(159),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(157),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(157),
    [anon_sym_BSLASHnewlabel] = ACTIONS(157),
    [anon_sym_BSLASHnewcommand] = ACTIONS(157),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(159),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(157),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(159),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(157),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(159),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(157),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(159),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(157),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(159),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(157),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(157),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(157),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(157),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(157),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(157),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(157),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(157),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(157),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(157),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(157),
    [anon_sym_BSLASHdef] = ACTIONS(157),
    [anon_sym_BSLASHgdef] = ACTIONS(157),
    [anon_sym_BSLASHedef] = ACTIONS(157),
    [anon_sym_BSLASHxdef] = ACTIONS(157),
    [anon_sym_BSLASHlet] = ACTIONS(157),
    [anon_sym_BSLASHglet] = ACTIONS(157),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(157),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(157),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(157),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(157),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(157),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(157),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(157),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(157),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(157),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(157),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(157),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(157),
    [anon_sym_BSLASHgls] = ACTIONS(157),
    [anon_sym_BSLASHGls] = ACTIONS(157),
    [anon_sym_BSLASHGLS] = ACTIONS(157),
    [anon_sym_BSLASHglspl] = ACTIONS(157),
    [anon_sym_BSLASHGlspl] = ACTIONS(157),
    [anon_sym_BSLASHGLSpl] = ACTIONS(157),
    [anon_sym_BSLASHglsdisp] = ACTIONS(157),
    [anon_sym_BSLASHglslink] = ACTIONS(157),
    [anon_sym_BSLASHglstext] = ACTIONS(157),
    [anon_sym_BSLASHGlstext] = ACTIONS(157),
    [anon_sym_BSLASHGLStext] = ACTIONS(157),
    [anon_sym_BSLASHglsfirst] = ACTIONS(157),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(157),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(157),
    [anon_sym_BSLASHglsplural] = ACTIONS(157),
    [anon_sym_BSLASHGlsplural] = ACTIONS(157),
    [anon_sym_BSLASHGLSplural] = ACTIONS(157),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(157),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(157),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(157),
    [anon_sym_BSLASHglsname] = ACTIONS(157),
    [anon_sym_BSLASHGlsname] = ACTIONS(157),
    [anon_sym_BSLASHGLSname] = ACTIONS(157),
    [anon_sym_BSLASHglssymbol] = ACTIONS(157),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(157),
    [anon_sym_BSLASHglsdesc] = ACTIONS(157),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(157),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(157),
    [anon_sym_BSLASHglsuseri] = ACTIONS(157),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(157),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(157),
    [anon_sym_BSLASHglsuserii] = ACTIONS(157),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(157),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(157),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(157),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(157),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(157),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(157),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(157),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(157),
    [anon_sym_BSLASHglsuserv] = ACTIONS(157),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(157),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(157),
    [anon_sym_BSLASHglsuservi] = ACTIONS(157),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(157),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(157),
    [anon_sym_BSLASHnewacronym] = ACTIONS(157),
    [anon_sym_BSLASHacrshort] = ACTIONS(157),
    [anon_sym_BSLASHAcrshort] = ACTIONS(157),
    [anon_sym_BSLASHACRshort] = ACTIONS(157),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(157),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(157),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(157),
    [anon_sym_BSLASHacrlong] = ACTIONS(157),
    [anon_sym_BSLASHAcrlong] = ACTIONS(157),
    [anon_sym_BSLASHACRlong] = ACTIONS(157),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(157),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(157),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(157),
    [anon_sym_BSLASHacrfull] = ACTIONS(157),
    [anon_sym_BSLASHAcrfull] = ACTIONS(157),
    [anon_sym_BSLASHACRfull] = ACTIONS(157),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(157),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(157),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(157),
    [anon_sym_BSLASHacs] = ACTIONS(157),
    [anon_sym_BSLASHAcs] = ACTIONS(157),
    [anon_sym_BSLASHacsp] = ACTIONS(157),
    [anon_sym_BSLASHAcsp] = ACTIONS(157),
    [anon_sym_BSLASHacl] = ACTIONS(157),
    [anon_sym_BSLASHAcl] = ACTIONS(157),
    [anon_sym_BSLASHaclp] = ACTIONS(157),
    [anon_sym_BSLASHAclp] = ACTIONS(157),
    [anon_sym_BSLASHacf] = ACTIONS(157),
    [anon_sym_BSLASHAcf] = ACTIONS(157),
    [anon_sym_BSLASHacfp] = ACTIONS(157),
    [anon_sym_BSLASHAcfp] = ACTIONS(157),
    [anon_sym_BSLASHac] = ACTIONS(157),
    [anon_sym_BSLASHAc] = ACTIONS(157),
    [anon_sym_BSLASHacp] = ACTIONS(157),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(157),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(157),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(157),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(157),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(157),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(157),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(157),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(157),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(157),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(157),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(157),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(159),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(157),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(159),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(157),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(157),
    [anon_sym_BSLASHcolor] = ACTIONS(157),
    [anon_sym_BSLASHpagecolor] = ACTIONS(157),
    [anon_sym_BSLASHtextcolor] = ACTIONS(157),
    [anon_sym_BSLASHmathcolor] = ACTIONS(157),
    [anon_sym_BSLASHcolorbox] = ACTIONS(157),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(157),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(157),
    [anon_sym_BSLASHurl] = ACTIONS(157),
    [anon_sym_BSLASHhref] = ACTIONS(157),
  },
  [3] = {
    [sym_block_comment] = STATE(104),
    [sym__root_content] = STATE(104),
    [sym__flat_content] = STATE(104),
    [sym__text_with_env_content] = STATE(104),
    [sym__text_content] = STATE(104),
    [sym__section] = STATE(104),
    [sym__paragraph] = STATE(104),
    [sym__part_declaration] = STATE(165),
    [sym_part] = STATE(787),
    [sym__chapter_declaration] = STATE(172),
    [sym_chapter] = STATE(788),
    [sym__section_declaration] = STATE(185),
    [sym_section] = STATE(789),
    [sym__subsection_declaration] = STATE(194),
    [sym_subsection] = STATE(790),
    [sym__subsubsection_declaration] = STATE(204),
    [sym_subsubsection] = STATE(791),
    [sym__paragraph_declaration] = STATE(214),
    [sym_paragraph] = STATE(792),
    [sym__subparagraph_declaration] = STATE(224),
    [sym_subparagraph] = STATE(793),
    [sym__enum_itemdeclaration] = STATE(236),
    [sym_enum_item] = STATE(794),
    [sym_curly_group] = STATE(104),
    [sym_text] = STATE(104),
    [sym_operator] = STATE(1266),
    [sym_subscript] = STATE(1266),
    [sym_superscript] = STATE(1266),
    [sym__math_content] = STATE(104),
    [sym_displayed_equation] = STATE(104),
    [sym_inline_formula] = STATE(104),
    [sym_math_delimiter] = STATE(104),
    [sym_text_mode] = STATE(104),
    [sym_begin] = STATE(47),
    [sym_generic_environment] = STATE(104),
    [sym_comment_environment] = STATE(104),
    [sym__comment_environment_begin] = STATE(3888),
    [sym_verbatim_environment] = STATE(104),
    [sym__verbatim_environment_begin] = STATE(3890),
    [sym_listing_environment] = STATE(104),
    [sym__listing_environment_begin] = STATE(3891),
    [sym_minted_environment] = STATE(104),
    [sym__minted_environment_begin] = STATE(3892),
    [sym_asy_environment] = STATE(104),
    [sym__asy_environment_begin] = STATE(3893),
    [sym_asydef_environment] = STATE(104),
    [sym__asydef_environment_begin] = STATE(3895),
    [sym_pycode_environment] = STATE(104),
    [sym__pycode_environment_begin] = STATE(3896),
    [sym_luacode_environment] = STATE(104),
    [sym__luacode_environment] = STATE(1278),
    [sym___luacode_environment_begin] = STATE(3897),
    [sym__luacode_environment_star] = STATE(1282),
    [sym___luacode_environment_star_begin] = STATE(3898),
    [sym_sagesilent_environment] = STATE(104),
    [sym__sagesilent_environment_begin] = STATE(3899),
    [sym_sageblock_environment] = STATE(104),
    [sym__sageblock_environment_begin] = STATE(3900),
    [sym_math_environment] = STATE(104),
    [sym__math_environment_begin] = STATE(252),
    [sym__command] = STATE(104),
    [sym_generic_command] = STATE(104),
    [sym_title_declaration] = STATE(104),
    [sym_author_declaration] = STATE(104),
    [sym_package_include] = STATE(104),
    [sym_class_include] = STATE(104),
    [sym_latex_include] = STATE(104),
    [sym_biblatex_include] = STATE(104),
    [sym_bibstyle_include] = STATE(104),
    [sym_bibtex_include] = STATE(104),
    [sym_graphics_include] = STATE(104),
    [sym_svg_include] = STATE(104),
    [sym_inkscape_include] = STATE(104),
    [sym_verbatim_include] = STATE(104),
    [sym_import_include] = STATE(104),
    [sym_caption] = STATE(104),
    [sym_citation] = STATE(104),
    [sym_label_definition] = STATE(104),
    [sym_label_reference] = STATE(104),
    [sym_label_reference_range] = STATE(104),
    [sym_label_number] = STATE(104),
    [sym_new_command_definition] = STATE(104),
    [sym__new_command_definition] = STATE(1284),
    [sym__newer_command_definition] = STATE(1285),
    [sym__new_command_copy] = STATE(1347),
    [sym_old_command_definition] = STATE(104),
    [sym_let_command_definition] = STATE(104),
    [sym_paired_delimiter_definition] = STATE(104),
    [sym_environment_definition] = STATE(104),
    [sym__environment_definition] = STATE(1348),
    [sym__newer_environment_definition] = STATE(1349),
    [sym__new_environment_copy] = STATE(1350),
    [sym_glossary_entry_definition] = STATE(104),
    [sym_glossary_entry_reference] = STATE(104),
    [sym_acronym_definition] = STATE(104),
    [sym_acronym_reference] = STATE(104),
    [sym_theorem_definition] = STATE(104),
    [sym_color_definition] = STATE(104),
    [sym_color_set_definition] = STATE(104),
    [sym_color_reference] = STATE(104),
    [sym_tikz_library_import] = STATE(104),
    [sym_hyperlink] = STATE(104),
    [aux_sym_source_file_repeat1] = STATE(104),
    [aux_sym__section_repeat1] = STATE(787),
    [aux_sym__section_repeat2] = STATE(788),
    [aux_sym__section_repeat3] = STATE(789),
    [aux_sym__section_repeat4] = STATE(790),
    [aux_sym__section_repeat5] = STATE(791),
    [aux_sym__paragraph_repeat1] = STATE(792),
    [aux_sym__paragraph_repeat2] = STATE(793),
    [aux_sym__paragraph_repeat3] = STATE(794),
    [aux_sym_text_repeat1] = STATE(268),
    [sym_command_name] = ACTIONS(163),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(165),
    [anon_sym_RBRACK] = ACTIONS(165),
    [anon_sym_COMMA] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_RPAREN] = ACTIONS(165),
    [anon_sym_BSLASHpart] = ACTIONS(163),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(165),
    [anon_sym_BSLASHaddpart] = ACTIONS(163),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(165),
    [anon_sym_BSLASHchapter] = ACTIONS(163),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(165),
    [anon_sym_BSLASHaddchap] = ACTIONS(163),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(165),
    [anon_sym_BSLASHsection] = ACTIONS(163),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(165),
    [anon_sym_BSLASHaddsec] = ACTIONS(163),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(165),
    [anon_sym_BSLASHsubsection] = ACTIONS(163),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(165),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(163),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(165),
    [anon_sym_BSLASHparagraph] = ACTIONS(163),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(165),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(163),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(165),
    [anon_sym_BSLASHitem] = ACTIONS(163),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(165),
    [sym_word] = ACTIONS(163),
    [sym_placeholder] = ACTIONS(165),
    [sym_delimiter] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(165),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(165),
    [anon_sym_LT] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym__] = ACTIONS(165),
    [anon_sym_CARET] = ACTIONS(165),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(165),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(165),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(167),
    [anon_sym_BSLASHleft] = ACTIONS(163),
    [anon_sym_BSLASHbigl] = ACTIONS(163),
    [anon_sym_BSLASHBigl] = ACTIONS(163),
    [anon_sym_BSLASHbiggl] = ACTIONS(163),
    [anon_sym_BSLASHBiggl] = ACTIONS(163),
    [anon_sym_BSLASHright] = ACTIONS(163),
    [anon_sym_BSLASHbigr] = ACTIONS(163),
    [anon_sym_BSLASHBigr] = ACTIONS(163),
    [anon_sym_BSLASHbiggr] = ACTIONS(163),
    [anon_sym_BSLASHBiggr] = ACTIONS(163),
    [anon_sym_BSLASHtext] = ACTIONS(163),
    [anon_sym_BSLASHintertext] = ACTIONS(163),
    [anon_sym_BSLASHshortintertext] = ACTIONS(163),
    [anon_sym_BSLASHbegin] = ACTIONS(163),
    [anon_sym_BSLASHtitle] = ACTIONS(163),
    [anon_sym_BSLASHauthor] = ACTIONS(163),
    [anon_sym_BSLASHusepackage] = ACTIONS(163),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(163),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(163),
    [anon_sym_BSLASHinclude] = ACTIONS(163),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(163),
    [anon_sym_BSLASHinput] = ACTIONS(163),
    [anon_sym_BSLASHsubfile] = ACTIONS(163),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(163),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(163),
    [anon_sym_BSLASHbibliography] = ACTIONS(163),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(163),
    [anon_sym_BSLASHincludesvg] = ACTIONS(163),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(163),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(163),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(163),
    [anon_sym_BSLASHimport] = ACTIONS(163),
    [anon_sym_BSLASHsubimport] = ACTIONS(163),
    [anon_sym_BSLASHinputfrom] = ACTIONS(163),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(163),
    [anon_sym_BSLASHincludefrom] = ACTIONS(163),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(163),
    [anon_sym_BSLASHcaption] = ACTIONS(163),
    [anon_sym_BSLASHcite] = ACTIONS(163),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(165),
    [anon_sym_BSLASHCite] = ACTIONS(163),
    [anon_sym_BSLASHnocite] = ACTIONS(163),
    [anon_sym_BSLASHcitet] = ACTIONS(163),
    [anon_sym_BSLASHcitep] = ACTIONS(163),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(165),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(165),
    [anon_sym_BSLASHciteA] = ACTIONS(163),
    [anon_sym_BSLASHciteR] = ACTIONS(163),
    [anon_sym_BSLASHciteS] = ACTIONS(163),
    [anon_sym_BSLASHciteyearR] = ACTIONS(163),
    [anon_sym_BSLASHciteauthor] = ACTIONS(163),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(165),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(163),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(165),
    [anon_sym_BSLASHcitetitle] = ACTIONS(163),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(165),
    [anon_sym_BSLASHciteyear] = ACTIONS(163),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(165),
    [anon_sym_BSLASHcitedate] = ACTIONS(163),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(165),
    [anon_sym_BSLASHciteurl] = ACTIONS(163),
    [anon_sym_BSLASHfullcite] = ACTIONS(163),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(163),
    [anon_sym_BSLASHcitealt] = ACTIONS(163),
    [anon_sym_BSLASHcitealp] = ACTIONS(163),
    [anon_sym_BSLASHcitetext] = ACTIONS(163),
    [anon_sym_BSLASHparencite] = ACTIONS(163),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(165),
    [anon_sym_BSLASHParencite] = ACTIONS(163),
    [anon_sym_BSLASHfootcite] = ACTIONS(163),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(163),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(163),
    [anon_sym_BSLASHtextcite] = ACTIONS(163),
    [anon_sym_BSLASHTextcite] = ACTIONS(163),
    [anon_sym_BSLASHsmartcite] = ACTIONS(163),
    [anon_sym_BSLASHSmartcite] = ACTIONS(163),
    [anon_sym_BSLASHsupercite] = ACTIONS(163),
    [anon_sym_BSLASHautocite] = ACTIONS(163),
    [anon_sym_BSLASHAutocite] = ACTIONS(163),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(165),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(165),
    [anon_sym_BSLASHvolcite] = ACTIONS(163),
    [anon_sym_BSLASHVolcite] = ACTIONS(163),
    [anon_sym_BSLASHpvolcite] = ACTIONS(163),
    [anon_sym_BSLASHPvolcite] = ACTIONS(163),
    [anon_sym_BSLASHfvolcite] = ACTIONS(163),
    [anon_sym_BSLASHftvolcite] = ACTIONS(163),
    [anon_sym_BSLASHsvolcite] = ACTIONS(163),
    [anon_sym_BSLASHSvolcite] = ACTIONS(163),
    [anon_sym_BSLASHtvolcite] = ACTIONS(163),
    [anon_sym_BSLASHTvolcite] = ACTIONS(163),
    [anon_sym_BSLASHavolcite] = ACTIONS(163),
    [anon_sym_BSLASHAvolcite] = ACTIONS(163),
    [anon_sym_BSLASHnotecite] = ACTIONS(163),
    [anon_sym_BSLASHNotecite] = ACTIONS(163),
    [anon_sym_BSLASHpnotecite] = ACTIONS(163),
    [anon_sym_BSLASHPnotecite] = ACTIONS(163),
    [anon_sym_BSLASHfnotecite] = ACTIONS(163),
    [anon_sym_BSLASHlabel] = ACTIONS(163),
    [anon_sym_BSLASHref] = ACTIONS(163),
    [anon_sym_BSLASHeqref] = ACTIONS(163),
    [anon_sym_BSLASHvref] = ACTIONS(163),
    [anon_sym_BSLASHVref] = ACTIONS(163),
    [anon_sym_BSLASHautoref] = ACTIONS(163),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(165),
    [anon_sym_BSLASHpageref] = ACTIONS(163),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(165),
    [anon_sym_BSLASHautopageref] = ACTIONS(163),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(165),
    [anon_sym_BSLASHcref] = ACTIONS(163),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(165),
    [anon_sym_BSLASHCref] = ACTIONS(163),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(165),
    [anon_sym_BSLASHcpageref] = ACTIONS(163),
    [anon_sym_BSLASHCpageref] = ACTIONS(163),
    [anon_sym_BSLASHnamecref] = ACTIONS(163),
    [anon_sym_BSLASHnameCref] = ACTIONS(163),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(163),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(163),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(163),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(163),
    [anon_sym_BSLASHlabelcref] = ACTIONS(163),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(165),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(163),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(165),
    [anon_sym_BSLASHcrefrange] = ACTIONS(163),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(165),
    [anon_sym_BSLASHCrefrange] = ACTIONS(163),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(165),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(163),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(163),
    [anon_sym_BSLASHnewlabel] = ACTIONS(163),
    [anon_sym_BSLASHnewcommand] = ACTIONS(163),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(165),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(163),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(165),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(163),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(165),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(163),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(165),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(163),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(165),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(163),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(163),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(163),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(163),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(163),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(163),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(163),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(163),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(163),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(163),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(163),
    [anon_sym_BSLASHdef] = ACTIONS(163),
    [anon_sym_BSLASHgdef] = ACTIONS(163),
    [anon_sym_BSLASHedef] = ACTIONS(163),
    [anon_sym_BSLASHxdef] = ACTIONS(163),
    [anon_sym_BSLASHlet] = ACTIONS(163),
    [anon_sym_BSLASHglet] = ACTIONS(163),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(163),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(163),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(163),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(163),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(163),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(163),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(163),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(163),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(163),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(163),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(163),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(163),
    [anon_sym_BSLASHgls] = ACTIONS(163),
    [anon_sym_BSLASHGls] = ACTIONS(163),
    [anon_sym_BSLASHGLS] = ACTIONS(163),
    [anon_sym_BSLASHglspl] = ACTIONS(163),
    [anon_sym_BSLASHGlspl] = ACTIONS(163),
    [anon_sym_BSLASHGLSpl] = ACTIONS(163),
    [anon_sym_BSLASHglsdisp] = ACTIONS(163),
    [anon_sym_BSLASHglslink] = ACTIONS(163),
    [anon_sym_BSLASHglstext] = ACTIONS(163),
    [anon_sym_BSLASHGlstext] = ACTIONS(163),
    [anon_sym_BSLASHGLStext] = ACTIONS(163),
    [anon_sym_BSLASHglsfirst] = ACTIONS(163),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(163),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(163),
    [anon_sym_BSLASHglsplural] = ACTIONS(163),
    [anon_sym_BSLASHGlsplural] = ACTIONS(163),
    [anon_sym_BSLASHGLSplural] = ACTIONS(163),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(163),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(163),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(163),
    [anon_sym_BSLASHglsname] = ACTIONS(163),
    [anon_sym_BSLASHGlsname] = ACTIONS(163),
    [anon_sym_BSLASHGLSname] = ACTIONS(163),
    [anon_sym_BSLASHglssymbol] = ACTIONS(163),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(163),
    [anon_sym_BSLASHglsdesc] = ACTIONS(163),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(163),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(163),
    [anon_sym_BSLASHglsuseri] = ACTIONS(163),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(163),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(163),
    [anon_sym_BSLASHglsuserii] = ACTIONS(163),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(163),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(163),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(163),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(163),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(163),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(163),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(163),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(163),
    [anon_sym_BSLASHglsuserv] = ACTIONS(163),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(163),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(163),
    [anon_sym_BSLASHglsuservi] = ACTIONS(163),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(163),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(163),
    [anon_sym_BSLASHnewacronym] = ACTIONS(163),
    [anon_sym_BSLASHacrshort] = ACTIONS(163),
    [anon_sym_BSLASHAcrshort] = ACTIONS(163),
    [anon_sym_BSLASHACRshort] = ACTIONS(163),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(163),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(163),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(163),
    [anon_sym_BSLASHacrlong] = ACTIONS(163),
    [anon_sym_BSLASHAcrlong] = ACTIONS(163),
    [anon_sym_BSLASHACRlong] = ACTIONS(163),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(163),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(163),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(163),
    [anon_sym_BSLASHacrfull] = ACTIONS(163),
    [anon_sym_BSLASHAcrfull] = ACTIONS(163),
    [anon_sym_BSLASHACRfull] = ACTIONS(163),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(163),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(163),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(163),
    [anon_sym_BSLASHacs] = ACTIONS(163),
    [anon_sym_BSLASHAcs] = ACTIONS(163),
    [anon_sym_BSLASHacsp] = ACTIONS(163),
    [anon_sym_BSLASHAcsp] = ACTIONS(163),
    [anon_sym_BSLASHacl] = ACTIONS(163),
    [anon_sym_BSLASHAcl] = ACTIONS(163),
    [anon_sym_BSLASHaclp] = ACTIONS(163),
    [anon_sym_BSLASHAclp] = ACTIONS(163),
    [anon_sym_BSLASHacf] = ACTIONS(163),
    [anon_sym_BSLASHAcf] = ACTIONS(163),
    [anon_sym_BSLASHacfp] = ACTIONS(163),
    [anon_sym_BSLASHAcfp] = ACTIONS(163),
    [anon_sym_BSLASHac] = ACTIONS(163),
    [anon_sym_BSLASHAc] = ACTIONS(163),
    [anon_sym_BSLASHacp] = ACTIONS(163),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(163),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(163),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(163),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(163),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(163),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(163),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(163),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(163),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(163),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(163),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(163),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(165),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(163),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(165),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(163),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(163),
    [anon_sym_BSLASHcolor] = ACTIONS(163),
    [anon_sym_BSLASHpagecolor] = ACTIONS(163),
    [anon_sym_BSLASHtextcolor] = ACTIONS(163),
    [anon_sym_BSLASHmathcolor] = ACTIONS(163),
    [anon_sym_BSLASHcolorbox] = ACTIONS(163),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(163),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(163),
    [anon_sym_BSLASHurl] = ACTIONS(163),
    [anon_sym_BSLASHhref] = ACTIONS(163),
  },
  [4] = {
    [sym_block_comment] = STATE(97),
    [sym__root_content] = STATE(97),
    [sym__flat_content] = STATE(97),
    [sym__text_with_env_content] = STATE(97),
    [sym__text_content] = STATE(97),
    [sym__section] = STATE(97),
    [sym__paragraph] = STATE(97),
    [sym__part_declaration] = STATE(166),
    [sym_part] = STATE(895),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(896),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(897),
    [sym__subsection_declaration] = STATE(197),
    [sym_subsection] = STATE(898),
    [sym__subsubsection_declaration] = STATE(200),
    [sym_subsubsection] = STATE(899),
    [sym__paragraph_declaration] = STATE(217),
    [sym_paragraph] = STATE(900),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(901),
    [sym__enum_itemdeclaration] = STATE(237),
    [sym_enum_item] = STATE(902),
    [sym_curly_group] = STATE(97),
    [sym_text] = STATE(97),
    [sym_operator] = STATE(1465),
    [sym_subscript] = STATE(1465),
    [sym_superscript] = STATE(1465),
    [sym__math_content] = STATE(97),
    [sym_displayed_equation] = STATE(97),
    [sym_inline_formula] = STATE(97),
    [sym_math_delimiter] = STATE(97),
    [sym_text_mode] = STATE(97),
    [sym_begin] = STATE(43),
    [sym_generic_environment] = STATE(97),
    [sym_comment_environment] = STATE(97),
    [sym__comment_environment_begin] = STATE(3816),
    [sym_verbatim_environment] = STATE(97),
    [sym__verbatim_environment_begin] = STATE(3822),
    [sym_listing_environment] = STATE(97),
    [sym__listing_environment_begin] = STATE(3825),
    [sym_minted_environment] = STATE(97),
    [sym__minted_environment_begin] = STATE(3826),
    [sym_asy_environment] = STATE(97),
    [sym__asy_environment_begin] = STATE(3828),
    [sym_asydef_environment] = STATE(97),
    [sym__asydef_environment_begin] = STATE(3829),
    [sym_pycode_environment] = STATE(97),
    [sym__pycode_environment_begin] = STATE(3830),
    [sym_luacode_environment] = STATE(97),
    [sym__luacode_environment] = STATE(1476),
    [sym___luacode_environment_begin] = STATE(3831),
    [sym__luacode_environment_star] = STATE(1477),
    [sym___luacode_environment_star_begin] = STATE(3832),
    [sym_sagesilent_environment] = STATE(97),
    [sym__sagesilent_environment_begin] = STATE(3833),
    [sym_sageblock_environment] = STATE(97),
    [sym__sageblock_environment_begin] = STATE(3834),
    [sym_math_environment] = STATE(97),
    [sym__math_environment_begin] = STATE(249),
    [sym__command] = STATE(97),
    [sym_generic_command] = STATE(97),
    [sym_title_declaration] = STATE(97),
    [sym_author_declaration] = STATE(97),
    [sym_package_include] = STATE(97),
    [sym_class_include] = STATE(97),
    [sym_latex_include] = STATE(97),
    [sym_biblatex_include] = STATE(97),
    [sym_bibstyle_include] = STATE(97),
    [sym_bibtex_include] = STATE(97),
    [sym_graphics_include] = STATE(97),
    [sym_svg_include] = STATE(97),
    [sym_inkscape_include] = STATE(97),
    [sym_verbatim_include] = STATE(97),
    [sym_import_include] = STATE(97),
    [sym_caption] = STATE(97),
    [sym_citation] = STATE(97),
    [sym_label_definition] = STATE(97),
    [sym_label_reference] = STATE(97),
    [sym_label_reference_range] = STATE(97),
    [sym_label_number] = STATE(97),
    [sym_new_command_definition] = STATE(97),
    [sym__new_command_definition] = STATE(1478),
    [sym__newer_command_definition] = STATE(1479),
    [sym__new_command_copy] = STATE(1480),
    [sym_old_command_definition] = STATE(97),
    [sym_let_command_definition] = STATE(97),
    [sym_paired_delimiter_definition] = STATE(97),
    [sym_environment_definition] = STATE(97),
    [sym__environment_definition] = STATE(1481),
    [sym__newer_environment_definition] = STATE(1482),
    [sym__new_environment_copy] = STATE(1483),
    [sym_glossary_entry_definition] = STATE(97),
    [sym_glossary_entry_reference] = STATE(97),
    [sym_acronym_definition] = STATE(97),
    [sym_acronym_reference] = STATE(97),
    [sym_theorem_definition] = STATE(97),
    [sym_color_definition] = STATE(97),
    [sym_color_set_definition] = STATE(97),
    [sym_color_reference] = STATE(97),
    [sym_tikz_library_import] = STATE(97),
    [sym_hyperlink] = STATE(97),
    [aux_sym_source_file_repeat1] = STATE(97),
    [aux_sym__section_repeat1] = STATE(895),
    [aux_sym__section_repeat2] = STATE(896),
    [aux_sym__section_repeat3] = STATE(897),
    [aux_sym__section_repeat4] = STATE(898),
    [aux_sym__section_repeat5] = STATE(899),
    [aux_sym__paragraph_repeat1] = STATE(900),
    [aux_sym__paragraph_repeat2] = STATE(901),
    [aux_sym__paragraph_repeat3] = STATE(902),
    [aux_sym_text_repeat1] = STATE(273),
    [sym_command_name] = ACTIONS(169),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(169),
    [anon_sym_LBRACK] = ACTIONS(171),
    [anon_sym_RBRACK] = ACTIONS(171),
    [anon_sym_COMMA] = ACTIONS(171),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(171),
    [anon_sym_RPAREN] = ACTIONS(171),
    [anon_sym_BSLASHpart] = ACTIONS(169),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(171),
    [anon_sym_BSLASHaddpart] = ACTIONS(169),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(171),
    [anon_sym_BSLASHchapter] = ACTIONS(169),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(171),
    [anon_sym_BSLASHaddchap] = ACTIONS(169),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(171),
    [anon_sym_BSLASHsection] = ACTIONS(169),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(171),
    [anon_sym_BSLASHaddsec] = ACTIONS(169),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(171),
    [anon_sym_BSLASHsubsection] = ACTIONS(169),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(171),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(169),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(171),
    [anon_sym_BSLASHparagraph] = ACTIONS(169),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(171),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(169),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(171),
    [anon_sym_BSLASHitem] = ACTIONS(169),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(171),
    [anon_sym_LBRACE] = ACTIONS(171),
    [sym_word] = ACTIONS(169),
    [sym_placeholder] = ACTIONS(171),
    [sym_delimiter] = ACTIONS(171),
    [anon_sym_PLUS] = ACTIONS(171),
    [anon_sym_DASH] = ACTIONS(171),
    [anon_sym_STAR] = ACTIONS(171),
    [anon_sym_SLASH] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(169),
    [anon_sym_GT] = ACTIONS(169),
    [anon_sym_BANG] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(169),
    [anon_sym_COLON] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [anon_sym__] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(171),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(171),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(171),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(169),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(171),
    [anon_sym_BSLASHleft] = ACTIONS(169),
    [anon_sym_BSLASHbigl] = ACTIONS(169),
    [anon_sym_BSLASHBigl] = ACTIONS(169),
    [anon_sym_BSLASHbiggl] = ACTIONS(169),
    [anon_sym_BSLASHBiggl] = ACTIONS(169),
    [anon_sym_BSLASHright] = ACTIONS(169),
    [anon_sym_BSLASHbigr] = ACTIONS(169),
    [anon_sym_BSLASHBigr] = ACTIONS(169),
    [anon_sym_BSLASHbiggr] = ACTIONS(169),
    [anon_sym_BSLASHBiggr] = ACTIONS(169),
    [anon_sym_BSLASHtext] = ACTIONS(169),
    [anon_sym_BSLASHintertext] = ACTIONS(169),
    [anon_sym_BSLASHshortintertext] = ACTIONS(169),
    [anon_sym_BSLASHbegin] = ACTIONS(169),
    [anon_sym_BSLASHtitle] = ACTIONS(169),
    [anon_sym_BSLASHauthor] = ACTIONS(169),
    [anon_sym_BSLASHusepackage] = ACTIONS(169),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(169),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(169),
    [anon_sym_BSLASHinclude] = ACTIONS(169),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(169),
    [anon_sym_BSLASHinput] = ACTIONS(169),
    [anon_sym_BSLASHsubfile] = ACTIONS(169),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(169),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(169),
    [anon_sym_BSLASHbibliography] = ACTIONS(169),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(169),
    [anon_sym_BSLASHincludesvg] = ACTIONS(169),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(169),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(169),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(169),
    [anon_sym_BSLASHimport] = ACTIONS(169),
    [anon_sym_BSLASHsubimport] = ACTIONS(169),
    [anon_sym_BSLASHinputfrom] = ACTIONS(169),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(169),
    [anon_sym_BSLASHincludefrom] = ACTIONS(169),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(169),
    [anon_sym_BSLASHcaption] = ACTIONS(169),
    [anon_sym_BSLASHcite] = ACTIONS(169),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(171),
    [anon_sym_BSLASHCite] = ACTIONS(169),
    [anon_sym_BSLASHnocite] = ACTIONS(169),
    [anon_sym_BSLASHcitet] = ACTIONS(169),
    [anon_sym_BSLASHcitep] = ACTIONS(169),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(171),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(171),
    [anon_sym_BSLASHciteA] = ACTIONS(169),
    [anon_sym_BSLASHciteR] = ACTIONS(169),
    [anon_sym_BSLASHciteS] = ACTIONS(169),
    [anon_sym_BSLASHciteyearR] = ACTIONS(169),
    [anon_sym_BSLASHciteauthor] = ACTIONS(169),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(171),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(169),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(171),
    [anon_sym_BSLASHcitetitle] = ACTIONS(169),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(171),
    [anon_sym_BSLASHciteyear] = ACTIONS(169),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(171),
    [anon_sym_BSLASHcitedate] = ACTIONS(169),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(171),
    [anon_sym_BSLASHciteurl] = ACTIONS(169),
    [anon_sym_BSLASHfullcite] = ACTIONS(169),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(169),
    [anon_sym_BSLASHcitealt] = ACTIONS(169),
    [anon_sym_BSLASHcitealp] = ACTIONS(169),
    [anon_sym_BSLASHcitetext] = ACTIONS(169),
    [anon_sym_BSLASHparencite] = ACTIONS(169),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(171),
    [anon_sym_BSLASHParencite] = ACTIONS(169),
    [anon_sym_BSLASHfootcite] = ACTIONS(169),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(169),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(169),
    [anon_sym_BSLASHtextcite] = ACTIONS(169),
    [anon_sym_BSLASHTextcite] = ACTIONS(169),
    [anon_sym_BSLASHsmartcite] = ACTIONS(169),
    [anon_sym_BSLASHSmartcite] = ACTIONS(169),
    [anon_sym_BSLASHsupercite] = ACTIONS(169),
    [anon_sym_BSLASHautocite] = ACTIONS(169),
    [anon_sym_BSLASHAutocite] = ACTIONS(169),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(171),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(171),
    [anon_sym_BSLASHvolcite] = ACTIONS(169),
    [anon_sym_BSLASHVolcite] = ACTIONS(169),
    [anon_sym_BSLASHpvolcite] = ACTIONS(169),
    [anon_sym_BSLASHPvolcite] = ACTIONS(169),
    [anon_sym_BSLASHfvolcite] = ACTIONS(169),
    [anon_sym_BSLASHftvolcite] = ACTIONS(169),
    [anon_sym_BSLASHsvolcite] = ACTIONS(169),
    [anon_sym_BSLASHSvolcite] = ACTIONS(169),
    [anon_sym_BSLASHtvolcite] = ACTIONS(169),
    [anon_sym_BSLASHTvolcite] = ACTIONS(169),
    [anon_sym_BSLASHavolcite] = ACTIONS(169),
    [anon_sym_BSLASHAvolcite] = ACTIONS(169),
    [anon_sym_BSLASHnotecite] = ACTIONS(169),
    [anon_sym_BSLASHNotecite] = ACTIONS(169),
    [anon_sym_BSLASHpnotecite] = ACTIONS(169),
    [anon_sym_BSLASHPnotecite] = ACTIONS(169),
    [anon_sym_BSLASHfnotecite] = ACTIONS(169),
    [anon_sym_BSLASHlabel] = ACTIONS(169),
    [anon_sym_BSLASHref] = ACTIONS(169),
    [anon_sym_BSLASHeqref] = ACTIONS(169),
    [anon_sym_BSLASHvref] = ACTIONS(169),
    [anon_sym_BSLASHVref] = ACTIONS(169),
    [anon_sym_BSLASHautoref] = ACTIONS(169),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(171),
    [anon_sym_BSLASHpageref] = ACTIONS(169),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(171),
    [anon_sym_BSLASHautopageref] = ACTIONS(169),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(171),
    [anon_sym_BSLASHcref] = ACTIONS(169),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(171),
    [anon_sym_BSLASHCref] = ACTIONS(169),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(171),
    [anon_sym_BSLASHcpageref] = ACTIONS(169),
    [anon_sym_BSLASHCpageref] = ACTIONS(169),
    [anon_sym_BSLASHnamecref] = ACTIONS(169),
    [anon_sym_BSLASHnameCref] = ACTIONS(169),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(169),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(169),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(169),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(169),
    [anon_sym_BSLASHlabelcref] = ACTIONS(169),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(171),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(169),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(171),
    [anon_sym_BSLASHcrefrange] = ACTIONS(169),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(171),
    [anon_sym_BSLASHCrefrange] = ACTIONS(169),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(171),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(169),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(169),
    [anon_sym_BSLASHnewlabel] = ACTIONS(169),
    [anon_sym_BSLASHnewcommand] = ACTIONS(169),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(171),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(169),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(171),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(169),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(171),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(169),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(171),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(169),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(171),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(169),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(169),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(169),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(169),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(169),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(169),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(169),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(169),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(169),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(169),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(169),
    [anon_sym_BSLASHdef] = ACTIONS(169),
    [anon_sym_BSLASHgdef] = ACTIONS(169),
    [anon_sym_BSLASHedef] = ACTIONS(169),
    [anon_sym_BSLASHxdef] = ACTIONS(169),
    [anon_sym_BSLASHlet] = ACTIONS(169),
    [anon_sym_BSLASHglet] = ACTIONS(169),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(169),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(169),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(169),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(169),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(169),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(169),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(169),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(169),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(169),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(169),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(169),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(169),
    [anon_sym_BSLASHgls] = ACTIONS(169),
    [anon_sym_BSLASHGls] = ACTIONS(169),
    [anon_sym_BSLASHGLS] = ACTIONS(169),
    [anon_sym_BSLASHglspl] = ACTIONS(169),
    [anon_sym_BSLASHGlspl] = ACTIONS(169),
    [anon_sym_BSLASHGLSpl] = ACTIONS(169),
    [anon_sym_BSLASHglsdisp] = ACTIONS(169),
    [anon_sym_BSLASHglslink] = ACTIONS(169),
    [anon_sym_BSLASHglstext] = ACTIONS(169),
    [anon_sym_BSLASHGlstext] = ACTIONS(169),
    [anon_sym_BSLASHGLStext] = ACTIONS(169),
    [anon_sym_BSLASHglsfirst] = ACTIONS(169),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(169),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(169),
    [anon_sym_BSLASHglsplural] = ACTIONS(169),
    [anon_sym_BSLASHGlsplural] = ACTIONS(169),
    [anon_sym_BSLASHGLSplural] = ACTIONS(169),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(169),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(169),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(169),
    [anon_sym_BSLASHglsname] = ACTIONS(169),
    [anon_sym_BSLASHGlsname] = ACTIONS(169),
    [anon_sym_BSLASHGLSname] = ACTIONS(169),
    [anon_sym_BSLASHglssymbol] = ACTIONS(169),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(169),
    [anon_sym_BSLASHglsdesc] = ACTIONS(169),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(169),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(169),
    [anon_sym_BSLASHglsuseri] = ACTIONS(169),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(169),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(169),
    [anon_sym_BSLASHglsuserii] = ACTIONS(169),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(169),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(169),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(169),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(169),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(169),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(169),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(169),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(169),
    [anon_sym_BSLASHglsuserv] = ACTIONS(169),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(169),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(169),
    [anon_sym_BSLASHglsuservi] = ACTIONS(169),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(169),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(169),
    [anon_sym_BSLASHnewacronym] = ACTIONS(169),
    [anon_sym_BSLASHacrshort] = ACTIONS(169),
    [anon_sym_BSLASHAcrshort] = ACTIONS(169),
    [anon_sym_BSLASHACRshort] = ACTIONS(169),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(169),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(169),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(169),
    [anon_sym_BSLASHacrlong] = ACTIONS(169),
    [anon_sym_BSLASHAcrlong] = ACTIONS(169),
    [anon_sym_BSLASHACRlong] = ACTIONS(169),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(169),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(169),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(169),
    [anon_sym_BSLASHacrfull] = ACTIONS(169),
    [anon_sym_BSLASHAcrfull] = ACTIONS(169),
    [anon_sym_BSLASHACRfull] = ACTIONS(169),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(169),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(169),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(169),
    [anon_sym_BSLASHacs] = ACTIONS(169),
    [anon_sym_BSLASHAcs] = ACTIONS(169),
    [anon_sym_BSLASHacsp] = ACTIONS(169),
    [anon_sym_BSLASHAcsp] = ACTIONS(169),
    [anon_sym_BSLASHacl] = ACTIONS(169),
    [anon_sym_BSLASHAcl] = ACTIONS(169),
    [anon_sym_BSLASHaclp] = ACTIONS(169),
    [anon_sym_BSLASHAclp] = ACTIONS(169),
    [anon_sym_BSLASHacf] = ACTIONS(169),
    [anon_sym_BSLASHAcf] = ACTIONS(169),
    [anon_sym_BSLASHacfp] = ACTIONS(169),
    [anon_sym_BSLASHAcfp] = ACTIONS(169),
    [anon_sym_BSLASHac] = ACTIONS(169),
    [anon_sym_BSLASHAc] = ACTIONS(169),
    [anon_sym_BSLASHacp] = ACTIONS(169),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(169),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(169),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(169),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(169),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(169),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(169),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(169),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(169),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(169),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(169),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(169),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(171),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(169),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(171),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(169),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(169),
    [anon_sym_BSLASHcolor] = ACTIONS(169),
    [anon_sym_BSLASHpagecolor] = ACTIONS(169),
    [anon_sym_BSLASHtextcolor] = ACTIONS(169),
    [anon_sym_BSLASHmathcolor] = ACTIONS(169),
    [anon_sym_BSLASHcolorbox] = ACTIONS(169),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(169),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(169),
    [anon_sym_BSLASHurl] = ACTIONS(169),
    [anon_sym_BSLASHhref] = ACTIONS(169),
  },
  [5] = {
    [sym_block_comment] = STATE(104),
    [sym__root_content] = STATE(104),
    [sym__flat_content] = STATE(104),
    [sym__text_with_env_content] = STATE(104),
    [sym__text_content] = STATE(104),
    [sym__section] = STATE(104),
    [sym__paragraph] = STATE(104),
    [sym__part_declaration] = STATE(165),
    [sym_part] = STATE(787),
    [sym__chapter_declaration] = STATE(172),
    [sym_chapter] = STATE(788),
    [sym__section_declaration] = STATE(185),
    [sym_section] = STATE(789),
    [sym__subsection_declaration] = STATE(194),
    [sym_subsection] = STATE(790),
    [sym__subsubsection_declaration] = STATE(204),
    [sym_subsubsection] = STATE(791),
    [sym__paragraph_declaration] = STATE(214),
    [sym_paragraph] = STATE(792),
    [sym__subparagraph_declaration] = STATE(224),
    [sym_subparagraph] = STATE(793),
    [sym__enum_itemdeclaration] = STATE(236),
    [sym_enum_item] = STATE(794),
    [sym_curly_group] = STATE(104),
    [sym_text] = STATE(104),
    [sym_operator] = STATE(1266),
    [sym_subscript] = STATE(1266),
    [sym_superscript] = STATE(1266),
    [sym__math_content] = STATE(104),
    [sym_displayed_equation] = STATE(104),
    [sym_inline_formula] = STATE(104),
    [sym_math_delimiter] = STATE(104),
    [sym_text_mode] = STATE(104),
    [sym_begin] = STATE(47),
    [sym_generic_environment] = STATE(104),
    [sym_comment_environment] = STATE(104),
    [sym__comment_environment_begin] = STATE(3888),
    [sym_verbatim_environment] = STATE(104),
    [sym__verbatim_environment_begin] = STATE(3890),
    [sym_listing_environment] = STATE(104),
    [sym__listing_environment_begin] = STATE(3891),
    [sym_minted_environment] = STATE(104),
    [sym__minted_environment_begin] = STATE(3892),
    [sym_asy_environment] = STATE(104),
    [sym__asy_environment_begin] = STATE(3893),
    [sym_asydef_environment] = STATE(104),
    [sym__asydef_environment_begin] = STATE(3895),
    [sym_pycode_environment] = STATE(104),
    [sym__pycode_environment_begin] = STATE(3896),
    [sym_luacode_environment] = STATE(104),
    [sym__luacode_environment] = STATE(1278),
    [sym___luacode_environment_begin] = STATE(3897),
    [sym__luacode_environment_star] = STATE(1282),
    [sym___luacode_environment_star_begin] = STATE(3898),
    [sym_sagesilent_environment] = STATE(104),
    [sym__sagesilent_environment_begin] = STATE(3899),
    [sym_sageblock_environment] = STATE(104),
    [sym__sageblock_environment_begin] = STATE(3900),
    [sym_math_environment] = STATE(104),
    [sym__math_environment_begin] = STATE(252),
    [sym__command] = STATE(104),
    [sym_generic_command] = STATE(104),
    [sym_title_declaration] = STATE(104),
    [sym_author_declaration] = STATE(104),
    [sym_package_include] = STATE(104),
    [sym_class_include] = STATE(104),
    [sym_latex_include] = STATE(104),
    [sym_biblatex_include] = STATE(104),
    [sym_bibstyle_include] = STATE(104),
    [sym_bibtex_include] = STATE(104),
    [sym_graphics_include] = STATE(104),
    [sym_svg_include] = STATE(104),
    [sym_inkscape_include] = STATE(104),
    [sym_verbatim_include] = STATE(104),
    [sym_import_include] = STATE(104),
    [sym_caption] = STATE(104),
    [sym_citation] = STATE(104),
    [sym_label_definition] = STATE(104),
    [sym_label_reference] = STATE(104),
    [sym_label_reference_range] = STATE(104),
    [sym_label_number] = STATE(104),
    [sym_new_command_definition] = STATE(104),
    [sym__new_command_definition] = STATE(1284),
    [sym__newer_command_definition] = STATE(1285),
    [sym__new_command_copy] = STATE(1347),
    [sym_old_command_definition] = STATE(104),
    [sym_let_command_definition] = STATE(104),
    [sym_paired_delimiter_definition] = STATE(104),
    [sym_environment_definition] = STATE(104),
    [sym__environment_definition] = STATE(1348),
    [sym__newer_environment_definition] = STATE(1349),
    [sym__new_environment_copy] = STATE(1350),
    [sym_glossary_entry_definition] = STATE(104),
    [sym_glossary_entry_reference] = STATE(104),
    [sym_acronym_definition] = STATE(104),
    [sym_acronym_reference] = STATE(104),
    [sym_theorem_definition] = STATE(104),
    [sym_color_definition] = STATE(104),
    [sym_color_set_definition] = STATE(104),
    [sym_color_reference] = STATE(104),
    [sym_tikz_library_import] = STATE(104),
    [sym_hyperlink] = STATE(104),
    [aux_sym_source_file_repeat1] = STATE(104),
    [aux_sym__section_repeat1] = STATE(787),
    [aux_sym__section_repeat2] = STATE(788),
    [aux_sym__section_repeat3] = STATE(789),
    [aux_sym__section_repeat4] = STATE(790),
    [aux_sym__section_repeat5] = STATE(791),
    [aux_sym__paragraph_repeat1] = STATE(792),
    [aux_sym__paragraph_repeat2] = STATE(793),
    [aux_sym__paragraph_repeat3] = STATE(794),
    [aux_sym_text_repeat1] = STATE(268),
    [sym_command_name] = ACTIONS(173),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(173),
    [anon_sym_LBRACK] = ACTIONS(175),
    [anon_sym_RBRACK] = ACTIONS(175),
    [anon_sym_COMMA] = ACTIONS(175),
    [anon_sym_EQ] = ACTIONS(175),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_RPAREN] = ACTIONS(175),
    [anon_sym_BSLASHpart] = ACTIONS(173),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(175),
    [anon_sym_BSLASHaddpart] = ACTIONS(173),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(175),
    [anon_sym_BSLASHchapter] = ACTIONS(173),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(175),
    [anon_sym_BSLASHaddchap] = ACTIONS(173),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(175),
    [anon_sym_BSLASHsection] = ACTIONS(173),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(175),
    [anon_sym_BSLASHaddsec] = ACTIONS(173),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(175),
    [anon_sym_BSLASHsubsection] = ACTIONS(173),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(175),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(173),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(175),
    [anon_sym_BSLASHparagraph] = ACTIONS(173),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(175),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(173),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(175),
    [anon_sym_BSLASHitem] = ACTIONS(173),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(175),
    [anon_sym_LBRACE] = ACTIONS(175),
    [sym_word] = ACTIONS(173),
    [sym_placeholder] = ACTIONS(175),
    [sym_delimiter] = ACTIONS(175),
    [anon_sym_PLUS] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(175),
    [anon_sym_SLASH] = ACTIONS(175),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_BANG] = ACTIONS(173),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_COLON] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [anon_sym__] = ACTIONS(175),
    [anon_sym_CARET] = ACTIONS(175),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(175),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(175),
    [anon_sym_DOLLAR] = ACTIONS(173),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(175),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(167),
    [anon_sym_BSLASHleft] = ACTIONS(173),
    [anon_sym_BSLASHbigl] = ACTIONS(173),
    [anon_sym_BSLASHBigl] = ACTIONS(173),
    [anon_sym_BSLASHbiggl] = ACTIONS(173),
    [anon_sym_BSLASHBiggl] = ACTIONS(173),
    [anon_sym_BSLASHright] = ACTIONS(173),
    [anon_sym_BSLASHbigr] = ACTIONS(173),
    [anon_sym_BSLASHBigr] = ACTIONS(173),
    [anon_sym_BSLASHbiggr] = ACTIONS(173),
    [anon_sym_BSLASHBiggr] = ACTIONS(173),
    [anon_sym_BSLASHtext] = ACTIONS(173),
    [anon_sym_BSLASHintertext] = ACTIONS(173),
    [anon_sym_BSLASHshortintertext] = ACTIONS(173),
    [anon_sym_BSLASHbegin] = ACTIONS(173),
    [anon_sym_BSLASHtitle] = ACTIONS(173),
    [anon_sym_BSLASHauthor] = ACTIONS(173),
    [anon_sym_BSLASHusepackage] = ACTIONS(173),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(173),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(173),
    [anon_sym_BSLASHinclude] = ACTIONS(173),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(173),
    [anon_sym_BSLASHinput] = ACTIONS(173),
    [anon_sym_BSLASHsubfile] = ACTIONS(173),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(173),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(173),
    [anon_sym_BSLASHbibliography] = ACTIONS(173),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(173),
    [anon_sym_BSLASHincludesvg] = ACTIONS(173),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(173),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(173),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(173),
    [anon_sym_BSLASHimport] = ACTIONS(173),
    [anon_sym_BSLASHsubimport] = ACTIONS(173),
    [anon_sym_BSLASHinputfrom] = ACTIONS(173),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(173),
    [anon_sym_BSLASHincludefrom] = ACTIONS(173),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(173),
    [anon_sym_BSLASHcaption] = ACTIONS(173),
    [anon_sym_BSLASHcite] = ACTIONS(173),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(175),
    [anon_sym_BSLASHCite] = ACTIONS(173),
    [anon_sym_BSLASHnocite] = ACTIONS(173),
    [anon_sym_BSLASHcitet] = ACTIONS(173),
    [anon_sym_BSLASHcitep] = ACTIONS(173),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(175),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(175),
    [anon_sym_BSLASHciteA] = ACTIONS(173),
    [anon_sym_BSLASHciteR] = ACTIONS(173),
    [anon_sym_BSLASHciteS] = ACTIONS(173),
    [anon_sym_BSLASHciteyearR] = ACTIONS(173),
    [anon_sym_BSLASHciteauthor] = ACTIONS(173),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(175),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(173),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(175),
    [anon_sym_BSLASHcitetitle] = ACTIONS(173),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(175),
    [anon_sym_BSLASHciteyear] = ACTIONS(173),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(175),
    [anon_sym_BSLASHcitedate] = ACTIONS(173),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(175),
    [anon_sym_BSLASHciteurl] = ACTIONS(173),
    [anon_sym_BSLASHfullcite] = ACTIONS(173),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(173),
    [anon_sym_BSLASHcitealt] = ACTIONS(173),
    [anon_sym_BSLASHcitealp] = ACTIONS(173),
    [anon_sym_BSLASHcitetext] = ACTIONS(173),
    [anon_sym_BSLASHparencite] = ACTIONS(173),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(175),
    [anon_sym_BSLASHParencite] = ACTIONS(173),
    [anon_sym_BSLASHfootcite] = ACTIONS(173),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(173),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(173),
    [anon_sym_BSLASHtextcite] = ACTIONS(173),
    [anon_sym_BSLASHTextcite] = ACTIONS(173),
    [anon_sym_BSLASHsmartcite] = ACTIONS(173),
    [anon_sym_BSLASHSmartcite] = ACTIONS(173),
    [anon_sym_BSLASHsupercite] = ACTIONS(173),
    [anon_sym_BSLASHautocite] = ACTIONS(173),
    [anon_sym_BSLASHAutocite] = ACTIONS(173),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(175),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(175),
    [anon_sym_BSLASHvolcite] = ACTIONS(173),
    [anon_sym_BSLASHVolcite] = ACTIONS(173),
    [anon_sym_BSLASHpvolcite] = ACTIONS(173),
    [anon_sym_BSLASHPvolcite] = ACTIONS(173),
    [anon_sym_BSLASHfvolcite] = ACTIONS(173),
    [anon_sym_BSLASHftvolcite] = ACTIONS(173),
    [anon_sym_BSLASHsvolcite] = ACTIONS(173),
    [anon_sym_BSLASHSvolcite] = ACTIONS(173),
    [anon_sym_BSLASHtvolcite] = ACTIONS(173),
    [anon_sym_BSLASHTvolcite] = ACTIONS(173),
    [anon_sym_BSLASHavolcite] = ACTIONS(173),
    [anon_sym_BSLASHAvolcite] = ACTIONS(173),
    [anon_sym_BSLASHnotecite] = ACTIONS(173),
    [anon_sym_BSLASHNotecite] = ACTIONS(173),
    [anon_sym_BSLASHpnotecite] = ACTIONS(173),
    [anon_sym_BSLASHPnotecite] = ACTIONS(173),
    [anon_sym_BSLASHfnotecite] = ACTIONS(173),
    [anon_sym_BSLASHlabel] = ACTIONS(173),
    [anon_sym_BSLASHref] = ACTIONS(173),
    [anon_sym_BSLASHeqref] = ACTIONS(173),
    [anon_sym_BSLASHvref] = ACTIONS(173),
    [anon_sym_BSLASHVref] = ACTIONS(173),
    [anon_sym_BSLASHautoref] = ACTIONS(173),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(175),
    [anon_sym_BSLASHpageref] = ACTIONS(173),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(175),
    [anon_sym_BSLASHautopageref] = ACTIONS(173),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(175),
    [anon_sym_BSLASHcref] = ACTIONS(173),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(175),
    [anon_sym_BSLASHCref] = ACTIONS(173),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(175),
    [anon_sym_BSLASHcpageref] = ACTIONS(173),
    [anon_sym_BSLASHCpageref] = ACTIONS(173),
    [anon_sym_BSLASHnamecref] = ACTIONS(173),
    [anon_sym_BSLASHnameCref] = ACTIONS(173),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(173),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(173),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(173),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(173),
    [anon_sym_BSLASHlabelcref] = ACTIONS(173),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(175),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(173),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(175),
    [anon_sym_BSLASHcrefrange] = ACTIONS(173),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(175),
    [anon_sym_BSLASHCrefrange] = ACTIONS(173),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(175),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(173),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(173),
    [anon_sym_BSLASHnewlabel] = ACTIONS(173),
    [anon_sym_BSLASHnewcommand] = ACTIONS(173),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(175),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(173),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(175),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(173),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(175),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(173),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(175),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(173),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(175),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(173),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(173),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(173),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(173),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(173),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(173),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(173),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(173),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(173),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(173),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(173),
    [anon_sym_BSLASHdef] = ACTIONS(173),
    [anon_sym_BSLASHgdef] = ACTIONS(173),
    [anon_sym_BSLASHedef] = ACTIONS(173),
    [anon_sym_BSLASHxdef] = ACTIONS(173),
    [anon_sym_BSLASHlet] = ACTIONS(173),
    [anon_sym_BSLASHglet] = ACTIONS(173),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(173),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(173),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(173),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(173),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(173),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(173),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(173),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(173),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(173),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(173),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(173),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(173),
    [anon_sym_BSLASHgls] = ACTIONS(173),
    [anon_sym_BSLASHGls] = ACTIONS(173),
    [anon_sym_BSLASHGLS] = ACTIONS(173),
    [anon_sym_BSLASHglspl] = ACTIONS(173),
    [anon_sym_BSLASHGlspl] = ACTIONS(173),
    [anon_sym_BSLASHGLSpl] = ACTIONS(173),
    [anon_sym_BSLASHglsdisp] = ACTIONS(173),
    [anon_sym_BSLASHglslink] = ACTIONS(173),
    [anon_sym_BSLASHglstext] = ACTIONS(173),
    [anon_sym_BSLASHGlstext] = ACTIONS(173),
    [anon_sym_BSLASHGLStext] = ACTIONS(173),
    [anon_sym_BSLASHglsfirst] = ACTIONS(173),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(173),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(173),
    [anon_sym_BSLASHglsplural] = ACTIONS(173),
    [anon_sym_BSLASHGlsplural] = ACTIONS(173),
    [anon_sym_BSLASHGLSplural] = ACTIONS(173),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(173),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(173),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(173),
    [anon_sym_BSLASHglsname] = ACTIONS(173),
    [anon_sym_BSLASHGlsname] = ACTIONS(173),
    [anon_sym_BSLASHGLSname] = ACTIONS(173),
    [anon_sym_BSLASHglssymbol] = ACTIONS(173),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(173),
    [anon_sym_BSLASHglsdesc] = ACTIONS(173),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(173),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(173),
    [anon_sym_BSLASHglsuseri] = ACTIONS(173),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(173),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(173),
    [anon_sym_BSLASHglsuserii] = ACTIONS(173),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(173),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(173),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(173),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(173),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(173),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(173),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(173),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(173),
    [anon_sym_BSLASHglsuserv] = ACTIONS(173),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(173),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(173),
    [anon_sym_BSLASHglsuservi] = ACTIONS(173),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(173),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(173),
    [anon_sym_BSLASHnewacronym] = ACTIONS(173),
    [anon_sym_BSLASHacrshort] = ACTIONS(173),
    [anon_sym_BSLASHAcrshort] = ACTIONS(173),
    [anon_sym_BSLASHACRshort] = ACTIONS(173),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(173),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(173),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(173),
    [anon_sym_BSLASHacrlong] = ACTIONS(173),
    [anon_sym_BSLASHAcrlong] = ACTIONS(173),
    [anon_sym_BSLASHACRlong] = ACTIONS(173),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(173),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(173),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(173),
    [anon_sym_BSLASHacrfull] = ACTIONS(173),
    [anon_sym_BSLASHAcrfull] = ACTIONS(173),
    [anon_sym_BSLASHACRfull] = ACTIONS(173),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(173),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(173),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(173),
    [anon_sym_BSLASHacs] = ACTIONS(173),
    [anon_sym_BSLASHAcs] = ACTIONS(173),
    [anon_sym_BSLASHacsp] = ACTIONS(173),
    [anon_sym_BSLASHAcsp] = ACTIONS(173),
    [anon_sym_BSLASHacl] = ACTIONS(173),
    [anon_sym_BSLASHAcl] = ACTIONS(173),
    [anon_sym_BSLASHaclp] = ACTIONS(173),
    [anon_sym_BSLASHAclp] = ACTIONS(173),
    [anon_sym_BSLASHacf] = ACTIONS(173),
    [anon_sym_BSLASHAcf] = ACTIONS(173),
    [anon_sym_BSLASHacfp] = ACTIONS(173),
    [anon_sym_BSLASHAcfp] = ACTIONS(173),
    [anon_sym_BSLASHac] = ACTIONS(173),
    [anon_sym_BSLASHAc] = ACTIONS(173),
    [anon_sym_BSLASHacp] = ACTIONS(173),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(173),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(173),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(173),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(173),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(173),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(173),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(173),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(173),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(173),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(173),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(173),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(175),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(173),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(175),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(173),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(173),
    [anon_sym_BSLASHcolor] = ACTIONS(173),
    [anon_sym_BSLASHpagecolor] = ACTIONS(173),
    [anon_sym_BSLASHtextcolor] = ACTIONS(173),
    [anon_sym_BSLASHmathcolor] = ACTIONS(173),
    [anon_sym_BSLASHcolorbox] = ACTIONS(173),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(173),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(173),
    [anon_sym_BSLASHurl] = ACTIONS(173),
    [anon_sym_BSLASHhref] = ACTIONS(173),
  },
  [6] = {
    [sym_block_comment] = STATE(9),
    [sym__root_content] = STATE(9),
    [sym__flat_content] = STATE(9),
    [sym__text_with_env_content] = STATE(9),
    [sym__text_content] = STATE(9),
    [sym__section] = STATE(9),
    [sym__paragraph] = STATE(9),
    [sym__part_declaration] = STATE(157),
    [sym_part] = STATE(444),
    [sym__chapter_declaration] = STATE(158),
    [sym_chapter] = STATE(369),
    [sym__section_declaration] = STATE(168),
    [sym_section] = STATE(370),
    [sym__subsection_declaration] = STATE(180),
    [sym_subsection] = STATE(371),
    [sym__subsubsection_declaration] = STATE(189),
    [sym_subsubsection] = STATE(372),
    [sym__paragraph_declaration] = STATE(207),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(209),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(218),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(9),
    [sym_text] = STATE(9),
    [sym_operator] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_superscript] = STATE(625),
    [sym__math_content] = STATE(9),
    [sym_displayed_equation] = STATE(9),
    [sym_inline_formula] = STATE(9),
    [sym_math_delimiter] = STATE(9),
    [sym_text_mode] = STATE(9),
    [sym_begin] = STATE(55),
    [sym_generic_environment] = STATE(9),
    [sym_comment_environment] = STATE(9),
    [sym__comment_environment_begin] = STATE(3767),
    [sym_verbatim_environment] = STATE(9),
    [sym__verbatim_environment_begin] = STATE(3768),
    [sym_listing_environment] = STATE(9),
    [sym__listing_environment_begin] = STATE(3769),
    [sym_minted_environment] = STATE(9),
    [sym__minted_environment_begin] = STATE(3770),
    [sym_asy_environment] = STATE(9),
    [sym__asy_environment_begin] = STATE(3771),
    [sym_asydef_environment] = STATE(9),
    [sym__asydef_environment_begin] = STATE(3772),
    [sym_pycode_environment] = STATE(9),
    [sym__pycode_environment_begin] = STATE(3773),
    [sym_luacode_environment] = STATE(9),
    [sym__luacode_environment] = STATE(584),
    [sym___luacode_environment_begin] = STATE(3774),
    [sym__luacode_environment_star] = STATE(585),
    [sym___luacode_environment_star_begin] = STATE(3775),
    [sym_sagesilent_environment] = STATE(9),
    [sym__sagesilent_environment_begin] = STATE(3776),
    [sym_sageblock_environment] = STATE(9),
    [sym__sageblock_environment_begin] = STATE(3777),
    [sym_math_environment] = STATE(9),
    [sym__math_environment_begin] = STATE(250),
    [sym__command] = STATE(9),
    [sym_generic_command] = STATE(9),
    [sym_title_declaration] = STATE(9),
    [sym_author_declaration] = STATE(9),
    [sym_package_include] = STATE(9),
    [sym_class_include] = STATE(9),
    [sym_latex_include] = STATE(9),
    [sym_biblatex_include] = STATE(9),
    [sym_bibstyle_include] = STATE(9),
    [sym_bibtex_include] = STATE(9),
    [sym_graphics_include] = STATE(9),
    [sym_svg_include] = STATE(9),
    [sym_inkscape_include] = STATE(9),
    [sym_verbatim_include] = STATE(9),
    [sym_import_include] = STATE(9),
    [sym_caption] = STATE(9),
    [sym_citation] = STATE(9),
    [sym_label_definition] = STATE(9),
    [sym_label_reference] = STATE(9),
    [sym_label_reference_range] = STATE(9),
    [sym_label_number] = STATE(9),
    [sym_new_command_definition] = STATE(9),
    [sym__new_command_definition] = STATE(627),
    [sym__newer_command_definition] = STATE(628),
    [sym__new_command_copy] = STATE(629),
    [sym_old_command_definition] = STATE(9),
    [sym_let_command_definition] = STATE(9),
    [sym_paired_delimiter_definition] = STATE(9),
    [sym_environment_definition] = STATE(9),
    [sym__environment_definition] = STATE(630),
    [sym__newer_environment_definition] = STATE(631),
    [sym__new_environment_copy] = STATE(632),
    [sym_glossary_entry_definition] = STATE(9),
    [sym_glossary_entry_reference] = STATE(9),
    [sym_acronym_definition] = STATE(9),
    [sym_acronym_reference] = STATE(9),
    [sym_theorem_definition] = STATE(9),
    [sym_color_definition] = STATE(9),
    [sym_color_set_definition] = STATE(9),
    [sym_color_reference] = STATE(9),
    [sym_tikz_library_import] = STATE(9),
    [sym_hyperlink] = STATE(9),
    [aux_sym_source_file_repeat1] = STATE(9),
    [aux_sym__section_repeat1] = STATE(444),
    [aux_sym__section_repeat2] = STATE(369),
    [aux_sym__section_repeat3] = STATE(370),
    [aux_sym__section_repeat4] = STATE(371),
    [aux_sym__section_repeat5] = STATE(372),
    [aux_sym__paragraph_repeat1] = STATE(373),
    [aux_sym__paragraph_repeat2] = STATE(374),
    [aux_sym__paragraph_repeat3] = STATE(375),
    [aux_sym_text_repeat1] = STATE(265),
    [sym_command_name] = ACTIONS(177),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_RBRACK] = ACTIONS(181),
    [anon_sym_COMMA] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(181),
    [anon_sym_LPAREN] = ACTIONS(181),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_BSLASHpart] = ACTIONS(183),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddpart] = ACTIONS(183),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHchapter] = ACTIONS(187),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(189),
    [anon_sym_BSLASHaddchap] = ACTIONS(187),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(189),
    [anon_sym_BSLASHsection] = ACTIONS(191),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(193),
    [anon_sym_BSLASHaddsec] = ACTIONS(191),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(193),
    [anon_sym_BSLASHsubsection] = ACTIONS(195),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(197),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(199),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(201),
    [anon_sym_BSLASHparagraph] = ACTIONS(203),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(205),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(207),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(209),
    [anon_sym_BSLASHitem] = ACTIONS(211),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(213),
    [anon_sym_LBRACE] = ACTIONS(215),
    [sym_word] = ACTIONS(217),
    [sym_placeholder] = ACTIONS(219),
    [sym_delimiter] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_STAR] = ACTIONS(221),
    [anon_sym_SLASH] = ACTIONS(221),
    [anon_sym_LT] = ACTIONS(223),
    [anon_sym_GT] = ACTIONS(223),
    [anon_sym_BANG] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_COLON] = ACTIONS(223),
    [anon_sym_SQUOTE] = ACTIONS(223),
    [anon_sym__] = ACTIONS(225),
    [anon_sym_CARET] = ACTIONS(227),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(229),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(233),
    [anon_sym_BSLASHleft] = ACTIONS(235),
    [anon_sym_BSLASHbigl] = ACTIONS(235),
    [anon_sym_BSLASHBigl] = ACTIONS(235),
    [anon_sym_BSLASHbiggl] = ACTIONS(235),
    [anon_sym_BSLASHBiggl] = ACTIONS(235),
    [anon_sym_BSLASHright] = ACTIONS(237),
    [anon_sym_BSLASHbigr] = ACTIONS(237),
    [anon_sym_BSLASHBigr] = ACTIONS(237),
    [anon_sym_BSLASHbiggr] = ACTIONS(237),
    [anon_sym_BSLASHBiggr] = ACTIONS(237),
    [anon_sym_BSLASHtext] = ACTIONS(239),
    [anon_sym_BSLASHintertext] = ACTIONS(239),
    [anon_sym_BSLASHshortintertext] = ACTIONS(239),
    [anon_sym_BSLASHbegin] = ACTIONS(69),
    [anon_sym_BSLASHtitle] = ACTIONS(241),
    [anon_sym_BSLASHauthor] = ACTIONS(243),
    [anon_sym_BSLASHusepackage] = ACTIONS(245),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(245),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(247),
    [anon_sym_BSLASHinclude] = ACTIONS(249),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(249),
    [anon_sym_BSLASHinput] = ACTIONS(249),
    [anon_sym_BSLASHsubfile] = ACTIONS(249),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(251),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(253),
    [anon_sym_BSLASHbibliography] = ACTIONS(255),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(257),
    [anon_sym_BSLASHincludesvg] = ACTIONS(259),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(261),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(263),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(263),
    [anon_sym_BSLASHimport] = ACTIONS(265),
    [anon_sym_BSLASHsubimport] = ACTIONS(265),
    [anon_sym_BSLASHinputfrom] = ACTIONS(265),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(265),
    [anon_sym_BSLASHincludefrom] = ACTIONS(265),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(265),
    [anon_sym_BSLASHcaption] = ACTIONS(267),
    [anon_sym_BSLASHcite] = ACTIONS(269),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHCite] = ACTIONS(269),
    [anon_sym_BSLASHnocite] = ACTIONS(269),
    [anon_sym_BSLASHcitet] = ACTIONS(269),
    [anon_sym_BSLASHcitep] = ACTIONS(269),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteA] = ACTIONS(269),
    [anon_sym_BSLASHciteR] = ACTIONS(269),
    [anon_sym_BSLASHciteS] = ACTIONS(269),
    [anon_sym_BSLASHciteyearR] = ACTIONS(269),
    [anon_sym_BSLASHciteauthor] = ACTIONS(269),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(271),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(269),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitetitle] = ACTIONS(269),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteyear] = ACTIONS(269),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitedate] = ACTIONS(269),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteurl] = ACTIONS(269),
    [anon_sym_BSLASHfullcite] = ACTIONS(269),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(269),
    [anon_sym_BSLASHcitealt] = ACTIONS(269),
    [anon_sym_BSLASHcitealp] = ACTIONS(269),
    [anon_sym_BSLASHcitetext] = ACTIONS(269),
    [anon_sym_BSLASHparencite] = ACTIONS(269),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHParencite] = ACTIONS(269),
    [anon_sym_BSLASHfootcite] = ACTIONS(269),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(269),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(269),
    [anon_sym_BSLASHtextcite] = ACTIONS(269),
    [anon_sym_BSLASHTextcite] = ACTIONS(269),
    [anon_sym_BSLASHsmartcite] = ACTIONS(269),
    [anon_sym_BSLASHSmartcite] = ACTIONS(269),
    [anon_sym_BSLASHsupercite] = ACTIONS(269),
    [anon_sym_BSLASHautocite] = ACTIONS(269),
    [anon_sym_BSLASHAutocite] = ACTIONS(269),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHvolcite] = ACTIONS(269),
    [anon_sym_BSLASHVolcite] = ACTIONS(269),
    [anon_sym_BSLASHpvolcite] = ACTIONS(269),
    [anon_sym_BSLASHPvolcite] = ACTIONS(269),
    [anon_sym_BSLASHfvolcite] = ACTIONS(269),
    [anon_sym_BSLASHftvolcite] = ACTIONS(269),
    [anon_sym_BSLASHsvolcite] = ACTIONS(269),
    [anon_sym_BSLASHSvolcite] = ACTIONS(269),
    [anon_sym_BSLASHtvolcite] = ACTIONS(269),
    [anon_sym_BSLASHTvolcite] = ACTIONS(269),
    [anon_sym_BSLASHavolcite] = ACTIONS(269),
    [anon_sym_BSLASHAvolcite] = ACTIONS(269),
    [anon_sym_BSLASHnotecite] = ACTIONS(269),
    [anon_sym_BSLASHNotecite] = ACTIONS(269),
    [anon_sym_BSLASHpnotecite] = ACTIONS(269),
    [anon_sym_BSLASHPnotecite] = ACTIONS(269),
    [anon_sym_BSLASHfnotecite] = ACTIONS(269),
    [anon_sym_BSLASHlabel] = ACTIONS(273),
    [anon_sym_BSLASHref] = ACTIONS(275),
    [anon_sym_BSLASHeqref] = ACTIONS(275),
    [anon_sym_BSLASHvref] = ACTIONS(275),
    [anon_sym_BSLASHVref] = ACTIONS(275),
    [anon_sym_BSLASHautoref] = ACTIONS(275),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHpageref] = ACTIONS(275),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHautopageref] = ACTIONS(275),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcref] = ACTIONS(275),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHCref] = ACTIONS(275),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcpageref] = ACTIONS(275),
    [anon_sym_BSLASHCpageref] = ACTIONS(275),
    [anon_sym_BSLASHnamecref] = ACTIONS(275),
    [anon_sym_BSLASHnameCref] = ACTIONS(275),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(275),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(275),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(275),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(275),
    [anon_sym_BSLASHlabelcref] = ACTIONS(275),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(275),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcrefrange] = ACTIONS(279),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(281),
    [anon_sym_BSLASHCrefrange] = ACTIONS(279),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(281),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(279),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(279),
    [anon_sym_BSLASHnewlabel] = ACTIONS(283),
    [anon_sym_BSLASHnewcommand] = ACTIONS(285),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(285),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(285),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(285),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(285),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(287),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHdef] = ACTIONS(293),
    [anon_sym_BSLASHgdef] = ACTIONS(293),
    [anon_sym_BSLASHedef] = ACTIONS(293),
    [anon_sym_BSLASHxdef] = ACTIONS(293),
    [anon_sym_BSLASHlet] = ACTIONS(295),
    [anon_sym_BSLASHglet] = ACTIONS(295),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(297),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(297),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(299),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(299),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(305),
    [anon_sym_BSLASHgls] = ACTIONS(307),
    [anon_sym_BSLASHGls] = ACTIONS(307),
    [anon_sym_BSLASHGLS] = ACTIONS(307),
    [anon_sym_BSLASHglspl] = ACTIONS(307),
    [anon_sym_BSLASHGlspl] = ACTIONS(307),
    [anon_sym_BSLASHGLSpl] = ACTIONS(307),
    [anon_sym_BSLASHglsdisp] = ACTIONS(307),
    [anon_sym_BSLASHglslink] = ACTIONS(307),
    [anon_sym_BSLASHglstext] = ACTIONS(307),
    [anon_sym_BSLASHGlstext] = ACTIONS(307),
    [anon_sym_BSLASHGLStext] = ACTIONS(307),
    [anon_sym_BSLASHglsfirst] = ACTIONS(307),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(307),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(307),
    [anon_sym_BSLASHglsplural] = ACTIONS(307),
    [anon_sym_BSLASHGlsplural] = ACTIONS(307),
    [anon_sym_BSLASHGLSplural] = ACTIONS(307),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHglsname] = ACTIONS(307),
    [anon_sym_BSLASHGlsname] = ACTIONS(307),
    [anon_sym_BSLASHGLSname] = ACTIONS(307),
    [anon_sym_BSLASHglssymbol] = ACTIONS(307),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(307),
    [anon_sym_BSLASHglsdesc] = ACTIONS(307),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(307),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(307),
    [anon_sym_BSLASHglsuseri] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(307),
    [anon_sym_BSLASHglsuserii] = ACTIONS(307),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(307),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(307),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(307),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(307),
    [anon_sym_BSLASHglsuserv] = ACTIONS(307),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(307),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(307),
    [anon_sym_BSLASHglsuservi] = ACTIONS(307),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(307),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(307),
    [anon_sym_BSLASHnewacronym] = ACTIONS(309),
    [anon_sym_BSLASHacrshort] = ACTIONS(311),
    [anon_sym_BSLASHAcrshort] = ACTIONS(311),
    [anon_sym_BSLASHACRshort] = ACTIONS(311),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(311),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(311),
    [anon_sym_BSLASHacrlong] = ACTIONS(311),
    [anon_sym_BSLASHAcrlong] = ACTIONS(311),
    [anon_sym_BSLASHACRlong] = ACTIONS(311),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(311),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(311),
    [anon_sym_BSLASHacrfull] = ACTIONS(311),
    [anon_sym_BSLASHAcrfull] = ACTIONS(311),
    [anon_sym_BSLASHACRfull] = ACTIONS(311),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(311),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(311),
    [anon_sym_BSLASHacs] = ACTIONS(311),
    [anon_sym_BSLASHAcs] = ACTIONS(311),
    [anon_sym_BSLASHacsp] = ACTIONS(311),
    [anon_sym_BSLASHAcsp] = ACTIONS(311),
    [anon_sym_BSLASHacl] = ACTIONS(311),
    [anon_sym_BSLASHAcl] = ACTIONS(311),
    [anon_sym_BSLASHaclp] = ACTIONS(311),
    [anon_sym_BSLASHAclp] = ACTIONS(311),
    [anon_sym_BSLASHacf] = ACTIONS(311),
    [anon_sym_BSLASHAcf] = ACTIONS(311),
    [anon_sym_BSLASHacfp] = ACTIONS(311),
    [anon_sym_BSLASHAcfp] = ACTIONS(311),
    [anon_sym_BSLASHac] = ACTIONS(311),
    [anon_sym_BSLASHAc] = ACTIONS(311),
    [anon_sym_BSLASHacp] = ACTIONS(311),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(311),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(311),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(311),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(311),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(311),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(311),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(313),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(315),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(313),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(315),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(317),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(319),
    [anon_sym_BSLASHcolor] = ACTIONS(321),
    [anon_sym_BSLASHpagecolor] = ACTIONS(321),
    [anon_sym_BSLASHtextcolor] = ACTIONS(321),
    [anon_sym_BSLASHmathcolor] = ACTIONS(321),
    [anon_sym_BSLASHcolorbox] = ACTIONS(321),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(323),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(323),
    [anon_sym_BSLASHurl] = ACTIONS(325),
    [anon_sym_BSLASHhref] = ACTIONS(325),
  },
  [7] = {
    [sym_block_comment] = STATE(13),
    [sym__root_content] = STATE(13),
    [sym__flat_content] = STATE(13),
    [sym__text_with_env_content] = STATE(13),
    [sym__text_content] = STATE(13),
    [sym__section] = STATE(13),
    [sym__paragraph] = STATE(13),
    [sym__part_declaration] = STATE(157),
    [sym_part] = STATE(444),
    [sym__chapter_declaration] = STATE(158),
    [sym_chapter] = STATE(369),
    [sym__section_declaration] = STATE(168),
    [sym_section] = STATE(370),
    [sym__subsection_declaration] = STATE(180),
    [sym_subsection] = STATE(371),
    [sym__subsubsection_declaration] = STATE(189),
    [sym_subsubsection] = STATE(372),
    [sym__paragraph_declaration] = STATE(207),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(209),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(218),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(13),
    [sym_text] = STATE(13),
    [sym_operator] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_superscript] = STATE(625),
    [sym__math_content] = STATE(13),
    [sym_displayed_equation] = STATE(13),
    [sym_inline_formula] = STATE(13),
    [sym_math_delimiter] = STATE(13),
    [sym_text_mode] = STATE(13),
    [sym_begin] = STATE(55),
    [sym_generic_environment] = STATE(13),
    [sym_comment_environment] = STATE(13),
    [sym__comment_environment_begin] = STATE(3767),
    [sym_verbatim_environment] = STATE(13),
    [sym__verbatim_environment_begin] = STATE(3768),
    [sym_listing_environment] = STATE(13),
    [sym__listing_environment_begin] = STATE(3769),
    [sym_minted_environment] = STATE(13),
    [sym__minted_environment_begin] = STATE(3770),
    [sym_asy_environment] = STATE(13),
    [sym__asy_environment_begin] = STATE(3771),
    [sym_asydef_environment] = STATE(13),
    [sym__asydef_environment_begin] = STATE(3772),
    [sym_pycode_environment] = STATE(13),
    [sym__pycode_environment_begin] = STATE(3773),
    [sym_luacode_environment] = STATE(13),
    [sym__luacode_environment] = STATE(584),
    [sym___luacode_environment_begin] = STATE(3774),
    [sym__luacode_environment_star] = STATE(585),
    [sym___luacode_environment_star_begin] = STATE(3775),
    [sym_sagesilent_environment] = STATE(13),
    [sym__sagesilent_environment_begin] = STATE(3776),
    [sym_sageblock_environment] = STATE(13),
    [sym__sageblock_environment_begin] = STATE(3777),
    [sym_math_environment] = STATE(13),
    [sym__math_environment_begin] = STATE(250),
    [sym__command] = STATE(13),
    [sym_generic_command] = STATE(13),
    [sym_title_declaration] = STATE(13),
    [sym_author_declaration] = STATE(13),
    [sym_package_include] = STATE(13),
    [sym_class_include] = STATE(13),
    [sym_latex_include] = STATE(13),
    [sym_biblatex_include] = STATE(13),
    [sym_bibstyle_include] = STATE(13),
    [sym_bibtex_include] = STATE(13),
    [sym_graphics_include] = STATE(13),
    [sym_svg_include] = STATE(13),
    [sym_inkscape_include] = STATE(13),
    [sym_verbatim_include] = STATE(13),
    [sym_import_include] = STATE(13),
    [sym_caption] = STATE(13),
    [sym_citation] = STATE(13),
    [sym_label_definition] = STATE(13),
    [sym_label_reference] = STATE(13),
    [sym_label_reference_range] = STATE(13),
    [sym_label_number] = STATE(13),
    [sym_new_command_definition] = STATE(13),
    [sym__new_command_definition] = STATE(627),
    [sym__newer_command_definition] = STATE(628),
    [sym__new_command_copy] = STATE(629),
    [sym_old_command_definition] = STATE(13),
    [sym_let_command_definition] = STATE(13),
    [sym_paired_delimiter_definition] = STATE(13),
    [sym_environment_definition] = STATE(13),
    [sym__environment_definition] = STATE(630),
    [sym__newer_environment_definition] = STATE(631),
    [sym__new_environment_copy] = STATE(632),
    [sym_glossary_entry_definition] = STATE(13),
    [sym_glossary_entry_reference] = STATE(13),
    [sym_acronym_definition] = STATE(13),
    [sym_acronym_reference] = STATE(13),
    [sym_theorem_definition] = STATE(13),
    [sym_color_definition] = STATE(13),
    [sym_color_set_definition] = STATE(13),
    [sym_color_reference] = STATE(13),
    [sym_tikz_library_import] = STATE(13),
    [sym_hyperlink] = STATE(13),
    [aux_sym_source_file_repeat1] = STATE(13),
    [aux_sym__section_repeat1] = STATE(444),
    [aux_sym__section_repeat2] = STATE(369),
    [aux_sym__section_repeat3] = STATE(370),
    [aux_sym__section_repeat4] = STATE(371),
    [aux_sym__section_repeat5] = STATE(372),
    [aux_sym__paragraph_repeat1] = STATE(373),
    [aux_sym__paragraph_repeat2] = STATE(374),
    [aux_sym__paragraph_repeat3] = STATE(375),
    [aux_sym_text_repeat1] = STATE(265),
    [sym_command_name] = ACTIONS(177),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(327),
    [anon_sym_RBRACK] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(327),
    [anon_sym_EQ] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_RPAREN] = ACTIONS(327),
    [anon_sym_BSLASHpart] = ACTIONS(183),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddpart] = ACTIONS(183),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHchapter] = ACTIONS(187),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(189),
    [anon_sym_BSLASHaddchap] = ACTIONS(187),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(189),
    [anon_sym_BSLASHsection] = ACTIONS(191),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(193),
    [anon_sym_BSLASHaddsec] = ACTIONS(191),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(193),
    [anon_sym_BSLASHsubsection] = ACTIONS(195),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(197),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(199),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(201),
    [anon_sym_BSLASHparagraph] = ACTIONS(203),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(205),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(207),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(209),
    [anon_sym_BSLASHitem] = ACTIONS(211),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(213),
    [anon_sym_LBRACE] = ACTIONS(215),
    [sym_word] = ACTIONS(217),
    [sym_placeholder] = ACTIONS(219),
    [sym_delimiter] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_STAR] = ACTIONS(221),
    [anon_sym_SLASH] = ACTIONS(221),
    [anon_sym_LT] = ACTIONS(223),
    [anon_sym_GT] = ACTIONS(223),
    [anon_sym_BANG] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_COLON] = ACTIONS(223),
    [anon_sym_SQUOTE] = ACTIONS(223),
    [anon_sym__] = ACTIONS(225),
    [anon_sym_CARET] = ACTIONS(227),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(229),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(233),
    [anon_sym_BSLASHleft] = ACTIONS(235),
    [anon_sym_BSLASHbigl] = ACTIONS(235),
    [anon_sym_BSLASHBigl] = ACTIONS(235),
    [anon_sym_BSLASHbiggl] = ACTIONS(235),
    [anon_sym_BSLASHBiggl] = ACTIONS(235),
    [anon_sym_BSLASHright] = ACTIONS(329),
    [anon_sym_BSLASHbigr] = ACTIONS(329),
    [anon_sym_BSLASHBigr] = ACTIONS(329),
    [anon_sym_BSLASHbiggr] = ACTIONS(329),
    [anon_sym_BSLASHBiggr] = ACTIONS(329),
    [anon_sym_BSLASHtext] = ACTIONS(239),
    [anon_sym_BSLASHintertext] = ACTIONS(239),
    [anon_sym_BSLASHshortintertext] = ACTIONS(239),
    [anon_sym_BSLASHbegin] = ACTIONS(69),
    [anon_sym_BSLASHtitle] = ACTIONS(241),
    [anon_sym_BSLASHauthor] = ACTIONS(243),
    [anon_sym_BSLASHusepackage] = ACTIONS(245),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(245),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(247),
    [anon_sym_BSLASHinclude] = ACTIONS(249),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(249),
    [anon_sym_BSLASHinput] = ACTIONS(249),
    [anon_sym_BSLASHsubfile] = ACTIONS(249),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(251),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(253),
    [anon_sym_BSLASHbibliography] = ACTIONS(255),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(257),
    [anon_sym_BSLASHincludesvg] = ACTIONS(259),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(261),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(263),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(263),
    [anon_sym_BSLASHimport] = ACTIONS(265),
    [anon_sym_BSLASHsubimport] = ACTIONS(265),
    [anon_sym_BSLASHinputfrom] = ACTIONS(265),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(265),
    [anon_sym_BSLASHincludefrom] = ACTIONS(265),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(265),
    [anon_sym_BSLASHcaption] = ACTIONS(267),
    [anon_sym_BSLASHcite] = ACTIONS(269),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHCite] = ACTIONS(269),
    [anon_sym_BSLASHnocite] = ACTIONS(269),
    [anon_sym_BSLASHcitet] = ACTIONS(269),
    [anon_sym_BSLASHcitep] = ACTIONS(269),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteA] = ACTIONS(269),
    [anon_sym_BSLASHciteR] = ACTIONS(269),
    [anon_sym_BSLASHciteS] = ACTIONS(269),
    [anon_sym_BSLASHciteyearR] = ACTIONS(269),
    [anon_sym_BSLASHciteauthor] = ACTIONS(269),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(271),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(269),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitetitle] = ACTIONS(269),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteyear] = ACTIONS(269),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitedate] = ACTIONS(269),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteurl] = ACTIONS(269),
    [anon_sym_BSLASHfullcite] = ACTIONS(269),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(269),
    [anon_sym_BSLASHcitealt] = ACTIONS(269),
    [anon_sym_BSLASHcitealp] = ACTIONS(269),
    [anon_sym_BSLASHcitetext] = ACTIONS(269),
    [anon_sym_BSLASHparencite] = ACTIONS(269),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHParencite] = ACTIONS(269),
    [anon_sym_BSLASHfootcite] = ACTIONS(269),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(269),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(269),
    [anon_sym_BSLASHtextcite] = ACTIONS(269),
    [anon_sym_BSLASHTextcite] = ACTIONS(269),
    [anon_sym_BSLASHsmartcite] = ACTIONS(269),
    [anon_sym_BSLASHSmartcite] = ACTIONS(269),
    [anon_sym_BSLASHsupercite] = ACTIONS(269),
    [anon_sym_BSLASHautocite] = ACTIONS(269),
    [anon_sym_BSLASHAutocite] = ACTIONS(269),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHvolcite] = ACTIONS(269),
    [anon_sym_BSLASHVolcite] = ACTIONS(269),
    [anon_sym_BSLASHpvolcite] = ACTIONS(269),
    [anon_sym_BSLASHPvolcite] = ACTIONS(269),
    [anon_sym_BSLASHfvolcite] = ACTIONS(269),
    [anon_sym_BSLASHftvolcite] = ACTIONS(269),
    [anon_sym_BSLASHsvolcite] = ACTIONS(269),
    [anon_sym_BSLASHSvolcite] = ACTIONS(269),
    [anon_sym_BSLASHtvolcite] = ACTIONS(269),
    [anon_sym_BSLASHTvolcite] = ACTIONS(269),
    [anon_sym_BSLASHavolcite] = ACTIONS(269),
    [anon_sym_BSLASHAvolcite] = ACTIONS(269),
    [anon_sym_BSLASHnotecite] = ACTIONS(269),
    [anon_sym_BSLASHNotecite] = ACTIONS(269),
    [anon_sym_BSLASHpnotecite] = ACTIONS(269),
    [anon_sym_BSLASHPnotecite] = ACTIONS(269),
    [anon_sym_BSLASHfnotecite] = ACTIONS(269),
    [anon_sym_BSLASHlabel] = ACTIONS(273),
    [anon_sym_BSLASHref] = ACTIONS(275),
    [anon_sym_BSLASHeqref] = ACTIONS(275),
    [anon_sym_BSLASHvref] = ACTIONS(275),
    [anon_sym_BSLASHVref] = ACTIONS(275),
    [anon_sym_BSLASHautoref] = ACTIONS(275),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHpageref] = ACTIONS(275),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHautopageref] = ACTIONS(275),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcref] = ACTIONS(275),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHCref] = ACTIONS(275),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcpageref] = ACTIONS(275),
    [anon_sym_BSLASHCpageref] = ACTIONS(275),
    [anon_sym_BSLASHnamecref] = ACTIONS(275),
    [anon_sym_BSLASHnameCref] = ACTIONS(275),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(275),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(275),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(275),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(275),
    [anon_sym_BSLASHlabelcref] = ACTIONS(275),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(275),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcrefrange] = ACTIONS(279),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(281),
    [anon_sym_BSLASHCrefrange] = ACTIONS(279),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(281),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(279),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(279),
    [anon_sym_BSLASHnewlabel] = ACTIONS(283),
    [anon_sym_BSLASHnewcommand] = ACTIONS(285),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(285),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(285),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(285),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(285),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(287),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHdef] = ACTIONS(293),
    [anon_sym_BSLASHgdef] = ACTIONS(293),
    [anon_sym_BSLASHedef] = ACTIONS(293),
    [anon_sym_BSLASHxdef] = ACTIONS(293),
    [anon_sym_BSLASHlet] = ACTIONS(295),
    [anon_sym_BSLASHglet] = ACTIONS(295),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(297),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(297),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(299),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(299),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(305),
    [anon_sym_BSLASHgls] = ACTIONS(307),
    [anon_sym_BSLASHGls] = ACTIONS(307),
    [anon_sym_BSLASHGLS] = ACTIONS(307),
    [anon_sym_BSLASHglspl] = ACTIONS(307),
    [anon_sym_BSLASHGlspl] = ACTIONS(307),
    [anon_sym_BSLASHGLSpl] = ACTIONS(307),
    [anon_sym_BSLASHglsdisp] = ACTIONS(307),
    [anon_sym_BSLASHglslink] = ACTIONS(307),
    [anon_sym_BSLASHglstext] = ACTIONS(307),
    [anon_sym_BSLASHGlstext] = ACTIONS(307),
    [anon_sym_BSLASHGLStext] = ACTIONS(307),
    [anon_sym_BSLASHglsfirst] = ACTIONS(307),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(307),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(307),
    [anon_sym_BSLASHglsplural] = ACTIONS(307),
    [anon_sym_BSLASHGlsplural] = ACTIONS(307),
    [anon_sym_BSLASHGLSplural] = ACTIONS(307),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHglsname] = ACTIONS(307),
    [anon_sym_BSLASHGlsname] = ACTIONS(307),
    [anon_sym_BSLASHGLSname] = ACTIONS(307),
    [anon_sym_BSLASHglssymbol] = ACTIONS(307),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(307),
    [anon_sym_BSLASHglsdesc] = ACTIONS(307),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(307),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(307),
    [anon_sym_BSLASHglsuseri] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(307),
    [anon_sym_BSLASHglsuserii] = ACTIONS(307),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(307),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(307),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(307),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(307),
    [anon_sym_BSLASHglsuserv] = ACTIONS(307),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(307),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(307),
    [anon_sym_BSLASHglsuservi] = ACTIONS(307),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(307),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(307),
    [anon_sym_BSLASHnewacronym] = ACTIONS(309),
    [anon_sym_BSLASHacrshort] = ACTIONS(311),
    [anon_sym_BSLASHAcrshort] = ACTIONS(311),
    [anon_sym_BSLASHACRshort] = ACTIONS(311),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(311),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(311),
    [anon_sym_BSLASHacrlong] = ACTIONS(311),
    [anon_sym_BSLASHAcrlong] = ACTIONS(311),
    [anon_sym_BSLASHACRlong] = ACTIONS(311),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(311),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(311),
    [anon_sym_BSLASHacrfull] = ACTIONS(311),
    [anon_sym_BSLASHAcrfull] = ACTIONS(311),
    [anon_sym_BSLASHACRfull] = ACTIONS(311),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(311),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(311),
    [anon_sym_BSLASHacs] = ACTIONS(311),
    [anon_sym_BSLASHAcs] = ACTIONS(311),
    [anon_sym_BSLASHacsp] = ACTIONS(311),
    [anon_sym_BSLASHAcsp] = ACTIONS(311),
    [anon_sym_BSLASHacl] = ACTIONS(311),
    [anon_sym_BSLASHAcl] = ACTIONS(311),
    [anon_sym_BSLASHaclp] = ACTIONS(311),
    [anon_sym_BSLASHAclp] = ACTIONS(311),
    [anon_sym_BSLASHacf] = ACTIONS(311),
    [anon_sym_BSLASHAcf] = ACTIONS(311),
    [anon_sym_BSLASHacfp] = ACTIONS(311),
    [anon_sym_BSLASHAcfp] = ACTIONS(311),
    [anon_sym_BSLASHac] = ACTIONS(311),
    [anon_sym_BSLASHAc] = ACTIONS(311),
    [anon_sym_BSLASHacp] = ACTIONS(311),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(311),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(311),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(311),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(311),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(311),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(311),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(313),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(315),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(313),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(315),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(317),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(319),
    [anon_sym_BSLASHcolor] = ACTIONS(321),
    [anon_sym_BSLASHpagecolor] = ACTIONS(321),
    [anon_sym_BSLASHtextcolor] = ACTIONS(321),
    [anon_sym_BSLASHmathcolor] = ACTIONS(321),
    [anon_sym_BSLASHcolorbox] = ACTIONS(321),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(323),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(323),
    [anon_sym_BSLASHurl] = ACTIONS(325),
    [anon_sym_BSLASHhref] = ACTIONS(325),
  },
  [8] = {
    [sym_block_comment] = STATE(11),
    [sym__root_content] = STATE(11),
    [sym__flat_content] = STATE(11),
    [sym__text_with_env_content] = STATE(11),
    [sym__text_content] = STATE(11),
    [sym__section] = STATE(11),
    [sym__paragraph] = STATE(11),
    [sym__part_declaration] = STATE(157),
    [sym_part] = STATE(444),
    [sym__chapter_declaration] = STATE(158),
    [sym_chapter] = STATE(369),
    [sym__section_declaration] = STATE(168),
    [sym_section] = STATE(370),
    [sym__subsection_declaration] = STATE(180),
    [sym_subsection] = STATE(371),
    [sym__subsubsection_declaration] = STATE(189),
    [sym_subsubsection] = STATE(372),
    [sym__paragraph_declaration] = STATE(207),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(209),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(218),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(11),
    [sym_text] = STATE(11),
    [sym_operator] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_superscript] = STATE(625),
    [sym__math_content] = STATE(11),
    [sym_displayed_equation] = STATE(11),
    [sym_inline_formula] = STATE(11),
    [sym_math_delimiter] = STATE(11),
    [sym_text_mode] = STATE(11),
    [sym_begin] = STATE(55),
    [sym_generic_environment] = STATE(11),
    [sym_comment_environment] = STATE(11),
    [sym__comment_environment_begin] = STATE(3767),
    [sym_verbatim_environment] = STATE(11),
    [sym__verbatim_environment_begin] = STATE(3768),
    [sym_listing_environment] = STATE(11),
    [sym__listing_environment_begin] = STATE(3769),
    [sym_minted_environment] = STATE(11),
    [sym__minted_environment_begin] = STATE(3770),
    [sym_asy_environment] = STATE(11),
    [sym__asy_environment_begin] = STATE(3771),
    [sym_asydef_environment] = STATE(11),
    [sym__asydef_environment_begin] = STATE(3772),
    [sym_pycode_environment] = STATE(11),
    [sym__pycode_environment_begin] = STATE(3773),
    [sym_luacode_environment] = STATE(11),
    [sym__luacode_environment] = STATE(584),
    [sym___luacode_environment_begin] = STATE(3774),
    [sym__luacode_environment_star] = STATE(585),
    [sym___luacode_environment_star_begin] = STATE(3775),
    [sym_sagesilent_environment] = STATE(11),
    [sym__sagesilent_environment_begin] = STATE(3776),
    [sym_sageblock_environment] = STATE(11),
    [sym__sageblock_environment_begin] = STATE(3777),
    [sym_math_environment] = STATE(11),
    [sym__math_environment_begin] = STATE(250),
    [sym__command] = STATE(11),
    [sym_generic_command] = STATE(11),
    [sym_title_declaration] = STATE(11),
    [sym_author_declaration] = STATE(11),
    [sym_package_include] = STATE(11),
    [sym_class_include] = STATE(11),
    [sym_latex_include] = STATE(11),
    [sym_biblatex_include] = STATE(11),
    [sym_bibstyle_include] = STATE(11),
    [sym_bibtex_include] = STATE(11),
    [sym_graphics_include] = STATE(11),
    [sym_svg_include] = STATE(11),
    [sym_inkscape_include] = STATE(11),
    [sym_verbatim_include] = STATE(11),
    [sym_import_include] = STATE(11),
    [sym_caption] = STATE(11),
    [sym_citation] = STATE(11),
    [sym_label_definition] = STATE(11),
    [sym_label_reference] = STATE(11),
    [sym_label_reference_range] = STATE(11),
    [sym_label_number] = STATE(11),
    [sym_new_command_definition] = STATE(11),
    [sym__new_command_definition] = STATE(627),
    [sym__newer_command_definition] = STATE(628),
    [sym__new_command_copy] = STATE(629),
    [sym_old_command_definition] = STATE(11),
    [sym_let_command_definition] = STATE(11),
    [sym_paired_delimiter_definition] = STATE(11),
    [sym_environment_definition] = STATE(11),
    [sym__environment_definition] = STATE(630),
    [sym__newer_environment_definition] = STATE(631),
    [sym__new_environment_copy] = STATE(632),
    [sym_glossary_entry_definition] = STATE(11),
    [sym_glossary_entry_reference] = STATE(11),
    [sym_acronym_definition] = STATE(11),
    [sym_acronym_reference] = STATE(11),
    [sym_theorem_definition] = STATE(11),
    [sym_color_definition] = STATE(11),
    [sym_color_set_definition] = STATE(11),
    [sym_color_reference] = STATE(11),
    [sym_tikz_library_import] = STATE(11),
    [sym_hyperlink] = STATE(11),
    [aux_sym_source_file_repeat1] = STATE(11),
    [aux_sym__section_repeat1] = STATE(444),
    [aux_sym__section_repeat2] = STATE(369),
    [aux_sym__section_repeat3] = STATE(370),
    [aux_sym__section_repeat4] = STATE(371),
    [aux_sym__section_repeat5] = STATE(372),
    [aux_sym__paragraph_repeat1] = STATE(373),
    [aux_sym__paragraph_repeat2] = STATE(374),
    [aux_sym__paragraph_repeat3] = STATE(375),
    [aux_sym_text_repeat1] = STATE(265),
    [sym_command_name] = ACTIONS(177),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_RBRACK] = ACTIONS(331),
    [anon_sym_COMMA] = ACTIONS(331),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_RPAREN] = ACTIONS(331),
    [anon_sym_BSLASHpart] = ACTIONS(183),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddpart] = ACTIONS(183),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHchapter] = ACTIONS(187),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(189),
    [anon_sym_BSLASHaddchap] = ACTIONS(187),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(189),
    [anon_sym_BSLASHsection] = ACTIONS(191),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(193),
    [anon_sym_BSLASHaddsec] = ACTIONS(191),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(193),
    [anon_sym_BSLASHsubsection] = ACTIONS(195),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(197),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(199),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(201),
    [anon_sym_BSLASHparagraph] = ACTIONS(203),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(205),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(207),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(209),
    [anon_sym_BSLASHitem] = ACTIONS(211),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(213),
    [anon_sym_LBRACE] = ACTIONS(215),
    [sym_word] = ACTIONS(217),
    [sym_placeholder] = ACTIONS(219),
    [sym_delimiter] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_STAR] = ACTIONS(221),
    [anon_sym_SLASH] = ACTIONS(221),
    [anon_sym_LT] = ACTIONS(223),
    [anon_sym_GT] = ACTIONS(223),
    [anon_sym_BANG] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_COLON] = ACTIONS(223),
    [anon_sym_SQUOTE] = ACTIONS(223),
    [anon_sym__] = ACTIONS(225),
    [anon_sym_CARET] = ACTIONS(227),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(229),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(231),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(233),
    [anon_sym_BSLASHleft] = ACTIONS(235),
    [anon_sym_BSLASHbigl] = ACTIONS(235),
    [anon_sym_BSLASHBigl] = ACTIONS(235),
    [anon_sym_BSLASHbiggl] = ACTIONS(235),
    [anon_sym_BSLASHBiggl] = ACTIONS(235),
    [anon_sym_BSLASHright] = ACTIONS(333),
    [anon_sym_BSLASHbigr] = ACTIONS(333),
    [anon_sym_BSLASHBigr] = ACTIONS(333),
    [anon_sym_BSLASHbiggr] = ACTIONS(333),
    [anon_sym_BSLASHBiggr] = ACTIONS(333),
    [anon_sym_BSLASHtext] = ACTIONS(239),
    [anon_sym_BSLASHintertext] = ACTIONS(239),
    [anon_sym_BSLASHshortintertext] = ACTIONS(239),
    [anon_sym_BSLASHbegin] = ACTIONS(69),
    [anon_sym_BSLASHtitle] = ACTIONS(241),
    [anon_sym_BSLASHauthor] = ACTIONS(243),
    [anon_sym_BSLASHusepackage] = ACTIONS(245),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(245),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(247),
    [anon_sym_BSLASHinclude] = ACTIONS(249),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(249),
    [anon_sym_BSLASHinput] = ACTIONS(249),
    [anon_sym_BSLASHsubfile] = ACTIONS(249),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(251),
    [anon_sym_BSLASHbibliographystyle] = ACTIONS(253),
    [anon_sym_BSLASHbibliography] = ACTIONS(255),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(257),
    [anon_sym_BSLASHincludesvg] = ACTIONS(259),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(261),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(263),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(263),
    [anon_sym_BSLASHimport] = ACTIONS(265),
    [anon_sym_BSLASHsubimport] = ACTIONS(265),
    [anon_sym_BSLASHinputfrom] = ACTIONS(265),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(265),
    [anon_sym_BSLASHincludefrom] = ACTIONS(265),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(265),
    [anon_sym_BSLASHcaption] = ACTIONS(267),
    [anon_sym_BSLASHcite] = ACTIONS(269),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHCite] = ACTIONS(269),
    [anon_sym_BSLASHnocite] = ACTIONS(269),
    [anon_sym_BSLASHcitet] = ACTIONS(269),
    [anon_sym_BSLASHcitep] = ACTIONS(269),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteA] = ACTIONS(269),
    [anon_sym_BSLASHciteR] = ACTIONS(269),
    [anon_sym_BSLASHciteS] = ACTIONS(269),
    [anon_sym_BSLASHciteyearR] = ACTIONS(269),
    [anon_sym_BSLASHciteauthor] = ACTIONS(269),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(271),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(269),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitetitle] = ACTIONS(269),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteyear] = ACTIONS(269),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(271),
    [anon_sym_BSLASHcitedate] = ACTIONS(269),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(271),
    [anon_sym_BSLASHciteurl] = ACTIONS(269),
    [anon_sym_BSLASHfullcite] = ACTIONS(269),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(269),
    [anon_sym_BSLASHcitealt] = ACTIONS(269),
    [anon_sym_BSLASHcitealp] = ACTIONS(269),
    [anon_sym_BSLASHcitetext] = ACTIONS(269),
    [anon_sym_BSLASHparencite] = ACTIONS(269),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHParencite] = ACTIONS(269),
    [anon_sym_BSLASHfootcite] = ACTIONS(269),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(269),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(269),
    [anon_sym_BSLASHtextcite] = ACTIONS(269),
    [anon_sym_BSLASHTextcite] = ACTIONS(269),
    [anon_sym_BSLASHsmartcite] = ACTIONS(269),
    [anon_sym_BSLASHSmartcite] = ACTIONS(269),
    [anon_sym_BSLASHsupercite] = ACTIONS(269),
    [anon_sym_BSLASHautocite] = ACTIONS(269),
    [anon_sym_BSLASHAutocite] = ACTIONS(269),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(271),
    [anon_sym_BSLASHvolcite] = ACTIONS(269),
    [anon_sym_BSLASHVolcite] = ACTIONS(269),
    [anon_sym_BSLASHpvolcite] = ACTIONS(269),
    [anon_sym_BSLASHPvolcite] = ACTIONS(269),
    [anon_sym_BSLASHfvolcite] = ACTIONS(269),
    [anon_sym_BSLASHftvolcite] = ACTIONS(269),
    [anon_sym_BSLASHsvolcite] = ACTIONS(269),
    [anon_sym_BSLASHSvolcite] = ACTIONS(269),
    [anon_sym_BSLASHtvolcite] = ACTIONS(269),
    [anon_sym_BSLASHTvolcite] = ACTIONS(269),
    [anon_sym_BSLASHavolcite] = ACTIONS(269),
    [anon_sym_BSLASHAvolcite] = ACTIONS(269),
    [anon_sym_BSLASHnotecite] = ACTIONS(269),
    [anon_sym_BSLASHNotecite] = ACTIONS(269),
    [anon_sym_BSLASHpnotecite] = ACTIONS(269),
    [anon_sym_BSLASHPnotecite] = ACTIONS(269),
    [anon_sym_BSLASHfnotecite] = ACTIONS(269),
    [anon_sym_BSLASHlabel] = ACTIONS(273),
    [anon_sym_BSLASHref] = ACTIONS(275),
    [anon_sym_BSLASHeqref] = ACTIONS(275),
    [anon_sym_BSLASHvref] = ACTIONS(275),
    [anon_sym_BSLASHVref] = ACTIONS(275),
    [anon_sym_BSLASHautoref] = ACTIONS(275),
    [anon_sym_BSLASHautoref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHpageref] = ACTIONS(275),
    [anon_sym_BSLASHpageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHautopageref] = ACTIONS(275),
    [anon_sym_BSLASHautopageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcref] = ACTIONS(275),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHCref] = ACTIONS(275),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcpageref] = ACTIONS(275),
    [anon_sym_BSLASHCpageref] = ACTIONS(275),
    [anon_sym_BSLASHnamecref] = ACTIONS(275),
    [anon_sym_BSLASHnameCref] = ACTIONS(275),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(275),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(275),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(275),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(275),
    [anon_sym_BSLASHlabelcref] = ACTIONS(275),
    [anon_sym_BSLASHlabelcref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(275),
    [anon_sym_BSLASHlabelcpageref_STAR] = ACTIONS(277),
    [anon_sym_BSLASHcrefrange] = ACTIONS(279),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(281),
    [anon_sym_BSLASHCrefrange] = ACTIONS(279),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(281),
    [anon_sym_BSLASHcpagerefrange] = ACTIONS(279),
    [anon_sym_BSLASHCpagerefrange] = ACTIONS(279),
    [anon_sym_BSLASHnewlabel] = ACTIONS(283),
    [anon_sym_BSLASHnewcommand] = ACTIONS(285),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(285),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHprovidecommand] = ACTIONS(285),
    [anon_sym_BSLASHprovidecommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(285),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(287),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(285),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(287),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(289),
    [anon_sym_BSLASHNewCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHRenewCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHDeclareCommandCopy] = ACTIONS(291),
    [anon_sym_BSLASHdef] = ACTIONS(293),
    [anon_sym_BSLASHgdef] = ACTIONS(293),
    [anon_sym_BSLASHedef] = ACTIONS(293),
    [anon_sym_BSLASHxdef] = ACTIONS(293),
    [anon_sym_BSLASHlet] = ACTIONS(295),
    [anon_sym_BSLASHglet] = ACTIONS(295),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(297),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(297),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(299),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(299),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(301),
    [anon_sym_BSLASHNewEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHRenewEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHDeclareEnvironmentCopy] = ACTIONS(303),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(305),
    [anon_sym_BSLASHgls] = ACTIONS(307),
    [anon_sym_BSLASHGls] = ACTIONS(307),
    [anon_sym_BSLASHGLS] = ACTIONS(307),
    [anon_sym_BSLASHglspl] = ACTIONS(307),
    [anon_sym_BSLASHGlspl] = ACTIONS(307),
    [anon_sym_BSLASHGLSpl] = ACTIONS(307),
    [anon_sym_BSLASHglsdisp] = ACTIONS(307),
    [anon_sym_BSLASHglslink] = ACTIONS(307),
    [anon_sym_BSLASHglstext] = ACTIONS(307),
    [anon_sym_BSLASHGlstext] = ACTIONS(307),
    [anon_sym_BSLASHGLStext] = ACTIONS(307),
    [anon_sym_BSLASHglsfirst] = ACTIONS(307),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(307),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(307),
    [anon_sym_BSLASHglsplural] = ACTIONS(307),
    [anon_sym_BSLASHGlsplural] = ACTIONS(307),
    [anon_sym_BSLASHGLSplural] = ACTIONS(307),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(307),
    [anon_sym_BSLASHglsname] = ACTIONS(307),
    [anon_sym_BSLASHGlsname] = ACTIONS(307),
    [anon_sym_BSLASHGLSname] = ACTIONS(307),
    [anon_sym_BSLASHglssymbol] = ACTIONS(307),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(307),
    [anon_sym_BSLASHglsdesc] = ACTIONS(307),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(307),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(307),
    [anon_sym_BSLASHglsuseri] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(307),
    [anon_sym_BSLASHglsuserii] = ACTIONS(307),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(307),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(307),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(307),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(307),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(307),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(307),
    [anon_sym_BSLASHglsuserv] = ACTIONS(307),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(307),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(307),
    [anon_sym_BSLASHglsuservi] = ACTIONS(307),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(307),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(307),
    [anon_sym_BSLASHnewacronym] = ACTIONS(309),
    [anon_sym_BSLASHacrshort] = ACTIONS(311),
    [anon_sym_BSLASHAcrshort] = ACTIONS(311),
    [anon_sym_BSLASHACRshort] = ACTIONS(311),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(311),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(311),
    [anon_sym_BSLASHacrlong] = ACTIONS(311),
    [anon_sym_BSLASHAcrlong] = ACTIONS(311),
    [anon_sym_BSLASHACRlong] = ACTIONS(311),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(311),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(311),
    [anon_sym_BSLASHacrfull] = ACTIONS(311),
    [anon_sym_BSLASHAcrfull] = ACTIONS(311),
    [anon_sym_BSLASHACRfull] = ACTIONS(311),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(311),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(311),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(311),
    [anon_sym_BSLASHacs] = ACTIONS(311),
    [anon_sym_BSLASHAcs] = ACTIONS(311),
    [anon_sym_BSLASHacsp] = ACTIONS(311),
    [anon_sym_BSLASHAcsp] = ACTIONS(311),
    [anon_sym_BSLASHacl] = ACTIONS(311),
    [anon_sym_BSLASHAcl] = ACTIONS(311),
    [anon_sym_BSLASHaclp] = ACTIONS(311),
    [anon_sym_BSLASHAclp] = ACTIONS(311),
    [anon_sym_BSLASHacf] = ACTIONS(311),
    [anon_sym_BSLASHAcf] = ACTIONS(311),
    [anon_sym_BSLASHacfp] = ACTIONS(311),
    [anon_sym_BSLASHAcfp] = ACTIONS(311),
    [anon_sym_BSLASHac] = ACTIONS(311),
    [anon_sym_BSLASHAc] = ACTIONS(311),
    [anon_sym_BSLASHacp] = ACTIONS(311),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(311),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(311),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(311),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(311),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(311),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(311),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(311),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(313),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(315),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(313),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(315),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(317),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(319),
    [anon_sym_BSLASHcolor] = ACTIONS(321),
    [anon_sym_BSLASHpagecolor] = ACTIONS(321),
    [anon_sym_BSLASHtextcolor] = ACTIONS(321),
    [anon_sym_BSLASHmathcolor] = ACTIONS(321),
    [anon_sym_BSLASHcolorbox] = ACTIONS(321),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(323),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(323),
    [anon_sym_BSLASHurl] = ACTIONS(325),
    [anon_sym_BSLASHhref] = ACTIONS(325),
  },
  [9] = {
    [sym_block_comment] = STATE(10),
    [sym__root_content] = STATE(10),
    [sym__flat_content] = STATE(10),
    [sym__text_with_env_content] = STATE(10),
    [sym__text_content] = STATE(10),
    [sym__section] = STATE(10),
    [sym__paragraph] = STATE(10),
    [sym__part_declaration] = STATE(157),
    [sym_part] = STATE(444),
    [sym__chapter_declaration] = STATE(158),
    [sym_chapter] = STATE(369),
    [sym__section_declaration] = STATE(168),
    [sym_section] = STATE(370),
    [sym__subsection_declaration] = STATE(180),
    [sym_subsection] = STATE(371),
    [sym__subsubsection_declaration] = STATE(189),
    [sym_subsubsection] = STATE(372),
    [sym__paragraph_declaration] = STATE(207),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(209),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(218),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(10),
    [sym_text] = STATE(10),
    [sym_operator] = STATE(625),
    [sym_subscript] = STATE(625),
    [sym_superscript] = STATE(625),
    [sym__math_content] = STATE(10),
    [sym_displayed_equation] = STATE(10),
    [sym_inline_formula] = STATE(10),
    [sym_math_delimiter] = STATE(10),
    [sym_text_mode] = STATE(10),
    [sym_begin] = STATE(55),
    [sym_generic_environment] = STATE(10),
    [sym_comment_environment] = STATE(10),
    [sym__comment_environment_begin] = STATE(3767),
    [sym_verbatim_environment] = STATE(10),
    [sym__verbatim_environment_begin] = STATE(3768),
    [sym_listing_environment] = STATE(10),
    [sym__listing_environment_begin] = STATE(3769),
    [sym_minted_environment] = STATE(10),
    [sym__minted_environment_begin] = STATE(3770),
    [sym_asy_environment] = STATE(10),
    [sym__asy_e