# encoding: UTF-8
# frozen_string_literal: true

# This file contains data derived from the IANA Time Zone Database
# (https://www.iana.org/time-zones).

module TZInfo
  module Data
    module Indexes
      module Timezones
        include Format2::TimezoneIndexDefinition

        timezone_index do |i|
          i.data_timezone 'Africa/Abidjan'
          i.data_timezone 'Africa/Accra'
          i.linked_timezone 'Africa/Addis_Ababa'
          i.data_timezone 'Africa/Algiers'
          i.linked_timezone 'Africa/Asmara'
          i.linked_timezone 'Africa/Asmera'
          i.linked_timezone 'Africa/Bamako'
          i.linked_timezone 'Africa/Bangui'
          i.linked_timezone 'Africa/Banjul'
          i.data_timezone 'Africa/Bissau'
          i.linked_timezone 'Africa/Blantyre'
          i.linked_timezone 'Africa/Brazzaville'
          i.linked_timezone 'Africa/Bujumbura'
          i.data_timezone 'Africa/Cairo'
          i.data_timezone 'Africa/Casablanca'
          i.data_timezone 'Africa/Ceuta'
          i.linked_timezone 'Africa/Conakry'
          i.linked_timezone 'Africa/Dakar'
          i.linked_timezone 'Africa/Dar_es_Salaam'
          i.linked_timezone 'Africa/Djibouti'
          i.linked_timezone 'Africa/Douala'
          i.data_timezone 'Africa/El_Aaiun'
          i.linked_timezone 'Africa/Freetown'
          i.linked_timezone 'Africa/Gaborone'
          i.linked_timezone 'Africa/Harare'
          i.data_timezone 'Africa/Johannesburg'
          i.data_timezone 'Africa/Juba'
          i.linked_timezone 'Africa/Kampala'
          i.data_timezone 'Africa/Khartoum'
          i.linked_timezone 'Africa/Kigali'
          i.linked_timezone 'Africa/Kinshasa'
          i.data_timezone 'Africa/Lagos'
          i.linked_timezone 'Africa/Libreville'
          i.linked_timezone 'Africa/Lome'
          i.linked_timezone 'Africa/Luanda'
          i.linked_timezone 'Africa/Lubumbashi'
          i.linked_timezone 'Africa/Lusaka'
          i.linked_timezone 'Africa/Malabo'
          i.data_timezone 'Africa/Maputo'
          i.linked_timezone 'Africa/Maseru'
          i.linked_timezone 'Africa/Mbabane'
          i.linked_timezone 'Africa/Mogadishu'
          i.data_timezone 'Africa/Monrovia'
          i.data_timezone 'Africa/Nairobi'
          i.data_timezone 'Africa/Ndjamena'
          i.linked_timezone 'Africa/Niamey'
          i.linked_timezone 'Africa/Nouakchott'
          i.linked_timezone 'Africa/Ouagadougou'
          i.linked_timezone 'Africa/Porto-Novo'
          i.data_timezone 'Africa/Sao_Tome'
          i.linked_timezone 'Africa/Timbuktu'
          i.data_timezone 'Africa/Tripoli'
          i.data_timezone 'Africa/Tunis'
          i.data_timezone 'Africa/Windhoek'
          i.data_timezone 'America/Adak'
          i.data_timezone 'America/Anchorage'
          i.linked_timezone 'America/Anguilla'
          i.linked_timezone 'America/Antigua'
          i.data_timezone 'America/Araguaina'
          i.data_timezone 'America/Argentina/Buenos_Aires'
          i.data_timezone 'America/Argentina/Catamarca'
          i.linked_timezone 'America/Argentina/ComodRivadavia'
          i.data_timezone 'America/Argentina/Cordoba'
          i.data_timezone 'America/Argentina/Jujuy'
          i.data_timezone 'America/Argentina/La_Rioja'
          i.data_timezone 'America/Argentina/Mendoza'
          i.data_timezone 'America/Argentina/Rio_Gallegos'
          i.data_timezone 'America/Argentina/Salta'
          i.data_timezone 'America/Argentina/San_Juan'
          i.data_timezone 'America/Argentina/San_Luis'
          i.data_timezone 'America/Argentina/Tucuman'
          i.data_timezone 'America/Argentina/Ushuaia'
          i.linked_timezone 'America/Aruba'
          i.data_timezone 'America/Asuncion'
          i.data_timezone 'America/Atikokan'
          i.linked_timezone 'America/Atka'
          i.data_timezone 'America/Bahia'
          i.data_timezone 'America/Bahia_Banderas'
          i.data_timezone 'America/Barbados'
          i.data_timezone 'America/Belem'
          i.data_timezone 'America/Belize'
          i.data_timezone 'America/Blanc-Sablon'
          i.data_timezone 'America/Boa_Vista'
          i.data_timezone 'America/Bogota'
          i.data_timezone 'America/Boise'
          i.linked_timezone 'America/Buenos_Aires'
          i.data_timezone 'America/Cambridge_Bay'
          i.data_timezone 'America/Campo_Grande'
          i.data_timezone 'America/Cancun'
          i.data_timezone 'America/Caracas'
          i.linked_timezone 'America/Catamarca'
          i.data_timezone 'America/Cayenne'
          i.linked_timezone 'America/Cayman'
          i.data_timezone 'America/Chicago'
          i.data_timezone 'America/Chihuahua'
          i.linked_timezone 'America/Coral_Harbour'
          i.linked_timezone 'America/Cordoba'
          i.data_timezone 'America/Costa_Rica'
          i.data_timezone 'America/Creston'
          i.data_timezone 'America/Cuiaba'
          i.data_timezone 'America/Curacao'
          i.data_timezone 'America/Danmarkshavn'
          i.data_timezone 'America/Dawson'
          i.data_timezone 'America/Dawson_Creek'
          i.data_timezone 'America/Denver'
          i.data_timezone 'America/Detroit'
          i.linked_timezone 'America/Dominica'
          i.data_timezone 'America/Edmonton'
          i.data_timezone 'America/Eirunepe'
          i.data_timezone 'America/El_Salvador'
          i.linked_timezone 'America/Ensenada'
          i.data_timezone 'America/Fort_Nelson'
          i.linked_timezone 'America/Fort_Wayne'
          i.data_timezone 'America/Fortaleza'
          i.data_timezone 'America/Glace_Bay'
          i.linked_timezone 'America/Godthab'
          i.data_timezone 'America/Goose_Bay'
          i.data_timezone 'America/Grand_Turk'
          i.linked_timezone 'America/Grenada'
          i.linked_timezone 'America/Guadeloupe'
          i.data_timezone 'America/Guatemala'
          i.data_timezone 'America/Guayaquil'
          i.data_timezone 'America/Guyana'
          i.data_timezone 'America/Halifax'
          i.data_timezone 'America/Havana'
          i.data_timezone 'America/Hermosillo'
          i.data_timezone 'America/Indiana/Indianapolis'
          i.data_timezone 'America/Indiana/Knox'
          i.data_timezone 'America/Indiana/Marengo'
          i.data_timezone 'America/Indiana/Petersburg'
          i.data_timezone 'America/Indiana/Tell_City'
          i.data_timezone 'America/Indiana/Vevay'
          i.data_timezone 'America/Indiana/Vincennes'
          i.data_timezone 'America/Indiana/Winamac'
          i.linked_timezone 'America/Indianapolis'
          i.data_timezone 'America/Inuvik'
          i.data_timezone 'America/Iqaluit'
          i.data_timezone 'America/Jamaica'
          i.linked_timezone 'America/Jujuy'
          i.data_timezone 'America/Juneau'
          i.data_timezone 'America/Kentucky/Louisville'
          i.data_timezone 'America/Kentucky/Monticello'
          i.linked_timezone 'America/Knox_IN'
          i.linked_timezone 'America/Kralendijk'
          i.data_timezone 'America/La_Paz'
          i.data_timezone 'America/Lima'
          i.data_timezone 'America/Los_Angeles'
          i.linked_timezone 'America/Louisville'
          i.linked_timezone 'America/Lower_Princes'
          i.data_timezone 'America/Maceio'
          i.data_timezone 'America/Managua'
          i.data_timezone 'America/Manaus'
          i.linked_timezone 'America/Marigot'
          i.data_timezone 'America/Martinique'
          i.data_timezone 'America/Matamoros'
          i.data_timezone 'America/Mazatlan'
          i.linked_timezone 'America/Mendoza'
          i.data_timezone 'America/Menominee'
          i.data_timezone 'America/Merida'
          i.data_timezone 'America/Metlakatla'
          i.data_timezone 'America/Mexico_City'
          i.data_timezone 'America/Miquelon'
          i.data_timezone 'America/Moncton'
          i.data_timezone 'America/Monterrey'
          i.data_timezone 'America/Montevideo'
          i.linked_timezone 'America/Montreal'
          i.linked_timezone 'America/Montserrat'
          i.data_timezone 'America/Nassau'
          i.data_timezone 'America/New_York'
          i.data_timezone 'America/Nipigon'
          i.data_timezone 'America/Nome'
          i.data_timezone 'America/Noronha'
          i.data_timezone 'America/North_Dakota/Beulah'
          i.data_timezone 'America/North_Dakota/Center'
          i.data_timezone 'America/North_Dakota/New_Salem'
          i.data_timezone 'America/Nuuk'
          i.data_timezone 'America/Ojinaga'
          i.data_timezone 'America/Panama'
          i.data_timezone 'America/Pangnirtung'
          i.data_timezone 'America/Paramaribo'
          i.data_timezone 'America/Phoenix'
          i.data_timezone 'America/Port-au-Prince'
          i.data_timezone 'America/Port_of_Spain'
          i.linked_timezone 'America/Porto_Acre'
          i.data_timezone 'America/Porto_Velho'
          i.data_timezone 'America/Puerto_Rico'
          i.data_timezone 'America/Punta_Arenas'
          i.data_timezone 'America/Rainy_River'
          i.data_timezone 'America/Rankin_Inlet'
          i.data_timezone 'America/Recife'
          i.data_timezone 'America/Regina'
          i.data_timezone 'America/Resolute'
          i.data_timezone 'America/Rio_Branco'
          i.linked_timezone 'America/Rosario'
          i.linked_timezone 'America/Santa_Isabel'
          i.data_timezone 'America/Santarem'
          i.data_timezone 'America/Santiago'
          i.data_timezone 'America/Santo_Domingo'
          i.data_timezone 'America/Sao_Paulo'
          i.data_timezone 'America/Scoresbysund'
          i.linked_timezone 'America/Shiprock'
          i.data_timezone 'America/Sitka'
          i.linked_timezone 'America/St_Barthelemy'
          i.data_timezone 'America/St_Johns'
          i.linked_timezone 'America/St_Kitts'
          i.linked_timezone 'America/St_Lucia'
          i.linked_timezone 'America/St_Thomas'
          i.linked_timezone 'America/St_Vincent'
          i.data_timezone 'America/Swift_Current'
          i.data_timezone 'America/Tegucigalpa'
          i.data_timezone 'America/Thule'
          i.data_timezone 'America/Thunder_Bay'
          i.data_timezone 'America/Tijuana'
          i.data_timezone 'America/Toronto'
          i.linked_timezone 'America/Tortola'
          i.data_timezone 'America/Vancouver'
          i.linked_timezone 'America/Virgin'
          i.data_timezone 'America/Whitehorse'
          i.data_timezone 'America/Winnipeg'
          i.data_timezone 'America/Yakutat'
          i.data_timezone 'America/Yellowknife'
          i.data_timezone 'Antarctica/Casey'
          i.data_timezone 'Antarctica/Davis'
          i.data_timezone 'Antarctica/DumontDUrville'
          i.data_timezone 'Antarctica/Macquarie'
          i.data_timezone 'Antarctica/Mawson'
          i.linked_timezone 'Antarctica/McMurdo'
          i.data_timezone 'Antarctica/Palmer'
          i.data_timezone 'Antarctica/Rothera'
          i.linked_timezone 'Antarctica/South_Pole'
          i.data_timezone 'Antarctica/Syowa'
          i.data_timezone 'Antarctica/Troll'
          i.data_timezone 'Antarctica/Vostok'
          i.linked_timezone 'Arctic/Longyearbyen'
          i.linked_timezone 'Asia/Aden'
          i.data_timezone 'Asia/Almaty'
          i.data_timezone 'Asia/Amman'
          i.data_timezone 'Asia/Anadyr'
          i.data_timezone 'Asia/Aqtau'
          i.data_timezone 'Asia/Aqtobe'
          i.data_timezone 'Asia/Ashgabat'
          i.linked_timezone 'Asia/Ashkhabad'
          i.data_timezone 'Asia/Atyrau'
          i.data_timezone 'Asia/Baghdad'
          i.linked_timezone 'Asia/Bahrain'
          i.data_timezone 'Asia/Baku'
          i.data_timezone 'Asia/Bangkok'
          i.data_timezone 'Asia/Barnaul'
          i.data_timezone 'Asia/Beirut'
          i.data_timezone 'Asia/Bishkek'
          i.data_timezone 'Asia/Brunei'
          i.linked_timezone 'Asia/Calcutta'
          i.data_timezone 'Asia/Chita'
          i.data_timezone 'Asia/Choibalsan'
          i.linked_timezone 'Asia/Chongqing'
          i.linked_timezone 'Asia/Chungking'
          i.data_timezone 'Asia/Colombo'
          i.linked_timezone 'Asia/Dacca'
          i.data_timezone 'Asia/Damascus'
          i.data_timezone 'Asia/Dhaka'
          i.data_timezone 'Asia/Dili'
          i.data_timezone 'Asia/Dubai'
          i.data_timezone 'Asia/Dushanbe'
          i.data_timezone 'Asia/Famagusta'
          i.data_timezone 'Asia/Gaza'
          i.linked_timezone 'Asia/Harbin'
          i.data_timezone 'Asia/Hebron'
          i.data_timezone 'Asia/Ho_Chi_Minh'
          i.data_timezone 'Asia/Hong_Kong'
          i.data_timezone 'Asia/Hovd'
          i.data_timezone 'Asia/Irkutsk'
          i.linked_timezone 'Asia/Istanbul'
          i.data_timezone 'Asia/Jakarta'
          i.data_timezone 'Asia/Jayapura'
          i.data_timezone 'Asia/Jerusalem'
          i.data_timezone 'Asia/Kabul'
          i.data_timezone 'Asia/Kamchatka'
          i.data_timezone 'Asia/Karachi'
          i.linked_timezone 'Asia/Kashgar'
          i.data_timezone 'Asia/Kathmandu'
          i.linked_timezone 'Asia/Katmandu'
          i.data_timezone 'Asia/Khandyga'
          i.data_timezone 'Asia/Kolkata'
          i.data_timezone 'Asia/Krasnoyarsk'
          i.data_timezone 'Asia/Kuala_Lumpur'
          i.data_timezone 'Asia/Kuching'
          i.linked_timezone 'Asia/Kuwait'
          i.linked_timezone 'Asia/Macao'
          i.data_timezone 'Asia/Macau'
          i.data_timezone 'Asia/Magadan'
          i.data_timezone 'Asia/Makassar'
          i.data_timezone 'Asia/Manila'
          i.linked_timezone 'Asia/Muscat'
          i.data_timezone 'Asia/Nicosia'
          i.data_timezone 'Asia/Novokuznetsk'
          i.data_timezone 'Asia/Novosibirsk'
          i.data_timezone 'Asia/Omsk'
          i.data_timezone 'Asia/Oral'
          i.linked_timezone 'Asia/Phnom_Penh'
          i.data_timezone 'Asia/Pontianak'
          i.data_timezone 'Asia/Pyongyang'
          i.data_timezone 'Asia/Qatar'
          i.data_timezone 'Asia/Qostanay'
          i.data_timezone 'Asia/Qyzylorda'
          i.linked_timezone 'Asia/Rangoon'
          i.data_timezone 'Asia/Riyadh'
          i.linked_timezone 'Asia/Saigon'
          i.data_timezone 'Asia/Sakhalin'
          i.data_timezone 'Asia/Samarkand'
          i.data_timezone 'Asia/Seoul'
          i.data_timezone 'Asia/Shanghai'
          i.data_timezone 'Asia/Singapore'
          i.data_timezone 'Asia/Srednekolymsk'
          i.data_timezone 'Asia/Taipei'
          i.data_timezone 'Asia/Tashkent'
          i.data_timezone 'Asia/Tbilisi'
          i.data_timezone 'Asia/Tehran'
          i.linked_timezone 'Asia/Tel_Aviv'
          i.linked_timezone 'Asia/Thimbu'
          i.data_timezone 'Asia/Thimphu'
          i.data_timezone 'Asia/Tokyo'
          i.data_timezone 'Asia/Tomsk'
          i.linked_timezone 'Asia/Ujung_Pandang'
          i.data_timezone 'Asia/Ulaanbaatar'
          i.linked_timezone 'Asia/Ulan_Bator'
          i.data_timezone 'Asia/Urumqi'
          i.data_timezone 'Asia/Ust-Nera'
          i.linked_timezone 'Asia/Vientiane'
          i.data_timezone 'Asia/Vladivostok'
          i.data_timezone 'Asia/Yakutsk'
          i.data_timezone 'Asia/Yangon'
          i.data_timezone 'Asia/Yekaterinburg'
          i.data_timezone 'Asia/Yerevan'
          i.data_timezone 'Atlantic/Azores'
          i.data_timezone 'Atlantic/Bermuda'
          i.data_timezone 'Atlantic/Canary'
          i.data_timezone 'Atlantic/Cape_Verde'
          i.linked_timezone 'Atlantic/Faeroe'
          i.data_timezone 'Atlantic/Faroe'
          i.linked_timezone 'Atlantic/Jan_Mayen'
          i.data_timezone 'Atlantic/Madeira'
          i.data_timezone 'Atlantic/Reykjavik'
          i.data_timezone 'Atlantic/South_Georgia'
          i.linked_timezone 'Atlantic/St_Helena'
          i.data_timezone 'Atlantic/Stanley'
          i.linked_timezone 'Australia/ACT'
          i.data_timezone 'Australia/Adelaide'
          i.data_timezone 'Australia/Brisbane'
          i.data_timezone 'Australia/Broken_Hill'
          i.linked_timezone 'Australia/Canberra'
          i.data_timezone 'Australia/Currie'
          i.data_timezone 'Australia/Darwin'
          i.data_timezone 'Australia/Eucla'
          i.data_timezone 'Australia/Hobart'
          i.linked_timezone 'Australia/LHI'
          i.data_timezone 'Australia/Lindeman'
          i.data_timezone 'Australia/Lord_Howe'
          i.data_timezone 'Australia/Melbourne'
          i.linked_timezone 'Australia/NSW'
          i.linked_timezone 'Australia/North'
          i.data_timezone 'Australia/Perth'
          i.linked_timezone 'Australia/Queensland'
          i.linked_timezone 'Australia/South'
          i.data_timezone 'Australia/Sydney'
          i.linked_timezone 'Australia/Tasmania'
          i.linked_timezone 'Australia/Victoria'
          i.linked_timezone 'Australia/West'
          i.linked_timezone 'Australia/Yancowinna'
          i.linked_timezone 'Brazil/Acre'
          i.linked_timezone 'Brazil/DeNoronha'
          i.linked_timezone 'Brazil/East'
          i.linked_timezone 'Brazil/West'
          i.data_timezone 'CET'
          i.data_timezone 'CST6CDT'
          i.linked_timezone 'Canada/Atlantic'
          i.linked_timezone 'Canada/Central'
          i.linked_timezone 'Canada/Eastern'
          i.linked_timezone 'Canada/Mountain'
          i.linked_timezone 'Canada/Newfoundland'
          i.linked_timezone 'Canada/Pacific'
          i.linked_timezone 'Canada/Saskatchewan'
          i.linked_timezone 'Canada/Yukon'
          i.linked_timezone 'Chile/Continental'
          i.linked_timezone 'Chile/EasterIsland'
          i.linked_timezone 'Cuba'
          i.data_timezone 'EET'
          i.data_timezone 'EST'
          i.data_timezone 'EST5EDT'
          i.linked_timezone 'Egypt'
          i.linked_timezone 'Eire'
          i.data_timezone 'Etc/GMT'
          i.linked_timezone 'Etc/GMT+0'
          i.data_timezone 'Etc/GMT+1'
          i.data_timezone 'Etc/GMT+10'
          i.data_timezone 'Etc/GMT+11'
          i.data_timezone 'Etc/GMT+12'
          i.data_timezone 'Etc/GMT+2'
          i.data_timezone 'Etc/GMT+3'
          i.data_timezone 'Etc/GMT+4'
          i.data_timezone 'Etc/GMT+5'
          i.data_timezone 'Etc/GMT+6'
          i.data_timezone 'Etc/GMT+7'
          i.data_timezone 'Etc/GMT+8'
          i.data_timezone 'Etc/GMT+9'
          i.linked_timezone 'Etc/GMT-0'
          i.data_timezone 'Etc/GMT-1'
          i.data_timezone 'Etc/GMT-10'
          i.data_timezone 'Etc/GMT-11'
          i.data_timezone 'Etc/GMT-12'
          i.data_timezone 'Etc/GMT-13'
          i.data_timezone 'Etc/GMT-14'
          i.data_timezone 'Etc/GMT-2'
          i.data_timezone 'Etc/GMT-3'
          i.data_timezone 'Etc/GMT-4'
          i.data_timezone 'Etc/GMT-5'
          i.data_timezone 'Etc/GMT-6'
          i.data_timezone 'Etc/GMT-7'
          i.data_timezone 'Etc/GMT-8'
          i.data_timezone 'Etc/GMT-9'
          i.linked_timezone 'Etc/GMT0'
          i.linked_timezone 'Etc/Greenwich'
          i.linked_timezone 'Etc/UCT'
          i.data_timezone 'Etc/UTC'
          i.linked_timezone 'Etc/Universal'
          i.linked_timezone 'Etc/Zulu'
          i.data_timezone 'Europe/Amsterdam'
          i.data_timezone 'Europe/Andorra'
          i.data_timezone 'Europe/Astrakhan'
          i.data_timezone 'Europe/Athens'
          i.linked_timezone 'Europe/Belfast'
          i.data_timezone 'Europe/Belgrade'
          i.data_timezone 'Europe/Berlin'
          i.linked_timezone 'Europe/Bratislava'
          i.data_timezone 'Europe/Brussels'
          i.data_timezone 'Europe/Bucharest'
          i.data_timezone 'Europe/Budapest'
          i.linked_timezone 'Europe/Busingen'
          i.data_timezone 'Europe/Chisinau'
          i.data_timezone 'Europe/Copenhagen'
          i.data_timezone 'Europe/Dublin'
          i.data_timezone 'Europe/Gibraltar'
          i.linked_timezone 'Europe/Guernsey'
          i.data_timezone 'Europe/Helsinki'
          i.linked_timezone 'Europe/Isle_of_Man'
          i.data_timezone 'Europe/Istanbul'
          i.linked_timezone 'Europe/Jersey'
          i.data_timezone 'Europe/Kaliningrad'
          i.data_timezone 'Europe/Kiev'
          i.data_timezone 'Europe/Kirov'
          i.data_timezone 'Europe/Lisbon'
          i.linked_timezone 'Europe/Ljubljana'
          i.data_timezone 'Europe/London'
          i.data_timezone 'Europe/Luxembourg'
          i.data_timezone 'Europe/Madrid'
          i.data_timezone 'Europe/Malta'
          i.linked_timezone 'Europe/Mariehamn'
          i.data_timezone 'Europe/Minsk'
          i.data_timezone 'Europe/Monaco'
          i.data_timezone 'Europe/Moscow'
          i.linked_timezone 'Europe/Nicosia'
          i.data_timezone 'Europe/Oslo'
          i.data_timezone 'Europe/Paris'
          i.linked_timezone 'Europe/Podgorica'
          i.data_timezone 'Europe/Prague'
          i.data_timezone 'Europe/Riga'
          i.data_timezone 'Europe/Rome'
          i.data_timezone 'Europe/Samara'
          i.linked_timezone 'Europe/San_Marino'
          i.linked_timezone 'Europe/Sarajevo'
          i.data_timezone 'Europe/Saratov'
          i.data_timezone 'Europe/Simferopol'
          i.linked_timezone 'Europe/Skopje'
          i.data_timezone 'Europe/Sofia'
          i.data_timezone 'Europe/Stockholm'
          i.data_timezone 'Europe/Tallinn'
          i.data_timezone 'Europe/Tirane'
          i.linked_timezone 'Europe/Tiraspol'
          i.data_timezone 'Europe/Ulyanovsk'
          i.data_timezone 'Europe/Uzhgorod'
          i.linked_timezone 'Europe/Vaduz'
          i.linked_timezone 'Europe/Vatican'
          i.data_timezone 'Europe/Vienna'
          i.data_timezone 'Europe/Vilnius'
          i.data_timezone 'Europe/Volgograd'
          i.data_timezone 'Europe/Warsaw'
          i.linked_timezone 'Europe/Zagreb'
          i.data_timezone 'Europe/Zaporozhye'
          i.data_timezone 'Europe/Zurich'
          i.data_timezone 'Factory'
          i.linked_timezone 'GB'
          i.linked_timezone 'GB-Eire'
          i.linked_timezone 'GMT'
          i.linked_timezone 'GMT+0'
          i.linked_timezone 'GMT-0'
          i.linked_timezone 'GMT0'
          i.linked_timezone 'Greenwich'
          i.data_timezone 'HST'
          i.linked_timezone 'Hongkong'
          i.linked_timezone 'Iceland'
          i.linked_timezone 'Indian/Antananarivo'
          i.data_timezone 'Indian/Chagos'
          i.data_timezone 'Indian/Christmas'
          i.data_timezone 'Indian/Cocos'
          i.linked_timezone 'Indian/Comoro'
          i.data_timezone 'Indian/Kerguelen'
          i.data_timezone 'Indian/Mahe'
          i.data_timezone 'Indian/Maldives'
          i.data_timezone 'Indian/Mauritius'
          i.linked_timezone 'Indian/Mayotte'
          i.data_timezone 'Indian/Reunion'
          i.linked_timezone 'Iran'
          i.linked_timezone 'Israel'
          i.linked_timezone 'Jamaica'
          i.linked_timezone 'Japan'
          i.linked_timezone 'Kwajalein'
          i.linked_timezone 'Libya'
          i.data_timezone 'MET'
          i.data_timezone 'MST'
          i.data_timezone 'MST7MDT'
          i.linked_timezone 'Mexico/BajaNorte'
          i.linked_timezone 'Mexico/BajaSur'
          i.linked_timezone 'Mexico/General'
          i.linked_timezone 'NZ'
          i.linked_timezone 'NZ-CHAT'
          i.linked_timezone 'Navajo'
          i.linked_timezone 'PRC'
          i.data_timezone 'PST8PDT'
          i.data_timezone 'Pacific/Apia'
          i.data_timezone 'Pacific/Auckland'
          i.data_timezone 'Pacific/Bougainville'
          i.data_timezone 'Pacific/Chatham'
          i.data_timezone 'Pacific/Chuuk'
          i.data_timezone 'Pacific/Easter'
          i.data_timezone 'Pacific/Efate'
          i.data_timezone 'Pacific/Enderbury'
          i.data_timezone 'Pacific/Fakaofo'
          i.data_timezone 'Pacific/Fiji'
          i.data_timezone 'Pacific/Funafuti'
          i.data_timezone 'Pacific/Galapagos'
          i.data_timezone 'Pacific/Gambier'
          i.data_timezone 'Pacific/Guadalcanal'
          i.data_timezone 'Pacific/Guam'
          i.data_timezone 'Pacific/Honolulu'
          i.linked_timezone 'Pacific/Johnston'
          i.data_timezone 'Pacific/Kiritimati'
          i.data_timezone 'Pacific/Kosrae'
          i.data_timezone 'Pacific/Kwajalein'
          i.data_timezone 'Pacific/Majuro'
          i.data_timezone 'Pacific/Marquesas'
          i.linked_timezone 'Pacific/Midway'
          i.data_timezone 'Pacific/Nauru'
          i.data_timezone 'Pacific/Niue'
          i.data_timezone 'Pacific/Norfolk'
          i.data_timezone 'Pacific/Noumea'
          i.data_timezone 'Pacific/Pago_Pago'
          i.data_timezone 'Pacific/Palau'
          i.data_timezone 'Pacific/Pitcairn'
          i.data_timezone 'Pacific/Pohnpei'
          i.linked_timezone 'Pacific/Ponape'
          i.data_timezone 'Pacific/Port_Moresby'
          i.data_timezone 'Pacific/Rarotonga'
          i.linked_timezone 'Pacific/Saipan'
          i.linked_timezone 'Pacific/Samoa'
          i.data_timezone 'Pacific/Tahiti'
          i.data_timezone 'Pacific/Tarawa'
          i.data_timezone 'Pacific/Tongatapu'
          i.linked_timezone 'Pacific/Truk'
          i.data_timezone 'Pacific/Wake'
          i.data_timezone 'Pacific/Wallis'
          i.linked_timezone 'Pacific/Yap'
          i.linked_timezone 'Poland'
          i.linked_timezone 'Portugal'
          i.linked_timezone 'ROC'
          i.linked_timezone 'ROK'
          i.linked_timezone 'Singapore'
          i.linked_timezone 'Turkey'
          i.linked_timezone 'UCT'
          i.linked_timezone 'US/Alaska'
          i.linked_timezone 'US/Aleutian'
          i.linked_timezone 'US/Arizona'
          i.linked_timezone 'US/Central'
          i.linked_timezone 'US/East-Indiana'
          i.linked_timezone 'US/Eastern'
          i.linked_timezone 'US/Hawaii'
          i.linked_timezone 'US/Indiana-Starke'
          i.linked_timezone 'US/Michigan'
          i.linked_timezone 'US/Mountain'
          i.linked_timezone 'US/Pacific'
          i.linked_timezone 'US/Samoa'
          i.linked_timezone 'UTC'
          i.linked_timezone 'Universal'
          i.linked_timezone 'W-SU'
          i.data_timezone 'WET'
          i.linked_timezone 'Zulu'
        end
      end
    end
  end
end
