#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 800
#define LARGE_STATE_COUNT 307
#define SYMBOL_COUNT 507
#define ALIAS_COUNT 3
#define TOKEN_COUNT 320
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 33
#define MAX_ALIAS_SEQUENCE_LENGTH 12
#define PRODUCTION_ID_COUNT 85

enum {
  sym_identifier = 1,
  anon_sym_pragma = 2,
  anon_sym_PIPE_PIPE = 3,
  anon_sym_DASH = 4,
  anon_sym_solidity = 5,
  aux_sym_pragma_value_token1 = 6,
  sym_solidity_version = 7,
  anon_sym_LT_EQ = 8,
  anon_sym_LT = 9,
  anon_sym_CARET = 10,
  anon_sym_GT = 11,
  anon_sym_GT_EQ = 12,
  anon_sym_TILDE = 13,
  anon_sym_EQ = 14,
  anon_sym_import = 15,
  anon_sym_from = 16,
  anon_sym_STAR = 17,
  anon_sym_LBRACE = 18,
  anon_sym_COMMA = 19,
  anon_sym_RBRACE = 20,
  anon_sym_as = 21,
  anon_sym_type = 22,
  anon_sym_is = 23,
  anon_sym_constant = 24,
  anon_sym_abstract = 25,
  anon_sym_contract = 26,
  anon_sym_error = 27,
  anon_sym_LPAREN = 28,
  anon_sym_RPAREN = 29,
  anon_sym_interface = 30,
  anon_sym_library = 31,
  anon_sym_struct = 32,
  anon_sym_enum = 33,
  anon_sym_event = 34,
  anon_sym_anonymous = 35,
  anon_sym_indexed = 36,
  anon_sym_using = 37,
  anon_sym_for = 38,
  anon_sym_assembly = 39,
  anon_sym_DQUOTEevmasm_DQUOTE = 40,
  anon_sym_COLON = 41,
  sym_yul_leave = 42,
  anon_sym_break = 43,
  anon_sym_continue = 44,
  anon_sym_DOT = 45,
  sym_yul_decimal_number = 46,
  sym_yul_hex_number = 47,
  anon_sym_true = 48,
  anon_sym_false = 49,
  anon_sym_let = 50,
  anon_sym_COLON_EQ = 51,
  anon_sym_if = 52,
  anon_sym_switch = 53,
  anon_sym_default = 54,
  anon_sym_case = 55,
  anon_sym_function = 56,
  anon_sym_DASH_GT = 57,
  anon_sym_stop = 58,
  anon_sym_add = 59,
  anon_sym_sub = 60,
  anon_sym_mul = 61,
  anon_sym_div = 62,
  anon_sym_sdiv = 63,
  anon_sym_mod = 64,
  anon_sym_smod = 65,
  anon_sym_exp = 66,
  anon_sym_not = 67,
  anon_sym_lt = 68,
  anon_sym_gt = 69,
  anon_sym_slt = 70,
  anon_sym_sgt = 71,
  anon_sym_eq = 72,
  anon_sym_iszero = 73,
  anon_sym_and = 74,
  anon_sym_or = 75,
  anon_sym_xor = 76,
  anon_sym_byte = 77,
  anon_sym_shl = 78,
  anon_sym_shr = 79,
  anon_sym_sar = 80,
  anon_sym_addmod = 81,
  anon_sym_mulmod = 82,
  anon_sym_signextend = 83,
  anon_sym_keccak256 = 84,
  anon_sym_pop = 85,
  anon_sym_mload = 86,
  anon_sym_mstore = 87,
  anon_sym_mstore8 = 88,
  anon_sym_sload = 89,
  anon_sym_sstore = 90,
  anon_sym_msize = 91,
  anon_sym_gas = 92,
  anon_sym_address = 93,
  anon_sym_balance = 94,
  anon_sym_selfbalance = 95,
  anon_sym_caller = 96,
  anon_sym_callvalue = 97,
  anon_sym_calldataload = 98,
  anon_sym_calldatasize = 99,
  anon_sym_calldatacopy = 100,
  anon_sym_extcodesize = 101,
  anon_sym_extcodecopy = 102,
  anon_sym_returndatasize = 103,
  anon_sym_returndatacopy = 104,
  anon_sym_extcodehash = 105,
  anon_sym_create = 106,
  anon_sym_create2 = 107,
  anon_sym_call = 108,
  anon_sym_callcode = 109,
  anon_sym_delegatecall = 110,
  anon_sym_staticcall = 111,
  anon_sym_return = 112,
  anon_sym_revert = 113,
  anon_sym_selfdestruct = 114,
  anon_sym_invalid = 115,
  anon_sym_log0 = 116,
  anon_sym_log1 = 117,
  anon_sym_log2 = 118,
  anon_sym_log3 = 119,
  anon_sym_log4 = 120,
  anon_sym_chainid = 121,
  anon_sym_origin = 122,
  anon_sym_gasprice = 123,
  anon_sym_blockhash = 124,
  anon_sym_coinbase = 125,
  anon_sym_timestamp = 126,
  anon_sym_number = 127,
  anon_sym_difficulty = 128,
  anon_sym_gaslimit = 129,
  sym__unchecked = 130,
  anon_sym_memory = 131,
  anon_sym_storage = 132,
  anon_sym_calldata = 133,
  anon_sym_var = 134,
  anon_sym_else = 135,
  anon_sym_while = 136,
  anon_sym_do = 137,
  anon_sym_try = 138,
  anon_sym_returns = 139,
  anon_sym_catch = 140,
  anon_sym_emit = 141,
  anon_sym_public = 142,
  anon_sym_internal = 143,
  anon_sym_private = 144,
  anon_sym_external = 145,
  anon_sym_pure = 146,
  anon_sym_view = 147,
  anon_sym_payable = 148,
  sym_immutable = 149,
  anon_sym_override = 150,
  anon_sym_modifier = 151,
  anon_sym_constructor = 152,
  anon_sym_fallback = 153,
  anon_sym_receive = 154,
  sym_virtual = 155,
  anon_sym_QMARK = 156,
  anon_sym_new = 157,
  anon_sym_LBRACK = 158,
  anon_sym_RBRACK = 159,
  anon_sym_AMP_AMP = 160,
  anon_sym_GT_GT = 161,
  anon_sym_GT_GT_GT = 162,
  anon_sym_LT_LT = 163,
  anon_sym_AMP = 164,
  anon_sym_PIPE = 165,
  anon_sym_PLUS = 166,
  anon_sym_SLASH = 167,
  anon_sym_PERCENT = 168,
  anon_sym_STAR_STAR = 169,
  anon_sym_EQ_EQ = 170,
  anon_sym_BANG_EQ = 171,
  anon_sym_BANG_EQ_EQ = 172,
  anon_sym_BANG = 173,
  anon_sym_delete = 174,
  anon_sym_PLUS_PLUS = 175,
  anon_sym_DASH_DASH = 176,
  anon_sym_PLUS_EQ = 177,
  anon_sym_DASH_EQ = 178,
  anon_sym_STAR_EQ = 179,
  anon_sym_SLASH_EQ = 180,
  anon_sym_PERCENT_EQ = 181,
  anon_sym_CARET_EQ = 182,
  anon_sym_AMP_EQ = 183,
  anon_sym_PIPE_EQ = 184,
  anon_sym_GT_GT_EQ = 185,
  anon_sym_GT_GT_GT_EQ = 186,
  anon_sym_LT_LT_EQ = 187,
  anon_sym_mapping = 188,
  anon_sym_EQ_GT = 189,
  anon_sym_bool = 190,
  anon_sym_string = 191,
  anon_sym_int = 192,
  anon_sym_int8 = 193,
  anon_sym_int16 = 194,
  anon_sym_int24 = 195,
  anon_sym_int32 = 196,
  anon_sym_int40 = 197,
  anon_sym_int48 = 198,
  anon_sym_int56 = 199,
  anon_sym_int64 = 200,
  anon_sym_int72 = 201,
  anon_sym_int80 = 202,
  anon_sym_int88 = 203,
  anon_sym_int96 = 204,
  anon_sym_int104 = 205,
  anon_sym_int112 = 206,
  anon_sym_int120 = 207,
  anon_sym_int128 = 208,
  anon_sym_int136 = 209,
  anon_sym_int144 = 210,
  anon_sym_int152 = 211,
  anon_sym_int160 = 212,
  anon_sym_int168 = 213,
  anon_sym_int176 = 214,
  anon_sym_int184 = 215,
  anon_sym_int192 = 216,
  anon_sym_int200 = 217,
  anon_sym_int208 = 218,
  anon_sym_int216 = 219,
  anon_sym_int224 = 220,
  anon_sym_int232 = 221,
  anon_sym_int240 = 222,
  anon_sym_int248 = 223,
  anon_sym_int256 = 224,
  anon_sym_uint = 225,
  anon_sym_uint8 = 226,
  anon_sym_uint16 = 227,
  anon_sym_uint24 = 228,
  anon_sym_uint32 = 229,
  anon_sym_uint40 = 230,
  anon_sym_uint48 = 231,
  anon_sym_uint56 = 232,
  anon_sym_uint64 = 233,
  anon_sym_uint72 = 234,
  anon_sym_uint80 = 235,
  anon_sym_uint88 = 236,
  anon_sym_uint96 = 237,
  anon_sym_uint104 = 238,
  anon_sym_uint112 = 239,
  anon_sym_uint120 = 240,
  anon_sym_uint128 = 241,
  anon_sym_uint136 = 242,
  anon_sym_uint144 = 243,
  anon_sym_uint152 = 244,
  anon_sym_uint160 = 245,
  anon_sym_uint168 = 246,
  anon_sym_uint176 = 247,
  anon_sym_uint184 = 248,
  anon_sym_uint192 = 249,
  anon_sym_uint200 = 250,
  anon_sym_uint208 = 251,
  anon_sym_uint216 = 252,
  anon_sym_uint224 = 253,
  anon_sym_uint232 = 254,
  anon_sym_uint240 = 255,
  anon_sym_uint248 = 256,
  anon_sym_uint256 = 257,
  anon_sym_bytes = 258,
  anon_sym_bytes1 = 259,
  anon_sym_bytes2 = 260,
  anon_sym_bytes3 = 261,
  anon_sym_bytes4 = 262,
  anon_sym_bytes5 = 263,
  anon_sym_bytes6 = 264,
  anon_sym_bytes7 = 265,
  anon_sym_bytes8 = 266,
  anon_sym_bytes9 = 267,
  anon_sym_bytes10 = 268,
  anon_sym_bytes11 = 269,
  anon_sym_bytes12 = 270,
  anon_sym_bytes13 = 271,
  anon_sym_bytes14 = 272,
  anon_sym_bytes15 = 273,
  anon_sym_bytes16 = 274,
  anon_sym_bytes17 = 275,
  anon_sym_bytes18 = 276,
  anon_sym_bytes19 = 277,
  anon_sym_bytes20 = 278,
  anon_sym_bytes21 = 279,
  anon_sym_bytes22 = 280,
  anon_sym_bytes23 = 281,
  anon_sym_bytes24 = 282,
  anon_sym_bytes25 = 283,
  anon_sym_bytes26 = 284,
  anon_sym_bytes27 = 285,
  anon_sym_bytes28 = 286,
  anon_sym_bytes29 = 287,
  anon_sym_bytes30 = 288,
  anon_sym_bytes31 = 289,
  anon_sym_bytes32 = 290,
  anon_sym_fixed = 291,
  aux_sym__fixed_token1 = 292,
  anon_sym_ufixed = 293,
  aux_sym__ufixed_token1 = 294,
  sym__semicolon = 295,
  aux_sym__decimal_number_token1 = 296,
  aux_sym__decimal_number_token2 = 297,
  aux_sym__hex_number_token1 = 298,
  sym__hex_digit = 299,
  anon_sym_wei = 300,
  anon_sym_szabo = 301,
  anon_sym_finney = 302,
  anon_sym_gwei = 303,
  anon_sym_ether = 304,
  anon_sym_seconds = 305,
  anon_sym_minutes = 306,
  anon_sym_hours = 307,
  anon_sym_days = 308,
  anon_sym_weeks = 309,
  anon_sym_years = 310,
  anon_sym_hex = 311,
  anon_sym_DQUOTE = 312,
  anon_sym__ = 313,
  anon_sym_SQUOTE = 314,
  sym__escape_sequence = 315,
  aux_sym__single_quoted_unicode_char_token1 = 316,
  aux_sym__double_quoted_unicode_char_token1 = 317,
  anon_sym_unicode = 318,
  sym_comment = 319,
  sym_source_file = 320,
  sym__source_unit = 321,
  sym__directive = 322,
  sym_pragma_directive = 323,
  sym_solidity_pragma_token = 324,
  sym_any_pragma_token = 325,
  sym__solidity = 326,
  sym_pragma_value = 327,
  sym__pragma_version_constraint = 328,
  sym_solidity_version_comparison_operator = 329,
  sym_import_directive = 330,
  sym__source_import = 331,
  sym__import_clause = 332,
  sym__from_clause = 333,
  sym__single_import = 334,
  sym__multiple_import = 335,
  sym__import_declaration = 336,
  sym__import_alias = 337,
  sym__declaration = 338,
  sym_user_defined_type_definition = 339,
  sym_constant_variable_declaration = 340,
  sym_contract_declaration = 341,
  sym_error_declaration = 342,
  sym_error_parameter = 343,
  sym_interface_declaration = 344,
  sym_library_declaration = 345,
  sym__class_heritage = 346,
  sym_inheritance_specifier = 347,
  sym_contract_body = 348,
  sym__contract_member = 349,
  sym_struct_declaration = 350,
  sym_struct_member = 351,
  sym_enum_declaration = 352,
  sym_event_definition = 353,
  sym__event_parameter_list = 354,
  sym_event_paramater = 355,
  sym_using_directive = 356,
  sym_any_source_type = 357,
  sym__statement = 358,
  sym_assembly_statement = 359,
  sym__yul_statement = 360,
  sym_yul_label = 361,
  sym_yul_break = 362,
  sym_yul_continue = 363,
  sym_yul_identifier = 364,
  sym__yul_expression = 365,
  sym_yul_path = 366,
  sym__yul_literal = 367,
  sym_yul_string_literal = 368,
  sym_yul_boolean = 369,
  sym_yul_block = 370,
  sym_yul_variable_declaration = 371,
  sym__yul_assignment_operator = 372,
  sym_yul_assignment = 373,
  sym_yul_function_call = 374,
  sym_yul_if_statement = 375,
  sym_yul_for_statement = 376,
  sym_yul_switch_statement = 377,
  sym_yul_function_definition = 378,
  sym_yul_evm_builtin = 379,
  sym_block_statement = 380,
  sym_variable_declaration_statement = 381,
  sym_variable_declaration = 382,
  sym_variable_declaration_tuple = 383,
  sym_expression_statement = 384,
  sym_if_statement = 385,
  sym_for_statement = 386,
  sym_while_statement = 387,
  sym_do_while_statement = 388,
  sym_continue_statement = 389,
  sym_break_statement = 390,
  sym_revert_statement = 391,
  sym_try_statement = 392,
  sym_catch_clause = 393,
  sym_return_statement = 394,
  sym_emit_statement = 395,
  sym_state_variable_declaration = 396,
  sym_visibility = 397,
  sym_state_mutability = 398,
  sym_override_specifier = 399,
  sym_modifier_definition = 400,
  sym_constructor_definition = 401,
  sym_fallback_receive_definition = 402,
  sym_function_definition = 403,
  sym_return_type_definition = 404,
  sym_modifier_invocation = 405,
  sym__call_arguments = 406,
  sym_call_argument = 407,
  sym_call_struct_argument = 408,
  sym_function_body = 409,
  sym__expression = 410,
  sym__primary_expression = 411,
  sym_type_cast_expression = 412,
  sym_ternary_expression = 413,
  sym_new_expression = 414,
  sym_tuple_expression = 415,
  sym_inline_array_expression = 416,
  sym_binary_expression = 417,
  sym_unary_expression = 418,
  sym_update_expression = 419,
  sym_member_expression = 420,
  sym_array_access = 421,
  sym_slice_access = 422,
  sym_struct_expression = 423,
  sym_struct_field_assignment = 424,
  sym_parenthesized_expression = 425,
  sym_assignment_expression = 426,
  sym_augmented_assignment_expression = 427,
  sym_call_expression = 428,
  sym_payable_conversion_expression = 429,
  sym_meta_type_expression = 430,
  sym_type_name = 431,
  sym__array_type = 432,
  sym__function_type = 433,
  sym__parameter_list = 434,
  sym__return_parameters = 435,
  sym__nameless_parameter = 436,
  sym_parameter = 437,
  sym__storage_location = 438,
  sym_user_defined_type = 439,
  sym__identifier_path = 440,
  sym__mapping = 441,
  sym__mapping_key = 442,
  sym_primitive_type = 443,
  sym__int = 444,
  sym__uint = 445,
  sym__bytes = 446,
  sym__fixed = 447,
  sym__ufixed = 448,
  sym__literal = 449,
  sym_string_literal = 450,
  sym_number_literal = 451,
  sym__decimal_number = 452,
  sym__hex_number = 453,
  sym_number_unit = 454,
  sym_true = 455,
  sym_false = 456,
  sym_boolean_literal = 457,
  sym_hex_string_literal = 458,
  sym__single_quoted_unicode_char = 459,
  sym__double_quoted_unicode_char = 460,
  sym_unicode_string_literal = 461,
  sym_string = 462,
  sym__string_immediate_elt_inside_double_quote = 463,
  sym__string_immediate_elt_inside_quote = 464,
  aux_sym_source_file_repeat1 = 465,
  aux_sym_solidity_pragma_token_repeat1 = 466,
  aux_sym__multiple_import_repeat1 = 467,
  aux_sym_error_declaration_repeat1 = 468,
  aux_sym__class_heritage_repeat1 = 469,
  aux_sym_contract_body_repeat1 = 470,
  aux_sym_struct_declaration_repeat1 = 471,
  aux_sym_enum_declaration_repeat1 = 472,
  aux_sym__event_parameter_list_repeat1 = 473,
  aux_sym_assembly_statement_repeat1 = 474,
  aux_sym_yul_path_repeat1 = 475,
  aux_sym_yul_variable_declaration_repeat1 = 476,
  aux_sym_yul_assignment_repeat1 = 477,
  aux_sym_yul_function_call_repeat1 = 478,
  aux_sym_yul_switch_statement_repeat1 = 479,
  aux_sym_block_statement_repeat1 = 480,
  aux_sym_variable_declaration_tuple_repeat1 = 481,
  aux_sym_variable_declaration_tuple_repeat2 = 482,
  aux_sym_try_statement_repeat1 = 483,
  aux_sym_state_variable_declaration_repeat1 = 484,
  aux_sym_override_specifier_repeat1 = 485,
  aux_sym_modifier_definition_repeat1 = 486,
  aux_sym_constructor_definition_repeat1 = 487,
  aux_sym_fallback_receive_definition_repeat1 = 488,
  aux_sym_function_definition_repeat1 = 489,
  aux_sym__call_arguments_repeat1 = 490,
  aux_sym_call_argument_repeat1 = 491,
  aux_sym_tuple_expression_repeat1 = 492,
  aux_sym_inline_array_expression_repeat1 = 493,
  aux_sym_struct_expression_repeat1 = 494,
  aux_sym__function_type_repeat1 = 495,
  aux_sym__parameter_list_repeat1 = 496,
  aux_sym__return_parameters_repeat1 = 497,
  aux_sym__identifier_path_repeat1 = 498,
  aux_sym_string_literal_repeat1 = 499,
  aux_sym_hex_string_literal_repeat1 = 500,
  aux_sym_hex_string_literal_repeat2 = 501,
  aux_sym_unicode_string_literal_repeat1 = 502,
  aux_sym_unicode_string_literal_repeat2 = 503,
  aux_sym_unicode_string_literal_repeat3 = 504,
  aux_sym_string_repeat1 = 505,
  aux_sym_string_repeat2 = 506,
  alias_sym_enum_value = 507,
  alias_sym_revert_arguments = 508,
  alias_sym_type_alias = 509,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_pragma] = "pragma",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_DASH] = "-",
  [anon_sym_solidity] = "solidity",
  [aux_sym_pragma_value_token1] = "pragma_value_token1",
  [sym_solidity_version] = "solidity_version",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_CARET] = "^",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_TILDE] = "~",
  [anon_sym_EQ] = "=",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_STAR] = "*",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_type] = "type",
  [anon_sym_is] = "is",
  [anon_sym_constant] = "constant",
  [anon_sym_abstract] = "abstract",
  [anon_sym_contract] = "contract",
  [anon_sym_error] = "error",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_interface] = "interface",
  [anon_sym_library] = "library",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_event] = "event",
  [anon_sym_anonymous] = "anonymous",
  [anon_sym_indexed] = "indexed",
  [anon_sym_using] = "using",
  [anon_sym_for] = "for",
  [anon_sym_assembly] = "assembly",
  [anon_sym_DQUOTEevmasm_DQUOTE] = "\"evmasm\"",
  [anon_sym_COLON] = ":",
  [sym_yul_leave] = "yul_leave",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_DOT] = ".",
  [sym_yul_decimal_number] = "yul_decimal_number",
  [sym_yul_hex_number] = "yul_hex_number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_let] = "let",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_default] = "default",
  [anon_sym_case] = "case",
  [anon_sym_function] = "function",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_stop] = "stop",
  [anon_sym_add] = "add",
  [anon_sym_sub] = "sub",
  [anon_sym_mul] = "mul",
  [anon_sym_div] = "div",
  [anon_sym_sdiv] = "sdiv",
  [anon_sym_mod] = "mod",
  [anon_sym_smod] = "smod",
  [anon_sym_exp] = "exp",
  [anon_sym_not] = "not",
  [anon_sym_lt] = "lt",
  [anon_sym_gt] = "gt",
  [anon_sym_slt] = "slt",
  [anon_sym_sgt] = "sgt",
  [anon_sym_eq] = "eq",
  [anon_sym_iszero] = "iszero",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_xor] = "xor",
  [anon_sym_byte] = "byte",
  [anon_sym_shl] = "shl",
  [anon_sym_shr] = "shr",
  [anon_sym_sar] = "sar",
  [anon_sym_addmod] = "addmod",
  [anon_sym_mulmod] = "mulmod",
  [anon_sym_signextend] = "signextend",
  [anon_sym_keccak256] = "keccak256",
  [anon_sym_pop] = "pop",
  [anon_sym_mload] = "mload",
  [anon_sym_mstore] = "mstore",
  [anon_sym_mstore8] = "mstore8",
  [anon_sym_sload] = "sload",
  [anon_sym_sstore] = "sstore",
  [anon_sym_msize] = "msize",
  [anon_sym_gas] = "gas",
  [anon_sym_address] = "address",
  [anon_sym_balance] = "balance",
  [anon_sym_selfbalance] = "selfbalance",
  [anon_sym_caller] = "caller",
  [anon_sym_callvalue] = "callvalue",
  [anon_sym_calldataload] = "calldataload",
  [anon_sym_calldatasize] = "calldatasize",
  [anon_sym_calldatacopy] = "calldatacopy",
  [anon_sym_extcodesize] = "extcodesize",
  [anon_sym_extcodecopy] = "extcodecopy",
  [anon_sym_returndatasize] = "returndatasize",
  [anon_sym_returndatacopy] = "returndatacopy",
  [anon_sym_extcodehash] = "extcodehash",
  [anon_sym_create] = "create",
  [anon_sym_create2] = "create2",
  [anon_sym_call] = "call",
  [anon_sym_callcode] = "callcode",
  [anon_sym_delegatecall] = "delegatecall",
  [anon_sym_staticcall] = "staticcall",
  [anon_sym_return] = "return",
  [anon_sym_revert] = "revert",
  [anon_sym_selfdestruct] = "selfdestruct",
  [anon_sym_invalid] = "invalid",
  [anon_sym_log0] = "log0",
  [anon_sym_log1] = "log1",
  [anon_sym_log2] = "log2",
  [anon_sym_log3] = "log3",
  [anon_sym_log4] = "log4",
  [anon_sym_chainid] = "chainid",
  [anon_sym_origin] = "origin",
  [anon_sym_gasprice] = "gasprice",
  [anon_sym_blockhash] = "blockhash",
  [anon_sym_coinbase] = "coinbase",
  [anon_sym_timestamp] = "timestamp",
  [anon_sym_number] = "number",
  [anon_sym_difficulty] = "difficulty",
  [anon_sym_gaslimit] = "gaslimit",
  [sym__unchecked] = "_unchecked",
  [anon_sym_memory] = "memory",
  [anon_sym_storage] = "storage",
  [anon_sym_calldata] = "calldata",
  [anon_sym_var] = "var",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_returns] = "returns",
  [anon_sym_catch] = "catch",
  [anon_sym_emit] = "emit",
  [anon_sym_public] = "public",
  [anon_sym_internal] = "internal",
  [anon_sym_private] = "private",
  [anon_sym_external] = "external",
  [anon_sym_pure] = "pure",
  [anon_sym_view] = "view",
  [anon_sym_payable] = "payable",
  [sym_immutable] = "immutable",
  [anon_sym_override] = "override",
  [anon_sym_modifier] = "modifier",
  [anon_sym_constructor] = "constructor",
  [anon_sym_fallback] = "fallback",
  [anon_sym_receive] = "receive",
  [sym_virtual] = "virtual",
  [anon_sym_QMARK] = "\?",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_BANG] = "!",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_mapping] = "mapping",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_bool] = "bool",
  [anon_sym_string] = "string",
  [anon_sym_int] = "int",
  [anon_sym_int8] = "int8",
  [anon_sym_int16] = "int16",
  [anon_sym_int24] = "int24",
  [anon_sym_int32] = "int32",
  [anon_sym_int40] = "int40",
  [anon_sym_int48] = "int48",
  [anon_sym_int56] = "int56",
  [anon_sym_int64] = "int64",
  [anon_sym_int72] = "int72",
  [anon_sym_int80] = "int80",
  [anon_sym_int88] = "int88",
  [anon_sym_int96] = "int96",
  [anon_sym_int104] = "int104",
  [anon_sym_int112] = "int112",
  [anon_sym_int120] = "int120",
  [anon_sym_int128] = "int128",
  [anon_sym_int136] = "int136",
  [anon_sym_int144] = "int144",
  [anon_sym_int152] = "int152",
  [anon_sym_int160] = "int160",
  [anon_sym_int168] = "int168",
  [anon_sym_int176] = "int176",
  [anon_sym_int184] = "int184",
  [anon_sym_int192] = "int192",
  [anon_sym_int200] = "int200",
  [anon_sym_int208] = "int208",
  [anon_sym_int216] = "int216",
  [anon_sym_int224] = "int224",
  [anon_sym_int232] = "int232",
  [anon_sym_int240] = "int240",
  [anon_sym_int248] = "int248",
  [anon_sym_int256] = "int256",
  [anon_sym_uint] = "uint",
  [anon_sym_uint8] = "uint8",
  [anon_sym_uint16] = "uint16",
  [anon_sym_uint24] = "uint24",
  [anon_sym_uint32] = "uint32",
  [anon_sym_uint40] = "uint40",
  [anon_sym_uint48] = "uint48",
  [anon_sym_uint56] = "uint56",
  [anon_sym_uint64] = "uint64",
  [anon_sym_uint72] = "uint72",
  [anon_sym_uint80] = "uint80",
  [anon_sym_uint88] = "uint88",
  [anon_sym_uint96] = "uint96",
  [anon_sym_uint104] = "uint104",
  [anon_sym_uint112] = "uint112",
  [anon_sym_uint120] = "uint120",
  [anon_sym_uint128] = "uint128",
  [anon_sym_uint136] = "uint136",
  [anon_sym_uint144] = "uint144",
  [anon_sym_uint152] = "uint152",
  [anon_sym_uint160] = "uint160",
  [anon_sym_uint168] = "uint168",
  [anon_sym_uint176] = "uint176",
  [anon_sym_uint184] = "uint184",
  [anon_sym_uint192] = "uint192",
  [anon_sym_uint200] = "uint200",
  [anon_sym_uint208] = "uint208",
  [anon_sym_uint216] = "uint216",
  [anon_sym_uint224] = "uint224",
  [anon_sym_uint232] = "uint232",
  [anon_sym_uint240] = "uint240",
  [anon_sym_uint248] = "uint248",
  [anon_sym_uint256] = "uint256",
  [anon_sym_bytes] = "bytes",
  [anon_sym_bytes1] = "bytes1",
  [anon_sym_bytes2] = "bytes2",
  [anon_sym_bytes3] = "bytes3",
  [anon_sym_bytes4] = "bytes4",
  [anon_sym_bytes5] = "bytes5",
  [anon_sym_bytes6] = "bytes6",
  [anon_sym_bytes7] = "bytes7",
  [anon_sym_bytes8] = "bytes8",
  [anon_sym_bytes9] = "bytes9",
  [anon_sym_bytes10] = "bytes10",
  [anon_sym_bytes11] = "bytes11",
  [anon_sym_bytes12] = "bytes12",
  [anon_sym_bytes13] = "bytes13",
  [anon_sym_bytes14] = "bytes14",
  [anon_sym_bytes15] = "bytes15",
  [anon_sym_bytes16] = "bytes16",
  [anon_sym_bytes17] = "bytes17",
  [anon_sym_bytes18] = "bytes18",
  [anon_sym_bytes19] = "bytes19",
  [anon_sym_bytes20] = "bytes20",
  [anon_sym_bytes21] = "bytes21",
  [anon_sym_bytes22] = "bytes22",
  [anon_sym_bytes23] = "bytes23",
  [anon_sym_bytes24] = "bytes24",
  [anon_sym_bytes25] = "bytes25",
  [anon_sym_bytes26] = "bytes26",
  [anon_sym_bytes27] = "bytes27",
  [anon_sym_bytes28] = "bytes28",
  [anon_sym_bytes29] = "bytes29",
  [anon_sym_bytes30] = "bytes30",
  [anon_sym_bytes31] = "bytes31",
  [anon_sym_bytes32] = "bytes32",
  [anon_sym_fixed] = "fixed",
  [aux_sym__fixed_token1] = "_fixed_token1",
  [anon_sym_ufixed] = "ufixed",
  [aux_sym__ufixed_token1] = "_ufixed_token1",
  [sym__semicolon] = "_semicolon",
  [aux_sym__decimal_number_token1] = "_decimal_number_token1",
  [aux_sym__decimal_number_token2] = "_decimal_number_token2",
  [aux_sym__hex_number_token1] = "_hex_number_token1",
  [sym__hex_digit] = "_hex_digit",
  [anon_sym_wei] = "wei",
  [anon_sym_szabo] = "szabo",
  [anon_sym_finney] = "finney",
  [anon_sym_gwei] = "gwei",
  [anon_sym_ether] = "ether",
  [anon_sym_seconds] = "seconds",
  [anon_sym_minutes] = "minutes",
  [anon_sym_hours] = "hours",
  [anon_sym_days] = "days",
  [anon_sym_weeks] = "weeks",
  [anon_sym_years] = "years",
  [anon_sym_hex] = "hex",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym__] = "_",
  [anon_sym_SQUOTE] = "'",
  [sym__escape_sequence] = "_escape_sequence",
  [aux_sym__single_quoted_unicode_char_token1] = "_single_quoted_unicode_char_token1",
  [aux_sym__double_quoted_unicode_char_token1] = "_double_quoted_unicode_char_token1",
  [anon_sym_unicode] = "unicode",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__source_unit] = "_source_unit",
  [sym__directive] = "_directive",
  [sym_pragma_directive] = "pragma_directive",
  [sym_solidity_pragma_token] = "solidity_pragma_token",
  [sym_any_pragma_token] = "any_pragma_token",
  [sym__solidity] = "_solidity",
  [sym_pragma_value] = "pragma_value",
  [sym__pragma_version_constraint] = "_pragma_version_constraint",
  [sym_solidity_version_comparison_operator] = "solidity_version_comparison_operator",
  [sym_import_directive] = "import_directive",
  [sym__source_import] = "_source_import",
  [sym__import_clause] = "_import_clause",
  [sym__from_clause] = "_from_clause",
  [sym__single_import] = "_single_import",
  [sym__multiple_import] = "_multiple_import",
  [sym__import_declaration] = "_import_declaration",
  [sym__import_alias] = "_import_alias",
  [sym__declaration] = "_declaration",
  [sym_user_defined_type_definition] = "user_defined_type_definition",
  [sym_constant_variable_declaration] = "constant_variable_declaration",
  [sym_contract_declaration] = "contract_declaration",
  [sym_error_declaration] = "error_declaration",
  [sym_error_parameter] = "error_parameter",
  [sym_interface_declaration] = "interface_declaration",
  [sym_library_declaration] = "library_declaration",
  [sym__class_heritage] = "_class_heritage",
  [sym_inheritance_specifier] = "inheritance_specifier",
  [sym_contract_body] = "contract_body",
  [sym__contract_member] = "_contract_member",
  [sym_struct_declaration] = "struct_declaration",
  [sym_struct_member] = "struct_member",
  [sym_enum_declaration] = "enum_declaration",
  [sym_event_definition] = "event_definition",
  [sym__event_parameter_list] = "_event_parameter_list",
  [sym_event_paramater] = "event_paramater",
  [sym_using_directive] = "using_directive",
  [sym_any_source_type] = "any_source_type",
  [sym__statement] = "_statement",
  [sym_assembly_statement] = "assembly_statement",
  [sym__yul_statement] = "_yul_statement",
  [sym_yul_label] = "yul_label",
  [sym_yul_break] = "yul_break",
  [sym_yul_continue] = "yul_continue",
  [sym_yul_identifier] = "yul_identifier",
  [sym__yul_expression] = "_yul_expression",
  [sym_yul_path] = "yul_path",
  [sym__yul_literal] = "_yul_literal",
  [sym_yul_string_literal] = "yul_string_literal",
  [sym_yul_boolean] = "yul_boolean",
  [sym_yul_block] = "yul_block",
  [sym_yul_variable_declaration] = "yul_variable_declaration",
  [sym__yul_assignment_operator] = "_yul_assignment_operator",
  [sym_yul_assignment] = "yul_assignment",
  [sym_yul_function_call] = "yul_function_call",
  [sym_yul_if_statement] = "yul_if_statement",
  [sym_yul_for_statement] = "yul_for_statement",
  [sym_yul_switch_statement] = "yul_switch_statement",
  [sym_yul_function_definition] = "yul_function_definition",
  [sym_yul_evm_builtin] = "yul_evm_builtin",
  [sym_block_statement] = "block_statement",
  [sym_variable_declaration_statement] = "variable_declaration_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_variable_declaration_tuple] = "variable_declaration_tuple",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_while_statement] = "do_while_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_break_statement] = "break_statement",
  [sym_revert_statement] = "revert_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_return_statement] = "return_statement",
  [sym_emit_statement] = "emit_statement",
  [sym_state_variable_declaration] = "state_variable_declaration",
  [sym_visibility] = "visibility",
  [sym_state_mutability] = "state_mutability",
  [sym_override_specifier] = "override_specifier",
  [sym_modifier_definition] = "modifier_definition",
  [sym_constructor_definition] = "constructor_definition",
  [sym_fallback_receive_definition] = "fallback_receive_definition",
  [sym_function_definition] = "function_definition",
  [sym_return_type_definition] = "return_type_definition",
  [sym_modifier_invocation] = "modifier_invocation",
  [sym__call_arguments] = "_call_arguments",
  [sym_call_argument] = "call_argument",
  [sym_call_struct_argument] = "call_struct_argument",
  [sym_function_body] = "function_body",
  [sym__expression] = "_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_type_cast_expression] = "type_cast_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_new_expression] = "new_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_inline_array_expression] = "inline_array_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_member_expression] = "member_expression",
  [sym_array_access] = "array_access",
  [sym_slice_access] = "slice_access",
  [sym_struct_expression] = "struct_expression",
  [sym_struct_field_assignment] = "struct_field_assignment",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym_call_expression] = "call_expression",
  [sym_payable_conversion_expression] = "payable_conversion_expression",
  [sym_meta_type_expression] = "meta_type_expression",
  [sym_type_name] = "type_name",
  [sym__array_type] = "_array_type",
  [sym__function_type] = "_function_type",
  [sym__parameter_list] = "_parameter_list",
  [sym__return_parameters] = "_return_parameters",
  [sym__nameless_parameter] = "return_parameter",
  [sym_parameter] = "parameter",
  [sym__storage_location] = "_storage_location",
  [sym_user_defined_type] = "user_defined_type",
  [sym__identifier_path] = "_identifier_path",
  [sym__mapping] = "_mapping",
  [sym__mapping_key] = "_mapping_key",
  [sym_primitive_type] = "primitive_type",
  [sym__int] = "_int",
  [sym__uint] = "_uint",
  [sym__bytes] = "_bytes",
  [sym__fixed] = "_fixed",
  [sym__ufixed] = "_ufixed",
  [sym__literal] = "_literal",
  [sym_string_literal] = "string_literal",
  [sym_number_literal] = "number_literal",
  [sym__decimal_number] = "_decimal_number",
  [sym__hex_number] = "_hex_number",
  [sym_number_unit] = "number_unit",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_boolean_literal] = "boolean_literal",
  [sym_hex_string_literal] = "hex_string_literal",
  [sym__single_quoted_unicode_char] = "_single_quoted_unicode_char",
  [sym__double_quoted_unicode_char] = "_double_quoted_unicode_char",
  [sym_unicode_string_literal] = "unicode_string_literal",
  [sym_string] = "string",
  [sym__string_immediate_elt_inside_double_quote] = "_string_immediate_elt_inside_double_quote",
  [sym__string_immediate_elt_inside_quote] = "_string_immediate_elt_inside_quote",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_solidity_pragma_token_repeat1] = "solidity_pragma_token_repeat1",
  [aux_sym__multiple_import_repeat1] = "_multiple_import_repeat1",
  [aux_sym_error_declaration_repeat1] = "error_declaration_repeat1",
  [aux_sym__class_heritage_repeat1] = "_class_heritage_repeat1",
  [aux_sym_contract_body_repeat1] = "contract_body_repeat1",
  [aux_sym_struct_declaration_repeat1] = "struct_declaration_repeat1",
  [aux_sym_enum_declaration_repeat1] = "enum_declaration_repeat1",
  [aux_sym__event_parameter_list_repeat1] = "_event_parameter_list_repeat1",
  [aux_sym_assembly_statement_repeat1] = "assembly_statement_repeat1",
  [aux_sym_yul_path_repeat1] = "yul_path_repeat1",
  [aux_sym_yul_variable_declaration_repeat1] = "yul_variable_declaration_repeat1",
  [aux_sym_yul_assignment_repeat1] = "yul_assignment_repeat1",
  [aux_sym_yul_function_call_repeat1] = "yul_function_call_repeat1",
  [aux_sym_yul_switch_statement_repeat1] = "yul_switch_statement_repeat1",
  [aux_sym_block_statement_repeat1] = "block_statement_repeat1",
  [aux_sym_variable_declaration_tuple_repeat1] = "variable_declaration_tuple_repeat1",
  [aux_sym_variable_declaration_tuple_repeat2] = "variable_declaration_tuple_repeat2",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_state_variable_declaration_repeat1] = "state_variable_declaration_repeat1",
  [aux_sym_override_specifier_repeat1] = "override_specifier_repeat1",
  [aux_sym_modifier_definition_repeat1] = "modifier_definition_repeat1",
  [aux_sym_constructor_definition_repeat1] = "constructor_definition_repeat1",
  [aux_sym_fallback_receive_definition_repeat1] = "fallback_receive_definition_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym__call_arguments_repeat1] = "_call_arguments_repeat1",
  [aux_sym_call_argument_repeat1] = "call_argument_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_inline_array_expression_repeat1] = "inline_array_expression_repeat1",
  [aux_sym_struct_expression_repeat1] = "struct_expression_repeat1",
  [aux_sym__function_type_repeat1] = "_function_type_repeat1",
  [aux_sym__parameter_list_repeat1] = "_parameter_list_repeat1",
  [aux_sym__return_parameters_repeat1] = "_return_parameters_repeat1",
  [aux_sym__identifier_path_repeat1] = "_identifier_path_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_hex_string_literal_repeat1] = "hex_string_literal_repeat1",
  [aux_sym_hex_string_literal_repeat2] = "hex_string_literal_repeat2",
  [aux_sym_unicode_string_literal_repeat1] = "unicode_string_literal_repeat1",
  [aux_sym_unicode_string_literal_repeat2] = "unicode_string_literal_repeat2",
  [aux_sym_unicode_string_literal_repeat3] = "unicode_string_literal_repeat3",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [alias_sym_enum_value] = "enum_value",
  [alias_sym_revert_arguments] = "revert_arguments",
  [alias_sym_type_alias] = "type_alias",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_pragma] = anon_sym_pragma,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_solidity] = anon_sym_solidity,
  [aux_sym_pragma_value_token1] = aux_sym_pragma_value_token1,
  [sym_solidity_version] = sym_solidity_version,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_constant] = anon_sym_constant,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_contract] = anon_sym_contract,
  [anon_sym_error] = anon_sym_error,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_library] = anon_sym_library,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_anonymous] = anon_sym_anonymous,
  [anon_sym_indexed] = anon_sym_indexed,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_assembly] = anon_sym_assembly,
  [anon_sym_DQUOTEevmasm_DQUOTE] = anon_sym_DQUOTEevmasm_DQUOTE,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_yul_leave] = sym_yul_leave,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_yul_decimal_number] = sym_yul_decimal_number,
  [sym_yul_hex_number] = sym_yul_hex_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_stop] = anon_sym_stop,
  [anon_sym_add] = anon_sym_add,
  [anon_sym_sub] = anon_sym_sub,
  [anon_sym_mul] = anon_sym_mul,
  [anon_sym_div] = anon_sym_div,
  [anon_sym_sdiv] = anon_sym_sdiv,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_smod] = anon_sym_smod,
  [anon_sym_exp] = anon_sym_exp,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_lt] = anon_sym_lt,
  [anon_sym_gt] = anon_sym_gt,
  [anon_sym_slt] = anon_sym_slt,
  [anon_sym_sgt] = anon_sym_sgt,
  [anon_sym_eq] = anon_sym_eq,
  [anon_sym_iszero] = anon_sym_iszero,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_shl] = anon_sym_shl,
  [anon_sym_shr] = anon_sym_shr,
  [anon_sym_sar] = anon_sym_sar,
  [anon_sym_addmod] = anon_sym_addmod,
  [anon_sym_mulmod] = anon_sym_mulmod,
  [anon_sym_signextend] = anon_sym_signextend,
  [anon_sym_keccak256] = anon_sym_keccak256,
  [anon_sym_pop] = anon_sym_pop,
  [anon_sym_mload] = anon_sym_mload,
  [anon_sym_mstore] = anon_sym_mstore,
  [anon_sym_mstore8] = anon_sym_mstore8,
  [anon_sym_sload] = anon_sym_sload,
  [anon_sym_sstore] = anon_sym_sstore,
  [anon_sym_msize] = anon_sym_msize,
  [anon_sym_gas] = anon_sym_gas,
  [anon_sym_address] = anon_sym_address,
  [anon_sym_balance] = anon_sym_balance,
  [anon_sym_selfbalance] = anon_sym_selfbalance,
  [anon_sym_caller] = anon_sym_caller,
  [anon_sym_callvalue] = anon_sym_callvalue,
  [anon_sym_calldataload] = anon_sym_calldataload,
  [anon_sym_calldatasize] = anon_sym_calldatasize,
  [anon_sym_calldatacopy] = anon_sym_calldatacopy,
  [anon_sym_extcodesize] = anon_sym_extcodesize,
  [anon_sym_extcodecopy] = anon_sym_extcodecopy,
  [anon_sym_returndatasize] = anon_sym_returndatasize,
  [anon_sym_returndatacopy] = anon_sym_returndatacopy,
  [anon_sym_extcodehash] = anon_sym_extcodehash,
  [anon_sym_create] = anon_sym_create,
  [anon_sym_create2] = anon_sym_create2,
  [anon_sym_call] = anon_sym_call,
  [anon_sym_callcode] = anon_sym_callcode,
  [anon_sym_delegatecall] = anon_sym_delegatecall,
  [anon_sym_staticcall] = anon_sym_staticcall,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_revert] = anon_sym_revert,
  [anon_sym_selfdestruct] = anon_sym_selfdestruct,
  [anon_sym_invalid] = anon_sym_invalid,
  [anon_sym_log0] = anon_sym_log0,
  [anon_sym_log1] = anon_sym_log1,
  [anon_sym_log2] = anon_sym_log2,
  [anon_sym_log3] = anon_sym_log3,
  [anon_sym_log4] = anon_sym_log4,
  [anon_sym_chainid] = anon_sym_chainid,
  [anon_sym_origin] = anon_sym_origin,
  [anon_sym_gasprice] = anon_sym_gasprice,
  [anon_sym_blockhash] = anon_sym_blockhash,
  [anon_sym_coinbase] = anon_sym_coinbase,
  [anon_sym_timestamp] = anon_sym_timestamp,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_difficulty] = anon_sym_difficulty,
  [anon_sym_gaslimit] = anon_sym_gaslimit,
  [sym__unchecked] = sym__unchecked,
  [anon_sym_memory] = anon_sym_memory,
  [anon_sym_storage] = anon_sym_storage,
  [anon_sym_calldata] = anon_sym_calldata,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_returns] = anon_sym_returns,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_emit] = anon_sym_emit,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_pure] = anon_sym_pure,
  [anon_sym_view] = anon_sym_view,
  [anon_sym_payable] = anon_sym_payable,
  [sym_immutable] = sym_immutable,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_modifier] = anon_sym_modifier,
  [anon_sym_constructor] = anon_sym_constructor,
  [anon_sym_fallback] = anon_sym_fallback,
  [anon_sym_receive] = anon_sym_receive,
  [sym_virtual] = sym_virtual,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_mapping] = anon_sym_mapping,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_int8] = anon_sym_int8,
  [anon_sym_int16] = anon_sym_int16,
  [anon_sym_int24] = anon_sym_int24,
  [anon_sym_int32] = anon_sym_int32,
  [anon_sym_int40] = anon_sym_int40,
  [anon_sym_int48] = anon_sym_int48,
  [anon_sym_int56] = anon_sym_int56,
  [anon_sym_int64] = anon_sym_int64,
  [anon_sym_int72] = anon_sym_int72,
  [anon_sym_int80] = anon_sym_int80,
  [anon_sym_int88] = anon_sym_int88,
  [anon_sym_int96] = anon_sym_int96,
  [anon_sym_int104] = anon_sym_int104,
  [anon_sym_int112] = anon_sym_int112,
  [anon_sym_int120] = anon_sym_int120,
  [anon_sym_int128] = anon_sym_int128,
  [anon_sym_int136] = anon_sym_int136,
  [anon_sym_int144] = anon_sym_int144,
  [anon_sym_int152] = anon_sym_int152,
  [anon_sym_int160] = anon_sym_int160,
  [anon_sym_int168] = anon_sym_int168,
  [anon_sym_int176] = anon_sym_int176,
  [anon_sym_int184] = anon_sym_int184,
  [anon_sym_int192] = anon_sym_int192,
  [anon_sym_int200] = anon_sym_int200,
  [anon_sym_int208] = anon_sym_int208,
  [anon_sym_int216] = anon_sym_int216,
  [anon_sym_int224] = anon_sym_int224,
  [anon_sym_int232] = anon_sym_int232,
  [anon_sym_int240] = anon_sym_int240,
  [anon_sym_int248] = anon_sym_int248,
  [anon_sym_int256] = anon_sym_int256,
  [anon_sym_uint] = anon_sym_uint,
  [anon_sym_uint8] = anon_sym_uint8,
  [anon_sym_uint16] = anon_sym_uint16,
  [anon_sym_uint24] = anon_sym_uint24,
  [anon_sym_uint32] = anon_sym_uint32,
  [anon_sym_uint40] = anon_sym_uint40,
  [anon_sym_uint48] = anon_sym_uint48,
  [anon_sym_uint56] = anon_sym_uint56,
  [anon_sym_uint64] = anon_sym_uint64,
  [anon_sym_uint72] = anon_sym_uint72,
  [anon_sym_uint80] = anon_sym_uint80,
  [anon_sym_uint88] = anon_sym_uint88,
  [anon_sym_uint96] = anon_sym_uint96,
  [anon_sym_uint104] = anon_sym_uint104,
  [anon_sym_uint112] = anon_sym_uint112,
  [anon_sym_uint120] = anon_sym_uint120,
  [anon_sym_uint128] = anon_sym_uint128,
  [anon_sym_uint136] = anon_sym_uint136,
  [anon_sym_uint144] = anon_sym_uint144,
  [anon_sym_uint152] = anon_sym_uint152,
  [anon_sym_uint160] = anon_sym_uint160,
  [anon_sym_uint168] = anon_sym_uint168,
  [anon_sym_uint176] = anon_sym_uint176,
  [anon_sym_uint184] = anon_sym_uint184,
  [anon_sym_uint192] = anon_sym_uint192,
  [anon_sym_uint200] = anon_sym_uint200,
  [anon_sym_uint208] = anon_sym_uint208,
  [anon_sym_uint216] = anon_sym_uint216,
  [anon_sym_uint224] = anon_sym_uint224,
  [anon_sym_uint232] = anon_sym_uint232,
  [anon_sym_uint240] = anon_sym_uint240,
  [anon_sym_uint248] = anon_sym_uint248,
  [anon_sym_uint256] = anon_sym_uint256,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_bytes1] = anon_sym_bytes1,
  [anon_sym_bytes2] = anon_sym_bytes2,
  [anon_sym_bytes3] = anon_sym_bytes3,
  [anon_sym_bytes4] = anon_sym_bytes4,
  [anon_sym_bytes5] = anon_sym_bytes5,
  [anon_sym_bytes6] = anon_sym_bytes6,
  [anon_sym_bytes7] = anon_sym_bytes7,
  [anon_sym_bytes8] = anon_sym_bytes8,
  [anon_sym_bytes9] = anon_sym_bytes9,
  [anon_sym_bytes10] = anon_sym_bytes10,
  [anon_sym_bytes11] = anon_sym_bytes11,
  [anon_sym_bytes12] = anon_sym_bytes12,
  [anon_sym_bytes13] = anon_sym_bytes13,
  [anon_sym_bytes14] = anon_sym_bytes14,
  [anon_sym_bytes15] = anon_sym_bytes15,
  [anon_sym_bytes16] = anon_sym_bytes16,
  [anon_sym_bytes17] = anon_sym_bytes17,
  [anon_sym_bytes18] = anon_sym_bytes18,
  [anon_sym_bytes19] = anon_sym_bytes19,
  [anon_sym_bytes20] = anon_sym_bytes20,
  [anon_sym_bytes21] = anon_sym_bytes21,
  [anon_sym_bytes22] = anon_sym_bytes22,
  [anon_sym_bytes23] = anon_sym_bytes23,
  [anon_sym_bytes24] = anon_sym_bytes24,
  [anon_sym_bytes25] = anon_sym_bytes25,
  [anon_sym_bytes26] = anon_sym_bytes26,
  [anon_sym_bytes27] = anon_sym_bytes27,
  [anon_sym_bytes28] = anon_sym_bytes28,
  [anon_sym_bytes29] = anon_sym_bytes29,
  [anon_sym_bytes30] = anon_sym_bytes30,
  [anon_sym_bytes31] = anon_sym_bytes31,
  [anon_sym_bytes32] = anon_sym_bytes32,
  [anon_sym_fixed] = anon_sym_fixed,
  [aux_sym__fixed_token1] = aux_sym__fixed_token1,
  [anon_sym_ufixed] = anon_sym_ufixed,
  [aux_sym__ufixed_token1] = aux_sym__ufixed_token1,
  [sym__semicolon] = sym__semicolon,
  [aux_sym__decimal_number_token1] = aux_sym__decimal_number_token1,
  [aux_sym__decimal_number_token2] = aux_sym__decimal_number_token2,
  [aux_sym__hex_number_token1] = aux_sym__hex_number_token1,
  [sym__hex_digit] = sym__hex_digit,
  [anon_sym_wei] = anon_sym_wei,
  [anon_sym_szabo] = anon_sym_szabo,
  [anon_sym_finney] = anon_sym_finney,
  [anon_sym_gwei] = anon_sym_gwei,
  [anon_sym_ether] = anon_sym_ether,
  [anon_sym_seconds] = anon_sym_seconds,
  [anon_sym_minutes] = anon_sym_minutes,
  [anon_sym_hours] = anon_sym_hours,
  [anon_sym_days] = anon_sym_days,
  [anon_sym_weeks] = anon_sym_weeks,
  [anon_sym_years] = anon_sym_years,
  [anon_sym_hex] = anon_sym_hex,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym__] = anon_sym__,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym__escape_sequence] = sym__escape_sequence,
  [aux_sym__single_quoted_unicode_char_token1] = aux_sym__single_quoted_unicode_char_token1,
  [aux_sym__double_quoted_unicode_char_token1] = aux_sym__double_quoted_unicode_char_token1,
  [anon_sym_unicode] = anon_sym_unicode,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__source_unit] = sym__source_unit,
  [sym__directive] = sym__directive,
  [sym_pragma_directive] = sym_pragma_directive,
  [sym_solidity_pragma_token] = sym_solidity_pragma_token,
  [sym_any_pragma_token] = sym_any_pragma_token,
  [sym__solidity] = sym__solidity,
  [sym_pragma_value] = sym_pragma_value,
  [sym__pragma_version_constraint] = sym__pragma_version_constraint,
  [sym_solidity_version_comparison_operator] = sym_solidity_version_comparison_operator,
  [sym_import_directive] = sym_import_directive,
  [sym__source_import] = sym__source_import,
  [sym__import_clause] = sym__import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym__single_import] = sym__single_import,
  [sym__multiple_import] = sym__multiple_import,
  [sym__import_declaration] = sym__import_declaration,
  [sym__import_alias] = sym__import_alias,
  [sym__declaration] = sym__declaration,
  [sym_user_defined_type_definition] = sym_user_defined_type_definition,
  [sym_constant_variable_declaration] = sym_constant_variable_declaration,
  [sym_contract_declaration] = sym_contract_declaration,
  [sym_error_declaration] = sym_error_declaration,
  [sym_error_parameter] = sym_error_parameter,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_library_declaration] = sym_library_declaration,
  [sym__class_heritage] = sym__class_heritage,
  [sym_inheritance_specifier] = sym_inheritance_specifier,
  [sym_contract_body] = sym_contract_body,
  [sym__contract_member] = sym__contract_member,
  [sym_struct_declaration] = sym_struct_declaration,
  [sym_struct_member] = sym_struct_member,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_event_definition] = sym_event_definition,
  [sym__event_parameter_list] = sym__event_parameter_list,
  [sym_event_paramater] = sym_event_paramater,
  [sym_using_directive] = sym_using_directive,
  [sym_any_source_type] = sym_any_source_type,
  [sym__statement] = sym__statement,
  [sym_assembly_statement] = sym_assembly_statement,
  [sym__yul_statement] = sym__yul_statement,
  [sym_yul_label] = sym_yul_label,
  [sym_yul_break] = sym_yul_break,
  [sym_yul_continue] = sym_yul_continue,
  [sym_yul_identifier] = sym_yul_identifier,
  [sym__yul_expression] = sym__yul_expression,
  [sym_yul_path] = sym_yul_path,
  [sym__yul_literal] = sym__yul_literal,
  [sym_yul_string_literal] = sym_yul_string_literal,
  [sym_yul_boolean] = sym_yul_boolean,
  [sym_yul_block] = sym_yul_block,
  [sym_yul_variable_declaration] = sym_yul_variable_declaration,
  [sym__yul_assignment_operator] = sym__yul_assignment_operator,
  [sym_yul_assignment] = sym_yul_assignment,
  [sym_yul_function_call] = sym_yul_function_call,
  [sym_yul_if_statement] = sym_yul_if_statement,
  [sym_yul_for_statement] = sym_yul_for_statement,
  [sym_yul_switch_statement] = sym_yul_switch_statement,
  [sym_yul_function_definition] = sym_yul_function_definition,
  [sym_yul_evm_builtin] = sym_yul_evm_builtin,
  [sym_block_statement] = sym_block_statement,
  [sym_variable_declaration_statement] = sym_variable_declaration_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_variable_declaration_tuple] = sym_variable_declaration_tuple,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_while_statement] = sym_do_while_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_revert_statement] = sym_revert_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_return_statement] = sym_return_statement,
  [sym_emit_statement] = sym_emit_statement,
  [sym_state_variable_declaration] = sym_state_variable_declaration,
  [sym_visibility] = sym_visibility,
  [sym_state_mutability] = sym_state_mutability,
  [sym_override_specifier] = sym_override_specifier,
  [sym_modifier_definition] = sym_modifier_definition,
  [sym_constructor_definition] = sym_constructor_definition,
  [sym_fallback_receive_definition] = sym_fallback_receive_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_return_type_definition] = sym_return_type_definition,
  [sym_modifier_invocation] = sym_modifier_invocation,
  [sym__call_arguments] = sym__call_arguments,
  [sym_call_argument] = sym_call_argument,
  [sym_call_struct_argument] = sym_call_struct_argument,
  [sym_function_body] = sym_function_body,
  [sym__expression] = sym__expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_type_cast_expression] = sym_type_cast_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_inline_array_expression] = sym_inline_array_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_array_access] = sym_array_access,
  [sym_slice_access] = sym_slice_access,
  [sym_struct_expression] = sym_struct_expression,
  [sym_struct_field_assignment] = sym_struct_field_assignment,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_payable_conversion_expression] = sym_payable_conversion_expression,
  [sym_meta_type_expression] = sym_meta_type_expression,
  [sym_type_name] = sym_type_name,
  [sym__array_type] = sym__array_type,
  [sym__function_type] = sym__function_type,
  [sym__parameter_list] = sym__parameter_list,
  [sym__return_parameters] = sym__return_parameters,
  [sym__nameless_parameter] = sym__nameless_parameter,
  [sym_parameter] = sym_parameter,
  [sym__storage_location] = sym__storage_location,
  [sym_user_defined_type] = sym_user_defined_type,
  [sym__identifier_path] = sym__identifier_path,
  [sym__mapping] = sym__mapping,
  [sym__mapping_key] = sym__mapping_key,
  [sym_primitive_type] = sym_primitive_type,
  [sym__int] = sym__int,
  [sym__uint] = sym__uint,
  [sym__bytes] = sym__bytes,
  [sym__fixed] = sym__fixed,
  [sym__ufixed] = sym__ufixed,
  [sym__literal] = sym__literal,
  [sym_string_literal] = sym_string_literal,
  [sym_number_literal] = sym_number_literal,
  [sym__decimal_number] = sym__decimal_number,
  [sym__hex_number] = sym__hex_number,
  [sym_number_unit] = sym_number_unit,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym_hex_string_literal] = sym_hex_string_literal,
  [sym__single_quoted_unicode_char] = sym__single_quoted_unicode_char,
  [sym__double_quoted_unicode_char] = sym__double_quoted_unicode_char,
  [sym_unicode_string_literal] = sym_unicode_string_literal,
  [sym_string] = sym_string,
  [sym__string_immediate_elt_inside_double_quote] = sym__string_immediate_elt_inside_double_quote,
  [sym__string_immediate_elt_inside_quote] = sym__string_immediate_elt_inside_quote,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_solidity_pragma_token_repeat1] = aux_sym_solidity_pragma_token_repeat1,
  [aux_sym__multiple_import_repeat1] = aux_sym__multiple_import_repeat1,
  [aux_sym_error_declaration_repeat1] = aux_sym_error_declaration_repeat1,
  [aux_sym__class_heritage_repeat1] = aux_sym__class_heritage_repeat1,
  [aux_sym_contract_body_repeat1] = aux_sym_contract_body_repeat1,
  [aux_sym_struct_declaration_repeat1] = aux_sym_struct_declaration_repeat1,
  [aux_sym_enum_declaration_repeat1] = aux_sym_enum_declaration_repeat1,
  [aux_sym__event_parameter_list_repeat1] = aux_sym__event_parameter_list_repeat1,
  [aux_sym_assembly_statement_repeat1] = aux_sym_assembly_statement_repeat1,
  [aux_sym_yul_path_repeat1] = aux_sym_yul_path_repeat1,
  [aux_sym_yul_variable_declaration_repeat1] = aux_sym_yul_variable_declaration_repeat1,
  [aux_sym_yul_assignment_repeat1] = aux_sym_yul_assignment_repeat1,
  [aux_sym_yul_function_call_repeat1] = aux_sym_yul_function_call_repeat1,
  [aux_sym_yul_switch_statement_repeat1] = aux_sym_yul_switch_statement_repeat1,
  [aux_sym_block_statement_repeat1] = aux_sym_block_statement_repeat1,
  [aux_sym_variable_declaration_tuple_repeat1] = aux_sym_variable_declaration_tuple_repeat1,
  [aux_sym_variable_declaration_tuple_repeat2] = aux_sym_variable_declaration_tuple_repeat2,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_state_variable_declaration_repeat1] = aux_sym_state_variable_declaration_repeat1,
  [aux_sym_override_specifier_repeat1] = aux_sym_override_specifier_repeat1,
  [aux_sym_modifier_definition_repeat1] = aux_sym_modifier_definition_repeat1,
  [aux_sym_constructor_definition_repeat1] = aux_sym_constructor_definition_repeat1,
  [aux_sym_fallback_receive_definition_repeat1] = aux_sym_fallback_receive_definition_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym__call_arguments_repeat1] = aux_sym__call_arguments_repeat1,
  [aux_sym_call_argument_repeat1] = aux_sym_call_argument_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_inline_array_expression_repeat1] = aux_sym_inline_array_expression_repeat1,
  [aux_sym_struct_expression_repeat1] = aux_sym_struct_expression_repeat1,
  [aux_sym__function_type_repeat1] = aux_sym__function_type_repeat1,
  [aux_sym__parameter_list_repeat1] = aux_sym__parameter_list_repeat1,
  [aux_sym__return_parameters_repeat1] = aux_sym__return_parameters_repeat1,
  [aux_sym__identifier_path_repeat1] = aux_sym__identifier_path_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_hex_string_literal_repeat1] = aux_sym_hex_string_literal_repeat1,
  [aux_sym_hex_string_literal_repeat2] = aux_sym_hex_string_literal_repeat2,
  [aux_sym_unicode_string_literal_repeat1] = aux_sym_unicode_string_literal_repeat1,
  [aux_sym_unicode_string_literal_repeat2] = aux_sym_unicode_string_literal_repeat2,
  [aux_sym_unicode_string_literal_repeat3] = aux_sym_unicode_string_literal_repeat3,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [alias_sym_enum_value] = alias_sym_enum_value,
  [alias_sym_revert_arguments] = alias_sym_revert_arguments,
  [alias_sym_type_alias] = alias_sym_type_alias,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_pragma] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_solidity] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_pragma_value_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_solidity_version] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constant] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_error] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_library] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_anonymous] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indexed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assembly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTEevmasm_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_yul_leave] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_yul_decimal_number] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_hex_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_smod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_slt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sgt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iszero] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addmod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mulmod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signextend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keccak256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mstore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mstore8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sstore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_msize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gas] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_address] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_balance] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_selfbalance] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_caller] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callvalue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldataload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldatasize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldatacopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodesize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodecopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returndatasize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returndatacopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodehash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_create] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_create2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callcode] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delegatecall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_staticcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_revert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_selfdestruct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invalid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log0] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chainid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_origin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gasprice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blockhash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_coinbase] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_timestamp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_difficulty] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gaslimit] = {
    .visible = true,
    .named = false,
  },
  [sym__unchecked] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_memory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_storage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldata] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returns] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_emit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_view] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_payable] = {
    .visible = true,
    .named = false,
  },
  [sym_immutable] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_modifier] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constructor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receive] = {
    .visible = true,
    .named = false,
  },
  [sym_virtual] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mapping] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int80] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int88] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int96] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int104] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int112] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int120] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int136] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int144] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int152] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int160] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int168] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int176] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int184] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int216] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int224] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int232] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int240] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int248] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint80] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint88] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint96] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint104] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint112] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint120] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint136] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint144] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint152] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint160] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint168] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint176] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint184] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint216] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint224] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint232] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint240] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint248] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes11] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes12] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes13] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes14] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes15] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes17] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes18] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes19] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes20] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes21] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes22] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes23] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes25] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes26] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes27] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes28] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes29] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes30] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes31] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fixed] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__fixed_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_ufixed] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__ufixed_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__decimal_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__decimal_number_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hex_number_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__hex_digit] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_wei] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_szabo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finney] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gwei] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ether] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_seconds] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minutes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hours] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_days] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weeks] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_years] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__single_quoted_unicode_char_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_unicode_char_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_unicode] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__source_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym_pragma_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_solidity_pragma_token] = {
    .visible = true,
    .named = true,
  },
  [sym_any_pragma_token] = {
    .visible = true,
    .named = true,
  },
  [sym__solidity] = {
    .visible = false,
    .named = true,
  },
  [sym_pragma_value] = {
    .visible = true,
    .named = true,
  },
  [sym__pragma_version_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym_solidity_version_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_import_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__source_import] = {
    .visible = false,
    .named = true,
  },
  [sym__import_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__single_import] = {
    .visible = false,
    .named = true,
  },
  [sym__multiple_import] = {
    .visible = false,
    .named = true,
  },
  [sym__import_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__import_alias] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_user_defined_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_error_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_error_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_library_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__class_heritage] = {
    .visible = false,
    .named = true,
  },
  [sym_inheritance_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_body] = {
    .visible = true,
    .named = true,
  },
  [sym__contract_member] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_event_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__event_parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym_event_paramater] = {
    .visible = true,
    .named = true,
  },
  [sym_using_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_any_source_type] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_assembly_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_label] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_break] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_continue] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_path] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_block] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_assignment_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_evm_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_revert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_emit_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_state_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_state_mutability] = {
    .visible = true,
    .named = true,
  },
  [sym_override_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_fallback_receive_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_return_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym__call_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_call_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_call_struct_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_type_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_access] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_field_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_payable_conversion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym__array_type] = {
    .visible = false,
    .named = true,
  },
  [sym__function_type] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__return_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__nameless_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__storage_location] = {
    .visible = false,
    .named = true,
  },
  [sym_user_defined_type] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier_path] = {
    .visible = false,
    .named = true,
  },
  [sym__mapping] = {
    .visible = false,
    .named = true,
  },
  [sym__mapping_key] = {
    .visible = false,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym__int] = {
    .visible = false,
    .named = true,
  },
  [sym__uint] = {
    .visible = false,
    .named = true,
  },
  [sym__bytes] = {
    .visible = false,
    .named = true,
  },
  [sym__fixed] = {
    .visible = false,
    .named = true,
  },
  [sym__ufixed] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__decimal_number] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_number] = {
    .visible = false,
    .named = true,
  },
  [sym_number_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quoted_unicode_char] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quoted_unicode_char] = {
    .visible = false,
    .named = true,
  },
  [sym_unicode_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__string_immediate_elt_inside_double_quote] = {
    .visible = false,
    .named = true,
  },
  [sym__string_immediate_elt_inside_quote] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_solidity_pragma_token_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiple_import_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_error_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_heritage_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_contract_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__event_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assembly_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_assignment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_function_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_tuple_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_state_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_override_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifier_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constructor_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fallback_receive_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_array_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__return_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__identifier_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hex_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hex_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_enum_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_revert_arguments] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_alias] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_ancestor = 2,
  field_ancestor_arguments = 3,
  field_argument = 4,
  field_attempt = 5,
  field_base = 6,
  field_body = 7,
  field_condition = 8,
  field_else = 9,
  field_error = 10,
  field_from = 11,
  field_function = 12,
  field_import_name = 13,
  field_index = 14,
  field_initial = 15,
  field_key_type = 16,
  field_left = 17,
  field_location = 18,
  field_name = 19,
  field_object = 20,
  field_operator = 21,
  field_parameters = 22,
  field_property = 23,
  field_return_type = 24,
  field_right = 25,
  field_source = 26,
  field_to = 27,
  field_type = 28,
  field_update = 29,
  field_value = 30,
  field_value_type = 31,
  field_version_constraint = 32,
  field_visibility = 33,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_ancestor] = "ancestor",
  [field_ancestor_arguments] = "ancestor_arguments",
  [field_argument] = "argument",
  [field_attempt] = "attempt",
  [field_base] = "base",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_else] = "else",
  [field_error] = "error",
  [field_from] = "from",
  [field_function] = "function",
  [field_import_name] = "import_name",
  [field_index] = "index",
  [field_initial] = "initial",
  [field_key_type] = "key_type",
  [field_left] = "left",
  [field_location] = "location",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_source] = "source",
  [field_to] = "to",
  [field_type] = "type",
  [field_update] = "update",
  [field_value] = "value",
  [field_value_type] = "value_type",
  [field_version_constraint] = "version_constraint",
  [field_visibility] = "visibility",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 11, .length = 2},
  [11] = {.index = 13, .length = 2},
  [12] = {.index = 15, .length = 2},
  [13] = {.index = 17, .length = 2},
  [14] = {.index = 19, .length = 1},
  [15] = {.index = 20, .length = 2},
  [16] = {.index = 22, .length = 1},
  [17] = {.index = 23, .length = 2},
  [18] = {.index = 25, .length = 1},
  [19] = {.index = 26, .length = 3},
  [20] = {.index = 29, .length = 2},
  [21] = {.index = 31, .length = 1},
  [22] = {.index = 32, .length = 2},
  [23] = {.index = 34, .length = 1},
  [24] = {.index = 35, .length = 2},
  [25] = {.index = 37, .length = 2},
  [26] = {.index = 39, .length = 2},
  [27] = {.index = 41, .length = 2},
  [28] = {.index = 43, .length = 1},
  [29] = {.index = 44, .length = 4},
  [30] = {.index = 48, .length = 4},
  [31] = {.index = 52, .length = 2},
  [32] = {.index = 54, .length = 1},
  [33] = {.index = 55, .length = 2},
  [34] = {.index = 34, .length = 1},
  [35] = {.index = 57, .length = 3},
  [36] = {.index = 60, .length = 2},
  [37] = {.index = 62, .length = 3},
  [38] = {.index = 65, .length = 2},
  [39] = {.index = 67, .length = 2},
  [40] = {.index = 69, .length = 3},
  [41] = {.index = 72, .length = 2},
  [42] = {.index = 74, .length = 1},
  [43] = {.index = 75, .length = 1},
  [44] = {.index = 76, .length = 2},
  [46] = {.index = 78, .length = 2},
  [47] = {.index = 80, .length = 3},
  [48] = {.index = 83, .length = 2},
  [49] = {.index = 85, .length = 2},
  [50] = {.index = 87, .length = 3},
  [51] = {.index = 90, .length = 2},
  [52] = {.index = 92, .length = 1},
  [53] = {.index = 93, .length = 3},
  [55] = {.index = 96, .length = 1},
  [56] = {.index = 97, .length = 2},
  [57] = {.index = 99, .length = 2},
  [58] = {.index = 101, .length = 2},
  [59] = {.index = 103, .length = 2},
  [60] = {.index = 105, .length = 1},
  [61] = {.index = 106, .length = 3},
  [62] = {.index = 109, .length = 1},
  [63] = {.index = 96, .length = 1},
  [64] = {.index = 110, .length = 2},
  [65] = {.index = 112, .length = 1},
  [66] = {.index = 113, .length = 3},
  [67] = {.index = 116, .length = 2},
  [68] = {.index = 118, .length = 4},
  [69] = {.index = 122, .length = 2},
  [70] = {.index = 124, .length = 2},
  [71] = {.index = 126, .length = 1},
  [72] = {.index = 127, .length = 3},
  [73] = {.index = 130, .length = 3},
  [74] = {.index = 133, .length = 2},
  [75] = {.index = 135, .length = 2},
  [76] = {.index = 137, .length = 4},
  [77] = {.index = 141, .length = 4},
  [78] = {.index = 145, .length = 3},
  [79] = {.index = 148, .length = 4},
  [80] = {.index = 152, .length = 2},
  [81] = {.index = 154, .length = 4},
  [82] = {.index = 158, .length = 5},
  [83] = {.index = 163, .length = 5},
  [84] = {.index = 168, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_parameters, 0, .inherited = true},
  [1] =
    {field_key_type, 0, .inherited = true},
    {field_value_type, 0, .inherited = true},
  [3] =
    {field_import_name, 0},
  [4] =
    {field_alias, 0, .inherited = true},
    {field_import_name, 0, .inherited = true},
  [6] =
    {field_source, 0},
  [7] =
    {field_parameters, 1},
  [8] =
    {field_version_constraint, 0},
  [9] =
    {field_version_constraint, 1, .inherited = true},
  [10] =
    {field_alias, 1, .inherited = true},
  [11] =
    {field_alias, 1, .inherited = true},
    {field_import_name, 0},
  [13] =
    {field_alias, 1, .inherited = true},
    {field_source, 1, .inherited = true},
  [15] =
    {field_alias, 1, .inherited = true},
    {field_source, 0},
  [17] =
    {field_body, 2},
    {field_name, 1},
  [19] =
    {field_type, 0},
  [20] =
    {field_version_constraint, 0, .inherited = true},
    {field_version_constraint, 1, .inherited = true},
  [22] =
    {field_alias, 1},
  [23] =
    {field_alias, 1, .inherited = true},
    {field_import_name, 1, .inherited = true},
  [25] =
    {field_source, 1},
  [26] =
    {field_alias, 1, .inherited = true},
    {field_import_name, 1, .inherited = true},
    {field_source, 2, .inherited = true},
  [29] =
    {field_body, 3},
    {field_name, 2},
  [31] =
    {field_ancestor, 0},
  [32] =
    {field_body, 3},
    {field_name, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_name, 1},
    {field_type, 0},
  [37] =
    {field_location, 1},
    {field_type, 0},
  [39] =
    {field_argument, 1},
    {field_operator, 0},
  [41] =
    {field_argument, 0},
    {field_operator, 1},
  [43] =
    {field_function, 0},
  [44] =
    {field_alias, 1, .inherited = true},
    {field_alias, 2, .inherited = true},
    {field_import_name, 1, .inherited = true},
    {field_import_name, 2, .inherited = true},
  [48] =
    {field_alias, 0, .inherited = true},
    {field_alias, 1, .inherited = true},
    {field_import_name, 0, .inherited = true},
    {field_import_name, 1, .inherited = true},
  [52] =
    {field_body, 4},
    {field_name, 2},
  [54] =
    {field_visibility, 0},
  [55] =
    {field_ancestor, 0},
    {field_ancestor_arguments, 1},
  [57] =
    {field_location, 1},
    {field_name, 2},
    {field_type, 0},
  [60] =
    {field_name, 1},
    {field_return_type, 3},
  [62] =
    {field_body, 4},
    {field_name, 1},
    {field_return_type, 3},
  [65] =
    {field_body, 4},
    {field_name, 1},
  [67] =
    {field_object, 0},
    {field_property, 2},
  [69] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [72] =
    {field_left, 0},
    {field_right, 2},
  [74] =
    {field_base, 0},
  [75] =
    {field_body, 2},
  [76] =
    {field_visibility, 0, .inherited = true},
    {field_visibility, 1, .inherited = true},
  [78] =
    {field_name, 1},
    {field_return_type, 4},
  [80] =
    {field_body, 5},
    {field_name, 1},
    {field_return_type, 4},
  [83] =
    {field_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [85] =
    {field_key_type, 2},
    {field_value_type, 4},
  [87] =
    {field_name, 2},
    {field_type, 0},
    {field_value, 4},
  [90] =
    {field_base, 0},
    {field_index, 2},
  [92] =
    {field_body, 3},
  [93] =
    {field_name, 2},
    {field_type, 0},
    {field_visibility, 1, .inherited = true},
  [96] =
    {field_error, 1},
  [97] =
    {field_location, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [99] =
    {field_name, 0},
    {field_value, 2},
  [101] =
    {field_base, 0},
    {field_to, 3},
  [103] =
    {field_base, 0},
    {field_from, 2},
  [105] =
    {field_source, 3},
  [106] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 3},
  [109] =
    {field_left, 1},
  [110] =
    {field_attempt, 1},
    {field_body, 2},
  [112] =
    {field_value, 2},
  [113] =
    {field_base, 0},
    {field_from, 2},
    {field_to, 4},
  [116] =
    {field_name, 2},
    {field_type, 0},
  [118] =
    {field_name, 2},
    {field_type, 0},
    {field_value, 4},
    {field_visibility, 1, .inherited = true},
  [122] =
    {field_left, 1},
    {field_left, 2},
  [124] =
    {field_body, 4},
    {field_condition, 2},
  [126] =
    {field_body, 1},
  [127] =
    {field_body, 5},
    {field_condition, 3},
    {field_initial, 2},
  [130] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
  [133] =
    {field_left, 1},
    {field_right, 3},
  [135] =
    {field_attempt, 1},
    {field_body, 4},
  [137] =
    {field_body, 6},
    {field_condition, 3},
    {field_initial, 2},
    {field_update, 4},
  [141] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
  [145] =
    {field_left, 1},
    {field_left, 2},
    {field_right, 4},
  [148] =
    {field_body, 4},
    {field_body, 6},
    {field_condition, 2},
    {field_else, 5},
  [152] =
    {field_body, 1},
    {field_condition, 4},
  [154] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_right, 5},
  [158] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_left, 5},
  [163] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_right, 6},
  [168] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_left, 5},
    {field_right, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [34] = {
    [3] = alias_sym_enum_value,
  },
  [45] = {
    [1] = alias_sym_enum_value,
  },
  [54] = {
    [1] = alias_sym_revert_arguments,
  },
  [60] = {
    [1] = alias_sym_type_alias,
  },
  [63] = {
    [2] = alias_sym_revert_arguments,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__call_arguments, 2,
    sym__call_arguments,
    alias_sym_revert_arguments,
  sym_user_defined_type, 2,
    sym_user_defined_type,
    alias_sym_type_alias,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(51);
      if (lookahead == '!') ADVANCE(111);
      if (lookahead == '"') ADVANCE(140);
      if (lookahead == '%') ADVANCE(105);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '\'') ADVANCE(143);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(83);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(103);
      if (lookahead == ',') ADVANCE(80);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(104);
      if (lookahead == '0') ADVANCE(88);
      if (lookahead == ':') ADVANCE(86);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '?') ADVANCE(93);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '_') ADVANCE(142);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(101);
      if (lookahead == '}') ADVANCE(81);
      if (lookahead == '~') ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(89);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(13)
      if (lookahead == '"') ADVANCE(140);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(161);
      if (lookahead != 0) ADVANCE(162);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(156);
      if (lookahead == '\r') ADVANCE(145);
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '\'') ADVANCE(143);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(154);
      if (lookahead != 0) ADVANCE(155);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(149);
      if (lookahead == '\r') ADVANCE(146);
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 5:
      if (lookahead == ' ') ADVANCE(5);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (lookahead == '-') ADVANCE(53);
      if (lookahead == '.') ADVANCE(6);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(68);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(71);
      if (lookahead == '^') ADVANCE(69);
      if (lookahead == '|') ADVANCE(34);
      if (lookahead == '~') ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == ' ') ADVANCE(36);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 7:
      if (lookahead == ' ') ADVANCE(36);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (lookahead == '.') ADVANCE(6);
      END_STATE();
    case 8:
      if (lookahead == ' ') ADVANCE(37);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '"') ADVANCE(140);
      if (lookahead == '%') ADVANCE(105);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '\'') ADVANCE(143);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(83);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(103);
      if (lookahead == ',') ADVANCE(80);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(104);
      if (lookahead == ':') ADVANCE(85);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '?') ADVANCE(93);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(101);
      if (lookahead == '}') ADVANCE(81);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '"') ADVANCE(27);
      if (lookahead == '%') ADVANCE(105);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(83);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(103);
      if (lookahead == ',') ADVANCE(80);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(104);
      if (lookahead == ':') ADVANCE(85);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '?') ADVANCE(93);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(101);
      if (lookahead == '}') ADVANCE(81);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(110);
      if (lookahead == '"') ADVANCE(140);
      if (lookahead == '\'') ADVANCE(143);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(83);
      if (lookahead == '+') ADVANCE(102);
      if (lookahead == ',') ADVANCE(80);
      if (lookahead == '-') ADVANCE(54);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(132);
      if (lookahead == ':') ADVANCE(85);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '_') ADVANCE(128);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '}') ADVANCE(81);
      if (lookahead == '~') ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(140);
      if (lookahead == '\'') ADVANCE(143);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '_') ADVANCE(141);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(140);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(84);
      END_STATE();
    case 15:
      if (lookahead == '\'') ADVANCE(143);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(83);
      if (lookahead == ',') ADVANCE(80);
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(165);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 19:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(134);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(136);
      END_STATE();
    case 22:
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(59);
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(60);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 24:
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 25:
      if (lookahead == '>') ADVANCE(92);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(30);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 28:
      if (lookahead == 'm') ADVANCE(26);
      END_STATE();
    case 29:
      if (lookahead == 'm') ADVANCE(14);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(29);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 32:
      if (lookahead == 'v') ADVANCE(28);
      END_STATE();
    case 33:
      if (lookahead == '{') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 34:
      if (lookahead == '|') ADVANCE(52);
      END_STATE();
    case 35:
      if (lookahead == '}') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 37:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 38:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(135);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(133);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(134);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(136);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(139);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 49:
      if (eof) ADVANCE(51);
      if (lookahead == '!') ADVANCE(111);
      if (lookahead == '"') ADVANCE(140);
      if (lookahead == '%') ADVANCE(105);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '\'') ADVANCE(143);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(83);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(103);
      if (lookahead == ',') ADVANCE(80);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(104);
      if (lookahead == '0') ADVANCE(88);
      if (lookahead == ':') ADVANCE(86);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '?') ADVANCE(93);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '_') ADVANCE(142);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(101);
      if (lookahead == '}') ADVANCE(81);
      if (lookahead == '~') ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(89);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 50:
      if (eof) ADVANCE(51);
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '"') ADVANCE(140);
      if (lookahead == '%') ADVANCE(105);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '\'') ADVANCE(143);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(83);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(103);
      if (lookahead == ',') ADVANCE(80);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(104);
      if (lookahead == '0') ADVANCE(88);
      if (lookahead == ':') ADVANCE(86);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '?') ADVANCE(93);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(70);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(101);
      if (lookahead == '}') ADVANCE(81);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(89);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(113);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(113);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead == '*') ADVANCE(58);
      if (lookahead == '/') ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(60);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead == ';') ADVANCE(19);
      if (lookahead != 0) ADVANCE(58);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == ';') ADVANCE(19);
      if (lookahead != 0) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(59);
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(60);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_solidity_version);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_solidity_version);
      if (lookahead == ' ') ADVANCE(63);
      if (lookahead == '"') ADVANCE(61);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      if (lookahead == '.') ADVANCE(38);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_solidity_version);
      if (lookahead == '"') ADVANCE(61);
      if (lookahead == '.') ADVANCE(38);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_solidity_version);
      if (lookahead == '"') ADVANCE(61);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (lookahead == '.') ADVANCE(8);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_solidity_version);
      if (lookahead == '"') ADVANCE(61);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(66);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(66);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(97);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(107);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(106);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DQUOTEevmasm_DQUOTE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(91);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_yul_decimal_number);
      if (lookahead == 'x') ADVANCE(90);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_yul_decimal_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_yul_hex_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(122);
      if (lookahead == '>') ADVANCE(98);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(96);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(121);
      if (lookahead == '|') ADVANCE(52);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(112);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(112);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym__semicolon);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(129);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(128);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(127);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(129);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (lookahead == '.') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(131);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (lookahead == '.') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(131);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(20);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(46);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(133);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(134);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym__decimal_number_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(135);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym__decimal_number_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym__hex_number_token1);
      if (lookahead == '_') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym__hex_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym__hex_digit);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym__escape_sequence);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (lookahead == '\n') ADVANCE(156);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (lookahead == '\n') ADVANCE(149);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(144);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(147);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '\r') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(153);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(152);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(153);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(152);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(154);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '\r') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(157);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead == '/') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(159);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(160);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(160);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(161);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == ';') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(164);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(165);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'h') ADVANCE(8);
      if (lookahead == 'i') ADVANCE(9);
      if (lookahead == 'k') ADVANCE(10);
      if (lookahead == 'l') ADVANCE(11);
      if (lookahead == 'm') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'p') ADVANCE(15);
      if (lookahead == 'r') ADVANCE(16);
      if (lookahead == 's') ADVANCE(17);
      if (lookahead == 't') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      if (lookahead == 'v') ADVANCE(20);
      if (lookahead == 'w') ADVANCE(21);
      if (lookahead == 'x') ADVANCE(22);
      if (lookahead == 'y') ADVANCE(23);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(24);
      if (lookahead == 'd') ADVANCE(25);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      if (lookahead == 'r') ADVANCE(31);
      if (lookahead == 'y') ADVANCE(32);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'h') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(35);
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == 'i') ADVANCE(39);
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(41);
      if (lookahead == 'm') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(43);
      if (lookahead == 'q') ADVANCE(44);
      if (lookahead == 'r') ADVANCE(45);
      if (lookahead == 't') ADVANCE(46);
      if (lookahead == 'v') ADVANCE(47);
      if (lookahead == 'x') ADVANCE(48);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(51);
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 't') ADVANCE(55);
      if (lookahead == 'w') ADVANCE(56);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(59);
      if (lookahead == 'm') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == 's') ADVANCE(62);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(64);
      if (lookahead == 'i') ADVANCE(65);
      if (lookahead == 'o') ADVANCE(66);
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(68);
      if (lookahead == 'e') ADVANCE(69);
      if (lookahead == 'i') ADVANCE(70);
      if (lookahead == 'l') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(72);
      if (lookahead == 's') ADVANCE(73);
      if (lookahead == 'u') ADVANCE(74);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(75);
      if (lookahead == 'o') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(78);
      if (lookahead == 'v') ADVANCE(79);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(80);
      if (lookahead == 'o') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(82);
      if (lookahead == 'u') ADVANCE(83);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(85);
      if (lookahead == 'd') ADVANCE(86);
      if (lookahead == 'e') ADVANCE(87);
      if (lookahead == 'g') ADVANCE(88);
      if (lookahead == 'h') ADVANCE(89);
      if (lookahead == 'i') ADVANCE(90);
      if (lookahead == 'l') ADVANCE(91);
      if (lookahead == 'm') ADVANCE(92);
      if (lookahead == 'o') ADVANCE(93);
      if (lookahead == 's') ADVANCE(94);
      if (lookahead == 't') ADVANCE(95);
      if (lookahead == 'u') ADVANCE(96);
      if (lookahead == 'w') ADVANCE(97);
      if (lookahead == 'z') ADVANCE(98);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(99);
      if (lookahead == 'r') ADVANCE(100);
      if (lookahead == 'y') ADVANCE(101);
      END_STATE();
    case 19:
      if (lookahead == 'f') ADVANCE(102);
      if (lookahead == 'i') ADVANCE(103);
      if (lookahead == 'n') ADVANCE(104);
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'h') ADVANCE(109);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(113);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(114);
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(116);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 29:
      if (lookahead == 'o') ADVANCE(118);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(119);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(122);
      if (lookahead == 's') ADVANCE(123);
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(126);
      if (lookahead == 'n') ADVANCE(127);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 37:
      if (lookahead == 'y') ADVANCE(129);
      END_STATE();
    case 38:
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead == 'l') ADVANCE(131);
      END_STATE();
    case 39:
      if (lookahead == 'f') ADVANCE(132);
      if (lookahead == 'v') ADVANCE(133);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(134);
      END_STATE();
    case 42:
      if (lookahead == 'i') ADVANCE(135);
      END_STATE();
    case 43:
      if (lookahead == 'u') ADVANCE(136);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_eq);
      END_STATE();
    case 45:
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 46:
      if (lookahead == 'h') ADVANCE(138);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 48:
      if (lookahead == 'p') ADVANCE(140);
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(142);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'x') ADVANCE(144);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(146);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(147);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_gt);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 57:
      if (lookahead == 'x') ADVANCE(150);
      END_STATE();
    case 58:
      if (lookahead == 'u') ADVANCE(151);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 60:
      if (lookahead == 'm') ADVANCE(152);
      if (lookahead == 'p') ADVANCE(153);
      END_STATE();
    case 61:
      if (lookahead == 'd') ADVANCE(154);
      if (lookahead == 't') ADVANCE(155);
      if (lookahead == 'v') ADVANCE(156);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_is);
      if (lookahead == 'z') ADVANCE(157);
      END_STATE();
    case 63:
      if (lookahead == 'c') ADVANCE(158);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(159);
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 65:
      if (lookahead == 'b') ADVANCE(161);
      END_STATE();
    case 66:
      if (lookahead == 'g') ADVANCE(162);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_lt);
      END_STATE();
    case 68:
      if (lookahead == 'p') ADVANCE(163);
      END_STATE();
    case 69:
      if (lookahead == 'm') ADVANCE(164);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(165);
      END_STATE();
    case 71:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 72:
      if (lookahead == 'd') ADVANCE(167);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 75:
      if (lookahead == 'w') ADVANCE(171);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(173);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 80:
      if (lookahead == 'y') ADVANCE(176);
      END_STATE();
    case 81:
      if (lookahead == 'p') ADVANCE(177);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(178);
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(180);
      if (lookahead == 'r') ADVANCE(181);
      END_STATE();
    case 84:
      if (lookahead == 'c') ADVANCE(182);
      if (lookahead == 't') ADVANCE(183);
      if (lookahead == 'v') ADVANCE(184);
      END_STATE();
    case 85:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 86:
      if (lookahead == 'i') ADVANCE(186);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'l') ADVANCE(188);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(189);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(190);
      if (lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 90:
      if (lookahead == 'g') ADVANCE(192);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(193);
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 92:
      if (lookahead == 'o') ADVANCE(195);
      END_STATE();
    case 93:
      if (lookahead == 'l') ADVANCE(196);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 95:
      if (lookahead == 'a') ADVANCE(198);
      if (lookahead == 'o') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(200);
      END_STATE();
    case 96:
      if (lookahead == 'b') ADVANCE(201);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(202);
      END_STATE();
    case 98:
      if (lookahead == 'a') ADVANCE(203);
      END_STATE();
    case 99:
      if (lookahead == 'm') ADVANCE(204);
      END_STATE();
    case 100:
      if (lookahead == 'u') ADVANCE(205);
      if (lookahead == 'y') ADVANCE(206);
      END_STATE();
    case 101:
      if (lookahead == 'p') ADVANCE(207);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(208);
      END_STATE();
    case 103:
      if (lookahead == 'n') ADVANCE(209);
      END_STATE();
    case 104:
      if (lookahead == 'c') ADVANCE(210);
      if (lookahead == 'i') ADVANCE(211);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(212);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(213);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(214);
      if (lookahead == 'r') ADVANCE(215);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(216);
      if (lookahead == 'i') ADVANCE(217);
      END_STATE();
    case 109:
      if (lookahead == 'i') ADVANCE(218);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(219);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(220);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_add);
      if (lookahead == 'm') ADVANCE(222);
      if (lookahead == 'r') ADVANCE(223);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 115:
      if (lookahead == 'n') ADVANCE(224);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(225);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(226);
      END_STATE();
    case 118:
      if (lookahead == 'c') ADVANCE(227);
      END_STATE();
    case 119:
      if (lookahead == 'l') ADVANCE(228);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(229);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(230);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(231);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 124:
      if (lookahead == 'c') ADVANCE(233);
      END_STATE();
    case 125:
      if (lookahead == 'i') ADVANCE(234);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(235);
      END_STATE();
    case 127:
      if (lookahead == 's') ADVANCE(236);
      if (lookahead == 't') ADVANCE(237);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(238);
      END_STATE();
    case 129:
      if (lookahead == 's') ADVANCE(239);
      END_STATE();
    case 130:
      if (lookahead == 'a') ADVANCE(240);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 132:
      if (lookahead == 'f') ADVANCE(242);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_div);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(243);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(244);
      END_STATE();
    case 136:
      if (lookahead == 'm') ADVANCE(245);
      END_STATE();
    case 137:
      if (lookahead == 'o') ADVANCE(246);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(247);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(248);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_exp);
      END_STATE();
    case 141:
      if (lookahead == 'c') ADVANCE(249);
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 142:
      if (lookahead == 'l') ADVANCE(251);
      if (lookahead == 's') ADVANCE(252);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(254);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 146:
      if (lookahead == 'm') ADVANCE(255);
      END_STATE();
    case 147:
      if (lookahead == 'c') ADVANCE(256);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_gas);
      if (lookahead == 'l') ADVANCE(257);
      if (lookahead == 'p') ADVANCE(258);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(259);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_hex);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(260);
      END_STATE();
    case 152:
      if (lookahead == 'u') ADVANCE(261);
      END_STATE();
    case 153:
      if (lookahead == 'o') ADVANCE(262);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == '1') ADVANCE(264);
      if (lookahead == '2') ADVANCE(265);
      if (lookahead == '3') ADVANCE(266);
      if (lookahead == '4') ADVANCE(267);
      if (lookahead == '5') ADVANCE(268);
      if (lookahead == '6') ADVANCE(269);
      if (lookahead == '7') ADVANCE(270);
      if (lookahead == '8') ADVANCE(271);
      if (lookahead == '9') ADVANCE(272);
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 156:
      if (lookahead == 'a') ADVANCE(274);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(275);
      END_STATE();
    case 158:
      if (lookahead == 'c') ADVANCE(276);
      END_STATE();
    case 159:
      if (lookahead == 'v') ADVANCE(277);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(278);
      END_STATE();
    case 162:
      if (lookahead == '0') ADVANCE(279);
      if (lookahead == '1') ADVANCE(280);
      if (lookahead == '2') ADVANCE(281);
      if (lookahead == '3') ADVANCE(282);
      if (lookahead == '4') ADVANCE(283);
      END_STATE();
    case 163:
      if (lookahead == 'p') ADVANCE(284);
      END_STATE();
    case 164:
      if (lookahead == 'o') ADVANCE(285);
      END_STATE();
    case 165:
      if (lookahead == 'u') ADVANCE(286);
      END_STATE();
    case 166:
      if (lookahead == 'a') ADVANCE(287);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_mod);
      if (lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 168:
      if (lookahead == 'z') ADVANCE(289);
      END_STATE();
    case 169:
      if (lookahead == 'o') ADVANCE(290);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_mul);
      if (lookahead == 'm') ADVANCE(291);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 173:
      if (lookahead == 'b') ADVANCE(292);
      END_STATE();
    case 174:
      if (lookahead == 'g') ADVANCE(293);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(294);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(295);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_pop);
      END_STATE();
    case 178:
      if (lookahead == 'g') ADVANCE(296);
      END_STATE();
    case 179:
      if (lookahead == 'v') ADVANCE(297);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(298);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(299);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(300);
      END_STATE();
    case 183:
      if (lookahead == 'u') ADVANCE(301);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_sar);
      END_STATE();
    case 186:
      if (lookahead == 'v') ADVANCE(303);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(304);
      END_STATE();
    case 188:
      if (lookahead == 'f') ADVANCE(305);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_sgt);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_shl);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_shr);
      END_STATE();
    case 192:
      if (lookahead == 'n') ADVANCE(306);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(307);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_slt);
      END_STATE();
    case 195:
      if (lookahead == 'd') ADVANCE(308);
      END_STATE();
    case 196:
      if (lookahead == 'i') ADVANCE(309);
      END_STATE();
    case 197:
      if (lookahead == 'o') ADVANCE(310);
      END_STATE();
    case 198:
      if (lookahead == 't') ADVANCE(311);
      END_STATE();
    case 199:
      if (lookahead == 'p') ADVANCE(312);
      if (lookahead == 'r') ADVANCE(313);
      END_STATE();
    case 200:
      if (lookahead == 'i') ADVANCE(314);
      if (lookahead == 'u') ADVANCE(315);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_sub);
      END_STATE();
    case 202:
      if (lookahead == 't') ADVANCE(316);
      END_STATE();
    case 203:
      if (lookahead == 'b') ADVANCE(317);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(318);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(319);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(320);
      END_STATE();
    case 208:
      if (lookahead == 'x') ADVANCE(321);
      END_STATE();
    case 209:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 210:
      if (lookahead == 'h') ADVANCE(323);
      END_STATE();
    case 211:
      if (lookahead == 'c') ADVANCE(324);
      END_STATE();
    case 212:
      if (lookahead == 'n') ADVANCE(325);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 214:
      if (lookahead == 'w') ADVANCE(326);
      END_STATE();
    case 215:
      if (lookahead == 't') ADVANCE(327);
      END_STATE();
    case 216:
      if (lookahead == 'k') ADVANCE(328);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_wei);
      END_STATE();
    case 218:
      if (lookahead == 'l') ADVANCE(329);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 220:
      if (lookahead == 'r') ADVANCE(330);
      END_STATE();
    case 221:
      if (lookahead == 'r') ADVANCE(331);
      END_STATE();
    case 222:
      if (lookahead == 'o') ADVANCE(332);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(333);
      END_STATE();
    case 224:
      if (lookahead == 'y') ADVANCE(334);
      END_STATE();
    case 225:
      if (lookahead == 'm') ADVANCE(335);
      END_STATE();
    case 226:
      if (lookahead == 'n') ADVANCE(336);
      END_STATE();
    case 227:
      if (lookahead == 'k') ADVANCE(337);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 229:
      if (lookahead == 'k') ADVANCE(338);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_byte);
      if (lookahead == 's') ADVANCE(339);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_call);
      if (lookahead == 'c') ADVANCE(340);
      if (lookahead == 'd') ADVANCE(341);
      if (lookahead == 'e') ADVANCE(342);
      if (lookahead == 'v') ADVANCE(343);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 233:
      if (lookahead == 'h') ADVANCE(344);
      END_STATE();
    case 234:
      if (lookahead == 'n') ADVANCE(345);
      END_STATE();
    case 235:
      if (lookahead == 'b') ADVANCE(346);
      END_STATE();
    case 236:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 237:
      if (lookahead == 'i') ADVANCE(348);
      if (lookahead == 'r') ADVANCE(349);
      END_STATE();
    case 238:
      if (lookahead == 't') ADVANCE(350);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_days);
      END_STATE();
    case 240:
      if (lookahead == 'u') ADVANCE(351);
      END_STATE();
    case 241:
      if (lookahead == 'g') ADVANCE(352);
      if (lookahead == 't') ADVANCE(353);
      END_STATE();
    case 242:
      if (lookahead == 'i') ADVANCE(354);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_emit);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 246:
      if (lookahead == 'r') ADVANCE(355);
      END_STATE();
    case 247:
      if (lookahead == 'r') ADVANCE(356);
      END_STATE();
    case 248:
      if (lookahead == 't') ADVANCE(357);
      END_STATE();
    case 249:
      if (lookahead == 'o') ADVANCE(358);
      END_STATE();
    case 250:
      if (lookahead == 'r') ADVANCE(359);
      END_STATE();
    case 251:
      if (lookahead == 'b') ADVANCE(360);
      END_STATE();
    case 252:
      if (lookahead == 'e') ADVANCE(361);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(362);
      END_STATE();
    case 254:
      if (lookahead == 'd') ADVANCE(363);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 256:
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 257:
      if (lookahead == 'i') ADVANCE(365);
      END_STATE();
    case 258:
      if (lookahead == 'r') ADVANCE(366);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_gwei);
      END_STATE();
    case 260:
      if (lookahead == 's') ADVANCE(367);
      END_STATE();
    case 261:
      if (lookahead == 't') ADVANCE(368);
      END_STATE();
    case 262:
      if (lookahead == 'r') ADVANCE(369);
      END_STATE();
    case 263:
      if (lookahead == 'x') ADVANCE(370);
      END_STATE();
    case 264:
      if (lookahead == '0') ADVANCE(371);
      if (lookahead == '1') ADVANCE(372);
      if (lookahead == '2') ADVANCE(373);
      if (lookahead == '3') ADVANCE(374);
      if (lookahead == '4') ADVANCE(375);
      if (lookahead == '5') ADVANCE(376);
      if (lookahead == '6') ADVANCE(377);
      if (lookahead == '7') ADVANCE(378);
      if (lookahead == '8') ADVANCE(379);
      if (lookahead == '9') ADVANCE(380);
      END_STATE();
    case 265:
      if (lookahead == '0') ADVANCE(381);
      if (lookahead == '1') ADVANCE(382);
      if (lookahead == '2') ADVANCE(383);
      if (lookahead == '3') ADVANCE(384);
      if (lookahead == '4') ADVANCE(385);
      if (lookahead == '5') ADVANCE(386);
      END_STATE();
    case 266:
      if (lookahead == '2') ADVANCE(387);
      END_STATE();
    case 267:
      if (lookahead == '0') ADVANCE(388);
      if (lookahead == '8') ADVANCE(389);
      END_STATE();
    case 268:
      if (lookahead == '6') ADVANCE(390);
      END_STATE();
    case 269:
      if (lookahead == '4') ADVANCE(391);
      END_STATE();
    case 270:
      if (lookahead == '2') ADVANCE(392);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_int8);
      if (lookahead == '0') ADVANCE(393);
      if (lookahead == '8') ADVANCE(394);
      END_STATE();
    case 272:
      if (lookahead == '6') ADVANCE(395);
      END_STATE();
    case 273:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 274:
      if (lookahead == 'l') ADVANCE(397);
      END_STATE();
    case 275:
      if (lookahead == 'r') ADVANCE(398);
      END_STATE();
    case 276:
      if (lookahead == 'a') ADVANCE(399);
      END_STATE();
    case 277:
      if (lookahead == 'e') ADVANCE(400);
      END_STATE();
    case 278:
      if (lookahead == 'a') ADVANCE(401);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_log0);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_log1);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_log2);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_log3);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_log4);
      END_STATE();
    case 284:
      if (lookahead == 'i') ADVANCE(402);
      END_STATE();
    case 285:
      if (lookahead == 'r') ADVANCE(403);
      END_STATE();
    case 286:
      if (lookahead == 't') ADVANCE(404);
      END_STATE();
    case 287:
      if (lookahead == 'd') ADVANCE(405);
      END_STATE();
    case 288:
      if (lookahead == 'f') ADVANCE(406);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(407);
      END_STATE();
    case 290:
      if (lookahead == 'r') ADVANCE(408);
      END_STATE();
    case 291:
      if (lookahead == 'o') ADVANCE(409);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(410);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(411);
      END_STATE();
    case 294:
      if (lookahead == 'r') ADVANCE(412);
      END_STATE();
    case 295:
      if (lookahead == 'b') ADVANCE(413);
      END_STATE();
    case 296:
      if (lookahead == 'm') ADVANCE(414);
      END_STATE();
    case 297:
      if (lookahead == 'a') ADVANCE(415);
      END_STATE();
    case 298:
      if (lookahead == 'i') ADVANCE(416);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_pure);
      END_STATE();
    case 300:
      if (lookahead == 'i') ADVANCE(417);
      END_STATE();
    case 301:
      if (lookahead == 'r') ADVANCE(418);
      END_STATE();
    case 302:
      if (lookahead == 'r') ADVANCE(419);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_sdiv);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(420);
      END_STATE();
    case 305:
      if (lookahead == 'b') ADVANCE(421);
      if (lookahead == 'd') ADVANCE(422);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(423);
      END_STATE();
    case 307:
      if (lookahead == 'd') ADVANCE(424);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_smod);
      END_STATE();
    case 309:
      if (lookahead == 'd') ADVANCE(425);
      END_STATE();
    case 310:
      if (lookahead == 'r') ADVANCE(426);
      END_STATE();
    case 311:
      if (lookahead == 'i') ADVANCE(427);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_stop);
      END_STATE();
    case 313:
      if (lookahead == 'a') ADVANCE(428);
      END_STATE();
    case 314:
      if (lookahead == 'n') ADVANCE(429);
      END_STATE();
    case 315:
      if (lookahead == 'c') ADVANCE(430);
      END_STATE();
    case 316:
      if (lookahead == 'c') ADVANCE(431);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(432);
      END_STATE();
    case 318:
      if (lookahead == 's') ADVANCE(433);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 321:
      if (lookahead == 'e') ADVANCE(434);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_uint);
      if (lookahead == '1') ADVANCE(435);
      if (lookahead == '2') ADVANCE(436);
      if (lookahead == '3') ADVANCE(437);
      if (lookahead == '4') ADVANCE(438);
      if (lookahead == '5') ADVANCE(439);
      if (lookahead == '6') ADVANCE(440);
      if (lookahead == '7') ADVANCE(441);
      if (lookahead == '8') ADVANCE(442);
      if (lookahead == '9') ADVANCE(443);
      END_STATE();
    case 323:
      if (lookahead == 'e') ADVANCE(444);
      END_STATE();
    case 324:
      if (lookahead == 'o') ADVANCE(445);
      END_STATE();
    case 325:
      if (lookahead == 'g') ADVANCE(446);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_view);
      END_STATE();
    case 327:
      if (lookahead == 'u') ADVANCE(447);
      END_STATE();
    case 328:
      if (lookahead == 's') ADVANCE(448);
      END_STATE();
    case 329:
      if (lookahead == 'e') ADVANCE(449);
      END_STATE();
    case 330:
      if (lookahead == 's') ADVANCE(450);
      END_STATE();
    case 331:
      if (lookahead == 'a') ADVANCE(451);
      END_STATE();
    case 332:
      if (lookahead == 'd') ADVANCE(452);
      END_STATE();
    case 333:
      if (lookahead == 's') ADVANCE(453);
      END_STATE();
    case 334:
      if (lookahead == 'm') ADVANCE(454);
      END_STATE();
    case 335:
      if (lookahead == 'b') ADVANCE(455);
      END_STATE();
    case 336:
      if (lookahead == 'c') ADVANCE(456);
      END_STATE();
    case 337:
      if (lookahead == 'h') ADVANCE(457);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (lookahead == '1') ADVANCE(458);
      if (lookahead == '2') ADVANCE(459);
      if (lookahead == '3') ADVANCE(460);
      if (lookahead == '4') ADVANCE(461);
      if (lookahead == '5') ADVANCE(462);
      if (lookahead == '6') ADVANCE(463);
      if (lookahead == '7') ADVANCE(464);
      if (lookahead == '8') ADVANCE(465);
      if (lookahead == '9') ADVANCE(466);
      END_STATE();
    case 340:
      if (lookahead == 'o') ADVANCE(467);
      END_STATE();
    case 341:
      if (lookahead == 'a') ADVANCE(468);
      END_STATE();
    case 342:
      if (lookahead == 'r') ADVANCE(469);
      END_STATE();
    case 343:
      if (lookahead == 'a') ADVANCE(470);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 345:
      if (lookahead == 'i') ADVANCE(471);
      END_STATE();
    case 346:
      if (lookahead == 'a') ADVANCE(472);
      END_STATE();
    case 347:
      if (lookahead == 'a') ADVANCE(473);
      if (lookahead == 'r') ADVANCE(474);
      END_STATE();
    case 348:
      if (lookahead == 'n') ADVANCE(475);
      END_STATE();
    case 349:
      if (lookahead == 'a') ADVANCE(476);
      END_STATE();
    case 350:
      if (lookahead == 'e') ADVANCE(477);
      END_STATE();
    case 351:
      if (lookahead == 'l') ADVANCE(478);
      END_STATE();
    case 352:
      if (lookahead == 'a') ADVANCE(479);
      END_STATE();
    case 353:
      if (lookahead == 'e') ADVANCE(480);
      END_STATE();
    case 354:
      if (lookahead == 'c') ADVANCE(481);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_error);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_ether);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 358:
      if (lookahead == 'd') ADVANCE(482);
      END_STATE();
    case 359:
      if (lookahead == 'n') ADVANCE(483);
      END_STATE();
    case 360:
      if (lookahead == 'a') ADVANCE(484);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 362:
      if (lookahead == 'y') ADVANCE(485);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_fixed);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(486);
      END_STATE();
    case 364:
      if (lookahead == 'i') ADVANCE(487);
      END_STATE();
    case 365:
      if (lookahead == 'm') ADVANCE(488);
      END_STATE();
    case 366:
      if (lookahead == 'i') ADVANCE(489);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_hours);
      END_STATE();
    case 368:
      if (lookahead == 'a') ADVANCE(490);
      END_STATE();
    case 369:
      if (lookahead == 't') ADVANCE(491);
      END_STATE();
    case 370:
      if (lookahead == 'e') ADVANCE(492);
      END_STATE();
    case 371:
      if (lookahead == '4') ADVANCE(493);
      END_STATE();
    case 372:
      if (lookahead == '2') ADVANCE(494);
      END_STATE();
    case 373:
      if (lookahead == '0') ADVANCE(495);
      if (lookahead == '8') ADVANCE(496);
      END_STATE();
    case 374:
      if (lookahead == '6') ADVANCE(497);
      END_STATE();
    case 375:
      if (lookahead == '4') ADVANCE(498);
      END_STATE();
    case 376:
      if (lookahead == '2') ADVANCE(499);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_int16);
      if (lookahead == '0') ADVANCE(500);
      if (lookahead == '8') ADVANCE(501);
      END_STATE();
    case 378:
      if (lookahead == '6') ADVANCE(502);
      END_STATE();
    case 379:
      if (lookahead == '4') ADVANCE(503);
      END_STATE();
    case 380:
      if (lookahead == '2') ADVANCE(504);
      END_STATE();
    case 381:
      if (lookahead == '0') ADVANCE(505);
      if (lookahead == '8') ADVANCE(506);
      END_STATE();
    case 382:
      if (lookahead == '6') ADVANCE(507);
      END_STATE();
    case 383:
      if (lookahead == '4') ADVANCE(508);
      END_STATE();
    case 384:
      if (lookahead == '2') ADVANCE(509);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_int24);
      if (lookahead == '0') ADVANCE(510);
      if (lookahead == '8') ADVANCE(511);
      END_STATE();
    case 386:
      if (lookahead == '6') ADVANCE(512);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_int32);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_int40);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_int48);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_int56);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_int64);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_int72);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_int80);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_int88);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_int96);
      END_STATE();
    case 396:
      if (lookahead == 'f') ADVANCE(513);
      if (lookahead == 'n') ADVANCE(514);
      END_STATE();
    case 397:
      if (lookahead == 'i') ADVANCE(515);
      END_STATE();
    case 398:
      if (lookahead == 'o') ADVANCE(516);
      END_STATE();
    case 399:
      if (lookahead == 'k') ADVANCE(517);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_yul_leave);
      END_STATE();
    case 401:
      if (lookahead == 'r') ADVANCE(518);
      END_STATE();
    case 402:
      if (lookahead == 'n') ADVANCE(519);
      END_STATE();
    case 403:
      if (lookahead == 'y') ADVANCE(520);
      END_STATE();
    case 404:
      if (lookahead == 'e') ADVANCE(521);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_mload);
      END_STATE();
    case 406:
      if (lookahead == 'i') ADVANCE(522);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_msize);
      END_STATE();
    case 408:
      if (lookahead == 'e') ADVANCE(523);
      END_STATE();
    case 409:
      if (lookahead == 'd') ADVANCE(524);
      END_STATE();
    case 410:
      if (lookahead == 'r') ADVANCE(525);
      END_STATE();
    case 411:
      if (lookahead == 'n') ADVANCE(526);
      END_STATE();
    case 412:
      if (lookahead == 'i') ADVANCE(527);
      END_STATE();
    case 413:
      if (lookahead == 'l') ADVANCE(528);
      END_STATE();
    case 414:
      if (lookahead == 'a') ADVANCE(529);
      END_STATE();
    case 415:
      if (lookahead == 't') ADVANCE(530);
      END_STATE();
    case 416:
      if (lookahead == 'c') ADVANCE(531);
      END_STATE();
    case 417:
      if (lookahead == 'v') ADVANCE(532);
      END_STATE();
    case 418:
      if (lookahead == 'n') ADVANCE(533);
      END_STATE();
    case 419:
      if (lookahead == 't') ADVANCE(534);
      END_STATE();
    case 420:
      if (lookahead == 'd') ADVANCE(535);
      END_STATE();
    case 421:
      if (lookahead == 'a') ADVANCE(536);
      END_STATE();
    case 422:
      if (lookahead == 'e') ADVANCE(537);
      END_STATE();
    case 423:
      if (lookahead == 'x') ADVANCE(538);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_sload);
      END_STATE();
    case 425:
      if (lookahead == 'i') ADVANCE(539);
      END_STATE();
    case 426:
      if (lookahead == 'e') ADVANCE(540);
      END_STATE();
    case 427:
      if (lookahead == 'c') ADVANCE(541);
      END_STATE();
    case 428:
      if (lookahead == 'g') ADVANCE(542);
      END_STATE();
    case 429:
      if (lookahead == 'g') ADVANCE(543);
      END_STATE();
    case 430:
      if (lookahead == 't') ADVANCE(544);
      END_STATE();
    case 431:
      if (lookahead == 'h') ADVANCE(545);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_szabo);
      END_STATE();
    case 433:
      if (lookahead == 't') ADVANCE(546);
      END_STATE();
    case 434:
      if (lookahead == 'd') ADVANCE(547);
      END_STATE();
    case 435:
      if (lookahead == '0') ADVANCE(548);
      if (lookahead == '1') ADVANCE(549);
      if (lookahead == '2') ADVANCE(550);
      if (lookahead == '3') ADVANCE(551);
      if (lookahead == '4') ADVANCE(552);
      if (lookahead == '5') ADVANCE(553);
      if (lookahead == '6') ADVANCE(554);
      if (lookahead == '7') ADVANCE(555);
      if (lookahead == '8') ADVANCE(556);
      if (lookahead == '9') ADVANCE(557);
      END_STATE();
    case 436:
      if (lookahead == '0') ADVANCE(558);
      if (lookahead == '1') ADVANCE(559);
      if (lookahead == '2') ADVANCE(560);
      if (lookahead == '3') ADVANCE(561);
      if (lookahead == '4') ADVANCE(562);
      if (lookahead == '5') ADVANCE(563);
      END_STATE();
    case 437:
      if (lookahead == '2') ADVANCE(564);
      END_STATE();
    case 438:
      if (lookahead == '0') ADVANCE(565);
      if (lookahead == '8') ADVANCE(566);
      END_STATE();
    case 439:
      if (lookahead == '6') ADVANCE(567);
      END_STATE();
    case 440:
      if (lookahead == '4') ADVANCE(568);
      END_STATE();
    case 441:
      if (lookahead == '2') ADVANCE(569);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_uint8);
      if (lookahead == '0') ADVANCE(570);
      if (lookahead == '8') ADVANCE(571);
      END_STATE();
    case 443:
      if (lookahead == '6') ADVANCE(572);
      END_STATE();
    case 444:
      if (lookahead == 'c') ADVANCE(573);
      END_STATE();
    case 445:
      if (lookahead == 'd') ADVANCE(574);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 447:
      if (lookahead == 'a') ADVANCE(575);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_weeks);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_years);
      END_STATE();
    case 451:
      if (lookahead == 'c') ADVANCE(576);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_addmod);
      END_STATE();
    case 453:
      if (lookahead == 's') ADVANCE(577);
      END_STATE();
    case 454:
      if (lookahead == 'o') ADVANCE(578);
      END_STATE();
    case 455:
      if (lookahead == 'l') ADVANCE(579);
      END_STATE();
    case 456:
      if (lookahead == 'e') ADVANCE(580);
      END_STATE();
    case 457:
      if (lookahead == 'a') ADVANCE(581);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_bytes1);
      if (lookahead == '0') ADVANCE(582);
      if (lookahead == '1') ADVANCE(583);
      if (lookahead == '2') ADVANCE(584);
      if (lookahead == '3') ADVANCE(585);
      if (lookahead == '4') ADVANCE(586);
      if (lookahead == '5') ADVANCE(587);
      if (lookahead == '6') ADVANCE(588);
      if (lookahead == '7') ADVANCE(589);
      if (lookahead == '8') ADVANCE(590);
      if (lookahead == '9') ADVANCE(591);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_bytes2);
      if (lookahead == '0') ADVANCE(592);
      if (lookahead == '1') ADVANCE(593);
      if (lookahead == '2') ADVANCE(594);
      if (lookahead == '3') ADVANCE(595);
      if (lookahead == '4') ADVANCE(596);
      if (lookahead == '5') ADVANCE(597);
      if (lookahead == '6') ADVANCE(598);
      if (lookahead == '7') ADVANCE(599);
      if (lookahead == '8') ADVANCE(600);
      if (lookahead == '9') ADVANCE(601);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_bytes3);
      if (lookahead == '0') ADVANCE(602);
      if (lookahead == '1') ADVANCE(603);
      if (lookahead == '2') ADVANCE(604);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_bytes4);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_bytes5);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_bytes6);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_bytes7);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_bytes8);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_bytes9);
      END_STATE();
    case 467:
      if (lookahead == 'd') ADVANCE(605);
      END_STATE();
    case 468:
      if (lookahead == 't') ADVANCE(606);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_caller);
      END_STATE();
    case 470:
      if (lookahead == 'l') ADVANCE(607);
      END_STATE();
    case 471:
      if (lookahead == 'd') ADVANCE(608);
      END_STATE();
    case 472:
      if (lookahead == 's') ADVANCE(609);
      END_STATE();
    case 473:
      if (lookahead == 'n') ADVANCE(610);
      END_STATE();
    case 474:
      if (lookahead == 'u') ADVANCE(611);
      END_STATE();
    case 475:
      if (lookahead == 'u') ADVANCE(612);
      END_STATE();
    case 476:
      if (lookahead == 'c') ADVANCE(613);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_create);
      if (lookahead == '2') ADVANCE(614);
      END_STATE();
    case 478:
      if (lookahead == 't') ADVANCE(615);
      END_STATE();
    case 479:
      if (lookahead == 't') ADVANCE(616);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 481:
      if (lookahead == 'u') ADVANCE(617);
      END_STATE();
    case 482:
      if (lookahead == 'e') ADVANCE(618);
      END_STATE();
    case 483:
      if (lookahead == 'a') ADVANCE(619);
      END_STATE();
    case 484:
      if (lookahead == 'c') ADVANCE(620);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_finney);
      END_STATE();
    case 486:
      if (lookahead == 'x') ADVANCE(621);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(486);
      END_STATE();
    case 487:
      if (lookahead == 'o') ADVANCE(622);
      END_STATE();
    case 488:
      if (lookahead == 'i') ADVANCE(623);
      END_STATE();
    case 489:
      if (lookahead == 'c') ADVANCE(624);
      END_STATE();
    case 490:
      if (lookahead == 'b') ADVANCE(625);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 492:
      if (lookahead == 'd') ADVANCE(626);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_int104);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_int112);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_int120);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_int128);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_int136);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_int144);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_int152);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_int160);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_int168);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_int176);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_int184);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_int192);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_int200);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_int208);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_int216);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_int224);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_int232);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_int240);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_int248);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_int256);
      END_STATE();
    case 513:
      if (lookahead == 'a') ADVANCE(627);
      END_STATE();
    case 514:
      if (lookahead == 'a') ADVANCE(628);
      END_STATE();
    case 515:
      if (lookahead == 'd') ADVANCE(629);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_iszero);
      END_STATE();
    case 517:
      if (lookahead == '2') ADVANCE(630);
      END_STATE();
    case 518:
      if (lookahead == 'y') ADVANCE(631);
      END_STATE();
    case 519:
      if (lookahead == 'g') ADVANCE(632);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_memory);
      END_STATE();
    case 521:
      if (lookahead == 's') ADVANCE(633);
      END_STATE();
    case 522:
      if (lookahead == 'e') ADVANCE(634);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_mstore);
      if (lookahead == '8') ADVANCE(635);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_mulmod);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_origin);
      END_STATE();
    case 527:
      if (lookahead == 'd') ADVANCE(636);
      END_STATE();
    case 528:
      if (lookahead == 'e') ADVANCE(637);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_pragma);
      END_STATE();
    case 530:
      if (lookahead == 'e') ADVANCE(638);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 532:
      if (lookahead == 'e') ADVANCE(639);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == 'd') ADVANCE(640);
      if (lookahead == 's') ADVANCE(641);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_revert);
      END_STATE();
    case 535:
      if (lookahead == 's') ADVANCE(642);
      END_STATE();
    case 536:
      if (lookahead == 'l') ADVANCE(643);
      END_STATE();
    case 537:
      if (lookahead == 's') ADVANCE(644);
      END_STATE();
    case 538:
      if (lookahead == 't') ADVANCE(645);
      END_STATE();
    case 539:
      if (lookahead == 't') ADVANCE(646);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_sstore);
      END_STATE();
    case 541:
      if (lookahead == 'c') ADVANCE(647);
      END_STATE();
    case 542:
      if (lookahead == 'e') ADVANCE(648);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 546:
      if (lookahead == 'a') ADVANCE(649);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_ufixed);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(650);
      END_STATE();
    case 548:
      if (lookahead == '4') ADVANCE(651);
      END_STATE();
    case 549:
      if (lookahead == '2') ADVANCE(652);
      END_STATE();
    case 550:
      if (lookahead == '0') ADVANCE(653);
      if (lookahead == '8') ADVANCE(654);
      END_STATE();
    case 551:
      if (lookahead == '6') ADVANCE(655);
      END_STATE();
    case 552:
      if (lookahead == '4') ADVANCE(656);
      END_STATE();
    case 553:
      if (lookahead == '2') ADVANCE(657);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_uint16);
      if (lookahead == '0') ADVANCE(658);
      if (lookahead == '8') ADVANCE(659);
      END_STATE();
    case 555:
      if (lookahead == '6') ADVANCE(660);
      END_STATE();
    case 556:
      if (lookahead == '4') ADVANCE(661);
      END_STATE();
    case 557:
      if (lookahead == '2') ADVANCE(662);
      END_STATE();
    case 558:
      if (lookahead == '0') ADVANCE(663);
      if (lookahead == '8') ADVANCE(664);
      END_STATE();
    case 559:
      if (lookahead == '6') ADVANCE(665);
      END_STATE();
    case 560:
      if (lookahead == '4') ADVANCE(666);
      END_STATE();
    case 561:
      if (lookahead == '2') ADVANCE(667);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_uint24);
      if (lookahead == '0') ADVANCE(668);
      if (lookahead == '8') ADVANCE(669);
      END_STATE();
    case 563:
      if (lookahead == '6') ADVANCE(670);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_uint32);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_uint40);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(anon_sym_uint48);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_uint56);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_uint64);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_uint72);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_uint80);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_uint88);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_uint96);
      END_STATE();
    case 573:
      if (lookahead == 'k') ADVANCE(671);
      END_STATE();
    case 574:
      if (lookahead == 'e') ADVANCE(672);
      END_STATE();
    case 575:
      if (lookahead == 'l') ADVANCE(673);
      END_STATE();
    case 576:
      if (lookahead == 't') ADVANCE(674);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_address);
      END_STATE();
    case 578:
      if (lookahead == 'u') ADVANCE(675);
      END_STATE();
    case 579:
      if (lookahead == 'y') ADVANCE(676);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_balance);
      END_STATE();
    case 581:
      if (lookahead == 's') ADVANCE(677);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_bytes10);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_bytes11);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_bytes12);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(anon_sym_bytes13);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_bytes14);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_bytes15);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_bytes16);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(anon_sym_bytes17);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(anon_sym_bytes18);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(anon_sym_bytes19);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(anon_sym_bytes20);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(anon_sym_bytes21);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(anon_sym_bytes22);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(anon_sym_bytes23);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(anon_sym_bytes24);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(anon_sym_bytes25);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(anon_sym_bytes26);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(anon_sym_bytes27);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(anon_sym_bytes28);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(anon_sym_bytes29);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(anon_sym_bytes30);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(anon_sym_bytes31);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(anon_sym_bytes32);
      END_STATE();
    case 605:
      if (lookahead == 'e') ADVANCE(678);
      END_STATE();
    case 606:
      if (lookahead == 'a') ADVANCE(679);
      END_STATE();
    case 607:
      if (lookahead == 'u') ADVANCE(680);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(anon_sym_chainid);
      END_STATE();
    case 609:
      if (lookahead == 'e') ADVANCE(681);
      END_STATE();
    case 610:
      if (lookahead == 't') ADVANCE(682);
      END_STATE();
    case 611:
      if (lookahead == 'c') ADVANCE(683);
      END_STATE();
    case 612:
      if (lookahead == 'e') ADVANCE(684);
      END_STATE();
    case 613:
      if (lookahead == 't') ADVANCE(685);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(anon_sym_create2);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 616:
      if (lookahead == 'e') ADVANCE(686);
      END_STATE();
    case 617:
      if (lookahead == 'l') ADVANCE(687);
      END_STATE();
    case 618:
      if (lookahead == 'c') ADVANCE(688);
      if (lookahead == 'h') ADVANCE(689);
      if (lookahead == 's') ADVANCE(690);
      END_STATE();
    case 619:
      if (lookahead == 'l') ADVANCE(691);
      END_STATE();
    case 620:
      if (lookahead == 'k') ADVANCE(692);
      END_STATE();
    case 621:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(693);
      END_STATE();
    case 622:
      if (lookahead == 'n') ADVANCE(694);
      END_STATE();
    case 623:
      if (lookahead == 't') ADVANCE(695);
      END_STATE();
    case 624:
      if (lookahead == 'e') ADVANCE(696);
      END_STATE();
    case 625:
      if (lookahead == 'l') ADVANCE(697);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(anon_sym_indexed);
      END_STATE();
    case 627:
      if (lookahead == 'c') ADVANCE(698);
      END_STATE();
    case 628:
      if (lookahead == 'l') ADVANCE(699);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(anon_sym_invalid);
      END_STATE();
    case 630:
      if (lookahead == '5') ADVANCE(700);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(anon_sym_library);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(anon_sym_mapping);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(anon_sym_minutes);
      END_STATE();
    case 634:
      if (lookahead == 'r') ADVANCE(701);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(anon_sym_mstore8);
      END_STATE();
    case 636:
      if (lookahead == 'e') ADVANCE(702);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(anon_sym_payable);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(anon_sym_receive);
      END_STATE();
    case 640:
      if (lookahead == 'a') ADVANCE(703);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(anon_sym_returns);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(anon_sym_seconds);
      END_STATE();
    case 643:
      if (lookahead == 'a') ADVANCE(704);
      END_STATE();
    case 644:
      if (lookahead == 't') ADVANCE(705);
      END_STATE();
    case 645:
      if (lookahead == 'e') ADVANCE(706);
      END_STATE();
    case 646:
      if (lookahead == 'y') ADVANCE(707);
      END_STATE();
    case 647:
      if (lookahead == 'a') ADVANCE(708);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(anon_sym_storage);
      END_STATE();
    case 649:
      if (lookahead == 'm') ADVANCE(709);
      END_STATE();
    case 650:
      if (lookahead == 'x') ADVANCE(710);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(650);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(anon_sym_uint104);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(anon_sym_uint112);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(anon_sym_uint120);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(anon_sym_uint128);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(anon_sym_uint136);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(anon_sym_uint144);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(anon_sym_uint152);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(anon_sym_uint160);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(anon_sym_uint168);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(anon_sym_uint176);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(anon_sym_uint184);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(anon_sym_uint192);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(anon_sym_uint200);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(anon_sym_uint208);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(anon_sym_uint216);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(anon_sym_uint224);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(anon_sym_uint232);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(anon_sym_uint240);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(anon_sym_uint248);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(anon_sym_uint256);
      END_STATE();
    case 671:
      if (lookahead == 'e') ADVANCE(711);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(anon_sym_unicode);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_virtual);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 675:
      if (lookahead == 's') ADVANCE(712);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(anon_sym_assembly);
      END_STATE();
    case 677:
      if (lookahead == 'h') ADVANCE(713);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(anon_sym_callcode);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(anon_sym_calldata);
      if (lookahead == 'c') ADVANCE(714);
      if (lookahead == 'l') ADVANCE(715);
      if (lookahead == 's') ADVANCE(716);
      END_STATE();
    case 680:
      if (lookahead == 'e') ADVANCE(717);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(anon_sym_coinbase);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(anon_sym_constant);
      END_STATE();
    case 683:
      if (lookahead == 't') ADVANCE(718);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(anon_sym_contract);
      END_STATE();
    case 686:
      if (lookahead == 'c') ADVANCE(719);
      END_STATE();
    case 687:
      if (lookahead == 't') ADVANCE(720);
      END_STATE();
    case 688:
      if (lookahead == 'o') ADVANCE(721);
      END_STATE();
    case 689:
      if (lookahead == 'a') ADVANCE(722);
      END_STATE();
    case 690:
      if (lookahead == 'i') ADVANCE(723);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(anon_sym_fallback);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(aux_sym__fixed_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(693);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(anon_sym_gaslimit);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(anon_sym_gasprice);
      END_STATE();
    case 697:
      if (lookahead == 'e') ADVANCE(724);
      END_STATE();
    case 698:
      if (lookahead == 'e') ADVANCE(725);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(anon_sym_internal);
      END_STATE();
    case 700:
      if (lookahead == '6') ADVANCE(726);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(anon_sym_modifier);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 703:
      if (lookahead == 't') ADVANCE(727);
      END_STATE();
    case 704:
      if (lookahead == 'n') ADVANCE(728);
      END_STATE();
    case 705:
      if (lookahead == 'r') ADVANCE(729);
      END_STATE();
    case 706:
      if (lookahead == 'n') ADVANCE(730);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(anon_sym_solidity);
      END_STATE();
    case 708:
      if (lookahead == 'l') ADVANCE(731);
      END_STATE();
    case 709:
      if (lookahead == 'p') ADVANCE(732);
      END_STATE();
    case 710:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(733);
      END_STATE();
    case 711:
      if (lookahead == 'd') ADVANCE(734);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(anon_sym_anonymous);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(anon_sym_blockhash);
      END_STATE();
    case 714:
      if (lookahead == 'o') ADVANCE(735);
      END_STATE();
    case 715:
      if (lookahead == 'o') ADVANCE(736);
      END_STATE();
    case 716:
      if (lookahead == 'i') ADVANCE(737);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(anon_sym_callvalue);
      END_STATE();
    case 718:
      if (lookahead == 'o') ADVANCE(738);
      END_STATE();
    case 719:
      if (lookahead == 'a') ADVANCE(739);
      END_STATE();
    case 720:
      if (lookahead == 'y') ADVANCE(740);
      END_STATE();
    case 721:
      if (lookahead == 'p') ADVANCE(741);
      END_STATE();
    case 722:
      if (lookahead == 's') ADVANCE(742);
      END_STATE();
    case 723:
      if (lookahead == 'z') ADVANCE(743);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_immutable);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(anon_sym_keccak256);
      END_STATE();
    case 727:
      if (lookahead == 'a') ADVANCE(744);
      END_STATE();
    case 728:
      if (lookahead == 'c') ADVANCE(745);
      END_STATE();
    case 729:
      if (lookahead == 'u') ADVANCE(746);
      END_STATE();
    case 730:
      if (lookahead == 'd') ADVANCE(747);
      END_STATE();
    case 731:
      if (lookahead == 'l') ADVANCE(748);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(anon_sym_timestamp);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(aux_sym__ufixed_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(733);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym__unchecked);
      END_STATE();
    case 735:
      if (lookahead == 'p') ADVANCE(749);
      END_STATE();
    case 736:
      if (lookahead == 'a') ADVANCE(750);
      END_STATE();
    case 737:
      if (lookahead == 'z') ADVANCE(751);
      END_STATE();
    case 738:
      if (lookahead == 'r') ADVANCE(752);
      END_STATE();
    case 739:
      if (lookahead == 'l') ADVANCE(753);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(anon_sym_difficulty);
      END_STATE();
    case 741:
      if (lookahead == 'y') ADVANCE(754);
      END_STATE();
    case 742:
      if (lookahead == 'h') ADVANCE(755);
      END_STATE();
    case 743:
      if (lookahead == 'e') ADVANCE(756);
      END_STATE();
    case 744:
      if (lookahead == 'c') ADVANCE(757);
      if (lookahead == 's') ADVANCE(758);
      END_STATE();
    case 745:
      if (lookahead == 'e') ADVANCE(759);
      END_STATE();
    case 746:
      if (lookahead == 'c') ADVANCE(760);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(anon_sym_signextend);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(anon_sym_staticcall);
      END_STATE();
    case 749:
      if (lookahead == 'y') ADVANCE(761);
      END_STATE();
    case 750:
      if (lookahead == 'd') ADVANCE(762);
      END_STATE();
    case 751:
      if (lookahead == 'e') ADVANCE(763);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(anon_sym_constructor);
      END_STATE();
    case 753:
      if (lookahead == 'l') ADVANCE(764);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(anon_sym_extcodecopy);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(anon_sym_extcodehash);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(anon_sym_extcodesize);
      END_STATE();
    case 757:
      if (lookahead == 'o') ADVANCE(765);
      END_STATE();
    case 758:
      if (lookahead == 'i') ADVANCE(766);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(anon_sym_selfbalance);
      END_STATE();
    case 760:
      if (lookahead == 't') ADVANCE(767);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(anon_sym_calldatacopy);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(anon_sym_calldataload);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(anon_sym_calldatasize);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(anon_sym_delegatecall);
      END_STATE();
    case 765:
      if (lookahead == 'p') ADVANCE(768);
      END_STATE();
    case 766:
      if (lookahead == 'z') ADVANCE(769);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(anon_sym_selfdestruct);
      END_STATE();
    case 768:
      if (lookahead == 'y') ADVANCE(770);
      END_STATE();
    case 769:
      if (lookahead == 'e') ADVANCE(771);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(anon_sym_returndatacopy);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(anon_sym_returndatasize);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 50},
  [2] = {.lex_state = 11},
  [3] = {.lex_state = 11},
  [4] = {.lex_state = 11},
  [5] = {.lex_state = 11},
  [6] = {.lex_state = 11},
  [7] = {.lex_state = 11},
  [8] = {.lex_state = 11},
  [9] = {.lex_state = 11},
  [10] = {.lex_state = 11},
  [11] = {.lex_state = 11},
  [12] = {.lex_state = 11},
  [13] = {.lex_state = 11},
  [14] = {.lex_state = 11},
  [15] = {.lex_state = 11},
  [16] = {.lex_state = 11},
  [17] = {.lex_state = 11},
  [18] = {.lex_state = 11},
  [19] = {.lex_state = 11},
  [20] = {.lex_state = 11},
  [21] = {.lex_state = 11},
  [22] = {.lex_state = 11},
  [23] = {.lex_state = 11},
  [24] = {.lex_state = 11},
  [25] = {.lex_state = 11},
  [26] = {.lex_state = 11},
  [27] = {.lex_state = 11},
  [28] = {.lex_state = 11},
  [29] = {.lex_state = 11},
  [30] = {.lex_state = 11},
  [31] = {.lex_state = 11},
  [32] = {.lex_state = 11},
  [33] = {.lex_state = 11},
  [34] = {.lex_state = 11},
  [35] = {.lex_state = 11},
  [36] = {.lex_state = 11},
  [37] = {.lex_state = 11},
  [38] = {.lex_state = 11},
  [39] = {.lex_state = 11},
  [40] = {.lex_state = 11},
  [41] = {.lex_state = 11},
  [42] = {.lex_state = 11},
  [43] = {.lex_state = 11},
  [44] = {.lex_state = 11},
  [45] = {.lex_state = 11},
  [46] = {.lex_state = 11},
  [47] = {.lex_state = 11},
  [48] = {.lex_state = 11},
  [49] = {.lex_state = 11},
  [50] = {.lex_state = 11},
  [51] = {.lex_state = 11},
  [52] = {.lex_state = 11},
  [53] = {.lex_state = 11},
  [54] = {.lex_state = 11},
  [55] = {.lex_state = 11},
  [56] = {.lex_state = 11},
  [57] = {.lex_state = 11},
  [58] = {.lex_state = 11},
  [59] = {.lex_state = 11},
  [60] = {.lex_state = 11},
  [61] = {.lex_state = 11},
  [62] = {.lex_state = 11},
  [63] = {.lex_state = 11},
  [64] = {.lex_state = 11},
  [65] = {.lex_state = 11},
  [66] = {.lex_state = 11},
  [67] = {.lex_state = 11},
  [68] = {.lex_state = 11},
  [69] = {.lex_state = 11},
  [70] = {.lex_state = 11},
  [71] = {.lex_state = 11},
  [72] = {.lex_state = 50},
  [73] = {.lex_state = 50},
  [74] = {.lex_state = 11},
  [75] = {.lex_state = 11},
  [76] = {.lex_state = 11},
  [77] = {.lex_state = 11},
  [78] = {.lex_state = 11},
  [79] = {.lex_state = 11},
  [80] = {.lex_state = 11},
  [81] = {.lex_state = 11},
  [82] = {.lex_state = 11},
  [83] = {.lex_state = 11},
  [84] = {.lex_state = 11},
  [85] = {.lex_state = 11},
  [86] = {.lex_state = 11},
  [87] = {.lex_state = 50},
  [88] = {.lex_state = 11},
  [89] = {.lex_state = 11},
  [90] = {.lex_state = 50},
  [91] = {.lex_state = 50},
  [92] = {.lex_state = 11},
  [93] = {.lex_state = 11},
  [94] = {.lex_state = 11},
  [95] = {.lex_state = 11},
  [96] = {.lex_state = 11},
  [97] = {.lex_state = 11},
  [98] = {.lex_state = 11},
  [99] = {.lex_state = 11},
  [100] = {.lex_state = 11},
  [101] = {.lex_state = 11},
  [102] = {.lex_state = 11},
  [103] = {.lex_state = 11},
  [104] = {.lex_state = 50},
  [105] = {.lex_state = 50},
  [106] = {.lex_state = 50},
  [107] = {.lex_state = 50},
  [108] = {.lex_state = 50},
  [109] = {.lex_state = 50},
  [110] = {.lex_state = 50},
  [111] = {.lex_state = 50},
  [112] = {.lex_state = 50},
  [113] = {.lex_state = 50},
  [114] = {.lex_state = 50},
  [115] = {.lex_state = 50},
  [116] = {.lex_state = 50},
  [117] = {.lex_state = 50},
  [118] = {.lex_state = 50},
  [119] = {.lex_state = 50},
  [120] = {.lex_state = 50},
  [121] = {.lex_state = 50},
  [122] = {.lex_state = 50},
  [123] = {.lex_state = 50},
  [124] = {.lex_state = 50},
  [125] = {.lex_state = 50},
  [126] = {.lex_state = 50},
  [127] = {.lex_state = 50},
  [128] = {.lex_state = 50},
  [129] = {.lex_state = 50},
  [130] = {.lex_state = 50},
  [131] = {.lex_state = 50},
  [132] = {.lex_state = 50},
  [133] = {.lex_state = 50},
  [134] = {.lex_state = 50},
  [135] = {.lex_state = 50},
  [136] = {.lex_state = 50},
  [137] = {.lex_state = 50},
  [138] = {.lex_state = 50},
  [139] = {.lex_state = 50},
  [140] = {.lex_state = 50},
  [141] = {.lex_state = 50},
  [142] = {.lex_state = 50},
  [143] = {.lex_state = 50},
  [144] = {.lex_state = 50},
  [145] = {.lex_state = 50},
  [146] = {.lex_state = 50},
  [147] = {.lex_state = 50},
  [148] = {.lex_state = 50},
  [149] = {.lex_state = 50},
  [150] = {.lex_state = 50},
  [151] = {.lex_state = 50},
  [152] = {.lex_state = 50},
  [153] = {.lex_state = 50},
  [154] = {.lex_state = 50},
  [155] = {.lex_state = 50},
  [156] = {.lex_state = 50},
  [157] = {.lex_state = 50},
  [158] = {.lex_state = 50},
  [159] = {.lex_state = 50},
  [160] = {.lex_state = 50},
  [161] = {.lex_state = 50},
  [162] = {.lex_state = 50},
  [163] = {.lex_state = 50},
  [164] = {.lex_state = 50},
  [165] = {.lex_state = 50},
  [166] = {.lex_state = 50},
  [167] = {.lex_state = 50},
  [168] = {.lex_state = 50},
  [169] = {.lex_state = 50},
  [170] = {.lex_state = 50},
  [171] = {.lex_state = 50},
  [172] = {.lex_state = 50},
  [173] = {.lex_state = 50},
  [174] = {.lex_state = 50},
  [175] = {.lex_state = 50},
  [176] = {.lex_state = 50},
  [177] = {.lex_state = 50},
  [178] = {.lex_state = 50},
  [179] = {.lex_state = 50},
  [180] = {.lex_state = 50},
  [181] = {.lex_state = 50},
  [182] = {.lex_state = 50},
  [183] = {.lex_state = 50},
  [184] = {.lex_state = 50},
  [185] = {.lex_state = 50},
  [186] = {.lex_state = 50},
  [187] = {.lex_state = 50},
  [188] = {.lex_state = 50},
  [189] = {.lex_state = 50},
  [190] = {.lex_state = 50},
  [191] = {.lex_state = 50},
  [192] = {.lex_state = 50},
  [193] = {.lex_state = 50},
  [194] = {.lex_state = 50},
  [195] = {.lex_state = 50},
  [196] = {.lex_state = 50},
  [197] = {.lex_state = 50},
  [198] = {.lex_state = 50},
  [199] = {.lex_state = 50},
  [200] = {.lex_state = 50},
  [201] = {.lex_state = 50},
  [202] = {.lex_state = 50},
  [203] = {.lex_state = 50},
  [204] = {.lex_state = 50},
  [205] = {.lex_state = 50},
  [206] = {.lex_state = 50},
  [207] = {.lex_state = 50},
  [208] = {.lex_state = 50},
  [209] = {.lex_state = 50},
  [210] = {.lex_state = 50},
  [211] = {.lex_state = 50},
  [212] = {.lex_state = 50},
  [213] = {.lex_state = 50},
  [214] = {.lex_state = 50},
  [215] = {.lex_state = 50},
  [216] = {.lex_state = 50},
  [217] = {.lex_state = 50},
  [218] = {.lex_state = 50},
  [219] = {.lex_state = 50},
  [220] = {.lex_state = 50},
  [221] = {.lex_state = 50},
  [222] = {.lex_state = 50},
  [223] = {.lex_state = 50},
  [224] = {.lex_state = 50},
  [225] = {.lex_state = 50},
  [226] = {.lex_state = 50},
  [227] = {.lex_state = 50},
  [228] = {.lex_state = 50},
  [229] = {.lex_state = 50},
  [230] = {.lex_state = 50},
  [231] = {.lex_state = 50},
  [232] = {.lex_state = 50},
  [233] = {.lex_state = 50},
  [234] = {.lex_state = 50},
  [235] = {.lex_state = 50},
  [236] = {.lex_state = 50},
  [237] = {.lex_state = 50},
  [238] = {.lex_state = 50},
  [239] = {.lex_state = 50},
  [240] = {.lex_state = 50},
  [241] = {.lex_state = 50},
  [242] = {.lex_state = 50},
  [243] = {.lex_state = 50},
  [244] = {.lex_state = 50},
  [245] = {.lex_state = 50},
  [246] = {.lex_state = 50},
  [247] = {.lex_state = 50},
  [248] = {.lex_state = 50},
  [249] = {.lex_state = 50},
  [250] = {.lex_state = 50},
  [251] = {.lex_state = 50},
  [252] = {.lex_state = 50},
  [253] = {.lex_state = 50},
  [254] = {.lex_state = 50},
  [255] = {.lex_state = 50},
  [256] = {.lex_state = 50},
  [257] = {.lex_state = 50},
  [258] = {.lex_state = 50},
  [259] = {.lex_state = 50},
  [260] = {.lex_state = 50},
  [261] = {.lex_state = 50},
  [262] = {.lex_state = 50},
  [263] = {.lex_state = 50},
  [264] = {.lex_state = 50},
  [265] = {.lex_state = 50},
  [266] = {.lex_state = 50},
  [267] = {.lex_state = 50},
  [268] = {.lex_state = 50},
  [269] = {.lex_state = 50},
  [270] = {.lex_state = 50},
  [271] = {.lex_state = 50},
  [272] = {.lex_state = 50},
  [273] = {.lex_state = 50},
  [274] = {.lex_state = 50},
  [275] = {.lex_state = 50},
  [276] = {.lex_state = 50},
  [277] = {.lex_state = 50},
  [278] = {.lex_state = 50},
  [279] = {.lex_state = 50},
  [280] = {.lex_state = 50},
  [281] = {.lex_state = 50},
  [282] = {.lex_state = 50},
  [283] = {.lex_state = 50},
  [284] = {.lex_state = 50},
  [285] = {.lex_state = 50},
  [286] = {.lex_state = 50},
  [287] = {.lex_state = 50},
  [288] = {.lex_state = 50},
  [289] = {.lex_state = 50},
  [290] = {.lex_state = 50},
  [291] = {.lex_state = 50},
  [292] = {.lex_state = 50},
  [293] = {.lex_state = 50},
  [294] = {.lex_state = 50},
  [295] = {.lex_state = 50},
  [296] = {.lex_state = 10},
  [297] = {.lex_state = 9},
  [298] = {.lex_state = 9},
  [299] = {.lex_state = 10},
  [300] = {.lex_state = 9},
  [301] = {.lex_state = 9},
  [302] = {.lex_state = 9},
  [303] = {.lex_state = 9},
  [304] = {.lex_state = 9},
  [305] = {.lex_state = 9},
  [306] = {.lex_state = 9},
  [307] = {.lex_state = 10},
  [308] = {.lex_state = 10},
  [309] = {.lex_state = 10},
  [310] = {.lex_state = 10},
  [311] = {.lex_state = 9},
  [312] = {.lex_state = 9},
  [313] = {.lex_state = 9},
  [314] = {.lex_state = 9},
  [315] = {.lex_state = 9},
  [316] = {.lex_state = 9},
  [317] = {.lex_state = 9},
  [318] = {.lex_state = 9},
  [319] = {.lex_state = 9},
  [320] = {.lex_state = 9},
  [321] = {.lex_state = 9},
  [322] = {.lex_state = 9},
  [323] = {.lex_state = 9},
  [324] = {.lex_state = 9},
  [325] = {.lex_state = 9},
  [326] = {.lex_state = 9},
  [327] = {.lex_state = 9},
  [328] = {.lex_state = 9},
  [329] = {.lex_state = 9},
  [330] = {.lex_state = 9},
  [331] = {.lex_state = 9},
  [332] = {.lex_state = 9},
  [333] = {.lex_state = 9},
  [334] = {.lex_state = 9},
  [335] = {.lex_state = 9},
  [336] = {.lex_state = 9},
  [337] = {.lex_state = 9},
  [338] = {.lex_state = 9},
  [339] = {.lex_state = 9},
  [340] = {.lex_state = 9},
  [341] = {.lex_state = 9},
  [342] = {.lex_state = 9},
  [343] = {.lex_state = 9},
  [344] = {.lex_state = 9},
  [345] = {.lex_state = 9},
  [346] = {.lex_state = 9},
  [347] = {.lex_state = 9},
  [348] = {.lex_state = 9},
  [349] = {.lex_state = 9},
  [350] = {.lex_state = 9},
  [351] = {.lex_state = 9},
  [352] = {.lex_state = 9},
  [353] = {.lex_state = 9},
  [354] = {.lex_state = 9},
  [355] = {.lex_state = 9},
  [356] = {.lex_state = 9},
  [357] = {.lex_state = 9},
  [358] = {.lex_state = 9},
  [359] = {.lex_state = 9},
  [360] = {.lex_state = 9},
  [361] = {.lex_state = 9},
  [362] = {.lex_state = 9},
  [363] = {.lex_state = 9},
  [364] = {.lex_state = 9},
  [365] = {.lex_state = 9},
  [366] = {.lex_state = 9},
  [367] = {.lex_state = 9},
  [368] = {.lex_state = 9},
  [369] = {.lex_state = 9},
  [370] = {.lex_state = 9},
  [371] = {.lex_state = 9},
  [372] = {.lex_state = 9},
  [373] = {.lex_state = 9},
  [374] = {.lex_state = 9},
  [375] = {.lex_state = 9},
  [376] = {.lex_state = 9},
  [377] = {.lex_state = 9},
  [378] = {.lex_state = 9},
  [379] = {.lex_state = 9},
  [380] = {.lex_state = 9},
  [381] = {.lex_state = 9},
  [382] = {.lex_state = 9},
  [383] = {.lex_state = 9},
  [384] = {.lex_state = 9},
  [385] = {.lex_state = 9},
  [386] = {.lex_state = 9},
  [387] = {.lex_state = 9},
  [388] = {.lex_state = 9},
  [389] = {.lex_state = 9},
  [390] = {.lex_state = 50},
  [391] = {.lex_state = 50},
  [392] = {.lex_state = 9},
  [393] = {.lex_state = 50},
  [394] = {.lex_state = 50},
  [395] = {.lex_state = 50},
  [396] = {.lex_state = 50},
  [397] = {.lex_state = 50},
  [398] = {.lex_state = 50},
  [399] = {.lex_state = 50},
  [400] = {.lex_state = 50},
  [401] = {.lex_state = 50},
  [402] = {.lex_state = 50},
  [403] = {.lex_state = 50},
  [404] = {.lex_state = 9},
  [405] = {.lex_state = 50},
  [406] = {.lex_state = 50},
  [407] = {.lex_state = 50},
  [408] = {.lex_state = 50},
  [409] = {.lex_state = 50},
  [410] = {.lex_state = 50},
  [411] = {.lex_state = 50},
  [412] = {.lex_state = 50},
  [413] = {.lex_state = 50},
  [414] = {.lex_state = 50},
  [415] = {.lex_state = 50},
  [416] = {.lex_state = 50},
  [417] = {.lex_state = 9},
  [418] = {.lex_state = 50},
  [419] = {.lex_state = 50},
  [420] = {.lex_state = 50},
  [421] = {.lex_state = 50},
  [422] = {.lex_state = 50},
  [423] = {.lex_state = 50},
  [424] = {.lex_state = 50},
  [425] = {.lex_state = 50},
  [426] = {.lex_state = 50},
  [427] = {.lex_state = 16},
  [428] = {.lex_state = 16},
  [429] = {.lex_state = 50},
  [430] = {.lex_state = 50},
  [431] = {.lex_state = 50},
  [432] = {.lex_state = 50},
  [433] = {.lex_state = 50},
  [434] = {.lex_state = 50},
  [435] = {.lex_state = 50},
  [436] = {.lex_state = 50},
  [437] = {.lex_state = 50},
  [438] = {.lex_state = 50},
  [439] = {.lex_state = 50},
  [440] = {.lex_state = 50},
  [441] = {.lex_state = 50},
  [442] = {.lex_state = 50},
  [443] = {.lex_state = 50},
  [444] = {.lex_state = 50},
  [445] = {.lex_state = 5},
  [446] = {.lex_state = 5},
  [447] = {.lex_state = 5},
  [448] = {.lex_state = 50},
  [449] = {.lex_state = 5},
  [450] = {.lex_state = 50},
  [451] = {.lex_state = 50},
  [452] = {.lex_state = 5},
  [453] = {.lex_state = 50},
  [454] = {.lex_state = 50},
  [455] = {.lex_state = 50},
  [456] = {.lex_state = 50},
  [457] = {.lex_state = 5},
  [458] = {.lex_state = 50},
  [459] = {.lex_state = 50},
  [460] = {.lex_state = 50},
  [461] = {.lex_state = 50},
  [462] = {.lex_state = 50},
  [463] = {.lex_state = 50},
  [464] = {.lex_state = 50},
  [465] = {.lex_state = 50},
  [466] = {.lex_state = 50},
  [467] = {.lex_state = 50},
  [468] = {.lex_state = 1},
  [469] = {.lex_state = 3},
  [470] = {.lex_state = 50},
  [471] = {.lex_state = 12},
  [472] = {.lex_state = 1},
  [473] = {.lex_state = 3},
  [474] = {.lex_state = 50},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 3},
  [477] = {.lex_state = 50},
  [478] = {.lex_state = 3},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 50},
  [481] = {.lex_state = 3},
  [482] = {.lex_state = 1},
  [483] = {.lex_state = 50},
  [484] = {.lex_state = 50},
  [485] = {.lex_state = 50},
  [486] = {.lex_state = 50},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 50},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 50},
  [492] = {.lex_state = 50},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 50},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 50},
  [499] = {.lex_state = 50},
  [500] = {.lex_state = 12},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 50},
  [503] = {.lex_state = 50},
  [504] = {.lex_state = 50},
  [505] = {.lex_state = 50},
  [506] = {.lex_state = 50},
  [507] = {.lex_state = 50},
  [508] = {.lex_state = 50},
  [509] = {.lex_state = 12},
  [510] = {.lex_state = 3},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 3},
  [513] = {.lex_state = 1},
  [514] = {.lex_state = 1},
  [515] = {.lex_state = 50},
  [516] = {.lex_state = 12},
  [517] = {.lex_state = 12},
  [518] = {.lex_state = 3},
  [519] = {.lex_state = 1},
  [520] = {.lex_state = 50},
  [521] = {.lex_state = 12},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 50},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 50},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 50},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 50},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 50},
  [544] = {.lex_state = 50},
  [545] = {.lex_state = 50},
  [546] = {.lex_state = 50},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 50},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 50},
  [555] = {.lex_state = 50},
  [556] = {.lex_state = 50},
  [557] = {.lex_state = 50},
  [558] = {.lex_state = 50},
  [559] = {.lex_state = 50},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 50},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 16},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 50},
  [574] = {.lex_state = 50},
  [575] = {.lex_state = 16},
  [576] = {.lex_state = 50},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 50},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 16},
  [586] = {.lex_state = 50},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 50},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 50},
  [594] = {.lex_state = 50},
  [595] = {.lex_state = 50},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 50},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 50},
  [601] = {.lex_state = 16},
  [602] = {.lex_state = 50},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 50},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 50},
  [612] = {.lex_state = 50},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 50},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 50},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 50},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 50},
  [623] = {.lex_state = 50},
  [624] = {.lex_state = 50},
  [625] = {.lex_state = 50},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 12},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 50},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 50},
  [637] = {.lex_state = 12},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 50},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 50},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 50},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 50},
  [651] = {.lex_state = 50},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 50},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 50},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 10},
  [663] = {.lex_state = 50},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 50},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 50},
  [673] = {.lex_state = 22},
  [674] = {.lex_state = 50},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 50},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 50},
  [681] = {.lex_state = 50},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 50},
  [684] = {.lex_state = 50},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 50},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 50},
  [690] = {.lex_state = 50},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 50},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 50},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 50},
  [703] = {.lex_state = 50},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 50},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 50},
  [710] = {.lex_state = 50},
  [711] = {.lex_state = 50},
  [712] = {.lex_state = 50},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 50},
  [715] = {.lex_state = 50},
  [716] = {.lex_state = 5},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 50},
  [721] = {.lex_state = 50},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 5},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 50},
  [727] = {.lex_state = 50},
  [728] = {.lex_state = 50},
  [729] = {.lex_state = 50},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 11},
  [732] = {.lex_state = 50},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 50},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 50},
  [737] = {.lex_state = 50},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 50},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 50},
  [743] = {.lex_state = 50},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 50},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 50},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 50},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 50},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 50},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 50},
  [762] = {.lex_state = 50},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 11},
  [765] = {.lex_state = 50},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 50},
  [768] = {.lex_state = 12},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 50},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 50},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 50},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 50},
  [780] = {.lex_state = 11},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 50},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 50},
  [787] = {.lex_state = 50},
  [788] = {.lex_state = 50},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 50},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 50},
  [794] = {.lex_state = 50},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 50},
  [798] = {.lex_state = 50},
  [799] = {.lex_state = 50},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_pragma] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_solidity] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_constant] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_contract] = ACTIONS(1),
    [anon_sym_error] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_library] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_anonymous] = ACTIONS(1),
    [anon_sym_indexed] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_assembly] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_yul_leave] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_yul_decimal_number] = ACTIONS(1),
    [sym_yul_hex_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_stop] = ACTIONS(1),
    [anon_sym_add] = ACTIONS(1),
    [anon_sym_sub] = ACTIONS(1),
    [anon_sym_mul] = ACTIONS(1),
    [anon_sym_div] = ACTIONS(1),
    [anon_sym_sdiv] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_smod] = ACTIONS(1),
    [anon_sym_exp] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_lt] = ACTIONS(1),
    [anon_sym_gt] = ACTIONS(1),
    [anon_sym_slt] = ACTIONS(1),
    [anon_sym_sgt] = ACTIONS(1),
    [anon_sym_eq] = ACTIONS(1),
    [anon_sym_iszero] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_shl] = ACTIONS(1),
    [anon_sym_shr] = ACTIONS(1),
    [anon_sym_sar] = ACTIONS(1),
    [anon_sym_addmod] = ACTIONS(1),
    [anon_sym_mulmod] = ACTIONS(1),
    [anon_sym_signextend] = ACTIONS(1),
    [anon_sym_keccak256] = ACTIONS(1),
    [anon_sym_pop] = ACTIONS(1),
    [anon_sym_mload] = ACTIONS(1),
    [anon_sym_mstore] = ACTIONS(1),
    [anon_sym_mstore8] = ACTIONS(1),
    [anon_sym_sload] = ACTIONS(1),
    [anon_sym_sstore] = ACTIONS(1),
    [anon_sym_msize] = ACTIONS(1),
    [anon_sym_gas] = ACTIONS(1),
    [anon_sym_address] = ACTIONS(1),
    [anon_sym_balance] = ACTIONS(1),
    [anon_sym_selfbalance] = ACTIONS(1),
    [anon_sym_caller] = ACTIONS(1),
    [anon_sym_callvalue] = ACTIONS(1),
    [anon_sym_calldataload] = ACTIONS(1),
    [anon_sym_calldatasize] = ACTIONS(1),
    [anon_sym_calldatacopy] = ACTIONS(1),
    [anon_sym_extcodesize] = ACTIONS(1),
    [anon_sym_extcodecopy] = ACTIONS(1),
    [anon_sym_returndatasize] = ACTIONS(1),
    [anon_sym_returndatacopy] = ACTIONS(1),
    [anon_sym_extcodehash] = ACTIONS(1),
    [anon_sym_create] = ACTIONS(1),
    [anon_sym_create2] = ACTIONS(1),
    [anon_sym_call] = ACTIONS(1),
    [anon_sym_callcode] = ACTIONS(1),
    [anon_sym_delegatecall] = ACTIONS(1),
    [anon_sym_staticcall] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_revert] = ACTIONS(1),
    [anon_sym_selfdestruct] = ACTIONS(1),
    [anon_sym_invalid] = ACTIONS(1),
    [anon_sym_log0] = ACTIONS(1),
    [anon_sym_log1] = ACTIONS(1),
    [anon_sym_log2] = ACTIONS(1),
    [anon_sym_log3] = ACTIONS(1),
    [anon_sym_log4] = ACTIONS(1),
    [anon_sym_chainid] = ACTIONS(1),
    [anon_sym_origin] = ACTIONS(1),
    [anon_sym_gasprice] = ACTIONS(1),
    [anon_sym_blockhash] = ACTIONS(1),
    [anon_sym_coinbase] = ACTIONS(1),
    [anon_sym_timestamp] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_difficulty] = ACTIONS(1),
    [anon_sym_gaslimit] = ACTIONS(1),
    [sym__unchecked] = ACTIONS(1),
    [anon_sym_memory] = ACTIONS(1),
    [anon_sym_storage] = ACTIONS(1),
    [anon_sym_calldata] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_returns] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_emit] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_internal] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_pure] = ACTIONS(1),
    [anon_sym_view] = ACTIONS(1),
    [anon_sym_payable] = ACTIONS(1),
    [sym_immutable] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_modifier] = ACTIONS(1),
    [anon_sym_constructor] = ACTIONS(1),
    [anon_sym_fallback] = ACTIONS(1),
    [anon_sym_receive] = ACTIONS(1),
    [sym_virtual] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_mapping] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_int8] = ACTIONS(1),
    [anon_sym_int16] = ACTIONS(1),
    [anon_sym_int24] = ACTIONS(1),
    [anon_sym_int32] = ACTIONS(1),
    [anon_sym_int40] = ACTIONS(1),
    [anon_sym_int48] = ACTIONS(1),
    [anon_sym_int56] = ACTIONS(1),
    [anon_sym_int64] = ACTIONS(1),
    [anon_sym_int72] = ACTIONS(1),
    [anon_sym_int80] = ACTIONS(1),
    [anon_sym_int88] = ACTIONS(1),
    [anon_sym_int96] = ACTIONS(1),
    [anon_sym_int104] = ACTIONS(1),
    [anon_sym_int112] = ACTIONS(1),
    [anon_sym_int120] = ACTIONS(1),
    [anon_sym_int128] = ACTIONS(1),
    [anon_sym_int136] = ACTIONS(1),
    [anon_sym_int144] = ACTIONS(1),
    [anon_sym_int152] = ACTIONS(1),
    [anon_sym_int160] = ACTIONS(1),
    [anon_sym_int168] = ACTIONS(1),
    [anon_sym_int176] = ACTIONS(1),
    [anon_sym_int184] = ACTIONS(1),
    [anon_sym_int192] = ACTIONS(1),
    [anon_sym_int200] = ACTIONS(1),
    [anon_sym_int208] = ACTIONS(1),
    [anon_sym_int216] = ACTIONS(1),
    [anon_sym_int224] = ACTIONS(1),
    [anon_sym_int232] = ACTIONS(1),
    [anon_sym_int240] = ACTIONS(1),
    [anon_sym_int248] = ACTIONS(1),
    [anon_sym_int256] = ACTIONS(1),
    [anon_sym_uint] = ACTIONS(1),
    [anon_sym_uint8] = ACTIONS(1),
    [anon_sym_uint16] = ACTIONS(1),
    [anon_sym_uint24] = ACTIONS(1),
    [anon_sym_uint32] = ACTIONS(1),
    [anon_sym_uint40] = ACTIONS(1),
    [anon_sym_uint48] = ACTIONS(1),
    [anon_sym_uint56] = ACTIONS(1),
    [anon_sym_uint64] = ACTIONS(1),
    [anon_sym_uint72] = ACTIONS(1),
    [anon_sym_uint80] = ACTIONS(1),
    [anon_sym_uint88] = ACTIONS(1),
    [anon_sym_uint96] = ACTIONS(1),
    [anon_sym_uint104] = ACTIONS(1),
    [anon_sym_uint112] = ACTIONS(1),
    [anon_sym_uint120] = ACTIONS(1),
    [anon_sym_uint128] = ACTIONS(1),
    [anon_sym_uint136] = ACTIONS(1),
    [anon_sym_uint144] = ACTIONS(1),
    [anon_sym_uint152] = ACTIONS(1),
    [anon_sym_uint160] = ACTIONS(1),
    [anon_sym_uint168] = ACTIONS(1),
    [anon_sym_uint176] = ACTIONS(1),
    [anon_sym_uint184] = ACTIONS(1),
    [anon_sym_uint192] = ACTIONS(1),
    [anon_sym_uint200] = ACTIONS(1),
    [anon_sym_uint208] = ACTIONS(1),
    [anon_sym_uint216] = ACTIONS(1),
    [anon_sym_uint224] = ACTIONS(1),
    [anon_sym_uint232] = ACTIONS(1),
    [anon_sym_uint240] = ACTIONS(1),
    [anon_sym_uint248] = ACTIONS(1),
    [anon_sym_uint256] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_bytes1] = ACTIONS(1),
    [anon_sym_bytes2] = ACTIONS(1),
    [anon_sym_bytes3] = ACTIONS(1),
    [anon_sym_bytes4] = ACTIONS(1),
    [anon_sym_bytes5] = ACTIONS(1),
    [anon_sym_bytes6] = ACTIONS(1),
    [anon_sym_bytes7] = ACTIONS(1),
    [anon_sym_bytes8] = ACTIONS(1),
    [anon_sym_bytes9] = ACTIONS(1),
    [anon_sym_bytes10] = ACTIONS(1),
    [anon_sym_bytes11] = ACTIONS(1),
    [anon_sym_bytes12] = ACTIONS(1),
    [anon_sym_bytes13] = ACTIONS(1),
    [anon_sym_bytes14] = ACTIONS(1),
    [anon_sym_bytes15] = ACTIONS(1),
    [anon_sym_bytes16] = ACTIONS(1),
    [anon_sym_bytes17] = ACTIONS(1),
    [anon_sym_bytes18] = ACTIONS(1),
    [anon_sym_bytes19] = ACTIONS(1),
    [anon_sym_bytes20] = ACTIONS(1),
    [anon_sym_bytes21] = ACTIONS(1),
    [anon_sym_bytes22] = ACTIONS(1),
    [anon_sym_bytes23] = ACTIONS(1),
    [anon_sym_bytes24] = ACTIONS(1),
    [anon_sym_bytes25] = ACTIONS(1),
    [anon_sym_bytes26] = ACTIONS(1),
    [anon_sym_bytes27] = ACTIONS(1),
    [anon_sym_bytes28] = ACTIONS(1),
    [anon_sym_bytes29] = ACTIONS(1),
    [anon_sym_bytes30] = ACTIONS(1),
    [anon_sym_bytes31] = ACTIONS(1),
    [anon_sym_bytes32] = ACTIONS(1),
    [anon_sym_fixed] = ACTIONS(1),
    [aux_sym__fixed_token1] = ACTIONS(1),
    [anon_sym_ufixed] = ACTIONS(1),
    [aux_sym__ufixed_token1] = ACTIONS(1),
    [sym__semicolon] = ACTIONS(1),
    [anon_sym_wei] = ACTIONS(1),
    [anon_sym_szabo] = ACTIONS(1),
    [anon_sym_finney] = ACTIONS(1),
    [anon_sym_gwei] = ACTIONS(1),
    [anon_sym_ether] = ACTIONS(1),
    [anon_sym_seconds] = ACTIONS(1),
    [anon_sym_minutes] = ACTIONS(1),
    [anon_sym_hours] = ACTIONS(1),
    [anon_sym_days] = ACTIONS(1),
    [anon_sym_weeks] = ACTIONS(1),
    [anon_sym_years] = ACTIONS(1),
    [anon_sym_hex] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym__escape_sequence] = ACTIONS(1),
    [anon_sym_unicode] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(758),
    [sym__source_unit] = STATE(72),
    [sym__directive] = STATE(72),
    [sym_pragma_directive] = STATE(72),
    [sym_import_directive] = STATE(72),
    [sym__declaration] = STATE(72),
    [sym_user_defined_type_definition] = STATE(72),
    [sym_constant_variable_declaration] = STATE(72),
    [sym_contract_declaration] = STATE(72),
    [sym_error_declaration] = STATE(72),
    [sym_interface_declaration] = STATE(72),
    [sym_library_declaration] = STATE(72),
    [sym_struct_declaration] = STATE(72),
    [sym_enum_declaration] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_type_name] = STATE(663),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_source_file_repeat1] = STATE(72),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_pragma] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_abstract] = ACTIONS(15),
    [anon_sym_contract] = ACTIONS(17),
    [anon_sym_error] = ACTIONS(19),
    [anon_sym_interface] = ACTIONS(21),
    [anon_sym_library] = ACTIONS(23),
    [anon_sym_struct] = ACTIONS(25),
    [anon_sym_enum] = ACTIONS(27),
    [anon_sym_function] = ACTIONS(29),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__statement] = STATE(11),
    [sym_assembly_statement] = STATE(11),
    [sym_block_statement] = STATE(11),
    [sym_variable_declaration_statement] = STATE(11),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_while_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_revert_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_emit_statement] = STATE(11),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_struct_field_assignment] = STATE(553),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(11),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__statement] = STATE(4),
    [sym_assembly_statement] = STATE(4),
    [sym_block_statement] = STATE(4),
    [sym_variable_declaration_statement] = STATE(4),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(4),
    [sym_if_statement] = STATE(4),
    [sym_for_statement] = STATE(4),
    [sym_while_statement] = STATE(4),
    [sym_do_while_statement] = STATE(4),
    [sym_continue_statement] = STATE(4),
    [sym_break_statement] = STATE(4),
    [sym_revert_statement] = STATE(4),
    [sym_try_statement] = STATE(4),
    [sym_return_statement] = STATE(4),
    [sym_emit_statement] = STATE(4),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(4),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(107),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__statement] = STATE(5),
    [sym_assembly_statement] = STATE(5),
    [sym_block_statement] = STATE(5),
    [sym_variable_declaration_statement] = STATE(5),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_do_while_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_revert_statement] = STATE(5),
    [sym_try_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_emit_statement] = STATE(5),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(5),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__statement] = STATE(5),
    [sym_assembly_statement] = STATE(5),
    [sym_block_statement] = STATE(5),
    [sym_variable_declaration_statement] = STATE(5),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_do_while_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_revert_statement] = STATE(5),
    [sym_try_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_emit_statement] = STATE(5),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(5),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(111),
    [anon_sym_DASH] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(120),
    [anon_sym_RBRACE] = ACTIONS(123),
    [anon_sym_type] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(128),
    [anon_sym_for] = ACTIONS(131),
    [anon_sym_assembly] = ACTIONS(134),
    [anon_sym_break] = ACTIONS(137),
    [anon_sym_continue] = ACTIONS(140),
    [anon_sym_true] = ACTIONS(143),
    [anon_sym_false] = ACTIONS(146),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_function] = ACTIONS(152),
    [anon_sym_byte] = ACTIONS(155),
    [anon_sym_address] = ACTIONS(158),
    [anon_sym_return] = ACTIONS(161),
    [anon_sym_revert] = ACTIONS(164),
    [sym__unchecked] = ACTIONS(167),
    [anon_sym_var] = ACTIONS(170),
    [anon_sym_while] = ACTIONS(173),
    [anon_sym_do] = ACTIONS(176),
    [anon_sym_try] = ACTIONS(179),
    [anon_sym_emit] = ACTIONS(182),
    [anon_sym_payable] = ACTIONS(185),
    [anon_sym_new] = ACTIONS(188),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_PLUS] = ACTIONS(114),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_delete] = ACTIONS(194),
    [anon_sym_PLUS_PLUS] = ACTIONS(197),
    [anon_sym_DASH_DASH] = ACTIONS(197),
    [anon_sym_mapping] = ACTIONS(200),
    [anon_sym_bool] = ACTIONS(155),
    [anon_sym_string] = ACTIONS(155),
    [anon_sym_int] = ACTIONS(155),
    [anon_sym_int8] = ACTIONS(155),
    [anon_sym_int16] = ACTIONS(155),
    [anon_sym_int24] = ACTIONS(155),
    [anon_sym_int32] = ACTIONS(155),
    [anon_sym_int40] = ACTIONS(155),
    [anon_sym_int48] = ACTIONS(155),
    [anon_sym_int56] = ACTIONS(155),
    [anon_sym_int64] = ACTIONS(155),
    [anon_sym_int72] = ACTIONS(155),
    [anon_sym_int80] = ACTIONS(155),
    [anon_sym_int88] = ACTIONS(155),
    [anon_sym_int96] = ACTIONS(155),
    [anon_sym_int104] = ACTIONS(155),
    [anon_sym_int112] = ACTIONS(155),
    [anon_sym_int120] = ACTIONS(155),
    [anon_sym_int128] = ACTIONS(155),
    [anon_sym_int136] = ACTIONS(155),
    [anon_sym_int144] = ACTIONS(155),
    [anon_sym_int152] = ACTIONS(155),
    [anon_sym_int160] = ACTIONS(155),
    [anon_sym_int168] = ACTIONS(155),
    [anon_sym_int176] = ACTIONS(155),
    [anon_sym_int184] = ACTIONS(155),
    [anon_sym_int192] = ACTIONS(155),
    [anon_sym_int200] = ACTIONS(155),
    [anon_sym_int208] = ACTIONS(155),
    [anon_sym_int216] = ACTIONS(155),
    [anon_sym_int224] = ACTIONS(155),
    [anon_sym_int232] = ACTIONS(155),
    [anon_sym_int240] = ACTIONS(155),
    [anon_sym_int248] = ACTIONS(155),
    [anon_sym_int256] = ACTIONS(155),
    [anon_sym_uint] = ACTIONS(155),
    [anon_sym_uint8] = ACTIONS(155),
    [anon_sym_uint16] = ACTIONS(155),
    [anon_sym_uint24] = ACTIONS(155),
    [anon_sym_uint32] = ACTIONS(155),
    [anon_sym_uint40] = ACTIONS(155),
    [anon_sym_uint48] = ACTIONS(155),
    [anon_sym_uint56] = ACTIONS(155),
    [anon_sym_uint64] = ACTIONS(155),
    [anon_sym_uint72] = ACTIONS(155),
    [anon_sym_uint80] = ACTIONS(155),
    [anon_sym_uint88] = ACTIONS(155),
    [anon_sym_uint96] = ACTIONS(155),
    [anon_sym_uint104] = ACTIONS(155),
    [anon_sym_uint112] = ACTIONS(155),
    [anon_sym_uint120] = ACTIONS(155),
    [anon_sym_uint128] = ACTIONS(155),
    [anon_sym_uint136] = ACTIONS(155),
    [anon_sym_uint144] = ACTIONS(155),
    [anon_sym_uint152] = ACTIONS(155),
    [anon_sym_uint160] = ACTIONS(155),
    [anon_sym_uint168] = ACTIONS(155),
    [anon_sym_uint176] = ACTIONS(155),
    [anon_sym_uint184] = ACTIONS(155),
    [anon_sym_uint192] = ACTIONS(155),
    [anon_sym_uint200] = ACTIONS(155),
    [anon_sym_uint208] = ACTIONS(155),
    [anon_sym_uint216] = ACTIONS(155),
    [anon_sym_uint224] = ACTIONS(155),
    [anon_sym_uint232] = ACTIONS(155),
    [anon_sym_uint240] = ACTIONS(155),
    [anon_sym_uint248] = ACTIONS(155),
    [anon_sym_uint256] = ACTIONS(155),
    [anon_sym_bytes] = ACTIONS(155),
    [anon_sym_bytes1] = ACTIONS(155),
    [anon_sym_bytes2] = ACTIONS(155),
    [anon_sym_bytes3] = ACTIONS(155),
    [anon_sym_bytes4] = ACTIONS(155),
    [anon_sym_bytes5] = ACTIONS(155),
    [anon_sym_bytes6] = ACTIONS(155),
    [anon_sym_bytes7] = ACTIONS(155),
    [anon_sym_bytes8] = ACTIONS(155),
    [anon_sym_bytes9] = ACTIONS(155),
    [anon_sym_bytes10] = ACTIONS(155),
    [anon_sym_bytes11] = ACTIONS(155),
    [anon_sym_bytes12] = ACTIONS(155),
    [anon_sym_bytes13] = ACTIONS(155),
    [anon_sym_bytes14] = ACTIONS(155),
    [anon_sym_bytes15] = ACTIONS(155),
    [anon_sym_bytes16] = ACTIONS(155),
    [anon_sym_bytes17] = ACTIONS(155),
    [anon_sym_bytes18] = ACTIONS(155),
    [anon_sym_bytes19] = ACTIONS(155),
    [anon_sym_bytes20] = ACTIONS(155),
    [anon_sym_bytes21] = ACTIONS(155),
    [anon_sym_bytes22] = ACTIONS(155),
    [anon_sym_bytes23] = ACTIONS(155),
    [anon_sym_bytes24] = ACTIONS(155),
    [anon_sym_bytes25] = ACTIONS(155),
    [anon_sym_bytes26] = ACTIONS(155),
    [anon_sym_bytes27] = ACTIONS(155),
    [anon_sym_bytes28] = ACTIONS(155),
    [anon_sym_bytes29] = ACTIONS(155),
    [anon_sym_bytes30] = ACTIONS(155),
    [anon_sym_bytes31] = ACTIONS(155),
    [anon_sym_bytes32] = ACTIONS(155),
    [anon_sym_fixed] = ACTIONS(155),
    [aux_sym__fixed_token1] = ACTIONS(155),
    [anon_sym_ufixed] = ACTIONS(155),
    [aux_sym__ufixed_token1] = ACTIONS(155),
    [aux_sym__decimal_number_token1] = ACTIONS(203),
    [aux_sym__decimal_number_token2] = ACTIONS(206),
    [aux_sym__hex_number_token1] = ACTIONS(206),
    [anon_sym_hex] = ACTIONS(209),
    [anon_sym_DQUOTE] = ACTIONS(212),
    [anon_sym_SQUOTE] = ACTIONS(215),
    [anon_sym_unicode] = ACTIONS(218),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__statement] = STATE(10),
    [sym_assembly_statement] = STATE(10),
    [sym_block_statement] = STATE(10),
    [sym_variable_declaration_statement] = STATE(10),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_do_while_statement] = STATE(10),
    [sym_continue_statement] = STATE(10),
    [sym_break_statement] = STATE(10),
    [sym_revert_statement] = STATE(10),
    [sym_try_statement] = STATE(10),
    [sym_return_statement] = STATE(10),
    [sym_emit_statement] = STATE(10),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(10),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(221),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__statement] = STATE(11),
    [sym_assembly_statement] = STATE(11),
    [sym_block_statement] = STATE(11),
    [sym_variable_declaration_statement] = STATE(11),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_while_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_revert_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_emit_statement] = STATE(11),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(11),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__statement] = STATE(5),
    [sym_assembly_statement] = STATE(5),
    [sym_block_statement] = STATE(5),
    [sym_variable_declaration_statement] = STATE(5),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_do_while_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_revert_statement] = STATE(5),
    [sym_try_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_emit_statement] = STATE(5),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(5),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(225),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__statement] = STATE(8),
    [sym_assembly_statement] = STATE(8),
    [sym_block_statement] = STATE(8),
    [sym_variable_declaration_statement] = STATE(8),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(8),
    [sym_if_statement] = STATE(8),
    [sym_for_statement] = STATE(8),
    [sym_while_statement] = STATE(8),
    [sym_do_while_statement] = STATE(8),
    [sym_continue_statement] = STATE(8),
    [sym_break_statement] = STATE(8),
    [sym_revert_statement] = STATE(8),
    [sym_try_statement] = STATE(8),
    [sym_return_statement] = STATE(8),
    [sym_emit_statement] = STATE(8),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(8),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(227),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__statement] = STATE(5),
    [sym_assembly_statement] = STATE(5),
    [sym_block_statement] = STATE(5),
    [sym_variable_declaration_statement] = STATE(5),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_do_while_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_revert_statement] = STATE(5),
    [sym_try_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_emit_statement] = STATE(5),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(5),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__statement] = STATE(5),
    [sym_assembly_statement] = STATE(5),
    [sym_block_statement] = STATE(5),
    [sym_variable_declaration_statement] = STATE(5),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_do_while_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_revert_statement] = STATE(5),
    [sym_try_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_emit_statement] = STATE(5),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_block_statement_repeat1] = STATE(5),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(107),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__statement] = STATE(84),
    [sym_assembly_statement] = STATE(84),
    [sym_block_statement] = STATE(84),
    [sym_variable_declaration_statement] = STATE(84),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(84),
    [sym_if_statement] = STATE(84),
    [sym_for_statement] = STATE(84),
    [sym_while_statement] = STATE(84),
    [sym_do_while_statement] = STATE(84),
    [sym_continue_statement] = STATE(84),
    [sym_break_statement] = STATE(84),
    [sym_revert_statement] = STATE(84),
    [sym_try_statement] = STATE(84),
    [sym_return_statement] = STATE(84),
    [sym_emit_statement] = STATE(84),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__statement] = STATE(88),
    [sym_assembly_statement] = STATE(88),
    [sym_block_statement] = STATE(88),
    [sym_variable_declaration_statement] = STATE(88),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(88),
    [sym_if_statement] = STATE(88),
    [sym_for_statement] = STATE(88),
    [sym_while_statement] = STATE(88),
    [sym_do_while_statement] = STATE(88),
    [sym_continue_statement] = STATE(88),
    [sym_break_statement] = STATE(88),
    [sym_revert_statement] = STATE(88),
    [sym_try_statement] = STATE(88),
    [sym_return_statement] = STATE(88),
    [sym_emit_statement] = STATE(88),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__statement] = STATE(94),
    [sym_assembly_statement] = STATE(94),
    [sym_block_statement] = STATE(94),
    [sym_variable_declaration_statement] = STATE(94),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(94),
    [sym_if_statement] = STATE(94),
    [sym_for_statement] = STATE(94),
    [sym_while_statement] = STATE(94),
    [sym_do_while_statement] = STATE(94),
    [sym_continue_statement] = STATE(94),
    [sym_break_statement] = STATE(94),
    [sym_revert_statement] = STATE(94),
    [sym_try_statement] = STATE(94),
    [sym_return_statement] = STATE(94),
    [sym_emit_statement] = STATE(94),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__statement] = STATE(101),
    [sym_assembly_statement] = STATE(101),
    [sym_block_statement] = STATE(101),
    [sym_variable_declaration_statement] = STATE(101),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(101),
    [sym_if_statement] = STATE(101),
    [sym_for_statement] = STATE(101),
    [sym_while_statement] = STATE(101),
    [sym_do_while_statement] = STATE(101),
    [sym_continue_statement] = STATE(101),
    [sym_break_statement] = STATE(101),
    [sym_revert_statement] = STATE(101),
    [sym_try_statement] = STATE(101),
    [sym_return_statement] = STATE(101),
    [sym_emit_statement] = STATE(101),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__statement] = STATE(720),
    [sym_assembly_statement] = STATE(720),
    [sym_block_statement] = STATE(720),
    [sym_variable_declaration_statement] = STATE(720),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(720),
    [sym_if_statement] = STATE(720),
    [sym_for_statement] = STATE(720),
    [sym_while_statement] = STATE(720),
    [sym_do_while_statement] = STATE(720),
    [sym_continue_statement] = STATE(720),
    [sym_break_statement] = STATE(720),
    [sym_revert_statement] = STATE(720),
    [sym_try_statement] = STATE(720),
    [sym_return_statement] = STATE(720),
    [sym_emit_statement] = STATE(720),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__statement] = STATE(95),
    [sym_assembly_statement] = STATE(95),
    [sym_block_statement] = STATE(95),
    [sym_variable_declaration_statement] = STATE(95),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(95),
    [sym_if_statement] = STATE(95),
    [sym_for_statement] = STATE(95),
    [sym_while_statement] = STATE(95),
    [sym_do_while_statement] = STATE(95),
    [sym_continue_statement] = STATE(95),
    [sym_break_statement] = STATE(95),
    [sym_revert_statement] = STATE(95),
    [sym_try_statement] = STATE(95),
    [sym_return_statement] = STATE(95),
    [sym_emit_statement] = STATE(95),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_assembly] = ACTIONS(53),
    [anon_sym_break] = ACTIONS(55),
    [anon_sym_continue] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_revert] = ACTIONS(69),
    [sym__unchecked] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_while] = ACTIONS(75),
    [anon_sym_do] = ACTIONS(77),
    [anon_sym_try] = ACTIONS(79),
    [anon_sym_emit] = ACTIONS(81),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_variable_declaration] = STATE(566),
    [sym__expression] = STATE(396),
    [sym__primary_expression] = STATE(396),
    [sym_type_cast_expression] = STATE(396),
    [sym_ternary_expression] = STATE(396),
    [sym_new_expression] = STATE(396),
    [sym_tuple_expression] = STATE(396),
    [sym_inline_array_expression] = STATE(396),
    [sym_binary_expression] = STATE(396),
    [sym_unary_expression] = STATE(396),
    [sym_update_expression] = STATE(396),
    [sym_member_expression] = STATE(396),
    [sym_array_access] = STATE(396),
    [sym_slice_access] = STATE(396),
    [sym_struct_expression] = STATE(396),
    [sym_parenthesized_expression] = STATE(396),
    [sym_assignment_expression] = STATE(396),
    [sym_augmented_assignment_expression] = STATE(396),
    [sym_call_expression] = STATE(396),
    [sym_payable_conversion_expression] = STATE(396),
    [sym_meta_type_expression] = STATE(396),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(396),
    [sym_string_literal] = STATE(396),
    [sym_number_literal] = STATE(396),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(396),
    [sym_hex_string_literal] = STATE(396),
    [sym_unicode_string_literal] = STATE(396),
    [sym_string] = STATE(333),
    [aux_sym_variable_declaration_tuple_repeat1] = STATE(568),
    [aux_sym_tuple_expression_repeat1] = STATE(549),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_COMMA] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(235),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_variable_declaration_statement] = STATE(29),
    [sym_variable_declaration] = STATE(703),
    [sym_variable_declaration_tuple] = STATE(721),
    [sym_expression_statement] = STATE(29),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym__semicolon] = ACTIONS(237),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_variable_declaration] = STATE(685),
    [sym__expression] = STATE(398),
    [sym__primary_expression] = STATE(398),
    [sym_type_cast_expression] = STATE(398),
    [sym_ternary_expression] = STATE(398),
    [sym_new_expression] = STATE(398),
    [sym_tuple_expression] = STATE(398),
    [sym_inline_array_expression] = STATE(398),
    [sym_binary_expression] = STATE(398),
    [sym_unary_expression] = STATE(398),
    [sym_update_expression] = STATE(398),
    [sym_member_expression] = STATE(398),
    [sym_array_access] = STATE(398),
    [sym_slice_access] = STATE(398),
    [sym_struct_expression] = STATE(398),
    [sym_parenthesized_expression] = STATE(398),
    [sym_assignment_expression] = STATE(398),
    [sym_augmented_assignment_expression] = STATE(398),
    [sym_call_expression] = STATE(398),
    [sym_payable_conversion_expression] = STATE(398),
    [sym_meta_type_expression] = STATE(398),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(390),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(391),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(398),
    [sym_string_literal] = STATE(398),
    [sym_number_literal] = STATE(398),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(398),
    [sym_hex_string_literal] = STATE(398),
    [sym_unicode_string_literal] = STATE(398),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_call_argument] = STATE(548),
    [sym__expression] = STATE(395),
    [sym__primary_expression] = STATE(395),
    [sym_type_cast_expression] = STATE(395),
    [sym_ternary_expression] = STATE(395),
    [sym_new_expression] = STATE(395),
    [sym_tuple_expression] = STATE(395),
    [sym_inline_array_expression] = STATE(395),
    [sym_binary_expression] = STATE(395),
    [sym_unary_expression] = STATE(395),
    [sym_update_expression] = STATE(395),
    [sym_member_expression] = STATE(395),
    [sym_array_access] = STATE(395),
    [sym_slice_access] = STATE(395),
    [sym_struct_expression] = STATE(395),
    [sym_parenthesized_expression] = STATE(395),
    [sym_assignment_expression] = STATE(395),
    [sym_augmented_assignment_expression] = STATE(395),
    [sym_call_expression] = STATE(395),
    [sym_payable_conversion_expression] = STATE(395),
    [sym_meta_type_expression] = STATE(395),
    [sym_user_defined_type] = STATE(395),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(395),
    [sym_string_literal] = STATE(395),
    [sym_number_literal] = STATE(395),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(395),
    [sym_hex_string_literal] = STATE(395),
    [sym_unicode_string_literal] = STATE(395),
    [sym_string] = STATE(333),
    [aux_sym_tuple_expression_repeat1] = STATE(549),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_COMMA] = ACTIONS(246),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__expression] = STATE(396),
    [sym__primary_expression] = STATE(396),
    [sym_type_cast_expression] = STATE(396),
    [sym_ternary_expression] = STATE(396),
    [sym_new_expression] = STATE(396),
    [sym_tuple_expression] = STATE(396),
    [sym_inline_array_expression] = STATE(396),
    [sym_binary_expression] = STATE(396),
    [sym_unary_expression] = STATE(396),
    [sym_update_expression] = STATE(396),
    [sym_member_expression] = STATE(396),
    [sym_array_access] = STATE(396),
    [sym_slice_access] = STATE(396),
    [sym_struct_expression] = STATE(396),
    [sym_parenthesized_expression] = STATE(396),
    [sym_assignment_expression] = STATE(396),
    [sym_augmented_assignment_expression] = STATE(396),
    [sym_call_expression] = STATE(396),
    [sym_payable_conversion_expression] = STATE(396),
    [sym_meta_type_expression] = STATE(396),
    [sym_user_defined_type] = STATE(396),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(396),
    [sym_string_literal] = STATE(396),
    [sym_number_literal] = STATE(396),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(396),
    [sym_hex_string_literal] = STATE(396),
    [sym_unicode_string_literal] = STATE(396),
    [sym_string] = STATE(333),
    [aux_sym_tuple_expression_repeat1] = STATE(549),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_COMMA] = ACTIONS(246),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(250),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_call_argument] = STATE(628),
    [sym__expression] = STATE(400),
    [sym__primary_expression] = STATE(400),
    [sym_type_cast_expression] = STATE(400),
    [sym_ternary_expression] = STATE(400),
    [sym_new_expression] = STATE(400),
    [sym_tuple_expression] = STATE(400),
    [sym_inline_array_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_member_expression] = STATE(400),
    [sym_array_access] = STATE(400),
    [sym_slice_access] = STATE(400),
    [sym_struct_expression] = STATE(400),
    [sym_parenthesized_expression] = STATE(400),
    [sym_assignment_expression] = STATE(400),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym_call_expression] = STATE(400),
    [sym_payable_conversion_expression] = STATE(400),
    [sym_meta_type_expression] = STATE(400),
    [sym_user_defined_type] = STATE(400),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(400),
    [sym_string_literal] = STATE(400),
    [sym_number_literal] = STATE(400),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(400),
    [sym_hex_string_literal] = STATE(400),
    [sym_unicode_string_literal] = STATE(400),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_call_argument] = STATE(628),
    [sym__expression] = STATE(400),
    [sym__primary_expression] = STATE(400),
    [sym_type_cast_expression] = STATE(400),
    [sym_ternary_expression] = STATE(400),
    [sym_new_expression] = STATE(400),
    [sym_tuple_expression] = STATE(400),
    [sym_inline_array_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_member_expression] = STATE(400),
    [sym_array_access] = STATE(400),
    [sym_slice_access] = STATE(400),
    [sym_struct_expression] = STATE(400),
    [sym_parenthesized_expression] = STATE(400),
    [sym_assignment_expression] = STATE(400),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym_call_expression] = STATE(400),
    [sym_payable_conversion_expression] = STATE(400),
    [sym_meta_type_expression] = STATE(400),
    [sym_user_defined_type] = STATE(400),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(400),
    [sym_string_literal] = STATE(400),
    [sym_number_literal] = STATE(400),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(400),
    [sym_hex_string_literal] = STATE(400),
    [sym_unicode_string_literal] = STATE(400),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(254),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_call_argument] = STATE(548),
    [sym__expression] = STATE(400),
    [sym__primary_expression] = STATE(400),
    [sym_type_cast_expression] = STATE(400),
    [sym_ternary_expression] = STATE(400),
    [sym_new_expression] = STATE(400),
    [sym_tuple_expression] = STATE(400),
    [sym_inline_array_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_member_expression] = STATE(400),
    [sym_array_access] = STATE(400),
    [sym_slice_access] = STATE(400),
    [sym_struct_expression] = STATE(400),
    [sym_parenthesized_expression] = STATE(400),
    [sym_assignment_expression] = STATE(400),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym_call_expression] = STATE(400),
    [sym_payable_conversion_expression] = STATE(400),
    [sym_meta_type_expression] = STATE(400),
    [sym_user_defined_type] = STATE(400),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(400),
    [sym_string_literal] = STATE(400),
    [sym_number_literal] = STATE(400),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(400),
    [sym_hex_string_literal] = STATE(400),
    [sym_unicode_string_literal] = STATE(400),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(256),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_call_argument] = STATE(628),
    [sym__expression] = STATE(400),
    [sym__primary_expression] = STATE(400),
    [sym_type_cast_expression] = STATE(400),
    [sym_ternary_expression] = STATE(400),
    [sym_new_expression] = STATE(400),
    [sym_tuple_expression] = STATE(400),
    [sym_inline_array_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_member_expression] = STATE(400),
    [sym_array_access] = STATE(400),
    [sym_slice_access] = STATE(400),
    [sym_struct_expression] = STATE(400),
    [sym_parenthesized_expression] = STATE(400),
    [sym_assignment_expression] = STATE(400),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym_call_expression] = STATE(400),
    [sym_payable_conversion_expression] = STATE(400),
    [sym_meta_type_expression] = STATE(400),
    [sym_user_defined_type] = STATE(400),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(400),
    [sym_string_literal] = STATE(400),
    [sym_number_literal] = STATE(400),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(400),
    [sym_hex_string_literal] = STATE(400),
    [sym_unicode_string_literal] = STATE(400),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__expression] = STATE(398),
    [sym__primary_expression] = STATE(398),
    [sym_type_cast_expression] = STATE(398),
    [sym_ternary_expression] = STATE(398),
    [sym_new_expression] = STATE(398),
    [sym_tuple_expression] = STATE(398),
    [sym_inline_array_expression] = STATE(398),
    [sym_binary_expression] = STATE(398),
    [sym_unary_expression] = STATE(398),
    [sym_update_expression] = STATE(398),
    [sym_member_expression] = STATE(398),
    [sym_array_access] = STATE(398),
    [sym_slice_access] = STATE(398),
    [sym_struct_expression] = STATE(398),
    [sym_parenthesized_expression] = STATE(398),
    [sym_assignment_expression] = STATE(398),
    [sym_augmented_assignment_expression] = STATE(398),
    [sym_call_expression] = STATE(398),
    [sym_payable_conversion_expression] = STATE(398),
    [sym_meta_type_expression] = STATE(398),
    [sym_user_defined_type] = STATE(398),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(398),
    [sym_string_literal] = STATE(398),
    [sym_number_literal] = STATE(398),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(398),
    [sym_hex_string_literal] = STATE(398),
    [sym_unicode_string_literal] = STATE(398),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(260),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__expression] = STATE(398),
    [sym__primary_expression] = STATE(398),
    [sym_type_cast_expression] = STATE(398),
    [sym_ternary_expression] = STATE(398),
    [sym_new_expression] = STATE(398),
    [sym_tuple_expression] = STATE(398),
    [sym_inline_array_expression] = STATE(398),
    [sym_binary_expression] = STATE(398),
    [sym_unary_expression] = STATE(398),
    [sym_update_expression] = STATE(398),
    [sym_member_expression] = STATE(398),
    [sym_array_access] = STATE(398),
    [sym_slice_access] = STATE(398),
    [sym_struct_expression] = STATE(398),
    [sym_parenthesized_expression] = STATE(398),
    [sym_assignment_expression] = STATE(398),
    [sym_augmented_assignment_expression] = STATE(398),
    [sym_call_expression] = STATE(398),
    [sym_payable_conversion_expression] = STATE(398),
    [sym_meta_type_expression] = STATE(398),
    [sym_user_defined_type] = STATE(398),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(398),
    [sym_string_literal] = STATE(398),
    [sym_number_literal] = STATE(398),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(398),
    [sym_hex_string_literal] = STATE(398),
    [sym_unicode_string_literal] = STATE(398),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(258),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_expression_statement] = STATE(37),
    [sym__expression] = STATE(415),
    [sym__primary_expression] = STATE(415),
    [sym_type_cast_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_tuple_expression] = STATE(415),
    [sym_inline_array_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_member_expression] = STATE(415),
    [sym_array_access] = STATE(415),
    [sym_slice_access] = STATE(415),
    [sym_struct_expression] = STATE(415),
    [sym_parenthesized_expression] = STATE(415),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_payable_conversion_expression] = STATE(415),
    [sym_meta_type_expression] = STATE(415),
    [sym_user_defined_type] = STATE(415),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_number_literal] = STATE(415),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(415),
    [sym_hex_string_literal] = STATE(415),
    [sym_unicode_string_literal] = STATE(415),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym__semicolon] = ACTIONS(262),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__expression] = STATE(404),
    [sym__primary_expression] = STATE(404),
    [sym_type_cast_expression] = STATE(404),
    [sym_ternary_expression] = STATE(404),
    [sym_new_expression] = STATE(404),
    [sym_tuple_expression] = STATE(404),
    [sym_inline_array_expression] = STATE(404),
    [sym_binary_expression] = STATE(404),
    [sym_unary_expression] = STATE(404),
    [sym_update_expression] = STATE(404),
    [sym_member_expression] = STATE(404),
    [sym_array_access] = STATE(404),
    [sym_slice_access] = STATE(404),
    [sym_struct_expression] = STATE(404),
    [sym_parenthesized_expression] = STATE(404),
    [sym_assignment_expression] = STATE(404),
    [sym_augmented_assignment_expression] = STATE(404),
    [sym_call_expression] = STATE(404),
    [sym_payable_conversion_expression] = STATE(404),
    [sym_meta_type_expression] = STATE(404),
    [sym_user_defined_type] = STATE(404),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(404),
    [sym_string_literal] = STATE(404),
    [sym_number_literal] = STATE(404),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(404),
    [sym_hex_string_literal] = STATE(404),
    [sym_unicode_string_literal] = STATE(404),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_COLON] = ACTIONS(264),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_RBRACK] = ACTIONS(266),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__expression] = STATE(398),
    [sym__primary_expression] = STATE(398),
    [sym_type_cast_expression] = STATE(398),
    [sym_ternary_expression] = STATE(398),
    [sym_new_expression] = STATE(398),
    [sym_tuple_expression] = STATE(398),
    [sym_inline_array_expression] = STATE(398),
    [sym_binary_expression] = STATE(398),
    [sym_unary_expression] = STATE(398),
    [sym_update_expression] = STATE(398),
    [sym_member_expression] = STATE(398),
    [sym_array_access] = STATE(398),
    [sym_slice_access] = STATE(398),
    [sym_struct_expression] = STATE(398),
    [sym_parenthesized_expression] = STATE(398),
    [sym_assignment_expression] = STATE(398),
    [sym_augmented_assignment_expression] = STATE(398),
    [sym_call_expression] = STATE(398),
    [sym_payable_conversion_expression] = STATE(398),
    [sym_meta_type_expression] = STATE(398),
    [sym_user_defined_type] = STATE(398),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(398),
    [sym_string_literal] = STATE(398),
    [sym_number_literal] = STATE(398),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(398),
    [sym_hex_string_literal] = STATE(398),
    [sym_unicode_string_literal] = STATE(398),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(268),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__call_arguments] = STATE(722),
    [sym__expression] = STATE(405),
    [sym__primary_expression] = STATE(405),
    [sym_type_cast_expression] = STATE(405),
    [sym_ternary_expression] = STATE(405),
    [sym_new_expression] = STATE(405),
    [sym_tuple_expression] = STATE(405),
    [sym_inline_array_expression] = STATE(405),
    [sym_binary_expression] = STATE(405),
    [sym_unary_expression] = STATE(405),
    [sym_update_expression] = STATE(405),
    [sym_member_expression] = STATE(405),
    [sym_array_access] = STATE(405),
    [sym_slice_access] = STATE(405),
    [sym_struct_expression] = STATE(405),
    [sym_parenthesized_expression] = STATE(405),
    [sym_assignment_expression] = STATE(405),
    [sym_augmented_assignment_expression] = STATE(405),
    [sym_call_expression] = STATE(405),
    [sym_payable_conversion_expression] = STATE(405),
    [sym_meta_type_expression] = STATE(405),
    [sym_user_defined_type] = STATE(405),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(405),
    [sym_string_literal] = STATE(405),
    [sym_number_literal] = STATE(405),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(405),
    [sym_hex_string_literal] = STATE(405),
    [sym_unicode_string_literal] = STATE(405),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(270),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym__semicolon] = ACTIONS(272),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__expression] = STATE(398),
    [sym__primary_expression] = STATE(398),
    [sym_type_cast_expression] = STATE(398),
    [sym_ternary_expression] = STATE(398),
    [sym_new_expression] = STATE(398),
    [sym_tuple_expression] = STATE(398),
    [sym_inline_array_expression] = STATE(398),
    [sym_binary_expression] = STATE(398),
    [sym_unary_expression] = STATE(398),
    [sym_update_expression] = STATE(398),
    [sym_member_expression] = STATE(398),
    [sym_array_access] = STATE(398),
    [sym_slice_access] = STATE(398),
    [sym_struct_expression] = STATE(398),
    [sym_parenthesized_expression] = STATE(398),
    [sym_assignment_expression] = STATE(398),
    [sym_augmented_assignment_expression] = STATE(398),
    [sym_call_expression] = STATE(398),
    [sym_payable_conversion_expression] = STATE(398),
    [sym_meta_type_expression] = STATE(398),
    [sym_user_defined_type] = STATE(398),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(398),
    [sym_string_literal] = STATE(398),
    [sym_number_literal] = STATE(398),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(398),
    [sym_hex_string_literal] = STATE(398),
    [sym_unicode_string_literal] = STATE(398),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(274),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__expression] = STATE(399),
    [sym__primary_expression] = STATE(399),
    [sym_type_cast_expression] = STATE(399),
    [sym_ternary_expression] = STATE(399),
    [sym_new_expression] = STATE(399),
    [sym_tuple_expression] = STATE(399),
    [sym_inline_array_expression] = STATE(399),
    [sym_binary_expression] = STATE(399),
    [sym_unary_expression] = STATE(399),
    [sym_update_expression] = STATE(399),
    [sym_member_expression] = STATE(399),
    [sym_array_access] = STATE(399),
    [sym_slice_access] = STATE(399),
    [sym_struct_expression] = STATE(399),
    [sym_parenthesized_expression] = STATE(399),
    [sym_assignment_expression] = STATE(399),
    [sym_augmented_assignment_expression] = STATE(399),
    [sym_call_expression] = STATE(399),
    [sym_payable_conversion_expression] = STATE(399),
    [sym_meta_type_expression] = STATE(399),
    [sym_user_defined_type] = STATE(399),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(399),
    [sym_string_literal] = STATE(399),
    [sym_number_literal] = STATE(399),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(399),
    [sym_hex_string_literal] = STATE(399),
    [sym_unicode_string_literal] = STATE(399),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_RBRACK] = ACTIONS(276),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__expression] = STATE(411),
    [sym__primary_expression] = STATE(411),
    [sym_type_cast_expression] = STATE(411),
    [sym_ternary_expression] = STATE(411),
    [sym_new_expression] = STATE(411),
    [sym_tuple_expression] = STATE(411),
    [sym_inline_array_expression] = STATE(411),
    [sym_binary_expression] = STATE(411),
    [sym_unary_expression] = STATE(411),
    [sym_update_expression] = STATE(411),
    [sym_member_expression] = STATE(411),
    [sym_array_access] = STATE(411),
    [sym_slice_access] = STATE(411),
    [sym_struct_expression] = STATE(411),
    [sym_parenthesized_expression] = STATE(411),
    [sym_assignment_expression] = STATE(411),
    [sym_augmented_assignment_expression] = STATE(411),
    [sym_call_expression] = STATE(411),
    [sym_payable_conversion_expression] = STATE(411),
    [sym_meta_type_expression] = STATE(411),
    [sym_user_defined_type] = STATE(411),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(411),
    [sym_string_literal] = STATE(411),
    [sym_number_literal] = STATE(411),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(411),
    [sym_hex_string_literal] = STATE(411),
    [sym_unicode_string_literal] = STATE(411),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_RBRACK] = ACTIONS(278),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__expression] = STATE(397),
    [sym__primary_expression] = STATE(397),
    [sym_type_cast_expression] = STATE(397),
    [sym_ternary_expression] = STATE(397),
    [sym_new_expression] = STATE(397),
    [sym_tuple_expression] = STATE(397),
    [sym_inline_array_expression] = STATE(397),
    [sym_binary_expression] = STATE(397),
    [sym_unary_expression] = STATE(397),
    [sym_update_expression] = STATE(397),
    [sym_member_expression] = STATE(397),
    [sym_array_access] = STATE(397),
    [sym_slice_access] = STATE(397),
    [sym_struct_expression] = STATE(397),
    [sym_parenthesized_expression] = STATE(397),
    [sym_assignment_expression] = STATE(397),
    [sym_augmented_assignment_expression] = STATE(397),
    [sym_call_expression] = STATE(397),
    [sym_payable_conversion_expression] = STATE(397),
    [sym_meta_type_expression] = STATE(397),
    [sym_user_defined_type] = STATE(397),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(397),
    [sym_string_literal] = STATE(397),
    [sym_number_literal] = STATE(397),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(397),
    [sym_hex_string_literal] = STATE(397),
    [sym_unicode_string_literal] = STATE(397),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_RBRACK] = ACTIONS(280),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__expression] = STATE(408),
    [sym__primary_expression] = STATE(408),
    [sym_type_cast_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym_new_expression] = STATE(408),
    [sym_tuple_expression] = STATE(408),
    [sym_inline_array_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_update_expression] = STATE(408),
    [sym_member_expression] = STATE(408),
    [sym_array_access] = STATE(408),
    [sym_slice_access] = STATE(408),
    [sym_struct_expression] = STATE(408),
    [sym_parenthesized_expression] = STATE(408),
    [sym_assignment_expression] = STATE(408),
    [sym_augmented_assignment_expression] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_payable_conversion_expression] = STATE(408),
    [sym_meta_type_expression] = STATE(408),
    [sym_user_defined_type] = STATE(408),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(408),
    [sym_string_literal] = STATE(408),
    [sym_number_literal] = STATE(408),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(408),
    [sym_hex_string_literal] = STATE(408),
    [sym_unicode_string_literal] = STATE(408),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(282),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__expression] = STATE(399),
    [sym__primary_expression] = STATE(399),
    [sym_type_cast_expression] = STATE(399),
    [sym_ternary_expression] = STATE(399),
    [sym_new_expression] = STATE(399),
    [sym_tuple_expression] = STATE(399),
    [sym_inline_array_expression] = STATE(399),
    [sym_binary_expression] = STATE(399),
    [sym_unary_expression] = STATE(399),
    [sym_update_expression] = STATE(399),
    [sym_member_expression] = STATE(399),
    [sym_array_access] = STATE(399),
    [sym_slice_access] = STATE(399),
    [sym_struct_expression] = STATE(399),
    [sym_parenthesized_expression] = STATE(399),
    [sym_assignment_expression] = STATE(399),
    [sym_augmented_assignment_expression] = STATE(399),
    [sym_call_expression] = STATE(399),
    [sym_payable_conversion_expression] = STATE(399),
    [sym_meta_type_expression] = STATE(399),
    [sym_user_defined_type] = STATE(399),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(399),
    [sym_string_literal] = STATE(399),
    [sym_number_literal] = STATE(399),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(399),
    [sym_hex_string_literal] = STATE(399),
    [sym_unicode_string_literal] = STATE(399),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_RBRACK] = ACTIONS(284),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__expression] = STATE(418),
    [sym__primary_expression] = STATE(418),
    [sym_type_cast_expression] = STATE(418),
    [sym_ternary_expression] = STATE(418),
    [sym_new_expression] = STATE(418),
    [sym_tuple_expression] = STATE(418),
    [sym_inline_array_expression] = STATE(418),
    [sym_binary_expression] = STATE(418),
    [sym_unary_expression] = STATE(418),
    [sym_update_expression] = STATE(418),
    [sym_member_expression] = STATE(418),
    [sym_array_access] = STATE(418),
    [sym_slice_access] = STATE(418),
    [sym_struct_expression] = STATE(418),
    [sym_parenthesized_expression] = STATE(418),
    [sym_assignment_expression] = STATE(418),
    [sym_augmented_assignment_expression] = STATE(418),
    [sym_call_expression] = STATE(418),
    [sym_payable_conversion_expression] = STATE(418),
    [sym_meta_type_expression] = STATE(418),
    [sym_user_defined_type] = STATE(418),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(418),
    [sym_string_literal] = STATE(418),
    [sym_number_literal] = STATE(418),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(418),
    [sym_hex_string_literal] = STATE(418),
    [sym_unicode_string_literal] = STATE(418),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_RBRACK] = ACTIONS(286),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__expression] = STATE(416),
    [sym__primary_expression] = STATE(416),
    [sym_type_cast_expression] = STATE(416),
    [sym_ternary_expression] = STATE(416),
    [sym_new_expression] = STATE(416),
    [sym_tuple_expression] = STATE(416),
    [sym_inline_array_expression] = STATE(416),
    [sym_binary_expression] = STATE(416),
    [sym_unary_expression] = STATE(416),
    [sym_update_expression] = STATE(416),
    [sym_member_expression] = STATE(416),
    [sym_array_access] = STATE(416),
    [sym_slice_access] = STATE(416),
    [sym_struct_expression] = STATE(416),
    [sym_parenthesized_expression] = STATE(416),
    [sym_assignment_expression] = STATE(416),
    [sym_augmented_assignment_expression] = STATE(416),
    [sym_call_expression] = STATE(416),
    [sym_payable_conversion_expression] = STATE(416),
    [sym_meta_type_expression] = STATE(416),
    [sym_user_defined_type] = STATE(416),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(416),
    [sym_string_literal] = STATE(416),
    [sym_number_literal] = STATE(416),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(416),
    [sym_hex_string_literal] = STATE(416),
    [sym_unicode_string_literal] = STATE(416),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_RBRACK] = ACTIONS(288),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__expression] = STATE(419),
    [sym__primary_expression] = STATE(419),
    [sym_type_cast_expression] = STATE(419),
    [sym_ternary_expression] = STATE(419),
    [sym_new_expression] = STATE(419),
    [sym_tuple_expression] = STATE(419),
    [sym_inline_array_expression] = STATE(419),
    [sym_binary_expression] = STATE(419),
    [sym_unary_expression] = STATE(419),
    [sym_update_expression] = STATE(419),
    [sym_member_expression] = STATE(419),
    [sym_array_access] = STATE(419),
    [sym_slice_access] = STATE(419),
    [sym_struct_expression] = STATE(419),
    [sym_parenthesized_expression] = STATE(419),
    [sym_assignment_expression] = STATE(419),
    [sym_augmented_assignment_expression] = STATE(419),
    [sym_call_expression] = STATE(419),
    [sym_payable_conversion_expression] = STATE(419),
    [sym_meta_type_expression] = STATE(419),
    [sym_user_defined_type] = STATE(419),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(419),
    [sym_string_literal] = STATE(419),
    [sym_number_literal] = STATE(419),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(419),
    [sym_hex_string_literal] = STATE(419),
    [sym_unicode_string_literal] = STATE(419),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym__semicolon] = ACTIONS(290),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__expression] = STATE(394),
    [sym__primary_expression] = STATE(394),
    [sym_type_cast_expression] = STATE(394),
    [sym_ternary_expression] = STATE(394),
    [sym_new_expression] = STATE(394),
    [sym_tuple_expression] = STATE(394),
    [sym_inline_array_expression] = STATE(394),
    [sym_binary_expression] = STATE(394),
    [sym_unary_expression] = STATE(394),
    [sym_update_expression] = STATE(394),
    [sym_member_expression] = STATE(394),
    [sym_array_access] = STATE(394),
    [sym_slice_access] = STATE(394),
    [sym_struct_expression] = STATE(394),
    [sym_parenthesized_expression] = STATE(394),
    [sym_assignment_expression] = STATE(394),
    [sym_augmented_assignment_expression] = STATE(394),
    [sym_call_expression] = STATE(394),
    [sym_payable_conversion_expression] = STATE(394),
    [sym_meta_type_expression] = STATE(394),
    [sym_user_defined_type] = STATE(394),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(394),
    [sym_string_literal] = STATE(394),
    [sym_number_literal] = STATE(394),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(394),
    [sym_hex_string_literal] = STATE(394),
    [sym_unicode_string_literal] = STATE(394),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__expression] = STATE(348),
    [sym__primary_expression] = STATE(348),
    [sym_type_cast_expression] = STATE(348),
    [sym_ternary_expression] = STATE(348),
    [sym_new_expression] = STATE(348),
    [sym_tuple_expression] = STATE(348),
    [sym_inline_array_expression] = STATE(348),
    [sym_binary_expression] = STATE(348),
    [sym_unary_expression] = STATE(348),
    [sym_update_expression] = STATE(348),
    [sym_member_expression] = STATE(348),
    [sym_array_access] = STATE(348),
    [sym_slice_access] = STATE(348),
    [sym_struct_expression] = STATE(348),
    [sym_parenthesized_expression] = STATE(348),
    [sym_assignment_expression] = STATE(348),
    [sym_augmented_assignment_expression] = STATE(348),
    [sym_call_expression] = STATE(348),
    [sym_payable_conversion_expression] = STATE(348),
    [sym_meta_type_expression] = STATE(348),
    [sym_user_defined_type] = STATE(348),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(348),
    [sym_string_literal] = STATE(348),
    [sym_number_literal] = STATE(348),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(348),
    [sym_hex_string_literal] = STATE(348),
    [sym_unicode_string_literal] = STATE(348),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__expression] = STATE(414),
    [sym__primary_expression] = STATE(414),
    [sym_type_cast_expression] = STATE(414),
    [sym_ternary_expression] = STATE(414),
    [sym_new_expression] = STATE(414),
    [sym_tuple_expression] = STATE(414),
    [sym_inline_array_expression] = STATE(414),
    [sym_binary_expression] = STATE(414),
    [sym_unary_expression] = STATE(414),
    [sym_update_expression] = STATE(414),
    [sym_member_expression] = STATE(414),
    [sym_array_access] = STATE(414),
    [sym_slice_access] = STATE(414),
    [sym_struct_expression] = STATE(414),
    [sym_parenthesized_expression] = STATE(414),
    [sym_assignment_expression] = STATE(414),
    [sym_augmented_assignment_expression] = STATE(414),
    [sym_call_expression] = STATE(414),
    [sym_payable_conversion_expression] = STATE(414),
    [sym_meta_type_expression] = STATE(414),
    [sym_user_defined_type] = STATE(414),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(414),
    [sym_string_literal] = STATE(414),
    [sym_number_literal] = STATE(414),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(414),
    [sym_hex_string_literal] = STATE(414),
    [sym_unicode_string_literal] = STATE(414),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__expression] = STATE(343),
    [sym__primary_expression] = STATE(343),
    [sym_type_cast_expression] = STATE(343),
    [sym_ternary_expression] = STATE(343),
    [sym_new_expression] = STATE(343),
    [sym_tuple_expression] = STATE(343),
    [sym_inline_array_expression] = STATE(343),
    [sym_binary_expression] = STATE(343),
    [sym_unary_expression] = STATE(343),
    [sym_update_expression] = STATE(343),
    [sym_member_expression] = STATE(343),
    [sym_array_access] = STATE(343),
    [sym_slice_access] = STATE(343),
    [sym_struct_expression] = STATE(343),
    [sym_parenthesized_expression] = STATE(343),
    [sym_assignment_expression] = STATE(343),
    [sym_augmented_assignment_expression] = STATE(343),
    [sym_call_expression] = STATE(343),
    [sym_payable_conversion_expression] = STATE(343),
    [sym_meta_type_expression] = STATE(343),
    [sym_user_defined_type] = STATE(343),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(343),
    [sym_string_literal] = STATE(343),
    [sym_number_literal] = STATE(343),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(343),
    [sym_hex_string_literal] = STATE(343),
    [sym_unicode_string_literal] = STATE(343),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__expression] = STATE(422),
    [sym__primary_expression] = STATE(422),
    [sym_type_cast_expression] = STATE(422),
    [sym_ternary_expression] = STATE(422),
    [sym_new_expression] = STATE(422),
    [sym_tuple_expression] = STATE(422),
    [sym_inline_array_expression] = STATE(422),
    [sym_binary_expression] = STATE(422),
    [sym_unary_expression] = STATE(422),
    [sym_update_expression] = STATE(422),
    [sym_member_expression] = STATE(422),
    [sym_array_access] = STATE(422),
    [sym_slice_access] = STATE(422),
    [sym_struct_expression] = STATE(422),
    [sym_parenthesized_expression] = STATE(422),
    [sym_assignment_expression] = STATE(422),
    [sym_augmented_assignment_expression] = STATE(422),
    [sym_call_expression] = STATE(422),
    [sym_payable_conversion_expression] = STATE(422),
    [sym_meta_type_expression] = STATE(422),
    [sym_user_defined_type] = STATE(422),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(422),
    [sym_string_literal] = STATE(422),
    [sym_number_literal] = STATE(422),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(422),
    [sym_hex_string_literal] = STATE(422),
    [sym_unicode_string_literal] = STATE(422),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__expression] = STATE(344),
    [sym__primary_expression] = STATE(344),
    [sym_type_cast_expression] = STATE(344),
    [sym_ternary_expression] = STATE(344),
    [sym_new_expression] = STATE(344),
    [sym_tuple_expression] = STATE(344),
    [sym_inline_array_expression] = STATE(344),
    [sym_binary_expression] = STATE(344),
    [sym_unary_expression] = STATE(344),
    [sym_update_expression] = STATE(344),
    [sym_member_expression] = STATE(344),
    [sym_array_access] = STATE(344),
    [sym_slice_access] = STATE(344),
    [sym_struct_expression] = STATE(344),
    [sym_parenthesized_expression] = STATE(344),
    [sym_assignment_expression] = STATE(344),
    [sym_augmented_assignment_expression] = STATE(344),
    [sym_call_expression] = STATE(344),
    [sym_payable_conversion_expression] = STATE(344),
    [sym_meta_type_expression] = STATE(344),
    [sym_user_defined_type] = STATE(344),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(344),
    [sym_string_literal] = STATE(344),
    [sym_number_literal] = STATE(344),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(344),
    [sym_hex_string_literal] = STATE(344),
    [sym_unicode_string_literal] = STATE(344),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__expression] = STATE(402),
    [sym__primary_expression] = STATE(402),
    [sym_type_cast_expression] = STATE(402),
    [sym_ternary_expression] = STATE(402),
    [sym_new_expression] = STATE(402),
    [sym_tuple_expression] = STATE(402),
    [sym_inline_array_expression] = STATE(402),
    [sym_binary_expression] = STATE(402),
    [sym_unary_expression] = STATE(402),
    [sym_update_expression] = STATE(402),
    [sym_member_expression] = STATE(402),
    [sym_array_access] = STATE(402),
    [sym_slice_access] = STATE(402),
    [sym_struct_expression] = STATE(402),
    [sym_parenthesized_expression] = STATE(402),
    [sym_assignment_expression] = STATE(402),
    [sym_augmented_assignment_expression] = STATE(402),
    [sym_call_expression] = STATE(402),
    [sym_payable_conversion_expression] = STATE(402),
    [sym_meta_type_expression] = STATE(402),
    [sym_user_defined_type] = STATE(402),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(402),
    [sym_string_literal] = STATE(402),
    [sym_number_literal] = STATE(402),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(402),
    [sym_hex_string_literal] = STATE(402),
    [sym_unicode_string_literal] = STATE(402),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__expression] = STATE(407),
    [sym__primary_expression] = STATE(407),
    [sym_type_cast_expression] = STATE(407),
    [sym_ternary_expression] = STATE(407),
    [sym_new_expression] = STATE(407),
    [sym_tuple_expression] = STATE(407),
    [sym_inline_array_expression] = STATE(407),
    [sym_binary_expression] = STATE(407),
    [sym_unary_expression] = STATE(407),
    [sym_update_expression] = STATE(407),
    [sym_member_expression] = STATE(407),
    [sym_array_access] = STATE(407),
    [sym_slice_access] = STATE(407),
    [sym_struct_expression] = STATE(407),
    [sym_parenthesized_expression] = STATE(407),
    [sym_assignment_expression] = STATE(407),
    [sym_augmented_assignment_expression] = STATE(407),
    [sym_call_expression] = STATE(407),
    [sym_payable_conversion_expression] = STATE(407),
    [sym_meta_type_expression] = STATE(407),
    [sym_user_defined_type] = STATE(407),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(407),
    [sym_string_literal] = STATE(407),
    [sym_number_literal] = STATE(407),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(407),
    [sym_hex_string_literal] = STATE(407),
    [sym_unicode_string_literal] = STATE(407),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__expression] = STATE(357),
    [sym__primary_expression] = STATE(357),
    [sym_type_cast_expression] = STATE(357),
    [sym_ternary_expression] = STATE(357),
    [sym_new_expression] = STATE(357),
    [sym_tuple_expression] = STATE(357),
    [sym_inline_array_expression] = STATE(357),
    [sym_binary_expression] = STATE(357),
    [sym_unary_expression] = STATE(357),
    [sym_update_expression] = STATE(357),
    [sym_member_expression] = STATE(357),
    [sym_array_access] = STATE(357),
    [sym_slice_access] = STATE(357),
    [sym_struct_expression] = STATE(357),
    [sym_parenthesized_expression] = STATE(357),
    [sym_assignment_expression] = STATE(357),
    [sym_augmented_assignment_expression] = STATE(357),
    [sym_call_expression] = STATE(357),
    [sym_payable_conversion_expression] = STATE(357),
    [sym_meta_type_expression] = STATE(357),
    [sym_user_defined_type] = STATE(357),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(357),
    [sym_string_literal] = STATE(357),
    [sym_number_literal] = STATE(357),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(357),
    [sym_hex_string_literal] = STATE(357),
    [sym_unicode_string_literal] = STATE(357),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__expression] = STATE(340),
    [sym__primary_expression] = STATE(340),
    [sym_type_cast_expression] = STATE(340),
    [sym_ternary_expression] = STATE(340),
    [sym_new_expression] = STATE(340),
    [sym_tuple_expression] = STATE(340),
    [sym_inline_array_expression] = STATE(340),
    [sym_binary_expression] = STATE(340),
    [sym_unary_expression] = STATE(340),
    [sym_update_expression] = STATE(340),
    [sym_member_expression] = STATE(340),
    [sym_array_access] = STATE(340),
    [sym_slice_access] = STATE(340),
    [sym_struct_expression] = STATE(340),
    [sym_parenthesized_expression] = STATE(340),
    [sym_assignment_expression] = STATE(340),
    [sym_augmented_assignment_expression] = STATE(340),
    [sym_call_expression] = STATE(340),
    [sym_payable_conversion_expression] = STATE(340),
    [sym_meta_type_expression] = STATE(340),
    [sym_user_defined_type] = STATE(340),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(340),
    [sym_string_literal] = STATE(340),
    [sym_number_literal] = STATE(340),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(340),
    [sym_hex_string_literal] = STATE(340),
    [sym_unicode_string_literal] = STATE(340),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__expression] = STATE(410),
    [sym__primary_expression] = STATE(410),
    [sym_type_cast_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym_new_expression] = STATE(410),
    [sym_tuple_expression] = STATE(410),
    [sym_inline_array_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_member_expression] = STATE(410),
    [sym_array_access] = STATE(410),
    [sym_slice_access] = STATE(410),
    [sym_struct_expression] = STATE(410),
    [sym_parenthesized_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_augmented_assignment_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_payable_conversion_expression] = STATE(410),
    [sym_meta_type_expression] = STATE(410),
    [sym_user_defined_type] = STATE(410),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_number_literal] = STATE(410),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(410),
    [sym_hex_string_literal] = STATE(410),
    [sym_unicode_string_literal] = STATE(410),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__expression] = STATE(412),
    [sym__primary_expression] = STATE(412),
    [sym_type_cast_expression] = STATE(412),
    [sym_ternary_expression] = STATE(412),
    [sym_new_expression] = STATE(412),
    [sym_tuple_expression] = STATE(412),
    [sym_inline_array_expression] = STATE(412),
    [sym_binary_expression] = STATE(412),
    [sym_unary_expression] = STATE(412),
    [sym_update_expression] = STATE(412),
    [sym_member_expression] = STATE(412),
    [sym_array_access] = STATE(412),
    [sym_slice_access] = STATE(412),
    [sym_struct_expression] = STATE(412),
    [sym_parenthesized_expression] = STATE(412),
    [sym_assignment_expression] = STATE(412),
    [sym_augmented_assignment_expression] = STATE(412),
    [sym_call_expression] = STATE(412),
    [sym_payable_conversion_expression] = STATE(412),
    [sym_meta_type_expression] = STATE(412),
    [sym_user_defined_type] = STATE(412),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(412),
    [sym_string_literal] = STATE(412),
    [sym_number_literal] = STATE(412),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(412),
    [sym_hex_string_literal] = STATE(412),
    [sym_unicode_string_literal] = STATE(412),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__expression] = STATE(345),
    [sym__primary_expression] = STATE(345),
    [sym_type_cast_expression] = STATE(345),
    [sym_ternary_expression] = STATE(345),
    [sym_new_expression] = STATE(345),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(345),
    [sym_binary_expression] = STATE(345),
    [sym_unary_expression] = STATE(345),
    [sym_update_expression] = STATE(345),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(345),
    [sym_struct_expression] = STATE(345),
    [sym_parenthesized_expression] = STATE(345),
    [sym_assignment_expression] = STATE(345),
    [sym_augmented_assignment_expression] = STATE(345),
    [sym_call_expression] = STATE(345),
    [sym_payable_conversion_expression] = STATE(345),
    [sym_meta_type_expression] = STATE(345),
    [sym_user_defined_type] = STATE(345),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(345),
    [sym_string_literal] = STATE(345),
    [sym_number_literal] = STATE(345),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(345),
    [sym_hex_string_literal] = STATE(345),
    [sym_unicode_string_literal] = STATE(345),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__expression] = STATE(399),
    [sym__primary_expression] = STATE(399),
    [sym_type_cast_expression] = STATE(399),
    [sym_ternary_expression] = STATE(399),
    [sym_new_expression] = STATE(399),
    [sym_tuple_expression] = STATE(399),
    [sym_inline_array_expression] = STATE(399),
    [sym_binary_expression] = STATE(399),
    [sym_unary_expression] = STATE(399),
    [sym_update_expression] = STATE(399),
    [sym_member_expression] = STATE(399),
    [sym_array_access] = STATE(399),
    [sym_slice_access] = STATE(399),
    [sym_struct_expression] = STATE(399),
    [sym_parenthesized_expression] = STATE(399),
    [sym_assignment_expression] = STATE(399),
    [sym_augmented_assignment_expression] = STATE(399),
    [sym_call_expression] = STATE(399),
    [sym_payable_conversion_expression] = STATE(399),
    [sym_meta_type_expression] = STATE(399),
    [sym_user_defined_type] = STATE(399),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(399),
    [sym_string_literal] = STATE(399),
    [sym_number_literal] = STATE(399),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(399),
    [sym_hex_string_literal] = STATE(399),
    [sym_unicode_string_literal] = STATE(399),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__expression] = STATE(413),
    [sym__primary_expression] = STATE(413),
    [sym_type_cast_expression] = STATE(413),
    [sym_ternary_expression] = STATE(413),
    [sym_new_expression] = STATE(413),
    [sym_tuple_expression] = STATE(413),
    [sym_inline_array_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym_member_expression] = STATE(413),
    [sym_array_access] = STATE(413),
    [sym_slice_access] = STATE(413),
    [sym_struct_expression] = STATE(413),
    [sym_parenthesized_expression] = STATE(413),
    [sym_assignment_expression] = STATE(413),
    [sym_augmented_assignment_expression] = STATE(413),
    [sym_call_expression] = STATE(413),
    [sym_payable_conversion_expression] = STATE(413),
    [sym_meta_type_expression] = STATE(413),
    [sym_user_defined_type] = STATE(413),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(413),
    [sym_string_literal] = STATE(413),
    [sym_number_literal] = STATE(413),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(413),
    [sym_hex_string_literal] = STATE(413),
    [sym_unicode_string_literal] = STATE(413),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__expression] = STATE(406),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__expression] = STATE(401),
    [sym__primary_expression] = STATE(401),
    [sym_type_cast_expression] = STATE(401),
    [sym_ternary_expression] = STATE(401),
    [sym_new_expression] = STATE(401),
    [sym_tuple_expression] = STATE(401),
    [sym_inline_array_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym_member_expression] = STATE(401),
    [sym_array_access] = STATE(401),
    [sym_slice_access] = STATE(401),
    [sym_struct_expression] = STATE(401),
    [sym_parenthesized_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_augmented_assignment_expression] = STATE(401),
    [sym_call_expression] = STATE(401),
    [sym_payable_conversion_expression] = STATE(401),
    [sym_meta_type_expression] = STATE(401),
    [sym_user_defined_type] = STATE(401),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(401),
    [sym_string_literal] = STATE(401),
    [sym_number_literal] = STATE(401),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(401),
    [sym_hex_string_literal] = STATE(401),
    [sym_unicode_string_literal] = STATE(401),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__expression] = STATE(346),
    [sym__primary_expression] = STATE(346),
    [sym_type_cast_expression] = STATE(346),
    [sym_ternary_expression] = STATE(346),
    [sym_new_expression] = STATE(346),
    [sym_tuple_expression] = STATE(346),
    [sym_inline_array_expression] = STATE(346),
    [sym_binary_expression] = STATE(346),
    [sym_unary_expression] = STATE(346),
    [sym_update_expression] = STATE(346),
    [sym_member_expression] = STATE(346),
    [sym_array_access] = STATE(346),
    [sym_slice_access] = STATE(346),
    [sym_struct_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_assignment_expression] = STATE(346),
    [sym_augmented_assignment_expression] = STATE(346),
    [sym_call_expression] = STATE(346),
    [sym_payable_conversion_expression] = STATE(346),
    [sym_meta_type_expression] = STATE(346),
    [sym_user_defined_type] = STATE(346),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(346),
    [sym_string_literal] = STATE(346),
    [sym_number_literal] = STATE(346),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(346),
    [sym_hex_string_literal] = STATE(346),
    [sym_unicode_string_literal] = STATE(346),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__expression] = STATE(341),
    [sym__primary_expression] = STATE(341),
    [sym_type_cast_expression] = STATE(341),
    [sym_ternary_expression] = STATE(341),
    [sym_new_expression] = STATE(341),
    [sym_tuple_expression] = STATE(341),
    [sym_inline_array_expression] = STATE(341),
    [sym_binary_expression] = STATE(341),
    [sym_unary_expression] = STATE(341),
    [sym_update_expression] = STATE(341),
    [sym_member_expression] = STATE(341),
    [sym_array_access] = STATE(341),
    [sym_slice_access] = STATE(341),
    [sym_struct_expression] = STATE(341),
    [sym_parenthesized_expression] = STATE(341),
    [sym_assignment_expression] = STATE(341),
    [sym_augmented_assignment_expression] = STATE(341),
    [sym_call_expression] = STATE(341),
    [sym_payable_conversion_expression] = STATE(341),
    [sym_meta_type_expression] = STATE(341),
    [sym_user_defined_type] = STATE(341),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(341),
    [sym_string_literal] = STATE(341),
    [sym_number_literal] = STATE(341),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(341),
    [sym_hex_string_literal] = STATE(341),
    [sym_unicode_string_literal] = STATE(341),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__expression] = STATE(420),
    [sym__primary_expression] = STATE(420),
    [sym_type_cast_expression] = STATE(420),
    [sym_ternary_expression] = STATE(420),
    [sym_new_expression] = STATE(420),
    [sym_tuple_expression] = STATE(420),
    [sym_inline_array_expression] = STATE(420),
    [sym_binary_expression] = STATE(420),
    [sym_unary_expression] = STATE(420),
    [sym_update_expression] = STATE(420),
    [sym_member_expression] = STATE(420),
    [sym_array_access] = STATE(420),
    [sym_slice_access] = STATE(420),
    [sym_struct_expression] = STATE(420),
    [sym_parenthesized_expression] = STATE(420),
    [sym_assignment_expression] = STATE(420),
    [sym_augmented_assignment_expression] = STATE(420),
    [sym_call_expression] = STATE(420),
    [sym_payable_conversion_expression] = STATE(420),
    [sym_meta_type_expression] = STATE(420),
    [sym_user_defined_type] = STATE(420),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(420),
    [sym_string_literal] = STATE(420),
    [sym_number_literal] = STATE(420),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(420),
    [sym_hex_string_literal] = STATE(420),
    [sym_unicode_string_literal] = STATE(420),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__expression] = STATE(342),
    [sym__primary_expression] = STATE(342),
    [sym_type_cast_expression] = STATE(342),
    [sym_ternary_expression] = STATE(342),
    [sym_new_expression] = STATE(342),
    [sym_tuple_expression] = STATE(342),
    [sym_inline_array_expression] = STATE(342),
    [sym_binary_expression] = STATE(342),
    [sym_unary_expression] = STATE(342),
    [sym_update_expression] = STATE(342),
    [sym_member_expression] = STATE(342),
    [sym_array_access] = STATE(342),
    [sym_slice_access] = STATE(342),
    [sym_struct_expression] = STATE(342),
    [sym_parenthesized_expression] = STATE(342),
    [sym_assignment_expression] = STATE(342),
    [sym_augmented_assignment_expression] = STATE(342),
    [sym_call_expression] = STATE(342),
    [sym_payable_conversion_expression] = STATE(342),
    [sym_meta_type_expression] = STATE(342),
    [sym_user_defined_type] = STATE(342),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(342),
    [sym_string_literal] = STATE(342),
    [sym_number_literal] = STATE(342),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(342),
    [sym_hex_string_literal] = STATE(342),
    [sym_unicode_string_literal] = STATE(342),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__expression] = STATE(417),
    [sym__primary_expression] = STATE(417),
    [sym_type_cast_expression] = STATE(417),
    [sym_ternary_expression] = STATE(417),
    [sym_new_expression] = STATE(417),
    [sym_tuple_expression] = STATE(417),
    [sym_inline_array_expression] = STATE(417),
    [sym_binary_expression] = STATE(417),
    [sym_unary_expression] = STATE(417),
    [sym_update_expression] = STATE(417),
    [sym_member_expression] = STATE(417),
    [sym_array_access] = STATE(417),
    [sym_slice_access] = STATE(417),
    [sym_struct_expression] = STATE(417),
    [sym_parenthesized_expression] = STATE(417),
    [sym_assignment_expression] = STATE(417),
    [sym_augmented_assignment_expression] = STATE(417),
    [sym_call_expression] = STATE(417),
    [sym_payable_conversion_expression] = STATE(417),
    [sym_meta_type_expression] = STATE(417),
    [sym_user_defined_type] = STATE(417),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(417),
    [sym_string_literal] = STATE(417),
    [sym_number_literal] = STATE(417),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(417),
    [sym_hex_string_literal] = STATE(417),
    [sym_unicode_string_literal] = STATE(417),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__expression] = STATE(409),
    [sym__primary_expression] = STATE(409),
    [sym_type_cast_expression] = STATE(409),
    [sym_ternary_expression] = STATE(409),
    [sym_new_expression] = STATE(409),
    [sym_tuple_expression] = STATE(409),
    [sym_inline_array_expression] = STATE(409),
    [sym_binary_expression] = STATE(409),
    [sym_unary_expression] = STATE(409),
    [sym_update_expression] = STATE(409),
    [sym_member_expression] = STATE(409),
    [sym_array_access] = STATE(409),
    [sym_slice_access] = STATE(409),
    [sym_struct_expression] = STATE(409),
    [sym_parenthesized_expression] = STATE(409),
    [sym_assignment_expression] = STATE(409),
    [sym_augmented_assignment_expression] = STATE(409),
    [sym_call_expression] = STATE(409),
    [sym_payable_conversion_expression] = STATE(409),
    [sym_meta_type_expression] = STATE(409),
    [sym_user_defined_type] = STATE(409),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(409),
    [sym_string_literal] = STATE(409),
    [sym_number_literal] = STATE(409),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(409),
    [sym_hex_string_literal] = STATE(409),
    [sym_unicode_string_literal] = STATE(409),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__expression] = STATE(355),
    [sym__primary_expression] = STATE(355),
    [sym_type_cast_expression] = STATE(355),
    [sym_ternary_expression] = STATE(355),
    [sym_new_expression] = STATE(355),
    [sym_tuple_expression] = STATE(355),
    [sym_inline_array_expression] = STATE(355),
    [sym_binary_expression] = STATE(355),
    [sym_unary_expression] = STATE(355),
    [sym_update_expression] = STATE(355),
    [sym_member_expression] = STATE(355),
    [sym_array_access] = STATE(355),
    [sym_slice_access] = STATE(355),
    [sym_struct_expression] = STATE(355),
    [sym_parenthesized_expression] = STATE(355),
    [sym_assignment_expression] = STATE(355),
    [sym_augmented_assignment_expression] = STATE(355),
    [sym_call_expression] = STATE(355),
    [sym_payable_conversion_expression] = STATE(355),
    [sym_meta_type_expression] = STATE(355),
    [sym_user_defined_type] = STATE(355),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(355),
    [sym_string_literal] = STATE(355),
    [sym_number_literal] = STATE(355),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(355),
    [sym_hex_string_literal] = STATE(355),
    [sym_unicode_string_literal] = STATE(355),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__expression] = STATE(354),
    [sym__primary_expression] = STATE(354),
    [sym_type_cast_expression] = STATE(354),
    [sym_ternary_expression] = STATE(354),
    [sym_new_expression] = STATE(354),
    [sym_tuple_expression] = STATE(354),
    [sym_inline_array_expression] = STATE(354),
    [sym_binary_expression] = STATE(354),
    [sym_unary_expression] = STATE(354),
    [sym_update_expression] = STATE(354),
    [sym_member_expression] = STATE(354),
    [sym_array_access] = STATE(354),
    [sym_slice_access] = STATE(354),
    [sym_struct_expression] = STATE(354),
    [sym_parenthesized_expression] = STATE(354),
    [sym_assignment_expression] = STATE(354),
    [sym_augmented_assignment_expression] = STATE(354),
    [sym_call_expression] = STATE(354),
    [sym_payable_conversion_expression] = STATE(354),
    [sym_meta_type_expression] = STATE(354),
    [sym_user_defined_type] = STATE(354),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(354),
    [sym_string_literal] = STATE(354),
    [sym_number_literal] = STATE(354),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(354),
    [sym_hex_string_literal] = STATE(354),
    [sym_unicode_string_literal] = STATE(354),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__expression] = STATE(353),
    [sym__primary_expression] = STATE(353),
    [sym_type_cast_expression] = STATE(353),
    [sym_ternary_expression] = STATE(353),
    [sym_new_expression] = STATE(353),
    [sym_tuple_expression] = STATE(353),
    [sym_inline_array_expression] = STATE(353),
    [sym_binary_expression] = STATE(353),
    [sym_unary_expression] = STATE(353),
    [sym_update_expression] = STATE(353),
    [sym_member_expression] = STATE(353),
    [sym_array_access] = STATE(353),
    [sym_slice_access] = STATE(353),
    [sym_struct_expression] = STATE(353),
    [sym_parenthesized_expression] = STATE(353),
    [sym_assignment_expression] = STATE(353),
    [sym_augmented_assignment_expression] = STATE(353),
    [sym_call_expression] = STATE(353),
    [sym_payable_conversion_expression] = STATE(353),
    [sym_meta_type_expression] = STATE(353),
    [sym_user_defined_type] = STATE(353),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(353),
    [sym_string_literal] = STATE(353),
    [sym_number_literal] = STATE(353),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(353),
    [sym_hex_string_literal] = STATE(353),
    [sym_unicode_string_literal] = STATE(353),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__expression] = STATE(356),
    [sym__primary_expression] = STATE(356),
    [sym_type_cast_expression] = STATE(356),
    [sym_ternary_expression] = STATE(356),
    [sym_new_expression] = STATE(356),
    [sym_tuple_expression] = STATE(356),
    [sym_inline_array_expression] = STATE(356),
    [sym_binary_expression] = STATE(356),
    [sym_unary_expression] = STATE(356),
    [sym_update_expression] = STATE(356),
    [sym_member_expression] = STATE(356),
    [sym_array_access] = STATE(356),
    [sym_slice_access] = STATE(356),
    [sym_struct_expression] = STATE(356),
    [sym_parenthesized_expression] = STATE(356),
    [sym_assignment_expression] = STATE(356),
    [sym_augmented_assignment_expression] = STATE(356),
    [sym_call_expression] = STATE(356),
    [sym_payable_conversion_expression] = STATE(356),
    [sym_meta_type_expression] = STATE(356),
    [sym_user_defined_type] = STATE(356),
    [sym__identifier_path] = STATE(308),
    [sym_primitive_type] = STATE(380),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym__literal] = STATE(356),
    [sym_string_literal] = STATE(356),
    [sym_number_literal] = STATE(356),
    [sym__decimal_number] = STATE(316),
    [sym__hex_number] = STATE(316),
    [sym_true] = STATE(371),
    [sym_false] = STATE(371),
    [sym_boolean_literal] = STATE(356),
    [sym_hex_string_literal] = STATE(356),
    [sym_unicode_string_literal] = STATE(356),
    [sym_string] = STATE(333),
    [aux_sym_string_literal_repeat1] = STATE(333),
    [aux_sym_hex_string_literal_repeat2] = STATE(336),
    [aux_sym_unicode_string_literal_repeat3] = STATE(335),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_TILDE] = ACTIONS(41),
    [anon_sym_type] = ACTIONS(47),
    [anon_sym_LPAREN] = ACTIONS(233),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(61),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_payable] = ACTIONS(83),
    [anon_sym_new] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_delete] = ACTIONS(89),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_catch_clause] = STATE(70),
    [aux_sym_try_statement_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(292),
    [anon_sym_DASH] = ACTIONS(292),
    [anon_sym_TILDE] = ACTIONS(294),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_RBRACE] = ACTIONS(294),
    [anon_sym_type] = ACTIONS(292),
    [anon_sym_LPAREN] = ACTIONS(294),
    [anon_sym_for] = ACTIONS(292),
    [anon_sym_assembly] = ACTIONS(292),
    [anon_sym_break] = ACTIONS(292),
    [anon_sym_continue] = ACTIONS(292),
    [anon_sym_true] = ACTIONS(292),
    [anon_sym_false] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(292),
    [anon_sym_function] = ACTIONS(292),
    [anon_sym_byte] = ACTIONS(292),
    [anon_sym_address] = ACTIONS(292),
    [anon_sym_return] = ACTIONS(292),
    [anon_sym_revert] = ACTIONS(292),
    [sym__unchecked] = ACTIONS(292),
    [anon_sym_var] = ACTIONS(292),
    [anon_sym_else] = ACTIONS(292),
    [anon_sym_while] = ACTIONS(292),
    [anon_sym_do] = ACTIONS(292),
    [anon_sym_try] = ACTIONS(292),
    [anon_sym_catch] = ACTIONS(296),
    [anon_sym_emit] = ACTIONS(292),
    [anon_sym_payable] = ACTIONS(292),
    [anon_sym_new] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(294),
    [anon_sym_PLUS] = ACTIONS(292),
    [anon_sym_BANG] = ACTIONS(294),
    [anon_sym_delete] = ACTIONS(292),
    [anon_sym_PLUS_PLUS] = ACTIONS(294),
    [anon_sym_DASH_DASH] = ACTIONS(294),
    [anon_sym_mapping] = ACTIONS(292),
    [anon_sym_bool] = ACTIONS(292),
    [anon_sym_string] = ACTIONS(292),
    [anon_sym_int] = ACTIONS(292),
    [anon_sym_int8] = ACTIONS(292),
    [anon_sym_int16] = ACTIONS(292),
    [anon_sym_int24] = ACTIONS(292),
    [anon_sym_int32] = ACTIONS(292),
    [anon_sym_int40] = ACTIONS(292),
    [anon_sym_int48] = ACTIONS(292),
    [anon_sym_int56] = ACTIONS(292),
    [anon_sym_int64] = ACTIONS(292),
    [anon_sym_int72] = ACTIONS(292),
    [anon_sym_int80] = ACTIONS(292),
    [anon_sym_int88] = ACTIONS(292),
    [anon_sym_int96] = ACTIONS(292),
    [anon_sym_int104] = ACTIONS(292),
    [anon_sym_int112] = ACTIONS(292),
    [anon_sym_int120] = ACTIONS(292),
    [anon_sym_int128] = ACTIONS(292),
    [anon_sym_int136] = ACTIONS(292),
    [anon_sym_int144] = ACTIONS(292),
    [anon_sym_int152] = ACTIONS(292),
    [anon_sym_int160] = ACTIONS(292),
    [anon_sym_int168] = ACTIONS(292),
    [anon_sym_int176] = ACTIONS(292),
    [anon_sym_int184] = ACTIONS(292),
    [anon_sym_int192] = ACTIONS(292),
    [anon_sym_int200] = ACTIONS(292),
    [anon_sym_int208] = ACTIONS(292),
    [anon_sym_int216] = ACTIONS(292),
    [anon_sym_int224] = ACTIONS(292),
    [anon_sym_int232] = ACTIONS(292),
    [anon_sym_int240] = ACTIONS(292),
    [anon_sym_int248] = ACTIONS(292),
    [anon_sym_int256] = ACTIONS(292),
    [anon_sym_uint] = ACTIONS(292),
    [anon_sym_uint8] = ACTIONS(292),
    [anon_sym_uint16] = ACTIONS(292),
    [anon_sym_uint24] = ACTIONS(292),
    [anon_sym_uint32] = ACTIONS(292),
    [anon_sym_uint40] = ACTIONS(292),
    [anon_sym_uint48] = ACTIONS(292),
    [anon_sym_uint56] = ACTIONS(292),
    [anon_sym_uint64] = ACTIONS(292),
    [anon_sym_uint72] = ACTIONS(292),
    [anon_sym_uint80] = ACTIONS(292),
    [anon_sym_uint88] = ACTIONS(292),
    [anon_sym_uint96] = ACTIONS(292),
    [anon_sym_uint104] = ACTIONS(292),
    [anon_sym_uint112] = ACTIONS(292),
    [anon_sym_uint120] = ACTIONS(292),
    [anon_sym_uint128] = ACTIONS(292),
    [anon_sym_uint136] = ACTIONS(292),
    [anon_sym_uint144] = ACTIONS(292),
    [anon_sym_uint152] = ACTIONS(292),
    [anon_sym_uint160] = ACTIONS(292),
    [anon_sym_uint168] = ACTIONS(292),
    [anon_sym_uint176] = ACTIONS(292),
    [anon_sym_uint184] = ACTIONS(292),
    [anon_sym_uint192] = ACTIONS(292),
    [anon_sym_uint200] = ACTIONS(292),
    [anon_sym_uint208] = ACTIONS(292),
    [anon_sym_uint216] = ACTIONS(292),
    [anon_sym_uint224] = ACTIONS(292),
    [anon_sym_uint232] = ACTIONS(292),
    [anon_sym_uint240] = ACTIONS(292),
    [anon_sym_uint248] = ACTIONS(292),
    [anon_sym_uint256] = ACTIONS(292),
    [anon_sym_bytes] = ACTIONS(292),
    [anon_sym_bytes1] = ACTIONS(292),
    [anon_sym_bytes2] = ACTIONS(292),
    [anon_sym_bytes3] = ACTIONS(292),
    [anon_sym_bytes4] = ACTIONS(292),
    [anon_sym_bytes5] = ACTIONS(292),
    [anon_sym_bytes6] = ACTIONS(292),
    [anon_sym_bytes7] = ACTIONS(292),
    [anon_sym_bytes8] = ACTIONS(292),
    [anon_sym_bytes9] = ACTIONS(292),
    [anon_sym_bytes10] = ACTIONS(292),
    [anon_sym_bytes11] = ACTIONS(292),
    [anon_sym_bytes12] = ACTIONS(292),
    [anon_sym_bytes13] = ACTIONS(292),
    [anon_sym_bytes14] = ACTIONS(292),
    [anon_sym_bytes15] = ACTIONS(292),
    [anon_sym_bytes16] = ACTIONS(292),
    [anon_sym_bytes17] = ACTIONS(292),
    [anon_sym_bytes18] = ACTIONS(292),
    [anon_sym_bytes19] = ACTIONS(292),
    [anon_sym_bytes20] = ACTIONS(292),
    [anon_sym_bytes21] = ACTIONS(292),
    [anon_sym_bytes22] = ACTIONS(292),
    [anon_sym_bytes23] = ACTIONS(292),
    [anon_sym_bytes24] = ACTIONS(292),
    [anon_sym_bytes25] = ACTIONS(292),
    [anon_sym_bytes26] = ACTIONS(292),
    [anon_sym_bytes27] = ACTIONS(292),
    [anon_sym_bytes28] = ACTIONS(292),
    [anon_sym_bytes29] = ACTIONS(292),
    [anon_sym_bytes30] = ACTIONS(292),
    [anon_sym_bytes31] = ACTIONS(292),
    [anon_sym_bytes32] = ACTIONS(292),
    [anon_sym_fixed] = ACTIONS(292),
    [aux_sym__fixed_token1] = ACTIONS(292),
    [anon_sym_ufixed] = ACTIONS(292),
    [aux_sym__ufixed_token1] = ACTIONS(292),
    [aux_sym__decimal_number_token1] = ACTIONS(292),
    [aux_sym__decimal_number_token2] = ACTIONS(294),
    [aux_sym__hex_number_token1] = ACTIONS(294),
    [anon_sym_hex] = ACTIONS(292),
    [anon_sym_DQUOTE] = ACTIONS(294),
    [anon_sym_SQUOTE] = ACTIONS(294),
    [anon_sym_unicode] = ACTIONS(292),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_catch_clause] = STATE(70),
    [aux_sym_try_statement_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(298),
    [anon_sym_DASH] = ACTIONS(298),
    [anon_sym_TILDE] = ACTIONS(300),
    [anon_sym_LBRACE] = ACTIONS(300),
    [anon_sym_RBRACE] = ACTIONS(300),
    [anon_sym_type] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(300),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_assembly] = ACTIONS(298),
    [anon_sym_break] = ACTIONS(298),
    [anon_sym_continue] = ACTIONS(298),
    [anon_sym_true] = ACTIONS(298),
    [anon_sym_false] = ACTIONS(298),
    [anon_sym_if] = ACTIONS(298),
    [anon_sym_function] = ACTIONS(298),
    [anon_sym_byte] = ACTIONS(298),
    [anon_sym_address] = ACTIONS(298),
    [anon_sym_return] = ACTIONS(298),
    [anon_sym_revert] = ACTIONS(298),
    [sym__unchecked] = ACTIONS(298),
    [anon_sym_var] = ACTIONS(298),
    [anon_sym_else] = ACTIONS(298),
    [anon_sym_while] = ACTIONS(298),
    [anon_sym_do] = ACTIONS(298),
    [anon_sym_try] = ACTIONS(298),
    [anon_sym_catch] = ACTIONS(302),
    [anon_sym_emit] = ACTIONS(298),
    [anon_sym_payable] = ACTIONS(298),
    [anon_sym_new] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_PLUS] = ACTIONS(298),
    [anon_sym_BANG] = ACTIONS(300),
    [anon_sym_delete] = ACTIONS(298),
    [anon_sym_PLUS_PLUS] = ACTIONS(300),
    [anon_sym_DASH_DASH] = ACTIONS(300),
    [anon_sym_mapping] = ACTIONS(298),
    [anon_sym_bool] = ACTIONS(298),
    [anon_sym_string] = ACTIONS(298),
    [anon_sym_int] = ACTIONS(298),
    [anon_sym_int8] = ACTIONS(298),
    [anon_sym_int16] = ACTIONS(298),
    [anon_sym_int24] = ACTIONS(298),
    [anon_sym_int32] = ACTIONS(298),
    [anon_sym_int40] = ACTIONS(298),
    [anon_sym_int48] = ACTIONS(298),
    [anon_sym_int56] = ACTIONS(298),
    [anon_sym_int64] = ACTIONS(298),
    [anon_sym_int72] = ACTIONS(298),
    [anon_sym_int80] = ACTIONS(298),
    [anon_sym_int88] = ACTIONS(298),
    [anon_sym_int96] = ACTIONS(298),
    [anon_sym_int104] = ACTIONS(298),
    [anon_sym_int112] = ACTIONS(298),
    [anon_sym_int120] = ACTIONS(298),
    [anon_sym_int128] = ACTIONS(298),
    [anon_sym_int136] = ACTIONS(298),
    [anon_sym_int144] = ACTIONS(298),
    [anon_sym_int152] = ACTIONS(298),
    [anon_sym_int160] = ACTIONS(298),
    [anon_sym_int168] = ACTIONS(298),
    [anon_sym_int176] = ACTIONS(298),
    [anon_sym_int184] = ACTIONS(298),
    [anon_sym_int192] = ACTIONS(298),
    [anon_sym_int200] = ACTIONS(298),
    [anon_sym_int208] = ACTIONS(298),
    [anon_sym_int216] = ACTIONS(298),
    [anon_sym_int224] = ACTIONS(298),
    [anon_sym_int232] = ACTIONS(298),
    [anon_sym_int240] = ACTIONS(298),
    [anon_sym_int248] = ACTIONS(298),
    [anon_sym_int256] = ACTIONS(298),
    [anon_sym_uint] = ACTIONS(298),
    [anon_sym_uint8] = ACTIONS(298),
    [anon_sym_uint16] = ACTIONS(298),
    [anon_sym_uint24] = ACTIONS(298),
    [anon_sym_uint32] = ACTIONS(298),
    [anon_sym_uint40] = ACTIONS(298),
    [anon_sym_uint48] = ACTIONS(298),
    [anon_sym_uint56] = ACTIONS(298),
    [anon_sym_uint64] = ACTIONS(298),
    [anon_sym_uint72] = ACTIONS(298),
    [anon_sym_uint80] = ACTIONS(298),
    [anon_sym_uint88] = ACTIONS(298),
    [anon_sym_uint96] = ACTIONS(298),
    [anon_sym_uint104] = ACTIONS(298),
    [anon_sym_uint112] = ACTIONS(298),
    [anon_sym_uint120] = ACTIONS(298),
    [anon_sym_uint128] = ACTIONS(298),
    [anon_sym_uint136] = ACTIONS(298),
    [anon_sym_uint144] = ACTIONS(298),
    [anon_sym_uint152] = ACTIONS(298),
    [anon_sym_uint160] = ACTIONS(298),
    [anon_sym_uint168] = ACTIONS(298),
    [anon_sym_uint176] = ACTIONS(298),
    [anon_sym_uint184] = ACTIONS(298),
    [anon_sym_uint192] = ACTIONS(298),
    [anon_sym_uint200] = ACTIONS(298),
    [anon_sym_uint208] = ACTIONS(298),
    [anon_sym_uint216] = ACTIONS(298),
    [anon_sym_uint224] = ACTIONS(298),
    [anon_sym_uint232] = ACTIONS(298),
    [anon_sym_uint240] = ACTIONS(298),
    [anon_sym_uint248] = ACTIONS(298),
    [anon_sym_uint256] = ACTIONS(298),
    [anon_sym_bytes] = ACTIONS(298),
    [anon_sym_bytes1] = ACTIONS(298),
    [anon_sym_bytes2] = ACTIONS(298),
    [anon_sym_bytes3] = ACTIONS(298),
    [anon_sym_bytes4] = ACTIONS(298),
    [anon_sym_bytes5] = ACTIONS(298),
    [anon_sym_bytes6] = ACTIONS(298),
    [anon_sym_bytes7] = ACTIONS(298),
    [anon_sym_bytes8] = ACTIONS(298),
    [anon_sym_bytes9] = ACTIONS(298),
    [anon_sym_bytes10] = ACTIONS(298),
    [anon_sym_bytes11] = ACTIONS(298),
    [anon_sym_bytes12] = ACTIONS(298),
    [anon_sym_bytes13] = ACTIONS(298),
    [anon_sym_bytes14] = ACTIONS(298),
    [anon_sym_bytes15] = ACTIONS(298),
    [anon_sym_bytes16] = ACTIONS(298),
    [anon_sym_bytes17] = ACTIONS(298),
    [anon_sym_bytes18] = ACTIONS(298),
    [anon_sym_bytes19] = ACTIONS(298),
    [anon_sym_bytes20] = ACTIONS(298),
    [anon_sym_bytes21] = ACTIONS(298),
    [anon_sym_bytes22] = ACTIONS(298),
    [anon_sym_bytes23] = ACTIONS(298),
    [anon_sym_bytes24] = ACTIONS(298),
    [anon_sym_bytes25] = ACTIONS(298),
    [anon_sym_bytes26] = ACTIONS(298),
    [anon_sym_bytes27] = ACTIONS(298),
    [anon_sym_bytes28] = ACTIONS(298),
    [anon_sym_bytes29] = ACTIONS(298),
    [anon_sym_bytes30] = ACTIONS(298),
    [anon_sym_bytes31] = ACTIONS(298),
    [anon_sym_bytes32] = ACTIONS(298),
    [anon_sym_fixed] = ACTIONS(298),
    [aux_sym__fixed_token1] = ACTIONS(298),
    [anon_sym_ufixed] = ACTIONS(298),
    [aux_sym__ufixed_token1] = ACTIONS(298),
    [aux_sym__decimal_number_token1] = ACTIONS(298),
    [aux_sym__decimal_number_token2] = ACTIONS(300),
    [aux_sym__hex_number_token1] = ACTIONS(300),
    [anon_sym_hex] = ACTIONS(298),
    [anon_sym_DQUOTE] = ACTIONS(300),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_unicode] = ACTIONS(298),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_catch_clause] = STATE(70),
    [aux_sym_try_statement_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(305),
    [anon_sym_DASH] = ACTIONS(305),
    [anon_sym_TILDE] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_RBRACE] = ACTIONS(307),
    [anon_sym_type] = ACTIONS(305),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_for] = ACTIONS(305),
    [anon_sym_assembly] = ACTIONS(305),
    [anon_sym_break] = ACTIONS(305),
    [anon_sym_continue] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(305),
    [anon_sym_false] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_function] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(305),
    [anon_sym_address] = ACTIONS(305),
    [anon_sym_return] = ACTIONS(305),
    [anon_sym_revert] = ACTIONS(305),
    [sym__unchecked] = ACTIONS(305),
    [anon_sym_var] = ACTIONS(305),
    [anon_sym_else] = ACTIONS(305),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_do] = ACTIONS(305),
    [anon_sym_try] = ACTIONS(305),
    [anon_sym_catch] = ACTIONS(296),
    [anon_sym_emit] = ACTIONS(305),
    [anon_sym_payable] = ACTIONS(305),
    [anon_sym_new] = ACTIONS(305),
    [anon_sym_LBRACK] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(305),
    [anon_sym_BANG] = ACTIONS(307),
    [anon_sym_delete] = ACTIONS(305),
    [anon_sym_PLUS_PLUS] = ACTIONS(307),
    [anon_sym_DASH_DASH] = ACTIONS(307),
    [anon_sym_mapping] = ACTIONS(305),
    [anon_sym_bool] = ACTIONS(305),
    [anon_sym_string] = ACTIONS(305),
    [anon_sym_int] = ACTIONS(305),
    [anon_sym_int8] = ACTIONS(305),
    [anon_sym_int16] = ACTIONS(305),
    [anon_sym_int24] = ACTIONS(305),
    [anon_sym_int32] = ACTIONS(305),
    [anon_sym_int40] = ACTIONS(305),
    [anon_sym_int48] = ACTIONS(305),
    [anon_sym_int56] = ACTIONS(305),
    [anon_sym_int64] = ACTIONS(305),
    [anon_sym_int72] = ACTIONS(305),
    [anon_sym_int80] = ACTIONS(305),
    [anon_sym_int88] = ACTIONS(305),
    [anon_sym_int96] = ACTIONS(305),
    [anon_sym_int104] = ACTIONS(305),
    [anon_sym_int112] = ACTIONS(305),
    [anon_sym_int120] = ACTIONS(305),
    [anon_sym_int128] = ACTIONS(305),
    [anon_sym_int136] = ACTIONS(305),
    [anon_sym_int144] = ACTIONS(305),
    [anon_sym_int152] = ACTIONS(305),
    [anon_sym_int160] = ACTIONS(305),
    [anon_sym_int168] = ACTIONS(305),
    [anon_sym_int176] = ACTIONS(305),
    [anon_sym_int184] = ACTIONS(305),
    [anon_sym_int192] = ACTIONS(305),
    [anon_sym_int200] = ACTIONS(305),
    [anon_sym_int208] = ACTIONS(305),
    [anon_sym_int216] = ACTIONS(305),
    [anon_sym_int224] = ACTIONS(305),
    [anon_sym_int232] = ACTIONS(305),
    [anon_sym_int240] = ACTIONS(305),
    [anon_sym_int248] = ACTIONS(305),
    [anon_sym_int256] = ACTIONS(305),
    [anon_sym_uint] = ACTIONS(305),
    [anon_sym_uint8] = ACTIONS(305),
    [anon_sym_uint16] = ACTIONS(305),
    [anon_sym_uint24] = ACTIONS(305),
    [anon_sym_uint32] = ACTIONS(305),
    [anon_sym_uint40] = ACTIONS(305),
    [anon_sym_uint48] = ACTIONS(305),
    [anon_sym_uint56] = ACTIONS(305),
    [anon_sym_uint64] = ACTIONS(305),
    [anon_sym_uint72] = ACTIONS(305),
    [anon_sym_uint80] = ACTIONS(305),
    [anon_sym_uint88] = ACTIONS(305),
    [anon_sym_uint96] = ACTIONS(305),
    [anon_sym_uint104] = ACTIONS(305),
    [anon_sym_uint112] = ACTIONS(305),
    [anon_sym_uint120] = ACTIONS(305),
    [anon_sym_uint128] = ACTIONS(305),
    [anon_sym_uint136] = ACTIONS(305),
    [anon_sym_uint144] = ACTIONS(305),
    [anon_sym_uint152] = ACTIONS(305),
    [anon_sym_uint160] = ACTIONS(305),
    [anon_sym_uint168] = ACTIONS(305),
    [anon_sym_uint176] = ACTIONS(305),
    [anon_sym_uint184] = ACTIONS(305),
    [anon_sym_uint192] = ACTIONS(305),
    [anon_sym_uint200] = ACTIONS(305),
    [anon_sym_uint208] = ACTIONS(305),
    [anon_sym_uint216] = ACTIONS(305),
    [anon_sym_uint224] = ACTIONS(305),
    [anon_sym_uint232] = ACTIONS(305),
    [anon_sym_uint240] = ACTIONS(305),
    [anon_sym_uint248] = ACTIONS(305),
    [anon_sym_uint256] = ACTIONS(305),
    [anon_sym_bytes] = ACTIONS(305),
    [anon_sym_bytes1] = ACTIONS(305),
    [anon_sym_bytes2] = ACTIONS(305),
    [anon_sym_bytes3] = ACTIONS(305),
    [anon_sym_bytes4] = ACTIONS(305),
    [anon_sym_bytes5] = ACTIONS(305),
    [anon_sym_bytes6] = ACTIONS(305),
    [anon_sym_bytes7] = ACTIONS(305),
    [anon_sym_bytes8] = ACTIONS(305),
    [anon_sym_bytes9] = ACTIONS(305),
    [anon_sym_bytes10] = ACTIONS(305),
    [anon_sym_bytes11] = ACTIONS(305),
    [anon_sym_bytes12] = ACTIONS(305),
    [anon_sym_bytes13] = ACTIONS(305),
    [anon_sym_bytes14] = ACTIONS(305),
    [anon_sym_bytes15] = ACTIONS(305),
    [anon_sym_bytes16] = ACTIONS(305),
    [anon_sym_bytes17] = ACTIONS(305),
    [anon_sym_bytes18] = ACTIONS(305),
    [anon_sym_bytes19] = ACTIONS(305),
    [anon_sym_bytes20] = ACTIONS(305),
    [anon_sym_bytes21] = ACTIONS(305),
    [anon_sym_bytes22] = ACTIONS(305),
    [anon_sym_bytes23] = ACTIONS(305),
    [anon_sym_bytes24] = ACTIONS(305),
    [anon_sym_bytes25] = ACTIONS(305),
    [anon_sym_bytes26] = ACTIONS(305),
    [anon_sym_bytes27] = ACTIONS(305),
    [anon_sym_bytes28] = ACTIONS(305),
    [anon_sym_bytes29] = ACTIONS(305),
    [anon_sym_bytes30] = ACTIONS(305),
    [anon_sym_bytes31] = ACTIONS(305),
    [anon_sym_bytes32] = ACTIONS(305),
    [anon_sym_fixed] = ACTIONS(305),
    [aux_sym__fixed_token1] = ACTIONS(305),
    [anon_sym_ufixed] = ACTIONS(305),
    [aux_sym__ufixed_token1] = ACTIONS(305),
    [aux_sym__decimal_number_token1] = ACTIONS(305),
    [aux_sym__decimal_number_token2] = ACTIONS(307),
    [aux_sym__hex_number_token1] = ACTIONS(307),
    [anon_sym_hex] = ACTIONS(305),
    [anon_sym_DQUOTE] = ACTIONS(307),
    [anon_sym_SQUOTE] = ACTIONS(307),
    [anon_sym_unicode] = ACTIONS(305),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__source_unit] = STATE(73),
    [sym__directive] = STATE(73),
    [sym_pragma_directive] = STATE(73),
    [sym_import_directive] = STATE(73),
    [sym__declaration] = STATE(73),
    [sym_user_defined_type_definition] = STATE(73),
    [sym_constant_variable_declaration] = STATE(73),
    [sym_contract_declaration] = STATE(73),
    [sym_error_declaration] = STATE(73),
    [sym_interface_declaration] = STATE(73),
    [sym_library_declaration] = STATE(73),
    [sym_struct_declaration] = STATE(73),
    [sym_enum_declaration] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_type_name] = STATE(663),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_source_file_repeat1] = STATE(73),
    [ts_builtin_sym_end] = ACTIONS(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_pragma] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_abstract] = ACTIONS(15),
    [anon_sym_contract] = ACTIONS(17),
    [anon_sym_error] = ACTIONS(19),
    [anon_sym_interface] = ACTIONS(21),
    [anon_sym_library] = ACTIONS(23),
    [anon_sym_struct] = ACTIONS(25),
    [anon_sym_enum] = ACTIONS(27),
    [anon_sym_function] = ACTIONS(29),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__source_unit] = STATE(73),
    [sym__directive] = STATE(73),
    [sym_pragma_directive] = STATE(73),
    [sym_import_directive] = STATE(73),
    [sym__declaration] = STATE(73),
    [sym_user_defined_type_definition] = STATE(73),
    [sym_constant_variable_declaration] = STATE(73),
    [sym_contract_declaration] = STATE(73),
    [sym_error_declaration] = STATE(73),
    [sym_interface_declaration] = STATE(73),
    [sym_library_declaration] = STATE(73),
    [sym_struct_declaration] = STATE(73),
    [sym_enum_declaration] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_type_name] = STATE(663),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_source_file_repeat1] = STATE(73),
    [ts_builtin_sym_end] = ACTIONS(311),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_pragma] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(319),
    [anon_sym_type] = ACTIONS(322),
    [anon_sym_abstract] = ACTIONS(325),
    [anon_sym_contract] = ACTIONS(328),
    [anon_sym_error] = ACTIONS(331),
    [anon_sym_interface] = ACTIONS(334),
    [anon_sym_library] = ACTIONS(337),
    [anon_sym_struct] = ACTIONS(340),
    [anon_sym_enum] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(346),
    [anon_sym_byte] = ACTIONS(349),
    [anon_sym_address] = ACTIONS(352),
    [anon_sym_var] = ACTIONS(349),
    [anon_sym_mapping] = ACTIONS(355),
    [anon_sym_bool] = ACTIONS(349),
    [anon_sym_string] = ACTIONS(349),
    [anon_sym_int] = ACTIONS(349),
    [anon_sym_int8] = ACTIONS(349),
    [anon_sym_int16] = ACTIONS(349),
    [anon_sym_int24] = ACTIONS(349),
    [anon_sym_int32] = ACTIONS(349),
    [anon_sym_int40] = ACTIONS(349),
    [anon_sym_int48] = ACTIONS(349),
    [anon_sym_int56] = ACTIONS(349),
    [anon_sym_int64] = ACTIONS(349),
    [anon_sym_int72] = ACTIONS(349),
    [anon_sym_int80] = ACTIONS(349),
    [anon_sym_int88] = ACTIONS(349),
    [anon_sym_int96] = ACTIONS(349),
    [anon_sym_int104] = ACTIONS(349),
    [anon_sym_int112] = ACTIONS(349),
    [anon_sym_int120] = ACTIONS(349),
    [anon_sym_int128] = ACTIONS(349),
    [anon_sym_int136] = ACTIONS(349),
    [anon_sym_int144] = ACTIONS(349),
    [anon_sym_int152] = ACTIONS(349),
    [anon_sym_int160] = ACTIONS(349),
    [anon_sym_int168] = ACTIONS(349),
    [anon_sym_int176] = ACTIONS(349),
    [anon_sym_int184] = ACTIONS(349),
    [anon_sym_int192] = ACTIONS(349),
    [anon_sym_int200] = ACTIONS(349),
    [anon_sym_int208] = ACTIONS(349),
    [anon_sym_int216] = ACTIONS(349),
    [anon_sym_int224] = ACTIONS(349),
    [anon_sym_int232] = ACTIONS(349),
    [anon_sym_int240] = ACTIONS(349),
    [anon_sym_int248] = ACTIONS(349),
    [anon_sym_int256] = ACTIONS(349),
    [anon_sym_uint] = ACTIONS(349),
    [anon_sym_uint8] = ACTIONS(349),
    [anon_sym_uint16] = ACTIONS(349),
    [anon_sym_uint24] = ACTIONS(349),
    [anon_sym_uint32] = ACTIONS(349),
    [anon_sym_uint40] = ACTIONS(349),
    [anon_sym_uint48] = ACTIONS(349),
    [anon_sym_uint56] = ACTIONS(349),
    [anon_sym_uint64] = ACTIONS(349),
    [anon_sym_uint72] = ACTIONS(349),
    [anon_sym_uint80] = ACTIONS(349),
    [anon_sym_uint88] = ACTIONS(349),
    [anon_sym_uint96] = ACTIONS(349),
    [anon_sym_uint104] = ACTIONS(349),
    [anon_sym_uint112] = ACTIONS(349),
    [anon_sym_uint120] = ACTIONS(349),
    [anon_sym_uint128] = ACTIONS(349),
    [anon_sym_uint136] = ACTIONS(349),
    [anon_sym_uint144] = ACTIONS(349),
    [anon_sym_uint152] = ACTIONS(349),
    [anon_sym_uint160] = ACTIONS(349),
    [anon_sym_uint168] = ACTIONS(349),
    [anon_sym_uint176] = ACTIONS(349),
    [anon_sym_uint184] = ACTIONS(349),
    [anon_sym_uint192] = ACTIONS(349),
    [anon_sym_uint200] = ACTIONS(349),
    [anon_sym_uint208] = ACTIONS(349),
    [anon_sym_uint216] = ACTIONS(349),
    [anon_sym_uint224] = ACTIONS(349),
    [anon_sym_uint232] = ACTIONS(349),
    [anon_sym_uint240] = ACTIONS(349),
    [anon_sym_uint248] = ACTIONS(349),
    [anon_sym_uint256] = ACTIONS(349),
    [anon_sym_bytes] = ACTIONS(349),
    [anon_sym_bytes1] = ACTIONS(349),
    [anon_sym_bytes2] = ACTIONS(349),
    [anon_sym_bytes3] = ACTIONS(349),
    [anon_sym_bytes4] = ACTIONS(349),
    [anon_sym_bytes5] = ACTIONS(349),
    [anon_sym_bytes6] = ACTIONS(349),
    [anon_sym_bytes7] = ACTIONS(349),
    [anon_sym_bytes8] = ACTIONS(349),
    [anon_sym_bytes9] = ACTIONS(349),
    [anon_sym_bytes10] = ACTIONS(349),
    [anon_sym_bytes11] = ACTIONS(349),
    [anon_sym_bytes12] = ACTIONS(349),
    [anon_sym_bytes13] = ACTIONS(349),
    [anon_sym_bytes14] = ACTIONS(349),
    [anon_sym_bytes15] = ACTIONS(349),
    [anon_sym_bytes16] = ACTIONS(349),
    [anon_sym_bytes17] = ACTIONS(349),
    [anon_sym_bytes18] = ACTIONS(349),
    [anon_sym_bytes19] = ACTIONS(349),
    [anon_sym_bytes20] = ACTIONS(349),
    [anon_sym_bytes21] = ACTIONS(349),
    [anon_sym_bytes22] = ACTIONS(349),
    [anon_sym_bytes23] = ACTIONS(349),
    [anon_sym_bytes24] = ACTIONS(349),
    [anon_sym_bytes25] = ACTIONS(349),
    [anon_sym_bytes26] = ACTIONS(349),
    [anon_sym_bytes27] = ACTIONS(349),
    [anon_sym_bytes28] = ACTIONS(349),
    [anon_sym_bytes29] = ACTIONS(349),
    [anon_sym_bytes30] = ACTIONS(349),
    [anon_sym_bytes31] = ACTIONS(349),
    [anon_sym_bytes32] = ACTIONS(349),
    [anon_sym_fixed] = ACTIONS(349),
    [aux_sym__fixed_token1] = ACTIONS(349),
    [anon_sym_ufixed] = ACTIONS(349),
    [aux_sym__ufixed_token1] = ACTIONS(349),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_identifier] = ACTIONS(358),
    [anon_sym_DASH] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(360),
    [anon_sym_LBRACE] = ACTIONS(360),
    [anon_sym_RBRACE] = ACTIONS(360),
    [anon_sym_type] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(360),
    [anon_sym_RPAREN] = ACTIONS(360),
    [anon_sym_for] = ACTIONS(358),
    [anon_sym_assembly] = ACTIONS(358),
    [anon_sym_break] = ACTIONS(358),
    [anon_sym_continue] = ACTIONS(358),
    [anon_sym_true] = ACTIONS(358),
    [anon_sym_false] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_byte] = ACTIONS(358),
    [anon_sym_address] = ACTIONS(358),
    [anon_sym_return] = ACTIONS(358),
    [anon_sym_revert] = ACTIONS(358),
    [sym__unchecked] = ACTIONS(358),
    [anon_sym_var] = ACTIONS(358),
    [anon_sym_else] = ACTIONS(358),
    [anon_sym_while] = ACTIONS(358),
    [anon_sym_do] = ACTIONS(358),
    [anon_sym_try] = ACTIONS(358),
    [anon_sym_emit] = ACTIONS(358),
    [anon_sym_payable] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(358),
    [anon_sym_LBRACK] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(358),
    [anon_sym_BANG] = ACTIONS(360),
    [anon_sym_delete] = ACTIONS(358),
    [anon_sym_PLUS_PLUS] = ACTIONS(360),
    [anon_sym_DASH_DASH] = ACTIONS(360),
    [anon_sym_mapping] = ACTIONS(358),
    [anon_sym_bool] = ACTIONS(358),
    [anon_sym_string] = ACTIONS(358),
    [anon_sym_int] = ACTIONS(358),
    [anon_sym_int8] = ACTIONS(358),
    [anon_sym_int16] = ACTIONS(358),
    [anon_sym_int24] = ACTIONS(358),
    [anon_sym_int32] = ACTIONS(358),
    [anon_sym_int40] = ACTIONS(358),
    [anon_sym_int48] = ACTIONS(358),
    [anon_sym_int56] = ACTIONS(358),
    [anon_sym_int64] = ACTIONS(358),
    [anon_sym_int72] = ACTIONS(358),
    [anon_sym_int80] = ACTIONS(358),
    [anon_sym_int88] = ACTIONS(358),
    [anon_sym_int96] = ACTIONS(358),
    [anon_sym_int104] = ACTIONS(358),
    [anon_sym_int112] = ACTIONS(358),
    [anon_sym_int120] = ACTIONS(358),
    [anon_sym_int128] = ACTIONS(358),
    [anon_sym_int136] = ACTIONS(358),
    [anon_sym_int144] = ACTIONS(358),
    [anon_sym_int152] = ACTIONS(358),
    [anon_sym_int160] = ACTIONS(358),
    [anon_sym_int168] = ACTIONS(358),
    [anon_sym_int176] = ACTIONS(358),
    [anon_sym_int184] = ACTIONS(358),
    [anon_sym_int192] = ACTIONS(358),
    [anon_sym_int200] = ACTIONS(358),
    [anon_sym_int208] = ACTIONS(358),
    [anon_sym_int216] = ACTIONS(358),
    [anon_sym_int224] = ACTIONS(358),
    [anon_sym_int232] = ACTIONS(358),
    [anon_sym_int240] = ACTIONS(358),
    [anon_sym_int248] = ACTIONS(358),
    [anon_sym_int256] = ACTIONS(358),
    [anon_sym_uint] = ACTIONS(358),
    [anon_sym_uint8] = ACTIONS(358),
    [anon_sym_uint16] = ACTIONS(358),
    [anon_sym_uint24] = ACTIONS(358),
    [anon_sym_uint32] = ACTIONS(358),
    [anon_sym_uint40] = ACTIONS(358),
    [anon_sym_uint48] = ACTIONS(358),
    [anon_sym_uint56] = ACTIONS(358),
    [anon_sym_uint64] = ACTIONS(358),
    [anon_sym_uint72] = ACTIONS(358),
    [anon_sym_uint80] = ACTIONS(358),
    [anon_sym_uint88] = ACTIONS(358),
    [anon_sym_uint96] = ACTIONS(358),
    [anon_sym_uint104] = ACTIONS(358),
    [anon_sym_uint112] = ACTIONS(358),
    [anon_sym_uint120] = ACTIONS(358),
    [anon_sym_uint128] = ACTIONS(358),
    [anon_sym_uint136] = ACTIONS(358),
    [anon_sym_uint144] = ACTIONS(358),
    [anon_sym_uint152] = ACTIONS(358),
    [anon_sym_uint160] = ACTIONS(358),
    [anon_sym_uint168] = ACTIONS(358),
    [anon_sym_uint176] = ACTIONS(358),
    [anon_sym_uint184] = ACTIONS(358),
    [anon_sym_uint192] = ACTIONS(358),
    [anon_sym_uint200] = ACTIONS(358),
    [anon_sym_uint208] = ACTIONS(358),
    [anon_sym_uint216] = ACTIONS(358),
    [anon_sym_uint224] = ACTIONS(358),
    [anon_sym_uint232] = ACTIONS(358),
    [anon_sym_uint240] = ACTIONS(358),
    [anon_sym_uint248] = ACTIONS(358),
    [anon_sym_uint256] = ACTIONS(358),
    [anon_sym_bytes] = ACTIONS(358),
    [anon_sym_bytes1] = ACTIONS(358),
    [anon_sym_bytes2] = ACTIONS(358),
    [anon_sym_bytes3] = ACTIONS(358),
    [anon_sym_bytes4] = ACTIONS(358),
    [anon_sym_bytes5] = ACTIONS(358),
    [anon_sym_bytes6] = ACTIONS(358),
    [anon_sym_bytes7] = ACTIONS(358),
    [anon_sym_bytes8] = ACTIONS(358),
    [anon_sym_bytes9] = ACTIONS(358),
    [anon_sym_bytes10] = ACTIONS(358),
    [anon_sym_bytes11] = ACTIONS(358),
    [anon_sym_bytes12] = ACTIONS(358),
    [anon_sym_bytes13] = ACTIONS(358),
    [anon_sym_bytes14] = ACTIONS(358),
    [anon_sym_bytes15] = ACTIONS(358),
    [anon_sym_bytes16] = ACTIONS(358),
    [anon_sym_bytes17] = ACTIONS(358),
    [anon_sym_bytes18] = ACTIONS(358),
    [anon_sym_bytes19] = ACTIONS(358),
    [anon_sym_bytes20] = ACTIONS(358),
    [anon_sym_bytes21] = ACTIONS(358),
    [anon_sym_bytes22] = ACTIONS(358),
    [anon_sym_bytes23] = ACTIONS(358),
    [anon_sym_bytes24] = ACTIONS(358),
    [anon_sym_bytes25] = ACTIONS(358),
    [anon_sym_bytes26] = ACTIONS(358),
    [anon_sym_bytes27] = ACTIONS(358),
    [anon_sym_bytes28] = ACTIONS(358),
    [anon_sym_bytes29] = ACTIONS(358),
    [anon_sym_bytes30] = ACTIONS(358),
    [anon_sym_bytes31] = ACTIONS(358),
    [anon_sym_bytes32] = ACTIONS(358),
    [anon_sym_fixed] = ACTIONS(358),
    [aux_sym__fixed_token1] = ACTIONS(358),
    [anon_sym_ufixed] = ACTIONS(358),
    [aux_sym__ufixed_token1] = ACTIONS(358),
    [sym__semicolon] = ACTIONS(360),
    [aux_sym__decimal_number_token1] = ACTIONS(358),
    [aux_sym__decimal_number_token2] = ACTIONS(360),
    [aux_sym__hex_number_token1] = ACTIONS(360),
    [anon_sym_hex] = ACTIONS(358),
    [anon_sym_DQUOTE] = ACTIONS(360),
    [anon_sym_SQUOTE] = ACTIONS(360),
    [anon_sym_unicode] = ACTIONS(358),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_identifier] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(362),
    [anon_sym_TILDE] = ACTIONS(364),
    [anon_sym_LBRACE] = ACTIONS(364),
    [anon_sym_RBRACE] = ACTIONS(364),
    [anon_sym_type] = ACTIONS(362),
    [anon_sym_LPAREN] = ACTIONS(364),
    [anon_sym_for] = ACTIONS(362),
    [anon_sym_assembly] = ACTIONS(362),
    [anon_sym_break] = ACTIONS(362),
    [anon_sym_continue] = ACTIONS(362),
    [anon_sym_true] = ACTIONS(362),
    [anon_sym_false] = ACTIONS(362),
    [anon_sym_if] = ACTIONS(362),
    [anon_sym_function] = ACTIONS(362),
    [anon_sym_byte] = ACTIONS(362),
    [anon_sym_address] = ACTIONS(362),
    [anon_sym_return] = ACTIONS(362),
    [anon_sym_revert] = ACTIONS(362),
    [sym__unchecked] = ACTIONS(362),
    [anon_sym_var] = ACTIONS(362),
    [anon_sym_else] = ACTIONS(362),
    [anon_sym_while] = ACTIONS(362),
    [anon_sym_do] = ACTIONS(362),
    [anon_sym_try] = ACTIONS(362),
    [anon_sym_catch] = ACTIONS(362),
    [anon_sym_emit] = ACTIONS(362),
    [anon_sym_payable] = ACTIONS(362),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_LBRACK] = ACTIONS(364),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(362),
    [anon_sym_PLUS_PLUS] = ACTIONS(364),
    [anon_sym_DASH_DASH] = ACTIONS(364),
    [anon_sym_mapping] = ACTIONS(362),
    [anon_sym_bool] = ACTIONS(362),
    [anon_sym_string] = ACTIONS(362),
    [anon_sym_int] = ACTIONS(362),
    [anon_sym_int8] = ACTIONS(362),
    [anon_sym_int16] = ACTIONS(362),
    [anon_sym_int24] = ACTIONS(362),
    [anon_sym_int32] = ACTIONS(362),
    [anon_sym_int40] = ACTIONS(362),
    [anon_sym_int48] = ACTIONS(362),
    [anon_sym_int56] = ACTIONS(362),
    [anon_sym_int64] = ACTIONS(362),
    [anon_sym_int72] = ACTIONS(362),
    [anon_sym_int80] = ACTIONS(362),
    [anon_sym_int88] = ACTIONS(362),
    [anon_sym_int96] = ACTIONS(362),
    [anon_sym_int104] = ACTIONS(362),
    [anon_sym_int112] = ACTIONS(362),
    [anon_sym_int120] = ACTIONS(362),
    [anon_sym_int128] = ACTIONS(362),
    [anon_sym_int136] = ACTIONS(362),
    [anon_sym_int144] = ACTIONS(362),
    [anon_sym_int152] = ACTIONS(362),
    [anon_sym_int160] = ACTIONS(362),
    [anon_sym_int168] = ACTIONS(362),
    [anon_sym_int176] = ACTIONS(362),
    [anon_sym_int184] = ACTIONS(362),
    [anon_sym_int192] = ACTIONS(362),
    [anon_sym_int200] = ACTIONS(362),
    [anon_sym_int208] = ACTIONS(362),
    [anon_sym_int216] = ACTIONS(362),
    [anon_sym_int224] = ACTIONS(362),
    [anon_sym_int232] = ACTIONS(362),
    [anon_sym_int240] = ACTIONS(362),
    [anon_sym_int248] = ACTIONS(362),
    [anon_sym_int256] = ACTIONS(362),
    [anon_sym_uint] = ACTIONS(362),
    [anon_sym_uint8] = ACTIONS(362),
    [anon_sym_uint16] = ACTIONS(362),
    [anon_sym_uint24] = ACTIONS(362),
    [anon_sym_uint32] = ACTIONS(362),
    [anon_sym_uint40] = ACTIONS(362),
    [anon_sym_uint48] = ACTIONS(362),
    [anon_sym_uint56] = ACTIONS(362),
    [anon_sym_uint64] = ACTIONS(362),
    [anon_sym_uint72] = ACTIONS(362),
    [anon_sym_uint80] = ACTIONS(362),
    [anon_sym_uint88] = ACTIONS(362),
    [anon_sym_uint96] = ACTIONS(362),
    [anon_sym_uint104] = ACTIONS(362),
    [anon_sym_uint112] = ACTIONS(362),
    [anon_sym_uint120] = ACTIONS(362),
    [anon_sym_uint128] = ACTIONS(362),
    [anon_sym_uint136] = ACTIONS(362),
    [anon_sym_uint144] = ACTIONS(362),
    [anon_sym_uint152] = ACTIONS(362),
    [anon_sym_uint160] = ACTIONS(362),
    [anon_sym_uint168] = ACTIONS(362),
    [anon_sym_uint176] = ACTIONS(362),
    [anon_sym_uint184] = ACTIONS(362),
    [anon_sym_uint192] = ACTIONS(362),
    [anon_sym_uint200] = ACTIONS(362),
    [anon_sym_uint208] = ACTIONS(362),
    [anon_sym_uint216] = ACTIONS(362),
    [anon_sym_uint224] = ACTIONS(362),
    [anon_sym_uint232] = ACTIONS(362),
    [anon_sym_uint240] = ACTIONS(362),
    [anon_sym_uint248] = ACTIONS(362),
    [anon_sym_uint256] = ACTIONS(362),
    [anon_sym_bytes] = ACTIONS(362),
    [anon_sym_bytes1] = ACTIONS(362),
    [anon_sym_bytes2] = ACTIONS(362),
    [anon_sym_bytes3] = ACTIONS(362),
    [anon_sym_bytes4] = ACTIONS(362),
    [anon_sym_bytes5] = ACTIONS(362),
    [anon_sym_bytes6] = ACTIONS(362),
    [anon_sym_bytes7] = ACTIONS(362),
    [anon_sym_bytes8] = ACTIONS(362),
    [anon_sym_bytes9] = ACTIONS(362),
    [anon_sym_bytes10] = ACTIONS(362),
    [anon_sym_bytes11] = ACTIONS(362),
    [anon_sym_bytes12] = ACTIONS(362),
    [anon_sym_bytes13] = ACTIONS(362),
    [anon_sym_bytes14] = ACTIONS(362),
    [anon_sym_bytes15] = ACTIONS(362),
    [anon_sym_bytes16] = ACTIONS(362),
    [anon_sym_bytes17] = ACTIONS(362),
    [anon_sym_bytes18] = ACTIONS(362),
    [anon_sym_bytes19] = ACTIONS(362),
    [anon_sym_bytes20] = ACTIONS(362),
    [anon_sym_bytes21] = ACTIONS(362),
    [anon_sym_bytes22] = ACTIONS(362),
    [anon_sym_bytes23] = ACTIONS(362),
    [anon_sym_bytes24] = ACTIONS(362),
    [anon_sym_bytes25] = ACTIONS(362),
    [anon_sym_bytes26] = ACTIONS(362),
    [anon_sym_bytes27] = ACTIONS(362),
    [anon_sym_bytes28] = ACTIONS(362),
    [anon_sym_bytes29] = ACTIONS(362),
    [anon_sym_bytes30] = ACTIONS(362),
    [anon_sym_bytes31] = ACTIONS(362),
    [anon_sym_bytes32] = ACTIONS(362),
    [anon_sym_fixed] = ACTIONS(362),
    [aux_sym__fixed_token1] = ACTIONS(362),
    [anon_sym_ufixed] = ACTIONS(362),
    [aux_sym__ufixed_token1] = ACTIONS(362),
    [aux_sym__decimal_number_token1] = ACTIONS(362),
    [aux_sym__decimal_number_token2] = ACTIONS(364),
    [aux_sym__hex_number_token1] = ACTIONS(364),
    [anon_sym_hex] = ACTIONS(362),
    [anon_sym_DQUOTE] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(364),
    [anon_sym_unicode] = ACTIONS(362),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_identifier] = ACTIONS(366),
    [anon_sym_DASH] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(368),
    [anon_sym_RBRACE] = ACTIONS(368),
    [anon_sym_type] = ACTIONS(366),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_for] = ACTIONS(366),
    [anon_sym_assembly] = ACTIONS(366),
    [anon_sym_break] = ACTIONS(366),
    [anon_sym_continue] = ACTIONS(366),
    [anon_sym_true] = ACTIONS(366),
    [anon_sym_false] = ACTIONS(366),
    [anon_sym_if] = ACTIONS(366),
    [anon_sym_function] = ACTIONS(366),
    [anon_sym_byte] = ACTIONS(366),
    [anon_sym_address] = ACTIONS(366),
    [anon_sym_return] = ACTIONS(366),
    [anon_sym_revert] = ACTIONS(366),
    [sym__unchecked] = ACTIONS(366),
    [anon_sym_var] = ACTIONS(366),
    [anon_sym_else] = ACTIONS(366),
    [anon_sym_while] = ACTIONS(366),
    [anon_sym_do] = ACTIONS(366),
    [anon_sym_try] = ACTIONS(366),
    [anon_sym_catch] = ACTIONS(366),
    [anon_sym_emit] = ACTIONS(366),
    [anon_sym_payable] = ACTIONS(366),
    [anon_sym_new] = ACTIONS(366),
    [anon_sym_LBRACK] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(366),
    [anon_sym_BANG] = ACTIONS(368),
    [anon_sym_delete] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_mapping] = ACTIONS(366),
    [anon_sym_bool] = ACTIONS(366),
    [anon_sym_string] = ACTIONS(366),
    [anon_sym_int] = ACTIONS(366),
    [anon_sym_int8] = ACTIONS(366),
    [anon_sym_int16] = ACTIONS(366),
    [anon_sym_int24] = ACTIONS(366),
    [anon_sym_int32] = ACTIONS(366),
    [anon_sym_int40] = ACTIONS(366),
    [anon_sym_int48] = ACTIONS(366),
    [anon_sym_int56] = ACTIONS(366),
    [anon_sym_int64] = ACTIONS(366),
    [anon_sym_int72] = ACTIONS(366),
    [anon_sym_int80] = ACTIONS(366),
    [anon_sym_int88] = ACTIONS(366),
    [anon_sym_int96] = ACTIONS(366),
    [anon_sym_int104] = ACTIONS(366),
    [anon_sym_int112] = ACTIONS(366),
    [anon_sym_int120] = ACTIONS(366),
    [anon_sym_int128] = ACTIONS(366),
    [anon_sym_int136] = ACTIONS(366),
    [anon_sym_int144] = ACTIONS(366),
    [anon_sym_int152] = ACTIONS(366),
    [anon_sym_int160] = ACTIONS(366),
    [anon_sym_int168] = ACTIONS(366),
    [anon_sym_int176] = ACTIONS(366),
    [anon_sym_int184] = ACTIONS(366),
    [anon_sym_int192] = ACTIONS(366),
    [anon_sym_int200] = ACTIONS(366),
    [anon_sym_int208] = ACTIONS(366),
    [anon_sym_int216] = ACTIONS(366),
    [anon_sym_int224] = ACTIONS(366),
    [anon_sym_int232] = ACTIONS(366),
    [anon_sym_int240] = ACTIONS(366),
    [anon_sym_int248] = ACTIONS(366),
    [anon_sym_int256] = ACTIONS(366),
    [anon_sym_uint] = ACTIONS(366),
    [anon_sym_uint8] = ACTIONS(366),
    [anon_sym_uint16] = ACTIONS(366),
    [anon_sym_uint24] = ACTIONS(366),
    [anon_sym_uint32] = ACTIONS(366),
    [anon_sym_uint40] = ACTIONS(366),
    [anon_sym_uint48] = ACTIONS(366),
    [anon_sym_uint56] = ACTIONS(366),
    [anon_sym_uint64] = ACTIONS(366),
    [anon_sym_uint72] = ACTIONS(366),
    [anon_sym_uint80] = ACTIONS(366),
    [anon_sym_uint88] = ACTIONS(366),
    [anon_sym_uint96] = ACTIONS(366),
    [anon_sym_uint104] = ACTIONS(366),
    [anon_sym_uint112] = ACTIONS(366),
    [anon_sym_uint120] = ACTIONS(366),
    [anon_sym_uint128] = ACTIONS(366),
    [anon_sym_uint136] = ACTIONS(366),
    [anon_sym_uint144] = ACTIONS(366),
    [anon_sym_uint152] = ACTIONS(366),
    [anon_sym_uint160] = ACTIONS(366),
    [anon_sym_uint168] = ACTIONS(366),
    [anon_sym_uint176] = ACTIONS(366),
    [anon_sym_uint184] = ACTIONS(366),
    [anon_sym_uint192] = ACTIONS(366),
    [anon_sym_uint200] = ACTIONS(366),
    [anon_sym_uint208] = ACTIONS(366),
    [anon_sym_uint216] = ACTIONS(366),
    [anon_sym_uint224] = ACTIONS(366),
    [anon_sym_uint232] = ACTIONS(366),
    [anon_sym_uint240] = ACTIONS(366),
    [anon_sym_uint248] = ACTIONS(366),
    [anon_sym_uint256] = ACTIONS(366),
    [anon_sym_bytes] = ACTIONS(366),
    [anon_sym_bytes1] = ACTIONS(366),
    [anon_sym_bytes2] = ACTIONS(366),
    [anon_sym_bytes3] = ACTIONS(366),
    [anon_sym_bytes4] = ACTIONS(366),
    [anon_sym_bytes5] = ACTIONS(366),
    [anon_sym_bytes6] = ACTIONS(366),
    [anon_sym_bytes7] = ACTIONS(366),
    [anon_sym_bytes8] = ACTIONS(366),
    [anon_sym_bytes9] = ACTIONS(366),
    [anon_sym_bytes10] = ACTIONS(366),
    [anon_sym_bytes11] = ACTIONS(366),
    [anon_sym_bytes12] = ACTIONS(366),
    [anon_sym_bytes13] = ACTIONS(366),
    [anon_sym_bytes14] = ACTIONS(366),
    [anon_sym_bytes15] = ACTIONS(366),
    [anon_sym_bytes16] = ACTIONS(366),
    [anon_sym_bytes17] = ACTIONS(366),
    [anon_sym_bytes18] = ACTIONS(366),
    [anon_sym_bytes19] = ACTIONS(366),
    [anon_sym_bytes20] = ACTIONS(366),
    [anon_sym_bytes21] = ACTIONS(366),
    [anon_sym_bytes22] = ACTIONS(366),
    [anon_sym_bytes23] = ACTIONS(366),
    [anon_sym_bytes24] = ACTIONS(366),
    [anon_sym_bytes25] = ACTIONS(366),
    [anon_sym_bytes26] = ACTIONS(366),
    [anon_sym_bytes27] = ACTIONS(366),
    [anon_sym_bytes28] = ACTIONS(366),
    [anon_sym_bytes29] = ACTIONS(366),
    [anon_sym_bytes30] = ACTIONS(366),
    [anon_sym_bytes31] = ACTIONS(366),
    [anon_sym_bytes32] = ACTIONS(366),
    [anon_sym_fixed] = ACTIONS(366),
    [aux_sym__fixed_token1] = ACTIONS(366),
    [anon_sym_ufixed] = ACTIONS(366),
    [aux_sym__ufixed_token1] = ACTIONS(366),
    [aux_sym__decimal_number_token1] = ACTIONS(366),
    [aux_sym__decimal_number_token2] = ACTIONS(368),
    [aux_sym__hex_number_token1] = ACTIONS(368),
    [anon_sym_hex] = ACTIONS(366),
    [anon_sym_DQUOTE] = ACTIONS(368),
    [anon_sym_SQUOTE] = ACTIONS(368),
    [anon_sym_unicode] = ACTIONS(366),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_identifier] = ACTIONS(370),
    [anon_sym_DASH] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_RBRACE] = ACTIONS(372),
    [anon_sym_type] = ACTIONS(370),
    [anon_sym_LPAREN] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(370),
    [anon_sym_assembly] = ACTIONS(370),
    [anon_sym_break] = ACTIONS(370),
    [anon_sym_continue] = ACTIONS(370),
    [anon_sym_true] = ACTIONS(370),
    [anon_sym_false] = ACTIONS(370),
    [anon_sym_if] = ACTIONS(370),
    [anon_sym_function] = ACTIONS(370),
    [anon_sym_byte] = ACTIONS(370),
    [anon_sym_address] = ACTIONS(370),
    [anon_sym_return] = ACTIONS(370),
    [anon_sym_revert] = ACTIONS(370),
    [sym__unchecked] = ACTIONS(370),
    [anon_sym_var] = ACTIONS(370),
    [anon_sym_else] = ACTIONS(370),
    [anon_sym_while] = ACTIONS(370),
    [anon_sym_do] = ACTIONS(370),
    [anon_sym_try] = ACTIONS(370),
    [anon_sym_catch] = ACTIONS(370),
    [anon_sym_emit] = ACTIONS(370),
    [anon_sym_payable] = ACTIONS(370),
    [anon_sym_new] = ACTIONS(370),
    [anon_sym_LBRACK] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(370),
    [anon_sym_BANG] = ACTIONS(372),
    [anon_sym_delete] = ACTIONS(370),
    [anon_sym_PLUS_PLUS] = ACTIONS(372),
    [anon_sym_DASH_DASH] = ACTIONS(372),
    [anon_sym_mapping] = ACTIONS(370),
    [anon_sym_bool] = ACTIONS(370),
    [anon_sym_string] = ACTIONS(370),
    [anon_sym_int] = ACTIONS(370),
    [anon_sym_int8] = ACTIONS(370),
    [anon_sym_int16] = ACTIONS(370),
    [anon_sym_int24] = ACTIONS(370),
    [anon_sym_int32] = ACTIONS(370),
    [anon_sym_int40] = ACTIONS(370),
    [anon_sym_int48] = ACTIONS(370),
    [anon_sym_int56] = ACTIONS(370),
    [anon_sym_int64] = ACTIONS(370),
    [anon_sym_int72] = ACTIONS(370),
    [anon_sym_int80] = ACTIONS(370),
    [anon_sym_int88] = ACTIONS(370),
    [anon_sym_int96] = ACTIONS(370),
    [anon_sym_int104] = ACTIONS(370),
    [anon_sym_int112] = ACTIONS(370),
    [anon_sym_int120] = ACTIONS(370),
    [anon_sym_int128] = ACTIONS(370),
    [anon_sym_int136] = ACTIONS(370),
    [anon_sym_int144] = ACTIONS(370),
    [anon_sym_int152] = ACTIONS(370),
    [anon_sym_int160] = ACTIONS(370),
    [anon_sym_int168] = ACTIONS(370),
    [anon_sym_int176] = ACTIONS(370),
    [anon_sym_int184] = ACTIONS(370),
    [anon_sym_int192] = ACTIONS(370),
    [anon_sym_int200] = ACTIONS(370),
    [anon_sym_int208] = ACTIONS(370),
    [anon_sym_int216] = ACTIONS(370),
    [anon_sym_int224] = ACTIONS(370),
    [anon_sym_int232] = ACTIONS(370),
    [anon_sym_int240] = ACTIONS(370),
    [anon_sym_int248] = ACTIONS(370),
    [anon_sym_int256] = ACTIONS(370),
    [anon_sym_uint] = ACTIONS(370),
    [anon_sym_uint8] = ACTIONS(370),
    [anon_sym_uint16] = ACTIONS(370),
    [anon_sym_uint24] = ACTIONS(370),
    [anon_sym_uint32] = ACTIONS(370),
    [anon_sym_uint40] = ACTIONS(370),
    [anon_sym_uint48] = ACTIONS(370),
    [anon_sym_uint56] = ACTIONS(370),
    [anon_sym_uint64] = ACTIONS(370),
    [anon_sym_uint72] = ACTIONS(370),
    [anon_sym_uint80] = ACTIONS(370),
    [anon_sym_uint88] = ACTIONS(370),
    [anon_sym_uint96] = ACTIONS(370),
    [anon_sym_uint104] = ACTIONS(370),
    [anon_sym_uint112] = ACTIONS(370),
    [anon_sym_uint120] = ACTIONS(370),
    [anon_sym_uint128] = ACTIONS(370),
    [anon_sym_uint136] = ACTIONS(370),
    [anon_sym_uint144] = ACTIONS(370),
    [anon_sym_uint152] = ACTIONS(370),
    [anon_sym_uint160] = ACTIONS(370),
    [anon_sym_uint168] = ACTIONS(370),
    [anon_sym_uint176] = ACTIONS(370),
    [anon_sym_uint184] = ACTIONS(370),
    [anon_sym_uint192] = ACTIONS(370),
    [anon_sym_uint200] = ACTIONS(370),
    [anon_sym_uint208] = ACTIONS(370),
    [anon_sym_uint216] = ACTIONS(370),
    [anon_sym_uint224] = ACTIONS(370),
    [anon_sym_uint232] = ACTIONS(370),
    [anon_sym_uint240] = ACTIONS(370),
    [anon_sym_uint248] = ACTIONS(370),
    [anon_sym_uint256] = ACTIONS(370),
    [anon_sym_bytes] = ACTIONS(370),
    [anon_sym_bytes1] = ACTIONS(370),
    [anon_sym_bytes2] = ACTIONS(370),
    [anon_sym_bytes3] = ACTIONS(370),
    [anon_sym_bytes4] = ACTIONS(370),
    [anon_sym_bytes5] = ACTIONS(370),
    [anon_sym_bytes6] = ACTIONS(370),
    [anon_sym_bytes7] = ACTIONS(370),
    [anon_sym_bytes8] = ACTIONS(370),
    [anon_sym_bytes9] = ACTIONS(370),
    [anon_sym_bytes10] = ACTIONS(370),
    [anon_sym_bytes11] = ACTIONS(370),
    [anon_sym_bytes12] = ACTIONS(370),
    [anon_sym_bytes13] = ACTIONS(370),
    [anon_sym_bytes14] = ACTIONS(370),
    [anon_sym_bytes15] = ACTIONS(370),
    [anon_sym_bytes16] = ACTIONS(370),
    [anon_sym_bytes17] = ACTIONS(370),
    [anon_sym_bytes18] = ACTIONS(370),
    [anon_sym_bytes19] = ACTIONS(370),
    [anon_sym_bytes20] = ACTIONS(370),
    [anon_sym_bytes21] = ACTIONS(370),
    [anon_sym_bytes22] = ACTIONS(370),
    [anon_sym_bytes23] = ACTIONS(370),
    [anon_sym_bytes24] = ACTIONS(370),
    [anon_sym_bytes25] = ACTIONS(370),
    [anon_sym_bytes26] = ACTIONS(370),
    [anon_sym_bytes27] = ACTIONS(370),
    [anon_sym_bytes28] = ACTIONS(370),
    [anon_sym_bytes29] = ACTIONS(370),
    [anon_sym_bytes30] = ACTIONS(370),
    [anon_sym_bytes31] = ACTIONS(370),
    [anon_sym_bytes32] = ACTIONS(370),
    [anon_sym_fixed] = ACTIONS(370),
    [aux_sym__fixed_token1] = ACTIONS(370),
    [anon_sym_ufixed] = ACTIONS(370),
    [aux_sym__ufixed_token1] = ACTIONS(370),
    [aux_sym__decimal_number_token1] = ACTIONS(370),
    [aux_sym__decimal_number_token2] = ACTIONS(372),
    [aux_sym__hex_number_token1] = ACTIONS(372),
    [anon_sym_hex] = ACTIONS(370),
    [anon_sym_DQUOTE] = ACTIONS(372),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [anon_sym_unicode] = ACTIONS(370),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_identifier] = ACTIONS(374),
    [anon_sym_DASH] = ACTIONS(374),
    [anon_sym_TILDE] = ACTIONS(376),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(376),
    [anon_sym_type] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_assembly] = ACTIONS(374),
    [anon_sym_break] = ACTIONS(374),
    [anon_sym_continue] = ACTIONS(374),
    [anon_sym_true] = ACTIONS(374),
    [anon_sym_false] = ACTIONS(374),
    [anon_sym_if] = ACTIONS(374),
    [anon_sym_function] = ACTIONS(374),
    [anon_sym_byte] = ACTIONS(374),
    [anon_sym_address] = ACTIONS(374),
    [anon_sym_return] = ACTIONS(374),
    [anon_sym_revert] = ACTIONS(374),
    [sym__unchecked] = ACTIONS(374),
    [anon_sym_var] = ACTIONS(374),
    [anon_sym_else] = ACTIONS(374),
    [anon_sym_while] = ACTIONS(374),
    [anon_sym_do] = ACTIONS(374),
    [anon_sym_try] = ACTIONS(374),
    [anon_sym_emit] = ACTIONS(374),
    [anon_sym_payable] = ACTIONS(374),
    [anon_sym_new] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [anon_sym_PLUS] = ACTIONS(374),
    [anon_sym_BANG] = ACTIONS(376),
    [anon_sym_delete] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(376),
    [anon_sym_DASH_DASH] = ACTIONS(376),
    [anon_sym_mapping] = ACTIONS(374),
    [anon_sym_bool] = ACTIONS(374),
    [anon_sym_string] = ACTIONS(374),
    [anon_sym_int] = ACTIONS(374),
    [anon_sym_int8] = ACTIONS(374),
    [anon_sym_int16] = ACTIONS(374),
    [anon_sym_int24] = ACTIONS(374),
    [anon_sym_int32] = ACTIONS(374),
    [anon_sym_int40] = ACTIONS(374),
    [anon_sym_int48] = ACTIONS(374),
    [anon_sym_int56] = ACTIONS(374),
    [anon_sym_int64] = ACTIONS(374),
    [anon_sym_int72] = ACTIONS(374),
    [anon_sym_int80] = ACTIONS(374),
    [anon_sym_int88] = ACTIONS(374),
    [anon_sym_int96] = ACTIONS(374),
    [anon_sym_int104] = ACTIONS(374),
    [anon_sym_int112] = ACTIONS(374),
    [anon_sym_int120] = ACTIONS(374),
    [anon_sym_int128] = ACTIONS(374),
    [anon_sym_int136] = ACTIONS(374),
    [anon_sym_int144] = ACTIONS(374),
    [anon_sym_int152] = ACTIONS(374),
    [anon_sym_int160] = ACTIONS(374),
    [anon_sym_int168] = ACTIONS(374),
    [anon_sym_int176] = ACTIONS(374),
    [anon_sym_int184] = ACTIONS(374),
    [anon_sym_int192] = ACTIONS(374),
    [anon_sym_int200] = ACTIONS(374),
    [anon_sym_int208] = ACTIONS(374),
    [anon_sym_int216] = ACTIONS(374),
    [anon_sym_int224] = ACTIONS(374),
    [anon_sym_int232] = ACTIONS(374),
    [anon_sym_int240] = ACTIONS(374),
    [anon_sym_int248] = ACTIONS(374),
    [anon_sym_int256] = ACTIONS(374),
    [anon_sym_uint] = ACTIONS(374),
    [anon_sym_uint8] = ACTIONS(374),
    [anon_sym_uint16] = ACTIONS(374),
    [anon_sym_uint24] = ACTIONS(374),
    [anon_sym_uint32] = ACTIONS(374),
    [anon_sym_uint40] = ACTIONS(374),
    [anon_sym_uint48] = ACTIONS(374),
    [anon_sym_uint56] = ACTIONS(374),
    [anon_sym_uint64] = ACTIONS(374),
    [anon_sym_uint72] = ACTIONS(374),
    [anon_sym_uint80] = ACTIONS(374),
    [anon_sym_uint88] = ACTIONS(374),
    [anon_sym_uint96] = ACTIONS(374),
    [anon_sym_uint104] = ACTIONS(374),
    [anon_sym_uint112] = ACTIONS(374),
    [anon_sym_uint120] = ACTIONS(374),
    [anon_sym_uint128] = ACTIONS(374),
    [anon_sym_uint136] = ACTIONS(374),
    [anon_sym_uint144] = ACTIONS(374),
    [anon_sym_uint152] = ACTIONS(374),
    [anon_sym_uint160] = ACTIONS(374),
    [anon_sym_uint168] = ACTIONS(374),
    [anon_sym_uint176] = ACTIONS(374),
    [anon_sym_uint184] = ACTIONS(374),
    [anon_sym_uint192] = ACTIONS(374),
    [anon_sym_uint200] = ACTIONS(374),
    [anon_sym_uint208] = ACTIONS(374),
    [anon_sym_uint216] = ACTIONS(374),
    [anon_sym_uint224] = ACTIONS(374),
    [anon_sym_uint232] = ACTIONS(374),
    [anon_sym_uint240] = ACTIONS(374),
    [anon_sym_uint248] = ACTIONS(374),
    [anon_sym_uint256] = ACTIONS(374),
    [anon_sym_bytes] = ACTIONS(374),
    [anon_sym_bytes1] = ACTIONS(374),
    [anon_sym_bytes2] = ACTIONS(374),
    [anon_sym_bytes3] = ACTIONS(374),
    [anon_sym_bytes4] = ACTIONS(374),
    [anon_sym_bytes5] = ACTIONS(374),
    [anon_sym_bytes6] = ACTIONS(374),
    [anon_sym_bytes7] = ACTIONS(374),
    [anon_sym_bytes8] = ACTIONS(374),
    [anon_sym_bytes9] = ACTIONS(374),
    [anon_sym_bytes10] = ACTIONS(374),
    [anon_sym_bytes11] = ACTIONS(374),
    [anon_sym_bytes12] = ACTIONS(374),
    [anon_sym_bytes13] = ACTIONS(374),
    [anon_sym_bytes14] = ACTIONS(374),
    [anon_sym_bytes15] = ACTIONS(374),
    [anon_sym_bytes16] = ACTIONS(374),
    [anon_sym_bytes17] = ACTIONS(374),
    [anon_sym_bytes18] = ACTIONS(374),
    [anon_sym_bytes19] = ACTIONS(374),
    [anon_sym_bytes20] = ACTIONS(374),
    [anon_sym_bytes21] = ACTIONS(374),
    [anon_sym_bytes22] = ACTIONS(374),
    [anon_sym_bytes23] = ACTIONS(374),
    [anon_sym_bytes24] = ACTIONS(374),
    [anon_sym_bytes25] = ACTIONS(374),
    [anon_sym_bytes26] = ACTIONS(374),
    [anon_sym_bytes27] = ACTIONS(374),
    [anon_sym_bytes28] = ACTIONS(374),
    [anon_sym_bytes29] = ACTIONS(374),
    [anon_sym_bytes30] = ACTIONS(374),
    [anon_sym_bytes31] = ACTIONS(374),
    [anon_sym_bytes32] = ACTIONS(374),
    [anon_sym_fixed] = ACTIONS(374),
    [aux_sym__fixed_token1] = ACTIONS(374),
    [anon_sym_ufixed] = ACTIONS(374),
    [aux_sym__ufixed_token1] = ACTIONS(374),
    [sym__semicolon] = ACTIONS(376),
    [aux_sym__decimal_number_token1] = ACTIONS(374),
    [aux_sym__decimal_number_token2] = ACTIONS(376),
    [aux_sym__hex_number_token1] = ACTIONS(376),
    [anon_sym_hex] = ACTIONS(374),
    [anon_sym_DQUOTE] = ACTIONS(376),
    [anon_sym_SQUOTE] = ACTIONS(376),
    [anon_sym_unicode] = ACTIONS(374),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_identifier] = ACTIONS(378),
    [anon_sym_DASH] = ACTIONS(378),
    [anon_sym_TILDE] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_RBRACE] = ACTIONS(380),
    [anon_sym_type] = ACTIONS(378),
    [anon_sym_LPAREN] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(378),
    [anon_sym_assembly] = ACTIONS(378),
    [anon_sym_break] = ACTIONS(378),
    [anon_sym_continue] = ACTIONS(378),
    [anon_sym_true] = ACTIONS(378),
    [anon_sym_false] = ACTIONS(378),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_function] = ACTIONS(378),
    [anon_sym_byte] = ACTIONS(378),
    [anon_sym_address] = ACTIONS(378),
    [anon_sym_return] = ACTIONS(378),
    [anon_sym_revert] = ACTIONS(378),
    [sym__unchecked] = ACTIONS(378),
    [anon_sym_var] = ACTIONS(378),
    [anon_sym_else] = ACTIONS(378),
    [anon_sym_while] = ACTIONS(378),
    [anon_sym_do] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(378),
    [anon_sym_catch] = ACTIONS(378),
    [anon_sym_emit] = ACTIONS(378),
    [anon_sym_payable] = ACTIONS(378),
    [anon_sym_new] = ACTIONS(378),
    [anon_sym_LBRACK] = ACTIONS(380),
    [anon_sym_PLUS] = ACTIONS(378),
    [anon_sym_BANG] = ACTIONS(380),
    [anon_sym_delete] = ACTIONS(378),
    [anon_sym_PLUS_PLUS] = ACTIONS(380),
    [anon_sym_DASH_DASH] = ACTIONS(380),
    [anon_sym_mapping] = ACTIONS(378),
    [anon_sym_bool] = ACTIONS(378),
    [anon_sym_string] = ACTIONS(378),
    [anon_sym_int] = ACTIONS(378),
    [anon_sym_int8] = ACTIONS(378),
    [anon_sym_int16] = ACTIONS(378),
    [anon_sym_int24] = ACTIONS(378),
    [anon_sym_int32] = ACTIONS(378),
    [anon_sym_int40] = ACTIONS(378),
    [anon_sym_int48] = ACTIONS(378),
    [anon_sym_int56] = ACTIONS(378),
    [anon_sym_int64] = ACTIONS(378),
    [anon_sym_int72] = ACTIONS(378),
    [anon_sym_int80] = ACTIONS(378),
    [anon_sym_int88] = ACTIONS(378),
    [anon_sym_int96] = ACTIONS(378),
    [anon_sym_int104] = ACTIONS(378),
    [anon_sym_int112] = ACTIONS(378),
    [anon_sym_int120] = ACTIONS(378),
    [anon_sym_int128] = ACTIONS(378),
    [anon_sym_int136] = ACTIONS(378),
    [anon_sym_int144] = ACTIONS(378),
    [anon_sym_int152] = ACTIONS(378),
    [anon_sym_int160] = ACTIONS(378),
    [anon_sym_int168] = ACTIONS(378),
    [anon_sym_int176] = ACTIONS(378),
    [anon_sym_int184] = ACTIONS(378),
    [anon_sym_int192] = ACTIONS(378),
    [anon_sym_int200] = ACTIONS(378),
    [anon_sym_int208] = ACTIONS(378),
    [anon_sym_int216] = ACTIONS(378),
    [anon_sym_int224] = ACTIONS(378),
    [anon_sym_int232] = ACTIONS(378),
    [anon_sym_int240] = ACTIONS(378),
    [anon_sym_int248] = ACTIONS(378),
    [anon_sym_int256] = ACTIONS(378),
    [anon_sym_uint] = ACTIONS(378),
    [anon_sym_uint8] = ACTIONS(378),
    [anon_sym_uint16] = ACTIONS(378),
    [anon_sym_uint24] = ACTIONS(378),
    [anon_sym_uint32] = ACTIONS(378),
    [anon_sym_uint40] = ACTIONS(378),
    [anon_sym_uint48] = ACTIONS(378),
    [anon_sym_uint56] = ACTIONS(378),
    [anon_sym_uint64] = ACTIONS(378),
    [anon_sym_uint72] = ACTIONS(378),
    [anon_sym_uint80] = ACTIONS(378),
    [anon_sym_uint88] = ACTIONS(378),
    [anon_sym_uint96] = ACTIONS(378),
    [anon_sym_uint104] = ACTIONS(378),
    [anon_sym_uint112] = ACTIONS(378),
    [anon_sym_uint120] = ACTIONS(378),
    [anon_sym_uint128] = ACTIONS(378),
    [anon_sym_uint136] = ACTIONS(378),
    [anon_sym_uint144] = ACTIONS(378),
    [anon_sym_uint152] = ACTIONS(378),
    [anon_sym_uint160] = ACTIONS(378),
    [anon_sym_uint168] = ACTIONS(378),
    [anon_sym_uint176] = ACTIONS(378),
    [anon_sym_uint184] = ACTIONS(378),
    [anon_sym_uint192] = ACTIONS(378),
    [anon_sym_uint200] = ACTIONS(378),
    [anon_sym_uint208] = ACTIONS(378),
    [anon_sym_uint216] = ACTIONS(378),
    [anon_sym_uint224] = ACTIONS(378),
    [anon_sym_uint232] = ACTIONS(378),
    [anon_sym_uint240] = ACTIONS(378),
    [anon_sym_uint248] = ACTIONS(378),
    [anon_sym_uint256] = ACTIONS(378),
    [anon_sym_bytes] = ACTIONS(378),
    [anon_sym_bytes1] = ACTIONS(378),
    [anon_sym_bytes2] = ACTIONS(378),
    [anon_sym_bytes3] = ACTIONS(378),
    [anon_sym_bytes4] = ACTIONS(378),
    [anon_sym_bytes5] = ACTIONS(378),
    [anon_sym_bytes6] = ACTIONS(378),
    [anon_sym_bytes7] = ACTIONS(378),
    [anon_sym_bytes8] = ACTIONS(378),
    [anon_sym_bytes9] = ACTIONS(378),
    [anon_sym_bytes10] = ACTIONS(378),
    [anon_sym_bytes11] = ACTIONS(378),
    [anon_sym_bytes12] = ACTIONS(378),
    [anon_sym_bytes13] = ACTIONS(378),
    [anon_sym_bytes14] = ACTIONS(378),
    [anon_sym_bytes15] = ACTIONS(378),
    [anon_sym_bytes16] = ACTIONS(378),
    [anon_sym_bytes17] = ACTIONS(378),
    [anon_sym_bytes18] = ACTIONS(378),
    [anon_sym_bytes19] = ACTIONS(378),
    [anon_sym_bytes20] = ACTIONS(378),
    [anon_sym_bytes21] = ACTIONS(378),
    [anon_sym_bytes22] = ACTIONS(378),
    [anon_sym_bytes23] = ACTIONS(378),
    [anon_sym_bytes24] = ACTIONS(378),
    [anon_sym_bytes25] = ACTIONS(378),
    [anon_sym_bytes26] = ACTIONS(378),
    [anon_sym_bytes27] = ACTIONS(378),
    [anon_sym_bytes28] = ACTIONS(378),
    [anon_sym_bytes29] = ACTIONS(378),
    [anon_sym_bytes30] = ACTIONS(378),
    [anon_sym_bytes31] = ACTIONS(378),
    [anon_sym_bytes32] = ACTIONS(378),
    [anon_sym_fixed] = ACTIONS(378),
    [aux_sym__fixed_token1] = ACTIONS(378),
    [anon_sym_ufixed] = ACTIONS(378),
    [aux_sym__ufixed_token1] = ACTIONS(378),
    [aux_sym__decimal_number_token1] = ACTIONS(378),
    [aux_sym__decimal_number_token2] = ACTIONS(380),
    [aux_sym__hex_number_token1] = ACTIONS(380),
    [anon_sym_hex] = ACTIONS(378),
    [anon_sym_DQUOTE] = ACTIONS(380),
    [anon_sym_SQUOTE] = ACTIONS(380),
    [anon_sym_unicode] = ACTIONS(378),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_identifier] = ACTIONS(382),
    [anon_sym_DASH] = ACTIONS(382),
    [anon_sym_TILDE] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(384),
    [anon_sym_RBRACE] = ACTIONS(384),
    [anon_sym_type] = ACTIONS(382),
    [anon_sym_LPAREN] = ACTIONS(384),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_assembly] = ACTIONS(382),
    [anon_sym_break] = ACTIONS(382),
    [anon_sym_continue] = ACTIONS(382),
    [anon_sym_true] = ACTIONS(382),
    [anon_sym_false] = ACTIONS(382),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_byte] = ACTIONS(382),
    [anon_sym_address] = ACTIONS(382),
    [anon_sym_return] = ACTIONS(382),
    [anon_sym_revert] = ACTIONS(382),
    [sym__unchecked] = ACTIONS(382),
    [anon_sym_var] = ACTIONS(382),
    [anon_sym_else] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(382),
    [anon_sym_do] = ACTIONS(382),
    [anon_sym_try] = ACTIONS(382),
    [anon_sym_catch] = ACTIONS(382),
    [anon_sym_emit] = ACTIONS(382),
    [anon_sym_payable] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(382),
    [anon_sym_LBRACK] = ACTIONS(384),
    [anon_sym_PLUS] = ACTIONS(382),
    [anon_sym_BANG] = ACTIONS(384),
    [anon_sym_delete] = ACTIONS(382),
    [anon_sym_PLUS_PLUS] = ACTIONS(384),
    [anon_sym_DASH_DASH] = ACTIONS(384),
    [anon_sym_mapping] = ACTIONS(382),
    [anon_sym_bool] = ACTIONS(382),
    [anon_sym_string] = ACTIONS(382),
    [anon_sym_int] = ACTIONS(382),
    [anon_sym_int8] = ACTIONS(382),
    [anon_sym_int16] = ACTIONS(382),
    [anon_sym_int24] = ACTIONS(382),
    [anon_sym_int32] = ACTIONS(382),
    [anon_sym_int40] = ACTIONS(382),
    [anon_sym_int48] = ACTIONS(382),
    [anon_sym_int56] = ACTIONS(382),
    [anon_sym_int64] = ACTIONS(382),
    [anon_sym_int72] = ACTIONS(382),
    [anon_sym_int80] = ACTIONS(382),
    [anon_sym_int88] = ACTIONS(382),
    [anon_sym_int96] = ACTIONS(382),
    [anon_sym_int104] = ACTIONS(382),
    [anon_sym_int112] = ACTIONS(382),
    [anon_sym_int120] = ACTIONS(382),
    [anon_sym_int128] = ACTIONS(382),
    [anon_sym_int136] = ACTIONS(382),
    [anon_sym_int144] = ACTIONS(382),
    [anon_sym_int152] = ACTIONS(382),
    [anon_sym_int160] = ACTIONS(382),
    [anon_sym_int168] = ACTIONS(382),
    [anon_sym_int176] = ACTIONS(382),
    [anon_sym_int184] = ACTIONS(382),
    [anon_sym_int192] = ACTIONS(382),
    [anon_sym_int200] = ACTIONS(382),
    [anon_sym_int208] = ACTIONS(382),
    [anon_sym_int216] = ACTIONS(382),
    [anon_sym_int224] = ACTIONS(382),
    [anon_sym_int232] = ACTIONS(382),
    [anon_sym_int240] = ACTIONS(382),
    [anon_sym_int248] = ACTIONS(382),
    [anon_sym_int256] = ACTIONS(382),
    [anon_sym_uint] = ACTIONS(382),
    [anon_sym_uint8] = ACTIONS(382),
    [anon_sym_uint16] = ACTIONS(382),
    [anon_sym_uint24] = ACTIONS(382),
    [anon_sym_uint32] = ACTIONS(382),
    [anon_sym_uint40] = ACTIONS(382),
    [anon_sym_uint48] = ACTIONS(382),
    [anon_sym_uint56] = ACTIONS(382),
    [anon_sym_uint64] = ACTIONS(382),
    [anon_sym_uint72] = ACTIONS(382),
    [anon_sym_uint80] = ACTIONS(382),
    [anon_sym_uint88] = ACTIONS(382),
    [anon_sym_uint96] = ACTIONS(382),
    [anon_sym_uint104] = ACTIONS(382),
    [anon_sym_uint112] = ACTIONS(382),
    [anon_sym_uint120] = ACTIONS(382),
    [anon_sym_uint128] = ACTIONS(382),
    [anon_sym_uint136] = ACTIONS(382),
    [anon_sym_uint144] = ACTIONS(382),
    [anon_sym_uint152] = ACTIONS(382),
    [anon_sym_uint160] = ACTIONS(382),
    [anon_sym_uint168] = ACTIONS(382),
    [anon_sym_uint176] = ACTIONS(382),
    [anon_sym_uint184] = ACTIONS(382),
    [anon_sym_uint192] = ACTIONS(382),
    [anon_sym_uint200] = ACTIONS(382),
    [anon_sym_uint208] = ACTIONS(382),
    [anon_sym_uint216] = ACTIONS(382),
    [anon_sym_uint224] = ACTIONS(382),
    [anon_sym_uint232] = ACTIONS(382),
    [anon_sym_uint240] = ACTIONS(382),
    [anon_sym_uint248] = ACTIONS(382),
    [anon_sym_uint256] = ACTIONS(382),
    [anon_sym_bytes] = ACTIONS(382),
    [anon_sym_bytes1] = ACTIONS(382),
    [anon_sym_bytes2] = ACTIONS(382),
    [anon_sym_bytes3] = ACTIONS(382),
    [anon_sym_bytes4] = ACTIONS(382),
    [anon_sym_bytes5] = ACTIONS(382),
    [anon_sym_bytes6] = ACTIONS(382),
    [anon_sym_bytes7] = ACTIONS(382),
    [anon_sym_bytes8] = ACTIONS(382),
    [anon_sym_bytes9] = ACTIONS(382),
    [anon_sym_bytes10] = ACTIONS(382),
    [anon_sym_bytes11] = ACTIONS(382),
    [anon_sym_bytes12] = ACTIONS(382),
    [anon_sym_bytes13] = ACTIONS(382),
    [anon_sym_bytes14] = ACTIONS(382),
    [anon_sym_bytes15] = ACTIONS(382),
    [anon_sym_bytes16] = ACTIONS(382),
    [anon_sym_bytes17] = ACTIONS(382),
    [anon_sym_bytes18] = ACTIONS(382),
    [anon_sym_bytes19] = ACTIONS(382),
    [anon_sym_bytes20] = ACTIONS(382),
    [anon_sym_bytes21] = ACTIONS(382),
    [anon_sym_bytes22] = ACTIONS(382),
    [anon_sym_bytes23] = ACTIONS(382),
    [anon_sym_bytes24] = ACTIONS(382),
    [anon_sym_bytes25] = ACTIONS(382),
    [anon_sym_bytes26] = ACTIONS(382),
    [anon_sym_bytes27] = ACTIONS(382),
    [anon_sym_bytes28] = ACTIONS(382),
    [anon_sym_bytes29] = ACTIONS(382),
    [anon_sym_bytes30] = ACTIONS(382),
    [anon_sym_bytes31] = ACTIONS(382),
    [anon_sym_bytes32] = ACTIONS(382),
    [anon_sym_fixed] = ACTIONS(382),
    [aux_sym__fixed_token1] = ACTIONS(382),
    [anon_sym_ufixed] = ACTIONS(382),
    [aux_sym__ufixed_token1] = ACTIONS(382),
    [aux_sym__decimal_number_token1] = ACTIONS(382),
    [aux_sym__decimal_number_token2] = ACTIONS(384),
    [aux_sym__hex_number_token1] = ACTIONS(384),
    [anon_sym_hex] = ACTIONS(382),
    [anon_sym_DQUOTE] = ACTIONS(384),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_unicode] = ACTIONS(382),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_identifier] = ACTIONS(386),
    [anon_sym_DASH] = ACTIONS(386),
    [anon_sym_TILDE] = ACTIONS(388),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(388),
    [anon_sym_type] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(388),
    [anon_sym_for] = ACTIONS(386),
    [anon_sym_assembly] = ACTIONS(386),
    [anon_sym_break] = ACTIONS(386),
    [anon_sym_continue] = ACTIONS(386),
    [anon_sym_true] = ACTIONS(386),
    [anon_sym_false] = ACTIONS(386),
    [anon_sym_if] = ACTIONS(386),
    [anon_sym_function] = ACTIONS(386),
    [anon_sym_byte] = ACTIONS(386),
    [anon_sym_address] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(386),
    [anon_sym_revert] = ACTIONS(386),
    [sym__unchecked] = ACTIONS(386),
    [anon_sym_var] = ACTIONS(386),
    [anon_sym_else] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(386),
    [anon_sym_do] = ACTIONS(386),
    [anon_sym_try] = ACTIONS(386),
    [anon_sym_emit] = ACTIONS(386),
    [anon_sym_payable] = ACTIONS(386),
    [anon_sym_new] = ACTIONS(386),
    [anon_sym_LBRACK] = ACTIONS(388),
    [anon_sym_PLUS] = ACTIONS(386),
    [anon_sym_BANG] = ACTIONS(388),
    [anon_sym_delete] = ACTIONS(386),
    [anon_sym_PLUS_PLUS] = ACTIONS(388),
    [anon_sym_DASH_DASH] = ACTIONS(388),
    [anon_sym_mapping] = ACTIONS(386),
    [anon_sym_bool] = ACTIONS(386),
    [anon_sym_string] = ACTIONS(386),
    [anon_sym_int] = ACTIONS(386),
    [anon_sym_int8] = ACTIONS(386),
    [anon_sym_int16] = ACTIONS(386),
    [anon_sym_int24] = ACTIONS(386),
    [anon_sym_int32] = ACTIONS(386),
    [anon_sym_int40] = ACTIONS(386),
    [anon_sym_int48] = ACTIONS(386),
    [anon_sym_int56] = ACTIONS(386),
    [anon_sym_int64] = ACTIONS(386),
    [anon_sym_int72] = ACTIONS(386),
    [anon_sym_int80] = ACTIONS(386),
    [anon_sym_int88] = ACTIONS(386),
    [anon_sym_int96] = ACTIONS(386),
    [anon_sym_int104] = ACTIONS(386),
    [anon_sym_int112] = ACTIONS(386),
    [anon_sym_int120] = ACTIONS(386),
    [anon_sym_int128] = ACTIONS(386),
    [anon_sym_int136] = ACTIONS(386),
    [anon_sym_int144] = ACTIONS(386),
    [anon_sym_int152] = ACTIONS(386),
    [anon_sym_int160] = ACTIONS(386),
    [anon_sym_int168] = ACTIONS(386),
    [anon_sym_int176] = ACTIONS(386),
    [anon_sym_int184] = ACTIONS(386),
    [anon_sym_int192] = ACTIONS(386),
    [anon_sym_int200] = ACTIONS(386),
    [anon_sym_int208] = ACTIONS(386),
    [anon_sym_int216] = ACTIONS(386),
    [anon_sym_int224] = ACTIONS(386),
    [anon_sym_int232] = ACTIONS(386),
    [anon_sym_int240] = ACTIONS(386),
    [anon_sym_int248] = ACTIONS(386),
    [anon_sym_int256] = ACTIONS(386),
    [anon_sym_uint] = ACTIONS(386),
    [anon_sym_uint8] = ACTIONS(386),
    [anon_sym_uint16] = ACTIONS(386),
    [anon_sym_uint24] = ACTIONS(386),
    [anon_sym_uint32] = ACTIONS(386),
    [anon_sym_uint40] = ACTIONS(386),
    [anon_sym_uint48] = ACTIONS(386),
    [anon_sym_uint56] = ACTIONS(386),
    [anon_sym_uint64] = ACTIONS(386),
    [anon_sym_uint72] = ACTIONS(386),
    [anon_sym_uint80] = ACTIONS(386),
    [anon_sym_uint88] = ACTIONS(386),
    [anon_sym_uint96] = ACTIONS(386),
    [anon_sym_uint104] = ACTIONS(386),
    [anon_sym_uint112] = ACTIONS(386),
    [anon_sym_uint120] = ACTIONS(386),
    [anon_sym_uint128] = ACTIONS(386),
    [anon_sym_uint136] = ACTIONS(386),
    [anon_sym_uint144] = ACTIONS(386),
    [anon_sym_uint152] = ACTIONS(386),
    [anon_sym_uint160] = ACTIONS(386),
    [anon_sym_uint168] = ACTIONS(386),
    [anon_sym_uint176] = ACTIONS(386),
    [anon_sym_uint184] = ACTIONS(386),
    [anon_sym_uint192] = ACTIONS(386),
    [anon_sym_uint200] = ACTIONS(386),
    [anon_sym_uint208] = ACTIONS(386),
    [anon_sym_uint216] = ACTIONS(386),
    [anon_sym_uint224] = ACTIONS(386),
    [anon_sym_uint232] = ACTIONS(386),
    [anon_sym_uint240] = ACTIONS(386),
    [anon_sym_uint248] = ACTIONS(386),
    [anon_sym_uint256] = ACTIONS(386),
    [anon_sym_bytes] = ACTIONS(386),
    [anon_sym_bytes1] = ACTIONS(386),
    [anon_sym_bytes2] = ACTIONS(386),
    [anon_sym_bytes3] = ACTIONS(386),
    [anon_sym_bytes4] = ACTIONS(386),
    [anon_sym_bytes5] = ACTIONS(386),
    [anon_sym_bytes6] = ACTIONS(386),
    [anon_sym_bytes7] = ACTIONS(386),
    [anon_sym_bytes8] = ACTIONS(386),
    [anon_sym_bytes9] = ACTIONS(386),
    [anon_sym_bytes10] = ACTIONS(386),
    [anon_sym_bytes11] = ACTIONS(386),
    [anon_sym_bytes12] = ACTIONS(386),
    [anon_sym_bytes13] = ACTIONS(386),
    [anon_sym_bytes14] = ACTIONS(386),
    [anon_sym_bytes15] = ACTIONS(386),
    [anon_sym_bytes16] = ACTIONS(386),
    [anon_sym_bytes17] = ACTIONS(386),
    [anon_sym_bytes18] = ACTIONS(386),
    [anon_sym_bytes19] = ACTIONS(386),
    [anon_sym_bytes20] = ACTIONS(386),
    [anon_sym_bytes21] = ACTIONS(386),
    [anon_sym_bytes22] = ACTIONS(386),
    [anon_sym_bytes23] = ACTIONS(386),
    [anon_sym_bytes24] = ACTIONS(386),
    [anon_sym_bytes25] = ACTIONS(386),
    [anon_sym_bytes26] = ACTIONS(386),
    [anon_sym_bytes27] = ACTIONS(386),
    [anon_sym_bytes28] = ACTIONS(386),
    [anon_sym_bytes29] = ACTIONS(386),
    [anon_sym_bytes30] = ACTIONS(386),
    [anon_sym_bytes31] = ACTIONS(386),
    [anon_sym_bytes32] = ACTIONS(386),
    [anon_sym_fixed] = ACTIONS(386),
    [aux_sym__fixed_token1] = ACTIONS(386),
    [anon_sym_ufixed] = ACTIONS(386),
    [aux_sym__ufixed_token1] = ACTIONS(386),
    [sym__semicolon] = ACTIONS(388),
    [aux_sym__decimal_number_token1] = ACTIONS(386),
    [aux_sym__decimal_number_token2] = ACTIONS(388),
    [aux_sym__hex_number_token1] = ACTIONS(388),
    [anon_sym_hex] = ACTIONS(386),
    [anon_sym_DQUOTE] = ACTIONS(388),
    [anon_sym_SQUOTE] = ACTIONS(388),
    [anon_sym_unicode] = ACTIONS(386),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_identifier] = ACTIONS(390),
    [anon_sym_DASH] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_LBRACE] = ACTIONS(392),
    [anon_sym_RBRACE] = ACTIONS(392),
    [anon_sym_type] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(390),
    [anon_sym_assembly] = ACTIONS(390),
    [anon_sym_break] = ACTIONS(390),
    [anon_sym_continue] = ACTIONS(390),
    [anon_sym_true] = ACTIONS(390),
    [anon_sym_false] = ACTIONS(390),
    [anon_sym_if] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_byte] = ACTIONS(390),
    [anon_sym_address] = ACTIONS(390),
    [anon_sym_return] = ACTIONS(390),
    [anon_sym_revert] = ACTIONS(390),
    [sym__unchecked] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(390),
    [anon_sym_else] = ACTIONS(390),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_try] = ACTIONS(390),
    [anon_sym_catch] = ACTIONS(390),
    [anon_sym_emit] = ACTIONS(390),
    [anon_sym_payable] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(390),
    [anon_sym_LBRACK] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(390),
    [anon_sym_BANG] = ACTIONS(392),
    [anon_sym_delete] = ACTIONS(390),
    [anon_sym_PLUS_PLUS] = ACTIONS(392),
    [anon_sym_DASH_DASH] = ACTIONS(392),
    [anon_sym_mapping] = ACTIONS(390),
    [anon_sym_bool] = ACTIONS(390),
    [anon_sym_string] = ACTIONS(390),
    [anon_sym_int] = ACTIONS(390),
    [anon_sym_int8] = ACTIONS(390),
    [anon_sym_int16] = ACTIONS(390),
    [anon_sym_int24] = ACTIONS(390),
    [anon_sym_int32] = ACTIONS(390),
    [anon_sym_int40] = ACTIONS(390),
    [anon_sym_int48] = ACTIONS(390),
    [anon_sym_int56] = ACTIONS(390),
    [anon_sym_int64] = ACTIONS(390),
    [anon_sym_int72] = ACTIONS(390),
    [anon_sym_int80] = ACTIONS(390),
    [anon_sym_int88] = ACTIONS(390),
    [anon_sym_int96] = ACTIONS(390),
    [anon_sym_int104] = ACTIONS(390),
    [anon_sym_int112] = ACTIONS(390),
    [anon_sym_int120] = ACTIONS(390),
    [anon_sym_int128] = ACTIONS(390),
    [anon_sym_int136] = ACTIONS(390),
    [anon_sym_int144] = ACTIONS(390),
    [anon_sym_int152] = ACTIONS(390),
    [anon_sym_int160] = ACTIONS(390),
    [anon_sym_int168] = ACTIONS(390),
    [anon_sym_int176] = ACTIONS(390),
    [anon_sym_int184] = ACTIONS(390),
    [anon_sym_int192] = ACTIONS(390),
    [anon_sym_int200] = ACTIONS(390),
    [anon_sym_int208] = ACTIONS(390),
    [anon_sym_int216] = ACTIONS(390),
    [anon_sym_int224] = ACTIONS(390),
    [anon_sym_int232] = ACTIONS(390),
    [anon_sym_int240] = ACTIONS(390),
    [anon_sym_int248] = ACTIONS(390),
    [anon_sym_int256] = ACTIONS(390),
    [anon_sym_uint] = ACTIONS(390),
    [anon_sym_uint8] = ACTIONS(390),
    [anon_sym_uint16] = ACTIONS(390),
    [anon_sym_uint24] = ACTIONS(390),
    [anon_sym_uint32] = ACTIONS(390),
    [anon_sym_uint40] = ACTIONS(390),
    [anon_sym_uint48] = ACTIONS(390),
    [anon_sym_uint56] = ACTIONS(390),
    [anon_sym_uint64] = ACTIONS(390),
    [anon_sym_uint72] = ACTIONS(390),
    [anon_sym_uint80] = ACTIONS(390),
    [anon_sym_uint88] = ACTIONS(390),
    [anon_sym_uint96] = ACTIONS(390),
    [anon_sym_uint104] = ACTIONS(390),
    [anon_sym_uint112] = ACTIONS(390),
    [anon_sym_uint120] = ACTIONS(390),
    [anon_sym_uint128] = ACTIONS(390),
    [anon_sym_uint136] = ACTIONS(390),
    [anon_sym_uint144] = ACTIONS(390),
    [anon_sym_uint152] = ACTIONS(390),
    [anon_sym_uint160] = ACTIONS(390),
    [anon_sym_uint168] = ACTIONS(390),
    [anon_sym_uint176] = ACTIONS(390),
    [anon_sym_uint184] = ACTIONS(390),
    [anon_sym_uint192] = ACTIONS(390),
    [anon_sym_uint200] = ACTIONS(390),
    [anon_sym_uint208] = ACTIONS(390),
    [anon_sym_uint216] = ACTIONS(390),
    [anon_sym_uint224] = ACTIONS(390),
    [anon_sym_uint232] = ACTIONS(390),
    [anon_sym_uint240] = ACTIONS(390),
    [anon_sym_uint248] = ACTIONS(390),
    [anon_sym_uint256] = ACTIONS(390),
    [anon_sym_bytes] = ACTIONS(390),
    [anon_sym_bytes1] = ACTIONS(390),
    [anon_sym_bytes2] = ACTIONS(390),
    [anon_sym_bytes3] = ACTIONS(390),
    [anon_sym_bytes4] = ACTIONS(390),
    [anon_sym_bytes5] = ACTIONS(390),
    [anon_sym_bytes6] = ACTIONS(390),
    [anon_sym_bytes7] = ACTIONS(390),
    [anon_sym_bytes8] = ACTIONS(390),
    [anon_sym_bytes9] = ACTIONS(390),
    [anon_sym_bytes10] = ACTIONS(390),
    [anon_sym_bytes11] = ACTIONS(390),
    [anon_sym_bytes12] = ACTIONS(390),
    [anon_sym_bytes13] = ACTIONS(390),
    [anon_sym_bytes14] = ACTIONS(390),
    [anon_sym_bytes15] = ACTIONS(390),
    [anon_sym_bytes16] = ACTIONS(390),
    [anon_sym_bytes17] = ACTIONS(390),
    [anon_sym_bytes18] = ACTIONS(390),
    [anon_sym_bytes19] = ACTIONS(390),
    [anon_sym_bytes20] = ACTIONS(390),
    [anon_sym_bytes21] = ACTIONS(390),
    [anon_sym_bytes22] = ACTIONS(390),
    [anon_sym_bytes23] = ACTIONS(390),
    [anon_sym_bytes24] = ACTIONS(390),
    [anon_sym_bytes25] = ACTIONS(390),
    [anon_sym_bytes26] = ACTIONS(390),
    [anon_sym_bytes27] = ACTIONS(390),
    [anon_sym_bytes28] = ACTIONS(390),
    [anon_sym_bytes29] = ACTIONS(390),
    [anon_sym_bytes30] = ACTIONS(390),
    [anon_sym_bytes31] = ACTIONS(390),
    [anon_sym_bytes32] = ACTIONS(390),
    [anon_sym_fixed] = ACTIONS(390),
    [aux_sym__fixed_token1] = ACTIONS(390),
    [anon_sym_ufixed] = ACTIONS(390),
    [aux_sym__ufixed_token1] = ACTIONS(390),
    [aux_sym__decimal_number_token1] = ACTIONS(390),
    [aux_sym__decimal_number_token2] = ACTIONS(392),
    [aux_sym__hex_number_token1] = ACTIONS(392),
    [anon_sym_hex] = ACTIONS(390),
    [anon_sym_DQUOTE] = ACTIONS(392),
    [anon_sym_SQUOTE] = ACTIONS(392),
    [anon_sym_unicode] = ACTIONS(390),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_identifier] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(396),
    [anon_sym_LBRACE] = ACTIONS(396),
    [anon_sym_RBRACE] = ACTIONS(396),
    [anon_sym_type] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_assembly] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(394),
    [anon_sym_continue] = ACTIONS(394),
    [anon_sym_true] = ACTIONS(394),
    [anon_sym_false] = ACTIONS(394),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(394),
    [anon_sym_byte] = ACTIONS(394),
    [anon_sym_address] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_revert] = ACTIONS(394),
    [sym__unchecked] = ACTIONS(394),
    [anon_sym_var] = ACTIONS(394),
    [anon_sym_else] = ACTIONS(394),
    [anon_sym_while] = ACTIONS(394),
    [anon_sym_do] = ACTIONS(394),
    [anon_sym_try] = ACTIONS(394),
    [anon_sym_emit] = ACTIONS(394),
    [anon_sym_payable] = ACTIONS(394),
    [anon_sym_new] = ACTIONS(394),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(396),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(396),
    [anon_sym_DASH_DASH] = ACTIONS(396),
    [anon_sym_mapping] = ACTIONS(394),
    [anon_sym_bool] = ACTIONS(394),
    [anon_sym_string] = ACTIONS(394),
    [anon_sym_int] = ACTIONS(394),
    [anon_sym_int8] = ACTIONS(394),
    [anon_sym_int16] = ACTIONS(394),
    [anon_sym_int24] = ACTIONS(394),
    [anon_sym_int32] = ACTIONS(394),
    [anon_sym_int40] = ACTIONS(394),
    [anon_sym_int48] = ACTIONS(394),
    [anon_sym_int56] = ACTIONS(394),
    [anon_sym_int64] = ACTIONS(394),
    [anon_sym_int72] = ACTIONS(394),
    [anon_sym_int80] = ACTIONS(394),
    [anon_sym_int88] = ACTIONS(394),
    [anon_sym_int96] = ACTIONS(394),
    [anon_sym_int104] = ACTIONS(394),
    [anon_sym_int112] = ACTIONS(394),
    [anon_sym_int120] = ACTIONS(394),
    [anon_sym_int128] = ACTIONS(394),
    [anon_sym_int136] = ACTIONS(394),
    [anon_sym_int144] = ACTIONS(394),
    [anon_sym_int152] = ACTIONS(394),
    [anon_sym_int160] = ACTIONS(394),
    [anon_sym_int168] = ACTIONS(394),
    [anon_sym_int176] = ACTIONS(394),
    [anon_sym_int184] = ACTIONS(394),
    [anon_sym_int192] = ACTIONS(394),
    [anon_sym_int200] = ACTIONS(394),
    [anon_sym_int208] = ACTIONS(394),
    [anon_sym_int216] = ACTIONS(394),
    [anon_sym_int224] = ACTIONS(394),
    [anon_sym_int232] = ACTIONS(394),
    [anon_sym_int240] = ACTIONS(394),
    [anon_sym_int248] = ACTIONS(394),
    [anon_sym_int256] = ACTIONS(394),
    [anon_sym_uint] = ACTIONS(394),
    [anon_sym_uint8] = ACTIONS(394),
    [anon_sym_uint16] = ACTIONS(394),
    [anon_sym_uint24] = ACTIONS(394),
    [anon_sym_uint32] = ACTIONS(394),
    [anon_sym_uint40] = ACTIONS(394),
    [anon_sym_uint48] = ACTIONS(394),
    [anon_sym_uint56] = ACTIONS(394),
    [anon_sym_uint64] = ACTIONS(394),
    [anon_sym_uint72] = ACTIONS(394),
    [anon_sym_uint80] = ACTIONS(394),
    [anon_sym_uint88] = ACTIONS(394),
    [anon_sym_uint96] = ACTIONS(394),
    [anon_sym_uint104] = ACTIONS(394),
    [anon_sym_uint112] = ACTIONS(394),
    [anon_sym_uint120] = ACTIONS(394),
    [anon_sym_uint128] = ACTIONS(394),
    [anon_sym_uint136] = ACTIONS(394),
    [anon_sym_uint144] = ACTIONS(394),
    [anon_sym_uint152] = ACTIONS(394),
    [anon_sym_uint160] = ACTIONS(394),
    [anon_sym_uint168] = ACTIONS(394),
    [anon_sym_uint176] = ACTIONS(394),
    [anon_sym_uint184] = ACTIONS(394),
    [anon_sym_uint192] = ACTIONS(394),
    [anon_sym_uint200] = ACTIONS(394),
    [anon_sym_uint208] = ACTIONS(394),
    [anon_sym_uint216] = ACTIONS(394),
    [anon_sym_uint224] = ACTIONS(394),
    [anon_sym_uint232] = ACTIONS(394),
    [anon_sym_uint240] = ACTIONS(394),
    [anon_sym_uint248] = ACTIONS(394),
    [anon_sym_uint256] = ACTIONS(394),
    [anon_sym_bytes] = ACTIONS(394),
    [anon_sym_bytes1] = ACTIONS(394),
    [anon_sym_bytes2] = ACTIONS(394),
    [anon_sym_bytes3] = ACTIONS(394),
    [anon_sym_bytes4] = ACTIONS(394),
    [anon_sym_bytes5] = ACTIONS(394),
    [anon_sym_bytes6] = ACTIONS(394),
    [anon_sym_bytes7] = ACTIONS(394),
    [anon_sym_bytes8] = ACTIONS(394),
    [anon_sym_bytes9] = ACTIONS(394),
    [anon_sym_bytes10] = ACTIONS(394),
    [anon_sym_bytes11] = ACTIONS(394),
    [anon_sym_bytes12] = ACTIONS(394),
    [anon_sym_bytes13] = ACTIONS(394),
    [anon_sym_bytes14] = ACTIONS(394),
    [anon_sym_bytes15] = ACTIONS(394),
    [anon_sym_bytes16] = ACTIONS(394),
    [anon_sym_bytes17] = ACTIONS(394),
    [anon_sym_bytes18] = ACTIONS(394),
    [anon_sym_bytes19] = ACTIONS(394),
    [anon_sym_bytes20] = ACTIONS(394),
    [anon_sym_bytes21] = ACTIONS(394),
    [anon_sym_bytes22] = ACTIONS(394),
    [anon_sym_bytes23] = ACTIONS(394),
    [anon_sym_bytes24] = ACTIONS(394),
    [anon_sym_bytes25] = ACTIONS(394),
    [anon_sym_bytes26] = ACTIONS(394),
    [anon_sym_bytes27] = ACTIONS(394),
    [anon_sym_bytes28] = ACTIONS(394),
    [anon_sym_bytes29] = ACTIONS(394),
    [anon_sym_bytes30] = ACTIONS(394),
    [anon_sym_bytes31] = ACTIONS(394),
    [anon_sym_bytes32] = ACTIONS(394),
    [anon_sym_fixed] = ACTIONS(394),
    [aux_sym__fixed_token1] = ACTIONS(394),
    [anon_sym_ufixed] = ACTIONS(394),
    [aux_sym__ufixed_token1] = ACTIONS(394),
    [aux_sym__decimal_number_token1] = ACTIONS(394),
    [aux_sym__decimal_number_token2] = ACTIONS(396),
    [aux_sym__hex_number_token1] = ACTIONS(396),
    [anon_sym_hex] = ACTIONS(394),
    [anon_sym_DQUOTE] = ACTIONS(396),
    [anon_sym_SQUOTE] = ACTIONS(396),
    [anon_sym_unicode] = ACTIONS(394),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_identifier] = ACTIONS(398),
    [anon_sym_DASH] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(400),
    [anon_sym_RBRACE] = ACTIONS(400),
    [anon_sym_type] = ACTIONS(398),
    [anon_sym_LPAREN] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(398),
    [anon_sym_assembly] = ACTIONS(398),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_true] = ACTIONS(398),
    [anon_sym_false] = ACTIONS(398),
    [anon_sym_if] = ACTIONS(398),
    [anon_sym_function] = ACTIONS(398),
    [anon_sym_byte] = ACTIONS(398),
    [anon_sym_address] = ACTIONS(398),
    [anon_sym_return] = ACTIONS(398),
    [anon_sym_revert] = ACTIONS(398),
    [sym__unchecked] = ACTIONS(398),
    [anon_sym_var] = ACTIONS(398),
    [anon_sym_else] = ACTIONS(398),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_do] = ACTIONS(398),
    [anon_sym_try] = ACTIONS(398),
    [anon_sym_emit] = ACTIONS(398),
    [anon_sym_payable] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(398),
    [anon_sym_LBRACK] = ACTIONS(400),
    [anon_sym_PLUS] = ACTIONS(398),
    [anon_sym_BANG] = ACTIONS(400),
    [anon_sym_delete] = ACTIONS(398),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [anon_sym_mapping] = ACTIONS(398),
    [anon_sym_bool] = ACTIONS(398),
    [anon_sym_string] = ACTIONS(398),
    [anon_sym_int] = ACTIONS(398),
    [anon_sym_int8] = ACTIONS(398),
    [anon_sym_int16] = ACTIONS(398),
    [anon_sym_int24] = ACTIONS(398),
    [anon_sym_int32] = ACTIONS(398),
    [anon_sym_int40] = ACTIONS(398),
    [anon_sym_int48] = ACTIONS(398),
    [anon_sym_int56] = ACTIONS(398),
    [anon_sym_int64] = ACTIONS(398),
    [anon_sym_int72] = ACTIONS(398),
    [anon_sym_int80] = ACTIONS(398),
    [anon_sym_int88] = ACTIONS(398),
    [anon_sym_int96] = ACTIONS(398),
    [anon_sym_int104] = ACTIONS(398),
    [anon_sym_int112] = ACTIONS(398),
    [anon_sym_int120] = ACTIONS(398),
    [anon_sym_int128] = ACTIONS(398),
    [anon_sym_int136] = ACTIONS(398),
    [anon_sym_int144] = ACTIONS(398),
    [anon_sym_int152] = ACTIONS(398),
    [anon_sym_int160] = ACTIONS(398),
    [anon_sym_int168] = ACTIONS(398),
    [anon_sym_int176] = ACTIONS(398),
    [anon_sym_int184] = ACTIONS(398),
    [anon_sym_int192] = ACTIONS(398),
    [anon_sym_int200] = ACTIONS(398),
    [anon_sym_int208] = ACTIONS(398),
    [anon_sym_int216] = ACTIONS(398),
    [anon_sym_int224] = ACTIONS(398),
    [anon_sym_int232] = ACTIONS(398),
    [anon_sym_int240] = ACTIONS(398),
    [anon_sym_int248] = ACTIONS(398),
    [anon_sym_int256] = ACTIONS(398),
    [anon_sym_uint] = ACTIONS(398),
    [anon_sym_uint8] = ACTIONS(398),
    [anon_sym_uint16] = ACTIONS(398),
    [anon_sym_uint24] = ACTIONS(398),
    [anon_sym_uint32] = ACTIONS(398),
    [anon_sym_uint40] = ACTIONS(398),
    [anon_sym_uint48] = ACTIONS(398),
    [anon_sym_uint56] = ACTIONS(398),
    [anon_sym_uint64] = ACTIONS(398),
    [anon_sym_uint72] = ACTIONS(398),
    [anon_sym_uint80] = ACTIONS(398),
    [anon_sym_uint88] = ACTIONS(398),
    [anon_sym_uint96] = ACTIONS(398),
    [anon_sym_uint104] = ACTIONS(398),
    [anon_sym_uint112] = ACTIONS(398),
    [anon_sym_uint120] = ACTIONS(398),
    [anon_sym_uint128] = ACTIONS(398),
    [anon_sym_uint136] = ACTIONS(398),
    [anon_sym_uint144] = ACTIONS(398),
    [anon_sym_uint152] = ACTIONS(398),
    [anon_sym_uint160] = ACTIONS(398),
    [anon_sym_uint168] = ACTIONS(398),
    [anon_sym_uint176] = ACTIONS(398),
    [anon_sym_uint184] = ACTIONS(398),
    [anon_sym_uint192] = ACTIONS(398),
    [anon_sym_uint200] = ACTIONS(398),
    [anon_sym_uint208] = ACTIONS(398),
    [anon_sym_uint216] = ACTIONS(398),
    [anon_sym_uint224] = ACTIONS(398),
    [anon_sym_uint232] = ACTIONS(398),
    [anon_sym_uint240] = ACTIONS(398),
    [anon_sym_uint248] = ACTIONS(398),
    [anon_sym_uint256] = ACTIONS(398),
    [anon_sym_bytes] = ACTIONS(398),
    [anon_sym_bytes1] = ACTIONS(398),
    [anon_sym_bytes2] = ACTIONS(398),
    [anon_sym_bytes3] = ACTIONS(398),
    [anon_sym_bytes4] = ACTIONS(398),
    [anon_sym_bytes5] = ACTIONS(398),
    [anon_sym_bytes6] = ACTIONS(398),
    [anon_sym_bytes7] = ACTIONS(398),
    [anon_sym_bytes8] = ACTIONS(398),
    [anon_sym_bytes9] = ACTIONS(398),
    [anon_sym_bytes10] = ACTIONS(398),
    [anon_sym_bytes11] = ACTIONS(398),
    [anon_sym_bytes12] = ACTIONS(398),
    [anon_sym_bytes13] = ACTIONS(398),
    [anon_sym_bytes14] = ACTIONS(398),
    [anon_sym_bytes15] = ACTIONS(398),
    [anon_sym_bytes16] = ACTIONS(398),
    [anon_sym_bytes17] = ACTIONS(398),
    [anon_sym_bytes18] = ACTIONS(398),
    [anon_sym_bytes19] = ACTIONS(398),
    [anon_sym_bytes20] = ACTIONS(398),
    [anon_sym_bytes21] = ACTIONS(398),
    [anon_sym_bytes22] = ACTIONS(398),
    [anon_sym_bytes23] = ACTIONS(398),
    [anon_sym_bytes24] = ACTIONS(398),
    [anon_sym_bytes25] = ACTIONS(398),
    [anon_sym_bytes26] = ACTIONS(398),
    [anon_sym_bytes27] = ACTIONS(398),
    [anon_sym_bytes28] = ACTIONS(398),
    [anon_sym_bytes29] = ACTIONS(398),
    [anon_sym_bytes30] = ACTIONS(398),
    [anon_sym_bytes31] = ACTIONS(398),
    [anon_sym_bytes32] = ACTIONS(398),
    [anon_sym_fixed] = ACTIONS(398),
    [aux_sym__fixed_token1] = ACTIONS(398),
    [anon_sym_ufixed] = ACTIONS(398),
    [aux_sym__ufixed_token1] = ACTIONS(398),
    [aux_sym__decimal_number_token1] = ACTIONS(398),
    [aux_sym__decimal_number_token2] = ACTIONS(400),
    [aux_sym__hex_number_token1] = ACTIONS(400),
    [anon_sym_hex] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(400),
    [anon_sym_unicode] = ACTIONS(398),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_identifier] = ACTIONS(402),
    [anon_sym_DASH] = ACTIONS(402),
    [anon_sym_TILDE] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(404),
    [anon_sym_RBRACE] = ACTIONS(404),
    [anon_sym_type] = ACTIONS(402),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_assembly] = ACTIONS(402),
    [anon_sym_break] = ACTIONS(402),
    [anon_sym_continue] = ACTIONS(402),
    [anon_sym_true] = ACTIONS(402),
    [anon_sym_false] = ACTIONS(402),
    [anon_sym_if] = ACTIONS(402),
    [anon_sym_function] = ACTIONS(402),
    [anon_sym_byte] = ACTIONS(402),
    [anon_sym_address] = ACTIONS(402),
    [anon_sym_return] = ACTIONS(402),
    [anon_sym_revert] = ACTIONS(402),
    [sym__unchecked] = ACTIONS(402),
    [anon_sym_var] = ACTIONS(402),
    [anon_sym_else] = ACTIONS(402),
    [anon_sym_while] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(402),
    [anon_sym_try] = ACTIONS(402),
    [anon_sym_emit] = ACTIONS(402),
    [anon_sym_payable] = ACTIONS(402),
    [anon_sym_new] = ACTIONS(402),
    [anon_sym_LBRACK] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(402),
    [anon_sym_BANG] = ACTIONS(404),
    [anon_sym_delete] = ACTIONS(402),
    [anon_sym_PLUS_PLUS] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(404),
    [anon_sym_mapping] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_string] = ACTIONS(402),
    [anon_sym_int] = ACTIONS(402),
    [anon_sym_int8] = ACTIONS(402),
    [anon_sym_int16] = ACTIONS(402),
    [anon_sym_int24] = ACTIONS(402),
    [anon_sym_int32] = ACTIONS(402),
    [anon_sym_int40] = ACTIONS(402),
    [anon_sym_int48] = ACTIONS(402),
    [anon_sym_int56] = ACTIONS(402),
    [anon_sym_int64] = ACTIONS(402),
    [anon_sym_int72] = ACTIONS(402),
    [anon_sym_int80] = ACTIONS(402),
    [anon_sym_int88] = ACTIONS(402),
    [anon_sym_int96] = ACTIONS(402),
    [anon_sym_int104] = ACTIONS(402),
    [anon_sym_int112] = ACTIONS(402),
    [anon_sym_int120] = ACTIONS(402),
    [anon_sym_int128] = ACTIONS(402),
    [anon_sym_int136] = ACTIONS(402),
    [anon_sym_int144] = ACTIONS(402),
    [anon_sym_int152] = ACTIONS(402),
    [anon_sym_int160] = ACTIONS(402),
    [anon_sym_int168] = ACTIONS(402),
    [anon_sym_int176] = ACTIONS(402),
    [anon_sym_int184] = ACTIONS(402),
    [anon_sym_int192] = ACTIONS(402),
    [anon_sym_int200] = ACTIONS(402),
    [anon_sym_int208] = ACTIONS(402),
    [anon_sym_int216] = ACTIONS(402),
    [anon_sym_int224] = ACTIONS(402),
    [anon_sym_int232] = ACTIONS(402),
    [anon_sym_int240] = ACTIONS(402),
    [anon_sym_int248] = ACTIONS(402),
    [anon_sym_int256] = ACTIONS(402),
    [anon_sym_uint] = ACTIONS(402),
    [anon_sym_uint8] = ACTIONS(402),
    [anon_sym_uint16] = ACTIONS(402),
    [anon_sym_uint24] = ACTIONS(402),
    [anon_sym_uint32] = ACTIONS(402),
    [anon_sym_uint40] = ACTIONS(402),
    [anon_sym_uint48] = ACTIONS(402),
    [anon_sym_uint56] = ACTIONS(402),
    [anon_sym_uint64] = ACTIONS(402),
    [anon_sym_uint72] = ACTIONS(402),
    [anon_sym_uint80] = ACTIONS(402),
    [anon_sym_uint88] = ACTIONS(402),
    [anon_sym_uint96] = ACTIONS(402),
    [anon_sym_uint104] = ACTIONS(402),
    [anon_sym_uint112] = ACTIONS(402),
    [anon_sym_uint120] = ACTIONS(402),
    [anon_sym_uint128] = ACTIONS(402),
    [anon_sym_uint136] = ACTIONS(402),
    [anon_sym_uint144] = ACTIONS(402),
    [anon_sym_uint152] = ACTIONS(402),
    [anon_sym_uint160] = ACTIONS(402),
    [anon_sym_uint168] = ACTIONS(402),
    [anon_sym_uint176] = ACTIONS(402),
    [anon_sym_uint184] = ACTIONS(402),
    [anon_sym_uint192] = ACTIONS(402),
    [anon_sym_uint200] = ACTIONS(402),
    [anon_sym_uint208] = ACTIONS(402),
    [anon_sym_uint216] = ACTIONS(402),
    [anon_sym_uint224] = ACTIONS(402),
    [anon_sym_uint232] = ACTIONS(402),
    [anon_sym_uint240] = ACTIONS(402),
    [anon_sym_uint248] = ACTIONS(402),
    [anon_sym_uint256] = ACTIONS(402),
    [anon_sym_bytes] = ACTIONS(402),
    [anon_sym_bytes1] = ACTIONS(402),
    [anon_sym_bytes2] = ACTIONS(402),
    [anon_sym_bytes3] = ACTIONS(402),
    [anon_sym_bytes4] = ACTIONS(402),
    [anon_sym_bytes5] = ACTIONS(402),
    [anon_sym_bytes6] = ACTIONS(402),
    [anon_sym_bytes7] = ACTIONS(402),
    [anon_sym_bytes8] = ACTIONS(402),
    [anon_sym_bytes9] = ACTIONS(402),
    [anon_sym_bytes10] = ACTIONS(402),
    [anon_sym_bytes11] = ACTIONS(402),
    [anon_sym_bytes12] = ACTIONS(402),
    [anon_sym_bytes13] = ACTIONS(402),
    [anon_sym_bytes14] = ACTIONS(402),
    [anon_sym_bytes15] = ACTIONS(402),
    [anon_sym_bytes16] = ACTIONS(402),
    [anon_sym_bytes17] = ACTIONS(402),
    [anon_sym_bytes18] = ACTIONS(402),
    [anon_sym_bytes19] = ACTIONS(402),
    [anon_sym_bytes20] = ACTIONS(402),
    [anon_sym_bytes21] = ACTIONS(402),
    [anon_sym_bytes22] = ACTIONS(402),
    [anon_sym_bytes23] = ACTIONS(402),
    [anon_sym_bytes24] = ACTIONS(402),
    [anon_sym_bytes25] = ACTIONS(402),
    [anon_sym_bytes26] = ACTIONS(402),
    [anon_sym_bytes27] = ACTIONS(402),
    [anon_sym_bytes28] = ACTIONS(402),
    [anon_sym_bytes29] = ACTIONS(402),
    [anon_sym_bytes30] = ACTIONS(402),
    [anon_sym_bytes31] = ACTIONS(402),
    [anon_sym_bytes32] = ACTIONS(402),
    [anon_sym_fixed] = ACTIONS(402),
    [aux_sym__fixed_token1] = ACTIONS(402),
    [anon_sym_ufixed] = ACTIONS(402),
    [aux_sym__ufixed_token1] = ACTIONS(402),
    [aux_sym__decimal_number_token1] = ACTIONS(402),
    [aux_sym__decimal_number_token2] = ACTIONS(404),
    [aux_sym__hex_number_token1] = ACTIONS(404),
    [anon_sym_hex] = ACTIONS(402),
    [anon_sym_DQUOTE] = ACTIONS(404),
    [anon_sym_SQUOTE] = ACTIONS(404),
    [anon_sym_unicode] = ACTIONS(402),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_identifier] = ACTIONS(406),
    [anon_sym_DASH] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
    [anon_sym_LBRACE] = ACTIONS(408),
    [anon_sym_RBRACE] = ACTIONS(408),
    [anon_sym_type] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(408),
    [anon_sym_for] = ACTIONS(406),
    [anon_sym_assembly] = ACTIONS(406),
    [anon_sym_break] = ACTIONS(406),
    [anon_sym_continue] = ACTIONS(406),
    [anon_sym_true] = ACTIONS(406),
    [anon_sym_false] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_function] = ACTIONS(406),
    [anon_sym_byte] = ACTIONS(406),
    [anon_sym_address] = ACTIONS(406),
    [anon_sym_return] = ACTIONS(406),
    [anon_sym_revert] = ACTIONS(406),
    [sym__unchecked] = ACTIONS(406),
    [anon_sym_var] = ACTIONS(406),
    [anon_sym_else] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(406),
    [anon_sym_do] = ACTIONS(406),
    [anon_sym_try] = ACTIONS(406),
    [anon_sym_emit] = ACTIONS(406),
    [anon_sym_payable] = ACTIONS(406),
    [anon_sym_new] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(408),
    [anon_sym_PLUS] = ACTIONS(406),
    [anon_sym_BANG] = ACTIONS(408),
    [anon_sym_delete] = ACTIONS(406),
    [anon_sym_PLUS_PLUS] = ACTIONS(408),
    [anon_sym_DASH_DASH] = ACTIONS(408),
    [anon_sym_mapping] = ACTIONS(406),
    [anon_sym_bool] = ACTIONS(406),
    [anon_sym_string] = ACTIONS(406),
    [anon_sym_int] = ACTIONS(406),
    [anon_sym_int8] = ACTIONS(406),
    [anon_sym_int16] = ACTIONS(406),
    [anon_sym_int24] = ACTIONS(406),
    [anon_sym_int32] = ACTIONS(406),
    [anon_sym_int40] = ACTIONS(406),
    [anon_sym_int48] = ACTIONS(406),
    [anon_sym_int56] = ACTIONS(406),
    [anon_sym_int64] = ACTIONS(406),
    [anon_sym_int72] = ACTIONS(406),
    [anon_sym_int80] = ACTIONS(406),
    [anon_sym_int88] = ACTIONS(406),
    [anon_sym_int96] = ACTIONS(406),
    [anon_sym_int104] = ACTIONS(406),
    [anon_sym_int112] = ACTIONS(406),
    [anon_sym_int120] = ACTIONS(406),
    [anon_sym_int128] = ACTIONS(406),
    [anon_sym_int136] = ACTIONS(406),
    [anon_sym_int144] = ACTIONS(406),
    [anon_sym_int152] = ACTIONS(406),
    [anon_sym_int160] = ACTIONS(406),
    [anon_sym_int168] = ACTIONS(406),
    [anon_sym_int176] = ACTIONS(406),
    [anon_sym_int184] = ACTIONS(406),
    [anon_sym_int192] = ACTIONS(406),
    [anon_sym_int200] = ACTIONS(406),
    [anon_sym_int208] = ACTIONS(406),
    [anon_sym_int216] = ACTIONS(406),
    [anon_sym_int224] = ACTIONS(406),
    [anon_sym_int232] = ACTIONS(406),
    [anon_sym_int240] = ACTIONS(406),
    [anon_sym_int248] = ACTIONS(406),
    [anon_sym_int256] = ACTIONS(406),
    [anon_sym_uint] = ACTIONS(406),
    [anon_sym_uint8] = ACTIONS(406),
    [anon_sym_uint16] = ACTIONS(406),
    [anon_sym_uint24] = ACTIONS(406),
    [anon_sym_uint32] = ACTIONS(406),
    [anon_sym_uint40] = ACTIONS(406),
    [anon_sym_uint48] = ACTIONS(406),
    [anon_sym_uint56] = ACTIONS(406),
    [anon_sym_uint64] = ACTIONS(406),
    [anon_sym_uint72] = ACTIONS(406),
    [anon_sym_uint80] = ACTIONS(406),
    [anon_sym_uint88] = ACTIONS(406),
    [anon_sym_uint96] = ACTIONS(406),
    [anon_sym_uint104] = ACTIONS(406),
    [anon_sym_uint112] = ACTIONS(406),
    [anon_sym_uint120] = ACTIONS(406),
    [anon_sym_uint128] = ACTIONS(406),
    [anon_sym_uint136] = ACTIONS(406),
    [anon_sym_uint144] = ACTIONS(406),
    [anon_sym_uint152] = ACTIONS(406),
    [anon_sym_uint160] = ACTIONS(406),
    [anon_sym_uint168] = ACTIONS(406),
    [anon_sym_uint176] = ACTIONS(406),
    [anon_sym_uint184] = ACTIONS(406),
    [anon_sym_uint192] = ACTIONS(406),
    [anon_sym_uint200] = ACTIONS(406),
    [anon_sym_uint208] = ACTIONS(406),
    [anon_sym_uint216] = ACTIONS(406),
    [anon_sym_uint224] = ACTIONS(406),
    [anon_sym_uint232] = ACTIONS(406),
    [anon_sym_uint240] = ACTIONS(406),
    [anon_sym_uint248] = ACTIONS(406),
    [anon_sym_uint256] = ACTIONS(406),
    [anon_sym_bytes] = ACTIONS(406),
    [anon_sym_bytes1] = ACTIONS(406),
    [anon_sym_bytes2] = ACTIONS(406),
    [anon_sym_bytes3] = ACTIONS(406),
    [anon_sym_bytes4] = ACTIONS(406),
    [anon_sym_bytes5] = ACTIONS(406),
    [anon_sym_bytes6] = ACTIONS(406),
    [anon_sym_bytes7] = ACTIONS(406),
    [anon_sym_bytes8] = ACTIONS(406),
    [anon_sym_bytes9] = ACTIONS(406),
    [anon_sym_bytes10] = ACTIONS(406),
    [anon_sym_bytes11] = ACTIONS(406),
    [anon_sym_bytes12] = ACTIONS(406),
    [anon_sym_bytes13] = ACTIONS(406),
    [anon_sym_bytes14] = ACTIONS(406),
    [anon_sym_bytes15] = ACTIONS(406),
    [anon_sym_bytes16] = ACTIONS(406),
    [anon_sym_bytes17] = ACTIONS(406),
    [anon_sym_bytes18] = ACTIONS(406),
    [anon_sym_bytes19] = ACTIONS(406),
    [anon_sym_bytes20] = ACTIONS(406),
    [anon_sym_bytes21] = ACTIONS(406),
    [anon_sym_bytes22] = ACTIONS(406),
    [anon_sym_bytes23] = ACTIONS(406),
    [anon_sym_bytes24] = ACTIONS(406),
    [anon_sym_bytes25] = ACTIONS(406),
    [anon_sym_bytes26] = ACTIONS(406),
    [anon_sym_bytes27] = ACTIONS(406),
    [anon_sym_bytes28] = ACTIONS(406),
    [anon_sym_bytes29] = ACTIONS(406),
    [anon_sym_bytes30] = ACTIONS(406),
    [anon_sym_bytes31] = ACTIONS(406),
    [anon_sym_bytes32] = ACTIONS(406),
    [anon_sym_fixed] = ACTIONS(406),
    [aux_sym__fixed_token1] = ACTIONS(406),
    [anon_sym_ufixed] = ACTIONS(406),
    [aux_sym__ufixed_token1] = ACTIONS(406),
    [aux_sym__decimal_number_token1] = ACTIONS(406),
    [aux_sym__decimal_number_token2] = ACTIONS(408),
    [aux_sym__hex_number_token1] = ACTIONS(408),
    [anon_sym_hex] = ACTIONS(406),
    [anon_sym_DQUOTE] = ACTIONS(408),
    [anon_sym_SQUOTE] = ACTIONS(408),
    [anon_sym_unicode] = ACTIONS(406),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_user_defined_type_definition] = STATE(91),
    [sym_error_declaration] = STATE(91),
    [sym__contract_member] = STATE(91),
    [sym_struct_declaration] = STATE(91),
    [sym_enum_declaration] = STATE(91),
    [sym_event_definition] = STATE(91),
    [sym_using_directive] = STATE(91),
    [sym_state_variable_declaration] = STATE(91),
    [sym_modifier_definition] = STATE(91),
    [sym_constructor_definition] = STATE(91),
    [sym_fallback_receive_definition] = STATE(91),
    [sym_function_definition] = STATE(91),
    [sym_type_name] = STATE(448),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_contract_body_repeat1] = STATE(91),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(410),
    [anon_sym_type] = ACTIONS(412),
    [anon_sym_error] = ACTIONS(414),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(418),
    [anon_sym_event] = ACTIONS(420),
    [anon_sym_using] = ACTIONS(422),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_modifier] = ACTIONS(426),
    [anon_sym_constructor] = ACTIONS(428),
    [anon_sym_fallback] = ACTIONS(430),
    [anon_sym_receive] = ACTIONS(430),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_identifier] = ACTIONS(432),
    [anon_sym_DASH] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(434),
    [anon_sym_RBRACE] = ACTIONS(434),
    [anon_sym_type] = ACTIONS(432),
    [anon_sym_LPAREN] = ACTIONS(434),
    [anon_sym_for] = ACTIONS(432),
    [anon_sym_assembly] = ACTIONS(432),
    [anon_sym_break] = ACTIONS(432),
    [anon_sym_continue] = ACTIONS(432),
    [anon_sym_true] = ACTIONS(432),
    [anon_sym_false] = ACTIONS(432),
    [anon_sym_if] = ACTIONS(432),
    [anon_sym_function] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(432),
    [anon_sym_address] = ACTIONS(432),
    [anon_sym_return] = ACTIONS(432),
    [anon_sym_revert] = ACTIONS(432),
    [sym__unchecked] = ACTIONS(432),
    [anon_sym_var] = ACTIONS(432),
    [anon_sym_else] = ACTIONS(432),
    [anon_sym_while] = ACTIONS(432),
    [anon_sym_do] = ACTIONS(432),
    [anon_sym_try] = ACTIONS(432),
    [anon_sym_emit] = ACTIONS(432),
    [anon_sym_payable] = ACTIONS(432),
    [anon_sym_new] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_PLUS] = ACTIONS(432),
    [anon_sym_BANG] = ACTIONS(434),
    [anon_sym_delete] = ACTIONS(432),
    [anon_sym_PLUS_PLUS] = ACTIONS(434),
    [anon_sym_DASH_DASH] = ACTIONS(434),
    [anon_sym_mapping] = ACTIONS(432),
    [anon_sym_bool] = ACTIONS(432),
    [anon_sym_string] = ACTIONS(432),
    [anon_sym_int] = ACTIONS(432),
    [anon_sym_int8] = ACTIONS(432),
    [anon_sym_int16] = ACTIONS(432),
    [anon_sym_int24] = ACTIONS(432),
    [anon_sym_int32] = ACTIONS(432),
    [anon_sym_int40] = ACTIONS(432),
    [anon_sym_int48] = ACTIONS(432),
    [anon_sym_int56] = ACTIONS(432),
    [anon_sym_int64] = ACTIONS(432),
    [anon_sym_int72] = ACTIONS(432),
    [anon_sym_int80] = ACTIONS(432),
    [anon_sym_int88] = ACTIONS(432),
    [anon_sym_int96] = ACTIONS(432),
    [anon_sym_int104] = ACTIONS(432),
    [anon_sym_int112] = ACTIONS(432),
    [anon_sym_int120] = ACTIONS(432),
    [anon_sym_int128] = ACTIONS(432),
    [anon_sym_int136] = ACTIONS(432),
    [anon_sym_int144] = ACTIONS(432),
    [anon_sym_int152] = ACTIONS(432),
    [anon_sym_int160] = ACTIONS(432),
    [anon_sym_int168] = ACTIONS(432),
    [anon_sym_int176] = ACTIONS(432),
    [anon_sym_int184] = ACTIONS(432),
    [anon_sym_int192] = ACTIONS(432),
    [anon_sym_int200] = ACTIONS(432),
    [anon_sym_int208] = ACTIONS(432),
    [anon_sym_int216] = ACTIONS(432),
    [anon_sym_int224] = ACTIONS(432),
    [anon_sym_int232] = ACTIONS(432),
    [anon_sym_int240] = ACTIONS(432),
    [anon_sym_int248] = ACTIONS(432),
    [anon_sym_int256] = ACTIONS(432),
    [anon_sym_uint] = ACTIONS(432),
    [anon_sym_uint8] = ACTIONS(432),
    [anon_sym_uint16] = ACTIONS(432),
    [anon_sym_uint24] = ACTIONS(432),
    [anon_sym_uint32] = ACTIONS(432),
    [anon_sym_uint40] = ACTIONS(432),
    [anon_sym_uint48] = ACTIONS(432),
    [anon_sym_uint56] = ACTIONS(432),
    [anon_sym_uint64] = ACTIONS(432),
    [anon_sym_uint72] = ACTIONS(432),
    [anon_sym_uint80] = ACTIONS(432),
    [anon_sym_uint88] = ACTIONS(432),
    [anon_sym_uint96] = ACTIONS(432),
    [anon_sym_uint104] = ACTIONS(432),
    [anon_sym_uint112] = ACTIONS(432),
    [anon_sym_uint120] = ACTIONS(432),
    [anon_sym_uint128] = ACTIONS(432),
    [anon_sym_uint136] = ACTIONS(432),
    [anon_sym_uint144] = ACTIONS(432),
    [anon_sym_uint152] = ACTIONS(432),
    [anon_sym_uint160] = ACTIONS(432),
    [anon_sym_uint168] = ACTIONS(432),
    [anon_sym_uint176] = ACTIONS(432),
    [anon_sym_uint184] = ACTIONS(432),
    [anon_sym_uint192] = ACTIONS(432),
    [anon_sym_uint200] = ACTIONS(432),
    [anon_sym_uint208] = ACTIONS(432),
    [anon_sym_uint216] = ACTIONS(432),
    [anon_sym_uint224] = ACTIONS(432),
    [anon_sym_uint232] = ACTIONS(432),
    [anon_sym_uint240] = ACTIONS(432),
    [anon_sym_uint248] = ACTIONS(432),
    [anon_sym_uint256] = ACTIONS(432),
    [anon_sym_bytes] = ACTIONS(432),
    [anon_sym_bytes1] = ACTIONS(432),
    [anon_sym_bytes2] = ACTIONS(432),
    [anon_sym_bytes3] = ACTIONS(432),
    [anon_sym_bytes4] = ACTIONS(432),
    [anon_sym_bytes5] = ACTIONS(432),
    [anon_sym_bytes6] = ACTIONS(432),
    [anon_sym_bytes7] = ACTIONS(432),
    [anon_sym_bytes8] = ACTIONS(432),
    [anon_sym_bytes9] = ACTIONS(432),
    [anon_sym_bytes10] = ACTIONS(432),
    [anon_sym_bytes11] = ACTIONS(432),
    [anon_sym_bytes12] = ACTIONS(432),
    [anon_sym_bytes13] = ACTIONS(432),
    [anon_sym_bytes14] = ACTIONS(432),
    [anon_sym_bytes15] = ACTIONS(432),
    [anon_sym_bytes16] = ACTIONS(432),
    [anon_sym_bytes17] = ACTIONS(432),
    [anon_sym_bytes18] = ACTIONS(432),
    [anon_sym_bytes19] = ACTIONS(432),
    [anon_sym_bytes20] = ACTIONS(432),
    [anon_sym_bytes21] = ACTIONS(432),
    [anon_sym_bytes22] = ACTIONS(432),
    [anon_sym_bytes23] = ACTIONS(432),
    [anon_sym_bytes24] = ACTIONS(432),
    [anon_sym_bytes25] = ACTIONS(432),
    [anon_sym_bytes26] = ACTIONS(432),
    [anon_sym_bytes27] = ACTIONS(432),
    [anon_sym_bytes28] = ACTIONS(432),
    [anon_sym_bytes29] = ACTIONS(432),
    [anon_sym_bytes30] = ACTIONS(432),
    [anon_sym_bytes31] = ACTIONS(432),
    [anon_sym_bytes32] = ACTIONS(432),
    [anon_sym_fixed] = ACTIONS(432),
    [aux_sym__fixed_token1] = ACTIONS(432),
    [anon_sym_ufixed] = ACTIONS(432),
    [aux_sym__ufixed_token1] = ACTIONS(432),
    [aux_sym__decimal_number_token1] = ACTIONS(432),
    [aux_sym__decimal_number_token2] = ACTIONS(434),
    [aux_sym__hex_number_token1] = ACTIONS(434),
    [anon_sym_hex] = ACTIONS(432),
    [anon_sym_DQUOTE] = ACTIONS(434),
    [anon_sym_SQUOTE] = ACTIONS(434),
    [anon_sym_unicode] = ACTIONS(432),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_identifier] = ACTIONS(436),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_LBRACE] = ACTIONS(438),
    [anon_sym_RBRACE] = ACTIONS(438),
    [anon_sym_type] = ACTIONS(436),
    [anon_sym_LPAREN] = ACTIONS(438),
    [anon_sym_for] = ACTIONS(436),
    [anon_sym_assembly] = ACTIONS(436),
    [anon_sym_break] = ACTIONS(436),
    [anon_sym_continue] = ACTIONS(436),
    [anon_sym_true] = ACTIONS(436),
    [anon_sym_false] = ACTIONS(436),
    [anon_sym_if] = ACTIONS(436),
    [anon_sym_function] = ACTIONS(436),
    [anon_sym_byte] = ACTIONS(436),
    [anon_sym_address] = ACTIONS(436),
    [anon_sym_return] = ACTIONS(436),
    [anon_sym_revert] = ACTIONS(436),
    [sym__unchecked] = ACTIONS(436),
    [anon_sym_var] = ACTIONS(436),
    [anon_sym_else] = ACTIONS(436),
    [anon_sym_while] = ACTIONS(436),
    [anon_sym_do] = ACTIONS(436),
    [anon_sym_try] = ACTIONS(436),
    [anon_sym_emit] = ACTIONS(436),
    [anon_sym_payable] = ACTIONS(436),
    [anon_sym_new] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(438),
    [anon_sym_PLUS] = ACTIONS(436),
    [anon_sym_BANG] = ACTIONS(438),
    [anon_sym_delete] = ACTIONS(436),
    [anon_sym_PLUS_PLUS] = ACTIONS(438),
    [anon_sym_DASH_DASH] = ACTIONS(438),
    [anon_sym_mapping] = ACTIONS(436),
    [anon_sym_bool] = ACTIONS(436),
    [anon_sym_string] = ACTIONS(436),
    [anon_sym_int] = ACTIONS(436),
    [anon_sym_int8] = ACTIONS(436),
    [anon_sym_int16] = ACTIONS(436),
    [anon_sym_int24] = ACTIONS(436),
    [anon_sym_int32] = ACTIONS(436),
    [anon_sym_int40] = ACTIONS(436),
    [anon_sym_int48] = ACTIONS(436),
    [anon_sym_int56] = ACTIONS(436),
    [anon_sym_int64] = ACTIONS(436),
    [anon_sym_int72] = ACTIONS(436),
    [anon_sym_int80] = ACTIONS(436),
    [anon_sym_int88] = ACTIONS(436),
    [anon_sym_int96] = ACTIONS(436),
    [anon_sym_int104] = ACTIONS(436),
    [anon_sym_int112] = ACTIONS(436),
    [anon_sym_int120] = ACTIONS(436),
    [anon_sym_int128] = ACTIONS(436),
    [anon_sym_int136] = ACTIONS(436),
    [anon_sym_int144] = ACTIONS(436),
    [anon_sym_int152] = ACTIONS(436),
    [anon_sym_int160] = ACTIONS(436),
    [anon_sym_int168] = ACTIONS(436),
    [anon_sym_int176] = ACTIONS(436),
    [anon_sym_int184] = ACTIONS(436),
    [anon_sym_int192] = ACTIONS(436),
    [anon_sym_int200] = ACTIONS(436),
    [anon_sym_int208] = ACTIONS(436),
    [anon_sym_int216] = ACTIONS(436),
    [anon_sym_int224] = ACTIONS(436),
    [anon_sym_int232] = ACTIONS(436),
    [anon_sym_int240] = ACTIONS(436),
    [anon_sym_int248] = ACTIONS(436),
    [anon_sym_int256] = ACTIONS(436),
    [anon_sym_uint] = ACTIONS(436),
    [anon_sym_uint8] = ACTIONS(436),
    [anon_sym_uint16] = ACTIONS(436),
    [anon_sym_uint24] = ACTIONS(436),
    [anon_sym_uint32] = ACTIONS(436),
    [anon_sym_uint40] = ACTIONS(436),
    [anon_sym_uint48] = ACTIONS(436),
    [anon_sym_uint56] = ACTIONS(436),
    [anon_sym_uint64] = ACTIONS(436),
    [anon_sym_uint72] = ACTIONS(436),
    [anon_sym_uint80] = ACTIONS(436),
    [anon_sym_uint88] = ACTIONS(436),
    [anon_sym_uint96] = ACTIONS(436),
    [anon_sym_uint104] = ACTIONS(436),
    [anon_sym_uint112] = ACTIONS(436),
    [anon_sym_uint120] = ACTIONS(436),
    [anon_sym_uint128] = ACTIONS(436),
    [anon_sym_uint136] = ACTIONS(436),
    [anon_sym_uint144] = ACTIONS(436),
    [anon_sym_uint152] = ACTIONS(436),
    [anon_sym_uint160] = ACTIONS(436),
    [anon_sym_uint168] = ACTIONS(436),
    [anon_sym_uint176] = ACTIONS(436),
    [anon_sym_uint184] = ACTIONS(436),
    [anon_sym_uint192] = ACTIONS(436),
    [anon_sym_uint200] = ACTIONS(436),
    [anon_sym_uint208] = ACTIONS(436),
    [anon_sym_uint216] = ACTIONS(436),
    [anon_sym_uint224] = ACTIONS(436),
    [anon_sym_uint232] = ACTIONS(436),
    [anon_sym_uint240] = ACTIONS(436),
    [anon_sym_uint248] = ACTIONS(436),
    [anon_sym_uint256] = ACTIONS(436),
    [anon_sym_bytes] = ACTIONS(436),
    [anon_sym_bytes1] = ACTIONS(436),
    [anon_sym_bytes2] = ACTIONS(436),
    [anon_sym_bytes3] = ACTIONS(436),
    [anon_sym_bytes4] = ACTIONS(436),
    [anon_sym_bytes5] = ACTIONS(436),
    [anon_sym_bytes6] = ACTIONS(436),
    [anon_sym_bytes7] = ACTIONS(436),
    [anon_sym_bytes8] = ACTIONS(436),
    [anon_sym_bytes9] = ACTIONS(436),
    [anon_sym_bytes10] = ACTIONS(436),
    [anon_sym_bytes11] = ACTIONS(436),
    [anon_sym_bytes12] = ACTIONS(436),
    [anon_sym_bytes13] = ACTIONS(436),
    [anon_sym_bytes14] = ACTIONS(436),
    [anon_sym_bytes15] = ACTIONS(436),
    [anon_sym_bytes16] = ACTIONS(436),
    [anon_sym_bytes17] = ACTIONS(436),
    [anon_sym_bytes18] = ACTIONS(436),
    [anon_sym_bytes19] = ACTIONS(436),
    [anon_sym_bytes20] = ACTIONS(436),
    [anon_sym_bytes21] = ACTIONS(436),
    [anon_sym_bytes22] = ACTIONS(436),
    [anon_sym_bytes23] = ACTIONS(436),
    [anon_sym_bytes24] = ACTIONS(436),
    [anon_sym_bytes25] = ACTIONS(436),
    [anon_sym_bytes26] = ACTIONS(436),
    [anon_sym_bytes27] = ACTIONS(436),
    [anon_sym_bytes28] = ACTIONS(436),
    [anon_sym_bytes29] = ACTIONS(436),
    [anon_sym_bytes30] = ACTIONS(436),
    [anon_sym_bytes31] = ACTIONS(436),
    [anon_sym_bytes32] = ACTIONS(436),
    [anon_sym_fixed] = ACTIONS(436),
    [aux_sym__fixed_token1] = ACTIONS(436),
    [anon_sym_ufixed] = ACTIONS(436),
    [aux_sym__ufixed_token1] = ACTIONS(436),
    [aux_sym__decimal_number_token1] = ACTIONS(436),
    [aux_sym__decimal_number_token2] = ACTIONS(438),
    [aux_sym__hex_number_token1] = ACTIONS(438),
    [anon_sym_hex] = ACTIONS(436),
    [anon_sym_DQUOTE] = ACTIONS(438),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_unicode] = ACTIONS(436),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_user_defined_type_definition] = STATE(87),
    [sym_error_declaration] = STATE(87),
    [sym__contract_member] = STATE(87),
    [sym_struct_declaration] = STATE(87),
    [sym_enum_declaration] = STATE(87),
    [sym_event_definition] = STATE(87),
    [sym_using_directive] = STATE(87),
    [sym_state_variable_declaration] = STATE(87),
    [sym_modifier_definition] = STATE(87),
    [sym_constructor_definition] = STATE(87),
    [sym_fallback_receive_definition] = STATE(87),
    [sym_function_definition] = STATE(87),
    [sym_type_name] = STATE(448),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_contract_body_repeat1] = STATE(87),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(440),
    [anon_sym_type] = ACTIONS(412),
    [anon_sym_error] = ACTIONS(414),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(418),
    [anon_sym_event] = ACTIONS(420),
    [anon_sym_using] = ACTIONS(422),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_modifier] = ACTIONS(426),
    [anon_sym_constructor] = ACTIONS(428),
    [anon_sym_fallback] = ACTIONS(430),
    [anon_sym_receive] = ACTIONS(430),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_user_defined_type_definition] = STATE(91),
    [sym_error_declaration] = STATE(91),
    [sym__contract_member] = STATE(91),
    [sym_struct_declaration] = STATE(91),
    [sym_enum_declaration] = STATE(91),
    [sym_event_definition] = STATE(91),
    [sym_using_directive] = STATE(91),
    [sym_state_variable_declaration] = STATE(91),
    [sym_modifier_definition] = STATE(91),
    [sym_constructor_definition] = STATE(91),
    [sym_fallback_receive_definition] = STATE(91),
    [sym_function_definition] = STATE(91),
    [sym_type_name] = STATE(448),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_contract_body_repeat1] = STATE(91),
    [sym_identifier] = ACTIONS(442),
    [anon_sym_RBRACE] = ACTIONS(445),
    [anon_sym_type] = ACTIONS(447),
    [anon_sym_error] = ACTIONS(450),
    [anon_sym_struct] = ACTIONS(453),
    [anon_sym_enum] = ACTIONS(456),
    [anon_sym_event] = ACTIONS(459),
    [anon_sym_using] = ACTIONS(462),
    [anon_sym_function] = ACTIONS(465),
    [anon_sym_byte] = ACTIONS(468),
    [anon_sym_address] = ACTIONS(471),
    [anon_sym_var] = ACTIONS(468),
    [anon_sym_modifier] = ACTIONS(474),
    [anon_sym_constructor] = ACTIONS(477),
    [anon_sym_fallback] = ACTIONS(480),
    [anon_sym_receive] = ACTIONS(480),
    [anon_sym_mapping] = ACTIONS(483),
    [anon_sym_bool] = ACTIONS(468),
    [anon_sym_string] = ACTIONS(468),
    [anon_sym_int] = ACTIONS(468),
    [anon_sym_int8] = ACTIONS(468),
    [anon_sym_int16] = ACTIONS(468),
    [anon_sym_int24] = ACTIONS(468),
    [anon_sym_int32] = ACTIONS(468),
    [anon_sym_int40] = ACTIONS(468),
    [anon_sym_int48] = ACTIONS(468),
    [anon_sym_int56] = ACTIONS(468),
    [anon_sym_int64] = ACTIONS(468),
    [anon_sym_int72] = ACTIONS(468),
    [anon_sym_int80] = ACTIONS(468),
    [anon_sym_int88] = ACTIONS(468),
    [anon_sym_int96] = ACTIONS(468),
    [anon_sym_int104] = ACTIONS(468),
    [anon_sym_int112] = ACTIONS(468),
    [anon_sym_int120] = ACTIONS(468),
    [anon_sym_int128] = ACTIONS(468),
    [anon_sym_int136] = ACTIONS(468),
    [anon_sym_int144] = ACTIONS(468),
    [anon_sym_int152] = ACTIONS(468),
    [anon_sym_int160] = ACTIONS(468),
    [anon_sym_int168] = ACTIONS(468),
    [anon_sym_int176] = ACTIONS(468),
    [anon_sym_int184] = ACTIONS(468),
    [anon_sym_int192] = ACTIONS(468),
    [anon_sym_int200] = ACTIONS(468),
    [anon_sym_int208] = ACTIONS(468),
    [anon_sym_int216] = ACTIONS(468),
    [anon_sym_int224] = ACTIONS(468),
    [anon_sym_int232] = ACTIONS(468),
    [anon_sym_int240] = ACTIONS(468),
    [anon_sym_int248] = ACTIONS(468),
    [anon_sym_int256] = ACTIONS(468),
    [anon_sym_uint] = ACTIONS(468),
    [anon_sym_uint8] = ACTIONS(468),
    [anon_sym_uint16] = ACTIONS(468),
    [anon_sym_uint24] = ACTIONS(468),
    [anon_sym_uint32] = ACTIONS(468),
    [anon_sym_uint40] = ACTIONS(468),
    [anon_sym_uint48] = ACTIONS(468),
    [anon_sym_uint56] = ACTIONS(468),
    [anon_sym_uint64] = ACTIONS(468),
    [anon_sym_uint72] = ACTIONS(468),
    [anon_sym_uint80] = ACTIONS(468),
    [anon_sym_uint88] = ACTIONS(468),
    [anon_sym_uint96] = ACTIONS(468),
    [anon_sym_uint104] = ACTIONS(468),
    [anon_sym_uint112] = ACTIONS(468),
    [anon_sym_uint120] = ACTIONS(468),
    [anon_sym_uint128] = ACTIONS(468),
    [anon_sym_uint136] = ACTIONS(468),
    [anon_sym_uint144] = ACTIONS(468),
    [anon_sym_uint152] = ACTIONS(468),
    [anon_sym_uint160] = ACTIONS(468),
    [anon_sym_uint168] = ACTIONS(468),
    [anon_sym_uint176] = ACTIONS(468),
    [anon_sym_uint184] = ACTIONS(468),
    [anon_sym_uint192] = ACTIONS(468),
    [anon_sym_uint200] = ACTIONS(468),
    [anon_sym_uint208] = ACTIONS(468),
    [anon_sym_uint216] = ACTIONS(468),
    [anon_sym_uint224] = ACTIONS(468),
    [anon_sym_uint232] = ACTIONS(468),
    [anon_sym_uint240] = ACTIONS(468),
    [anon_sym_uint248] = ACTIONS(468),
    [anon_sym_uint256] = ACTIONS(468),
    [anon_sym_bytes] = ACTIONS(468),
    [anon_sym_bytes1] = ACTIONS(468),
    [anon_sym_bytes2] = ACTIONS(468),
    [anon_sym_bytes3] = ACTIONS(468),
    [anon_sym_bytes4] = ACTIONS(468),
    [anon_sym_bytes5] = ACTIONS(468),
    [anon_sym_bytes6] = ACTIONS(468),
    [anon_sym_bytes7] = ACTIONS(468),
    [anon_sym_bytes8] = ACTIONS(468),
    [anon_sym_bytes9] = ACTIONS(468),
    [anon_sym_bytes10] = ACTIONS(468),
    [anon_sym_bytes11] = ACTIONS(468),
    [anon_sym_bytes12] = ACTIONS(468),
    [anon_sym_bytes13] = ACTIONS(468),
    [anon_sym_bytes14] = ACTIONS(468),
    [anon_sym_bytes15] = ACTIONS(468),
    [anon_sym_bytes16] = ACTIONS(468),
    [anon_sym_bytes17] = ACTIONS(468),
    [anon_sym_bytes18] = ACTIONS(468),
    [anon_sym_bytes19] = ACTIONS(468),
    [anon_sym_bytes20] = ACTIONS(468),
    [anon_sym_bytes21] = ACTIONS(468),
    [anon_sym_bytes22] = ACTIONS(468),
    [anon_sym_bytes23] = ACTIONS(468),
    [anon_sym_bytes24] = ACTIONS(468),
    [anon_sym_bytes25] = ACTIONS(468),
    [anon_sym_bytes26] = ACTIONS(468),
    [anon_sym_bytes27] = ACTIONS(468),
    [anon_sym_bytes28] = ACTIONS(468),
    [anon_sym_bytes29] = ACTIONS(468),
    [anon_sym_bytes30] = ACTIONS(468),
    [anon_sym_bytes31] = ACTIONS(468),
    [anon_sym_bytes32] = ACTIONS(468),
    [anon_sym_fixed] = ACTIONS(468),
    [aux_sym__fixed_token1] = ACTIONS(468),
    [anon_sym_ufixed] = ACTIONS(468),
    [aux_sym__ufixed_token1] = ACTIONS(468),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_identifier] = ACTIONS(486),
    [anon_sym_DASH] = ACTIONS(486),
    [anon_sym_TILDE] = ACTIONS(488),
    [anon_sym_LBRACE] = ACTIONS(488),
    [anon_sym_RBRACE] = ACTIONS(488),
    [anon_sym_type] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(488),
    [anon_sym_for] = ACTIONS(486),
    [anon_sym_assembly] = ACTIONS(486),
    [anon_sym_break] = ACTIONS(486),
    [anon_sym_continue] = ACTIONS(486),
    [anon_sym_true] = ACTIONS(486),
    [anon_sym_false] = ACTIONS(486),
    [anon_sym_if] = ACTIONS(486),
    [anon_sym_function] = ACTIONS(486),
    [anon_sym_byte] = ACTIONS(486),
    [anon_sym_address] = ACTIONS(486),
    [anon_sym_return] = ACTIONS(486),
    [anon_sym_revert] = ACTIONS(486),
    [sym__unchecked] = ACTIONS(486),
    [anon_sym_var] = ACTIONS(486),
    [anon_sym_else] = ACTIONS(486),
    [anon_sym_while] = ACTIONS(486),
    [anon_sym_do] = ACTIONS(486),
    [anon_sym_try] = ACTIONS(486),
    [anon_sym_emit] = ACTIONS(486),
    [anon_sym_payable] = ACTIONS(486),
    [anon_sym_new] = ACTIONS(486),
    [anon_sym_LBRACK] = ACTIONS(488),
    [anon_sym_PLUS] = ACTIONS(486),
    [anon_sym_BANG] = ACTIONS(488),
    [anon_sym_delete] = ACTIONS(486),
    [anon_sym_PLUS_PLUS] = ACTIONS(488),
    [anon_sym_DASH_DASH] = ACTIONS(488),
    [anon_sym_mapping] = ACTIONS(486),
    [anon_sym_bool] = ACTIONS(486),
    [anon_sym_string] = ACTIONS(486),
    [anon_sym_int] = ACTIONS(486),
    [anon_sym_int8] = ACTIONS(486),
    [anon_sym_int16] = ACTIONS(486),
    [anon_sym_int24] = ACTIONS(486),
    [anon_sym_int32] = ACTIONS(486),
    [anon_sym_int40] = ACTIONS(486),
    [anon_sym_int48] = ACTIONS(486),
    [anon_sym_int56] = ACTIONS(486),
    [anon_sym_int64] = ACTIONS(486),
    [anon_sym_int72] = ACTIONS(486),
    [anon_sym_int80] = ACTIONS(486),
    [anon_sym_int88] = ACTIONS(486),
    [anon_sym_int96] = ACTIONS(486),
    [anon_sym_int104] = ACTIONS(486),
    [anon_sym_int112] = ACTIONS(486),
    [anon_sym_int120] = ACTIONS(486),
    [anon_sym_int128] = ACTIONS(486),
    [anon_sym_int136] = ACTIONS(486),
    [anon_sym_int144] = ACTIONS(486),
    [anon_sym_int152] = ACTIONS(486),
    [anon_sym_int160] = ACTIONS(486),
    [anon_sym_int168] = ACTIONS(486),
    [anon_sym_int176] = ACTIONS(486),
    [anon_sym_int184] = ACTIONS(486),
    [anon_sym_int192] = ACTIONS(486),
    [anon_sym_int200] = ACTIONS(486),
    [anon_sym_int208] = ACTIONS(486),
    [anon_sym_int216] = ACTIONS(486),
    [anon_sym_int224] = ACTIONS(486),
    [anon_sym_int232] = ACTIONS(486),
    [anon_sym_int240] = ACTIONS(486),
    [anon_sym_int248] = ACTIONS(486),
    [anon_sym_int256] = ACTIONS(486),
    [anon_sym_uint] = ACTIONS(486),
    [anon_sym_uint8] = ACTIONS(486),
    [anon_sym_uint16] = ACTIONS(486),
    [anon_sym_uint24] = ACTIONS(486),
    [anon_sym_uint32] = ACTIONS(486),
    [anon_sym_uint40] = ACTIONS(486),
    [anon_sym_uint48] = ACTIONS(486),
    [anon_sym_uint56] = ACTIONS(486),
    [anon_sym_uint64] = ACTIONS(486),
    [anon_sym_uint72] = ACTIONS(486),
    [anon_sym_uint80] = ACTIONS(486),
    [anon_sym_uint88] = ACTIONS(486),
    [anon_sym_uint96] = ACTIONS(486),
    [anon_sym_uint104] = ACTIONS(486),
    [anon_sym_uint112] = ACTIONS(486),
    [anon_sym_uint120] = ACTIONS(486),
    [anon_sym_uint128] = ACTIONS(486),
    [anon_sym_uint136] = ACTIONS(486),
    [anon_sym_uint144] = ACTIONS(486),
    [anon_sym_uint152] = ACTIONS(486),
    [anon_sym_uint160] = ACTIONS(486),
    [anon_sym_uint168] = ACTIONS(486),
    [anon_sym_uint176] = ACTIONS(486),
    [anon_sym_uint184] = ACTIONS(486),
    [anon_sym_uint192] = ACTIONS(486),
    [anon_sym_uint200] = ACTIONS(486),
    [anon_sym_uint208] = ACTIONS(486),
    [anon_sym_uint216] = ACTIONS(486),
    [anon_sym_uint224] = ACTIONS(486),
    [anon_sym_uint232] = ACTIONS(486),
    [anon_sym_uint240] = ACTIONS(486),
    [anon_sym_uint248] = ACTIONS(486),
    [anon_sym_uint256] = ACTIONS(486),
    [anon_sym_bytes] = ACTIONS(486),
    [anon_sym_bytes1] = ACTIONS(486),
    [anon_sym_bytes2] = ACTIONS(486),
    [anon_sym_bytes3] = ACTIONS(486),
    [anon_sym_bytes4] = ACTIONS(486),
    [anon_sym_bytes5] = ACTIONS(486),
    [anon_sym_bytes6] = ACTIONS(486),
    [anon_sym_bytes7] = ACTIONS(486),
    [anon_sym_bytes8] = ACTIONS(486),
    [anon_sym_bytes9] = ACTIONS(486),
    [anon_sym_bytes10] = ACTIONS(486),
    [anon_sym_bytes11] = ACTIONS(486),
    [anon_sym_bytes12] = ACTIONS(486),
    [anon_sym_bytes13] = ACTIONS(486),
    [anon_sym_bytes14] = ACTIONS(486),
    [anon_sym_bytes15] = ACTIONS(486),
    [anon_sym_bytes16] = ACTIONS(486),
    [anon_sym_bytes17] = ACTIONS(486),
    [anon_sym_bytes18] = ACTIONS(486),
    [anon_sym_bytes19] = ACTIONS(486),
    [anon_sym_bytes20] = ACTIONS(486),
    [anon_sym_bytes21] = ACTIONS(486),
    [anon_sym_bytes22] = ACTIONS(486),
    [anon_sym_bytes23] = ACTIONS(486),
    [anon_sym_bytes24] = ACTIONS(486),
    [anon_sym_bytes25] = ACTIONS(486),
    [anon_sym_bytes26] = ACTIONS(486),
    [anon_sym_bytes27] = ACTIONS(486),
    [anon_sym_bytes28] = ACTIONS(486),
    [anon_sym_bytes29] = ACTIONS(486),
    [anon_sym_bytes30] = ACTIONS(486),
    [anon_sym_bytes31] = ACTIONS(486),
    [anon_sym_bytes32] = ACTIONS(486),
    [anon_sym_fixed] = ACTIONS(486),
    [aux_sym__fixed_token1] = ACTIONS(486),
    [anon_sym_ufixed] = ACTIONS(486),
    [aux_sym__ufixed_token1] = ACTIONS(486),
    [aux_sym__decimal_number_token1] = ACTIONS(486),
    [aux_sym__decimal_number_token2] = ACTIONS(488),
    [aux_sym__hex_number_token1] = ACTIONS(488),
    [anon_sym_hex] = ACTIONS(486),
    [anon_sym_DQUOTE] = ACTIONS(488),
    [anon_sym_SQUOTE] = ACTIONS(488),
    [anon_sym_unicode] = ACTIONS(486),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_identifier] = ACTIONS(490),
    [anon_sym_DASH] = ACTIONS(490),
    [anon_sym_TILDE] = ACTIONS(492),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_RBRACE] = ACTIONS(492),
    [anon_sym_type] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(492),
    [anon_sym_for] = ACTIONS(490),
    [anon_sym_assembly] = ACTIONS(490),
    [anon_sym_break] = ACTIONS(490),
    [anon_sym_continue] = ACTIONS(490),
    [anon_sym_true] = ACTIONS(490),
    [anon_sym_false] = ACTIONS(490),
    [anon_sym_if] = ACTIONS(490),
    [anon_sym_function] = ACTIONS(490),
    [anon_sym_byte] = ACTIONS(490),
    [anon_sym_address] = ACTIONS(490),
    [anon_sym_return] = ACTIONS(490),
    [anon_sym_revert] = ACTIONS(490),
    [sym__unchecked] = ACTIONS(490),
    [anon_sym_var] = ACTIONS(490),
    [anon_sym_else] = ACTIONS(490),
    [anon_sym_while] = ACTIONS(490),
    [anon_sym_do] = ACTIONS(490),
    [anon_sym_try] = ACTIONS(490),
    [anon_sym_emit] = ACTIONS(490),
    [anon_sym_payable] = ACTIONS(490),
    [anon_sym_new] = ACTIONS(490),
    [anon_sym_LBRACK] = ACTIONS(492),
    [anon_sym_PLUS] = ACTIONS(490),
    [anon_sym_BANG] = ACTIONS(492),
    [anon_sym_delete] = ACTIONS(490),
    [anon_sym_PLUS_PLUS] = ACTIONS(492),
    [anon_sym_DASH_DASH] = ACTIONS(492),
    [anon_sym_mapping] = ACTIONS(490),
    [anon_sym_bool] = ACTIONS(490),
    [anon_sym_string] = ACTIONS(490),
    [anon_sym_int] = ACTIONS(490),
    [anon_sym_int8] = ACTIONS(490),
    [anon_sym_int16] = ACTIONS(490),
    [anon_sym_int24] = ACTIONS(490),
    [anon_sym_int32] = ACTIONS(490),
    [anon_sym_int40] = ACTIONS(490),
    [anon_sym_int48] = ACTIONS(490),
    [anon_sym_int56] = ACTIONS(490),
    [anon_sym_int64] = ACTIONS(490),
    [anon_sym_int72] = ACTIONS(490),
    [anon_sym_int80] = ACTIONS(490),
    [anon_sym_int88] = ACTIONS(490),
    [anon_sym_int96] = ACTIONS(490),
    [anon_sym_int104] = ACTIONS(490),
    [anon_sym_int112] = ACTIONS(490),
    [anon_sym_int120] = ACTIONS(490),
    [anon_sym_int128] = ACTIONS(490),
    [anon_sym_int136] = ACTIONS(490),
    [anon_sym_int144] = ACTIONS(490),
    [anon_sym_int152] = ACTIONS(490),
    [anon_sym_int160] = ACTIONS(490),
    [anon_sym_int168] = ACTIONS(490),
    [anon_sym_int176] = ACTIONS(490),
    [anon_sym_int184] = ACTIONS(490),
    [anon_sym_int192] = ACTIONS(490),
    [anon_sym_int200] = ACTIONS(490),
    [anon_sym_int208] = ACTIONS(490),
    [anon_sym_int216] = ACTIONS(490),
    [anon_sym_int224] = ACTIONS(490),
    [anon_sym_int232] = ACTIONS(490),
    [anon_sym_int240] = ACTIONS(490),
    [anon_sym_int248] = ACTIONS(490),
    [anon_sym_int256] = ACTIONS(490),
    [anon_sym_uint] = ACTIONS(490),
    [anon_sym_uint8] = ACTIONS(490),
    [anon_sym_uint16] = ACTIONS(490),
    [anon_sym_uint24] = ACTIONS(490),
    [anon_sym_uint32] = ACTIONS(490),
    [anon_sym_uint40] = ACTIONS(490),
    [anon_sym_uint48] = ACTIONS(490),
    [anon_sym_uint56] = ACTIONS(490),
    [anon_sym_uint64] = ACTIONS(490),
    [anon_sym_uint72] = ACTIONS(490),
    [anon_sym_uint80] = ACTIONS(490),
    [anon_sym_uint88] = ACTIONS(490),
    [anon_sym_uint96] = ACTIONS(490),
    [anon_sym_uint104] = ACTIONS(490),
    [anon_sym_uint112] = ACTIONS(490),
    [anon_sym_uint120] = ACTIONS(490),
    [anon_sym_uint128] = ACTIONS(490),
    [anon_sym_uint136] = ACTIONS(490),
    [anon_sym_uint144] = ACTIONS(490),
    [anon_sym_uint152] = ACTIONS(490),
    [anon_sym_uint160] = ACTIONS(490),
    [anon_sym_uint168] = ACTIONS(490),
    [anon_sym_uint176] = ACTIONS(490),
    [anon_sym_uint184] = ACTIONS(490),
    [anon_sym_uint192] = ACTIONS(490),
    [anon_sym_uint200] = ACTIONS(490),
    [anon_sym_uint208] = ACTIONS(490),
    [anon_sym_uint216] = ACTIONS(490),
    [anon_sym_uint224] = ACTIONS(490),
    [anon_sym_uint232] = ACTIONS(490),
    [anon_sym_uint240] = ACTIONS(490),
    [anon_sym_uint248] = ACTIONS(490),
    [anon_sym_uint256] = ACTIONS(490),
    [anon_sym_bytes] = ACTIONS(490),
    [anon_sym_bytes1] = ACTIONS(490),
    [anon_sym_bytes2] = ACTIONS(490),
    [anon_sym_bytes3] = ACTIONS(490),
    [anon_sym_bytes4] = ACTIONS(490),
    [anon_sym_bytes5] = ACTIONS(490),
    [anon_sym_bytes6] = ACTIONS(490),
    [anon_sym_bytes7] = ACTIONS(490),
    [anon_sym_bytes8] = ACTIONS(490),
    [anon_sym_bytes9] = ACTIONS(490),
    [anon_sym_bytes10] = ACTIONS(490),
    [anon_sym_bytes11] = ACTIONS(490),
    [anon_sym_bytes12] = ACTIONS(490),
    [anon_sym_bytes13] = ACTIONS(490),
    [anon_sym_bytes14] = ACTIONS(490),
    [anon_sym_bytes15] = ACTIONS(490),
    [anon_sym_bytes16] = ACTIONS(490),
    [anon_sym_bytes17] = ACTIONS(490),
    [anon_sym_bytes18] = ACTIONS(490),
    [anon_sym_bytes19] = ACTIONS(490),
    [anon_sym_bytes20] = ACTIONS(490),
    [anon_sym_bytes21] = ACTIONS(490),
    [anon_sym_bytes22] = ACTIONS(490),
    [anon_sym_bytes23] = ACTIONS(490),
    [anon_sym_bytes24] = ACTIONS(490),
    [anon_sym_bytes25] = ACTIONS(490),
    [anon_sym_bytes26] = ACTIONS(490),
    [anon_sym_bytes27] = ACTIONS(490),
    [anon_sym_bytes28] = ACTIONS(490),
    [anon_sym_bytes29] = ACTIONS(490),
    [anon_sym_bytes30] = ACTIONS(490),
    [anon_sym_bytes31] = ACTIONS(490),
    [anon_sym_bytes32] = ACTIONS(490),
    [anon_sym_fixed] = ACTIONS(490),
    [aux_sym__fixed_token1] = ACTIONS(490),
    [anon_sym_ufixed] = ACTIONS(490),
    [aux_sym__ufixed_token1] = ACTIONS(490),
    [aux_sym__decimal_number_token1] = ACTIONS(490),
    [aux_sym__decimal_number_token2] = ACTIONS(492),
    [aux_sym__hex_number_token1] = ACTIONS(492),
    [anon_sym_hex] = ACTIONS(490),
    [anon_sym_DQUOTE] = ACTIONS(492),
    [anon_sym_SQUOTE] = ACTIONS(492),
    [anon_sym_unicode] = ACTIONS(490),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_identifier] = ACTIONS(494),
    [anon_sym_DASH] = ACTIONS(494),
    [anon_sym_TILDE] = ACTIONS(496),
    [anon_sym_LBRACE] = ACTIONS(496),
    [anon_sym_RBRACE] = ACTIONS(496),
    [anon_sym_type] = ACTIONS(494),
    [anon_sym_LPAREN] = ACTIONS(496),
    [anon_sym_for] = ACTIONS(494),
    [anon_sym_assembly] = ACTIONS(494),
    [anon_sym_break] = ACTIONS(494),
    [anon_sym_continue] = ACTIONS(494),
    [anon_sym_true] = ACTIONS(494),
    [anon_sym_false] = ACTIONS(494),
    [anon_sym_if] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(494),
    [anon_sym_byte] = ACTIONS(494),
    [anon_sym_address] = ACTIONS(494),
    [anon_sym_return] = ACTIONS(494),
    [anon_sym_revert] = ACTIONS(494),
    [sym__unchecked] = ACTIONS(494),
    [anon_sym_var] = ACTIONS(494),
    [anon_sym_else] = ACTIONS(498),
    [anon_sym_while] = ACTIONS(494),
    [anon_sym_do] = ACTIONS(494),
    [anon_sym_try] = ACTIONS(494),
    [anon_sym_emit] = ACTIONS(494),
    [anon_sym_payable] = ACTIONS(494),
    [anon_sym_new] = ACTIONS(494),
    [anon_sym_LBRACK] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(494),
    [anon_sym_BANG] = ACTIONS(496),
    [anon_sym_delete] = ACTIONS(494),
    [anon_sym_PLUS_PLUS] = ACTIONS(496),
    [anon_sym_DASH_DASH] = ACTIONS(496),
    [anon_sym_mapping] = ACTIONS(494),
    [anon_sym_bool] = ACTIONS(494),
    [anon_sym_string] = ACTIONS(494),
    [anon_sym_int] = ACTIONS(494),
    [anon_sym_int8] = ACTIONS(494),
    [anon_sym_int16] = ACTIONS(494),
    [anon_sym_int24] = ACTIONS(494),
    [anon_sym_int32] = ACTIONS(494),
    [anon_sym_int40] = ACTIONS(494),
    [anon_sym_int48] = ACTIONS(494),
    [anon_sym_int56] = ACTIONS(494),
    [anon_sym_int64] = ACTIONS(494),
    [anon_sym_int72] = ACTIONS(494),
    [anon_sym_int80] = ACTIONS(494),
    [anon_sym_int88] = ACTIONS(494),
    [anon_sym_int96] = ACTIONS(494),
    [anon_sym_int104] = ACTIONS(494),
    [anon_sym_int112] = ACTIONS(494),
    [anon_sym_int120] = ACTIONS(494),
    [anon_sym_int128] = ACTIONS(494),
    [anon_sym_int136] = ACTIONS(494),
    [anon_sym_int144] = ACTIONS(494),
    [anon_sym_int152] = ACTIONS(494),
    [anon_sym_int160] = ACTIONS(494),
    [anon_sym_int168] = ACTIONS(494),
    [anon_sym_int176] = ACTIONS(494),
    [anon_sym_int184] = ACTIONS(494),
    [anon_sym_int192] = ACTIONS(494),
    [anon_sym_int200] = ACTIONS(494),
    [anon_sym_int208] = ACTIONS(494),
    [anon_sym_int216] = ACTIONS(494),
    [anon_sym_int224] = ACTIONS(494),
    [anon_sym_int232] = ACTIONS(494),
    [anon_sym_int240] = ACTIONS(494),
    [anon_sym_int248] = ACTIONS(494),
    [anon_sym_int256] = ACTIONS(494),
    [anon_sym_uint] = ACTIONS(494),
    [anon_sym_uint8] = ACTIONS(494),
    [anon_sym_uint16] = ACTIONS(494),
    [anon_sym_uint24] = ACTIONS(494),
    [anon_sym_uint32] = ACTIONS(494),
    [anon_sym_uint40] = ACTIONS(494),
    [anon_sym_uint48] = ACTIONS(494),
    [anon_sym_uint56] = ACTIONS(494),
    [anon_sym_uint64] = ACTIONS(494),
    [anon_sym_uint72] = ACTIONS(494),
    [anon_sym_uint80] = ACTIONS(494),
    [anon_sym_uint88] = ACTIONS(494),
    [anon_sym_uint96] = ACTIONS(494),
    [anon_sym_uint104] = ACTIONS(494),
    [anon_sym_uint112] = ACTIONS(494),
    [anon_sym_uint120] = ACTIONS(494),
    [anon_sym_uint128] = ACTIONS(494),
    [anon_sym_uint136] = ACTIONS(494),
    [anon_sym_uint144] = ACTIONS(494),
    [anon_sym_uint152] = ACTIONS(494),
    [anon_sym_uint160] = ACTIONS(494),
    [anon_sym_uint168] = ACTIONS(494),
    [anon_sym_uint176] = ACTIONS(494),
    [anon_sym_uint184] = ACTIONS(494),
    [anon_sym_uint192] = ACTIONS(494),
    [anon_sym_uint200] = ACTIONS(494),
    [anon_sym_uint208] = ACTIONS(494),
    [anon_sym_uint216] = ACTIONS(494),
    [anon_sym_uint224] = ACTIONS(494),
    [anon_sym_uint232] = ACTIONS(494),
    [anon_sym_uint240] = ACTIONS(494),
    [anon_sym_uint248] = ACTIONS(494),
    [anon_sym_uint256] = ACTIONS(494),
    [anon_sym_bytes] = ACTIONS(494),
    [anon_sym_bytes1] = ACTIONS(494),
    [anon_sym_bytes2] = ACTIONS(494),
    [anon_sym_bytes3] = ACTIONS(494),
    [anon_sym_bytes4] = ACTIONS(494),
    [anon_sym_bytes5] = ACTIONS(494),
    [anon_sym_bytes6] = ACTIONS(494),
    [anon_sym_bytes7] = ACTIONS(494),
    [anon_sym_bytes8] = ACTIONS(494),
    [anon_sym_bytes9] = ACTIONS(494),
    [anon_sym_bytes10] = ACTIONS(494),
    [anon_sym_bytes11] = ACTIONS(494),
    [anon_sym_bytes12] = ACTIONS(494),
    [anon_sym_bytes13] = ACTIONS(494),
    [anon_sym_bytes14] = ACTIONS(494),
    [anon_sym_bytes15] = ACTIONS(494),
    [anon_sym_bytes16] = ACTIONS(494),
    [anon_sym_bytes17] = ACTIONS(494),
    [anon_sym_bytes18] = ACTIONS(494),
    [anon_sym_bytes19] = ACTIONS(494),
    [anon_sym_bytes20] = ACTIONS(494),
    [anon_sym_bytes21] = ACTIONS(494),
    [anon_sym_bytes22] = ACTIONS(494),
    [anon_sym_bytes23] = ACTIONS(494),
    [anon_sym_bytes24] = ACTIONS(494),
    [anon_sym_bytes25] = ACTIONS(494),
    [anon_sym_bytes26] = ACTIONS(494),
    [anon_sym_bytes27] = ACTIONS(494),
    [anon_sym_bytes28] = ACTIONS(494),
    [anon_sym_bytes29] = ACTIONS(494),
    [anon_sym_bytes30] = ACTIONS(494),
    [anon_sym_bytes31] = ACTIONS(494),
    [anon_sym_bytes32] = ACTIONS(494),
    [anon_sym_fixed] = ACTIONS(494),
    [aux_sym__fixed_token1] = ACTIONS(494),
    [anon_sym_ufixed] = ACTIONS(494),
    [aux_sym__ufixed_token1] = ACTIONS(494),
    [aux_sym__decimal_number_token1] = ACTIONS(494),
    [aux_sym__decimal_number_token2] = ACTIONS(496),
    [aux_sym__hex_number_token1] = ACTIONS(496),
    [anon_sym_hex] = ACTIONS(494),
    [anon_sym_DQUOTE] = ACTIONS(496),
    [anon_sym_SQUOTE] = ACTIONS(496),
    [anon_sym_unicode] = ACTIONS(494),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_identifier] = ACTIONS(500),
    [anon_sym_DASH] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(502),
    [anon_sym_LBRACE] = ACTIONS(502),
    [anon_sym_RBRACE] = ACTIONS(502),
    [anon_sym_type] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(502),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_assembly] = ACTIONS(500),
    [anon_sym_break] = ACTIONS(500),
    [anon_sym_continue] = ACTIONS(500),
    [anon_sym_true] = ACTIONS(500),
    [anon_sym_false] = ACTIONS(500),
    [anon_sym_if] = ACTIONS(500),
    [anon_sym_function] = ACTIONS(500),
    [anon_sym_byte] = ACTIONS(500),
    [anon_sym_address] = ACTIONS(500),
    [anon_sym_return] = ACTIONS(500),
    [anon_sym_revert] = ACTIONS(500),
    [sym__unchecked] = ACTIONS(500),
    [anon_sym_var] = ACTIONS(500),
    [anon_sym_else] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(500),
    [anon_sym_do] = ACTIONS(500),
    [anon_sym_try] = ACTIONS(500),
    [anon_sym_emit] = ACTIONS(500),
    [anon_sym_payable] = ACTIONS(500),
    [anon_sym_new] = ACTIONS(500),
    [anon_sym_LBRACK] = ACTIONS(502),
    [anon_sym_PLUS] = ACTIONS(500),
    [anon_sym_BANG] = ACTIONS(502),
    [anon_sym_delete] = ACTIONS(500),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [anon_sym_mapping] = ACTIONS(500),
    [anon_sym_bool] = ACTIONS(500),
    [anon_sym_string] = ACTIONS(500),
    [anon_sym_int] = ACTIONS(500),
    [anon_sym_int8] = ACTIONS(500),
    [anon_sym_int16] = ACTIONS(500),
    [anon_sym_int24] = ACTIONS(500),
    [anon_sym_int32] = ACTIONS(500),
    [anon_sym_int40] = ACTIONS(500),
    [anon_sym_int48] = ACTIONS(500),
    [anon_sym_int56] = ACTIONS(500),
    [anon_sym_int64] = ACTIONS(500),
    [anon_sym_int72] = ACTIONS(500),
    [anon_sym_int80] = ACTIONS(500),
    [anon_sym_int88] = ACTIONS(500),
    [anon_sym_int96] = ACTIONS(500),
    [anon_sym_int104] = ACTIONS(500),
    [anon_sym_int112] = ACTIONS(500),
    [anon_sym_int120] = ACTIONS(500),
    [anon_sym_int128] = ACTIONS(500),
    [anon_sym_int136] = ACTIONS(500),
    [anon_sym_int144] = ACTIONS(500),
    [anon_sym_int152] = ACTIONS(500),
    [anon_sym_int160] = ACTIONS(500),
    [anon_sym_int168] = ACTIONS(500),
    [anon_sym_int176] = ACTIONS(500),
    [anon_sym_int184] = ACTIONS(500),
    [anon_sym_int192] = ACTIONS(500),
    [anon_sym_int200] = ACTIONS(500),
    [anon_sym_int208] = ACTIONS(500),
    [anon_sym_int216] = ACTIONS(500),
    [anon_sym_int224] = ACTIONS(500),
    [anon_sym_int232] = ACTIONS(500),
    [anon_sym_int240] = ACTIONS(500),
    [anon_sym_int248] = ACTIONS(500),
    [anon_sym_int256] = ACTIONS(500),
    [anon_sym_uint] = ACTIONS(500),
    [anon_sym_uint8] = ACTIONS(500),
    [anon_sym_uint16] = ACTIONS(500),
    [anon_sym_uint24] = ACTIONS(500),
    [anon_sym_uint32] = ACTIONS(500),
    [anon_sym_uint40] = ACTIONS(500),
    [anon_sym_uint48] = ACTIONS(500),
    [anon_sym_uint56] = ACTIONS(500),
    [anon_sym_uint64] = ACTIONS(500),
    [anon_sym_uint72] = ACTIONS(500),
    [anon_sym_uint80] = ACTIONS(500),
    [anon_sym_uint88] = ACTIONS(500),
    [anon_sym_uint96] = ACTIONS(500),
    [anon_sym_uint104] = ACTIONS(500),
    [anon_sym_uint112] = ACTIONS(500),
    [anon_sym_uint120] = ACTIONS(500),
    [anon_sym_uint128] = ACTIONS(500),
    [anon_sym_uint136] = ACTIONS(500),
    [anon_sym_uint144] = ACTIONS(500),
    [anon_sym_uint152] = ACTIONS(500),
    [anon_sym_uint160] = ACTIONS(500),
    [anon_sym_uint168] = ACTIONS(500),
    [anon_sym_uint176] = ACTIONS(500),
    [anon_sym_uint184] = ACTIONS(500),
    [anon_sym_uint192] = ACTIONS(500),
    [anon_sym_uint200] = ACTIONS(500),
    [anon_sym_uint208] = ACTIONS(500),
    [anon_sym_uint216] = ACTIONS(500),
    [anon_sym_uint224] = ACTIONS(500),
    [anon_sym_uint232] = ACTIONS(500),
    [anon_sym_uint240] = ACTIONS(500),
    [anon_sym_uint248] = ACTIONS(500),
    [anon_sym_uint256] = ACTIONS(500),
    [anon_sym_bytes] = ACTIONS(500),
    [anon_sym_bytes1] = ACTIONS(500),
    [anon_sym_bytes2] = ACTIONS(500),
    [anon_sym_bytes3] = ACTIONS(500),
    [anon_sym_bytes4] = ACTIONS(500),
    [anon_sym_bytes5] = ACTIONS(500),
    [anon_sym_bytes6] = ACTIONS(500),
    [anon_sym_bytes7] = ACTIONS(500),
    [anon_sym_bytes8] = ACTIONS(500),
    [anon_sym_bytes9] = ACTIONS(500),
    [anon_sym_bytes10] = ACTIONS(500),
    [anon_sym_bytes11] = ACTIONS(500),
    [anon_sym_bytes12] = ACTIONS(500),
    [anon_sym_bytes13] = ACTIONS(500),
    [anon_sym_bytes14] = ACTIONS(500),
    [anon_sym_bytes15] = ACTIONS(500),
    [anon_sym_bytes16] = ACTIONS(500),
    [anon_sym_bytes17] = ACTIONS(500),
    [anon_sym_bytes18] = ACTIONS(500),
    [anon_sym_bytes19] = ACTIONS(500),
    [anon_sym_bytes20] = ACTIONS(500),
    [anon_sym_bytes21] = ACTIONS(500),
    [anon_sym_bytes22] = ACTIONS(500),
    [anon_sym_bytes23] = ACTIONS(500),
    [anon_sym_bytes24] = ACTIONS(500),
    [anon_sym_bytes25] = ACTIONS(500),
    [anon_sym_bytes26] = ACTIONS(500),
    [anon_sym_bytes27] = ACTIONS(500),
    [anon_sym_bytes28] = ACTIONS(500),
    [anon_sym_bytes29] = ACTIONS(500),
    [anon_sym_bytes30] = ACTIONS(500),
    [anon_sym_bytes31] = ACTIONS(500),
    [anon_sym_bytes32] = ACTIONS(500),
    [anon_sym_fixed] = ACTIONS(500),
    [aux_sym__fixed_token1] = ACTIONS(500),
    [anon_sym_ufixed] = ACTIONS(500),
    [aux_sym__ufixed_token1] = ACTIONS(500),
    [aux_sym__decimal_number_token1] = ACTIONS(500),
    [aux_sym__decimal_number_token2] = ACTIONS(502),
    [aux_sym__hex_number_token1] = ACTIONS(502),
    [anon_sym_hex] = ACTIONS(500),
    [anon_sym_DQUOTE] = ACTIONS(502),
    [anon_sym_SQUOTE] = ACTIONS(502),
    [anon_sym_unicode] = ACTIONS(500),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_identifier] = ACTIONS(504),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_TILDE] = ACTIONS(506),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_RBRACE] = ACTIONS(506),
    [anon_sym_type] = ACTIONS(504),
    [anon_sym_LPAREN] = ACTIONS(506),
    [anon_sym_for] = ACTIONS(504),
    [anon_sym_assembly] = ACTIONS(504),
    [anon_sym_break] = ACTIONS(504),
    [anon_sym_continue] = ACTIONS(504),
    [anon_sym_true] = ACTIONS(504),
    [anon_sym_false] = ACTIONS(504),
    [anon_sym_if] = ACTIONS(504),
    [anon_sym_function] = ACTIONS(504),
    [anon_sym_byte] = ACTIONS(504),
    [anon_sym_address] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(504),
    [anon_sym_revert] = ACTIONS(504),
    [sym__unchecked] = ACTIONS(504),
    [anon_sym_var] = ACTIONS(504),
    [anon_sym_else] = ACTIONS(504),
    [anon_sym_while] = ACTIONS(504),
    [anon_sym_do] = ACTIONS(504),
    [anon_sym_try] = ACTIONS(504),
    [anon_sym_emit] = ACTIONS(504),
    [anon_sym_payable] = ACTIONS(504),
    [anon_sym_new] = ACTIONS(504),
    [anon_sym_LBRACK] = ACTIONS(506),
    [anon_sym_PLUS] = ACTIONS(504),
    [anon_sym_BANG] = ACTIONS(506),
    [anon_sym_delete] = ACTIONS(504),
    [anon_sym_PLUS_PLUS] = ACTIONS(506),
    [anon_sym_DASH_DASH] = ACTIONS(506),
    [anon_sym_mapping] = ACTIONS(504),
    [anon_sym_bool] = ACTIONS(504),
    [anon_sym_string] = ACTIONS(504),
    [anon_sym_int] = ACTIONS(504),
    [anon_sym_int8] = ACTIONS(504),
    [anon_sym_int16] = ACTIONS(504),
    [anon_sym_int24] = ACTIONS(504),
    [anon_sym_int32] = ACTIONS(504),
    [anon_sym_int40] = ACTIONS(504),
    [anon_sym_int48] = ACTIONS(504),
    [anon_sym_int56] = ACTIONS(504),
    [anon_sym_int64] = ACTIONS(504),
    [anon_sym_int72] = ACTIONS(504),
    [anon_sym_int80] = ACTIONS(504),
    [anon_sym_int88] = ACTIONS(504),
    [anon_sym_int96] = ACTIONS(504),
    [anon_sym_int104] = ACTIONS(504),
    [anon_sym_int112] = ACTIONS(504),
    [anon_sym_int120] = ACTIONS(504),
    [anon_sym_int128] = ACTIONS(504),
    [anon_sym_int136] = ACTIONS(504),
    [anon_sym_int144] = ACTIONS(504),
    [anon_sym_int152] = ACTIONS(504),
    [anon_sym_int160] = ACTIONS(504),
    [anon_sym_int168] = ACTIONS(504),
    [anon_sym_int176] = ACTIONS(504),
    [anon_sym_int184] = ACTIONS(504),
    [anon_sym_int192] = ACTIONS(504),
    [anon_sym_int200] = ACTIONS(504),
    [anon_sym_int208] = ACTIONS(504),
    [anon_sym_int216] = ACTIONS(504),
    [anon_sym_int224] = ACTIONS(504),
    [anon_sym_int232] = ACTIONS(504),
    [anon_sym_int240] = ACTIONS(504),
    [anon_sym_int248] = ACTIONS(504),
    [anon_sym_int256] = ACTIONS(504),
    [anon_sym_uint] = ACTIONS(504),
    [anon_sym_uint8] = ACTIONS(504),
    [anon_sym_uint16] = ACTIONS(504),
    [anon_sym_uint24] = ACTIONS(504),
    [anon_sym_uint32] = ACTIONS(504),
    [anon_sym_uint40] = ACTIONS(504),
    [anon_sym_uint48] = ACTIONS(504),
    [anon_sym_uint56] = ACTIONS(504),
    [anon_sym_uint64] = ACTIONS(504),
    [anon_sym_uint72] = ACTIONS(504),
    [anon_sym_uint80] = ACTIONS(504),
    [anon_sym_uint88] = ACTIONS(504),
    [anon_sym_uint96] = ACTIONS(504),
    [anon_sym_uint104] = ACTIONS(504),
    [anon_sym_uint112] = ACTIONS(504),
    [anon_sym_uint120] = ACTIONS(504),
    [anon_sym_uint128] = ACTIONS(504),
    [anon_sym_uint136] = ACTIONS(504),
    [anon_sym_uint144] = ACTIONS(504),
    [anon_sym_uint152] = ACTIONS(504),
    [anon_sym_uint160] = ACTIONS(504),
    [anon_sym_uint168] = ACTIONS(504),
    [anon_sym_uint176] = ACTIONS(504),
    [anon_sym_uint184] = ACTIONS(504),
    [anon_sym_uint192] = ACTIONS(504),
    [anon_sym_uint200] = ACTIONS(504),
    [anon_sym_uint208] = ACTIONS(504),
    [anon_sym_uint216] = ACTIONS(504),
    [anon_sym_uint224] = ACTIONS(504),
    [anon_sym_uint232] = ACTIONS(504),
    [anon_sym_uint240] = ACTIONS(504),
    [anon_sym_uint248] = ACTIONS(504),
    [anon_sym_uint256] = ACTIONS(504),
    [anon_sym_bytes] = ACTIONS(504),
    [anon_sym_bytes1] = ACTIONS(504),
    [anon_sym_bytes2] = ACTIONS(504),
    [anon_sym_bytes3] = ACTIONS(504),
    [anon_sym_bytes4] = ACTIONS(504),
    [anon_sym_bytes5] = ACTIONS(504),
    [anon_sym_bytes6] = ACTIONS(504),
    [anon_sym_bytes7] = ACTIONS(504),
    [anon_sym_bytes8] = ACTIONS(504),
    [anon_sym_bytes9] = ACTIONS(504),
    [anon_sym_bytes10] = ACTIONS(504),
    [anon_sym_bytes11] = ACTIONS(504),
    [anon_sym_bytes12] = ACTIONS(504),
    [anon_sym_bytes13] = ACTIONS(504),
    [anon_sym_bytes14] = ACTIONS(504),
    [anon_sym_bytes15] = ACTIONS(504),
    [anon_sym_bytes16] = ACTIONS(504),
    [anon_sym_bytes17] = ACTIONS(504),
    [anon_sym_bytes18] = ACTIONS(504),
    [anon_sym_bytes19] = ACTIONS(504),
    [anon_sym_bytes20] = ACTIONS(504),
    [anon_sym_bytes21] = ACTIONS(504),
    [anon_sym_bytes22] = ACTIONS(504),
    [anon_sym_bytes23] = ACTIONS(504),
    [anon_sym_bytes24] = ACTIONS(504),
    [anon_sym_bytes25] = ACTIONS(504),
    [anon_sym_bytes26] = ACTIONS(504),
    [anon_sym_bytes27] = ACTIONS(504),
    [anon_sym_bytes28] = ACTIONS(504),
    [anon_sym_bytes29] = ACTIONS(504),
    [anon_sym_bytes30] = ACTIONS(504),
    [anon_sym_bytes31] = ACTIONS(504),
    [anon_sym_bytes32] = ACTIONS(504),
    [anon_sym_fixed] = ACTIONS(504),
    [aux_sym__fixed_token1] = ACTIONS(504),
    [anon_sym_ufixed] = ACTIONS(504),
    [aux_sym__ufixed_token1] = ACTIONS(504),
    [aux_sym__decimal_number_token1] = ACTIONS(504),
    [aux_sym__decimal_number_token2] = ACTIONS(506),
    [aux_sym__hex_number_token1] = ACTIONS(506),
    [anon_sym_hex] = ACTIONS(504),
    [anon_sym_DQUOTE] = ACTIONS(506),
    [anon_sym_SQUOTE] = ACTIONS(506),
    [anon_sym_unicode] = ACTIONS(504),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_identifier] = ACTIONS(508),
    [anon_sym_DASH] = ACTIONS(508),
    [anon_sym_TILDE] = ACTIONS(510),
    [anon_sym_LBRACE] = ACTIONS(510),
    [anon_sym_RBRACE] = ACTIONS(510),
    [anon_sym_type] = ACTIONS(508),
    [anon_sym_LPAREN] = ACTIONS(510),
    [anon_sym_for] = ACTIONS(508),
    [anon_sym_assembly] = ACTIONS(508),
    [anon_sym_break] = ACTIONS(508),
    [anon_sym_continue] = ACTIONS(508),
    [anon_sym_true] = ACTIONS(508),
    [anon_sym_false] = ACTIONS(508),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_function] = ACTIONS(508),
    [anon_sym_byte] = ACTIONS(508),
    [anon_sym_address] = ACTIONS(508),
    [anon_sym_return] = ACTIONS(508),
    [anon_sym_revert] = ACTIONS(508),
    [sym__unchecked] = ACTIONS(508),
    [anon_sym_var] = ACTIONS(508),
    [anon_sym_else] = ACTIONS(508),
    [anon_sym_while] = ACTIONS(508),
    [anon_sym_do] = ACTIONS(508),
    [anon_sym_try] = ACTIONS(508),
    [anon_sym_emit] = ACTIONS(508),
    [anon_sym_payable] = ACTIONS(508),
    [anon_sym_new] = ACTIONS(508),
    [anon_sym_LBRACK] = ACTIONS(510),
    [anon_sym_PLUS] = ACTIONS(508),
    [anon_sym_BANG] = ACTIONS(510),
    [anon_sym_delete] = ACTIONS(508),
    [anon_sym_PLUS_PLUS] = ACTIONS(510),
    [anon_sym_DASH_DASH] = ACTIONS(510),
    [anon_sym_mapping] = ACTIONS(508),
    [anon_sym_bool] = ACTIONS(508),
    [anon_sym_string] = ACTIONS(508),
    [anon_sym_int] = ACTIONS(508),
    [anon_sym_int8] = ACTIONS(508),
    [anon_sym_int16] = ACTIONS(508),
    [anon_sym_int24] = ACTIONS(508),
    [anon_sym_int32] = ACTIONS(508),
    [anon_sym_int40] = ACTIONS(508),
    [anon_sym_int48] = ACTIONS(508),
    [anon_sym_int56] = ACTIONS(508),
    [anon_sym_int64] = ACTIONS(508),
    [anon_sym_int72] = ACTIONS(508),
    [anon_sym_int80] = ACTIONS(508),
    [anon_sym_int88] = ACTIONS(508),
    [anon_sym_int96] = ACTIONS(508),
    [anon_sym_int104] = ACTIONS(508),
    [anon_sym_int112] = ACTIONS(508),
    [anon_sym_int120] = ACTIONS(508),
    [anon_sym_int128] = ACTIONS(508),
    [anon_sym_int136] = ACTIONS(508),
    [anon_sym_int144] = ACTIONS(508),
    [anon_sym_int152] = ACTIONS(508),
    [anon_sym_int160] = ACTIONS(508),
    [anon_sym_int168] = ACTIONS(508),
    [anon_sym_int176] = ACTIONS(508),
    [anon_sym_int184] = ACTIONS(508),
    [anon_sym_int192] = ACTIONS(508),
    [anon_sym_int200] = ACTIONS(508),
    [anon_sym_int208] = ACTIONS(508),
    [anon_sym_int216] = ACTIONS(508),
    [anon_sym_int224] = ACTIONS(508),
    [anon_sym_int232] = ACTIONS(508),
    [anon_sym_int240] = ACTIONS(508),
    [anon_sym_int248] = ACTIONS(508),
    [anon_sym_int256] = ACTIONS(508),
    [anon_sym_uint] = ACTIONS(508),
    [anon_sym_uint8] = ACTIONS(508),
    [anon_sym_uint16] = ACTIONS(508),
    [anon_sym_uint24] = ACTIONS(508),
    [anon_sym_uint32] = ACTIONS(508),
    [anon_sym_uint40] = ACTIONS(508),
    [anon_sym_uint48] = ACTIONS(508),
    [anon_sym_uint56] = ACTIONS(508),
    [anon_sym_uint64] = ACTIONS(508),
    [anon_sym_uint72] = ACTIONS(508),
    [anon_sym_uint80] = ACTIONS(508),
    [anon_sym_uint88] = ACTIONS(508),
    [anon_sym_uint96] = ACTIONS(508),
    [anon_sym_uint104] = ACTIONS(508),
    [anon_sym_uint112] = ACTIONS(508),
    [anon_sym_uint120] = ACTIONS(508),
    [anon_sym_uint128] = ACTIONS(508),
    [anon_sym_uint136] = ACTIONS(508),
    [anon_sym_uint144] = ACTIONS(508),
    [anon_sym_uint152] = ACTIONS(508),
    [anon_sym_uint160] = ACTIONS(508),
    [anon_sym_uint168] = ACTIONS(508),
    [anon_sym_uint176] = ACTIONS(508),
    [anon_sym_uint184] = ACTIONS(508),
    [anon_sym_uint192] = ACTIONS(508),
    [anon_sym_uint200] = ACTIONS(508),
    [anon_sym_uint208] = ACTIONS(508),
    [anon_sym_uint216] = ACTIONS(508),
    [anon_sym_uint224] = ACTIONS(508),
    [anon_sym_uint232] = ACTIONS(508),
    [anon_sym_uint240] = ACTIONS(508),
    [anon_sym_uint248] = ACTIONS(508),
    [anon_sym_uint256] = ACTIONS(508),
    [anon_sym_bytes] = ACTIONS(508),
    [anon_sym_bytes1] = ACTIONS(508),
    [anon_sym_bytes2] = ACTIONS(508),
    [anon_sym_bytes3] = ACTIONS(508),
    [anon_sym_bytes4] = ACTIONS(508),
    [anon_sym_bytes5] = ACTIONS(508),
    [anon_sym_bytes6] = ACTIONS(508),
    [anon_sym_bytes7] = ACTIONS(508),
    [anon_sym_bytes8] = ACTIONS(508),
    [anon_sym_bytes9] = ACTIONS(508),
    [anon_sym_bytes10] = ACTIONS(508),
    [anon_sym_bytes11] = ACTIONS(508),
    [anon_sym_bytes12] = ACTIONS(508),
    [anon_sym_bytes13] = ACTIONS(508),
    [anon_sym_bytes14] = ACTIONS(508),
    [anon_sym_bytes15] = ACTIONS(508),
    [anon_sym_bytes16] = ACTIONS(508),
    [anon_sym_bytes17] = ACTIONS(508),
    [anon_sym_bytes18] = ACTIONS(508),
    [anon_sym_bytes19] = ACTIONS(508),
    [anon_sym_bytes20] = ACTIONS(508),
    [anon_sym_bytes21] = ACTIONS(508),
    [anon_sym_bytes22] = ACTIONS(508),
    [anon_sym_bytes23] = ACTIONS(508),
    [anon_sym_bytes24] = ACTIONS(508),
    [anon_sym_bytes25] = ACTIONS(508),
    [anon_sym_bytes26] = ACTIONS(508),
    [anon_sym_bytes27] = ACTIONS(508),
    [anon_sym_bytes28] = ACTIONS(508),
    [anon_sym_bytes29] = ACTIONS(508),
    [anon_sym_bytes30] = ACTIONS(508),
    [anon_sym_bytes31] = ACTIONS(508),
    [anon_sym_bytes32] = ACTIONS(508),
    [anon_sym_fixed] = ACTIONS(508),
    [aux_sym__fixed_token1] = ACTIONS(508),
    [anon_sym_ufixed] = ACTIONS(508),
    [aux_sym__ufixed_token1] = ACTIONS(508),
    [aux_sym__decimal_number_token1] = ACTIONS(508),
    [aux_sym__decimal_number_token2] = ACTIONS(510),
    [aux_sym__hex_number_token1] = ACTIONS(510),
    [anon_sym_hex] = ACTIONS(508),
    [anon_sym_DQUOTE] = ACTIONS(510),
    [anon_sym_SQUOTE] = ACTIONS(510),
    [anon_sym_unicode] = ACTIONS(508),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_identifier] = ACTIONS(512),
    [anon_sym_DASH] = ACTIONS(512),
    [anon_sym_TILDE] = ACTIONS(514),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_RBRACE] = ACTIONS(514),
    [anon_sym_type] = ACTIONS(512),
    [anon_sym_LPAREN] = ACTIONS(514),
    [anon_sym_for] = ACTIONS(512),
    [anon_sym_assembly] = ACTIONS(512),
    [anon_sym_break] = ACTIONS(512),
    [anon_sym_continue] = ACTIONS(512),
    [anon_sym_true] = ACTIONS(512),
    [anon_sym_false] = ACTIONS(512),
    [anon_sym_if] = ACTIONS(512),
    [anon_sym_function] = ACTIONS(512),
    [anon_sym_byte] = ACTIONS(512),
    [anon_sym_address] = ACTIONS(512),
    [anon_sym_return] = ACTIONS(512),
    [anon_sym_revert] = ACTIONS(512),
    [sym__unchecked] = ACTIONS(512),
    [anon_sym_var] = ACTIONS(512),
    [anon_sym_else] = ACTIONS(512),
    [anon_sym_while] = ACTIONS(512),
    [anon_sym_do] = ACTIONS(512),
    [anon_sym_try] = ACTIONS(512),
    [anon_sym_emit] = ACTIONS(512),
    [anon_sym_payable] = ACTIONS(512),
    [anon_sym_new] = ACTIONS(512),
    [anon_sym_LBRACK] = ACTIONS(514),
    [anon_sym_PLUS] = ACTIONS(512),
    [anon_sym_BANG] = ACTIONS(514),
    [anon_sym_delete] = ACTIONS(512),
    [anon_sym_PLUS_PLUS] = ACTIONS(514),
    [anon_sym_DASH_DASH] = ACTIONS(514),
    [anon_sym_mapping] = ACTIONS(512),
    [anon_sym_bool] = ACTIONS(512),
    [anon_sym_string] = ACTIONS(512),
    [anon_sym_int] = ACTIONS(512),
    [anon_sym_int8] = ACTIONS(512),
    [anon_sym_int16] = ACTIONS(512),
    [anon_sym_int24] = ACTIONS(512),
    [anon_sym_int32] = ACTIONS(512),
    [anon_sym_int40] = ACTIONS(512),
    [anon_sym_int48] = ACTIONS(512),
    [anon_sym_int56] = ACTIONS(512),
    [anon_sym_int64] = ACTIONS(512),
    [anon_sym_int72] = ACTIONS(512),
    [anon_sym_int80] = ACTIONS(512),
    [anon_sym_int88] = ACTIONS(512),
    [anon_sym_int96] = ACTIONS(512),
    [anon_sym_int104] = ACTIONS(512),
    [anon_sym_int112] = ACTIONS(512),
    [anon_sym_int120] = ACTIONS(512),
    [anon_sym_int128] = ACTIONS(512),
    [anon_sym_int136] = ACTIONS(512),
    [anon_sym_int144] = ACTIONS(512),
    [anon_sym_int152] = ACTIONS(512),
    [anon_sym_int160] = ACTIONS(512),
    [anon_sym_int168] = ACTIONS(512),
    [anon_sym_int176] = ACTIONS(512),
    [anon_sym_int184] = ACTIONS(512),
    [anon_sym_int192] = ACTIONS(512),
    [anon_sym_int200] = ACTIONS(512),
    [anon_sym_int208] = ACTIONS(512),
    [anon_sym_int216] = ACTIONS(512),
    [anon_sym_int224] = ACTIONS(512),
    [anon_sym_int232] = ACTIONS(512),
    [anon_sym_int240] = ACTIONS(512),
    [anon_sym_int248] = ACTIONS(512),
    [anon_sym_int256] = ACTIONS(512),
    [anon_sym_uint] = ACTIONS(512),
    [anon_sym_uint8] = ACTIONS(512),
    [anon_sym_uint16] = ACTIONS(512),
    [anon_sym_uint24] = ACTIONS(512),
    [anon_sym_uint32] = ACTIONS(512),
    [anon_sym_uint40] = ACTIONS(512),
    [anon_sym_uint48] = ACTIONS(512),
    [anon_sym_uint56] = ACTIONS(512),
    [anon_sym_uint64] = ACTIONS(512),
    [anon_sym_uint72] = ACTIONS(512),
    [anon_sym_uint80] = ACTIONS(512),
    [anon_sym_uint88] = ACTIONS(512),
    [anon_sym_uint96] = ACTIONS(512),
    [anon_sym_uint104] = ACTIONS(512),
    [anon_sym_uint112] = ACTIONS(512),
    [anon_sym_uint120] = ACTIONS(512),
    [anon_sym_uint128] = ACTIONS(512),
    [anon_sym_uint136] = ACTIONS(512),
    [anon_sym_uint144] = ACTIONS(512),
    [anon_sym_uint152] = ACTIONS(512),
    [anon_sym_uint160] = ACTIONS(512),
    [anon_sym_uint168] = ACTIONS(512),
    [anon_sym_uint176] = ACTIONS(512),
    [anon_sym_uint184] = ACTIONS(512),
    [anon_sym_uint192] = ACTIONS(512),
    [anon_sym_uint200] = ACTIONS(512),
    [anon_sym_uint208] = ACTIONS(512),
    [anon_sym_uint216] = ACTIONS(512),
    [anon_sym_uint224] = ACTIONS(512),
    [anon_sym_uint232] = ACTIONS(512),
    [anon_sym_uint240] = ACTIONS(512),
    [anon_sym_uint248] = ACTIONS(512),
    [anon_sym_uint256] = ACTIONS(512),
    [anon_sym_bytes] = ACTIONS(512),
    [anon_sym_bytes1] = ACTIONS(512),
    [anon_sym_bytes2] = ACTIONS(512),
    [anon_sym_bytes3] = ACTIONS(512),
    [anon_sym_bytes4] = ACTIONS(512),
    [anon_sym_bytes5] = ACTIONS(512),
    [anon_sym_bytes6] = ACTIONS(512),
    [anon_sym_bytes7] = ACTIONS(512),
    [anon_sym_bytes8] = ACTIONS(512),
    [anon_sym_bytes9] = ACTIONS(512),
    [anon_sym_bytes10] = ACTIONS(512),
    [anon_sym_bytes11] = ACTIONS(512),
    [anon_sym_bytes12] = ACTIONS(512),
    [anon_sym_bytes13] = ACTIONS(512),
    [anon_sym_bytes14] = ACTIONS(512),
    [anon_sym_bytes15] = ACTIONS(512),
    [anon_sym_bytes16] = ACTIONS(512),
    [anon_sym_bytes17] = ACTIONS(512),
    [anon_sym_bytes18] = ACTIONS(512),
    [anon_sym_bytes19] = ACTIONS(512),
    [anon_sym_bytes20] = ACTIONS(512),
    [anon_sym_bytes21] = ACTIONS(512),
    [anon_sym_bytes22] = ACTIONS(512),
    [anon_sym_bytes23] = ACTIONS(512),
    [anon_sym_bytes24] = ACTIONS(512),
    [anon_sym_bytes25] = ACTIONS(512),
    [anon_sym_bytes26] = ACTIONS(512),
    [anon_sym_bytes27] = ACTIONS(512),
    [anon_sym_bytes28] = ACTIONS(512),
    [anon_sym_bytes29] = ACTIONS(512),
    [anon_sym_bytes30] = ACTIONS(512),
    [anon_sym_bytes31] = ACTIONS(512),
    [anon_sym_bytes32] = ACTIONS(512),
    [anon_sym_fixed] = ACTIONS(512),
    [aux_sym__fixed_token1] = ACTIONS(512),
    [anon_sym_ufixed] = ACTIONS(512),
    [aux_sym__ufixed_token1] = ACTIONS(512),
    [aux_sym__decimal_number_token1] = ACTIONS(512),
    [aux_sym__decimal_number_token2] = ACTIONS(514),
    [aux_sym__hex_number_token1] = ACTIONS(514),
    [anon_sym_hex] = ACTIONS(512),
    [anon_sym_DQUOTE] = ACTIONS(514),
    [anon_sym_SQUOTE] = ACTIONS(514),
    [anon_sym_unicode] = ACTIONS(512),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_identifier] = ACTIONS(516),
    [anon_sym_DASH] = ACTIONS(516),
    [anon_sym_TILDE] = ACTIONS(518),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(518),
    [anon_sym_type] = ACTIONS(516),
    [anon_sym_LPAREN] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(516),
    [anon_sym_assembly] = ACTIONS(516),
    [anon_sym_break] = ACTIONS(516),
    [anon_sym_continue] = ACTIONS(516),
    [anon_sym_true] = ACTIONS(516),
    [anon_sym_false] = ACTIONS(516),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_function] = ACTIONS(516),
    [anon_sym_byte] = ACTIONS(516),
    [anon_sym_address] = ACTIONS(516),
    [anon_sym_return] = ACTIONS(516),
    [anon_sym_revert] = ACTIONS(516),
    [sym__unchecked] = ACTIONS(516),
    [anon_sym_var] = ACTIONS(516),
    [anon_sym_else] = ACTIONS(516),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(516),
    [anon_sym_try] = ACTIONS(516),
    [anon_sym_emit] = ACTIONS(516),
    [anon_sym_payable] = ACTIONS(516),
    [anon_sym_new] = ACTIONS(516),
    [anon_sym_LBRACK] = ACTIONS(518),
    [anon_sym_PLUS] = ACTIONS(516),
    [anon_sym_BANG] = ACTIONS(518),
    [anon_sym_delete] = ACTIONS(516),
    [anon_sym_PLUS_PLUS] = ACTIONS(518),
    [anon_sym_DASH_DASH] = ACTIONS(518),
    [anon_sym_mapping] = ACTIONS(516),
    [anon_sym_bool] = ACTIONS(516),
    [anon_sym_string] = ACTIONS(516),
    [anon_sym_int] = ACTIONS(516),
    [anon_sym_int8] = ACTIONS(516),
    [anon_sym_int16] = ACTIONS(516),
    [anon_sym_int24] = ACTIONS(516),
    [anon_sym_int32] = ACTIONS(516),
    [anon_sym_int40] = ACTIONS(516),
    [anon_sym_int48] = ACTIONS(516),
    [anon_sym_int56] = ACTIONS(516),
    [anon_sym_int64] = ACTIONS(516),
    [anon_sym_int72] = ACTIONS(516),
    [anon_sym_int80] = ACTIONS(516),
    [anon_sym_int88] = ACTIONS(516),
    [anon_sym_int96] = ACTIONS(516),
    [anon_sym_int104] = ACTIONS(516),
    [anon_sym_int112] = ACTIONS(516),
    [anon_sym_int120] = ACTIONS(516),
    [anon_sym_int128] = ACTIONS(516),
    [anon_sym_int136] = ACTIONS(516),
    [anon_sym_int144] = ACTIONS(516),
    [anon_sym_int152] = ACTIONS(516),
    [anon_sym_int160] = ACTIONS(516),
    [anon_sym_int168] = ACTIONS(516),
    [anon_sym_int176] = ACTIONS(516),
    [anon_sym_int184] = ACTIONS(516),
    [anon_sym_int192] = ACTIONS(516),
    [anon_sym_int200] = ACTIONS(516),
    [anon_sym_int208] = ACTIONS(516),
    [anon_sym_int216] = ACTIONS(516),
    [anon_sym_int224] = ACTIONS(516),
    [anon_sym_int232] = ACTIONS(516),
    [anon_sym_int240] = ACTIONS(516),
    [anon_sym_int248] = ACTIONS(516),
    [anon_sym_int256] = ACTIONS(516),
    [anon_sym_uint] = ACTIONS(516),
    [anon_sym_uint8] = ACTIONS(516),
    [anon_sym_uint16] = ACTIONS(516),
    [anon_sym_uint24] = ACTIONS(516),
    [anon_sym_uint32] = ACTIONS(516),
    [anon_sym_uint40] = ACTIONS(516),
    [anon_sym_uint48] = ACTIONS(516),
    [anon_sym_uint56] = ACTIONS(516),
    [anon_sym_uint64] = ACTIONS(516),
    [anon_sym_uint72] = ACTIONS(516),
    [anon_sym_uint80] = ACTIONS(516),
    [anon_sym_uint88] = ACTIONS(516),
    [anon_sym_uint96] = ACTIONS(516),
    [anon_sym_uint104] = ACTIONS(516),
    [anon_sym_uint112] = ACTIONS(516),
    [anon_sym_uint120] = ACTIONS(516),
    [anon_sym_uint128] = ACTIONS(516),
    [anon_sym_uint136] = ACTIONS(516),
    [anon_sym_uint144] = ACTIONS(516),
    [anon_sym_uint152] = ACTIONS(516),
    [anon_sym_uint160] = ACTIONS(516),
    [anon_sym_uint168] = ACTIONS(516),
    [anon_sym_uint176] = ACTIONS(516),
    [anon_sym_uint184] = ACTIONS(516),
    [anon_sym_uint192] = ACTIONS(516),
    [anon_sym_uint200] = ACTIONS(516),
    [anon_sym_uint208] = ACTIONS(516),
    [anon_sym_uint216] = ACTIONS(516),
    [anon_sym_uint224] = ACTIONS(516),
    [anon_sym_uint232] = ACTIONS(516),
    [anon_sym_uint240] = ACTIONS(516),
    [anon_sym_uint248] = ACTIONS(516),
    [anon_sym_uint256] = ACTIONS(516),
    [anon_sym_bytes] = ACTIONS(516),
    [anon_sym_bytes1] = ACTIONS(516),
    [anon_sym_bytes2] = ACTIONS(516),
    [anon_sym_bytes3] = ACTIONS(516),
    [anon_sym_bytes4] = ACTIONS(516),
    [anon_sym_bytes5] = ACTIONS(516),
    [anon_sym_bytes6] = ACTIONS(516),
    [anon_sym_bytes7] = ACTIONS(516),
    [anon_sym_bytes8] = ACTIONS(516),
    [anon_sym_bytes9] = ACTIONS(516),
    [anon_sym_bytes10] = ACTIONS(516),
    [anon_sym_bytes11] = ACTIONS(516),
    [anon_sym_bytes12] = ACTIONS(516),
    [anon_sym_bytes13] = ACTIONS(516),
    [anon_sym_bytes14] = ACTIONS(516),
    [anon_sym_bytes15] = ACTIONS(516),
    [anon_sym_bytes16] = ACTIONS(516),
    [anon_sym_bytes17] = ACTIONS(516),
    [anon_sym_bytes18] = ACTIONS(516),
    [anon_sym_bytes19] = ACTIONS(516),
    [anon_sym_bytes20] = ACTIONS(516),
    [anon_sym_bytes21] = ACTIONS(516),
    [anon_sym_bytes22] = ACTIONS(516),
    [anon_sym_bytes23] = ACTIONS(516),
    [anon_sym_bytes24] = ACTIONS(516),
    [anon_sym_bytes25] = ACTIONS(516),
    [anon_sym_bytes26] = ACTIONS(516),
    [anon_sym_bytes27] = ACTIONS(516),
    [anon_sym_bytes28] = ACTIONS(516),
    [anon_sym_bytes29] = ACTIONS(516),
    [anon_sym_bytes30] = ACTIONS(516),
    [anon_sym_bytes31] = ACTIONS(516),
    [anon_sym_bytes32] = ACTIONS(516),
    [anon_sym_fixed] = ACTIONS(516),
    [aux_sym__fixed_token1] = ACTIONS(516),
    [anon_sym_ufixed] = ACTIONS(516),
    [aux_sym__ufixed_token1] = ACTIONS(516),
    [aux_sym__decimal_number_token1] = ACTIONS(516),
    [aux_sym__decimal_number_token2] = ACTIONS(518),
    [aux_sym__hex_number_token1] = ACTIONS(518),
    [anon_sym_hex] = ACTIONS(516),
    [anon_sym_DQUOTE] = ACTIONS(518),
    [anon_sym_SQUOTE] = ACTIONS(518),
    [anon_sym_unicode] = ACTIONS(516),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_identifier] = ACTIONS(520),
    [anon_sym_DASH] = ACTIONS(520),
    [anon_sym_TILDE] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(522),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_type] = ACTIONS(520),
    [anon_sym_LPAREN] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_assembly] = ACTIONS(520),
    [anon_sym_break] = ACTIONS(520),
    [anon_sym_continue] = ACTIONS(520),
    [anon_sym_true] = ACTIONS(520),
    [anon_sym_false] = ACTIONS(520),
    [anon_sym_if] = ACTIONS(520),
    [anon_sym_function] = ACTIONS(520),
    [anon_sym_byte] = ACTIONS(520),
    [anon_sym_address] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(520),
    [anon_sym_revert] = ACTIONS(520),
    [sym__unchecked] = ACTIONS(520),
    [anon_sym_var] = ACTIONS(520),
    [anon_sym_else] = ACTIONS(520),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(520),
    [anon_sym_try] = ACTIONS(520),
    [anon_sym_emit] = ACTIONS(520),
    [anon_sym_payable] = ACTIONS(520),
    [anon_sym_new] = ACTIONS(520),
    [anon_sym_LBRACK] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(520),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_delete] = ACTIONS(520),
    [anon_sym_PLUS_PLUS] = ACTIONS(522),
    [anon_sym_DASH_DASH] = ACTIONS(522),
    [anon_sym_mapping] = ACTIONS(520),
    [anon_sym_bool] = ACTIONS(520),
    [anon_sym_string] = ACTIONS(520),
    [anon_sym_int] = ACTIONS(520),
    [anon_sym_int8] = ACTIONS(520),
    [anon_sym_int16] = ACTIONS(520),
    [anon_sym_int24] = ACTIONS(520),
    [anon_sym_int32] = ACTIONS(520),
    [anon_sym_int40] = ACTIONS(520),
    [anon_sym_int48] = ACTIONS(520),
    [anon_sym_int56] = ACTIONS(520),
    [anon_sym_int64] = ACTIONS(520),
    [anon_sym_int72] = ACTIONS(520),
    [anon_sym_int80] = ACTIONS(520),
    [anon_sym_int88] = ACTIONS(520),
    [anon_sym_int96] = ACTIONS(520),
    [anon_sym_int104] = ACTIONS(520),
    [anon_sym_int112] = ACTIONS(520),
    [anon_sym_int120] = ACTIONS(520),
    [anon_sym_int128] = ACTIONS(520),
    [anon_sym_int136] = ACTIONS(520),
    [anon_sym_int144] = ACTIONS(520),
    [anon_sym_int152] = ACTIONS(520),
    [anon_sym_int160] = ACTIONS(520),
    [anon_sym_int168] = ACTIONS(520),
    [anon_sym_int176] = ACTIONS(520),
    [anon_sym_int184] = ACTIONS(520),
    [anon_sym_int192] = ACTIONS(520),
    [anon_sym_int200] = ACTIONS(520),
    [anon_sym_int208] = ACTIONS(520),
    [anon_sym_int216] = ACTIONS(520),
    [anon_sym_int224] = ACTIONS(520),
    [anon_sym_int232] = ACTIONS(520),
    [anon_sym_int240] = ACTIONS(520),
    [anon_sym_int248] = ACTIONS(520),
    [anon_sym_int256] = ACTIONS(520),
    [anon_sym_uint] = ACTIONS(520),
    [anon_sym_uint8] = ACTIONS(520),
    [anon_sym_uint16] = ACTIONS(520),
    [anon_sym_uint24] = ACTIONS(520),
    [anon_sym_uint32] = ACTIONS(520),
    [anon_sym_uint40] = ACTIONS(520),
    [anon_sym_uint48] = ACTIONS(520),
    [anon_sym_uint56] = ACTIONS(520),
    [anon_sym_uint64] = ACTIONS(520),
    [anon_sym_uint72] = ACTIONS(520),
    [anon_sym_uint80] = ACTIONS(520),
    [anon_sym_uint88] = ACTIONS(520),
    [anon_sym_uint96] = ACTIONS(520),
    [anon_sym_uint104] = ACTIONS(520),
    [anon_sym_uint112] = ACTIONS(520),
    [anon_sym_uint120] = ACTIONS(520),
    [anon_sym_uint128] = ACTIONS(520),
    [anon_sym_uint136] = ACTIONS(520),
    [anon_sym_uint144] = ACTIONS(520),
    [anon_sym_uint152] = ACTIONS(520),
    [anon_sym_uint160] = ACTIONS(520),
    [anon_sym_uint168] = ACTIONS(520),
    [anon_sym_uint176] = ACTIONS(520),
    [anon_sym_uint184] = ACTIONS(520),
    [anon_sym_uint192] = ACTIONS(520),
    [anon_sym_uint200] = ACTIONS(520),
    [anon_sym_uint208] = ACTIONS(520),
    [anon_sym_uint216] = ACTIONS(520),
    [anon_sym_uint224] = ACTIONS(520),
    [anon_sym_uint232] = ACTIONS(520),
    [anon_sym_uint240] = ACTIONS(520),
    [anon_sym_uint248] = ACTIONS(520),
    [anon_sym_uint256] = ACTIONS(520),
    [anon_sym_bytes] = ACTIONS(520),
    [anon_sym_bytes1] = ACTIONS(520),
    [anon_sym_bytes2] = ACTIONS(520),
    [anon_sym_bytes3] = ACTIONS(520),
    [anon_sym_bytes4] = ACTIONS(520),
    [anon_sym_bytes5] = ACTIONS(520),
    [anon_sym_bytes6] = ACTIONS(520),
    [anon_sym_bytes7] = ACTIONS(520),
    [anon_sym_bytes8] = ACTIONS(520),
    [anon_sym_bytes9] = ACTIONS(520),
    [anon_sym_bytes10] = ACTIONS(520),
    [anon_sym_bytes11] = ACTIONS(520),
    [anon_sym_bytes12] = ACTIONS(520),
    [anon_sym_bytes13] = ACTIONS(520),
    [anon_sym_bytes14] = ACTIONS(520),
    [anon_sym_bytes15] = ACTIONS(520),
    [anon_sym_bytes16] = ACTIONS(520),
    [anon_sym_bytes17] = ACTIONS(520),
    [anon_sym_bytes18] = ACTIONS(520),
    [anon_sym_bytes19] = ACTIONS(520),
    [anon_sym_bytes20] = ACTIONS(520),
    [anon_sym_bytes21] = ACTIONS(520),
    [anon_sym_bytes22] = ACTIONS(520),
    [anon_sym_bytes23] = ACTIONS(520),
    [anon_sym_bytes24] = ACTIONS(520),
    [anon_sym_bytes25] = ACTIONS(520),
    [anon_sym_bytes26] = ACTIONS(520),
    [anon_sym_bytes27] = ACTIONS(520),
    [anon_sym_bytes28] = ACTIONS(520),
    [anon_sym_bytes29] = ACTIONS(520),
    [anon_sym_bytes30] = ACTIONS(520),
    [anon_sym_bytes31] = ACTIONS(520),
    [anon_sym_bytes32] = ACTIONS(520),
    [anon_sym_fixed] = ACTIONS(520),
    [aux_sym__fixed_token1] = ACTIONS(520),
    [anon_sym_ufixed] = ACTIONS(520),
    [aux_sym__ufixed_token1] = ACTIONS(520),
    [aux_sym__decimal_number_token1] = ACTIONS(520),
    [aux_sym__decimal_number_token2] = ACTIONS(522),
    [aux_sym__hex_number_token1] = ACTIONS(522),
    [anon_sym_hex] = ACTIONS(520),
    [anon_sym_DQUOTE] = ACTIONS(522),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_unicode] = ACTIONS(520),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_identifier] = ACTIONS(524),
    [anon_sym_DASH] = ACTIONS(524),
    [anon_sym_TILDE] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(526),
    [anon_sym_RBRACE] = ACTIONS(526),
    [anon_sym_type] = ACTIONS(524),
    [anon_sym_LPAREN] = ACTIONS(526),
    [anon_sym_for] = ACTIONS(524),
    [anon_sym_assembly] = ACTIONS(524),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(524),
    [anon_sym_true] = ACTIONS(524),
    [anon_sym_false] = ACTIONS(524),
    [anon_sym_if] = ACTIONS(524),
    [anon_sym_function] = ACTIONS(524),
    [anon_sym_byte] = ACTIONS(524),
    [anon_sym_address] = ACTIONS(524),
    [anon_sym_return] = ACTIONS(524),
    [anon_sym_revert] = ACTIONS(524),
    [sym__unchecked] = ACTIONS(524),
    [anon_sym_var] = ACTIONS(524),
    [anon_sym_else] = ACTIONS(524),
    [anon_sym_while] = ACTIONS(524),
    [anon_sym_do] = ACTIONS(524),
    [anon_sym_try] = ACTIONS(524),
    [anon_sym_emit] = ACTIONS(524),
    [anon_sym_payable] = ACTIONS(524),
    [anon_sym_new] = ACTIONS(524),
    [anon_sym_LBRACK] = ACTIONS(526),
    [anon_sym_PLUS] = ACTIONS(524),
    [anon_sym_BANG] = ACTIONS(526),
    [anon_sym_delete] = ACTIONS(524),
    [anon_sym_PLUS_PLUS] = ACTIONS(526),
    [anon_sym_DASH_DASH] = ACTIONS(526),
    [anon_sym_mapping] = ACTIONS(524),
    [anon_sym_bool] = ACTIONS(524),
    [anon_sym_string] = ACTIONS(524),
    [anon_sym_int] = ACTIONS(524),
    [anon_sym_int8] = ACTIONS(524),
    [anon_sym_int16] = ACTIONS(524),
    [anon_sym_int24] = ACTIONS(524),
    [anon_sym_int32] = ACTIONS(524),
    [anon_sym_int40] = ACTIONS(524),
    [anon_sym_int48] = ACTIONS(524),
    [anon_sym_int56] = ACTIONS(524),
    [anon_sym_int64] = ACTIONS(524),
    [anon_sym_int72] = ACTIONS(524),
    [anon_sym_int80] = ACTIONS(524),
    [anon_sym_int88] = ACTIONS(524),
    [anon_sym_int96] = ACTIONS(524),
    [anon_sym_int104] = ACTIONS(524),
    [anon_sym_int112] = ACTIONS(524),
    [anon_sym_int120] = ACTIONS(524),
    [anon_sym_int128] = ACTIONS(524),
    [anon_sym_int136] = ACTIONS(524),
    [anon_sym_int144] = ACTIONS(524),
    [anon_sym_int152] = ACTIONS(524),
    [anon_sym_int160] = ACTIONS(524),
    [anon_sym_int168] = ACTIONS(524),
    [anon_sym_int176] = ACTIONS(524),
    [anon_sym_int184] = ACTIONS(524),
    [anon_sym_int192] = ACTIONS(524),
    [anon_sym_int200] = ACTIONS(524),
    [anon_sym_int208] = ACTIONS(524),
    [anon_sym_int216] = ACTIONS(524),
    [anon_sym_int224] = ACTIONS(524),
    [anon_sym_int232] = ACTIONS(524),
    [anon_sym_int240] = ACTIONS(524),
    [anon_sym_int248] = ACTIONS(524),
    [anon_sym_int256] = ACTIONS(524),
    [anon_sym_uint] = ACTIONS(524),
    [anon_sym_uint8] = ACTIONS(524),
    [anon_sym_uint16] = ACTIONS(524),
    [anon_sym_uint24] = ACTIONS(524),
    [anon_sym_uint32] = ACTIONS(524),
    [anon_sym_uint40] = ACTIONS(524),
    [anon_sym_uint48] = ACTIONS(524),
    [anon_sym_uint56] = ACTIONS(524),
    [anon_sym_uint64] = ACTIONS(524),
    [anon_sym_uint72] = ACTIONS(524),
    [anon_sym_uint80] = ACTIONS(524),
    [anon_sym_uint88] = ACTIONS(524),
    [anon_sym_uint96] = ACTIONS(524),
    [anon_sym_uint104] = ACTIONS(524),
    [anon_sym_uint112] = ACTIONS(524),
    [anon_sym_uint120] = ACTIONS(524),
    [anon_sym_uint128] = ACTIONS(524),
    [anon_sym_uint136] = ACTIONS(524),
    [anon_sym_uint144] = ACTIONS(524),
    [anon_sym_uint152] = ACTIONS(524),
    [anon_sym_uint160] = ACTIONS(524),
    [anon_sym_uint168] = ACTIONS(524),
    [anon_sym_uint176] = ACTIONS(524),
    [anon_sym_uint184] = ACTIONS(524),
    [anon_sym_uint192] = ACTIONS(524),
    [anon_sym_uint200] = ACTIONS(524),
    [anon_sym_uint208] = ACTIONS(524),
    [anon_sym_uint216] = ACTIONS(524),
    [anon_sym_uint224] = ACTIONS(524),
    [anon_sym_uint232] = ACTIONS(524),
    [anon_sym_uint240] = ACTIONS(524),
    [anon_sym_uint248] = ACTIONS(524),
    [anon_sym_uint256] = ACTIONS(524),
    [anon_sym_bytes] = ACTIONS(524),
    [anon_sym_bytes1] = ACTIONS(524),
    [anon_sym_bytes2] = ACTIONS(524),
    [anon_sym_bytes3] = ACTIONS(524),
    [anon_sym_bytes4] = ACTIONS(524),
    [anon_sym_bytes5] = ACTIONS(524),
    [anon_sym_bytes6] = ACTIONS(524),
    [anon_sym_bytes7] = ACTIONS(524),
    [anon_sym_bytes8] = ACTIONS(524),
    [anon_sym_bytes9] = ACTIONS(524),
    [anon_sym_bytes10] = ACTIONS(524),
    [anon_sym_bytes11] = ACTIONS(524),
    [anon_sym_bytes12] = ACTIONS(524),
    [anon_sym_bytes13] = ACTIONS(524),
    [anon_sym_bytes14] = ACTIONS(524),
    [anon_sym_bytes15] = ACTIONS(524),
    [anon_sym_bytes16] = ACTIONS(524),
    [anon_sym_bytes17] = ACTIONS(524),
    [anon_sym_bytes18] = ACTIONS(524),
    [anon_sym_bytes19] = ACTIONS(524),
    [anon_sym_bytes20] = ACTIONS(524),
    [anon_sym_bytes21] = ACTIONS(524),
    [anon_sym_bytes22] = ACTIONS(524),
    [anon_sym_bytes23] = ACTIONS(524),
    [anon_sym_bytes24] = ACTIONS(524),
    [anon_sym_bytes25] = ACTIONS(524),
    [anon_sym_bytes26] = ACTIONS(524),
    [anon_sym_bytes27] = ACTIONS(524),
    [anon_sym_bytes28] = ACTIONS(524),
    [anon_sym_bytes29] = ACTIONS(524),
    [anon_sym_bytes30] = ACTIONS(524),
    [anon_sym_bytes31] = ACTIONS(524),
    [anon_sym_bytes32] = ACTIONS(524),
    [anon_sym_fixed] = ACTIONS(524),
    [aux_sym__fixed_token1] = ACTIONS(524),
    [anon_sym_ufixed] = ACTIONS(524),
    [aux_sym__ufixed_token1] = ACTIONS(524),
    [aux_sym__decimal_number_token1] = ACTIONS(524),
    [aux_sym__decimal_number_token2] = ACTIONS(526),
    [aux_sym__hex_number_token1] = ACTIONS(526),
    [anon_sym_hex] = ACTIONS(524),
    [anon_sym_DQUOTE] = ACTIONS(526),
    [anon_sym_SQUOTE] = ACTIONS(526),
    [anon_sym_unicode] = ACTIONS(524),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_identifier] = ACTIONS(528),
    [anon_sym_DASH] = ACTIONS(528),
    [anon_sym_TILDE] = ACTIONS(530),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_type] = ACTIONS(528),
    [anon_sym_LPAREN] = ACTIONS(530),
    [anon_sym_for] = ACTIONS(528),
    [anon_sym_assembly] = ACTIONS(528),
    [anon_sym_break] = ACTIONS(528),
    [anon_sym_continue] = ACTIONS(528),
    [anon_sym_true] = ACTIONS(528),
    [anon_sym_false] = ACTIONS(528),
    [anon_sym_if] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(528),
    [anon_sym_byte] = ACTIONS(528),
    [anon_sym_address] = ACTIONS(528),
    [anon_sym_return] = ACTIONS(528),
    [anon_sym_revert] = ACTIONS(528),
    [sym__unchecked] = ACTIONS(528),
    [anon_sym_var] = ACTIONS(528),
    [anon_sym_else] = ACTIONS(528),
    [anon_sym_while] = ACTIONS(528),
    [anon_sym_do] = ACTIONS(528),
    [anon_sym_try] = ACTIONS(528),
    [anon_sym_emit] = ACTIONS(528),
    [anon_sym_payable] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(528),
    [anon_sym_LBRACK] = ACTIONS(530),
    [anon_sym_PLUS] = ACTIONS(528),
    [anon_sym_BANG] = ACTIONS(530),
    [anon_sym_delete] = ACTIONS(528),
    [anon_sym_PLUS_PLUS] = ACTIONS(530),
    [anon_sym_DASH_DASH] = ACTIONS(530),
    [anon_sym_mapping] = ACTIONS(528),
    [anon_sym_bool] = ACTIONS(528),
    [anon_sym_string] = ACTIONS(528),
    [anon_sym_int] = ACTIONS(528),
    [anon_sym_int8] = ACTIONS(528),
    [anon_sym_int16] = ACTIONS(528),
    [anon_sym_int24] = ACTIONS(528),
    [anon_sym_int32] = ACTIONS(528),
    [anon_sym_int40] = ACTIONS(528),
    [anon_sym_int48] = ACTIONS(528),
    [anon_sym_int56] = ACTIONS(528),
    [anon_sym_int64] = ACTIONS(528),
    [anon_sym_int72] = ACTIONS(528),
    [anon_sym_int80] = ACTIONS(528),
    [anon_sym_int88] = ACTIONS(528),
    [anon_sym_int96] = ACTIONS(528),
    [anon_sym_int104] = ACTIONS(528),
    [anon_sym_int112] = ACTIONS(528),
    [anon_sym_int120] = ACTIONS(528),
    [anon_sym_int128] = ACTIONS(528),
    [anon_sym_int136] = ACTIONS(528),
    [anon_sym_int144] = ACTIONS(528),
    [anon_sym_int152] = ACTIONS(528),
    [anon_sym_int160] = ACTIONS(528),
    [anon_sym_int168] = ACTIONS(528),
    [anon_sym_int176] = ACTIONS(528),
    [anon_sym_int184] = ACTIONS(528),
    [anon_sym_int192] = ACTIONS(528),
    [anon_sym_int200] = ACTIONS(528),
    [anon_sym_int208] = ACTIONS(528),
    [anon_sym_int216] = ACTIONS(528),
    [anon_sym_int224] = ACTIONS(528),
    [anon_sym_int232] = ACTIONS(528),
    [anon_sym_int240] = ACTIONS(528),
    [anon_sym_int248] = ACTIONS(528),
    [anon_sym_int256] = ACTIONS(528),
    [anon_sym_uint] = ACTIONS(528),
    [anon_sym_uint8] = ACTIONS(528),
    [anon_sym_uint16] = ACTIONS(528),
    [anon_sym_uint24] = ACTIONS(528),
    [anon_sym_uint32] = ACTIONS(528),
    [anon_sym_uint40] = ACTIONS(528),
    [anon_sym_uint48] = ACTIONS(528),
    [anon_sym_uint56] = ACTIONS(528),
    [anon_sym_uint64] = ACTIONS(528),
    [anon_sym_uint72] = ACTIONS(528),
    [anon_sym_uint80] = ACTIONS(528),
    [anon_sym_uint88] = ACTIONS(528),
    [anon_sym_uint96] = ACTIONS(528),
    [anon_sym_uint104] = ACTIONS(528),
    [anon_sym_uint112] = ACTIONS(528),
    [anon_sym_uint120] = ACTIONS(528),
    [anon_sym_uint128] = ACTIONS(528),
    [anon_sym_uint136] = ACTIONS(528),
    [anon_sym_uint144] = ACTIONS(528),
    [anon_sym_uint152] = ACTIONS(528),
    [anon_sym_uint160] = ACTIONS(528),
    [anon_sym_uint168] = ACTIONS(528),
    [anon_sym_uint176] = ACTIONS(528),
    [anon_sym_uint184] = ACTIONS(528),
    [anon_sym_uint192] = ACTIONS(528),
    [anon_sym_uint200] = ACTIONS(528),
    [anon_sym_uint208] = ACTIONS(528),
    [anon_sym_uint216] = ACTIONS(528),
    [anon_sym_uint224] = ACTIONS(528),
    [anon_sym_uint232] = ACTIONS(528),
    [anon_sym_uint240] = ACTIONS(528),
    [anon_sym_uint248] = ACTIONS(528),
    [anon_sym_uint256] = ACTIONS(528),
    [anon_sym_bytes] = ACTIONS(528),
    [anon_sym_bytes1] = ACTIONS(528),
    [anon_sym_bytes2] = ACTIONS(528),
    [anon_sym_bytes3] = ACTIONS(528),
    [anon_sym_bytes4] = ACTIONS(528),
    [anon_sym_bytes5] = ACTIONS(528),
    [anon_sym_bytes6] = ACTIONS(528),
    [anon_sym_bytes7] = ACTIONS(528),
    [anon_sym_bytes8] = ACTIONS(528),
    [anon_sym_bytes9] = ACTIONS(528),
    [anon_sym_bytes10] = ACTIONS(528),
    [anon_sym_bytes11] = ACTIONS(528),
    [anon_sym_bytes12] = ACTIONS(528),
    [anon_sym_bytes13] = ACTIONS(528),
    [anon_sym_bytes14] = ACTIONS(528),
    [anon_sym_bytes15] = ACTIONS(528),
    [anon_sym_bytes16] = ACTIONS(528),
    [anon_sym_bytes17] = ACTIONS(528),
    [anon_sym_bytes18] = ACTIONS(528),
    [anon_sym_bytes19] = ACTIONS(528),
    [anon_sym_bytes20] = ACTIONS(528),
    [anon_sym_bytes21] = ACTIONS(528),
    [anon_sym_bytes22] = ACTIONS(528),
    [anon_sym_bytes23] = ACTIONS(528),
    [anon_sym_bytes24] = ACTIONS(528),
    [anon_sym_bytes25] = ACTIONS(528),
    [anon_sym_bytes26] = ACTIONS(528),
    [anon_sym_bytes27] = ACTIONS(528),
    [anon_sym_bytes28] = ACTIONS(528),
    [anon_sym_bytes29] = ACTIONS(528),
    [anon_sym_bytes30] = ACTIONS(528),
    [anon_sym_bytes31] = ACTIONS(528),
    [anon_sym_bytes32] = ACTIONS(528),
    [anon_sym_fixed] = ACTIONS(528),
    [aux_sym__fixed_token1] = ACTIONS(528),
    [anon_sym_ufixed] = ACTIONS(528),
    [aux_sym__ufixed_token1] = ACTIONS(528),
    [aux_sym__decimal_number_token1] = ACTIONS(528),
    [aux_sym__decimal_number_token2] = ACTIONS(530),
    [aux_sym__hex_number_token1] = ACTIONS(530),
    [anon_sym_hex] = ACTIONS(528),
    [anon_sym_DQUOTE] = ACTIONS(530),
    [anon_sym_SQUOTE] = ACTIONS(530),
    [anon_sym_unicode] = ACTIONS(528),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_identifier] = ACTIONS(532),
    [anon_sym_DASH] = ACTIONS(532),
    [anon_sym_TILDE] = ACTIONS(534),
    [anon_sym_LBRACE] = ACTIONS(534),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_type] = ACTIONS(532),
    [anon_sym_LPAREN] = ACTIONS(534),
    [anon_sym_for] = ACTIONS(532),
    [anon_sym_assembly] = ACTIONS(532),
    [anon_sym_break] = ACTIONS(532),
    [anon_sym_continue] = ACTIONS(532),
    [anon_sym_true] = ACTIONS(532),
    [anon_sym_false] = ACTIONS(532),
    [anon_sym_if] = ACTIONS(532),
    [anon_sym_function] = ACTIONS(532),
    [anon_sym_byte] = ACTIONS(532),
    [anon_sym_address] = ACTIONS(532),
    [anon_sym_return] = ACTIONS(532),
    [anon_sym_revert] = ACTIONS(532),
    [sym__unchecked] = ACTIONS(532),
    [anon_sym_var] = ACTIONS(532),
    [anon_sym_else] = ACTIONS(532),
    [anon_sym_while] = ACTIONS(532),
    [anon_sym_do] = ACTIONS(532),
    [anon_sym_try] = ACTIONS(532),
    [anon_sym_emit] = ACTIONS(532),
    [anon_sym_payable] = ACTIONS(532),
    [anon_sym_new] = ACTIONS(532),
    [anon_sym_LBRACK] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(532),
    [anon_sym_BANG] = ACTIONS(534),
    [anon_sym_delete] = ACTIONS(532),
    [anon_sym_PLUS_PLUS] = ACTIONS(534),
    [anon_sym_DASH_DASH] = ACTIONS(534),
    [anon_sym_mapping] = ACTIONS(532),
    [anon_sym_bool] = ACTIONS(532),
    [anon_sym_string] = ACTIONS(532),
    [anon_sym_int] = ACTIONS(532),
    [anon_sym_int8] = ACTIONS(532),
    [anon_sym_int16] = ACTIONS(532),
    [anon_sym_int24] = ACTIONS(532),
    [anon_sym_int32] = ACTIONS(532),
    [anon_sym_int40] = ACTIONS(532),
    [anon_sym_int48] = ACTIONS(532),
    [anon_sym_int56] = ACTIONS(532),
    [anon_sym_int64] = ACTIONS(532),
    [anon_sym_int72] = ACTIONS(532),
    [anon_sym_int80] = ACTIONS(532),
    [anon_sym_int88] = ACTIONS(532),
    [anon_sym_int96] = ACTIONS(532),
    [anon_sym_int104] = ACTIONS(532),
    [anon_sym_int112] = ACTIONS(532),
    [anon_sym_int120] = ACTIONS(532),
    [anon_sym_int128] = ACTIONS(532),
    [anon_sym_int136] = ACTIONS(532),
    [anon_sym_int144] = ACTIONS(532),
    [anon_sym_int152] = ACTIONS(532),
    [anon_sym_int160] = ACTIONS(532),
    [anon_sym_int168] = ACTIONS(532),
    [anon_sym_int176] = ACTIONS(532),
    [anon_sym_int184] = ACTIONS(532),
    [anon_sym_int192] = ACTIONS(532),
    [anon_sym_int200] = ACTIONS(532),
    [anon_sym_int208] = ACTIONS(532),
    [anon_sym_int216] = ACTIONS(532),
    [anon_sym_int224] = ACTIONS(532),
    [anon_sym_int232] = ACTIONS(532),
    [anon_sym_int240] = ACTIONS(532),
    [anon_sym_int248] = ACTIONS(532),
    [anon_sym_int256] = ACTIONS(532),
    [anon_sym_uint] = ACTIONS(532),
    [anon_sym_uint8] = ACTIONS(532),
    [anon_sym_uint16] = ACTIONS(532),
    [anon_sym_uint24] = ACTIONS(532),
    [anon_sym_uint32] = ACTIONS(532),
    [anon_sym_uint40] = ACTIONS(532),
    [anon_sym_uint48] = ACTIONS(532),
    [anon_sym_uint56] = ACTIONS(532),
    [anon_sym_uint64] = ACTIONS(532),
    [anon_sym_uint72] = ACTIONS(532),
    [anon_sym_uint80] = ACTIONS(532),
    [anon_sym_uint88] = ACTIONS(532),
    [anon_sym_uint96] = ACTIONS(532),
    [anon_sym_uint104] = ACTIONS(532),
    [anon_sym_uint112] = ACTIONS(532),
    [anon_sym_uint120] = ACTIONS(532),
    [anon_sym_uint128] = ACTIONS(532),
    [anon_sym_uint136] = ACTIONS(532),
    [anon_sym_uint144] = ACTIONS(532),
    [anon_sym_uint152] = ACTIONS(532),
    [anon_sym_uint160] = ACTIONS(532),
    [anon_sym_uint168] = ACTIONS(532),
    [anon_sym_uint176] = ACTIONS(532),
    [anon_sym_uint184] = ACTIONS(532),
    [anon_sym_uint192] = ACTIONS(532),
    [anon_sym_uint200] = ACTIONS(532),
    [anon_sym_uint208] = ACTIONS(532),
    [anon_sym_uint216] = ACTIONS(532),
    [anon_sym_uint224] = ACTIONS(532),
    [anon_sym_uint232] = ACTIONS(532),
    [anon_sym_uint240] = ACTIONS(532),
    [anon_sym_uint248] = ACTIONS(532),
    [anon_sym_uint256] = ACTIONS(532),
    [anon_sym_bytes] = ACTIONS(532),
    [anon_sym_bytes1] = ACTIONS(532),
    [anon_sym_bytes2] = ACTIONS(532),
    [anon_sym_bytes3] = ACTIONS(532),
    [anon_sym_bytes4] = ACTIONS(532),
    [anon_sym_bytes5] = ACTIONS(532),
    [anon_sym_bytes6] = ACTIONS(532),
    [anon_sym_bytes7] = ACTIONS(532),
    [anon_sym_bytes8] = ACTIONS(532),
    [anon_sym_bytes9] = ACTIONS(532),
    [anon_sym_bytes10] = ACTIONS(532),
    [anon_sym_bytes11] = ACTIONS(532),
    [anon_sym_bytes12] = ACTIONS(532),
    [anon_sym_bytes13] = ACTIONS(532),
    [anon_sym_bytes14] = ACTIONS(532),
    [anon_sym_bytes15] = ACTIONS(532),
    [anon_sym_bytes16] = ACTIONS(532),
    [anon_sym_bytes17] = ACTIONS(532),
    [anon_sym_bytes18] = ACTIONS(532),
    [anon_sym_bytes19] = ACTIONS(532),
    [anon_sym_bytes20] = ACTIONS(532),
    [anon_sym_bytes21] = ACTIONS(532),
    [anon_sym_bytes22] = ACTIONS(532),
    [anon_sym_bytes23] = ACTIONS(532),
    [anon_sym_bytes24] = ACTIONS(532),
    [anon_sym_bytes25] = ACTIONS(532),
    [anon_sym_bytes26] = ACTIONS(532),
    [anon_sym_bytes27] = ACTIONS(532),
    [anon_sym_bytes28] = ACTIONS(532),
    [anon_sym_bytes29] = ACTIONS(532),
    [anon_sym_bytes30] = ACTIONS(532),
    [anon_sym_bytes31] = ACTIONS(532),
    [anon_sym_bytes32] = ACTIONS(532),
    [anon_sym_fixed] = ACTIONS(532),
    [aux_sym__fixed_token1] = ACTIONS(532),
    [anon_sym_ufixed] = ACTIONS(532),
    [aux_sym__ufixed_token1] = ACTIONS(532),
    [aux_sym__decimal_number_token1] = ACTIONS(532),
    [aux_sym__decimal_number_token2] = ACTIONS(534),
    [aux_sym__hex_number_token1] = ACTIONS(534),
    [anon_sym_hex] = ACTIONS(532),
    [anon_sym_DQUOTE] = ACTIONS(534),
    [anon_sym_SQUOTE] = ACTIONS(534),
    [anon_sym_unicode] = ACTIONS(532),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_struct_member] = STATE(109),
    [sym_type_name] = STATE(702),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_struct_declaration_repeat1] = STATE(109),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_variable_declaration] = STATE(685),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(538),
    [anon_sym_RPAREN] = ACTIONS(540),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_struct_member] = STATE(109),
    [sym_type_name] = STATE(702),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_struct_declaration_repeat1] = STATE(109),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_variable_declaration] = STATE(685),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(538),
    [anon_sym_RPAREN] = ACTIONS(544),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_variable_declaration] = STATE(685),
    [sym_type_name] = STATE(470),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(538),
    [anon_sym_RPAREN] = ACTIONS(538),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_struct_member] = STATE(109),
    [sym_type_name] = STATE(702),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [aux_sym_struct_declaration_repeat1] = STATE(109),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_RBRACE] = ACTIONS(549),
    [anon_sym_function] = ACTIONS(551),
    [anon_sym_byte] = ACTIONS(554),
    [anon_sym_address] = ACTIONS(557),
    [anon_sym_var] = ACTIONS(554),
    [anon_sym_mapping] = ACTIONS(560),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int24] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int40] = ACTIONS(554),
    [anon_sym_int48] = ACTIONS(554),
    [anon_sym_int56] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int72] = ACTIONS(554),
    [anon_sym_int80] = ACTIONS(554),
    [anon_sym_int88] = ACTIONS(554),
    [anon_sym_int96] = ACTIONS(554),
    [anon_sym_int104] = ACTIONS(554),
    [anon_sym_int112] = ACTIONS(554),
    [anon_sym_int120] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_int136] = ACTIONS(554),
    [anon_sym_int144] = ACTIONS(554),
    [anon_sym_int152] = ACTIONS(554),
    [anon_sym_int160] = ACTIONS(554),
    [anon_sym_int168] = ACTIONS(554),
    [anon_sym_int176] = ACTIONS(554),
    [anon_sym_int184] = ACTIONS(554),
    [anon_sym_int192] = ACTIONS(554),
    [anon_sym_int200] = ACTIONS(554),
    [anon_sym_int208] = ACTIONS(554),
    [anon_sym_int216] = ACTIONS(554),
    [anon_sym_int224] = ACTIONS(554),
    [anon_sym_int232] = ACTIONS(554),
    [anon_sym_int240] = ACTIONS(554),
    [anon_sym_int248] = ACTIONS(554),
    [anon_sym_int256] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint24] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint40] = ACTIONS(554),
    [anon_sym_uint48] = ACTIONS(554),
    [anon_sym_uint56] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint72] = ACTIONS(554),
    [anon_sym_uint80] = ACTIONS(554),
    [anon_sym_uint88] = ACTIONS(554),
    [anon_sym_uint96] = ACTIONS(554),
    [anon_sym_uint104] = ACTIONS(554),
    [anon_sym_uint112] = ACTIONS(554),
    [anon_sym_uint120] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_uint136] = ACTIONS(554),
    [anon_sym_uint144] = ACTIONS(554),
    [anon_sym_uint152] = ACTIONS(554),
    [anon_sym_uint160] = ACTIONS(554),
    [anon_sym_uint168] = ACTIONS(554),
    [anon_sym_uint176] = ACTIONS(554),
    [anon_sym_uint184] = ACTIONS(554),
    [anon_sym_uint192] = ACTIONS(554),
    [anon_sym_uint200] = ACTIONS(554),
    [anon_sym_uint208] = ACTIONS(554),
    [anon_sym_uint216] = ACTIONS(554),
    [anon_sym_uint224] = ACTIONS(554),
    [anon_sym_uint232] = ACTIONS(554),
    [anon_sym_uint240] = ACTIONS(554),
    [anon_sym_uint248] = ACTIONS(554),
    [anon_sym_uint256] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bytes1] = ACTIONS(554),
    [anon_sym_bytes2] = ACTIONS(554),
    [anon_sym_bytes3] = ACTIONS(554),
    [anon_sym_bytes4] = ACTIONS(554),
    [anon_sym_bytes5] = ACTIONS(554),
    [anon_sym_bytes6] = ACTIONS(554),
    [anon_sym_bytes7] = ACTIONS(554),
    [anon_sym_bytes8] = ACTIONS(554),
    [anon_sym_bytes9] = ACTIONS(554),
    [anon_sym_bytes10] = ACTIONS(554),
    [anon_sym_bytes11] = ACTIONS(554),
    [anon_sym_bytes12] = ACTIONS(554),
    [anon_sym_bytes13] = ACTIONS(554),
    [anon_sym_bytes14] = ACTIONS(554),
    [anon_sym_bytes15] = ACTIONS(554),
    [anon_sym_bytes16] = ACTIONS(554),
    [anon_sym_bytes17] = ACTIONS(554),
    [anon_sym_bytes18] = ACTIONS(554),
    [anon_sym_bytes19] = ACTIONS(554),
    [anon_sym_bytes20] = ACTIONS(554),
    [anon_sym_bytes21] = ACTIONS(554),
    [anon_sym_bytes22] = ACTIONS(554),
    [anon_sym_bytes23] = ACTIONS(554),
    [anon_sym_bytes24] = ACTIONS(554),
    [anon_sym_bytes25] = ACTIONS(554),
    [anon_sym_bytes26] = ACTIONS(554),
    [anon_sym_bytes27] = ACTIONS(554),
    [anon_sym_bytes28] = ACTIONS(554),
    [anon_sym_bytes29] = ACTIONS(554),
    [anon_sym_bytes30] = ACTIONS(554),
    [anon_sym_bytes31] = ACTIONS(554),
    [anon_sym_bytes32] = ACTIONS(554),
    [anon_sym_fixed] = ACTIONS(554),
    [aux_sym__fixed_token1] = ACTIONS(554),
    [anon_sym_ufixed] = ACTIONS(554),
    [aux_sym__ufixed_token1] = ACTIONS(554),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_event_paramater] = STATE(522),
    [sym_type_name] = STATE(474),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(563),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_any_source_type] = STATE(778),
    [sym_type_name] = STATE(660),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(565),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_type_name] = STATE(460),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_parameter] = STATE(619),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(567),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_type_name] = STATE(460),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_parameter] = STATE(644),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(569),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_type_name] = STATE(464),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym__nameless_parameter] = STATE(665),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(571),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_type_name] = STATE(460),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_parameter] = STATE(644),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(573),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_error_parameter] = STATE(572),
    [sym_type_name] = STATE(508),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(575),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_error_parameter] = STATE(688),
    [sym_type_name] = STATE(508),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(577),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_event_paramater] = STATE(664),
    [sym_type_name] = STATE(474),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(579),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym_type_name] = STATE(464),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym__nameless_parameter] = STATE(665),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(581),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [anon_sym_bytes] = ACTIONS(31),
    [anon_sym_bytes1] = ACTIONS(31),
    [anon_sym_bytes2] = ACTIONS(31),
    [anon_sym_bytes3] = ACTIONS(31),
    [anon_sym_bytes4] = ACTIONS(31),
    [anon_sym_bytes5] = ACTIONS(31),
    [anon_sym_bytes6] = ACTIONS(31),
    [anon_sym_bytes7] = ACTIONS(31),
    [anon_sym_bytes8] = ACTIONS(31),
    [anon_sym_bytes9] = ACTIONS(31),
    [anon_sym_bytes10] = ACTIONS(31),
    [anon_sym_bytes11] = ACTIONS(31),
    [anon_sym_bytes12] = ACTIONS(31),
    [anon_sym_bytes13] = ACTIONS(31),
    [anon_sym_bytes14] = ACTIONS(31),
    [anon_sym_bytes15] = ACTIONS(31),
    [anon_sym_bytes16] = ACTIONS(31),
    [anon_sym_bytes17] = ACTIONS(31),
    [anon_sym_bytes18] = ACTIONS(31),
    [anon_sym_bytes19] = ACTIONS(31),
    [anon_sym_bytes20] = ACTIONS(31),
    [anon_sym_bytes21] = ACTIONS(31),
    [anon_sym_bytes22] = ACTIONS(31),
    [anon_sym_bytes23] = ACTIONS(31),
    [anon_sym_bytes24] = ACTIONS(31),
    [anon_sym_bytes25] = ACTIONS(31),
    [anon_sym_bytes26] = ACTIONS(31),
    [anon_sym_bytes27] = ACTIONS(31),
    [anon_sym_bytes28] = ACTIONS(31),
    [anon_sym_bytes29] = ACTIONS(31),
    [anon_sym_bytes30] = ACTIONS(31),
    [anon_sym_bytes31] = ACTIONS(31),
    [anon_sym_bytes32] = ACTIONS(31),
    [anon_sym_fixed] = ACTIONS(31),
    [aux_sym__fixed_token1] = ACTIONS(31),
    [anon_sym_ufixed] = ACTIONS(31),
    [aux_sym__ufixed_token1] = ACTIONS(31),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_error_parameter] = STATE(688),
    [sym_type_name] = STATE(508),
    [sym__array_type] = STATE(321),
    [sym__function_type] = STATE(323),
    [sym_user_defined_type] = STATE(321),
    [sym__identifier_path] = STATE(308),
    [sym__mapping] = STATE(317),
    [sym_primitive_type] = STATE(321),
    [sym__int] = STATE(309),
    [sym__uint] = STATE(309),
    [sym__bytes] = STATE(309),
    [sym__fixed] = STATE(309),
    [sym__ufixed] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(583),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_byte] = ACTIONS(31),
    [anon_sym_address] = ACTIONS(33),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_mapping] = ACTIONS(35),
    [anon_sym_bool] = ACTIONS(31),
    [anon_sym_string] = ACTIONS(31),
    [anon_sym_int] = ACTIONS(31),
    [anon_sym_int8] = ACTIONS(31),
    [anon_sym_int16] = ACTIONS(31),
    [anon_sym_int24] = ACTIONS(31),
    [anon_sym_int32] = ACTIONS(31),
    [anon_sym_int40] = ACTIONS(31),
    [anon_sym_int48] = ACTIONS(31),
    [anon_sym_int56] = ACTIONS(31),
    [anon_sym_int64] = ACTIONS(31),
    [anon_sym_int72] = ACTIONS(31),
    [anon_sym_int80] = ACTIONS(31),
    [anon_sym_int88] = ACTIONS(31),
    [anon_sym_int96] = ACTIONS(31),
    [anon_sym_int104] = ACTIONS(31),
    [anon_sym_int112] = ACTIONS(31),
    [anon_sym_int120] = ACTIONS(31),
    [anon_sym_int128] = ACTIONS(31),
    [anon_sym_int136] = ACTIONS(31),
    [anon_sym_int144] = ACTIONS(31),
    [anon_sym_int152] = ACTIONS(31),
    [anon_sym_int160] = ACTIONS(31),
    [anon_sym_int168] = ACTIONS(31),
    [anon_sym_int176] = ACTIONS(31),
    [anon_sym_int184] = ACTIONS(31),
    [anon_sym_int192] = ACTIONS(31),
    [anon_sym_int200] = ACTIONS(31),
    [anon_sym_int208] = ACTIONS(31),
    [anon_sym_int216] = ACTIONS(31),
    [anon_sym_int224] = ACTIONS(31),
    [anon_sym_int232] = ACTIONS(31),
    [anon_sym_int240] = ACTIONS(31),
    [anon_sym_int248] = ACTIONS(31),
    [anon_sym_int256] = ACTIONS(31),
    [anon_sym_uint] = ACTIONS(31),
    [anon_sym_uint8] = ACTIONS(31),
    [anon_sym_uint16] = ACTIONS(31),
    [anon_sym_uint24] = ACTIONS(31),
    [anon_sym_uint32] = ACTIONS(31),
    [anon_sym_uint40] = ACTIONS(31),
    [anon_sym_uint48] = ACTIONS(31),
    [anon_sym_uint56] = ACTIONS(31),
    [anon_sym_uint64] = ACTIONS(31),
    [anon_sym_uint72] = ACTIONS(31),
    [anon_sym_uint80] = ACTIONS(31),
    [anon_sym_uint88] = ACTIONS(31),
    [anon_sym_uint96] = ACTIONS(31),
    [anon_sym_uint104] = ACTIONS(31),
    [anon_sym_uint112] = ACTIONS(31),
    [anon_sym_uint120] = ACTIONS(31),
    [anon_sym_uint128] = ACTIONS(31),
    [anon_sym_uint136] = ACTIONS(31),
    [anon_sym_uint144] = ACTIONS(31),
    [anon_sym_uint152] = ACTIONS(31),
    [anon_sym_uint160] = ACTIONS(31),
    [anon_sym_uint168] = ACTIONS(31),
    [anon_sym_uint176] = ACTIONS(31),
    [anon_sym_uint184] = ACTIONS(31),
    [anon_sym_uint192] = ACTIONS(31),
    [anon_sym_uint200] = ACTIONS(31),
    [anon_sym_uint208] = ACTIONS(31),
    [anon_sym_uint216] = ACTIONS(31),
    [anon_sym_uint224] = ACTIONS(31),
    [anon_sym_uint232] = ACTIONS(31),
    [anon_sym_uint240] = ACTIONS(31),
    [anon_sym_uint248] = ACTIONS(31),
    [anon_sym_uint256] = ACTIONS(31),
    [ano