/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.issuesCollection;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Issue;
import org.jfrog.build.api.IssueTracker;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.IssuesCollectionConfig;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryBuildInfoClientBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.executor.CommandExecutor;
import org.jfrog.build.extractor.executor.CommandResults;

public class IssuesCollector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LATEST = "LATEST";
    private static final String GIT_LOG_LIMIT = "100";

    public Issues collectIssues(File execDir, Log logger, String config, ArtifactoryBuildInfoClientBuilder clientBuilder, String buildName, Vcs vcs) throws InterruptedException, IOException {
        IssuesCollectionConfig parsedConfig = this.parseConfig(config);
        String previousVcsRevision = this.getPreviousVcsRevision(clientBuilder, buildName, vcs);
        Set<Issue> affectedIssues = this.doCollect(execDir, logger, parsedConfig, previousVcsRevision);
        return this.buildIssuesObject(parsedConfig, affectedIssues);
    }

    IssuesCollectionConfig parseConfig(String config) throws IOException {
        IssuesCollectionConfig parsedConfig;
        config = config.replace("\\", "\\\\");
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        try {
            parsedConfig = mapper.readValue(config, IssuesCollectionConfig.class);
        }
        catch (Exception e) {
            throw new IOException("Issues Collection Failed: Failed parsing config: " + e.getMessage());
        }
        parsedConfig.validateConfig();
        return parsedConfig;
    }

    private String getPreviousVcsRevision(ArtifactoryBuildInfoClientBuilder clientBuilder, String prevBuildName, Vcs prevVcs) throws IOException {
        try (ArtifactoryBuildInfoClient client = clientBuilder.build();){
            Build previousBuildInfo = client.getBuildInfo(prevBuildName, LATEST);
            if (previousBuildInfo == null) {
                String string = "";
                return string;
            }
            List<Vcs> vcsList = previousBuildInfo.getVcs();
            if (vcsList != null && vcsList.size() > 0) {
                for (Vcs curVcs : previousBuildInfo.getVcs()) {
                    if (!StringUtils.isNotEmpty(curVcs.getRevision()) || !StringUtils.equals(curVcs.getUrl(), prevVcs.getUrl())) continue;
                    String string = curVcs.getRevision();
                    return string;
                }
            }
            String string = "";
            return string;
        }
    }

    private Set<Issue> doCollect(File execDir, Log logger, IssuesCollectionConfig issuesConfig, String previousVcsRevision) throws InterruptedException, IOException {
        String[] lines;
        String gitLog = this.getGitLog(execDir, logger, previousVcsRevision);
        int keyIndex = issuesConfig.getIssues().getKeyGroupIndex();
        int summaryIndex = issuesConfig.getIssues().getSummaryGroupIndex();
        HashSet<Issue> affectedIssues = new HashSet<Issue>();
        Pattern pattern = Pattern.compile(issuesConfig.getIssues().getRegexp());
        for (String line : lines = gitLog.split("\\R")) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            Issue foundIssue = this.getMatchingIssue(keyIndex, summaryIndex, matcher, issuesConfig);
            affectedIssues.add(foundIssue);
            logger.info("Added issue: " + foundIssue.getKey() + " to the build-info");
        }
        return affectedIssues;
    }

    private Issues buildIssuesObject(IssuesCollectionConfig parsedConfig, Set<Issue> affectedIssues) {
        IssueTracker tracker = new IssueTracker(parsedConfig.getIssues().getTrackerName());
        boolean aggregateBuildIssues = parsedConfig.getIssues().isAggregate();
        String aggregationBuildStatus = parsedConfig.getIssues().getAggregationStatus();
        return new Issues(tracker, aggregateBuildIssues, aggregationBuildStatus, affectedIssues);
    }

    private Issue getMatchingIssue(int keyIndex, int summaryIndex, Matcher matcher, IssuesCollectionConfig issuesConfig) throws IOException {
        if (matcher.groupCount() < keyIndex || matcher.groupCount() < summaryIndex) {
            throw new IOException("Issues Collection Failed: Unexpected result while parsing issues from git log. Make sure that the regular expression used to find issues, includes two capturing groups, for the issue ID and the summary.");
        }
        String key = matcher.group(keyIndex);
        String summary = matcher.group(summaryIndex);
        String url = "";
        if (StringUtils.isNotEmpty(issuesConfig.getIssues().getTrackerUrl())) {
            url = issuesConfig.getIssues().getTrackerUrl() + "/" + key;
        }
        return new Issue(key, url, summary);
    }

    private String getGitLog(File execDir, Log logger, String previousVcsRevision) throws InterruptedException, IOException {
        CommandExecutor commandExecutor;
        CommandResults res;
        ArrayList<String> args = new ArrayList<String>();
        args.add("log");
        args.add("--pretty=format:%s");
        args.add("-100");
        if (!previousVcsRevision.isEmpty()) {
            args.add(previousVcsRevision + "..");
        }
        if (!(res = (commandExecutor = new CommandExecutor("git", null)).exeCommand(execDir, args, logger)).isOk()) {
            throw new IOException("Issues Collection Failed: Git log command failed: " + res.getErr());
        }
        return res.getRes();
    }
}

