// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/timeseriesinsights/v1/timeseries_insights.proto

#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/timeseriesinsights/v1/timeseries_insights.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace timeseriesinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TimeseriesInsightsControllerStub::~TimeseriesInsightsControllerStub() = default;

StatusOr<google::cloud::timeseriesinsights::v1::ListDataSetsResponse>
DefaultTimeseriesInsightsControllerStub::ListDataSets(
    grpc::ClientContext& context, Options const&,
    google::cloud::timeseriesinsights::v1::ListDataSetsRequest const& request) {
  google::cloud::timeseriesinsights::v1::ListDataSetsResponse response;
  auto status = grpc_stub_->ListDataSets(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::timeseriesinsights::v1::DataSet>
DefaultTimeseriesInsightsControllerStub::CreateDataSet(
    grpc::ClientContext& context, Options const&,
    google::cloud::timeseriesinsights::v1::CreateDataSetRequest const&
        request) {
  google::cloud::timeseriesinsights::v1::DataSet response;
  auto status = grpc_stub_->CreateDataSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultTimeseriesInsightsControllerStub::DeleteDataSet(
    grpc::ClientContext& context, Options const&,
    google::cloud::timeseriesinsights::v1::DeleteDataSetRequest const&
        request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteDataSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::timeseriesinsights::v1::AppendEventsResponse>
DefaultTimeseriesInsightsControllerStub::AppendEvents(
    grpc::ClientContext& context, Options const&,
    google::cloud::timeseriesinsights::v1::AppendEventsRequest const& request) {
  google::cloud::timeseriesinsights::v1::AppendEventsResponse response;
  auto status = grpc_stub_->AppendEvents(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::timeseriesinsights::v1::QueryDataSetResponse>
DefaultTimeseriesInsightsControllerStub::QueryDataSet(
    grpc::ClientContext& context, Options const&,
    google::cloud::timeseriesinsights::v1::QueryDataSetRequest const& request) {
  google::cloud::timeseriesinsights::v1::QueryDataSetResponse response;
  auto status = grpc_stub_->QueryDataSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
DefaultTimeseriesInsightsControllerStub::EvaluateSlice(
    grpc::ClientContext& context, Options const&,
    google::cloud::timeseriesinsights::v1::EvaluateSliceRequest const&
        request) {
  google::cloud::timeseriesinsights::v1::EvaluatedSlice response;
  auto status = grpc_stub_->EvaluateSlice(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
DefaultTimeseriesInsightsControllerStub::EvaluateTimeseries(
    grpc::ClientContext& context, Options const&,
    google::cloud::timeseriesinsights::v1::EvaluateTimeseriesRequest const&
        request) {
  google::cloud::timeseriesinsights::v1::EvaluatedSlice response;
  auto status = grpc_stub_->EvaluateTimeseries(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace timeseriesinsights_v1_internal
}  // namespace cloud
}  // namespace google
