// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/catalog_service.proto

#include "google/cloud/retail/v2/catalog_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CatalogServiceClient::CatalogServiceClient(
    std::shared_ptr<CatalogServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CatalogServiceClient::~CatalogServiceClient() = default;

StreamRange<google::cloud::retail::v2::Catalog>
CatalogServiceClient::ListCatalogs(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::ListCatalogsRequest request;
  request.set_parent(parent);
  return connection_->ListCatalogs(request);
}

StreamRange<google::cloud::retail::v2::Catalog>
CatalogServiceClient::ListCatalogs(
    google::cloud::retail::v2::ListCatalogsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCatalogs(std::move(request));
}

StatusOr<google::cloud::retail::v2::Catalog>
CatalogServiceClient::UpdateCatalog(
    google::cloud::retail::v2::Catalog const& catalog,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::UpdateCatalogRequest request;
  *request.mutable_catalog() = catalog;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCatalog(request);
}

StatusOr<google::cloud::retail::v2::Catalog>
CatalogServiceClient::UpdateCatalog(
    google::cloud::retail::v2::UpdateCatalogRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCatalog(request);
}

Status CatalogServiceClient::SetDefaultBranch(std::string const& catalog,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::SetDefaultBranchRequest request;
  request.set_catalog(catalog);
  return connection_->SetDefaultBranch(request);
}

Status CatalogServiceClient::SetDefaultBranch(
    google::cloud::retail::v2::SetDefaultBranchRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetDefaultBranch(request);
}

StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
CatalogServiceClient::GetDefaultBranch(std::string const& catalog,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::GetDefaultBranchRequest request;
  request.set_catalog(catalog);
  return connection_->GetDefaultBranch(request);
}

StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
CatalogServiceClient::GetDefaultBranch(
    google::cloud::retail::v2::GetDefaultBranchRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDefaultBranch(request);
}

StatusOr<google::cloud::retail::v2::CompletionConfig>
CatalogServiceClient::GetCompletionConfig(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::GetCompletionConfigRequest request;
  request.set_name(name);
  return connection_->GetCompletionConfig(request);
}

StatusOr<google::cloud::retail::v2::CompletionConfig>
CatalogServiceClient::GetCompletionConfig(
    google::cloud::retail::v2::GetCompletionConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCompletionConfig(request);
}

StatusOr<google::cloud::retail::v2::CompletionConfig>
CatalogServiceClient::UpdateCompletionConfig(
    google::cloud::retail::v2::CompletionConfig const& completion_config,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::UpdateCompletionConfigRequest request;
  *request.mutable_completion_config() = completion_config;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCompletionConfig(request);
}

StatusOr<google::cloud::retail::v2::CompletionConfig>
CatalogServiceClient::UpdateCompletionConfig(
    google::cloud::retail::v2::UpdateCompletionConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCompletionConfig(request);
}

StatusOr<google::cloud::retail::v2::AttributesConfig>
CatalogServiceClient::GetAttributesConfig(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::GetAttributesConfigRequest request;
  request.set_name(name);
  return connection_->GetAttributesConfig(request);
}

StatusOr<google::cloud::retail::v2::AttributesConfig>
CatalogServiceClient::GetAttributesConfig(
    google::cloud::retail::v2::GetAttributesConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAttributesConfig(request);
}

StatusOr<google::cloud::retail::v2::AttributesConfig>
CatalogServiceClient::UpdateAttributesConfig(
    google::cloud::retail::v2::AttributesConfig const& attributes_config,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::UpdateAttributesConfigRequest request;
  *request.mutable_attributes_config() = attributes_config;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAttributesConfig(request);
}

StatusOr<google::cloud::retail::v2::AttributesConfig>
CatalogServiceClient::UpdateAttributesConfig(
    google::cloud::retail::v2::UpdateAttributesConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAttributesConfig(request);
}

StatusOr<google::cloud::retail::v2::AttributesConfig>
CatalogServiceClient::AddCatalogAttribute(
    google::cloud::retail::v2::AddCatalogAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddCatalogAttribute(request);
}

StatusOr<google::cloud::retail::v2::AttributesConfig>
CatalogServiceClient::RemoveCatalogAttribute(
    google::cloud::retail::v2::RemoveCatalogAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveCatalogAttribute(request);
}

StatusOr<google::cloud::retail::v2::AttributesConfig>
CatalogServiceClient::ReplaceCatalogAttribute(
    google::cloud::retail::v2::ReplaceCatalogAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReplaceCatalogAttribute(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2
}  // namespace cloud
}  // namespace google
