// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_holds.proto

#include "google/cloud/resourcemanager/v3/tag_holds_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TagHoldsClient::TagHoldsClient(std::shared_ptr<TagHoldsConnection> connection,
                               Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TagHoldsClient::~TagHoldsClient() = default;

future<StatusOr<google::cloud::resourcemanager::v3::TagHold>>
TagHoldsClient::CreateTagHold(
    std::string const& parent,
    google::cloud::resourcemanager::v3::TagHold const& tag_hold, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::CreateTagHoldRequest request;
  request.set_parent(parent);
  *request.mutable_tag_hold() = tag_hold;
  return connection_->CreateTagHold(request);
}

StatusOr<google::longrunning::Operation> TagHoldsClient::CreateTagHold(
    NoAwaitTag, std::string const& parent,
    google::cloud::resourcemanager::v3::TagHold const& tag_hold, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::CreateTagHoldRequest request;
  request.set_parent(parent);
  *request.mutable_tag_hold() = tag_hold;
  return connection_->CreateTagHold(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagHold>>
TagHoldsClient::CreateTagHold(
    google::cloud::resourcemanager::v3::CreateTagHoldRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTagHold(request);
}

StatusOr<google::longrunning::Operation> TagHoldsClient::CreateTagHold(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::CreateTagHoldRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTagHold(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagHold>>
TagHoldsClient::CreateTagHold(google::longrunning::Operation const& operation,
                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTagHold(operation);
}

future<StatusOr<google::cloud::resourcemanager::v3::DeleteTagHoldMetadata>>
TagHoldsClient::DeleteTagHold(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::DeleteTagHoldRequest request;
  request.set_name(name);
  return connection_->DeleteTagHold(request);
}

StatusOr<google::longrunning::Operation> TagHoldsClient::DeleteTagHold(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::DeleteTagHoldRequest request;
  request.set_name(name);
  return connection_->DeleteTagHold(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::DeleteTagHoldMetadata>>
TagHoldsClient::DeleteTagHold(
    google::cloud::resourcemanager::v3::DeleteTagHoldRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTagHold(request);
}

StatusOr<google::longrunning::Operation> TagHoldsClient::DeleteTagHold(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::DeleteTagHoldRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTagHold(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::DeleteTagHoldMetadata>>
TagHoldsClient::DeleteTagHold(google::longrunning::Operation const& operation,
                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTagHold(operation);
}

StreamRange<google::cloud::resourcemanager::v3::TagHold>
TagHoldsClient::ListTagHolds(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::ListTagHoldsRequest request;
  request.set_parent(parent);
  return connection_->ListTagHolds(request);
}

StreamRange<google::cloud::resourcemanager::v3::TagHold>
TagHoldsClient::ListTagHolds(
    google::cloud::resourcemanager::v3::ListTagHoldsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTagHolds(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
