// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_MIGRATION_CENTER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_MIGRATION_CENTER_CLIENT_H

#include "google/cloud/migrationcenter/v1/migration_center_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace migrationcenter_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service describing handlers for resources.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class MigrationCenterClient {
 public:
  explicit MigrationCenterClient(
      std::shared_ptr<MigrationCenterConnection> connection, Options opts = {});
  ~MigrationCenterClient();

  ///@{
  /// @name Copy and move support
  MigrationCenterClient(MigrationCenterClient const&) = default;
  MigrationCenterClient& operator=(MigrationCenterClient const&) = default;
  MigrationCenterClient(MigrationCenterClient&&) = default;
  MigrationCenterClient& operator=(MigrationCenterClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(MigrationCenterClient const& a,
                         MigrationCenterClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(MigrationCenterClient const& a,
                         MigrationCenterClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists all the assets in a given project and location.
  ///
  /// @param parent  Required. Parent value for `ListAssetsRequest`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.Asset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Asset]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L567}
  /// [google.cloud.migrationcenter.v1.ListAssetsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1040}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::Asset> ListAssets(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the assets in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListAssetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.Asset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Asset]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L567}
  /// [google.cloud.migrationcenter.v1.ListAssetsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1040}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::Asset> ListAssets(
      google::cloud::migrationcenter::v1::ListAssetsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of an asset.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Asset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Asset]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L567}
  /// [google.cloud.migrationcenter.v1.GetAssetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1079}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Asset> GetAsset(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of an asset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetAssetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Asset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Asset]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L567}
  /// [google.cloud.migrationcenter.v1.GetAssetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1079}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Asset> GetAsset(
      google::cloud::migrationcenter::v1::GetAssetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of an asset.
  ///
  /// @param asset  Required. The resource being updated.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Asset` resource by the update.
  ///  The values specified in the `update_mask` field are relative to the
  ///  resource, not the full request.
  ///  A field will be overwritten if it is in the mask.
  ///  A single * value in the mask lets you to overwrite all fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Asset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Asset]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L567}
  /// [google.cloud.migrationcenter.v1.UpdateAssetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1093}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Asset> UpdateAsset(
      google::cloud::migrationcenter::v1::Asset const& asset,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of an asset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.UpdateAssetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Asset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Asset]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L567}
  /// [google.cloud.migrationcenter.v1.UpdateAssetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1093}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Asset> UpdateAsset(
      google::cloud::migrationcenter::v1::UpdateAssetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a list of assets.
  ///
  /// @param parent  Required. Parent value for batch asset update.
  /// @param requests  Required. The request message specifying the resources to update.
  ///  A maximum of 1000 assets can be modified in a batch.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.BatchUpdateAssetsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.BatchUpdateAssetsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1123}
  /// [google.cloud.migrationcenter.v1.BatchUpdateAssetsResponse]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1139}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>
  BatchUpdateAssets(
      std::string const& parent,
      std::vector<google::cloud::migrationcenter::v1::UpdateAssetRequest> const&
          requests,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a list of assets.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.BatchUpdateAssetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.BatchUpdateAssetsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.BatchUpdateAssetsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1123}
  /// [google.cloud.migrationcenter.v1.BatchUpdateAssetsResponse]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1139}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>
  BatchUpdateAssets(
      google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an asset.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteAssetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1146}
  ///
  // clang-format on
  Status DeleteAsset(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an asset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.DeleteAssetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteAssetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1146}
  ///
  // clang-format on
  Status DeleteAsset(
      google::cloud::migrationcenter::v1::DeleteAssetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes list of Assets.
  ///
  /// @param parent  Required. Parent value for batch asset delete.
  /// @param names  Required. The IDs of the assets to delete.
  ///  A maximum of 1000 assets can be deleted in a batch.
  ///  Format: projects/{project}/locations/{location}/assets/{name}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.BatchDeleteAssetsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1172}
  ///
  // clang-format on
  Status BatchDeleteAssets(std::string const& parent,
                           std::vector<std::string> const& names,
                           Options opts = {});

  // clang-format off
  ///
  /// Deletes list of Assets.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.BatchDeleteAssetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.BatchDeleteAssetsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1172}
  ///
  // clang-format on
  Status BatchDeleteAssets(
      google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Reports a set of frames.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ReportAssetFramesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ReportAssetFramesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ReportAssetFramesRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1198}
  /// [google.cloud.migrationcenter.v1.ReportAssetFramesResponse]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1215}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ReportAssetFramesResponse>
  ReportAssetFrames(
      google::cloud::migrationcenter::v1::ReportAssetFramesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Aggregates the requested fields based on provided function.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.AggregateAssetsValuesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1218}
  /// [google.cloud.migrationcenter.v1.AggregateAssetsValuesResponse]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1231}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::AggregateAssetsValuesResponse>
  AggregateAssetsValues(
      google::cloud::migrationcenter::v1::AggregateAssetsValuesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an import job.
  ///
  /// @param parent  Required. Value for parent.
  /// @param import_job  Required. The resource being created.
  /// @param import_job_id  Required. ID of the import job.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.ImportJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1237}
  /// [google.cloud.migrationcenter.v1.ImportJob]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L652}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  CreateImportJob(
      std::string const& parent,
      google::cloud::migrationcenter::v1::ImportJob const& import_job,
      std::string const& import_job_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateImportJob(
      NoAwaitTag, std::string const& parent,
      google::cloud::migrationcenter::v1::ImportJob const& import_job,
      std::string const& import_job_id, Options opts = {});

  // clang-format off
  ///
  /// Creates an import job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.CreateImportJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.ImportJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1237}
  /// [google.cloud.migrationcenter.v1.ImportJob]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L652}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  CreateImportJob(
      google::cloud::migrationcenter::v1::CreateImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateImportJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  CreateImportJob(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Lists all import jobs.
  ///
  /// @param parent  Required. Parent value for `ListImportJobsRequest`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.ImportJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ImportJob]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L652}
  /// [google.cloud.migrationcenter.v1.ListImportJobsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1269}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::ImportJob> ListImportJobs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all import jobs.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListImportJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.ImportJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ImportJob]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L652}
  /// [google.cloud.migrationcenter.v1.ListImportJobsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1269}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::ImportJob> ListImportJobs(
      google::cloud::migrationcenter::v1::ListImportJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of an import job.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ImportJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1309}
  /// [google.cloud.migrationcenter.v1.ImportJob]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L652}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ImportJob> GetImportJob(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of an import job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetImportJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ImportJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1309}
  /// [google.cloud.migrationcenter.v1.ImportJob]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L652}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ImportJob> GetImportJob(
      google::cloud::migrationcenter::v1::GetImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an import job.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1324}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteImportJob(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an import job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.DeleteImportJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1324}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportJob(
      google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteImportJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportJob(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Updates an import job.
  ///
  /// @param import_job  Required. The resource being updated
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Asset` resource by the update.
  ///  The values specified in the `update_mask` field are relative to the
  ///  resource, not the full request.
  ///  A field will be overwritten if it is in the mask.
  ///  A single * value in the mask lets you to overwrite all fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.ImportJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ImportJob]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L652}
  /// [google.cloud.migrationcenter.v1.UpdateImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1355}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  UpdateImportJob(
      google::cloud::migrationcenter::v1::ImportJob const& import_job,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::ImportJob const& import_job,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an import job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.UpdateImportJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.ImportJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ImportJob]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L652}
  /// [google.cloud.migrationcenter.v1.UpdateImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1355}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  UpdateImportJob(
      google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateImportJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
  UpdateImportJob(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Validates an import job.
  ///
  /// @param name  Required. The name of the import job to validate.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  /// [google.cloud.migrationcenter.v1.ValidateImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1385}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  ValidateImportJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ValidateImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ValidateImportJob(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Validates an import job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ValidateImportJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  /// [google.cloud.migrationcenter.v1.ValidateImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1385}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  ValidateImportJob(
      google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ValidateImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ValidateImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ValidateImportJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  ValidateImportJob(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Runs an import job.
  ///
  /// @param name  Required. The name of the import job to run.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  /// [google.cloud.migrationcenter.v1.RunImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1411}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  RunImportJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RunImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RunImportJob(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Runs an import job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.RunImportJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  /// [google.cloud.migrationcenter.v1.RunImportJobRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1411}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  RunImportJob(
      google::cloud::migrationcenter::v1::RunImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RunImportJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RunImportJob(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::RunImportJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RunImportJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  RunImportJob(google::longrunning::Operation const& operation,
               Options opts = {});

  // clang-format off
  ///
  /// Gets an import data file.
  ///
  /// @param name  Required. Name of the ImportDataFile.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ImportDataFile])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetImportDataFileRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1437}
  /// [google.cloud.migrationcenter.v1.ImportDataFile]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L730}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>
  GetImportDataFile(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets an import data file.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetImportDataFileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ImportDataFile])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetImportDataFileRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1437}
  /// [google.cloud.migrationcenter.v1.ImportDataFile]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L730}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>
  GetImportDataFile(
      google::cloud::migrationcenter::v1::GetImportDataFileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// List import data files.
  ///
  /// @param parent  Required. Name of the parent of the `ImportDataFiles` resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.ImportDataFile], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ImportDataFile]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L730}
  /// [google.cloud.migrationcenter.v1.ListImportDataFilesRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1448}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>
  ListImportDataFiles(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List import data files.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListImportDataFilesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.ImportDataFile], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ImportDataFile]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L730}
  /// [google.cloud.migrationcenter.v1.ListImportDataFilesRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1448}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>
  ListImportDataFiles(
      google::cloud::migrationcenter::v1::ListImportDataFilesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an import data file.
  ///
  /// @param parent  Required. Name of the parent of the ImportDataFile.
  /// @param import_data_file  Required. The resource being created.
  /// @param import_data_file_id  Required. The ID of the new data file.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.ImportDataFile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateImportDataFileRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1491}
  /// [google.cloud.migrationcenter.v1.ImportDataFile]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L730}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
  CreateImportDataFile(std::string const& parent,
                       google::cloud::migrationcenter::v1::ImportDataFile const&
                           import_data_file,
                       std::string const& import_data_file_id,
                       Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateImportDataFile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateImportDataFile(
      NoAwaitTag, std::string const& parent,
      google::cloud::migrationcenter::v1::ImportDataFile const&
          import_data_file,
      std::string const& import_data_file_id, Options opts = {});

  // clang-format off
  ///
  /// Creates an import data file.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.CreateImportDataFileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.ImportDataFile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateImportDataFileRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1491}
  /// [google.cloud.migrationcenter.v1.ImportDataFile]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L730}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
  CreateImportDataFile(
      google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateImportDataFile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateImportDataFile(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateImportDataFile
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
  CreateImportDataFile(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Delete an import data file.
  ///
  /// @param name  Required. Name of the ImportDataFile to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteImportDataFileRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1523}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportDataFile(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteImportDataFile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteImportDataFile(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete an import data file.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.DeleteImportDataFileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteImportDataFileRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1523}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportDataFile(
      google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteImportDataFile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteImportDataFile(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteImportDataFile
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteImportDataFile(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Lists all groups in a given project and location.
  ///
  /// @param parent  Required. Parent value for `ListGroupsRequest`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.Group], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  /// [google.cloud.migrationcenter.v1.ListGroupsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1549}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::Group> ListGroups(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all groups in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListGroupsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.Group], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  /// [google.cloud.migrationcenter.v1.ListGroupsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1549}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::Group> ListGroups(
      google::cloud::migrationcenter::v1::ListGroupsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a group.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Group])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1585}
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Group> GetGroup(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a group.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Group])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1585}
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Group> GetGroup(
      google::cloud::migrationcenter::v1::GetGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new group in a given project and location.
  ///
  /// @param parent  Required. Value for parent.
  /// @param group  Required. The group resource being created.
  /// @param group_id  Required. User specified ID for the group. It will become the last
  ///  component of the group name. The ID must be unique within the project, must
  ///  conform with RFC-1034, is restricted to lower-cased letters, and has a
  ///  maximum length of 63 characters. The ID must match the regular expression:
  ///  `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Group] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1596}
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> CreateGroup(
      std::string const& parent,
      google::cloud::migrationcenter::v1::Group const& group,
      std::string const& group_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGroup(
      NoAwaitTag, std::string const& parent,
      google::cloud::migrationcenter::v1::Group const& group,
      std::string const& group_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new group in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.CreateGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Group] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1596}
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> CreateGroup(
      google::cloud::migrationcenter::v1::CreateGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGroup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> CreateGroup(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a group.
  ///
  /// @param group  Required. The group resource being updated.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Group` resource by the update.
  ///  The values specified in the `update_mask` are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask.
  ///  A single * value in the mask lets you to overwrite all fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Group] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  /// [google.cloud.migrationcenter.v1.UpdateGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1632}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> UpdateGroup(
      google::cloud::migrationcenter::v1::Group const& group,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGroup(
      NoAwaitTag, google::cloud::migrationcenter::v1::Group const& group,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a group.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.UpdateGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Group] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  /// [google.cloud.migrationcenter.v1.UpdateGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1632}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> UpdateGroup(
      google::cloud::migrationcenter::v1::UpdateGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdateGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGroup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> UpdateGroup(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a group.
  ///
  /// @param name  Required. Name of the group resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1661}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteGroup(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGroup(NoAwaitTag,
                                                       std::string const& name,
                                                       Options opts = {});

  // clang-format off
  ///
  /// Deletes a group.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.DeleteGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1661}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteGroup(
      google::cloud::migrationcenter::v1::DeleteGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGroup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteGroup(google::longrunning::Operation const& operation,
              Options opts = {});

  // clang-format off
  ///
  /// Adds assets to a group.
  ///
  /// @param group  Required. Group reference.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Group] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.AddAssetsToGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1687}
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> AddAssetsToGroup(
      std::string const& group, Options opts = {});

  // clang-format off
  ///
  /// @copybrief AddAssetsToGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> AddAssetsToGroup(
      NoAwaitTag, std::string const& group, Options opts = {});

  // clang-format off
  ///
  /// Adds assets to a group.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.AddAssetsToGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Group] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.AddAssetsToGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1687}
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> AddAssetsToGroup(
      google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief AddAssetsToGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> AddAssetsToGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief AddAssetsToGroup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>> AddAssetsToGroup(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Removes assets from a group.
  ///
  /// @param group  Required. Group reference.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Group] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  /// [google.cloud.migrationcenter.v1.RemoveAssetsFromGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1726}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>>
  RemoveAssetsFromGroup(std::string const& group, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RemoveAssetsFromGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RemoveAssetsFromGroup(
      NoAwaitTag, std::string const& group, Options opts = {});

  // clang-format off
  ///
  /// Removes assets from a group.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.RemoveAssetsFromGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Group] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Group]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L774}
  /// [google.cloud.migrationcenter.v1.RemoveAssetsFromGroupRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1726}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>>
  RemoveAssetsFromGroup(
      google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RemoveAssetsFromGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RemoveAssetsFromGroup(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RemoveAssetsFromGroup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Group>>
  RemoveAssetsFromGroup(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Lists all error frames in a given source and location.
  ///
  /// @param parent  Required. Parent value (the source) for `ListErrorFramesRequest`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.ErrorFrame], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ErrorFrame]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L802}
  /// [google.cloud.migrationcenter.v1.ListErrorFramesRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1764}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::ErrorFrame> ListErrorFrames(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all error frames in a given source and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListErrorFramesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.ErrorFrame], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ErrorFrame]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L802}
  /// [google.cloud.migrationcenter.v1.ListErrorFramesRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1764}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::ErrorFrame> ListErrorFrames(
      google::cloud::migrationcenter::v1::ListErrorFramesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of an error frame.
  ///
  /// @param name  Required. The name of the frame to retrieve.
  ///  Format:
  ///  projects/{project}/locations/{location}/sources/{source}/errorFrames/{error_frame}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ErrorFrame])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ErrorFrame]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L802}
  /// [google.cloud.migrationcenter.v1.GetErrorFrameRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1797}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ErrorFrame> GetErrorFrame(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of an error frame.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetErrorFrameRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ErrorFrame])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ErrorFrame]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L802}
  /// [google.cloud.migrationcenter.v1.GetErrorFrameRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1797}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ErrorFrame> GetErrorFrame(
      google::cloud::migrationcenter::v1::GetErrorFrameRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all the sources in a given project and location.
  ///
  /// @param parent  Required. Parent value for `ListSourcesRequest`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.Source], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ListSourcesRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1814}
  /// [google.cloud.migrationcenter.v1.Source]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L825}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::Source> ListSources(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the sources in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListSourcesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.Source], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ListSourcesRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1814}
  /// [google.cloud.migrationcenter.v1.Source]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L825}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::Source> ListSources(
      google::cloud::migrationcenter::v1::ListSourcesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a source.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Source])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetSourceRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1850}
  /// [google.cloud.migrationcenter.v1.Source]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L825}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Source> GetSource(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a source.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Source])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetSourceRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1850}
  /// [google.cloud.migrationcenter.v1.Source]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L825}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Source> GetSource(
      google::cloud::migrationcenter::v1::GetSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new source in a given project and location.
  ///
  /// @param parent  Required. Value for parent.
  /// @param source  Required. The resource being created.
  /// @param source_id  Required. User specified ID for the source. It will become the last
  ///  component of the source name. The ID must be unique within the project,
  ///  must conform with RFC-1034, is restricted to lower-cased letters, and has a
  ///  maximum length of 63 characters. The ID must match the regular expression:
  ///  `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Source] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateSourceRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1861}
  /// [google.cloud.migrationcenter.v1.Source]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L825}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Source>> CreateSource(
      std::string const& parent,
      google::cloud::migrationcenter::v1::Source const& source,
      std::string const& source_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateSource(
      NoAwaitTag, std::string const& parent,
      google::cloud::migrationcenter::v1::Source const& source,
      std::string const& source_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new source in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.CreateSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Source] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateSourceRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1861}
  /// [google.cloud.migrationcenter.v1.Source]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L825}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Source>> CreateSource(
      google::cloud::migrationcenter::v1::CreateSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateSource(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateSource
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Source>> CreateSource(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a source.
  ///
  /// @param source  Required. The resource being updated
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Source` resource by the update.
  ///  The values specified in the `update_mask` field are relative to the
  ///  resource, not the full request.
  ///  A field will be overwritten if it is in the mask.
  ///  A single * value in the mask lets you to overwrite all fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Source] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Source]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L825}
  /// [google.cloud.migrationcenter.v1.UpdateSourceRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1897}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Source>> UpdateSource(
      google::cloud::migrationcenter::v1::Source const& source,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateSource(
      NoAwaitTag, google::cloud::migrationcenter::v1::Source const& source,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a source.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.UpdateSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Source] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Source]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L825}
  /// [google.cloud.migrationcenter.v1.UpdateSourceRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1897}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Source>> UpdateSource(
      google::cloud::migrationcenter::v1::UpdateSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateSource(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdateSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSource
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Source>> UpdateSource(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a source.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteSourceRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1927}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteSource(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteSource(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a source.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.DeleteSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteSourceRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1927}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteSource(
      google::cloud::migrationcenter::v1::DeleteSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteSource(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteSourceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteSource
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteSource(google::longrunning::Operation const& operation,
               Options opts = {});

  // clang-format off
  ///
  /// Lists all the preference sets in a given project and location.
  ///
  /// @param parent  Required. Parent value for `ListPreferenceSetsRequest`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.PreferenceSet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ListPreferenceSetsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1953}
  /// [google.cloud.migrationcenter.v1.PreferenceSet]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L624}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>
  ListPreferenceSets(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the preference sets in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListPreferenceSetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.PreferenceSet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ListPreferenceSetsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1953}
  /// [google.cloud.migrationcenter.v1.PreferenceSet]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L624}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>
  ListPreferenceSets(
      google::cloud::migrationcenter::v1::ListPreferenceSetsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a preference set.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.PreferenceSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetPreferenceSetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1987}
  /// [google.cloud.migrationcenter.v1.PreferenceSet]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L624}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::PreferenceSet> GetPreferenceSet(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a preference set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetPreferenceSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.PreferenceSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetPreferenceSetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1987}
  /// [google.cloud.migrationcenter.v1.PreferenceSet]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L624}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::PreferenceSet> GetPreferenceSet(
      google::cloud::migrationcenter::v1::GetPreferenceSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new preference set in a given project and location.
  ///
  /// @param parent  Required. Value for parent.
  /// @param preference_set  Required. The preference set resource being created.
  /// @param preference_set_id  Required. User specified ID for the preference set. It will become the last
  ///  component of the preference set name. The ID must be unique within the
  ///  project, must conform with RFC-1034, is restricted to lower-cased letters,
  ///  and has a maximum length of 63 characters. The ID must match the regular
  ///  expression
  ///  `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.PreferenceSet] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreatePreferenceSetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1998}
  /// [google.cloud.migrationcenter.v1.PreferenceSet]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L624}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  CreatePreferenceSet(
      std::string const& parent,
      google::cloud::migrationcenter::v1::PreferenceSet const& preference_set,
      std::string const& preference_set_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePreferenceSet
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePreferenceSet(
      NoAwaitTag, std::string const& parent,
      google::cloud::migrationcenter::v1::PreferenceSet const& preference_set,
      std::string const& preference_set_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new preference set in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.CreatePreferenceSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.PreferenceSet] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreatePreferenceSetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1998}
  /// [google.cloud.migrationcenter.v1.PreferenceSet]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L624}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  CreatePreferenceSet(
      google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePreferenceSet
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePreferenceSet(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePreferenceSet
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  CreatePreferenceSet(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a preference set.
  ///
  /// @param preference_set  Required. The preference set resource being updated.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `PreferenceSet` resource by the update.
  ///  The values specified in the `update_mask` field are relative to the
  ///  resource, not the full request.
  ///  A field will be overwritten if it is in the mask.
  ///  A single * value in the mask lets you to overwrite all fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.PreferenceSet] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.PreferenceSet]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L624}
  /// [google.cloud.migrationcenter.v1.UpdatePreferenceSetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2035}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  UpdatePreferenceSet(
      google::cloud::migrationcenter::v1::PreferenceSet const& preference_set,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePreferenceSet
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdatePreferenceSet(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::PreferenceSet const& preference_set,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a preference set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.UpdatePreferenceSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.PreferenceSet] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.PreferenceSet]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L624}
  /// [google.cloud.migrationcenter.v1.UpdatePreferenceSetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2035}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  UpdatePreferenceSet(
      google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePreferenceSet
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdatePreferenceSet(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdatePreferenceSet
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
  UpdatePreferenceSet(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Deletes a preference set.
  ///
  /// @param name  Required. Name of the group resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeletePreferenceSetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2065}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeletePreferenceSet(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePreferenceSet
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePreferenceSet(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a preference set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.DeletePreferenceSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeletePreferenceSetRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2065}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeletePreferenceSet(
      google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePreferenceSet
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePreferenceSet(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePreferenceSet
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeletePreferenceSet(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of regional settings.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Settings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetSettingsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2091}
  /// [google.cloud.migrationcenter.v1.Settings]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L3803}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Settings> GetSettings(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of regional settings.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Settings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetSettingsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2091}
  /// [google.cloud.migrationcenter.v1.Settings]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L3803}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Settings> GetSettings(
      google::cloud::migrationcenter::v1::GetSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the regional-level project settings.
  ///
  /// @param settings  Required. The project settings resource being updated.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  `Settings` resource by the update.
  ///  The values specified in the `update_mask` field are relative to the
  ///  resource, not the full request.
  ///  A field will be overwritten if it is in the mask.
  ///  A single * value in the mask lets you to overwrite all fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Settings] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Settings]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L3803}
  /// [google.cloud.migrationcenter.v1.UpdateSettingsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2102}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Settings>> UpdateSettings(
      google::cloud::migrationcenter::v1::Settings const& settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateSettings(
      NoAwaitTag, google::cloud::migrationcenter::v1::Settings const& settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the regional-level project settings.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.UpdateSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Settings] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.Settings]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L3803}
  /// [google.cloud.migrationcenter.v1.UpdateSettingsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2102}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Settings>> UpdateSettings(
      google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSettings
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateSettings(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSettings
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Settings>> UpdateSettings(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Creates a report configuration.
  ///
  /// @param parent  Required. Value for parent.
  /// @param report_config  Required. The report config set resource being created.
  /// @param report_config_id  Required. User specified ID for the report config. It will become the last
  ///  component of the report config name. The ID must be unique within the
  ///  project, must conform with RFC-1034, is restricted to lower-cased letters,
  ///  and has a maximum length of 63 characters. The ID must match the regular
  ///  expression: [a-z]([a-z0-9-]{0,61}[a-z0-9])?.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.ReportConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateReportConfigRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2132}
  /// [google.cloud.migrationcenter.v1.ReportConfig]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L904}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
  CreateReportConfig(
      std::string const& parent,
      google::cloud::migrationcenter::v1::ReportConfig const& report_config,
      std::string const& report_config_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateReportConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateReportConfig(
      NoAwaitTag, std::string const& parent,
      google::cloud::migrationcenter::v1::ReportConfig const& report_config,
      std::string const& report_config_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a report configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.CreateReportConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.ReportConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateReportConfigRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2132}
  /// [google.cloud.migrationcenter.v1.ReportConfig]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L904}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
  CreateReportConfig(
      google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateReportConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateReportConfig(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateReportConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
  CreateReportConfig(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single ReportConfig.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ReportConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetReportConfigRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2278}
  /// [google.cloud.migrationcenter.v1.ReportConfig]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L904}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ReportConfig> GetReportConfig(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single ReportConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetReportConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.ReportConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetReportConfigRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2278}
  /// [google.cloud.migrationcenter.v1.ReportConfig]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L904}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::ReportConfig> GetReportConfig(
      google::cloud::migrationcenter::v1::GetReportConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists ReportConfigs in a given project and location.
  ///
  /// @param parent  Required. Parent value for `ListReportConfigsRequest`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.ReportConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ListReportConfigsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2289}
  /// [google.cloud.migrationcenter.v1.ReportConfig]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L904}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::ReportConfig>
  ListReportConfigs(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists ReportConfigs in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListReportConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.ReportConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ListReportConfigsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2289}
  /// [google.cloud.migrationcenter.v1.ReportConfig]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L904}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::ReportConfig>
  ListReportConfigs(
      google::cloud::migrationcenter::v1::ListReportConfigsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a ReportConfig.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteReportConfigRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2168}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReportConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteReportConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteReportConfig(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a ReportConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.DeleteReportConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteReportConfigRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2168}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReportConfig(
      google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteReportConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteReportConfig(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteReportConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReportConfig(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Creates a report.
  ///
  /// @param parent  Required. Value for parent.
  /// @param report  Required. The report resource being created.
  /// @param report_id  Required. User specified id for the report. It will become the last
  ///  component of the report name. The id must be unique within the project,
  ///  must conform with RFC-1034, is restricted to lower-cased letters, and has a
  ///  maximum length of 63 characters. The id must match the regular expression:
  ///  [a-z]([a-z0-9-]{0,61}[a-z0-9])?.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Report] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateReportRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2325}
  /// [google.cloud.migrationcenter.v1.Report]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L952}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Report>> CreateReport(
      std::string const& parent,
      google::cloud::migrationcenter::v1::Report const& report,
      std::string const& report_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateReport
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateReport(
      NoAwaitTag, std::string const& parent,
      google::cloud::migrationcenter::v1::Report const& report,
      std::string const& report_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a report.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.CreateReportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.Report] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.CreateReportRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2325}
  /// [google.cloud.migrationcenter.v1.Report]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L952}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Report>> CreateReport(
      google::cloud::migrationcenter::v1::CreateReportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateReport
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateReport(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::CreateReportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateReport
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::Report>> CreateReport(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Report.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Report])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetReportRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2199}
  /// [google.cloud.migrationcenter.v1.Report]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L952}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Report> GetReport(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Report.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.GetReportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.migrationcenter.v1.Report])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.GetReportRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2199}
  /// [google.cloud.migrationcenter.v1.Report]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L952}
  ///
  // clang-format on
  StatusOr<google::cloud::migrationcenter::v1::Report> GetReport(
      google::cloud::migrationcenter::v1::GetReportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Reports in a given ReportConfig.
  ///
  /// @param parent  Required. Parent value for `ListReportsRequest`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.Report], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ListReportsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2213}
  /// [google.cloud.migrationcenter.v1.Report]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L952}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::Report> ListReports(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Reports in a given ReportConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.ListReportsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.migrationcenter.v1.Report], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.ListReportsRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2213}
  /// [google.cloud.migrationcenter.v1.Report]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L952}
  ///
  // clang-format on
  StreamRange<google::cloud::migrationcenter::v1::Report> ListReports(
      google::cloud::migrationcenter::v1::ListReportsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a Report.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteReportRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2252}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReport(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteReport
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteReport(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a Report.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.migrationcenter.v1.DeleteReportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.migrationcenter.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.migrationcenter.v1.DeleteReportRequest]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L2252}
  /// [google.cloud.migrationcenter.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/migrationcenter/v1/migrationcenter.proto#L1010}
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReport(
      google::cloud::migrationcenter::v1::DeleteReportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteReport
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteReport(
      NoAwaitTag,
      google::cloud::migrationcenter::v1::DeleteReportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteReport
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
  DeleteReport(google::longrunning::Operation const& operation,
               Options opts = {});

 private:
  std::shared_ptr<MigrationCenterConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace migrationcenter_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_MIGRATION_CENTER_CLIENT_H
