// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_MOCKS_MOCK_SITE_SEARCH_ENGINE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_MOCKS_MOCK_SITE_SEARCH_ENGINE_CONNECTION_H

#include "google/cloud/discoveryengine/v1/site_search_engine_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace discoveryengine_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `SiteSearchEngineServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `SiteSearchEngineServiceClient`. To
 * do so, construct an object of type `SiteSearchEngineServiceClient` with an
 * instance of this class. Then use the Google Test framework functions to
 * program the behavior of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockSiteSearchEngineServiceConnection
    : public discoveryengine_v1::SiteSearchEngineServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>,
      GetSiteSearchEngine,
      (google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateTargetSite(Matcher<google::cloud::discoveryengine::v1::CreateTargetSiteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>,
      CreateTargetSite,
      (google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateTargetSite(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateTargetSite,
      (NoAwaitTag,
       google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateTargetSite(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>,
              CreateTargetSite,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// BatchCreateTargetSites(Matcher<google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>,
      BatchCreateTargetSites,
      (google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, BatchCreateTargetSites(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, BatchCreateTargetSites,
      (NoAwaitTag,
       google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// BatchCreateTargetSites(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>,
      BatchCreateTargetSites, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::discoveryengine::v1::TargetSite>, GetTargetSite,
      (google::cloud::discoveryengine::v1::GetTargetSiteRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateTargetSite(Matcher<google::cloud::discoveryengine::v1::UpdateTargetSiteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>,
      UpdateTargetSite,
      (google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateTargetSite(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateTargetSite,
      (NoAwaitTag,
       google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateTargetSite(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>,
              UpdateTargetSite,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteTargetSite(Matcher<google::cloud::discoveryengine::v1::DeleteTargetSiteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>,
      DeleteTargetSite,
      (google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteTargetSite(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteTargetSite,
      (NoAwaitTag,
       google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteTargetSite(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>,
      DeleteTargetSite, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::discoveryengine::v1::TargetSite>),
      ListTargetSites,
      (google::cloud::discoveryengine::v1::ListTargetSitesRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// EnableAdvancedSiteSearch(Matcher<google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::discoveryengine::v1::
                                  EnableAdvancedSiteSearchResponse>>,
              EnableAdvancedSiteSearch,
              (google::cloud::discoveryengine::v1::
                   EnableAdvancedSiteSearchRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, EnableAdvancedSiteSearch(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              EnableAdvancedSiteSearch,
              (NoAwaitTag, google::cloud::discoveryengine::v1::
                               EnableAdvancedSiteSearchRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// EnableAdvancedSiteSearch(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::discoveryengine::v1::
                                  EnableAdvancedSiteSearchResponse>>,
              EnableAdvancedSiteSearch,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DisableAdvancedSiteSearch(Matcher<google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::discoveryengine::v1::
                                  DisableAdvancedSiteSearchResponse>>,
              DisableAdvancedSiteSearch,
              (google::cloud::discoveryengine::v1::
                   DisableAdvancedSiteSearchRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DisableAdvancedSiteSearch(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              DisableAdvancedSiteSearch,
              (NoAwaitTag, google::cloud::discoveryengine::v1::
                               DisableAdvancedSiteSearchRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DisableAdvancedSiteSearch(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::discoveryengine::v1::
                                  DisableAdvancedSiteSearchResponse>>,
              DisableAdvancedSiteSearch,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RecrawlUris(Matcher<google::cloud::discoveryengine::v1::RecrawlUrisRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>,
      RecrawlUris,
      (google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, RecrawlUris(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, RecrawlUris,
      (NoAwaitTag,
       google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, RecrawlUris(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>,
      RecrawlUris, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// BatchVerifyTargetSites(Matcher<google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>,
      BatchVerifyTargetSites,
      (google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, BatchVerifyTargetSites(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, BatchVerifyTargetSites,
      (NoAwaitTag,
       google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// BatchVerifyTargetSites(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>,
      BatchVerifyTargetSites, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::discoveryengine::v1::TargetSite>),
      FetchDomainVerificationStatus,
      (google::cloud::discoveryengine::v1::FetchDomainVerificationStatusRequest
           request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_MOCKS_MOCK_SITE_SEARCH_ENGINE_CONNECTION_H
