// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/data_store_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_DATA_STORE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_DATA_STORE_CLIENT_H

#include "google/cloud/discoveryengine/v1/data_store_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for managing [DataStore][google.cloud.discoveryengine.v1.DataStore]
/// configuration.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.discoveryengine.v1.DataStore]:
/// @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
///
class DataStoreServiceClient {
 public:
  explicit DataStoreServiceClient(
      std::shared_ptr<DataStoreServiceConnection> connection,
      Options opts = {});
  ~DataStoreServiceClient();

  ///@{
  /// @name Copy and move support
  DataStoreServiceClient(DataStoreServiceClient const&) = default;
  DataStoreServiceClient& operator=(DataStoreServiceClient const&) = default;
  DataStoreServiceClient(DataStoreServiceClient&&) = default;
  DataStoreServiceClient& operator=(DataStoreServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DataStoreServiceClient const& a,
                         DataStoreServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DataStoreServiceClient const& a,
                         DataStoreServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a [DataStore][google.cloud.discoveryengine.v1.DataStore].
  ///
  /// DataStore is for storing
  /// [Documents][google.cloud.discoveryengine.v1.Document]. To serve these
  /// documents for Search, or Recommendation use case, an
  /// [Engine][google.cloud.discoveryengine.v1.Engine] needs to be created
  /// separately.
  ///
  /// @param parent  Required. The parent resource name, such as
  ///  `projects/{project}/locations/{location}/collections/{collection}`.
  /// @param data_store  Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
  ///  create.
  /// @param data_store_id  Required. The ID to use for the
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
  ///  the final component of the
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
  ///  @n
  ///  This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
  ///  standard with a length limit of 63 characters. Otherwise, an
  ///  INVALID_ARGUMENT error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DataStore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.CreateDataStoreRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L125}
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
  CreateDataStore(
      std::string const& parent,
      google::cloud::discoveryengine::v1::DataStore const& data_store,
      std::string const& data_store_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDataStore
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateDataStore(
      NoAwaitTag, std::string const& parent,
      google::cloud::discoveryengine::v1::DataStore const& data_store,
      std::string const& data_store_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a [DataStore][google.cloud.discoveryengine.v1.DataStore].
  ///
  /// DataStore is for storing
  /// [Documents][google.cloud.discoveryengine.v1.Document]. To serve these
  /// documents for Search, or Recommendation use case, an
  /// [Engine][google.cloud.discoveryengine.v1.Engine] needs to be created
  /// separately.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.CreateDataStoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DataStore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.CreateDataStoreRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L125}
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
  CreateDataStore(
      google::cloud::discoveryengine::v1::CreateDataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDataStore
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateDataStore(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::CreateDataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDataStore
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
  CreateDataStore(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Gets a [DataStore][google.cloud.discoveryengine.v1.DataStore].
  ///
  /// @param name  Required. Full resource name of
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore], such as
  ///  `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
  ///  @n
  ///  If the caller does not have permission to access the
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore], regardless of
  ///  whether or not it exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the requested [DataStore][google.cloud.discoveryengine.v1.DataStore]
  ///  does not exist, a NOT_FOUND error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.DataStore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  /// [google.cloud.discoveryengine.v1.GetDataStoreRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L170}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::DataStore> GetDataStore(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a [DataStore][google.cloud.discoveryengine.v1.DataStore].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.GetDataStoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.DataStore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  /// [google.cloud.discoveryengine.v1.GetDataStoreRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L170}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::DataStore> GetDataStore(
      google::cloud::discoveryengine::v1::GetDataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all the [DataStore][google.cloud.discoveryengine.v1.DataStore]s
  /// associated with the project.
  ///
  /// @param parent  Required. The parent branch resource name, such as
  ///  `projects/{project}/locations/{location}/collections/{collection_id}`.
  ///  @n
  ///  If the caller does not have permission to list
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore]s under this
  ///  location, regardless of whether or not this data store exists, a
  ///  PERMISSION_DENIED error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.DataStore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  /// [google.cloud.discoveryengine.v1.ListDataStoresRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L205}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::DataStore> ListDataStores(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the [DataStore][google.cloud.discoveryengine.v1.DataStore]s
  /// associated with the project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.ListDataStoresRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.DataStore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  /// [google.cloud.discoveryengine.v1.ListDataStoresRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L205}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::DataStore> ListDataStores(
      google::cloud::discoveryengine::v1::ListDataStoresRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a [DataStore][google.cloud.discoveryengine.v1.DataStore].
  ///
  /// @param name  Required. Full resource name of
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore], such as
  ///  `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
  ///  @n
  ///  If the caller does not have permission to delete the
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore], regardless of
  ///  whether or not it exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the [DataStore][google.cloud.discoveryengine.v1.DataStore] to delete
  ///  does not exist, a NOT_FOUND error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DeleteDataStoreMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  /// [google.cloud.discoveryengine.v1.DeleteDataStoreMetadata]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L307}
  /// [google.cloud.discoveryengine.v1.DeleteDataStoreRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L261}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
  DeleteDataStore(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataStore
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDataStore(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a [DataStore][google.cloud.discoveryengine.v1.DataStore].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.DeleteDataStoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DeleteDataStoreMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  /// [google.cloud.discoveryengine.v1.DeleteDataStoreMetadata]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L307}
  /// [google.cloud.discoveryengine.v1.DeleteDataStoreRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L261}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
  DeleteDataStore(
      google::cloud::discoveryengine::v1::DeleteDataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataStore
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDataStore(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::DeleteDataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataStore
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
  DeleteDataStore(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Updates a [DataStore][google.cloud.discoveryengine.v1.DataStore]
  ///
  /// @param data_store  Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
  ///  update.
  ///  @n
  ///  If the caller does not have permission to update the
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore], regardless of
  ///  whether or not it exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the [DataStore][google.cloud.discoveryengine.v1.DataStore] to update
  ///  does not exist, a NOT_FOUND error is returned.
  /// @param update_mask  Indicates which fields in the provided
  ///  [DataStore][google.cloud.discoveryengine.v1.DataStore] to update.
  ///  @n
  ///  If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
  ///  is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.DataStore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  /// [google.cloud.discoveryengine.v1.UpdateDataStoreRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L283}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::DataStore> UpdateDataStore(
      google::cloud::discoveryengine::v1::DataStore const& data_store,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a [DataStore][google.cloud.discoveryengine.v1.DataStore]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.UpdateDataStoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.DataStore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DataStore]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store.proto#L36}
  /// [google.cloud.discoveryengine.v1.UpdateDataStoreRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/data_store_service.proto#L283}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::DataStore> UpdateDataStore(
      google::cloud::discoveryengine::v1::UpdateDataStoreRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<DataStoreServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_DATA_STORE_CLIENT_H
