// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#include "google/cloud/datastore/v1/internal/datastore_option_defaults.h"
#include "google/cloud/datastore/v1/datastore_connection.h"
#include "google/cloud/datastore/v1/datastore_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options DatastoreDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_DATASTORE_ENDPOINT",
      "DATASTORE_EMULATOR_HOST", "GOOGLE_CLOUD_CPP_DATASTORE_AUTHORITY",
      "datastore.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<datastore_v1::DatastoreRetryPolicyOption>()) {
    options.set<datastore_v1::DatastoreRetryPolicyOption>(
        datastore_v1::DatastoreLimitedTimeRetryPolicy(std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<datastore_v1::DatastoreBackoffPolicyOption>()) {
    options.set<datastore_v1::DatastoreBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options
           .has<datastore_v1::DatastoreConnectionIdempotencyPolicyOption>()) {
    options.set<datastore_v1::DatastoreConnectionIdempotencyPolicyOption>(
        datastore_v1::MakeDefaultDatastoreConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1_internal
}  // namespace cloud
}  // namespace google
