// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: grafeas/v1/grafeas.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINERANALYSIS_V1_GRAFEAS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINERANALYSIS_V1_GRAFEAS_CLIENT_H

#include "google/cloud/containeranalysis/v1/grafeas_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace containeranalysis_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// [Grafeas](https://grafeas.io) API.
///
/// Retrieves analysis results of Cloud components such as Docker container
/// images.
///
/// Analysis results are stored as a series of occurrences. An `Occurrence`
/// contains information about a specific analysis instance on a resource. An
/// occurrence refers to a `Note`. A note contains details describing the
/// analysis and is generally stored in a separate project, called a `Provider`.
/// Multiple occurrences can refer to the same note.
///
/// For example, an SSL vulnerability could affect multiple images. In this
/// case, there would be one note for the vulnerability and an occurrence for
/// each image with the vulnerability referring to that note.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class GrafeasClient {
 public:
  explicit GrafeasClient(std::shared_ptr<GrafeasConnection> connection,
                         Options opts = {});
  ~GrafeasClient();

  ///@{
  /// @name Copy and move support
  GrafeasClient(GrafeasClient const&) = default;
  GrafeasClient& operator=(GrafeasClient const&) = default;
  GrafeasClient(GrafeasClient&&) = default;
  GrafeasClient& operator=(GrafeasClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(GrafeasClient const& a, GrafeasClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(GrafeasClient const& a, GrafeasClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Gets the specified occurrence.
  ///
  /// @param name  The name of the occurrence in the form of
  ///  `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Occurrence])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.GetOccurrenceRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L373}
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Occurrence> GetOccurrence(std::string const& name,
                                                  Options opts = {});

  // clang-format off
  ///
  /// Gets the specified occurrence.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.GetOccurrenceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Occurrence])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.GetOccurrenceRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L373}
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Occurrence> GetOccurrence(
      grafeas::v1::GetOccurrenceRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Lists occurrences for the specified project.
  ///
  /// @param parent  The name of the project to list occurrences for in the form of
  ///  `projects/[PROJECT_ID]`.
  /// @param filter  The filter expression.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [grafeas.v1.Occurrence], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.ListOccurrencesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L383}
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  ///
  // clang-format on
  StreamRange<grafeas::v1::Occurrence> ListOccurrences(
      std::string const& parent, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists occurrences for the specified project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.ListOccurrencesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [grafeas.v1.Occurrence], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.ListOccurrencesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L383}
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  ///
  // clang-format on
  StreamRange<grafeas::v1::Occurrence> ListOccurrences(
      grafeas::v1::ListOccurrencesRequest request, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified occurrence. For example, use this method to delete an
  /// occurrence when the occurrence is no longer applicable for the given
  /// resource.
  ///
  /// @param name  The name of the occurrence in the form of
  ///  `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.DeleteOccurrenceRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L413}
  ///
  // clang-format on
  Status DeleteOccurrence(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified occurrence. For example, use this method to delete an
  /// occurrence when the occurrence is no longer applicable for the given
  /// resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.DeleteOccurrenceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.DeleteOccurrenceRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L413}
  ///
  // clang-format on
  Status DeleteOccurrence(grafeas::v1::DeleteOccurrenceRequest const& request,
                          Options opts = {});

  // clang-format off
  ///
  /// Creates a new occurrence.
  ///
  /// @param parent  The name of the project in the form of `projects/[PROJECT_ID]`, under which
  ///  the occurrence is to be created.
  /// @param occurrence  The occurrence to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Occurrence])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.CreateOccurrenceRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L423}
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Occurrence> CreateOccurrence(
      std::string const& parent, grafeas::v1::Occurrence const& occurrence,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new occurrence.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.CreateOccurrenceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Occurrence])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.CreateOccurrenceRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L423}
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Occurrence> CreateOccurrence(
      grafeas::v1::CreateOccurrenceRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Creates new occurrences in batch.
  ///
  /// @param parent  The name of the project in the form of `projects/[PROJECT_ID]`, under which
  ///  the occurrences are to be created.
  /// @param occurrences  The occurrences to create. Max allowed length is 1000.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.BatchCreateOccurrencesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.BatchCreateOccurrencesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L580}
  /// [grafeas.v1.BatchCreateOccurrencesResponse]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L593}
  ///
  // clang-format on
  StatusOr<grafeas::v1::BatchCreateOccurrencesResponse> BatchCreateOccurrences(
      std::string const& parent,
      std::vector<grafeas::v1::Occurrence> const& occurrences,
      Options opts = {});

  // clang-format off
  ///
  /// Creates new occurrences in batch.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.BatchCreateOccurrencesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.BatchCreateOccurrencesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.BatchCreateOccurrencesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L580}
  /// [grafeas.v1.BatchCreateOccurrencesResponse]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L593}
  ///
  // clang-format on
  StatusOr<grafeas::v1::BatchCreateOccurrencesResponse> BatchCreateOccurrences(
      grafeas::v1::BatchCreateOccurrencesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the specified occurrence.
  ///
  /// @param name  The name of the occurrence in the form of
  ///  `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  /// @param occurrence  The updated occurrence.
  /// @param update_mask  The fields to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Occurrence])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  /// [grafeas.v1.UpdateOccurrenceRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L435}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Occurrence> UpdateOccurrence(
      std::string const& name, grafeas::v1::Occurrence const& occurrence,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified occurrence.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.UpdateOccurrenceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Occurrence])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  /// [grafeas.v1.UpdateOccurrenceRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L435}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Occurrence> UpdateOccurrence(
      grafeas::v1::UpdateOccurrenceRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Gets the note attached to the specified occurrence. Consumer projects can
  /// use this method to get a note that belongs to a provider project.
  ///
  /// @param name  The name of the occurrence in the form of
  ///  `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Note])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.GetOccurrenceNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L459}
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Note> GetOccurrenceNote(std::string const& name,
                                                Options opts = {});

  // clang-format off
  ///
  /// Gets the note attached to the specified occurrence. Consumer projects can
  /// use this method to get a note that belongs to a provider project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.GetOccurrenceNoteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Note])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.GetOccurrenceNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L459}
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Note> GetOccurrenceNote(
      grafeas::v1::GetOccurrenceNoteRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Gets the specified note.
  ///
  /// @param name  The name of the note in the form of
  ///  `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Note])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.GetNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L449}
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Note> GetNote(std::string const& name,
                                      Options opts = {});

  // clang-format off
  ///
  /// Gets the specified note.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.GetNoteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Note])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.GetNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L449}
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Note> GetNote(
      grafeas::v1::GetNoteRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Lists notes for the specified project.
  ///
  /// @param parent  The name of the project to list notes for in the form of
  ///  `projects/[PROJECT_ID]`.
  /// @param filter  The filter expression.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [grafeas.v1.Note], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.ListNotesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L469}
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  ///
  // clang-format on
  StreamRange<grafeas::v1::Note> ListNotes(std::string const& parent,
                                           std::string const& filter,
                                           Options opts = {});

  // clang-format off
  ///
  /// Lists notes for the specified project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.ListNotesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [grafeas.v1.Note], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.ListNotesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L469}
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  ///
  // clang-format on
  StreamRange<grafeas::v1::Note> ListNotes(
      grafeas::v1::ListNotesRequest request, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified note.
  ///
  /// @param name  The name of the note in the form of
  ///  `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.DeleteNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L499}
  ///
  // clang-format on
  Status DeleteNote(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified note.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.DeleteNoteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.DeleteNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L499}
  ///
  // clang-format on
  Status DeleteNote(grafeas::v1::DeleteNoteRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// Creates a new note.
  ///
  /// @param parent  The name of the project in the form of `projects/[PROJECT_ID]`, under which
  ///  the note is to be created.
  /// @param note_id  The ID to use for this note.
  /// @param note  The note to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Note])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.CreateNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L509}
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Note> CreateNote(std::string const& parent,
                                         std::string const& note_id,
                                         grafeas::v1::Note const& note,
                                         Options opts = {});

  // clang-format off
  ///
  /// Creates a new note.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.CreateNoteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Note])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.CreateNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L509}
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Note> CreateNote(
      grafeas::v1::CreateNoteRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Creates new notes in batch.
  ///
  /// @param parent  The name of the project in the form of `projects/[PROJECT_ID]`, under which
  ///  the notes are to be created.
  /// @param notes  The notes to create. Max allowed length is 1000.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.BatchCreateNotesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.BatchCreateNotesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L561}
  /// [grafeas.v1.BatchCreateNotesResponse]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L574}
  ///
  // clang-format on
  StatusOr<grafeas::v1::BatchCreateNotesResponse> BatchCreateNotes(
      std::string const& parent,
      std::map<std::string, grafeas::v1::Note> const& notes, Options opts = {});

  // clang-format off
  ///
  /// Creates new notes in batch.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.BatchCreateNotesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.BatchCreateNotesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.BatchCreateNotesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L561}
  /// [grafeas.v1.BatchCreateNotesResponse]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L574}
  ///
  // clang-format on
  StatusOr<grafeas::v1::BatchCreateNotesResponse> BatchCreateNotes(
      grafeas::v1::BatchCreateNotesRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified note.
  ///
  /// @param name  The name of the note in the form of
  ///  `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
  /// @param note  The updated note.
  /// @param update_mask  The fields to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Note])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  /// [grafeas.v1.UpdateNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L523}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Note> UpdateNote(
      std::string const& name, grafeas::v1::Note const& note,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified note.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.UpdateNoteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([grafeas.v1.Note])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.Note]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L306}
  /// [grafeas.v1.UpdateNoteRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L523}
  ///
  // clang-format on
  StatusOr<grafeas::v1::Note> UpdateNote(
      grafeas::v1::UpdateNoteRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Lists occurrences referencing the specified note. Provider projects can use
  /// this method to get all occurrences across consumer projects referencing the
  /// specified note.
  ///
  /// @param name  The name of the note to list occurrences for in the form of
  ///  `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
  /// @param filter  The filter expression.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [grafeas.v1.Occurrence], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.ListNoteOccurrencesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L537}
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  ///
  // clang-format on
  StreamRange<grafeas::v1::Occurrence> ListNoteOccurrences(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists occurrences referencing the specified note. Provider projects can use
  /// this method to get all occurrences across consumer projects referencing the
  /// specified note.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [grafeas.v1.ListNoteOccurrencesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [grafeas.v1.Occurrence], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [grafeas.v1.ListNoteOccurrencesRequest]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L537}
  /// [grafeas.v1.Occurrence]: @googleapis_reference_link{grafeas/v1/grafeas.proto#L240}
  ///
  // clang-format on
  StreamRange<grafeas::v1::Occurrence> ListNoteOccurrences(
      grafeas::v1::ListNoteOccurrencesRequest request, Options opts = {});

 private:
  std::shared_ptr<GrafeasConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace containeranalysis_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINERANALYSIS_V1_GRAFEAS_CLIENT_H
