// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/networks/v1/networks.proto

#include "google/cloud/compute/networks/v1/networks_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_networks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

NetworksConnectionIdempotencyPolicy::~NetworksConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<NetworksConnectionIdempotencyPolicy>
NetworksConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<NetworksConnectionIdempotencyPolicy>(*this);
}

Idempotency NetworksConnectionIdempotencyPolicy::AddPeering(
    google::cloud::cpp::compute::networks::v1::AddPeeringRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::DeleteNetwork(
    google::cloud::cpp::compute::networks::v1::DeleteNetworkRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::GetNetwork(
    google::cloud::cpp::compute::networks::v1::GetNetworkRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::GetEffectiveFirewalls(
    google::cloud::cpp::compute::networks::v1::
        GetEffectiveFirewallsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::InsertNetwork(
    google::cloud::cpp::compute::networks::v1::InsertNetworkRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::ListNetworks(
    google::cloud::cpp::compute::networks::v1::ListNetworksRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::ListPeeringRoutes(
    google::cloud::cpp::compute::networks::v1::
        ListPeeringRoutesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::PatchNetwork(
    google::cloud::cpp::compute::networks::v1::PatchNetworkRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::RemovePeering(
    google::cloud::cpp::compute::networks::v1::RemovePeeringRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::SwitchToCustomMode(
    google::cloud::cpp::compute::networks::v1::
        SwitchToCustomModeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworksConnectionIdempotencyPolicy::UpdatePeering(
    google::cloud::cpp::compute::networks::v1::UpdatePeeringRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<NetworksConnectionIdempotencyPolicy>
MakeDefaultNetworksConnectionIdempotencyPolicy() {
  return std::make_unique<NetworksConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_networks_v1
}  // namespace cloud
}  // namespace google
