// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#include "google/cloud/apphub/v1/app_hub_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace apphub_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AppHubClient::AppHubClient(std::shared_ptr<AppHubConnection> connection,
                           Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AppHubClient::~AppHubClient() = default;

StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
AppHubClient::LookupServiceProjectAttachment(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest request;
  request.set_name(name);
  return connection_->LookupServiceProjectAttachment(request);
}

StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
AppHubClient::LookupServiceProjectAttachment(
    google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->LookupServiceProjectAttachment(request);
}

StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubClient::ListServiceProjectAttachments(std::string const& parent,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest request;
  request.set_parent(parent);
  return connection_->ListServiceProjectAttachments(request);
}

StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubClient::ListServiceProjectAttachments(
    google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListServiceProjectAttachments(std::move(request));
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubClient::CreateServiceProjectAttachment(
    std::string const& parent,
    google::cloud::apphub::v1::ServiceProjectAttachment const&
        service_project_attachment,
    std::string const& service_project_attachment_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest request;
  request.set_parent(parent);
  *request.mutable_service_project_attachment() = service_project_attachment;
  request.set_service_project_attachment_id(service_project_attachment_id);
  return connection_->CreateServiceProjectAttachment(request);
}

StatusOr<google::longrunning::Operation>
AppHubClient::CreateServiceProjectAttachment(
    NoAwaitTag, std::string const& parent,
    google::cloud::apphub::v1::ServiceProjectAttachment const&
        service_project_attachment,
    std::string const& service_project_attachment_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest request;
  request.set_parent(parent);
  *request.mutable_service_project_attachment() = service_project_attachment;
  request.set_service_project_attachment_id(service_project_attachment_id);
  return connection_->CreateServiceProjectAttachment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubClient::CreateServiceProjectAttachment(
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateServiceProjectAttachment(request);
}

StatusOr<google::longrunning::Operation>
AppHubClient::CreateServiceProjectAttachment(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateServiceProjectAttachment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubClient::CreateServiceProjectAttachment(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateServiceProjectAttachment(operation);
}

StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubClient::GetServiceProjectAttachment(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::GetServiceProjectAttachmentRequest request;
  request.set_name(name);
  return connection_->GetServiceProjectAttachment(request);
}

StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubClient::GetServiceProjectAttachment(
    google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetServiceProjectAttachment(request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteServiceProjectAttachment(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest request;
  request.set_name(name);
  return connection_->DeleteServiceProjectAttachment(request);
}

StatusOr<google::longrunning::Operation>
AppHubClient::DeleteServiceProjectAttachment(NoAwaitTag,
                                             std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest request;
  request.set_name(name);
  return connection_->DeleteServiceProjectAttachment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteServiceProjectAttachment(
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteServiceProjectAttachment(request);
}

StatusOr<google::longrunning::Operation>
AppHubClient::DeleteServiceProjectAttachment(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteServiceProjectAttachment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteServiceProjectAttachment(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteServiceProjectAttachment(operation);
}

StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
AppHubClient::DetachServiceProjectAttachment(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest request;
  request.set_name(name);
  return connection_->DetachServiceProjectAttachment(request);
}

StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
AppHubClient::DetachServiceProjectAttachment(
    google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetachServiceProjectAttachment(request);
}

StreamRange<google::cloud::apphub::v1::DiscoveredService>
AppHubClient::ListDiscoveredServices(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::ListDiscoveredServicesRequest request;
  request.set_parent(parent);
  return connection_->ListDiscoveredServices(request);
}

StreamRange<google::cloud::apphub::v1::DiscoveredService>
AppHubClient::ListDiscoveredServices(
    google::cloud::apphub::v1::ListDiscoveredServicesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDiscoveredServices(std::move(request));
}

StatusOr<google::cloud::apphub::v1::DiscoveredService>
AppHubClient::GetDiscoveredService(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::GetDiscoveredServiceRequest request;
  request.set_name(name);
  return connection_->GetDiscoveredService(request);
}

StatusOr<google::cloud::apphub::v1::DiscoveredService>
AppHubClient::GetDiscoveredService(
    google::cloud::apphub::v1::GetDiscoveredServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDiscoveredService(request);
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
AppHubClient::LookupDiscoveredService(std::string const& parent,
                                      std::string const& uri, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::LookupDiscoveredServiceRequest request;
  request.set_parent(parent);
  request.set_uri(uri);
  return connection_->LookupDiscoveredService(request);
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
AppHubClient::LookupDiscoveredService(
    google::cloud::apphub::v1::LookupDiscoveredServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->LookupDiscoveredService(request);
}

StreamRange<google::cloud::apphub::v1::Service> AppHubClient::ListServices(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::ListServicesRequest request;
  request.set_parent(parent);
  return connection_->ListServices(request);
}

StreamRange<google::cloud::apphub::v1::Service> AppHubClient::ListServices(
    google::cloud::apphub::v1::ListServicesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListServices(std::move(request));
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubClient::CreateService(std::string const& parent,
                            google::cloud::apphub::v1::Service const& service,
                            std::string const& service_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::CreateServiceRequest request;
  request.set_parent(parent);
  *request.mutable_service() = service;
  request.set_service_id(service_id);
  return connection_->CreateService(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::CreateService(
    NoAwaitTag, std::string const& parent,
    google::cloud::apphub::v1::Service const& service,
    std::string const& service_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::CreateServiceRequest request;
  request.set_parent(parent);
  *request.mutable_service() = service;
  request.set_service_id(service_id);
  return connection_->CreateService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubClient::CreateService(
    google::cloud::apphub::v1::CreateServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateService(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::CreateService(
    NoAwaitTag, google::cloud::apphub::v1::CreateServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubClient::CreateService(google::longrunning::Operation const& operation,
                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateService(operation);
}

StatusOr<google::cloud::apphub::v1::Service> AppHubClient::GetService(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::GetServiceRequest request;
  request.set_name(name);
  return connection_->GetService(request);
}

StatusOr<google::cloud::apphub::v1::Service> AppHubClient::GetService(
    google::cloud::apphub::v1::GetServiceRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetService(request);
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubClient::UpdateService(google::cloud::apphub::v1::Service const& service,
                            google::protobuf::FieldMask const& update_mask,
                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::UpdateServiceRequest request;
  *request.mutable_service() = service;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateService(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::UpdateService(
    NoAwaitTag, google::cloud::apphub::v1::Service const& service,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::UpdateServiceRequest request;
  *request.mutable_service() = service;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubClient::UpdateService(
    google::cloud::apphub::v1::UpdateServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateService(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::UpdateService(
    NoAwaitTag, google::cloud::apphub::v1::UpdateServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubClient::UpdateService(google::longrunning::Operation const& operation,
                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateService(operation);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteService(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DeleteServiceRequest request;
  request.set_name(name);
  return connection_->DeleteService(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::DeleteService(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DeleteServiceRequest request;
  request.set_name(name);
  return connection_->DeleteService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteService(
    google::cloud::apphub::v1::DeleteServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteService(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::DeleteService(
    NoAwaitTag, google::cloud::apphub::v1::DeleteServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteService(google::longrunning::Operation const& operation,
                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteService(operation);
}

StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubClient::ListDiscoveredWorkloads(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest request;
  request.set_parent(parent);
  return connection_->ListDiscoveredWorkloads(request);
}

StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubClient::ListDiscoveredWorkloads(
    google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDiscoveredWorkloads(std::move(request));
}

StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubClient::GetDiscoveredWorkload(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::GetDiscoveredWorkloadRequest request;
  request.set_name(name);
  return connection_->GetDiscoveredWorkload(request);
}

StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubClient::GetDiscoveredWorkload(
    google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDiscoveredWorkload(request);
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
AppHubClient::LookupDiscoveredWorkload(std::string const& parent,
                                       std::string const& uri, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest request;
  request.set_parent(parent);
  request.set_uri(uri);
  return connection_->LookupDiscoveredWorkload(request);
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
AppHubClient::LookupDiscoveredWorkload(
    google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->LookupDiscoveredWorkload(request);
}

StreamRange<google::cloud::apphub::v1::Workload> AppHubClient::ListWorkloads(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::ListWorkloadsRequest request;
  request.set_parent(parent);
  return connection_->ListWorkloads(request);
}

StreamRange<google::cloud::apphub::v1::Workload> AppHubClient::ListWorkloads(
    google::cloud::apphub::v1::ListWorkloadsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListWorkloads(std::move(request));
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubClient::CreateWorkload(
    std::string const& parent,
    google::cloud::apphub::v1::Workload const& workload,
    std::string const& workload_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::CreateWorkloadRequest request;
  request.set_parent(parent);
  *request.mutable_workload() = workload;
  request.set_workload_id(workload_id);
  return connection_->CreateWorkload(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::CreateWorkload(
    NoAwaitTag, std::string const& parent,
    google::cloud::apphub::v1::Workload const& workload,
    std::string const& workload_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::CreateWorkloadRequest request;
  request.set_parent(parent);
  *request.mutable_workload() = workload;
  request.set_workload_id(workload_id);
  return connection_->CreateWorkload(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubClient::CreateWorkload(
    google::cloud::apphub::v1::CreateWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateWorkload(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::CreateWorkload(
    NoAwaitTag, google::cloud::apphub::v1::CreateWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateWorkload(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubClient::CreateWorkload(google::longrunning::Operation const& operation,
                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateWorkload(operation);
}

StatusOr<google::cloud::apphub::v1::Workload> AppHubClient::GetWorkload(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::GetWorkloadRequest request;
  request.set_name(name);
  return connection_->GetWorkload(request);
}

StatusOr<google::cloud::apphub::v1::Workload> AppHubClient::GetWorkload(
    google::cloud::apphub::v1::GetWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetWorkload(request);
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubClient::UpdateWorkload(
    google::cloud::apphub::v1::Workload const& workload,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::UpdateWorkloadRequest request;
  *request.mutable_workload() = workload;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateWorkload(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::UpdateWorkload(
    NoAwaitTag, google::cloud::apphub::v1::Workload const& workload,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::UpdateWorkloadRequest request;
  *request.mutable_workload() = workload;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateWorkload(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubClient::UpdateWorkload(
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateWorkload(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::UpdateWorkload(
    NoAwaitTag, google::cloud::apphub::v1::UpdateWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateWorkload(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubClient::UpdateWorkload(google::longrunning::Operation const& operation,
                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateWorkload(operation);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteWorkload(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DeleteWorkloadRequest request;
  request.set_name(name);
  return connection_->DeleteWorkload(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::DeleteWorkload(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DeleteWorkloadRequest request;
  request.set_name(name);
  return connection_->DeleteWorkload(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteWorkload(
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteWorkload(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::DeleteWorkload(
    NoAwaitTag, google::cloud::apphub::v1::DeleteWorkloadRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteWorkload(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteWorkload(google::longrunning::Operation const& operation,
                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteWorkload(operation);
}

StreamRange<google::cloud::apphub::v1::Application>
AppHubClient::ListApplications(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::ListApplicationsRequest request;
  request.set_parent(parent);
  return connection_->ListApplications(request);
}

StreamRange<google::cloud::apphub::v1::Application>
AppHubClient::ListApplications(
    google::cloud::apphub::v1::ListApplicationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListApplications(std::move(request));
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubClient::CreateApplication(
    std::string const& parent,
    google::cloud::apphub::v1::Application const& application,
    std::string const& application_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::CreateApplicationRequest request;
  request.set_parent(parent);
  *request.mutable_application() = application;
  request.set_application_id(application_id);
  return connection_->CreateApplication(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::CreateApplication(
    NoAwaitTag, std::string const& parent,
    google::cloud::apphub::v1::Application const& application,
    std::string const& application_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::CreateApplicationRequest request;
  request.set_parent(parent);
  *request.mutable_application() = application;
  request.set_application_id(application_id);
  return connection_->CreateApplication(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubClient::CreateApplication(
    google::cloud::apphub::v1::CreateApplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateApplication(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::CreateApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateApplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateApplication(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubClient::CreateApplication(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateApplication(operation);
}

StatusOr<google::cloud::apphub::v1::Application> AppHubClient::GetApplication(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::GetApplicationRequest request;
  request.set_name(name);
  return connection_->GetApplication(request);
}

StatusOr<google::cloud::apphub::v1::Application> AppHubClient::GetApplication(
    google::cloud::apphub::v1::GetApplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetApplication(request);
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubClient::UpdateApplication(
    google::cloud::apphub::v1::Application const& application,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::UpdateApplicationRequest request;
  *request.mutable_application() = application;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateApplication(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::UpdateApplication(
    NoAwaitTag, google::cloud::apphub::v1::Application const& application,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::UpdateApplicationRequest request;
  *request.mutable_application() = application;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateApplication(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubClient::UpdateApplication(
    google::cloud::apphub::v1::UpdateApplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateApplication(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::UpdateApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::UpdateApplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateApplication(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubClient::UpdateApplication(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateApplication(operation);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteApplication(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DeleteApplicationRequest request;
  request.set_name(name);
  return connection_->DeleteApplication(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::DeleteApplication(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::apphub::v1::DeleteApplicationRequest request;
  request.set_name(name);
  return connection_->DeleteApplication(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteApplication(
    google::cloud::apphub::v1::DeleteApplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteApplication(request);
}

StatusOr<google::longrunning::Operation> AppHubClient::DeleteApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteApplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteApplication(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubClient::DeleteApplication(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteApplication(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1
}  // namespace cloud
}  // namespace google
