// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/metadata_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_METADATA_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_METADATA_CLIENT_H

#include "google/cloud/aiplatform/v1/metadata_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for reading and writing metadata entries.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class MetadataServiceClient {
 public:
  explicit MetadataServiceClient(
      std::shared_ptr<MetadataServiceConnection> connection, Options opts = {});
  ~MetadataServiceClient();

  ///@{
  /// @name Copy and move support
  MetadataServiceClient(MetadataServiceClient const&) = default;
  MetadataServiceClient& operator=(MetadataServiceClient const&) = default;
  MetadataServiceClient(MetadataServiceClient&&) = default;
  MetadataServiceClient& operator=(MetadataServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(MetadataServiceClient const& a,
                         MetadataServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(MetadataServiceClient const& a,
                         MetadataServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Initializes a MetadataStore, including allocation of resources.
  ///
  /// @param parent  Required. The resource name of the Location where the MetadataStore should
  ///  be created.
  ///  Format: `projects/{project}/locations/{location}/`
  /// @param metadata_store  Required. The MetadataStore to create.
  /// @param metadata_store_id  The {metadatastore} portion of the resource name with the format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  ///  If not provided, the MetadataStore's ID will be a UUID generated by the
  ///  service.
  ///  Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
  ///  Must be unique across all MetadataStores in the parent Location.
  ///  (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
  ///  if the caller can't view the preexisting MetadataStore.)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.MetadataStore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateMetadataStoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L391}
  /// [google.cloud.aiplatform.v1.MetadataStore]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_store.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
  CreateMetadataStore(
      std::string const& parent,
      google::cloud::aiplatform::v1::MetadataStore const& metadata_store,
      std::string const& metadata_store_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMetadataStore
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMetadataStore(
      NoAwaitTag, std::string const& parent,
      google::cloud::aiplatform::v1::MetadataStore const& metadata_store,
      std::string const& metadata_store_id, Options opts = {});

  // clang-format off
  ///
  /// Initializes a MetadataStore, including allocation of resources.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateMetadataStoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.MetadataStore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateMetadataStoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L391}
  /// [google.cloud.aiplatform.v1.MetadataStore]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_store.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
  CreateMetadataStore(
      google::cloud::aiplatform::v1::CreateMetadataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMetadataStore
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMetadataStore(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateMetadataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMetadataStore
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
  CreateMetadataStore(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific MetadataStore.
  ///
  /// @param name  Required. The resource name of the MetadataStore to retrieve.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.MetadataStore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetMetadataStoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L425}
  /// [google.cloud.aiplatform.v1.MetadataStore]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_store.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::MetadataStore> GetMetadataStore(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific MetadataStore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetMetadataStoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.MetadataStore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetMetadataStoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L425}
  /// [google.cloud.aiplatform.v1.MetadataStore]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_store.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::MetadataStore> GetMetadataStore(
      google::cloud::aiplatform::v1::GetMetadataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists MetadataStores for a Location.
  ///
  /// @param parent  Required. The Location whose MetadataStores should be listed.
  ///  Format:
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.MetadataStore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListMetadataStoresRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L439}
  /// [google.cloud.aiplatform.v1.MetadataStore]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_store.proto#L34}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::MetadataStore> ListMetadataStores(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists MetadataStores for a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListMetadataStoresRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.MetadataStore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListMetadataStoresRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L439}
  /// [google.cloud.aiplatform.v1.MetadataStore]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_store.proto#L34}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::MetadataStore> ListMetadataStores(
      google::cloud::aiplatform::v1::ListMetadataStoresRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single MetadataStore and all its child resources (Artifacts,
  /// Executions, and Contexts).
  ///
  /// @param name  Required. The resource name of the MetadataStore to delete.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteMetadataStoreOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteMetadataStoreOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L497}
  /// [google.cloud.aiplatform.v1.DeleteMetadataStoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L480}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
  DeleteMetadataStore(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMetadataStore
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMetadataStore(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single MetadataStore and all its child resources (Artifacts,
  /// Executions, and Contexts).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteMetadataStoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteMetadataStoreOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteMetadataStoreOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L497}
  /// [google.cloud.aiplatform.v1.DeleteMetadataStoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L480}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
  DeleteMetadataStore(
      google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMetadataStore
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMetadataStore(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMetadataStore
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
  DeleteMetadataStore(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Creates an Artifact associated with a MetadataStore.
  ///
  /// @param parent  Required. The resource name of the MetadataStore where the Artifact should
  ///  be created.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param artifact  Required. The Artifact to create.
  /// @param artifact_id  The {artifact} portion of the resource name with the format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  ///  If not provided, the Artifact's ID will be a UUID generated by the service.
  ///  Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
  ///  Must be unique across all Artifacts in the parent MetadataStore. (Otherwise
  ///  the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
  ///  caller can't view the preexisting Artifact.)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Artifact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Artifact]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L33}
  /// [google.cloud.aiplatform.v1.CreateArtifactRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L504}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Artifact> CreateArtifact(
      std::string const& parent,
      google::cloud::aiplatform::v1::Artifact const& artifact,
      std::string const& artifact_id, Options opts = {});

  // clang-format off
  ///
  /// Creates an Artifact associated with a MetadataStore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateArtifactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Artifact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Artifact]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L33}
  /// [google.cloud.aiplatform.v1.CreateArtifactRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L504}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Artifact> CreateArtifact(
      google::cloud::aiplatform::v1::CreateArtifactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific Artifact.
  ///
  /// @param name  Required. The resource name of the Artifact to retrieve.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Artifact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Artifact]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L33}
  /// [google.cloud.aiplatform.v1.GetArtifactRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L531}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Artifact> GetArtifact(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific Artifact.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetArtifactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Artifact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Artifact]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L33}
  /// [google.cloud.aiplatform.v1.GetArtifactRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L531}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Artifact> GetArtifact(
      google::cloud::aiplatform::v1::GetArtifactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Artifacts in the MetadataStore.
  ///
  /// @param parent  Required. The MetadataStore whose Artifacts should be listed.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Artifact], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Artifact]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L33}
  /// [google.cloud.aiplatform.v1.ListArtifactsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L545}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Artifact> ListArtifacts(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Artifacts in the MetadataStore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListArtifactsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Artifact], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Artifact]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L33}
  /// [google.cloud.aiplatform.v1.ListArtifactsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L545}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Artifact> ListArtifacts(
      google::cloud::aiplatform::v1::ListArtifactsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a stored Artifact.
  ///
  /// @param artifact  Required. The Artifact containing updates.
  ///  The Artifact's [Artifact.name][google.cloud.aiplatform.v1.Artifact.name]
  ///  field is used to identify the Artifact to be updated. Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  /// @param update_mask  Optional. A FieldMask indicating which fields should be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Artifact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Artifact]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L33}
  /// [google.cloud.aiplatform.v1.Artifact.name]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L54}
  /// [google.cloud.aiplatform.v1.UpdateArtifactRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L626}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Artifact> UpdateArtifact(
      google::cloud::aiplatform::v1::Artifact const& artifact,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a stored Artifact.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateArtifactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Artifact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Artifact]: @googleapis_reference_link{google/cloud/aiplatform/v1/artifact.proto#L33}
  /// [google.cloud.aiplatform.v1.UpdateArtifactRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L626}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Artifact> UpdateArtifact(
      google::cloud::aiplatform::v1::UpdateArtifactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an Artifact.
  ///
  /// @param name  Required. The resource name of the Artifact to delete.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteArtifactRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L645}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteArtifact(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteArtifact
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteArtifact(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an Artifact.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteArtifactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteArtifactRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L645}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteArtifact(
      google::cloud::aiplatform::v1::DeleteArtifactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteArtifact
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteArtifact(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteArtifactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteArtifact
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteArtifact(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Purges Artifacts.
  ///
  /// @param parent  Required. The metadata store to purge Artifacts from.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.PurgeArtifactsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.PurgeArtifactsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L664}
  /// [google.cloud.aiplatform.v1.PurgeArtifactsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L687}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
  PurgeArtifacts(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeArtifacts
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PurgeArtifacts(
      NoAwaitTag, std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Purges Artifacts.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.PurgeArtifactsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.PurgeArtifactsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.PurgeArtifactsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L664}
  /// [google.cloud.aiplatform.v1.PurgeArtifactsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L687}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
  PurgeArtifacts(
      google::cloud::aiplatform::v1::PurgeArtifactsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeArtifacts
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PurgeArtifacts(
      NoAwaitTag,
      google::cloud::aiplatform::v1::PurgeArtifactsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeArtifacts
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
  PurgeArtifacts(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Creates a Context associated with a MetadataStore.
  ///
  /// @param parent  Required. The resource name of the MetadataStore where the Context should
  ///  be created. Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param context  Required. The Context to create.
  /// @param context_id  The {context} portion of the resource name with the format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`.
  ///  If not provided, the Context's ID will be a UUID generated by the service.
  ///  Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
  ///  Must be unique across all Contexts in the parent MetadataStore. (Otherwise
  ///  the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
  ///  caller can't view the preexisting Context.)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Context])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Context]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L33}
  /// [google.cloud.aiplatform.v1.CreateContextRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L709}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Context> CreateContext(
      std::string const& parent,
      google::cloud::aiplatform::v1::Context const& context,
      std::string const& context_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a Context associated with a MetadataStore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateContextRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Context])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Context]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L33}
  /// [google.cloud.aiplatform.v1.CreateContextRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L709}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Context> CreateContext(
      google::cloud::aiplatform::v1::CreateContextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific Context.
  ///
  /// @param name  Required. The resource name of the Context to retrieve.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Context])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Context]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L33}
  /// [google.cloud.aiplatform.v1.GetContextRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L735}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Context> GetContext(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific Context.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetContextRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Context])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Context]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L33}
  /// [google.cloud.aiplatform.v1.GetContextRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L735}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Context> GetContext(
      google::cloud::aiplatform::v1::GetContextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Contexts on the MetadataStore.
  ///
  /// @param parent  Required. The MetadataStore whose Contexts should be listed.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Context], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Context]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L33}
  /// [google.cloud.aiplatform.v1.ListContextsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L749}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Context> ListContexts(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Contexts on the MetadataStore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListContextsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Context], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Context]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L33}
  /// [google.cloud.aiplatform.v1.ListContextsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L749}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Context> ListContexts(
      google::cloud::aiplatform::v1::ListContextsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a stored Context.
  ///
  /// @param context  Required. The Context containing updates.
  ///  The Context's [Context.name][google.cloud.aiplatform.v1.Context.name] field
  ///  is used to identify the Context to be updated. Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// @param update_mask  Optional. A FieldMask indicating which fields should be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Context])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Context]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L33}
  /// [google.cloud.aiplatform.v1.Context.name]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L40}
  /// [google.cloud.aiplatform.v1.UpdateContextRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L834}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Context> UpdateContext(
      google::cloud::aiplatform::v1::Context const& context,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a stored Context.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateContextRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Context])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Context]: @googleapis_reference_link{google/cloud/aiplatform/v1/context.proto#L33}
  /// [google.cloud.aiplatform.v1.UpdateContextRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L834}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Context> UpdateContext(
      google::cloud::aiplatform::v1::UpdateContextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a stored Context.
  ///
  /// @param name  Required. The resource name of the Context to delete.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteContextRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L852}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteContext(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteContext
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteContext(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a stored Context.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteContextRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteContextRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L852}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteContext(
      google::cloud::aiplatform::v1::DeleteContextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteContext
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteContext(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteContextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteContext
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteContext(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Purges Contexts.
  ///
  /// @param parent  Required. The metadata store to purge Contexts from.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.PurgeContextsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.PurgeContextsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L875}
  /// [google.cloud.aiplatform.v1.PurgeContextsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L898}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
  PurgeContexts(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeContexts
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PurgeContexts(
      NoAwaitTag, std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Purges Contexts.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.PurgeContextsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.PurgeContextsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.PurgeContextsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L875}
  /// [google.cloud.aiplatform.v1.PurgeContextsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L898}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
  PurgeContexts(
      google::cloud::aiplatform::v1::PurgeContextsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeContexts
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PurgeContexts(
      NoAwaitTag,
      google::cloud::aiplatform::v1::PurgeContextsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeContexts
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
  PurgeContexts(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Adds a set of Artifacts and Executions to a Context. If any of the
  /// Artifacts or Executions have already been added to a Context, they are
  /// simply skipped.
  ///
  /// @param context  Required. The resource name of the Context that the Artifacts and
  ///  Executions belong to. Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// @param artifacts  The resource names of the Artifacts to attribute to the Context.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  /// @param executions  The resource names of the Executions to associate with the
  ///  Context.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L920}
  /// [google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L951}
  ///
  // clang-format on
  StatusOr<
      google::cloud::aiplatform::v1::AddContextArtifactsAndExecutionsResponse>
  AddContextArtifactsAndExecutions(std::string const& context,
                                   std::vector<std::string> const& artifacts,
                                   std::vector<std::string> const& executions,
                                   Options opts = {});

  // clang-format off
  ///
  /// Adds a set of Artifacts and Executions to a Context. If any of the
  /// Artifacts or Executions have already been added to a Context, they are
  /// simply skipped.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L920}
  /// [google.cloud.aiplatform.v1.AddContextArtifactsAndExecutionsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L951}
  ///
  // clang-format on
  StatusOr<
      google::cloud::aiplatform::v1::AddContextArtifactsAndExecutionsResponse>
  AddContextArtifactsAndExecutions(
      google::cloud::aiplatform::v1::
          AddContextArtifactsAndExecutionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Adds a set of Contexts as children to a parent Context. If any of the
  /// child Contexts have already been added to the parent Context, they are
  /// simply skipped. If this call would create a cycle or cause any Context to
  /// have more than 10 parents, the request will fail with an INVALID_ARGUMENT
  /// error.
  ///
  /// @param context  Required. The resource name of the parent Context.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// @param child_contexts  The resource names of the child Contexts.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.AddContextChildrenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.AddContextChildrenRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L955}
  /// [google.cloud.aiplatform.v1.AddContextChildrenResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L975}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::AddContextChildrenResponse>
  AddContextChildren(std::string const& context,
                     std::vector<std::string> const& child_contexts,
                     Options opts = {});

  // clang-format off
  ///
  /// Adds a set of Contexts as children to a parent Context. If any of the
  /// child Contexts have already been added to the parent Context, they are
  /// simply skipped. If this call would create a cycle or cause any Context to
  /// have more than 10 parents, the request will fail with an INVALID_ARGUMENT
  /// error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.AddContextChildrenRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.AddContextChildrenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.AddContextChildrenRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L955}
  /// [google.cloud.aiplatform.v1.AddContextChildrenResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L975}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::AddContextChildrenResponse>
  AddContextChildren(
      google::cloud::aiplatform::v1::AddContextChildrenRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Remove a set of children contexts from a parent Context. If any of the
  /// child Contexts were NOT added to the parent Context, they are
  /// simply skipped.
  ///
  /// @param context  Required. The resource name of the parent Context.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// @param child_contexts  The resource names of the child Contexts.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.RemoveContextChildrenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.RemoveContextChildrenRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L979}
  /// [google.cloud.aiplatform.v1.RemoveContextChildrenResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L999}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::RemoveContextChildrenResponse>
  RemoveContextChildren(std::string const& context,
                        std::vector<std::string> const& child_contexts,
                        Options opts = {});

  // clang-format off
  ///
  /// Remove a set of children contexts from a parent Context. If any of the
  /// child Contexts were NOT added to the parent Context, they are
  /// simply skipped.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.RemoveContextChildrenRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.RemoveContextChildrenResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.RemoveContextChildrenRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L979}
  /// [google.cloud.aiplatform.v1.RemoveContextChildrenResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L999}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::RemoveContextChildrenResponse>
  RemoveContextChildren(
      google::cloud::aiplatform::v1::RemoveContextChildrenRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves Artifacts and Executions within the specified Context, connected
  /// by Event edges and returned as a LineageSubgraph.
  ///
  /// @param context  Required. The resource name of the Context whose Artifacts and Executions
  ///  should be retrieved as a LineageSubgraph.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  ///  @n
  ///  The request may error with FAILED_PRECONDITION if the number of Artifacts,
  ///  the number of Executions, or the number of Events that would be returned
  ///  for the Context exceeds 1000.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.LineageSubgraph])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.LineageSubgraph]: @googleapis_reference_link{google/cloud/aiplatform/v1/lineage_subgraph.proto#L33}
  /// [google.cloud.aiplatform.v1.QueryContextLineageSubgraphRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1003}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
  QueryContextLineageSubgraph(std::string const& context, Options opts = {});

  // clang-format off
  ///
  /// Retrieves Artifacts and Executions within the specified Context, connected
  /// by Event edges and returned as a LineageSubgraph.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.QueryContextLineageSubgraphRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.LineageSubgraph])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.LineageSubgraph]: @googleapis_reference_link{google/cloud/aiplatform/v1/lineage_subgraph.proto#L33}
  /// [google.cloud.aiplatform.v1.QueryContextLineageSubgraphRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1003}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
  QueryContextLineageSubgraph(
      google::cloud::aiplatform::v1::QueryContextLineageSubgraphRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an Execution associated with a MetadataStore.
  ///
  /// @param parent  Required. The resource name of the MetadataStore where the Execution should
  ///  be created.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param execution  Required. The Execution to create.
  /// @param execution_id  The {execution} portion of the resource name with the format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  ///  If not provided, the Execution's ID will be a UUID generated by the
  ///  service.
  ///  Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
  ///  Must be unique across all Executions in the parent MetadataStore.
  ///  (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
  ///  if the caller can't view the preexisting Execution.)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Execution])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateExecutionRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1022}
  /// [google.cloud.aiplatform.v1.Execution]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Execution> CreateExecution(
      std::string const& parent,
      google::cloud::aiplatform::v1::Execution const& execution,
      std::string const& execution_id, Options opts = {});

  // clang-format off
  ///
  /// Creates an Execution associated with a MetadataStore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateExecutionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Execution])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateExecutionRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1022}
  /// [google.cloud.aiplatform.v1.Execution]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Execution> CreateExecution(
      google::cloud::aiplatform::v1::CreateExecutionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific Execution.
  ///
  /// @param name  Required. The resource name of the Execution to retrieve.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Execution])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Execution]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L33}
  /// [google.cloud.aiplatform.v1.GetExecutionRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1050}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Execution> GetExecution(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific Execution.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetExecutionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Execution])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Execution]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L33}
  /// [google.cloud.aiplatform.v1.GetExecutionRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1050}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Execution> GetExecution(
      google::cloud::aiplatform::v1::GetExecutionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Executions in the MetadataStore.
  ///
  /// @param parent  Required. The MetadataStore whose Executions should be listed.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Execution], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Execution]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L33}
  /// [google.cloud.aiplatform.v1.ListExecutionsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1064}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Execution> ListExecutions(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Executions in the MetadataStore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListExecutionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Execution], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Execution]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L33}
  /// [google.cloud.aiplatform.v1.ListExecutionsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1064}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Execution> ListExecutions(
      google::cloud::aiplatform::v1::ListExecutionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a stored Execution.
  ///
  /// @param execution  Required. The Execution containing updates.
  ///  The Execution's [Execution.name][google.cloud.aiplatform.v1.Execution.name]
  ///  field is used to identify the Execution to be updated. Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// @param update_mask  Optional. A FieldMask indicating which fields should be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Execution])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Execution]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L33}
  /// [google.cloud.aiplatform.v1.Execution.name]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L64}
  /// [google.cloud.aiplatform.v1.UpdateExecutionRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1145}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Execution> UpdateExecution(
      google::cloud::aiplatform::v1::Execution const& execution,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a stored Execution.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateExecutionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Execution])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Execution]: @googleapis_reference_link{google/cloud/aiplatform/v1/execution.proto#L33}
  /// [google.cloud.aiplatform.v1.UpdateExecutionRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1145}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Execution> UpdateExecution(
      google::cloud::aiplatform::v1::UpdateExecutionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an Execution.
  ///
  /// @param name  Required. The resource name of the Execution to delete.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteExecutionRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1164}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteExecution(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExecution
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteExecution(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an Execution.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteExecutionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteExecutionRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1164}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteExecution(
      google::cloud::aiplatform::v1::DeleteExecutionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExecution
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteExecution(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteExecutionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteExecution
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteExecution(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Purges Executions.
  ///
  /// @param parent  Required. The metadata store to purge Executions from.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.PurgeExecutionsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.PurgeExecutionsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1183}
  /// [google.cloud.aiplatform.v1.PurgeExecutionsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1206}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
  PurgeExecutions(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeExecutions
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PurgeExecutions(
      NoAwaitTag, std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Purges Executions.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.PurgeExecutionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.PurgeExecutionsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.PurgeExecutionsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1183}
  /// [google.cloud.aiplatform.v1.PurgeExecutionsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1206}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
  PurgeExecutions(
      google::cloud::aiplatform::v1::PurgeExecutionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeExecutions
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PurgeExecutions(
      NoAwaitTag,
      google::cloud::aiplatform::v1::PurgeExecutionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeExecutions
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
  PurgeExecutions(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Adds Events to the specified Execution. An Event indicates whether an
  /// Artifact was used as an input or output for an Execution. If an Event
  /// already exists between the Execution and the Artifact, the Event is
  /// skipped.
  ///
  /// @param execution  Required. The resource name of the Execution that the Events connect
  ///  Artifacts with.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// @param events  The Events to create and add.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.AddExecutionEventsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.AddExecutionEventsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1229}
  /// [google.cloud.aiplatform.v1.AddExecutionEventsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1247}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::AddExecutionEventsResponse>
  AddExecutionEvents(
      std::string const& execution,
      std::vector<google::cloud::aiplatform::v1::Event> const& events,
      Options opts = {});

  // clang-format off
  ///
  /// Adds Events to the specified Execution. An Event indicates whether an
  /// Artifact was used as an input or output for an Execution. If an Event
  /// already exists between the Execution and the Artifact, the Event is
  /// skipped.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.AddExecutionEventsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.AddExecutionEventsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.AddExecutionEventsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1229}
  /// [google.cloud.aiplatform.v1.AddExecutionEventsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1247}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::AddExecutionEventsResponse>
  AddExecutionEvents(
      google::cloud::aiplatform::v1::AddExecutionEventsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Obtains the set of input and output Artifacts for this Execution, in the
  /// form of LineageSubgraph that also contains the Execution and connecting
  /// Events.
  ///
  /// @param execution  Required. The resource name of the Execution whose input and output
  ///  Artifacts should be retrieved as a LineageSubgraph. Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.LineageSubgraph])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.LineageSubgraph]: @googleapis_reference_link{google/cloud/aiplatform/v1/lineage_subgraph.proto#L33}
  /// [google.cloud.aiplatform.v1.QueryExecutionInputsAndOutputsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1251}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
  QueryExecutionInputsAndOutputs(std::string const& execution,
                                 Options opts = {});

  // clang-format off
  ///
  /// Obtains the set of input and output Artifacts for this Execution, in the
  /// form of LineageSubgraph that also contains the Execution and connecting
  /// Events.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.QueryExecutionInputsAndOutputsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.LineageSubgraph])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.LineageSubgraph]: @googleapis_reference_link{google/cloud/aiplatform/v1/lineage_subgraph.proto#L33}
  /// [google.cloud.aiplatform.v1.QueryExecutionInputsAndOutputsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1251}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
  QueryExecutionInputsAndOutputs(
      google::cloud::aiplatform::v1::
          QueryExecutionInputsAndOutputsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a MetadataSchema.
  ///
  /// @param parent  Required. The resource name of the MetadataStore where the MetadataSchema
  ///  should be created. Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param metadata_schema  Required. The MetadataSchema to create.
  /// @param metadata_schema_id  The {metadata_schema} portion of the resource name with the format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
  ///  If not provided, the MetadataStore's ID will be a UUID generated by the
  ///  service.
  ///  Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
  ///  Must be unique across all MetadataSchemas in the parent Location.
  ///  (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
  ///  if the caller can't view the preexisting MetadataSchema.)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.MetadataSchema])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateMetadataSchemaRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1265}
  /// [google.cloud.aiplatform.v1.MetadataSchema]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_schema.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::MetadataSchema> CreateMetadataSchema(
      std::string const& parent,
      google::cloud::aiplatform::v1::MetadataSchema const& metadata_schema,
      std::string const& metadata_schema_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a MetadataSchema.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateMetadataSchemaRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.MetadataSchema])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateMetadataSchemaRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1265}
  /// [google.cloud.aiplatform.v1.MetadataSchema]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_schema.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::MetadataSchema> CreateMetadataSchema(
      google::cloud::aiplatform::v1::CreateMetadataSchemaRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific MetadataSchema.
  ///
  /// @param name  Required. The resource name of the MetadataSchema to retrieve.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.MetadataSchema])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetMetadataSchemaRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1292}
  /// [google.cloud.aiplatform.v1.MetadataSchema]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_schema.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::MetadataSchema> GetMetadataSchema(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a specific MetadataSchema.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetMetadataSchemaRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.MetadataSchema])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetMetadataSchemaRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1292}
  /// [google.cloud.aiplatform.v1.MetadataSchema]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_schema.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::MetadataSchema> GetMetadataSchema(
      google::cloud::aiplatform::v1::GetMetadataSchemaRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists MetadataSchemas.
  ///
  /// @param parent  Required. The MetadataStore whose MetadataSchemas should be listed.
  ///  Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.MetadataSchema], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListMetadataSchemasRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1306}
  /// [google.cloud.aiplatform.v1.MetadataSchema]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_schema.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::MetadataSchema>
  ListMetadataSchemas(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists MetadataSchemas.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListMetadataSchemasRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.MetadataSchema], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListMetadataSchemasRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1306}
  /// [google.cloud.aiplatform.v1.MetadataSchema]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_schema.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::MetadataSchema>
  ListMetadataSchemas(
      google::cloud::aiplatform::v1::ListMetadataSchemasRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves lineage of an Artifact represented through Artifacts and
  /// Executions connected by Event edges and returned as a LineageSubgraph.
  ///
  /// @param artifact  Required. The resource name of the Artifact whose Lineage needs to be
  ///  retrieved as a LineageSubgraph. Format:
  ///  `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  ///  @n
  ///  The request may error with FAILED_PRECONDITION if the number of Artifacts,
  ///  the number of Executions, or the number of Events that would be returned
  ///  for the Context exceeds 1000.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.LineageSubgraph])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.LineageSubgraph]: @googleapis_reference_link{google/cloud/aiplatform/v1/lineage_subgraph.proto#L33}
  /// [google.cloud.aiplatform.v1.QueryArtifactLineageSubgraphRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1350}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
  QueryArtifactLineageSubgraph(std::string const& artifact, Options opts = {});

  // clang-format off
  ///
  /// Retrieves lineage of an Artifact represented through Artifacts and
  /// Executions connected by Event edges and returned as a LineageSubgraph.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.QueryArtifactLineageSubgraphRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.LineageSubgraph])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.LineageSubgraph]: @googleapis_reference_link{google/cloud/aiplatform/v1/lineage_subgraph.proto#L33}
  /// [google.cloud.aiplatform.v1.QueryArtifactLineageSubgraphRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/metadata_service.proto#L1350}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
  QueryArtifactLineageSubgraph(
      google::cloud::aiplatform::v1::QueryArtifactLineageSubgraphRequest const&
          request,
      Options opts = {});

 private:
  std::shared_ptr<MetadataServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_METADATA_CLIENT_H
