// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/job_service.proto

#include "google/cloud/aiplatform/v1/job_connection.h"
#include "google/cloud/aiplatform/v1/internal/job_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/job_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/job_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/job_tracing_connection.h"
#include "google/cloud/aiplatform/v1/job_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

JobServiceConnection::~JobServiceConnection() = default;

StatusOr<google::cloud::aiplatform::v1::CustomJob>
JobServiceConnection::CreateCustomJob(
    google::cloud::aiplatform::v1::CreateCustomJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::CustomJob>
JobServiceConnection::GetCustomJob(
    google::cloud::aiplatform::v1::GetCustomJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::CustomJob>
JobServiceConnection::ListCustomJobs(
    google::cloud::aiplatform::v1::
        ListCustomJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::CustomJob>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteCustomJob(
    google::cloud::aiplatform::v1::DeleteCustomJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> JobServiceConnection::DeleteCustomJob(
    NoAwaitTag, google::cloud::aiplatform::v1::DeleteCustomJobRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteCustomJob(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status JobServiceConnection::CancelCustomJob(
    google::cloud::aiplatform::v1::CancelCustomJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceConnection::CreateDataLabelingJob(
    google::cloud::aiplatform::v1::CreateDataLabelingJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceConnection::GetDataLabelingJob(
    google::cloud::aiplatform::v1::GetDataLabelingJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceConnection::ListDataLabelingJobs(
    google::cloud::aiplatform::v1::
        ListDataLabelingJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::DataLabelingJob>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteDataLabelingJob(
    google::cloud::aiplatform::v1::DeleteDataLabelingJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
JobServiceConnection::DeleteDataLabelingJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteDataLabelingJobRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteDataLabelingJob(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status JobServiceConnection::CancelDataLabelingJob(
    google::cloud::aiplatform::v1::CancelDataLabelingJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceConnection::CreateHyperparameterTuningJob(
    google::cloud::aiplatform::v1::
        CreateHyperparameterTuningJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceConnection::GetHyperparameterTuningJob(
    google::cloud::aiplatform::v1::GetHyperparameterTuningJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceConnection::ListHyperparameterTuningJobs(
    google::cloud::aiplatform::v1::
        ListHyperparameterTuningJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::HyperparameterTuningJob>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteHyperparameterTuningJob(
    google::cloud::aiplatform::v1::
        DeleteHyperparameterTuningJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
JobServiceConnection::DeleteHyperparameterTuningJob(
    NoAwaitTag, google::cloud::aiplatform::v1::
                    DeleteHyperparameterTuningJobRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteHyperparameterTuningJob(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status JobServiceConnection::CancelHyperparameterTuningJob(
    google::cloud::aiplatform::v1::
        CancelHyperparameterTuningJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::NasJob>
JobServiceConnection::CreateNasJob(
    google::cloud::aiplatform::v1::CreateNasJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::NasJob> JobServiceConnection::GetNasJob(
    google::cloud::aiplatform::v1::GetNasJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::NasJob>
JobServiceConnection::ListNasJobs(
    google::cloud::aiplatform::v1::
        ListNasJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::NasJob>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteNasJob(
    google::cloud::aiplatform::v1::DeleteNasJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> JobServiceConnection::DeleteNasJob(
    NoAwaitTag, google::cloud::aiplatform::v1::DeleteNasJobRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteNasJob(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status JobServiceConnection::CancelNasJob(
    google::cloud::aiplatform::v1::CancelNasJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::NasTrialDetail>
JobServiceConnection::GetNasTrialDetail(
    google::cloud::aiplatform::v1::GetNasTrialDetailRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::NasTrialDetail>
JobServiceConnection::ListNasTrialDetails(
    google::cloud::aiplatform::v1::
        ListNasTrialDetailsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::NasTrialDetail>>();
}

StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceConnection::CreateBatchPredictionJob(
    google::cloud::aiplatform::v1::CreateBatchPredictionJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceConnection::GetBatchPredictionJob(
    google::cloud::aiplatform::v1::GetBatchPredictionJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceConnection::ListBatchPredictionJobs(
    google::cloud::aiplatform::v1::
        ListBatchPredictionJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::BatchPredictionJob>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteBatchPredictionJob(
    google::cloud::aiplatform::v1::DeleteBatchPredictionJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
JobServiceConnection::DeleteBatchPredictionJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteBatchPredictionJobRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteBatchPredictionJob(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status JobServiceConnection::CancelBatchPredictionJob(
    google::cloud::aiplatform::v1::CancelBatchPredictionJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceConnection::CreateModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        CreateModelDeploymentMonitoringJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::ModelMonitoringStatsAnomalies>
JobServiceConnection::SearchModelDeploymentMonitoringStatsAnomalies(
    google::cloud::aiplatform::v1::
        SearchModelDeploymentMonitoringStatsAnomaliesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      google::cloud::aiplatform::v1::ModelMonitoringStatsAnomalies>>();
}

StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceConnection::GetModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        GetModelDeploymentMonitoringJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceConnection::ListModelDeploymentMonitoringJobs(
    google::cloud::aiplatform::v1::
        ListModelDeploymentMonitoringJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>();
}

future<StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>
JobServiceConnection::UpdateModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        UpdateModelDeploymentMonitoringJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
JobServiceConnection::UpdateModelDeploymentMonitoringJob(
    NoAwaitTag, google::cloud::aiplatform::v1::
                    UpdateModelDeploymentMonitoringJobRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>
JobServiceConnection::UpdateModelDeploymentMonitoringJob(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        DeleteModelDeploymentMonitoringJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
JobServiceConnection::DeleteModelDeploymentMonitoringJob(
    NoAwaitTag, google::cloud::aiplatform::v1::
                    DeleteModelDeploymentMonitoringJobRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceConnection::DeleteModelDeploymentMonitoringJob(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status JobServiceConnection::PauseModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        PauseModelDeploymentMonitoringJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status JobServiceConnection::ResumeModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        ResumeModelDeploymentMonitoringJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<JobServiceConnection> MakeJobServiceConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 JobServicePolicyOptionList>(options, __func__);
  options = aiplatform_v1_internal::JobServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = aiplatform_v1_internal::CreateDefaultJobServiceStub(
      std::move(auth), options);
  return aiplatform_v1_internal::MakeJobServiceTracingConnection(
      std::make_shared<aiplatform_v1_internal::JobServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
