/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __SBP2_POINTER_H__
#define __SBP2_POINTER_H__


#include <glib.h>


typedef struct _SBP2Pointer SBP2Pointer;

struct _SBP2Pointer
{
#if G_BYTE_ORDER == G_BIG_ENDIAN
  guint   node    : 16;
  guint   addr_hi : 16;
#else
  guint   addr_hi : 16;
  guint   node    : 16;
#endif
  guint32 addr_lo;
};


static inline guint64
sbp2_pointer_to_1394_address (SBP2Pointer *p)
{
  guint64 address;

  address = p->addr_lo;
  address |= (guint64) p->addr_hi << 32;

  return address;
}

static inline void
sbp2_pointer_from_1394_address (SBP2Pointer *p,
                                guint64      address)
{
  p->addr_lo = address & 0xffffffff;
  p->addr_hi |= (address >> 32) & 0xffff;
}


static inline gboolean
sbp2_pointer_is_null_orb (SBP2Pointer *p)
{
  return p->node & 0x8000;
}


#endif /* __SBP2_POINTER_H__ */
