## lab mr create

Creates a merge request.

```
lab mr create [target_remote [target_branch]] [flags]
```

### Examples

```
lab mr create target_remote
lab mr create target_remote target_branch --allow-collaboration
lab mr create upstream main --source my_fork:feature-3
lab mr create a_remote -a johndoe -a janedoe
lab mr create my_remote -c
lab mr create my_remote --draft
lab mr create my_remote -F a_file.txt
lab mr create my_remote -F a_file.txt --force-linebreak
lab mr create my_remote -f a_file.txt
lab mr create my_remote -l bug -l confirmed
lab mr create my_remote -m "A title message"
lab mr create my_remote -m "A MR title" -m "A MR description"
lab mr create my_remote --milestone "Fall"
lab mr create my_remote -d
lab mr create my_remote -r johndoe -r janedoe
lab mr create my_remote -s
```

### Options

```
      --allow-collaboration    allow commits from other members
  -a, --assignee strings       set assignee by username; can be specified multiple times for multiple assignees
  -c, --cover-letter           comment changelog and diffstat
      --draft                  mark the merge request as draft
  -F, --file string            use the given file as the Title and Description
  -f, --file-edit string       use the given file as the Title and Description and open the editor
      --force-linebreak        append 2 spaces to the end of each line to force markdown linebreaks
  -h, --help                   help for create
  -l, --label strings          add label <label>; can be specified multiple times for multiple labels
  -m, --message stringArray    use the given <msg>; multiple -m are concatenated as separate paragraphs
      --milestone string       set milestone by milestone title or ID
      --no-edit                use the selected commit message without opening the editor
  -d, --remove-source-branch   remove source branch from remote after merge
  -r, --reviewer strings       set reviewer by username; can be specified multiple times for multiple reviewers
      --source string          specify the source remote and branch in the form of remote:branch
  -s, --squash                 squash commits when merging
```

### Options inherited from parent commands

```
      --debug      Enable debug logging level
      --no-pager   Do not pipe output into a pager
      --quiet      Turn off any sort of logging. Only command output is printed
```

### SEE ALSO

* [lab mr](lab_mr.md)	 - Describe, list, and create merge requests

###### Auto generated by spf13/cobra on 27-Jun-2022
