/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.util;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.util.InvalidNumberException;
import org.whispersystems.signalservice.internal.util.Util;

public class PhoneNumberFormatter {
    private static final String TAG = PhoneNumberFormatter.class.getSimpleName();
    private static final String COUNTRY_CODE_BR = "55";
    private static final String COUNTRY_CODE_US = "1";

    public static boolean isValidNumber(String e164Number, String countryCode) {
        if (!PhoneNumberUtil.getInstance().isPossibleNumber((CharSequence)e164Number, countryCode)) {
            Log.w((String)TAG, (String)"Failed isPossibleNumber()");
            return false;
        }
        if (COUNTRY_CODE_US.equals(countryCode) && !Pattern.matches("^\\+1[0-9]{10}$", e164Number)) {
            Log.w((String)TAG, (String)"Failed US number format check");
            return false;
        }
        if (COUNTRY_CODE_BR.equals(countryCode) && !Pattern.matches("^\\+55[0-9]{2}9?[0-9]{8}$", e164Number)) {
            Log.w((String)TAG, (String)"Failed Brazil number format check");
            return false;
        }
        return e164Number.matches("^\\+[1-9][0-9]{6,14}$");
    }

    private static String impreciseFormatNumber(String number, String localNumber) throws InvalidNumberException {
        if ((number = number.replaceAll("[^0-9+]", "")).charAt(0) == '+') {
            return number;
        }
        if (localNumber.charAt(0) == '+') {
            localNumber = localNumber.substring(1);
        }
        if (localNumber.length() == number.length() || number.length() > localNumber.length()) {
            return "+" + number;
        }
        int difference = localNumber.length() - number.length();
        return "+" + localNumber.substring(0, difference) + number;
    }

    public static String formatNumberInternational(String number) {
        try {
            PhoneNumberUtil util = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber parsedNumber = util.parse((CharSequence)number, null);
            return util.format(parsedNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        }
        catch (NumberParseException e) {
            Log.w((String)TAG, (Throwable)e);
            return number;
        }
    }

    public static String formatNumber(String number, String localNumber) throws InvalidNumberException {
        if (number == null) {
            throw new InvalidNumberException("Null String passed as number.");
        }
        if (number.contains("@")) {
            throw new InvalidNumberException("Possible attempt to use email address.");
        }
        if ((number = number.replaceAll("[^0-9+]", "")).length() == 0) {
            throw new InvalidNumberException("No valid characters found.");
        }
        try {
            PhoneNumberUtil util = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber localNumberObject = util.parse((CharSequence)localNumber, null);
            String localCountryCode = util.getRegionCodeForNumber(localNumberObject);
            Log.w((String)TAG, (String)("Got local CC: " + localCountryCode));
            Phonenumber.PhoneNumber numberObject = util.parse((CharSequence)number, localCountryCode);
            return util.format(numberObject, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (NumberParseException e) {
            Log.d((String)TAG, (String)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage()));
            return PhoneNumberFormatter.impreciseFormatNumber(number, localNumber);
        }
    }

    @Deprecated
    public static String getRegionDisplayNameLegacy(String regionCode) {
        return PhoneNumberFormatter.getRegionDisplayName(regionCode).orElse("Unknown country");
    }

    public static Optional<String> getRegionDisplayName(String regionCode) {
        String displayCountry;
        if (!(regionCode == null || regionCode.equals("ZZ") || regionCode.equals("001") || Util.isEmpty(displayCountry = new Locale("", regionCode).getDisplayCountry(Locale.getDefault())))) {
            return Optional.of(displayCountry);
        }
        return Optional.empty();
    }

    public static String formatE164(String countryCode, String number) {
        try {
            PhoneNumberUtil util = PhoneNumberUtil.getInstance();
            int parsedCountryCode = Integer.parseInt(countryCode);
            Phonenumber.PhoneNumber parsedNumber = util.parse((CharSequence)number, util.getRegionCodeForCountryCode(parsedCountryCode));
            return util.format(parsedNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (NumberParseException | NumberFormatException npe) {
            Log.d((String)TAG, (String)(npe.getClass().getSimpleName() + ": " + npe.getMessage()));
            return "+" + countryCode.replaceAll("[^0-9]", "").replaceAll("^0*", "") + (number != null ? number.replaceAll("[^0-9]", "") : "");
        }
    }

    public static String getInternationalFormatFromE164(String e164number) {
        try {
            PhoneNumberUtil util = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber parsedNumber = util.parse((CharSequence)e164number, null);
            return util.format(parsedNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        }
        catch (NumberParseException e) {
            Log.w((String)TAG, (Throwable)e);
            return e164number;
        }
    }
}

