/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import okio.ByteString;
import org.signal.core.util.Base64;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.whispersystems.signalservice.internal.devices.DeviceName;
import org.whispersystems.signalservice.internal.util.Util;

public final class DeviceNameUtil {
    public static String encryptDeviceName(String plainTextDeviceName, ECPrivateKey identityKey) {
        byte[] plainText = plainTextDeviceName.getBytes(StandardCharsets.UTF_8);
        ECKeyPair ephemeralKeyPair = Curve.generateKeyPair();
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            byte[] masterSecret = Curve.calculateAgreement((ECPublicKey)ephemeralKeyPair.getPublicKey(), (ECPrivateKey)identityKey);
            mac.init(new SecretKeySpec(masterSecret, "HmacSHA256"));
            byte[] key1 = mac.doFinal("auth".getBytes());
            mac.init(new SecretKeySpec(key1, "HmacSHA256"));
            byte[] syntheticIv = ByteUtil.trim((byte[])mac.doFinal(plainText), (int)16);
            mac.init(new SecretKeySpec(masterSecret, "HmacSHA256"));
            byte[] key2 = mac.doFinal("cipher".getBytes());
            mac.init(new SecretKeySpec(key2, "HmacSHA256"));
            byte[] cipherKey = mac.doFinal(syntheticIv);
            cipher.init(1, (Key)new SecretKeySpec(cipherKey, "AES"), new IvParameterSpec(new byte[16]));
            byte[] cipherText = cipher.doFinal(plainText);
            DeviceName deviceName = new DeviceName.Builder().ciphertext(ByteString.of((byte[])cipherText)).ephemeralPublic(ByteString.of((byte[])ephemeralKeyPair.getPublicKey().serialize())).syntheticIv(ByteString.of((byte[])syntheticIv)).build();
            return Base64.encodeWithPadding((byte[])deviceName.encode());
        }
        catch (GeneralSecurityException | InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String decryptDeviceName(String encryptedDeviceName, ECPrivateKey identityKey) throws IOException {
        if (Util.isEmpty(encryptedDeviceName) || encryptedDeviceName.length() < 4) {
            throw new IOException("Invalid DeviceInfo name.");
        }
        DeviceName deviceName = (DeviceName)((Object)DeviceName.ADAPTER.decode(Base64.decode((String)encryptedDeviceName)));
        if (deviceName.ciphertext == null || deviceName.ephemeralPublic == null || deviceName.syntheticIv == null) {
            throw new IOException("Got a DeviceName that wasn't properly populated.");
        }
        byte[] syntheticIv = deviceName.syntheticIv.toByteArray();
        byte[] cipherText = deviceName.ciphertext.toByteArray();
        byte[] ephemeralPublicBytes = deviceName.ephemeralPublic.toByteArray();
        try {
            ECPublicKey ephemeralPublic = Curve.decodePoint((byte[])ephemeralPublicBytes, (int)0);
            byte[] masterSecret = Curve.calculateAgreement((ECPublicKey)ephemeralPublic, (ECPrivateKey)identityKey);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(masterSecret, "HmacSHA256"));
            byte[] cipherKeyPart1 = mac.doFinal("cipher".getBytes());
            mac.init(new SecretKeySpec(cipherKeyPart1, "HmacSHA256"));
            byte[] cipherKey = mac.doFinal(syntheticIv);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(cipherKey, "AES"), new IvParameterSpec(new byte[16]));
            byte[] plaintext = cipher.doFinal(cipherText);
            mac.init(new SecretKeySpec(masterSecret, "HmacSHA256"));
            byte[] verificationPart1 = mac.doFinal("auth".getBytes());
            mac.init(new SecretKeySpec(verificationPart1, "HmacSHA256"));
            byte[] verificationPart2 = mac.doFinal(plaintext);
            byte[] ourSyntheticIv = ByteUtil.trim((byte[])verificationPart2, (int)16);
            if (!MessageDigest.isEqual(ourSyntheticIv, syntheticIv)) {
                throw new GeneralSecurityException("The computed syntheticIv didn't match the actual syntheticIv.");
            }
            return new String(plaintext, StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException | InvalidKeyException e) {
            throw new IOException("Failed to decrypt device name", e);
        }
    }
}

