/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import com.squareup.wire.Message;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import okio.ByteString;
import org.signal.core.util.ProtoUtil;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.StoryDistributionListRecord;

public class SignalStoryDistributionListRecord
implements SignalRecord {
    private static final String TAG = SignalStoryDistributionListRecord.class.getSimpleName();
    private final StorageId id;
    private final StoryDistributionListRecord proto;
    private final boolean hasUnknownFields;
    private final List<SignalServiceAddress> recipients;

    public SignalStoryDistributionListRecord(StorageId id, StoryDistributionListRecord proto) {
        this.id = id;
        this.proto = proto;
        this.hasUnknownFields = ProtoUtil.hasUnknownFields((Message)proto);
        this.recipients = proto.recipientServiceIds.stream().map(ServiceId::parseOrNull).filter(Objects::nonNull).map(SignalServiceAddress::new).collect(Collectors.toList());
    }

    @Override
    public StorageId getId() {
        return this.id;
    }

    @Override
    public SignalStorageRecord asStorageRecord() {
        return SignalStorageRecord.forStoryDistributionList(this);
    }

    public StoryDistributionListRecord toProto() {
        return this.proto;
    }

    public byte[] serializeUnknownFields() {
        return this.hasUnknownFields ? this.proto.encode() : null;
    }

    public byte[] getIdentifier() {
        return this.proto.identifier.toByteArray();
    }

    public String getName() {
        return this.proto.name;
    }

    public List<SignalServiceAddress> getRecipients() {
        return this.recipients;
    }

    public long getDeletedAtTimestamp() {
        return this.proto.deletedAtTimestamp;
    }

    public boolean allowsReplies() {
        return this.proto.allowsReplies;
    }

    public boolean isBlockList() {
        return this.proto.isBlockList;
    }

    @Override
    public String describeDiff(SignalRecord other) {
        if (other instanceof SignalStoryDistributionListRecord) {
            SignalStoryDistributionListRecord that = (SignalStoryDistributionListRecord)other;
            LinkedList<String> diff = new LinkedList<String>();
            if (!Arrays.equals(this.id.getRaw(), that.id.getRaw())) {
                diff.add("ID");
            }
            if (!Arrays.equals(this.getIdentifier(), that.getIdentifier())) {
                diff.add("Identifier");
            }
            if (!Objects.equals(this.getName(), that.getName())) {
                diff.add("Name");
            }
            if (!Objects.equals(this.recipients, that.recipients)) {
                diff.add("RecipientUuids");
            }
            if (this.getDeletedAtTimestamp() != that.getDeletedAtTimestamp()) {
                diff.add("DeletedAtTimestamp");
            }
            if (this.allowsReplies() != that.allowsReplies()) {
                diff.add("AllowsReplies");
            }
            if (this.isBlockList() != that.isBlockList()) {
                diff.add("BlockList");
            }
            return ((Object)diff).toString();
        }
        return "Different class. " + this.getClass().getSimpleName() + " | " + other.getClass().getSimpleName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalStoryDistributionListRecord that = (SignalStoryDistributionListRecord)o;
        return this.id.equals(that.id) && this.proto.equals((Object)that.proto);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.proto});
    }

    public static final class Builder {
        private final StorageId id;
        private final StoryDistributionListRecord.Builder builder;

        public Builder(byte[] rawId, byte[] serializedUnknowns) {
            this.id = StorageId.forStoryDistributionList(rawId);
            this.builder = serializedUnknowns != null ? Builder.parseUnknowns(serializedUnknowns) : new StoryDistributionListRecord.Builder();
        }

        public Builder setIdentifier(byte[] identifier) {
            this.builder.identifier(ByteString.of((byte[])identifier));
            return this;
        }

        public Builder setName(String name) {
            this.builder.name(name);
            return this;
        }

        public Builder setRecipients(List<SignalServiceAddress> recipients) {
            this.builder.recipientServiceIds = recipients.stream().map(SignalServiceAddress::getIdentifier).collect(Collectors.toList());
            return this;
        }

        public Builder setDeletedAtTimestamp(long deletedAtTimestamp) {
            this.builder.deletedAtTimestamp(deletedAtTimestamp);
            return this;
        }

        public Builder setAllowsReplies(boolean allowsReplies) {
            this.builder.allowsReplies(allowsReplies);
            return this;
        }

        public Builder setIsBlockList(boolean isBlockList) {
            this.builder.isBlockList(isBlockList);
            return this;
        }

        public SignalStoryDistributionListRecord build() {
            return new SignalStoryDistributionListRecord(this.id, this.builder.build());
        }

        private static StoryDistributionListRecord.Builder parseUnknowns(byte[] serializedUnknowns) {
            try {
                return ((StoryDistributionListRecord)((Object)StoryDistributionListRecord.ADAPTER.decode(serializedUnknowns))).newBuilder();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Failed to combine unknown fields!", (Throwable)e);
                return new StoryDistributionListRecord.Builder();
            }
        }
    }
}

