/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.CallLinkRecord;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0005R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/whispersystems/signalservice/api/storage/SignalCallLinkRecord;", "Lorg/whispersystems/signalservice/api/storage/SignalRecord;", "id", "Lorg/whispersystems/signalservice/api/storage/StorageId;", "proto", "Lorg/whispersystems/signalservice/internal/storage/protos/CallLinkRecord;", "(Lorg/whispersystems/signalservice/api/storage/StorageId;Lorg/whispersystems/signalservice/internal/storage/protos/CallLinkRecord;)V", "adminPassKey", "", "getAdminPassKey", "()[B", "deletionTimestamp", "", "getDeletionTimestamp", "()J", "rootKey", "getRootKey", "asStorageRecord", "Lorg/whispersystems/signalservice/api/storage/SignalStorageRecord;", "describeDiff", "", "other", "getId", "isDeleted", "", "toProto", "Builder", "signal-service-java"})
public final class SignalCallLinkRecord
implements SignalRecord {
    @NotNull
    private final StorageId id;
    @NotNull
    private final CallLinkRecord proto;
    @NotNull
    private final byte[] rootKey;
    @NotNull
    private final byte[] adminPassKey;
    private final long deletionTimestamp;

    public SignalCallLinkRecord(@NotNull StorageId id, @NotNull CallLinkRecord proto) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)proto), (String)"proto");
        this.id = id;
        this.proto = proto;
        this.rootKey = this.proto.rootKey.toByteArray();
        this.adminPassKey = this.proto.adminPasskey.toByteArray();
        this.deletionTimestamp = this.proto.deletedAtTimestampMs;
    }

    @NotNull
    public final byte[] getRootKey() {
        return this.rootKey;
    }

    @NotNull
    public final byte[] getAdminPassKey() {
        return this.adminPassKey;
    }

    public final long getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @NotNull
    public final CallLinkRecord toProto() {
        return this.proto;
    }

    @Override
    @NotNull
    public StorageId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public SignalStorageRecord asStorageRecord() {
        SignalStorageRecord signalStorageRecord = SignalStorageRecord.forCallLink(this);
        Intrinsics.checkNotNullExpressionValue((Object)signalStorageRecord, (String)"forCallLink(...)");
        return signalStorageRecord;
    }

    @Override
    @NotNull
    public String describeDiff(@Nullable SignalRecord other) {
        Object object;
        SignalRecord signalRecord = other;
        if (signalRecord instanceof SignalCallLinkRecord) {
            LinkedList<String> diff = new LinkedList<String>();
            if (!Arrays.equals(this.rootKey, ((SignalCallLinkRecord)other).rootKey)) {
                diff.add("RootKey");
            }
            if (!Arrays.equals(this.adminPassKey, ((SignalCallLinkRecord)other).adminPassKey)) {
                diff.add("AdminPassKey");
            }
            if (this.deletionTimestamp != ((SignalCallLinkRecord)other).deletionTimestamp) {
                diff.add("DeletionTimestamp");
            }
            String string = diff.toString();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else {
            object = signalRecord == null ? "Other was null!" : "Different class. " + this.getClass().getSimpleName() + " | " + other.getClass().getSimpleName();
        }
        return object;
    }

    public final boolean isDeleted() {
        return this.deletionTimestamp > 0L;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/whispersystems/signalservice/api/storage/SignalCallLinkRecord$Builder;", "", "rawId", "", "serializedUnknowns", "([B[B)V", "builder", "Lorg/whispersystems/signalservice/internal/storage/protos/CallLinkRecord$Builder;", "id", "Lorg/whispersystems/signalservice/api/storage/StorageId;", "build", "Lorg/whispersystems/signalservice/api/storage/SignalCallLinkRecord;", "setAdminPassKey", "adminPasskey", "setDeletedTimestamp", "deletedTimestamp", "", "setRootKey", "rootKey", "Companion", "signal-service-java"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private StorageId id;
        @NotNull
        private CallLinkRecord.Builder builder;

        public Builder(@NotNull byte[] rawId, @Nullable byte[] serializedUnknowns) {
            Intrinsics.checkNotNullParameter((Object)rawId, (String)"rawId");
            StorageId storageId = StorageId.forCallLink(rawId);
            Intrinsics.checkNotNullExpressionValue((Object)storageId, (String)"forCallLink(...)");
            this.id = storageId;
            this.builder = serializedUnknowns != null ? Companion.parseUnknowns(serializedUnknowns) : new CallLinkRecord.Builder();
        }

        @NotNull
        public final Builder setRootKey(@NotNull byte[] rootKey) {
            Intrinsics.checkNotNullParameter((Object)rootKey, (String)"rootKey");
            this.builder.rootKey = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])rootKey, (int)0, (int)0, (int)3, null);
            return this;
        }

        @NotNull
        public final Builder setAdminPassKey(@NotNull byte[] adminPasskey) {
            Intrinsics.checkNotNullParameter((Object)adminPasskey, (String)"adminPasskey");
            this.builder.adminPasskey = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])adminPasskey, (int)0, (int)0, (int)3, null);
            return this;
        }

        @NotNull
        public final Builder setDeletedTimestamp(long deletedTimestamp) {
            this.builder.deletedAtTimestampMs = deletedTimestamp;
            return this;
        }

        @NotNull
        public final SignalCallLinkRecord build() {
            return new SignalCallLinkRecord(this.id, this.builder.build());
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/whispersystems/signalservice/api/storage/SignalCallLinkRecord$Builder$Companion;", "", "()V", "parseUnknowns", "Lorg/whispersystems/signalservice/internal/storage/protos/CallLinkRecord$Builder;", "serializedUnknowns", "", "signal-service-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CallLinkRecord.Builder parseUnknowns(@NotNull byte[] serializedUnknowns) {
                CallLinkRecord.Builder builder;
                Intrinsics.checkNotNullParameter((Object)serializedUnknowns, (String)"serializedUnknowns");
                try {
                    builder = ((CallLinkRecord)((Object)CallLinkRecord.ADAPTER.decode(serializedUnknowns))).newBuilder();
                }
                catch (IOException e) {
                    builder = new CallLinkRecord.Builder();
                }
                return builder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

