/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.archive;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.Base64;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/archive/ArchiveCredentialPresentation;", "", "presentation", "", "signedPresentation", "([B[B)V", "getPresentation", "()[B", "getSignedPresentation", "toHeaders", "", "", "signal-service-java"})
public final class ArchiveCredentialPresentation {
    @NotNull
    private final byte[] presentation;
    @NotNull
    private final byte[] signedPresentation;

    public ArchiveCredentialPresentation(@NotNull byte[] presentation, @NotNull byte[] signedPresentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)signedPresentation, (String)"signedPresentation");
        this.presentation = presentation;
        this.signedPresentation = signedPresentation;
    }

    @NotNull
    public final byte[] getPresentation() {
        return this.presentation;
    }

    @NotNull
    public final byte[] getSignedPresentation() {
        return this.signedPresentation;
    }

    @NotNull
    public final Map<String, String> toHeaders() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-Signal-ZK-Auth", (Object)Base64.encodeWithPadding$default((byte[])this.presentation, (int)0, (int)0, (int)6, null)), TuplesKt.to((Object)"X-Signal-ZK-Auth-Signature", (Object)Base64.encodeWithPadding$default((byte[])this.signedPresentation, (int)0, (int)0, (int)6, null))};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }
}

