/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.receipts;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.internal.ByteArray;
import org.signal.libsignal.zkgroup.receipts.ReceiptSerial;

public final class ReceiptCredentialPresentation
extends ByteArray {
    public ReceiptCredentialPresentation(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.ReceiptCredentialPresentation_CheckValidContents(contents)));
    }

    public long getReceiptExpirationTime() {
        return Native.ReceiptCredentialPresentation_GetReceiptExpirationTime(this.contents);
    }

    public long getReceiptLevel() {
        return Native.ReceiptCredentialPresentation_GetReceiptLevel(this.contents);
    }

    public ReceiptSerial getReceiptSerial() {
        byte[] newContents = Native.ReceiptCredentialPresentation_GetReceiptSerial(this.contents);
        try {
            return new ReceiptSerial(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

