/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.groupsend;

import java.time.Instant;
import java.util.Collection;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groupsend.GroupSendDerivedKeyPair;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class GroupSendFullToken
extends ByteArray {
    public GroupSendFullToken(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.GroupSendFullToken_CheckValidContents(contents));
    }

    public Instant getExpiration() {
        return Instant.ofEpochSecond(Native.GroupSendFullToken_GetExpiration(this.getInternalContentsForJNI()));
    }

    public void verify(Collection<ServiceId> userIds, GroupSendDerivedKeyPair keyPair) throws VerificationFailedException {
        this.verify(userIds, Instant.now(), keyPair);
    }

    public void verify(Collection<ServiceId> userIds, Instant now, GroupSendDerivedKeyPair keyPair) throws VerificationFailedException {
        FilterExceptions.filterExceptions(VerificationFailedException.class, () -> Native.GroupSendFullToken_Verify(this.getInternalContentsForJNI(), ServiceId.toConcatenatedFixedWidthBinary(userIds), now.getEpochSecond(), keyPair.getInternalContentsForJNI()));
    }
}

